;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Inline/simple.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jan 10 19:34:08 1995                          */
;*    Last change :  Tue Feb  6 15:34:36 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The inlining of non-recursive functions.                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module inline_simple
   (include "Tools/trace.sch"
	    "Type/type.sch"
            "Ast/node.sch")
   (import  tools_shape
            tools_error
	    tools_speek
	    tools_args
            inline_inline
	    type_cache
	    ast_duplicate
            ast_dump
            ast_env
            ast_sexp
            ast_local
            ast_global
	    ast_loc)
   (export  (inline-app-simple <ast> <integer> <variable>*)))

;*---------------------------------------------------------------------*/
;*    inline-app-simple ...                                            */
;*    -------------------------------------------------------------    */
;*    The `inline-app-simple' transformation is a simple               */
;*    beta-reduction.                                                  */
;*---------------------------------------------------------------------*/
(define (inline-app-simple ast-call amount stack)
   (trace inline "inline-app-simple: " (ast->sexp ast-call) #\Newline)
   (let* ((callee  (var-variable (app-fun ast-call)))
          (fun     (variable-value callee))
          (formals (function-args fun))
          (actuals (app-actuals ast-call))
          (what/by (if (>=fx (function-arity fun) 0)
		       (make-fx-what/by-list ast-call callee formals actuals)
		       (make-va-what/by-list ast-call callee formals actuals)))
          (body    (function-body fun)))
      (if (not (and (boolean? (function-inline? fun))
		    (function-inline? fun)))
	  (verbose 2 "        "
		   (shape callee) " --> " (current-function)
		   " (simple)"
		   #\Newline))
      (variable-occurrence-set! callee (-fx (variable-occurrence callee) 1))
      (if (not (pair? what/by))
          what/by
          (let* ((new-body   (duplicate-ast (car what/by) body))
                 (new-2-body (inline-ast new-body amount stack)))
	     (if (or (and (global? callee)
			  (eq? (global-import callee) 'import))
		     (not (loc? (ast-location new-2-body))))
		 (ast-set-loc! (ast-location ast-call) new-2-body))
	     (trace (loop inline) "body: " (ast->sexp body) #\Newline)
             (trace (loop inline) "new-body: " (ast->sexp new-body) #\Newline)
             (trace (loop inline) "new-2-body: " (ast->sexp new-2-body)
                    #\Newline)
	     (if (null? (cdr what/by))
		 new-2-body
		 (ast-let-var (ast-location ast-call)
			      #f
			      #f
			      (cdr what/by)
			      new-2-body
			      #t))))))

;*---------------------------------------------------------------------*/
;*    make-fx-what/by-list ...                                         */
;*---------------------------------------------------------------------*/
(define (make-fx-what/by-list ast-call callee formals actuals)
   (let loop ((formals  formals)
              (actuals  actuals)
              (what.by '())
              (bindings '()))
      (cond
         ((null? formals)
          (if (null? actuals)
	      ;; in order to be left->right evaluated we are
	      ;; oblige to reverse the bindings order.
              (cons what.by (reverse! bindings))
	      (internal-error "make-fx-what/by-list"
			      "Illegal number of arguments"
			      (shape ast-call))))
         ((null? actuals)
	  (internal-error "make-fx-what/by-list"
			  "Illegal number of arguments"
			  (shape ast-call)))
         (else
          (let ((formal (car formals))
                (actual (car actuals)))
	     (if (need-a-variable? (car formals) (car actuals))
		 (let ((aux (make-local-variable (local-name formal)
						 *obj*)))
		    (local-access-set! aux (local-access formal))
		    (local-type-set! aux (local-type formal))
		    (loop (cdr formals)
			  (cdr actuals)
			  (cons `(,formal . ,aux) what.by)
			  (cons `(,aux . ,actual) bindings)))
		 (loop (cdr formals)
		       (cdr actuals)
		       (cons `(,(car formals) . ,(car actuals)) what.by)
		       bindings)))))))

;*---------------------------------------------------------------------*/
;*    make-va-what/by-list ...                                         */
;*---------------------------------------------------------------------*/
(define (make-va-what/by-list ast-call callee formals actuals)
   (define (make-args-list actuals)
      (let ((loc (ast-location ast-call))
	    (cons (find-global 'c-cons)))
	 (global-occurrence-set! cons (+fx 1 (global-occurrence cons)))
	 (let loop ((actuals actuals))
	    (if (null? actuals)
		(ast-atom loc #f #f '())
		(ast-app loc
			 #f
			 #f
			 (ast-var loc
				  #f
				  #f
				  cons)
			 (list (car actuals)
			       (make-args-list (cdr actuals)))
			 #f
			 #f
			 #f
			 #f)))))
   (let loop ((formals  formals)
              (actuals  actuals)
              (what.by '())
              (bindings '()))
      (cond
         ((null? (cdr formals))
	  (let ((aux (make-local-variable (local-name (car formals))
					  *obj*)))
	     (local-access-set! aux (local-access (car formals)))
	     (cons (cons `(,(car formals) . ,aux) what.by)
		   (reverse! (cons `(,aux . ,(make-args-list actuals))
				   bindings)))))
         ((null? actuals)
	  (internal-error "make-va-what/by-list"
			  "Illegal number of arguments"
			  (shape ast-call)))
         (else
          (let ((formal (car formals))
                (actual (car actuals)))
	     (if (need-a-variable? (car formals) (car actuals))
		 (let ((aux (make-local-variable (local-name formal)
						 *obj*)))
		    (local-access-set! aux (local-access formal))
		    (local-type-set! aux (local-type formal))
		    (loop (cdr formals)
			  (cdr actuals)
			  (cons `(,formal . ,aux) what.by)
			  (cons `(,aux . ,actual) bindings)))
		 (loop (cdr formals)
		       (cdr actuals)
		       (cons `(,(car formals) . ,(car actuals)) what.by)
		       bindings)))))))

;*---------------------------------------------------------------------*/
;*    need-a-variable? ...                                             */
;*---------------------------------------------------------------------*/
(define (need-a-variable? var ast)
   (or (eq? (local-access var) 'write)
       (and (type? (local-type var))
	    (not (eq? (local-type var) *obj*)))
       (ast-case ast
	  ((var)
	   (not (eq? (variable-access (var-variable ast)) 'read)))
	  ((fun)
	   (internal-error "do-set-recursive-call!"
			   "Illegal node (see `Bivaluation' pass)"
			   (ast->sexp ast)))
	  ((atom)
	   #f)
	  ((prag-ma)
	   #f)
	  (else
	   #t))))

                               
      
   
