;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Inline/loop.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jan 10 19:33:00 1995                          */
;*    Last change :  Wed Oct 11 11:34:50 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The loop inlining                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module inline_loop
   (include "Ast/node.sch"
            "Tools/trace.sch")
   (import  tools_shape
	    ast_dump)
   (export  (recursion? <variable> <ast>)
	    (is-loop?   <variable>)))

;*---------------------------------------------------------------------*/
;*    recursion? ...                                                   */
;*    -------------------------------------------------------------    */
;*    Is an expression a recursion ?                                   */
;*---------------------------------------------------------------------*/
(define (recursion? var ast)
   (ast-case ast
      ((app)
       (let ((callee (app-fun ast)))
	  (ast-case callee
	     ((var)
	      (eq? (var-variable callee) var))
	     (else
	      #f))))
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    is-loop? ...                                                     */
;*    -------------------------------------------------------------    */
;*    This function returns true if the function is recursive.         */
;*---------------------------------------------------------------------*/
(define (is-loop? var)
   (let loop ((ast (function-body (variable-value var))))
      (ast-case ast
         ((atom)
          #f)
         ((var)
          #f)
         ((kwote)
          #f)
	 ((make-box)
	  (loop (make-box-value ast)))
	 ((box-ref)
	  #f)
	 ((box-set!)
	  (loop (box-set!-value ast)))
         ((sequence)
          (let liip ((asts (sequence-exp ast)))
             (cond
                ((null? asts)
                 #f)
                ((loop (car asts))
                 #t)
                (else
                 (liip (cdr asts))))))
         ((setq)
          (loop (setq-val ast)))
         ((conditional)
          (or (loop (conditional-test ast))
              (loop (conditional-then ast))
              (loop (conditional-else ast))))
         ((fail)
          (or (loop (fail-proc ast))
              (loop (fail-msg ast))
              (loop (fail-obj ast))))
         ((let-fun)
          (or (loop (let-fun-body ast))
              (let liip ((locals (let-fun-locals ast)))
                 (cond
                    ((null? locals)
                     #f)
                    ((loop (function-body (local-value (car locals))))
                     #t)
                    (else
                     (liip (cdr locals)))))))
         ((let-var)
          (or (loop (let-var-body ast))
              (let liip ((bdgs (let-var-bindings ast)))
                 (cond
                    ((null? bdgs)
                     #f)
                    ((loop (cdr (car bdgs)))
                     #t)
                    (else
                     (liip (cdr bdgs)))))))
         ((app-ly)
          (or (loop (app-ly-fun ast))
              (loop (app-ly-value ast))))
         ((app)
	  (recursion? var ast))
	 ((funcall)
	  (or (loop (funcall-fun ast))
	      (let liip ((actuals (funcall-actuals ast)))
		 (cond
		    ((null? actuals)
		     #f)
		    ((loop (car actuals))
		     #t)
		    (else
		     (liip (cdr actuals)))))))
	 ((fun)
	  (internal-error "do-set-recursive-call!"
			  "Illegal node (see `Bivaluation' pass)"
			  (ast->sexp ast)))
         ((set-ex-it)
          (loop (set-ex-it-body ast)))
	 ((jump-ex-it)
	  (or (loop (jump-ex-it-exit ast))
	      (loop (jump-ex-it-value ast))))
         ((switch)
          (or (loop (switch-test ast))
              (let liip ((clauses (switch-clauses ast)))
                 (cond
                    ((null? clauses)
                     #f)
                    ((loop (cdr (car clauses)))
                     #t)
                    (else
                     (liip (cdr clauses)))))))
      ((prag-ma)
       (let liip ((values (prag-ma-values ast)))
	  (cond
	     ((null? values)
	      #f)
	     ((loop (car values))
	      #t)
	     (else
	      (liip (cdr values)))))))))
