;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../prgm/project/bigloo/comptime1.8/Globalize/kapture.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jan 30 07:30:09 1995                          */
;*    Last change :  Fri Mar 22 15:47:04 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `kaptured' computation                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_kapture
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Globalize/globalize.sch")
   (import  tools_shape
	    tools_speek
	    globalize_ast
	    globalize_free
	    globalize_clocto
	    tools_args
	    type_cache
	    ast_sexp
	    ast_dump
	    ast_global
	    ast_local)
   (export  (set-kaptured! <local>*)
	    (union sets)))

;*---------------------------------------------------------------------*/
;*    set-kaptured! ...                                                */
;*---------------------------------------------------------------------*/
(define (set-kaptured! local*)
   ;; first we compute the transitive closure of the `cto' property
   ;; (i.e. we add to local the cto fields of its including local functions).
   (for-each (lambda (local)
		(cto-transitive-closure! local))
	     local*)
   ;; then we compute the kaptured property.
   (for-each (lambda (local)
		(set-one-kaptured! local local))
	     local*))

;*---------------------------------------------------------------------*/
;*    set-one-kaptured! ...                                            */
;*    -------------------------------------------------------------    */
;*    This function computes the set of kaptured variables and         */
;*    the future globalized body.                                      */
;*---------------------------------------------------------------------*/
(define (set-one-kaptured! local locking)
   (trace (globalize loop) "set-one-kaptured: " (shape local) " [locking:"
	  (shape locking) #\]
	  #\Newline)
   (let* ((info     (local-info local))
	  (kaptured (fun-Ginfo-kaptured info)))
      (cond
	 ((or (pair? kaptured) (null? kaptured))
	  (trace (globalize loop) "--> (or pair? null?) [" (shape local)
		 "] " (shape kaptured) #\Newline)
	  (vector #t locking kaptured))
	 ((local? kaptured)
	  (trace (globalize loop) "--> local? [" (shape local)
		 "] " (shape kaptured) #\Newline)
	  (vector #f locking '()))
	 (else
	  (trace (globalize loop) "--> cto* [" (shape local) "] "
		 (shape (fun-Ginfo-cto* info)) #\Newline)
	  (let ((new-body (fun-Ginfo-new-body info)))
	     ;; before entering the recursion we mark this function
	     (fun-Ginfo-kaptured-set! info local)
	     ;; we walk across the call-graph
	     (let loop ((kaptured '())
			(cto      (append (fun-Ginfo-cto* info)
					  (fun-Ginfo-cfunction info)))
			(setter?  #t))
		(trace (globalize loop)
		       "loop( " (shape local) " ) : " #\Newline
		       "      "  (shape kaptured) #\Newline
		       "      "  (shape cto) #\Newline
		       "      "  setter? #\Newline)
		(cond
		   ((null? cto)
		    (let* ((free      (get-free-vars new-body local))
			   (fkaptured (free-from kaptured local))
			   (kaptured  (union (cons free fkaptured))))
		       (trace globalize
			      "   kaptured(" (local-shape local) ") : "
			      (shape kaptured) #\Newline)
		       (trace (loop globalize)
			      "       free(" (local-shape local) ") : "
			      (shape free) #\Newline)
		       (if setter?
			   (begin
			      ;; we store kaptured variables
			      (fun-Ginfo-kaptured-set! info kaptured)
			      ;; we mark that kaptured variable are
			      (for-each (lambda (local)
					   (var-Ginfo-kaptured?-set!
					    (local-info local) #t))
					kaptured))
			   (fun-Ginfo-kaptured-set! info #f))
		       (vector setter? locking kaptured)))
		   ((eq? (car cto) local)
		    (trace (globalize loop) "  (eq? (car cto) local)"
			   #\Newline)
		    (loop kaptured
			  (cdr cto)
			  setter?))
		   ((fun-Ginfo-G? (local-info (car cto)))
		    (trace (globalize loop) "  (fun-Ginfo-G? (car cto))"
			   #\Newline)
		    (let ((other-kaptured (set-one-kaptured! (car cto)
							     locking)))
		       (if (not (vector-ref other-kaptured 0))
			   (loop (cons (vector-ref other-kaptured 2) kaptured)
				 (cdr cto)
				 (and setter?
				      (eq? (vector-ref other-kaptured 1)
					   local)))
			   (loop (cons (vector-ref other-kaptured 2) kaptured)
				 (cdr cto)
				 setter?))))
		   (else
		    (trace (globalize loop) "  not globalized (car cto)"
			   #\Newline)
		    (loop kaptured
			  (cdr cto)
			  setter?)))))))))

;*---------------------------------------------------------------------*/
;*    *union-round* ...                                                */
;*---------------------------------------------------------------------*/
(define *union-round* 0)

;*---------------------------------------------------------------------*/
;*    union ...                                                        */
;*---------------------------------------------------------------------*/
(define (union sets)
   (set! *union-round* (+fx 1 *union-round*))
   (let loop ((sets  sets)
	      (union '()))
      (if (null? sets)
	  union
	  (let liip ((set   (car sets))
		     (union union))
	     (cond
		((null? set)
		 (loop (cdr sets)
		       union))
		((function? (local-value (car set)))
		 (if (eq? (fun-Ginfo-umark (local-info (car set)))
			  *union-round*)
		     (liip (cdr set) union)
		     (begin
			(fun-Ginfo-umark-set! (local-info (car set))
					      *union-round*)
			(liip (cdr set)
			      (cons (car set) union)))))
		((eq? (var-Ginfo-mark (local-info (car set))) *union-round*)
		 (liip (cdr set) union))
		(else
		 (var-Ginfo-mark-set! (local-info (car set)) *union-round*)
		 (liip (cdr set)
		       (cons (car set) union))))))))
		 

	  
