;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Globalize/clocto.scm     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jan 23 14:03:24 1996                          */
;*    Last change :  Tue Jan 23 14:25:07 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The transitive closure of the `cto' property.                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_clocto
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Globalize/globalize.sch")
   (import  tools_shape
	    ast_dump
	    globalize_kapture)
   (export (cto-transitive-closure! <local>)))

;*---------------------------------------------------------------------*/
;*    cto-transitive-closure ...                                       */
;*---------------------------------------------------------------------*/
(define (cto-transitive-closure! host)
   [assert (host) (local? host)]
   (let* ((info      (local-info host))
	  (cto       (fun-Ginfo-cto info))
	  (cto*-orig (list cto)))
      (let loop ((cto  cto)
		 (cto* cto*-orig))
	 (cond
	    ((null? cto)
	     (fun-Ginfo-cto*-set! info
				  (if (eq? cto* cto*-orig)
				      (car cto*-orig)
				      (union cto*))))
	    ((eq? (car cto) local)
	     (loop (cdr cto) cto*))
	    ((fun-Ginfo-G? (local-info (car cto)))
	     (loop (cdr cto) cto*))
	    (else
	     (loop (cdr cto)
		   (cons (fun-Ginfo-cto (local-info (car cto)))
			 cto*)))))))
	     
	     
