;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Globalize/ast.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 27 14:12:58 1995                          */
;*    Last change :  Tue Apr  9 15:56:31 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We transforme the ast in order to fix the free variables, to     */
;*    remove the useless local functions (globalized or integrated     */
;*    ones) and to remove `fun' constructions.                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_ast
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Globalize/globalize.sch")
   (import  tools_shape
	    ast_sexp
	    ast_env
	    ast_global
	    ast_local
	    ast_dump
	    type_cache
	    globalize_free
	    globalize_local->global
	    globalize_cache)
   (export  (ast-globalize! <ast> <variable> <variablexvariable>*)))

;*---------------------------------------------------------------------*/
;*    ast-globalize! ...                                               */
;*    -------------------------------------------------------------    */
;*    This function makes many transformation on the Ast *and*         */
;*    returns a free variables list.                                   */
;*---------------------------------------------------------------------*/
(define (ast-globalize! ast integrator what/by*)
   ;; for each celled variable, we declare a new local
   ;; variable
   (let* ((fun      (variable-value integrator))
	  (celled   (celled-bindings (function-args fun)))
	  (what/by* (append celled what/by*)))
      ;; we set alpha-fast slot 
      (for-each (lambda (w.b)
		   (variable-fast-alpha-set! (car w.b) (cdr w.b)))
		what/by*)
      (let ((res (cell-formals celled (do-ast-globalize! ast integrator))))
	 ;; we remove alpha-fast slots
	 (for-each (lambda (w.b)
		      (variable-fast-alpha-set! (car w.b) #f))
		   what/by*)
	 res)))

;*---------------------------------------------------------------------*/
;*    celled-bindings ...                                              */
;*---------------------------------------------------------------------*/
(define (celled-bindings formals)
   (let loop ((celled   '())
	      (formals  formals))
      (cond
	 ((null? formals)
	  celled)
	 ((not (celled? (car formals)))
	  (loop celled (cdr formals)))
	 (else
	  (let* ((var (make-local-variable (local-name (car formals)) *obj*))
		 (o.n (cons (car formals) var)))
	     (local-access-set! var 'celled-globalize)
	     (local-info-set!   var (default-var-Ginfo))
	     (var-Ginfo-kaptured?-set! (local-info var) #t)
	     (loop (cons o.n celled)
		   (cdr formals)))))))

;*---------------------------------------------------------------------*/
;*    cell-formals ...                                                 */
;*---------------------------------------------------------------------*/
(define (cell-formals celled body)
   (if (null? celled)
       body
       (let ((loc (ast-location body)))
	  (ast-let-var #f
		       #f
		       #f
		       (map (lambda (o.n)
			       (cons (cdr o.n)
				     (a-make-cell (ast-var loc
							   #f
							   #f
							   (car o.n))
						  (car o.n))))
			    celled)
		       body
		       #t))))

;*---------------------------------------------------------------------*/
;*    mark-celled-formals! ...                                         */
;*---------------------------------------------------------------------*/
(define (mark-cell-formals! variable)
   (for-each (lambda (arg)
		(if (celled? arg)
		    (local-access-set! arg 'celled-globalize)))
	     (function-args (variable-value variable))))

;*---------------------------------------------------------------------*/
;*    a-make-cell ...                                                  */
;*---------------------------------------------------------------------*/
(define (a-make-cell ast var)
   (let ((loc (ast-location ast)))
      (local-access-set! var 'celled-globalize)
      (ast-make-box loc #f #f ast)))

;*---------------------------------------------------------------------*/
;*    celled? ...                                                      */
;*---------------------------------------------------------------------*/
(define (celled? var)
   (if (and (local? var)
	    (var-Ginfo-kaptured? (local-info var)))
       (cond
	  ((eq? (local-access var) 'celled-globalize)
	   #t)
	  ((eq? (local-access var) 'write)
	   (local-access-set! var 'celled-globalize))
	  (else
	   #f))
       #f))

;*---------------------------------------------------------------------*/
;*    do-ast-globalize! ...                                            */
;*---------------------------------------------------------------------*/
(define (do-ast-globalize! ast integrator)
   (let loop ((ast ast))
      (trace (loop globalize) "do-ast-globalize!" (shape integrator) ": "
	     (ast->sexp ast) #\Newline)
      (ast-case ast
	 ((atom)
	  ast)
	 ((kwote)
	  ast)
	 ((var)
	  (let* ((var   (var-variable ast))
		 (alpha (variable-fast-alpha var)))
	     (if (local? alpha)
		 (begin
		    (var-variable-set! ast alpha)
		    (loop ast))
		 (cond
		    ((celled? var)
		     (ast-box-ref (ast-location ast)
				  #f
				  #f
				  ast))
		    (else
		     ast)))))
	 ((make-box)
	  (make-box-value-set! ast (loop (make-box-value ast)))
	  ast)
	 ((box-ref)
	  (box-ref-var-set! ast (loop (box-ref-var ast)))
	  ast)
	 ((box-set!)
	  (box-set!-var-set! ast (loop (box-set!-var ast)))
	  (box-set!-value-set! ast (loop (box-set!-value ast)))
	  ast)
	 ((fun)
	  (let ((var (var-variable (fun-value ast)))
		(loc (ast-location ast)))
	     (loop (ast-var loc #f #f (the-closure var loc)))))
	 ((prag-ma)
	  (let liip ((values (prag-ma-values ast)))
	     (if (null? values)
		 ast
		 (begin
		    (set-car! values (loop (car values)))
		    (liip (cdr values))))))
	 ((fail)
	  (fail-proc-set! ast (loop (fail-proc ast)))
	  (fail-msg-set! ast (loop (fail-msg ast)))
	  (fail-obj-set! ast (loop (fail-obj ast)))
	  ast)
	 ((sequence)
	  (let liip ((sexp (sequence-exp ast)))
	     (if (null? sexp)
		 ast
		 (begin
		    (set-car! sexp (loop (car sexp)))
		    (liip (cdr sexp))))))
	 ((conditional)
	  (conditional-test-set! ast (loop (conditional-test ast)))
	  (conditional-then-set! ast (loop (conditional-then ast)))
	  (conditional-else-set! ast (loop (conditional-else ast)))
	  ast)
	 ((setq)
	  [assert check (ast) (not (make-box? (setq-val ast)))]
	  (setq-val-set! ast (loop (setq-val ast)))
	  (let ((var (var-variable (setq-var ast))))
	     (let loop ((var   var)
			(alpha (variable-fast-alpha var)))
		(if (local? alpha)
		    (begin
		       (var-variable-set! (setq-var ast) alpha)
		       (loop alpha (variable-fast-alpha alpha)))
		    (let ((var (var-variable (setq-var ast))))
		       (if (celled? var)
;* 			   (ast-box-set! (ast-location ast)            */
;* 					 #f                            */
;* 					 #f                            */
;* 					 (setq-var ast)                */
;* 					 (setq-val ast))               */
			   (let ((a-var (make-local-variable (gensym 'a-cell)
							     (local-type var)))
				 (loc   (ast-location ast)))
			      (ast-let-var (ast-location ast)
					   #f
					   #f
					   (list (cons a-var (setq-val ast)))
					   (ast-box-set! loc
							 #f
							 #f
							 (setq-var ast)
							 (ast-var loc
								  #f
								  #f
								  a-var))
					   #t))
			   ast))))))
	 ((let-var)
	  (for-each (lambda (binding)
		       (let ((var (car binding))
			     (val (cdr binding)))
			  (set-cdr! binding (loop val))
			  (if (celled? var)
			      (begin
				 (local-type-set! var *obj*)
				 (set-cdr! binding
					   (a-make-cell (cdr binding) var))))))
		    (let-var-bindings ast))
	  (let-var-body-set! ast (loop (let-var-body ast)))
	  ast)
	 ((let-fun)
	  (let-fun-body-set! ast (loop (let-fun-body ast)))
	  (let liip ((obindings (let-fun-locals ast))
		     (nbindings '())
		     (ebindings '()))
	     (cond
		((null? obindings)
		 (let-fun-locals-set! ast nbindings)
		 (if (null? ebindings)
		     ast
		     (make-escaping-bindings ebindings ast integrator)))
		((and (not (eq? (car obindings) integrator))
		      (function-escape? (local-value (car obindings))))
		 (liip (cdr obindings)
		       nbindings
		       (cons (car obindings) ebindings)))
		(else
		 (let ((local (car obindings)))
		    (globalize-local-fun! local integrator)
		    (liip (cdr obindings)
			  (cons local nbindings)
			  ebindings))))))
	 ((set-ex-it)
	  (let* ((exit (var-variable (set-ex-it-exit ast)))
		 (hdlg (return-handler (local-value exit))))
	     (if (fun-Ginfo-G? (local-info hdlg))
		 (return-detached-set! (local-value exit) #t)))
	  (set-ex-it-exit-set! ast (loop (set-ex-it-exit ast)))
	  (set-ex-it-body-set! ast (loop (set-ex-it-body ast)))
	  ast)
	 ((jump-ex-it)
	  (jump-ex-it-exit-set! ast (loop (jump-ex-it-exit ast)))
	  (jump-ex-it-value-set! ast (loop (jump-ex-it-value ast)))
	  ast)
	 ((funcall)
	  (funcall-fun-set! ast (loop (funcall-fun ast)))
	  (let liip ((asts (funcall-actuals ast)))
	     (if (null? asts)
		 ast
		 (begin
		    (set-car! asts (loop (car asts)))
		    (liip (cdr asts))))))
	 ((app-ly)
	  (app-ly-fun-set! ast (loop (app-ly-fun ast)))
	  (app-ly-value-set! ast (loop (app-ly-value ast)))
	  ast)
	 ((app)
	  (let* ((fun  (var-variable (app-fun ast)))
		 (info (variable-info fun))
		 (loc  (ast-location ast)))
	     ;; we change the called function if globalized. We have
	     ;; to take care that for a call to a local globalized
	     ;; function there are two cases. First, the function
	     ;; is escaping, then we still calls the local entry
	     ;; point (which is integrated in the global function).
	     ;; Second, the function is not escaping then we have
	     ;; to translate a recursive call to a call to the
	     ;; globalized function.
	     (if (and (local? fun)
		      (or (not (eq? fun integrator))
			  (not (function-escape? (local-value fun))))
		      (fun-Ginfo-G? (local-info fun)))
		 (app-fun-set! ast (ast-var (ast-location (app-fun ast))
					    #f
					    #f
					    (the-global fun))))
	     ;; we globalize the actuals before adding new one
	     ;; otherwise, we could produce illegal `cell-ref'
	     (let liip ((asts (app-actuals ast)))
		(if (null? asts)
		    'done
		    (begin
		       (set-car! asts (loop (car asts)))
		       (liip (cdr asts)))))
	     (cond
		((or (global? fun)
		     (not (fun-Ginfo-G? info))
		     (and (eq? fun integrator)
			  (function-escape? (local-value fun))))
		 'done)
		((function-escape? (local-value fun))
		 ;; this is a direct call to an escaping call,
		 ;; we add its environement if it is a local function ...
		 (app-actuals-set! ast
				   (cons (loop (ast-var loc
							#f
							#f
							(the-closure fun loc)))
					 (app-actuals ast))))
		(else
		 ;; this is a call to globalized but non escaping
		 ;; function. We add its kaptured variables
		 (let loop ((new-actuals (app-actuals ast))
			    (kaptured    (fun-Ginfo-kaptured info)))
		    (if (null? kaptured)
			(app-actuals-set! ast new-actuals)
			(let* ((kap   (car kaptured))
			       (alpha (local-fast-alpha kap))
			       (var (if (local? alpha) alpha kap)))
			   (loop (cons (ast-var loc #f #f var)
				       new-actuals)
				 (cdr kaptured)))))))
	     ast))
	 ((switch)
	  (switch-test-set! ast (loop (switch-test ast)))
	  (for-each (lambda (clause)
		       (set-cdr! clause (loop (cdr clause))))
		    (switch-clauses ast))
	  ast))))

;*---------------------------------------------------------------------*/
;*    make-escaping-bindings ...                                       */
;*---------------------------------------------------------------------*/
(define (make-escaping-bindings ebindings ast integrator)
   (trace (globalize loop)
	  "make-escaping-bindings: " (ast->sexp ast)
	  #\Newline
	  "             ebindings: " (shape ebindings)
	  #\Newline)
   (let loop ((ebindings ebindings)
	      (bindings  '())
	      (sets      '()))
      (if (null? ebindings)
	  (ast-let-var (ast-location ast)
		       #f
		       #f
		       bindings
		       (if (null? sets)
			   ast
			   (ast-sequence loc
					 #f
					 #f
					 (append sets (list ast))))
		       #t)
	  (let* ((local (car ebindings))
		 (new   (the-closure local (ast-location ast)))
		 (nsets (make-sets new
				   (ast-location ast)
				   (fun-Ginfo-kaptured (local-info local))
				   integrator)))
	     (loop (cdr ebindings)
		   (cons (cons new (a-make-procedure local))
			 bindings)
		   (if (null? nsets)
		       sets
		       (cons nsets sets)))))))

;*---------------------------------------------------------------------*/
;*    globalize-local-fun! ...                                         */
;*---------------------------------------------------------------------*/
(define (globalize-local-fun! local integrator)
   (let* ((fun   (local-value local))
	  (obody (function-body fun)))
      (mark-cell-formals! local)
      (if (eq? local integrator)
	  (function-body-set! fun (do-ast-globalize! obody integrator))
	  (let ((celled (celled-bindings (function-args fun))))
	     (for-each (lambda (w.b)
			  (variable-fast-alpha-set! (car w.b) (cdr w.b)))
		       celled)
	     (let* ((nbody1 (do-ast-globalize! obody integrator))
		    (nbody2 (cell-formals celled nbody1)))
		(for-each (lambda (w.b)
			     (variable-fast-alpha-set! (car w.b) #f))
			  celled)
		(function-body-set! fun nbody2))))))

;*---------------------------------------------------------------------*/
;*    a-make-procedure ...                                             */
;*---------------------------------------------------------------------*/
(define (a-make-procedure local)
   (let* ((fun      (local-value local))
	  (arity    (function-arity fun))
	  (kaptured (fun-Ginfo-kaptured (local-info local)))
	  (loc      (ast-location (function-body fun)))
	  (make-p   (if (>=fx arity 0)
			*make-fx-procedure*
			*make-va-procedure*)))
      (function-kaptured-set! fun kaptured)
      (global-occurrence-set! make-p (+fx 1 (global-occurrence make-p)))
      (ast-app loc
	       #f
	       #f
	       (ast-var loc
			#f
			#f
			make-p)
	       (list (ast-var loc #f #f (the-global local))
		     (ast-atom loc #f #f arity)
		     (ast-atom loc #f #f (length kaptured)))
	       #f
	       #f
	       #f
	       #f)))

;*---------------------------------------------------------------------*/
;*    make-sets ...                                                    */
;*---------------------------------------------------------------------*/
(define (make-sets new loc kaptured integrator)
   (if (null? kaptured)
       '()
       (ast-sequence loc
		     #f
		     #f
		     (let loop ((kaptured kaptured)
				(indice   0)
				(sets     '()))
			(if (null? kaptured)
			    (reverse! sets)
			    (loop (cdr kaptured)
				  (+fx indice 1)
				  (cons (a-procedure-set! loc
							  new
							  indice
							  (car kaptured)
							  integrator)
					sets)))))))

;*---------------------------------------------------------------------*/
;*    a-procedure-set! ...                                             */
;*---------------------------------------------------------------------*/
(define (a-procedure-set! loc new indice kaptured integrator)
   (define (alpha-convert var)
      (let ((alpha (variable-fast-alpha var)))
	 (if (local? alpha)
	     (alpha-convert alpha)
	     var)))
   (global-occurrence-set! *procedure-set!*
			   (+fx 1 (global-occurrence *procedure-set!*)))
   (ast-app loc
	    #f
	    #f
	    (ast-var loc #f #f *procedure-set!*)
	    (list (ast-var loc #f #f new)
		  (ast-atom loc #f #f indice)
		  (let ((var (alpha-convert kaptured)))
		     (ast-var loc #f #f var)))
	    #f
	    #f
	    #f
	    #f))
				       
							       
						       
							     
			    
