;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Expand/expander.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 28 16:05:29 1994                          */
;*    Last change :  Wed May 17 09:11:03 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The O-expander creation.                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module expand_expander
   (include "Expand/expander.sch")
   (import  tools_error)
   (export  (initialize-Oenv!)
	    (install-O-comptime-expander <symbol> <procedure>)
	    (find-O-expander             <symbol>)
	    (unbind-O-expander!          <symbol>)))

;*---------------------------------------------------------------------*/
;*    *Oenv* ...                                                       */
;*---------------------------------------------------------------------*/
(define *Oenv* '())

;*---------------------------------------------------------------------*/
;*    initialize-Oenv! ...                                             */
;*---------------------------------------------------------------------*/
(define (initialize-Oenv!)
   (set! *Oenv* (make-hash-table 4096
				 (lambda (o)
				    (string->0..2^x-1 (symbol->string o)
						      12))
				 expander-name
				 eq?
				 1024)))

;*---------------------------------------------------------------------*/
;*    install-O-comptime-expander ...                                  */
;*    -------------------------------------------------------------    */
;*    Les O-expanders sont des expanseurs d'optimisation. La difference*/
;*    avec les expanseurs normaux est que si une fonction portent le   */
;*    meme nom qu'eux, il sont retires de l'environment.               */
;*---------------------------------------------------------------------*/
(define (install-O-comptime-expander keyword function)
   (assert check (keyword function) (and (symbol? keyword)
					 (procedure? function)))
   (if (expander? (find-O-expander keyword))
       (internal-error "install-O-comptime-expander"
		       "Illegal re-installation of O-expander"
		       keyword)
       (let ((new (expander keyword function)))
	  (put-hash! new *Oenv*)
	  new)))

;*---------------------------------------------------------------------*/
;*    find-O-expander ...                                              */
;*---------------------------------------------------------------------*/
(define (find-O-expander symbol)
   (get-hash symbol *Oenv*))

;*---------------------------------------------------------------------*/
;*    unbind-O-expander! ...                                           */
;*---------------------------------------------------------------------*/
(define (unbind-O-expander! symbol)
   (rem-key-hash! symbol *Oenv*))
