;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Engine/compiler.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 26 09:39:20 1994                          */
;*    Last change :  Tue Feb  6 18:02:46 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The compiler driver                                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module engine_compiler
   (export  (compiler))
   (import  tools_speek
	    init_signals
	    expand_install
	    expand_eps
	    engine_param
	    engine_engine
	    main
	    read_src
	    parse_src
	    type_env
	    type_cache
	    tvector_install
	    tstruct_install
	    write_expanded
	    write_ast
	    user_user
	    cforeign_install
	    heap_make
	    ast_walk
	    callcc_walk
	    trace_walk
	    bivalue_walk
            inline_walk
	    fail_walk
	    coerce_walk
	    reduce_walk
	    globalize_walk
	    lifext_walk
	    cfa_walk
	    effect_walk
	    cnst_walk
	    integrate_walk
	    cgen_walk
	    cc_indent
	    cc_cc
	    cc_ld))

;*---------------------------------------------------------------------*/
;*    stop-on-pass ...                                                 */
;*---------------------------------------------------------------------*/
(define (stop-on-pass pass thunk)
   (if (eq? *pass* pass)
       (begin
	  (thunk)
	  (exit-bigloo 0))))

;*---------------------------------------------------------------------*/
;*    compiler ...                                                     */
;*---------------------------------------------------------------------*/
(define (compiler)
   ;; we catch signals
   (init-compiler-signals!)
   ;; we read and parse the source file
   (let ((code (parse-src (read-src))))
      ;; we check if all types are defined
      (check-types)
      ;; we initialize type cache
      (make-type-cache!)
      ;; we check now if we have parsed all argument
      (if (not (null? *rest-args*))
	  (warning "Don't know what to do with arguments: " *rest-args*))
      ;; we perfom user pass
      (set! code (user-walk code))
      (stop-on-pass 'user (lambda ()
			     (if (not (string? *dest*))
				 (set! *dest* (string-append
					       (prefix *src*)
					       ".user")))
			     (write-expanded code)))
      ;; we install macros ...
      (install-initial-expander)
      ;; ... and we macro expand
      (set! code (expand-code code))
      (stop-on-pass 'expand (lambda () (write-expanded code)))
      ;; we install all tvector accessors and coercers
      (set! code (append (install-tvector-accessors-and-coercers!) code))
      ;; we install all tstruct accessors and coercers
      (set! code (append (install-tstruct-accessors-and-coercers!) code))
      ;; we install all C foreign accessors and coercers
      (set! code (append (install-c-foreign-accessors!) code))
      ;; ok, every thing is ok.
      ;; we build the `abstract syntax tree'
      (let ((tree (ast-walk code)))
	 (stop-on-pass 'ast (lambda () (write-ast tree)))
	 ;; we save heap
	 (stop-on-pass 'make-heap (lambda () (make-heap)))
	 ;; when the compiler is invoked in -g3 mode, we install
	 ;; traces before the inlining
	 (if (and (integer? *compiler-debug*) (>fx *compiler-debug* 2))
	     (set! tree (trace-walk! tree)))
	 ;; when we are compiling with call/cc we have to
	 ;; put all written local variables in cells
	 (if *call/cc?*
	     (set! tree (callcc-walk! tree)))
	 (stop-on-pass 'callcc (lambda () (write-ast tree)))
         ;; we perform the inlining pass
         (set! tree (inline-walk! tree))
         (stop-on-pass 'inline (lambda () (write-ast tree)))
	 (if (and (integer? *compiler-debug*)
		  (>fx *compiler-debug* 0)
		  (<=fx *compiler-debug* 2))
	     (set! tree (trace-walk! tree)))
	 ;; we replace `failure' invokation by `error/location' when
	 ;; invoked in debug mode
	 (if (and (integer? *compiler-debug*) (>fx *compiler-debug* 0))
	     (set! tree (fail-walk! tree)))
	 (stop-on-pass 'fail (lambda () tree))
	 ;; we perform bivaluation
	 (set! tree (bivalue-walk! tree))
	 (stop-on-pass 'bivalue (lambda () (write-ast tree)))
	 ;; the globalization stage
	 (set! tree (globalize-walk! tree))
	 (stop-on-pass 'globalize (lambda () (write-ast tree)))
	 ;; the life-time extension
	 (if *heap->stack?*
	     (begin
		(set! tree (lifext-walk! tree))
		(stop-on-pass 'lifext (lambda () (write-ast tree)))))
	 ;; the control flow analysis
	 (set! tree (cfa-walk! tree))
	 (stop-on-pass 'cfa (lambda () (write-ast tree)))
	 ;; the integration pass
	 (set! tree (integrate-walk! tree))
	 (stop-on-pass 'integrate (lambda () (write-ast tree)))
         ;; we introduce type coercion and checking
	 (set! tree (coerce-walk! tree))
	 (stop-on-pass 'coerce (lambda () (write-ast tree)))
	 ;; the effect property computation
	 (if (>=fx *optim* 2)
	     (begin
		(set! tree (effect-walk! tree))
		(stop-on-pass 'effect (lambda () (write-ast tree)))))
	 ;; the reduction optimizations
	 (if (>=fx *optim* 1)
	     (begin
		(set! tree (reduce-walk! tree))
		(stop-on-pass 'reduce (lambda () (write-ast tree)))))
	 ;; the constant computation
	 (set! tree (cnst-walk! tree))
	 (stop-on-pass 'cnst (lambda () (write-ast tree)))
	 ;; the C generation
	 (let ((c-prefix (cgen-walk tree)))
	    (stop-on-pass 'cgen (lambda () 'done))
	    (stop-on-pass 'distrib (lambda () 'done))
	    (set! tree #unspecified)
	    ;; we indent the resulting C file (if wanted)
	    (if (or (eq? *pass* 'cindent) *c-debug*)
		(indent c-prefix))
	    (stop-on-pass 'cindent (lambda () 'done))
	    ;; we invoke now the C compiler
	    (cc c-prefix (not (eq? *pass* 'cc)))
	    (stop-on-pass 'cc (lambda () 'done))
	    ;; and the linker
	    (ld c-prefix #t)
	    0))))
		       

