;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Effect/walk.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 13 10:25:23 1995                          */
;*    Last change :  Mon Jul 17 10:08:03 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The computation of the effect property.                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module effect_walk
   (include "Tools/pass.sch"
	    "Tools/trace.sch"
	    "Ast/ast.sch")
   (import  tools_shape
	    ast_env
	    ast_global
	    ast_pragma
	    engine_param
	    effect_cgraph
	    effect_fix)
   (export  (effect-walk! <global>*)
	    *effect-done?*))

;*---------------------------------------------------------------------*/
;*    *effect-done?* ...                                               */
;*---------------------------------------------------------------------*/
(define *effect-done?* #f)

;*---------------------------------------------------------------------*/
;*    effect-walk ...                                                  */
;*---------------------------------------------------------------------*/
(define (effect-walk! globals)
   (pass-prelude "Effect")
   ;; we scan all globals in order to find those who are declared
   ;; (using pragmas) as side-effect-free functions.
   (for-each-global! (lambda (global)
			(if (ast-pragma global '_no_side_effect_)
			    (let ((fun (global-value global)))
			       (cond
				  ((function? fun)
				   (function-sef?-set! fun #t))
				  ((ffunction? fun)
				   (ffunction-sef?-set! fun #t))
				  (else
				   #f))))))
   ;; ok, now, we scan the module definitions.
   (let loop ((globs globals)
	      (W       '()))
      (if (null? globs)
	  (begin
	     (iterate-to-fixpoint W)
	     (pass-postlude globals (lambda () (set! *effect-done?* #t) #t)))
	  (let ((global (car globs)))
	     (enter-function (global-shape global))
	     (get-info global)
	     (let* ((value (global-value global))
		    (W     (call-graph! (function-body value) global W)))
		(leave-function)
		(loop (cdr globs) W))))))
	     
  
