;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Coerce/apply.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 17:21:26 1995                          */
;*    Last change :  Tue Jul 11 15:08:40 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `apply' coercion                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module coerce_apply
   (include "Type/type.sch"
	    "Ast/node.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    tools_location
	    type_cache
	    engine_param
	    ast_sexp
	    ast_dump
	    ast_app
	    ast_env
	    coerce_coerce
	    coerce_convert)
   (export  (coerce-apply! <ast> <type>)))

;*---------------------------------------------------------------------*/
;*    coerce-apply! ...                                                */
;*---------------------------------------------------------------------*/
(define (coerce-apply! ast to)
   (trace type "coerce-apply!: " (ast->sexp ast) #\Newline)
   (let ((error-msg (list 'quote (ast->sexp ast))))
      ;; we coerce the arguments
      (app-ly-value-set! ast (coerce! (app-ly-value ast) *obj*))
      ;; we coerce the procedure
      (app-ly-fun-set! ast (coerce! (app-ly-fun ast) *procedure*))
      ;; we check arity
      (if *unsafe-arity*
	  (convert! ast *obj* to)
	  (let* ((aux  (gensym 'aux))
		 (val  (gensym 'val))
		 (len  (gensym 'len))
		 (loc  (ast-location ast))
		 (last (sexp->ast
			`(let ((,(symbol-append aux '::obj) #unspecified)
			       (,(symbol-append val '::obj) #unspecified))
			    ;; we are obliged to use two splitted `let'
			    ;; construction otherwise `sexp->ast' will
			    ;; introduce untyped binding for the call
			    ;; to `length'.
			    (let ((,(symbol-append len '::long) (length ,val)))
			       (if (correct-arity? ,aux ,len)
				   #unspecified
				   ,(if (and (>fx *compiler-debug* 0)
					     (loc? loc))
					`(begin
					    ((@ error/location __error)
					     ,(list 'quote (current-function))
					     "Wrong number of arguments in"
					     ,error-msg
					     ,(loc-full-fname loc)
					     ,(loc-pos loc))
					    (failure '_ '_ '_))
					`(failure
					  ,(list 'quote (current-function))
					  "Wrong number of arguments in"
					  ,error-msg)))))
				  '()
				  #f
				  loc
				  'read)))
	     (let ((aux (car (car (let-var-bindings last))))
		   (val (car (cadr (let-var-bindings last)))))
		;; we set the local variables type
		(local-type-set! aux *procedure*)
		(local-type-set! val *obj*)
		;; and the local variables value to the coerced function
		(set-cdr! (car (let-var-bindings last)) (app-ly-fun ast))
		(set-cdr! (cadr (let-var-bindings last)) (app-ly-value ast))
		;; we set the conditional slot 
		(conditional-then-set! (let-var-body (let-var-body last))
				       (convert! ast *obj* to))
		(conditional-else-set! (let-var-body (let-var-body last))
				       (coerce! (conditional-else
						  (let-var-body
						   (let-var-body last)))
						to))
		;; we set the new app-ly value
		(app-ly-value-set! ast (ast-var loc #f #f val))
		last)))))

