;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Cnst/cache.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Feb 19 10:35:59 1995                          */
;*    Last change :  Mon Mar 25 17:00:53 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    A cache to be able to recognize function call very fast.         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cnst_cache
   (import  ast_global
	    engine_param)
   (export  (start-cnst-cache!)
	    (stop-cnst-cache!)
	    *cnst-table-ref*
	    *cnst-table-set!*
	    *cons*
	    *btrue*
	    *bfalse*
	    *string->bstring*
	    *string->symbol*
	    *bool->bbool*
	    *make-fx-procedure*
	    *make-va-procedure*
	    *double->real*
	    *tvector-descr-set!*
	    *get-tvector-descr*))

;*---------------------------------------------------------------------*/
;*    The cache registers definition                                   */
;*---------------------------------------------------------------------*/
(define *cnst-table-ref*        #f)
(define *cnst-table-set!*       #f)
(define *cons*                  #f)
(define *btrue*                 #f)
(define *bfalse*                #f)
(define *string->bstring*       #f)
(define *string->symbol*        #f)
(define *bool->bbool*           #f)
(define *make-fx-procedure*     #f)
(define *make-va-procedure*     #f)
(define *double->real*          #f)
(define *tvector-descr-set!*    #f)
(define *get-tvector-descr*     #f)

;*---------------------------------------------------------------------*/
;*    start-cnst-cache! ...                                            */
;*---------------------------------------------------------------------*/
(define (start-cnst-cache!)
   (set! *cnst-table-ref*
	 (require-global 'cnst-table-ref 'foreign #f))
   (set! *cnst-table-set!*
	 (require-global 'cnst-table-set! 'foreign #f))
   (set! *cons*
	 (require-global 'c-cons #f #f))
   (set! *btrue*
	 (require-global 'btrue 'foreign #f))
   (set! *bfalse*
	 (require-global 'bfalse 'foreign #f))
   (set! *string->bstring*
	 (require-global 'string->bstring #f #f))
   (set! *string->symbol*
	 (require-global 'c-string->symbol #f #f))
   (set! *bool->bbool*
	 (require-global 'bool->bbool #f #f))
   (set! *make-fx-procedure*
	 (require-global 'make-fx-procedure #f #f))
   (set! *make-va-procedure*
	 (require-global 'make-va-procedure #f #f))
   (set! *double->real*
	 (require-global 'double->real #f #f))
   (set! *tvector-descr-set!*
	 (require-global 'tvector-descr-set! 'foreign #f))
   (set! *get-tvector-descr*
	 (require-global 'get-tvector-descriptor '__tvector #f))
   #t)


;*---------------------------------------------------------------------*/
;*    stop-cnst-cache! ...                                             */
;*---------------------------------------------------------------------*/
(define (stop-cnst-cache!)
   (set! *string->bstring*    #f)
   (set! *string->symbol*     #f)
   (set! *bool->bbool*        #f)
   (set! *make-fx-procedure*  #f)
   (set! *make-va-procedure*  #f)
   (set! *double->real*       #f)
   (set! *cons*               #f)
   (set! *btrue*              #f)
   (set! *bfalse*             #f)
   (set! *tvector-descr-set!* #f)
   (set! *get-tvector-descr*  #f)
   #t)






