;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Cgen/roots.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Aug 29 09:35:37 1995                          */
;*    Last change :  Mon Mar 25 17:00:38 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Each Scheme global variable has to be delcared as a GC roots.    */
;*    This function invokes the `GC-add-globv!' function on each       */
;*    global variable address.                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_roots
   (include "Ast/ast.sch")
   (import  engine_param
	    tools_shape
	    ast_global
	    ast_env
	    ast_sexp
	    cnst_alloc
	    cnst_cache)
   (export  (declare-gc-global-variables!)))

;*---------------------------------------------------------------------*/
;*    declare-gc-global-variables! ...                                 */
;*---------------------------------------------------------------------*/
(define (declare-gc-global-variables!)
   (let ((global (find-global 'gc-global-variables-declarations!
			      *module-name*))
	 (gcnst  (find-global (cnst-table-name) *module-name*))
	 (body   '()))
      (for-each-global!
       (lambda (g)
	  (if (and (eq? (global-class g) 'variable)
		   (eq? (global-module g) *module-name*)
		   (not (eq? g gcnst)))
	      (set! body (cons `(GC-add-globv! (var->root (@ ,(global-name g)
							    ,*module-name*)))
			       body)))))
      (function-body-set! (global-value global)
			  (sexp->ast (if (null? body)
					 #unspecified
					 `(begin ,@body #unspecified))
				     '()
				     (global-name global)
				     #f
				     'read))))
      
