;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cgen/a2c.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 16 18:16:06 1995                          */
;*    Last change :  Sat Apr  6 08:26:36 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The definition compilation                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_a2c
   (include "Type/type.sch"
	    "Tools/trace.sch"
	    "Ast/node.sch"
	    "Cgen/cgen.sch")
   (import  tools_shape
	    type_cache
	    type_tools
	    ast_global
	    ast_local
	    ast_dump
	    ast_typeof
	    effect_effect
	    engine_param
	    cgen_ident)
   (export (cgen-definition! <global>)))

;*---------------------------------------------------------------------*/
;*    *the-global* ...                                                 */
;*    -------------------------------------------------------------    */
;*    This variable is use to implement global tail calls.             */
;*---------------------------------------------------------------------*/
(define *the-global* #unspecified)

;*---------------------------------------------------------------------*/
;*    cgen-definition! ...                                             */
;*---------------------------------------------------------------------*/
(define (cgen-definition! global)
   (enter-function (global-shape global))
   (set! *the-global* global)
   (let ((label (create-label (global-id global)))
	 (cgen  (make-cgen)))
      (cgen-label-set! cgen label)
      (cgen-integrated-set! cgen #t)
      (global-info-set! global cgen)
      (let* ((fun  (global-value global))
	     (body (ast->cop (function-body fun)
			     (if (eq? (function-type-res fun) *void*)
				 *void-kont*
				 *return-kont*))))
	 (label-c-exp?-set! label (cop-c-exp? body))
	 (label-body-set! label body)
	 (cgen-cop-set! cgen (*block-kont* label))
	 (leave-function)
	 global)))

;*---------------------------------------------------------------------*/
;*    *return-kont* ...                                                */
;*---------------------------------------------------------------------*/
(define *return-kont*
   (lambda (cop)
      (cop-creturn #f
		   (cop-case cop
		      ((csetq)
		       (cop-csequence #t
				      (list cop (cop-catom #f #unspecified))))
		      (else
		       cop)))))

;*---------------------------------------------------------------------*/
;*    *id-kont* ...                                                    */
;*---------------------------------------------------------------------*/
(define *id-kont*
   (lambda (x) x))
      
;*---------------------------------------------------------------------*/
;*    *void-kont* ...                                                  */
;*---------------------------------------------------------------------*/
(define *void-kont*
   (lambda (cop)
      (cop-void (cop-c-exp? cop) cop)))

;*---------------------------------------------------------------------*/
;*    *stop-kont* ...                                                  */
;*---------------------------------------------------------------------*/
(define *stop-kont*
   (lambda (cop)
      (if (cop-c-exp? cop)
	  (cop-stop #f cop)
	  cop)))

;*---------------------------------------------------------------------*/
;*    *block-kont* ...                                                 */
;*---------------------------------------------------------------------*/
(define *block-kont*
   (lambda (cop)
      (if (cop-c-exp? cop)
	  (cop-stop #f cop)
	  (cop-case cop
	     ((block)
	      cop)
	     (else
	      (cop-block #f cop))))))

;*---------------------------------------------------------------------*/
;*    *fail-kont* ...                                                  */
;*---------------------------------------------------------------------*/
(define *fail-kont*
   (lambda (cop)
      cop))

;*---------------------------------------------------------------------*/
;*    *exit-kont* ...                                                  */
;*---------------------------------------------------------------------*/
(define *exit-kont*
   (lambda (cop) cop))

;*---------------------------------------------------------------------*/
;*    make-setq-kont ...                                               */
;*---------------------------------------------------------------------*/
(define (make-setq-kont var kont)
   (lambda (cop)
      (if (cfail? cop)
	  cop
	  (kont (cop-csetq #t
			   (cop-cvar #f var)
			   (cop-case cop
			      ((csetq)
			       (cop-csequence
				#t
				(list cop
				      (cop-catom #f #unspecified))))
			      (else
			       cop)))))))
			  
;*---------------------------------------------------------------------*/
;*    create-label ...                                                 */
;*---------------------------------------------------------------------*/
(define (create-label name)
   (cop-label #t name #f #f))

;*---------------------------------------------------------------------*/
;*    create-goto ...                                                  */
;*---------------------------------------------------------------------*/
(define (create-goto label)
   [assert check (label) (label? label)]
   (label-used?-set! label #t)
   (cop-goto #f label))

;*---------------------------------------------------------------------*/
;*    ast->cop ...                                                     */
;*---------------------------------------------------------------------*/
(define (ast->cop ast kont)
   (ast-case ast
      ((atom)
       (kont (cop-catom #t (atom-value ast))))
      ((kwote)
       (internal-error "ast->cop"
		       "Illegal node (see Cnst pass)"
		       (ast->sexp ast)))
      ((var)
       (kont (cop-cvar #t (var-variable ast))))
      ((make-box)
       (ast->cop (make-box-value ast)
		 (lambda (v) (kont (cop-cmake-box #t v)))))
      ((box-ref)
       (kont (ast->cop (box-ref-var ast) (lambda (v) (cop-cbox-ref #t v)))))
      ((box-set!)
       (let ((var (var-variable (box-set!-var ast))))
	  (ast->cop (box-set!-value ast)
		    (lambda (v) (kont (cop-cbox-set! #t
						     (cop-cvar #f var)
						     v))))))
      ((prag-ma)
       (kont (cop-cpragma #t
			  (prag-ma-string ast)
			  (map (lambda (value)
				  (ast->cop value *id-kont*))
			       (prag-ma-values ast)))))
      ((fail)
       (ast-fail->cop ast *fail-kont*))
      ((sequence)
       (let ((exp (sequence-exp ast)))
	  (cond
	     ((null? exp)
	      (kont (cop-nop #f)))
	     ((null? (cdr exp))
	      (let ((cop (ast->cop (car exp) kont)))
		 (if (cop-c-exp? cop)
		     (cop-stop #f cop)
		     cop)))
	     (else
	      (let loop ((exp exp)
			 (new '()))
		 (if (null? (cdr exp))
		     (cop-csequence #f
				    (reverse! (cons (ast->cop (car exp) kont)
						    new)))
		     (begin
			(if (atom? (car exp))
			    (loop (cdr exp) new)
			    (loop (cdr exp)
				  (cons (ast->cop (car exp) *stop-kont*)
					new))))))))))
      ((conditional)
       (ast-conditional->cop ast kont))
      ((switch)
       (ast-switch->cop ast kont))
      ((setq)
       (let ((var (var-variable (setq-var ast)))
	     (val (setq-val ast)))
	  (if (and (var? val) (eq? var (var-variable val)))
	      ;; ok, it is a dummy affectation
	      (kont (*void-kont* (cop-catom #t #unspecified)))
	      (ast->cop val (make-setq-kont var kont)))))
      ((let-var)
       (let ((decls (cop-local-var #f (map car (let-var-bindings ast))))
	     (sets  (map (lambda (x)
			    (ast->cop
			     (ast-setq #f #f #f
				       (ast-var #f #f #f
						(car x))
				       (cdr x))
			     *stop-kont*))
			 (let-var-bindings ast)))
	     (body  (let ((cop (ast->cop (let-var-body ast) kont)))
		       (if (cop-c-exp? cop)
			   (cop-stop #f cop)
			   cop))))
	  (*block-kont* (cop-csequence #f (cons decls
						(append sets (list body)))))))
      ((let-fun)
       ;; local function are open-coded of their first call site.
       ;; So, the compilation of `let-fun' construction is just
       ;; the declaration of all local functions' formals (and
       ;; a initialization mark in local function to express the
       ;; need of integration of the first call site).
       (let loop ((locals       (let-fun-locals ast))
		  (all-formals  '()))
	  (if (null? locals)
	      (*block-kont*
	       (cop-csequence #f (list (cop-local-var #f all-formals)
				       (ast->cop (let-fun-body ast)
						 kont))))
	      (let* ((local   (car locals))
		     (fun     (local-value local))
		     (formals (function-args fun))
		     (cgen    (make-cgen))
		     (label   (create-label (local-id local))))
		 ;; the mark
		 (cgen-integrated-set! cgen #f)
		 (cgen-label-set! cgen label)
		 (local-info-set! local cgen)
		 (loop (cdr locals)
		       (append formals all-formals))))))
      ((set-ex-it)
       (let ((exit (var-variable (set-ex-it-exit ast))))
	  (cop-csequence #f (list
			     (cop-cpragma #f "jmp_buf jmpbuf;" '())
			     (cop-local-var #f (list exit))
			     (cop-cset-ex-it
			      #f
			      (cop-cvar #t exit)
			      (ast->cop (ast-prag-ma #f
						     #f
						     #f
						     "_exit_value_"
						     '())
					kont)
			      (cop-csequence
			       #f
			       (list
				(ast->cop
				 (ast-setq #f #f #f
					   (ast-var #f #f #f exit)
					   (ast-prag-ma
					    #f
					    #f
					    #f
					    (string-append
					     "("
					     (string-sans-$
					      (type-name (local-type exit)))
					     ")jmpbuf")
					    '()))
				 *id-kont*)
				(ast->cop (set-ex-it-body ast)
					  kont))))))))
      ((jump-ex-it)
       (ast-jump-ex-it->cop ast kont))
      ((fun)
       (internal-error "ast->cop"
		       "Illegal node (see Globalize)"
		       (ast->sexp ast)))
      ((app-ly)
       (ast-apply->cop ast kont))
      ((funcall)
       (ast-funcall->cop ast kont))
      ((app)
       (ast-app->cop ast kont))))

;*---------------------------------------------------------------------*/
;*    ast-fail->cop ...                                                */
;*---------------------------------------------------------------------*/
(define (ast-fail->cop ast kont)
   (trace (cgen loop) "ast-fail->cop: "
	  (ast->sexp ast)
	  #\Newline)
   (let loop ((old-actuals (list (fail-proc ast)
				 (fail-msg ast)
				 (fail-obj ast)))
	      (new-actuals  '())
	      (aux          (make-local-variable (gensym 'aux) *obj*))
	      (auxs         '())
	      (exps         '()))
      (if (null? old-actuals)
	  (if (null? auxs)
	      (kont (cop-cfail #f
			       (caddr new-actuals)
			       (cadr new-actuals)
			       (car new-actuals)))
	      (cop-block #f
			 (cop-csequence
			  #f
			  (list (cop-local-var #f auxs)
				(cop-csequence #f exps)
				(kont (cop-cfail #f
						 (caddr new-actuals)
						 (cadr new-actuals)
						 (car new-actuals)))))))
	  (let ((cop (ast->cop (ast-setq #f #f #f
					 (ast-var #f #f #f aux)
					 (car old-actuals))
			       *id-kont*)))
	     (if (and (csetq? cop)
		      (eq? (cvar-variable (csetq-var cop)) aux))
		 ;; the local is useless, we ignore it
		 (loop (cdr old-actuals)
		       (cons (csetq-val cop) new-actuals)
		       aux
		       auxs
		       exps)
		 (begin
		    (local-type-set! aux *obj*)
		    (loop (cdr old-actuals)
			  (cons (cop-cvar #t aux) new-actuals)
			  (make-local-variable (gensym 'aux) *obj*)
			  (cons aux auxs)
			  (cons cop exps))))))))

;*---------------------------------------------------------------------*/
;*    ast-conditional->cop ...                                         */
;*    -------------------------------------------------------------    */
;*    This compilation is really different from the other. The main    */
;*    reason is that, it applies the continuation twice. This means    */
;*    (this enforce) continuations to be applicable twice.             */
;*---------------------------------------------------------------------*/
(define (ast-conditional->cop ast kont)
   (let* ((aux   (make-local-variable (gensym 'test) *bool*))
	  (ctest (ast->cop (ast-setq #f #f #f
				     (ast-var #f #f #f aux)
				     (conditional-test ast))
			   *id-kont*)))
      (if (and (csetq? ctest) (eq? (cvar-variable (csetq-var ctest)) aux))
	  (cop-cif #f
		   (csetq-val ctest)
		   (*block-kont* (ast->cop (conditional-then ast) kont))
		   (*block-kont* (ast->cop (conditional-else ast) kont)))
	  (cop-block #f
		     (cop-csequence
		      #f
		      (list (cop-local-var #f (list aux))
			    ctest
			    (cop-cif #f
				     (cop-cvar #t aux)
				     (*block-kont*
				      (ast->cop (conditional-then ast)
						kont))
				     (*block-kont*
				      (ast->cop (conditional-else ast)
						kont)))))))))

;*---------------------------------------------------------------------*/
;*    ast-switch->cop ...                                              */
;*---------------------------------------------------------------------*/
(define (ast-switch->cop ast kont)
   (for-each (lambda (clause)
		(set-cdr! clause (ast->cop (cdr clause) kont)))
	     (switch-clauses ast))
   (let ((aux  (make-local-variable (gensym 'aux) (get-switch-type ast))))
      (let ((cop (ast->cop (ast-setq #f #f #f
				     (ast-var #f #f #f aux)
				     (switch-test ast))
			   *id-kont*)))
	 (if (and (csetq? cop)
		  (eq? (cvar-variable (csetq-var cop)) aux))
	     (cop-cswitch #f (csetq-val cop) (switch-clauses ast))
	     (cop-block #f
			(cop-csequence
			 #f
			 (list (cop-local-var #f (list aux))
			       cop
			       (cop-cswitch #f
					    (cop-cvar #t aux)
					    (switch-clauses ast)))))))))

;*---------------------------------------------------------------------*/
;*    ast-app->cop ...                                                 */
;*---------------------------------------------------------------------*/
(define (ast-app->cop ast kont)
   (let ((var (var-variable (app-fun ast))))
      (if (and (global? var)
	       (or (not (eq? var *the-global*))
		   (not (eq? kont *return-kont*)))) 
	  (ast-non-tail-app->cop var ast kont)
	  (ast-tail-app->cop var ast kont))))

;*---------------------------------------------------------------------*/
;*    ast-non-tail-app->cop ...                                        */
;*---------------------------------------------------------------------*/
(define (ast-non-tail-app->cop var ast kont)
   (trace (cgen loop) "ast-non-tail-app->cop: "
	  (shape var) " " 
	  (ast->sexp ast)
	  #\Newline)
   (let loop ((old-actuals (app-actuals ast))
	      (args-type   (let ((fun (global-value var)))
			      (if (function? fun)
				  (map local-type (function-args fun))
				  (cond
				     ((>=fx (ffunction-arity fun) 0)
				      (ffunction-type-args fun))
				     ((<=fx (length (app-actuals ast))
					    (length (ffunction-type-args
						     fun)))
				      (ffunction-type-args fun))
				     (else
				      (let* ((type (ffunction-type-args
						    fun))
					     (last (car (last-pair type))))
					 (append
					  type
					  (vector->list
					   (make-vector
					    (- (length (app-actuals ast))
					       (length type))
					    last)))))))))
	      (new-actuals  '())
	      (aux          (make-local-variable (gensym 'aux) *obj*))
	      (auxs         '())
	      (exps         '()))
      (if (null? old-actuals)
	  (if (null? auxs)
	      (kont (cop-capp #t
			      (ast->cop (app-fun ast) *id-kont*)
			      (reverse! new-actuals)))
	      (cop-block #f
			 (cop-csequence
			  #f
			  (list (cop-local-var #f auxs)
				(cop-csequence #f exps)
				(kont
				 (cop-capp #t
					   (ast->cop (app-fun ast)
						     *id-kont*)
					   (reverse! new-actuals)))))))
	  (let ((cop (ast->cop (ast-setq #f #f #f
					 (ast-var #f #f #f aux)
					 (car old-actuals))
			       *id-kont*)))
	     (if (and (csetq? cop)
		      (eq? (cvar-variable (csetq-var cop)) aux))
		 ;; the local is useless, we ignore it
		 (loop (cdr old-actuals)
		       (cdr args-type)
		       (cons (csetq-val cop) new-actuals)
		       aux
		       auxs
		       exps)
		 (begin
		    (local-type-set! aux (car args-type))
		    (loop (cdr old-actuals)
			  (cdr args-type)
			  (cons (cop-cvar #t aux) new-actuals)
			  (make-local-variable (gensym 'aux) *obj*)
			  (cons aux auxs)
			  (cons cop exps))))))))

;*---------------------------------------------------------------------*/
;*    ast-tail-app->cop ...                                            */
;*    -------------------------------------------------------------    */
;*    For local functions, the first time we see it, we have           */
;*    to expand their body. So we check if the functions is            */
;*    already expanded then, we jump to the definition otherwise       */
;*    we expand the body and don't produce jump.                       */
;*---------------------------------------------------------------------*/
(define (ast-tail-app->cop var ast kont)
   (let ((label (cgen-label (variable-info var)))
	 (args  (function-args (variable-value var))))
      (if (not (cgen-integrated (variable-info var)))
	  (begin
	     (cgen-integrated-set! (variable-info var) #t)
	     (let ((body (ast->cop (function-body (local-value var)) kont)))
		(label-c-exp?-set! label (cop-c-exp? body))
		(label-body-set! label body)
		(if (null? args)
		    label
		    (let loop ((formals args)
			       (actuals (app-actuals ast))
			       (seq     '()))
		       (if (null? formals)
			   (cop-csequence #f (reverse! (cons label seq)))
			   (loop (cdr formals)
				 (cdr actuals)
				 (cons (ast->cop
					(ast-setq
					 #f #f #f
					 (ast-var #f #f #f (car formals))
					 (car actuals))
					*stop-kont*)
				       seq)))))))
	  ;; before branching, we create local variable to hold
	  ;; new formal values.
	  (if (null? args)
	      (create-goto label)
	      (let loop ((args    args) 
			 (actuals (app-actuals ast))
			 (auxs    '())
			 (seq1    '())
			 (seq2    (list (create-goto label))))
		 (if (null? args)
		     (begin
			(if (null? seq1)
			    (set! seq1 seq2)
			    (begin
			       (set! seq1 (reverse! seq1))
			       (set-cdr! (last-pair seq1) seq2)))
			(*block-kont*
			 (cop-csequence #f (cons (cop-local-var #f auxs)
						 seq1))))
		     (let ((arg (car args))
			   (act (car actuals)))
			;; we look for this special case in order to avoid
			;; local variable creations for constant parameters
			;; (as kaptured ones).
			(if (and (var? act) (eq? arg (var-variable act)))
			    (loop (cdr args)
				  (cdr actuals)
				  auxs
				  seq1
				  seq2)
			    (let ((aux (make-local-variable (local-name arg)
							    (local-type arg))))
			       (loop (cdr args)
				     (cdr actuals)
				     (cons aux auxs)
				     (cons (ast->cop
					    (ast-setq #f #f #f
						      (ast-var #f #f #f aux)
						      act)
					    *stop-kont*)
					   seq1)
				     (cons (cop-stop #f
						     (cop-csetq
						      #t
						      (cop-cvar #t arg)
						      (cop-cvar #t aux)))
					   seq2)))))))))))

;*---------------------------------------------------------------------*/
;*    ast-funcall->cop ...                                             */
;*---------------------------------------------------------------------*/
(define (ast-funcall->cop ast kont)
   (trace (cgen loop) "ast-funcall->cop: "
	  (ast->sexp ast)
	  #\Newline)
   (let loop ((old-actuals  (funcall-actuals ast))
	      (new-actuals  '())
	      (aux          (make-local-variable (gensym 'aux) *obj*))
	      (auxs         '())
	      (exps         '()))
      (if (null? old-actuals)
	  (let* ((aux (make-local-variable (gensym 'aux) *obj*))
		 (cop (ast->cop (ast-setq #f #f #f
					  (ast-var #f #f #f aux)
					  (funcall-fun ast))
				*id-kont*)))
	     (if (and (csetq? cop) (eq? (cvar-variable (csetq-var cop)) aux))
		 (let ((fun (csetq-val cop)))
		    (if (null? auxs)
			(kont (cop-cfuncall #t
					    fun
					    (reverse! new-actuals)
					    (funcall-strength ast)))
			(cop-block #f
				   (cop-csequence
				    #f
				    (list (cop-local-var #f auxs)
					  (cop-csequence #f exps)
					  (kont
					   (cop-cfuncall #t
							 fun
							 (reverse!
							  new-actuals)
							 (funcall-strength
							  ast))))))))
		 (let ((fun cop))
		    (cop-block #f
			       (cop-csequence
				#f
				(list (cop-local-var #f (cons aux auxs))
				      (cop-csequence #f exps)
				      (kont
				       (cop-cfuncall #t
						     (cop-cvar #f aux)
						     (reverse!
						      new-actuals)
						     (funcall-strength
						      ast)))))))))
	  (let ((cop (ast->cop (ast-setq #f #f #f
					 (ast-var #f #f #f aux)
					 (car old-actuals))
			       *id-kont*)))
	     (if (and (csetq? cop)
		      (eq? (cvar-variable (csetq-var cop)) aux))
		 ;; the local is useless, we ignore it
		 (loop (cdr old-actuals)
		       (cons (csetq-val cop) new-actuals)
		       aux
		       auxs
		       exps)
		 (begin
		    (local-type-set! aux *obj*)
		    (loop (cdr old-actuals)
			  (cons (cop-cvar #t aux) new-actuals)
			  (make-local-variable (gensym 'aux) *obj*)
			  (cons aux auxs)
			  (cons cop exps)))))))) 
		 
;*---------------------------------------------------------------------*/
;*    ast-apply->cop ...                                               */
;*---------------------------------------------------------------------*/
(define (ast-apply->cop ast kont)
   (trace (cgen loop) "ast-apply->cop: "
	  (ast->sexp ast)
	  #\Newline)
   (let* ((value (app-ly-value ast))
	  (vaux  (make-local-variable (gensym 'aux) *obj*))
	  (vcop  (ast->cop (ast-setq #f #f #f
				     (ast-var #f #f #f vaux)
				     value)
			   *id-kont*))
	  (fun   (app-ly-fun ast))
	  (faux  (make-local-variable (gensym 'fun) *procedure*))
	  (fcop  (ast->cop (ast-setq #f #f #f
				     (ast-var #f #f #f faux)
				     (app-ly-fun ast))
				*id-kont*)))
      (cond
	 ((and (csetq? vcop) (eq? (cvar-variable (csetq-var vcop)) vaux)
	       (csetq? fcop) (eq? (cvar-variable (csetq-var fcop)) faux))
	  (kont (cop-capply #t (csetq-val fcop) (csetq-val vcop))))
	 ((and (csetq? vcop) (eq? (cvar-variable (csetq-var vcop)) vaux))
	  (cop-block #f
		     (cop-csequence
		      #f
		      (list (cop-local-var #f (list faux))
			    (cop-csequence #f (list fcop))
			    (kont (cop-capply #t
					      (cop-cvar #t faux)
					      (csetq-val vcop)))))))
	 ((and (csetq? fcop) (eq? (cvar-variable (csetq-var fcop)) faux))
	  (cop-block #f
		     (cop-csequence
		      #f
		      (list (cop-local-var #f (list vaux))
			    (cop-csequence #f (list vcop))
			    (kont (cop-capply #t
					      (csetq-val fcop)
					      (cop-cvar #t vaux)))))))
	 (else
	  (cop-block #f
		     (cop-csequence
		      #f
		      (list (cop-local-var #f (list faux vaux))
			    (cop-csequence #f (list fcop vcop))
			    (kont (cop-capply #t
					      (cop-cvar #f faux)
					      (cop-cvar #t vaux))))))))))

;*---------------------------------------------------------------------*/
;*    ast-jump-ex-it->cop ...                                          */
;*---------------------------------------------------------------------*/
(define (ast-jump-ex-it->cop ast kont)
   (let* ((value (jump-ex-it-value ast))
	  (vaux  (make-local-variable (gensym 'aux) *obj*))
	  (vcop  (ast->cop (ast-setq #f #f #f
				     (ast-var #f #f #f vaux)
				     value)
			   *id-kont*))
	  (exit   (jump-ex-it-exit ast))
	  (eaux  (make-local-variable (gensym 'exit) *procedure*))
	  (ecop  (ast->cop (ast-setq #f #f #f
				     (ast-var #f #f #f eaux)
				     (jump-ex-it-exit ast))
			   *id-kont*)))
      (cond
	 ((and (csetq? vcop) (eq? (cvar-variable (csetq-var vcop)) vaux)
	       (csetq? ecop) (eq? (cvar-variable (csetq-var ecop)) eaux))
	  (*exit-kont* (cop-cjump-ex-it #t (csetq-val ecop) (csetq-val vcop))))
	 ((and (csetq? vcop) (eq? (cvar-variable (csetq-var vcop)) vaux))
	  (cop-block #f
		     (cop-csequence
		      #f
		      (list (cop-local-var #f (list eaux))
			    (cop-csequence #f (list ecop))
			    (*exit-kont* (cop-cjump-ex-it #t
							 (cop-cvar #t eaux)
							 (csetq-val vcop)))))))
	 ((and (csetq? ecop) (eq? (cvar-variable (csetq-var ecop)) eaux))
	  (cop-block #f
		     (cop-csequence
		      #f
		      (list (cop-local-var #f (list vaux))
			    (cop-csequence #f (list vcop))
			    (*exit-kont* (cop-cjump-ex-it
					  #t
					  (csetq-val ecop)
					  (cop-cvar #t vaux)))))))
	 (else
	  (cop-block #f
		     (cop-csequence
		      #f
		      (list (cop-local-var #f (list eaux vaux))
			    (cop-csequence #f (list ecop vcop))
			    (*exit-kont* (cop-cjump-ex-it
					  #t
					  (cop-cvar #f eaux)
					  (cop-cvar #t vaux))))))))))

