;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/vector.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr  5 18:06:51 1995                          */
;*    Last change :  Fri Oct 27 15:41:21 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The vector approximation managment                               */
;*    -------------------------------------------------------------    */
;*    For vector, we merged all approximations in the `cfa-info-aux'   */
;*    slot.                                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_vector
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Type/type.sch"
	    "Cfa/approx.sch"
	    "Cfa/stack.sch")
   (import  cfa_ast
	    cfa_approx
	    cfa_cfa
	    cfa_tvector
	    cfa_cache
	    cfa_top
	    cfa_stack
	    cfa_special
	    engine_param
	    type_env
	    type_cache
	    tools_shape
	    tools_set
	    ast_typeof
	    ast_dump)
   (export  (start-cfa-vector!)
	    (stop-cfa-vector!)
	    (is-vector-alloc? <ast>)
	    (lock-vectors! <approx>)))

;*---------------------------------------------------------------------*/
;*    start-cfa-vector! ...                                            */
;*---------------------------------------------------------------------*/
(define (start-cfa-vector!)
   (if (>=fx *optim* 1)
       (begin
	  [assert check (*make-vector*) (global? *make-vector*)]
	  [assert check (*create-vector*) (global? *create-vector*)]
	  [assert check (*vector-ref*) (global? *vector-ref*)]
	  [assert check (*vector-set!*) (global? *vector-set!*)]
	  [assert check (*vector-length*) (global? *vector-length*)]
	  (ffunction-cfa-info-set! (global-value *make-vector*)
				   (ispecial make-vector-init-approx
					     #t
					     spread-vector-top!
					     spread-vector-unstackable!
					     make-vector-app!))
	  (ffunction-cfa-info-set! (global-value *create-vector*)
				   (ispecial make-vector-init-approx
					     #t
					     spread-vector-top!
					     spread-vector-unstackable!
					     create-vector-app!))
	  (ffunction-cfa-info-set! (global-value *vector-ref*)
				   (ispecial std-init
					     #f
					     #unspecified
					     #unspecified
					     vect-ref))
	  (ffunction-cfa-info-set! (global-value *vector-set!*)
				   (ispecial typed-init
					     #f
					     #unspecified
					     #unspecified
					     vect-set!))
	  (ffunction-cfa-info-set! (global-value *vector-length*)
				   (ispecial typed-init
					     #f
					     #unspecified
					     #unspecified
					     vect-length))))
   #t)

;*---------------------------------------------------------------------*/
;*    stop-cfa-vector! ...                                             */
;*---------------------------------------------------------------------*/
(define (stop-cfa-vector!)
   (if (>=fx *optim* 1)
       (begin
	  (ffunction-cfa-info-set! (global-value *make-vector*) #unspecified)
	  (ffunction-cfa-info-set! (global-value *create-vector*) #unspecified)
	  (ffunction-cfa-info-set! (global-value *vector-ref*) #unspecified)
	  (ffunction-cfa-info-set! (global-value *vector-set!*) #unspecified)))
   #t)

;*---------------------------------------------------------------------*/
;*    std-init ...                                                     */
;*---------------------------------------------------------------------*/
(define (std-init ast)
   (add-vector-access! ast)
   (create-approx '() '()))

;*---------------------------------------------------------------------*/
;*    typed-init ...                                                   */
;*---------------------------------------------------------------------*/
(define (typed-init ast)
   (add-vector-access! ast)
   (create-approx (list (typeof ast)) '()))

;*---------------------------------------------------------------------*/
;*    make-vector-init-approx ...                                      */
;*---------------------------------------------------------------------*/
(define (make-vector-init-approx ast)
   (let ((approx (create-approx (list (typeof ast)) (list ast))))
      (set-special-approx! ast (create-approx '() '()))
      (top-lock-approx! approx)
      approx))

;*---------------------------------------------------------------------*/
;*    make-vector-app! ...                                             */
;*    -------------------------------------------------------------    */
;*    We add the last actuals of the `make-vector' call to the         */
;*    approximation fo this vector.                                    */
;*---------------------------------------------------------------------*/
(define (make-vector-app! call-ast fun actuals-approx)
   [assert check (fun) (global? fun)]
   (trace (cfa loop)
	  "~ ~ >   make-proc-app: " (shape fun) " " (ast->sexp call-ast)
	  #\Newline)
   (union-approx! (get-special-approx call-ast) (cadr actuals-approx))
   (let ((A (get-approx call-ast)))
      (trace (cfa loop) "< ~ ~                : " (approx-shape A) #\Newline)
      A))

;*---------------------------------------------------------------------*/
;*    create-vector-app! ...                                           */
;*---------------------------------------------------------------------*/
(define (create-vector-app! call-ast fun actuals-approx)
   [assert check (fun) (global? fun)]
   (trace (cfa loop)
	  "~ ~ >   create-proc-app: " (shape fun) " " (ast->sexp call-ast)
	  #\Newline)
   ;; we just return the approximation
   (let ((A (get-approx call-ast)))
      (trace (cfa loop) "< ~ ~                : " (approx-shape A) #\Newline)
      A))

;*---------------------------------------------------------------------*/
;*    spread-vector-top! ...                                           */
;*---------------------------------------------------------------------*/
(define (spread-vector-top! app)
   (let ((approx (get-approx app)))
      (approx-exported?-set! approx #t)
      (trace (cfa loop) "!!! spread-make-vector-top!: " (ast->sexp app)
	     #\Newline
 	     "              approx: " (approx-shape approx) #\Newline)
      (let ((approx (get-special-approx app)))
	 (spread-top! approx)
	 (add-top! approx)
	 (add-obj! approx))))

;*---------------------------------------------------------------------*/
;*    spread-vector-unstackable! ...                                   */
;*---------------------------------------------------------------------*/
(define (spread-vector-unstackable! app min max mark age)
   (let* ((sinfo  (app-stack-info app))
	  (smark  (sinfo-mark sinfo))
	  (approx (get-approx app)))
      (trace (stack loop)
	     "!!! spread-vector-unstackable!: " (ast->sexp app)
	     #\Newline
	     "              approx: " (approx-shape approx) #\Newline)
      (let ((astamp (sinfo-stamp sinfo))
	    (approx (get-special-approx app)))
	 (if (case age
		((all)
		 #t)
		((between)
		 (and (>fx astamp min) (<=fx astamp max)))
		(else
		 (not (=fx astamp min))))
	     (mark-unstackable! app))
	 (for-each-set (lambda (a)
			  (spread-unstackable/mark! a
						    min
						    max
						    mark
						    age))
		       (approx-alloc approx)))))

;*---------------------------------------------------------------------*/
;*    is-vector-alloc? ...                                             */
;*---------------------------------------------------------------------*/
(define (is-vector-alloc? app)
   (and (>=fx *optim* 1)
	(let ((var (var-variable (app-fun app))))
	   (or (eq? var *make-vector*)
	       (eq? var *make-s-vector*)
	       (eq? var *create-vector*)
	       (eq? var *create-s-vector*)))))

;*---------------------------------------------------------------------*/
;*    allowed-vector->tvector-type? ...                                */
;*    -------------------------------------------------------------    */
;*    Is this type can be used in a typed vector (in a vector          */
;*    replaced by a typed vector) ?                                    */
;*---------------------------------------------------------------------*/
(define (allowed-vector->tvector-type? type)
   (cond
      ((sub-obj-type? type)
       #f)
      ((eq? type *string*)
       #f)
      (else
       #t)))

;*---------------------------------------------------------------------*/
;*    only-one-type? ...                                               */
;*    -------------------------------------------------------------    */
;*    Does all concerned vectors by the approximation return the       */
;*    same type ?                                                      */
;*---------------------------------------------------------------------*/
(define (only-one-type? approx)
   (let loop ((alloc (set->list (approx-alloc approx)))
	      (type  #f))
      (cond
	 ((null? alloc)
	  #t)
	 ((not (is-vector-alloc? (car alloc)))
	  #f)
	 (else
	  (let ((t (set->list (approx-type (get-special-approx (car alloc))))))
	     (cond
		((not (pair? t))
		 #t)
		((not (null? (cdr t)))
		 #f)
		((not (type? (car t)))
		 #f)
		((not (allowed-vector->tvector-type? (car t)))
		 #f)
		((and type (not (eq? (car t) type)))
		 #f)
		(else
		 (loop (cdr alloc) (car t)))))))))

;*---------------------------------------------------------------------*/
;*    all-vector-types ...                                             */
;*    -------------------------------------------------------------    */
;*    This function is only used in a trace. It has no other usages.   */
;*---------------------------------------------------------------------*/
(define (all-vector-types approx)
   (let loop ((alloc (set->list (approx-alloc approx)))
	      (type  '()))
      (cond
       ((null? alloc)
	type)
       ((not (is-vector-alloc? (car alloc)))
	(loop (cdr alloc) (cons 'no-vector type)))
       (else
	(let liip ((t    (set->list
			  (approx-type (get-special-approx (car alloc)))))
		   (type type))
	   (cond
	      ((null? t)
	       (loop (cdr alloc) type))
	      ((memq (car t) type)
	       (liip (cdr t) type))
	      (else
	       (liip (cdr t) (cons (car t) type)))))))))
   
;*---------------------------------------------------------------------*/
;*    vect-ref ...                                                     */
;*---------------------------------------------------------------------*/
(define (vect-ref call-ast fun actuals-approx)
   [assert check (fun) (eq? fun *vector-ref*)]
   (trace (cfa loop)
	  "~ ~ >   vector-ref: " (shape fun) " " (ast->sexp call-ast)
	  #\Newline)
   (let ((A        (get-approx call-ast))
	 (v-approx (car actuals-approx)))
      ;; in respect whith all approximated vector, we add obj and top
      ;; to result of the vector ref.
      (if (approx-top? v-approx)
	  (begin
	     (add-obj! A)
	     (add-top! A)))
      ;; is several type can be returned by the vector ref, then no
      ;; vectors appearing in this vector-ref can be typed.
      (if (or (approx-top? v-approx)
	      (>fx (set-length (approx-type v-approx)) 1)
	      (not (only-one-type? v-approx)))
	  (begin
	     (trace (cfa loop) "        NOT ONLY ONE TYPE "
		    (shape (all-vector-types v-approx)) #\Newline
		    "     " (approx-shape v-approx) #\Newline)
	     (add-obj! A)
	     (lock-vectors! v-approx)))
      ;; we merge all approximation in the vector-ref result
      (for-each-set
       (lambda (alloc)
	  (cond
	     ((not (is-vector-alloc? alloc))
	      #unspecified)
	     ((not (approx? (get-special-approx alloc)))
	      (internal-error "vect-ref"
			      "`cfa-info-aux' is not an approximation for"
			      (ast->sexp call-ast)))
	     (else
	      (union-approx! A (get-special-approx alloc)))))
       (approx-alloc v-approx))
      (trace (cfa loop) "< ~ ~                : " (approx-shape A)
	     #\Newline)
      A))

;*---------------------------------------------------------------------*/
;*    vect-set! ...                                                    */
;*---------------------------------------------------------------------*/
(define (vect-set! call-ast fun actuals-approx)
   [assert check (fun) (eq? fun *vector-set!*)]
   (trace (cfa loop)
	  "~ ~ >   vector-set!: " (shape fun) " " (ast->sexp call-ast)
	  #\Newline)
   (let ((v-approx   (car actuals-approx))
	 (val-approx (caddr actuals-approx)))
      (if (approx-top? v-approx)
	  (spread-top! val-approx))
      ;; is several type can be returned by the vector ref, then no
      ;; vectors appearing in this vector-ref can be typed.
      (if (or (approx-top? v-approx)
	      (>fx (set-length (approx-type v-approx)) 1)
	      (not (only-one-type? v-approx)))
	  (lock-vectors! v-approx))
      (for-each-set
       (lambda (alloc)
	  (cond
	     ((not (is-vector-alloc? alloc))
	      #unspecified)
	     ((not (approx? (get-special-approx alloc)))
	      (internal-error "vect-set!"
			      "`cfa-info-aux' is not an approximation for"
			      (ast->sexp call-ast)))
	     (else
	      (union-approx! (get-special-approx alloc) val-approx))))
       (approx-alloc v-approx))
      (let ((A (get-approx call-ast)))
	 (trace (cfa loop) "< ~ ~                : " (approx-shape A)
		#\Newline)
	 A)))
   
;*---------------------------------------------------------------------*/
;*    vect-length ...                                                  */
;*---------------------------------------------------------------------*/
(define (vect-length call-ast fun actuals-approx)
   [assert check (fun) (eq? fun *vector-length*)]
   (trace (cfa loop)
	  "~ ~ >   vector-set!: " (shape fun) " " (ast->sexp call-ast)
	  #\Newline)
   (let ((A        (get-approx call-ast))
	 (v-approx (car actuals-approx)))
      (trace (cfa loop) "< ~ ~                : " (approx-shape A)
	     #\Newline)
      ;; is several type can be returned by the vector ref, then no
      ;; vectors appearing in this vector-ref can be typed.
      (if (or (approx-top? v-approx)
	      (>fx (set-length (approx-type v-approx)) 1)
	      (not (only-one-type? v-approx)))
	  (lock-vectors! v-approx))
      ;; vector-length has a constant approximation, it always
      ;; return something like `number'.
      A))
   
;*---------------------------------------------------------------------*/
;*    lock-vectors! ...                                                */
;*    -------------------------------------------------------------    */
;*    Lock all vector approximation contained in approx (which means   */
;*    add `obj' to their possible returned values).                    */
;*---------------------------------------------------------------------*/
(define (lock-vectors! approx)
   (trace (cfa loop) "LOCKING VECTORS: " (approx-shape approx) #\Newline)
   (for-each-set (lambda (alloc)
		    (if (is-vector-alloc? alloc)
			(add-obj! (get-special-approx alloc))))
		 (approx-alloc approx)))



