;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/ast-tools.sch        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Dec 30 14:49:50 1994                          */
;*    Last change :  Fri Mar 17 10:56:51 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The macro which define `ast'                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    define-ast ...                                                   */
;*---------------------------------------------------------------------*/
(define-macro (define-ast name slots . nodes)
   (let ((*debug-mode* #t))
      (define (make-pred-name name)
	 (symbol-append name '?))
      (define (make-pred name nodes)
	 (if *debug-mode*
	     `(define (,(make-pred-name name) o)
		 (or ,@(map (lambda (node)
			       `(,(make-pred-name (cadr node)) o))
			    nodes)))
	     `(define (,(make-pred-name name) o)
		 ;; this a hack _to be left_ (see distrib/build script file)
		 (not #f))))
      (eval
       `(define-macro (,(symbol-append name '-case) exp . clauses)
	   (let ((val (gensym))
		 (find-node-key (lambda (node)
				   (let loop ((nodes ',nodes)
					      (key   0))
				      (cond
					 ((null? nodes)
					  (error ,(string-append
						   (symbol->string name)
						   "-case")
						 "Unknown node"
						 node))
					 ((eq? node (cadr (car nodes)))
					  key)
					 (else
					  (loop (cdr nodes)
						(+fx key 1)))))))) 
	      `(let ((,val ,exp))
		  (if (not (struct? ,val))
		      (internal-error ,(string-append ,(symbol->string name)
						      "-case")
				      ,(string-append "Not an `"
						      ,(symbol->string name)
						      "' node")
				      ,val)
		      (case (struct-ref ,val 0)
			 ,@(let loop ((clauses  clauses)
				      (branches '()))
			      (cond
				 ((null? clauses)
				  (reverse!
				   (cons `(else (internal-error
						 ,(string-append
						   ,(symbol->string name)
						   "-case")
						 "Unrecognized node"
						 (shape ,val)))
					 branches)))
				 ((not (pair? (car clauses)))
				  (error (string-append ,(symbol->string name)
							"-case")
					 "Illegal clause"
					 (car clauses)))
				 ((eq? (car (car clauses)) 'else)
				  (if (null? (cdr clauses))
				      (reverse! (cons `(else
							,@(cdr (car clauses)))
						      branches))
				      (error (string-append
					      ,(symbol->string name)
					      "-case")
					     "Illegal clause"
					     (car clauses))))
				 (else
				  (let* ((clause  (car clauses))
					 (node    (car clause))
					 (actions (cdr clause)))
				     (loop (cdr clauses)
					   (cons
					    `((,(find-node-key (car node)))
					      ,@actions)
					    branches))))))))))))
      (let loop ((node* nodes)
		 (def   '())
		 (key   0))
	 (if (null? node*)
	     ;; for-each global slots we declare generic accessors and mutators
	     (let loop ((slots slots)
			(index 1)
			(def   def))
		(if (null? slots)
		    ;; ok, every thing is over, we just return all functions.
		    (cons 'begin
			  (cons (make-pred name nodes)
				def))
		    (loop (cdr slots)
			  (+fx index 1)
			  (cons (if *debug-mode*
				    `(define (,(symbol-append name
							      '-
							      (car slots)) o)
					(if (,(make-pred-name name) o)
					    (struct-ref o ,index)
					    (internal-error
					     ',(symbol-append name
							     '-
							     (car slots))
					     "Not an instance of"
					     ',name)))
				    `(define (,(symbol-append name
							      '-
							      (car slots)) o)
					(struct-ref o ,index)))
				(cons
				 (if *debug-mode*
				     `(define (,(symbol-append name
							       '-
							       (car slots)
							       '-set!) o v)
					 (if (,(make-pred-name name) o)
					     (struct-set! o ,index v)
					     (internal-error
					      ',(symbol-append name
							      '-
							      (car slots))
					      "Not an instance of"
					      ',name)))
				     `(define (,(symbol-append name
							       '-
							       (car slots)
							       '-set!) o v)
					 (struct-set! o ,index v)))
				 def)))))
	     (match-case (car node*)
		((define-node ?lname . ?lslots)
		 (loop (cdr node*)
		       (append (list
				`(define-struct ,lname key ,@slots ,@lslots)
				`(define-inline (,(symbol-append name
								 '-
								 lname)
						 ,@slots ,@lslots)
				    (,lname ,key ,@slots ,@lslots)))
			       def)
		       (+fx key 1)))
		(else
		 (error "define-ast" "Illegal ast" (car node*))))))))

 
