/************************************************************************
Copyright Notice

Copyright (c) MCNC, Clearinghouse for Networked Information Discovery and
Retrieval, 1994. 

Permission to use, copy, modify, distribute, and sell this software and
its documentation, in whole or in part, for any purpose is hereby granted
without fee, provided that

1. The above copyright notice and this permission notice appear in all
copies of the software and related documentation. Notices of copyright
and/or attribution which appear at the beginning of any file included in
this distribution must remain intact. 

2. Users of this software agree to make their best efforts (a) to return
to MCNC any improvements or extensions that they make, so that these may
be included in future releases; and (b) to inform MCNC/CNIDR of noteworthy
uses of this software. 

3. The names of MCNC and Clearinghouse for Networked Information Discovery
and Retrieval may not be used in any advertising or publicity relating to
the software without the specific, prior written permission of MCNC/CNIDR. 

THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY
OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 

IN NO EVENT SHALL MCNC/CNIDR BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE
POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. 
************************************************************************/

/*@@@
File:		userinfo.hxx
Version:	1.00
Description:	Wrapper around system calls for obtaining information
		about a user.
Author:		Kevin Gamiel, kevin.gamiel@cnidr.org
@@@*/


#ifndef _userinfo_
#define _userinfo_

#include <stdio.h>
#include <pwd.h>
#include <sys/types.h>
#include <unistd.h>
#include "string.hxx"
#include "gdt.h"

#define USERINFO_NOPASSWDENT 0

class USERINFO {
private:
	uid_t cUserID;	
	struct passwd *cPasswordEnt;
	uid_t	cUserId;	// User ID
	gid_t	cGroupId;	// Group ID
	STRING	cName,		// Login name
		cFullName,	// Full name
	 	cHomeDir,	// Home directory
		cShell;		// Shell

	INT cError;
public:
	USERINFO(void);
	~USERINFO(void);
	
	uid_t UserID() { return cUserId; }
	gid_t GroupID() { return cGroupId; }
	void Name(STRING *d) { *d = cName; }
	void FullName(STRING *d) { *d = cFullName; }
	void HomeDir(STRING *d) { *d = cHomeDir; }
	void Shell(STRING *d) { *d = cShell; }

	void Print();
};

#endif

