/*
**
** save.h
**
** Copyright (C) 1995-1997 Johannes Plass
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** Author:   Johannes Plass (plass@thep.physik.uni-mainz.de)
**           Department of Physic
**           Johannes Gutenberg-University
**           Mainz, Germany
**
*/

#ifndef	_GV_SAVE_H_
#define	_GV_SAVE_H_

typedef struct SaveDataStruct_ {
   char         *save_fn;
   char         *src_fn;
   char         *conv_fn;
   char         *pagelist;
   char         *print_cmd;
   int          convert;
   int          save_to_file;
   int          save_to_printer;
   int          print_kills_file;
} SaveDataStruct, *SaveData;

extern SaveData			save_allocSaveData (
#if NeedFunctionPrototypes
#endif
);

extern void			save_freeSaveData (
#if NeedFunctionPrototypes
   SaveData	/* sd */
#endif
);

extern String			save_saveFile (
#if NeedFunctionPrototypes
   SaveData	/* sd */
#endif
);

#endif  /* _GV_SAVE_H_ */
