! first.S  -  primary boot loader for DOS
!
! Version 1.1 <Sat Nov  9 22:08:52 MET 1996>
!
! Copyright (C) 1996 Gero Kuhlmann   <gero@gkminix.han.de>
!
!  This program is free software; you can redistribute it and/or modify
!  it under the terms of the GNU General Public License as published by
!  the Free Software Foundation; either version 2 of the License, or
!  any later version.
!
!  This program is distributed in the hope that it will be useful,
!  but WITHOUT ANY WARRANTY; without even the implied warranty of
!  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!  GNU General Public License for more details.
!
!  You should have received a copy of the GNU General Public License
!  along with this program; if not, write to the Free Software
!  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#ifndef ASM_DEBUG
#undef ASM_DEBUG
#endif
#include "first.inc"

	.text

	.globl	_main

	.org	0

_main:	mov	dx,ds
	mov	ax,cs			! set DS and ES
	mov	ds,ax
	mov	oldES,es
	mov	oldDS,dx		! save old register values in case
	mov	oldBP,bp		! we have to return to the boot rom
	mov	oldSI,si
	mov	oldDI,di
	mov	bp,sp
	mov	ax,(bp+4)
	mov	(header+0),ax		! load the address of the boot header
	mov	ax,(bp+6)
	mov	(header+2),ax
	mov	ax,(bp+8)
	mov	(bootp+0),ax		! load the address of the bootp block
	mov	ax,(bp+10)
	mov	(bootp+2),ax

! Tell the user who we are and that we started running

	mov	si,#sigmsg
	call	prnstr

! Check if the boot image header is correct.

	les	bx,header
	mov	si,#bmerr		! prepare for correct error message
	seg	es
	mov	ax,BOOT_HD_MAGIC+0(bx)
	cmp	ax,(bmagic+0)		! compare boot rom magic numbers
	jne	doerr1
	seg	es
	mov	ax,BOOT_HD_MAGIC+2(bx)
	cmp	ax,(bmagic+2)
	jne	doerr1

	mov	si,#vmerr		! prepare for correct error message
	seg	es
	mov	al,BOOT_HD_LENGTH(bx)
	mov	cl,#4
	shr	al,cl
	and	al,#0x0F
	cmp	al,#VENDOR_SIZE		! check vendor ID size
	jne	doerr1
	xor	di,di
dovmag:	mov	al,vmagic(di)		! check vendor ID
	or	al,al
	jz	getmem			! vendor ID ok, continue
	seg	es
	cmp	al,BOOT_HD_VENDOR(bx+di)
	jne	doerr1
	inc	di
	jmp	dovmag

doerr1:	call	prnstr			! in case of error return to the
	mov	si,oldSI		! boot rom with registers set
	mov	di,oldDI		! correctly
	mov	bp,oldBP
	mov	es,oldES
	mov	ds,oldDS
	retf

! Get the size of the base and extended memory from the BIOS.

getmem:	int	0x12			! get memory size in kB
	mov	avlmem,ax		! save it for later
	mov	ah,#0x88
	int	0x15			! get extended memory size in kB
	mov	extmem,ax		! save it for later

! Get the number of hard disk drives in the system

	mov	ah,#0x08
	mov	dl,#0x80
	int	0x13			! get the number of hard disk
	inc	dl			! drives including the ramdisk
	mov	drvnum,dl		! from the BIOS

! Next get the address of the ramdisk and its size.

	mov	si,#recerr
	mov	al,#VENDOR_RAMDISK
	call	fndldr				! find load record for ramdisk
	mov	ax,es
	or	ax,di
	jz	doerr1
	seg	es
	mov	al,BOOT_LD_FLAGS(di)		! get load record flags
	and	al,#BOOT_FLAG_B0 + BOOT_FLAG_B1	! check that it has a
	cmp	al,#BOOT_FLAG_B1		! correct flag
	jne	doerr1

	mov	ax,extmem
	add	ax,#1024			! care for base 1M
	mov	bx,ax
	mov	cl,#10				! compute linear address of last
	shl	ax,cl				! byte in extended memory
	mov	cl,#6
	shr	bx,cl
	seg	es
	sub	ax,BOOT_LD_ADDR+0(di)		! get base adress of ramdisk
	seg	es
	sbb	bx,BOOT_LD_ADDR+2(di)
	mov	(rdaddr+0),ax
	mov	(rdaddr+2),bx

	seg	es
	mov	ax,BOOT_LD_MLENGTH+0(di)	! get ramdisk size
	seg	es
	mov	bx,BOOT_LD_MLENGTH+2(di)
	mov	(rdsize+0),ax
	mov	(rdsize+2),bx

! Get the disk geometry out of the vendor information block in the
! load record

	seg	es
	mov	bl,BOOT_LD_LENGTH(di)
	and	bl,#0x0f
	xor	bh,bh				! compute pointer to
	shl	bx,#1				! vendor block
	shl	bx,#1
	seg	es
	mov	ax,BOOT_LD_SECNUM(di+bx)	! get number of sectors
	mov	secnum,ax
	seg	es
	mov	ax,BOOT_LD_SPT(di+bx)		! get sectors per track
	mov	secptk,al
	seg	es
	mov	ax,BOOT_LD_CYL(di+bx)		! get number of cylinders
	mov	cylnum,ax

! Now get the boot sector of the ramdisk, check that its correct
! and then get the first sector of the ramdisk partition.

	mov	ax,#TEMP_SEGMENT
	mov	es,ax			! pointer to temporary buffer
	xor	bx,bx
	xor	al,al			! indicate read
	xor	dx,dx			! first sector
	call	rwsect			! read partition sector
	mov	si,#rderr
	jc	doerr2

	mov	si,#dskerr		! prepare for correct error message
	seg	es
	cmp	byte ptr PART_STATUS,#PART_ACTIVE
	jne	doerr2
	seg	es
	cmp	byte ptr PART_TYPE,#PART_FAT16
	je	partok
	seg	es
	cmp	byte ptr PART_TYPE,#PART_FAT12
	jne	doerr2
partok:	seg	es
	mov	dx,(PART_ABS_SECT+0)	! get number of first sector
	seg	es
	mov	ax,(PART_ABS_SECT+2)
	or	ax,ax
	jnz	doerr2
	xor	al,al			! indicate read
	call	rwsect			! read boot sector
	mov	si,#rderr
	jc	doerr2

	mov	si,#dskerr		! prepare for correct error message
	xor	di,di
dodmag:	mov	al,dmagic(di)		! check OEM ID
	or	al,al
	jz	chkbot			! OEM ID ok, continue
	seg	es
	cmp	al,DISK_OEM(di)
	jne	doerr2
	inc	di
	jmp	dodmag

chkbot:	seg	es
	cmp	byte ptr DISK_BOOT,#BOOT_ID	! check boot disk number
	jne	doerr2
	seg	es
	cmp	word ptr DISK_BPS,#SECT_SIZE	! check sector size
	jne	doerr2
	seg	es
	cmp	word ptr DISK_HEADS,#2	! check number of heads
	jne	doerr2
	seg	es
	mov	ax,DISK_SPT		! check number of sectors per track
	cmp	al,secptk
	je	dobotp

doerr2:	call	prnstr			! in case of error return to the
	mov	si,oldSI		! boot rom with registers set
	mov	di,oldDI		! correctly
	mov	bp,oldBP
	mov	es,oldES
	mov	ds,oldDS
	retf

! Save the BOOTP record for later retrieval by a DOS program.

dobotp:	cld
	xor	dx,dx
	les	di,bootp
	seg	es
	mov	al,BOOTP_OP(di)		! op code must indicate reply
	cmp	al,#BOOTP_REPLY
	jne	dobot9			! it isnt
	add	di,#BOOTP_VEND
	mov	bx,di
	mov	si,#pmagic		! compare vendor ID
dobot1:	mov	di,bx
	mov	cx,#BOOTP_MAGIC_LEN
	repe
	cmpsb
	jz	dobot2			! vendor ID is valid
	add	si,cx
	cmp	byte ptr (si),#0	! check next vendor ID
	jne	dobot1
dobot9:	jmp	nobot2			! vendor ID not found

doerr6:	jmp	doerr2

dobot2:	sub	si,#BOOTP_MAGIC_LEN
	sub	si,#pmagic
	mov	ax,si
	push	ds
	mov	bx,ds
	mov	es,bx
	mov	di,#btpnew
	lds	si,bootp
	mov	bx,si
	mov	dx,#BOOTP_SIZE
	or	ax,ax			! if not RFC vendor ID the bootp
	jnz	dobot7			! record has fixed length

	xor	cx,cx
	add	si,#BOOTP_VEND + BOOTP_MAGIC_LEN
dobot3:	lodsb
	cmp	al,#BOOTP_RFC_NOP	! handle NOP tag
	jnz	dobot4
	inc	cx
	cmp	cx,#16			! more than 16 NOP tags is VERY unusual
	jae	dobot7			! so the bootp record maybe broken
	jmp	dobot3			! loop to next tag

nobot2:	jmp	nobotp

dobot4:	cmp	al,#BOOTP_RFC_END	! handle END tag
	jnz	dobot6
	mov	dx,si
	sub	dx,bx			! compute length of bootp record
	cmp	dx,#BOOTP_SIZE
	jae	dobot7
	mov	dx,#BOOTP_SIZE		! use minimum size
	jmp	dobot7
dobot6:	lodsb				! handle all other tags
	mov	cl,al
	xor	ch,ch
	add	si,cx			! jump to next tag
	xor	cx,cx			! reset NOP counter
	jmp	dobot3			! proceed with next tag

dobot7:	mov	si,#btperr
	mov	ax,#btpnew		! bootp record cannot be larger
	add	ax,dx			! than the current segment
	jc	doerr6
	mov	cx,dx
	mov	si,bx			! restore source pointer
	rep
	movsb				! save the bootp record
	pop	ds
nobotp:	mov	btplen,dx		! set length of bootp record

! Everything is right, so we can now move the resident section to the
! end of the conventional memory, thus overwriting the bootrom data
! area. Therefore there is no chance of returning to the bootrom from
! now on.
! Note that the resident section doesnt start at offset 0, so we have
! to set the segment address to somewhere lower.

#ifdef ASM_DEBUG
	mov	si,#debug1
	call	prnstr
#endif
	cli
	mov	ax,#TEMP_SEGMENT		! set new stack
	mov	ss,ax
	mov	sp,#0xFFF0

	cld	
	mov	ax,avlmem
	mov	cl,#6
	shl	ax,cl			! compute last usable segment
	mov	bx,#btpnew
	add	bx,btplen
	mov	dx,bx
	mov	cl,#4
	shr	bx,cl			! compute size of code segment in
	inc	bx			! paragraphs
	sub	ax,bx			! compute new code segment
	mov	resseg,ax
	mov	es,ax			! set source and destination ptrs
	mov	si,#start_resident
	mov	di,si
	mov	cx,dx
	sub	cx,si			! compute size of resident area
	rep
	movsb				! move it

! Setup all interrupt vectors

	mov	bx,resseg
	push	ds
	mov	ds,bx
	xor	ax,ax
	mov	es,ax
	seg	es
	mov	ax,[I13_INT+0]
	mov	(old13h+0),ax
	seg	es
	mov	ax,[I13_INT+2]
	mov	(old13h+2),ax
	seg	es
	mov	ax,[I15_INT+0]		! save old interrupts
	mov	(old15h+0),ax
	seg	es
	mov	ax,[I15_INT+2]
	mov	(old15h+2),ax
	seg	es
	mov	ax,[I2F_INT+0]
	mov	(old2Fh+0),ax
	seg	es
	mov	ax,[I2F_INT+2]
	mov	(old2Fh+2),ax
	pop	ds

	seg	es
	mov	word ptr [I13_INT+2],bx	! interrupt vector 13h
	seg	es
	mov	word ptr [I15_INT+2],bx	! interrupt vector 15h
	seg	es
	mov	word ptr [I2F_INT+2],bx	! interrupt vector 2Fh
	seg	es
	mov	word ptr [I13_INT+0],#int13h
	seg	es
	mov	word ptr [I15_INT+0],#int15h
	seg	es
	mov	word ptr [I2F_INT+0],#int2Fh
	sti

! Output some debugging messages by simply calling the interrupt vectors
! which we just created.

#ifdef DRV_DEBUG
	mov	ax,#0x4A06
	int	0x2F
	mov	si,#consz
	call	prnstr			! print out amount of conventional
	mov	ax,dx			! memory
	mov	cl,#12
	shr	ax,cl
	call	prnwrd
	mov	ax,dx
	mov	cl,#4
	shl	ax,cl
	call	prnwrd
	mov	si,#bytes
	call	prnstr

	mov	ax,#0x8800
	int	0x15
	push	ax
	mov	si,#extsz
	call	prnstr			! print out amount of extended memory
	mov	cl,#6
	shr	ax,cl
	call	prnwrd
	pop	ax
	mov	cl,#10
	shl	ax,cl
	call	prnwrd
	mov	si,#bytes
	call	prnstr
#endif

! The boot sector had to be placed into a temporary memory area to
! avoid overwriting any bootrom structures. However, a call back
! to the bootrom is no longer possible, so we can move the bootblock
! where it belongs.

	push	ds
	mov	ax,#TEMP_SEGMENT
	mov	ds,ax
	xor	ax,ax
	mov	es,ax
	xor	si,si
	mov	di,#BOOT_OFFSET
	mov	cx,#SECT_SIZE
	rep
	movsb				! move it
	pop	ds

! Finally call the boot sector

#ifdef ASM_DEBUG
	mov	si,#debug2
	call	prnstr
#endif
#ifdef ASM_FREEZE_AFTER_INIT
lop:	jmp	lop
#else
	jmpi	BOOT_OFFSET,0
#endif



!====================================================================
!
! Find a load record in the boot header. The ID number of the load
! record is in AL, and ES:DI points to requested load record, or is
! the NULL pointer if load record not found.
!
! Changed registers: AX, DI, ES

fndldr:	push	cx
	mov	ch,al
	les	di,header		! examine boot image header
	seg	es
	mov	al,BOOT_HD_LENGTH(di)	! get length of image header
	call	getlen
	add	di,ax			! get the pointer to first load record
fndl1:	seg	es
	cmp	ch,BOOT_LD_TAG1(di)	! is it the desired one ?
	je	fndl3
	seg	es
	mov	al,BOOT_LD_FLAGS(di)	! no, so check if its the last record
	test	al,#BOOT_FLAG_EOF
	jnz	fndl2
	seg	es
	mov 	al,BOOT_LD_LENGTH(di)	! no, get the address of the next one
	call	getlen
	add	di,ax
	jmp	fndl1

fndl2:	xor	ax,ax			! couldnt find the desired record
	mov	es,ax
	mov	di,ax
fndl3:	pop	cx
	ret



!====================================================================
!
! Compute the length of a load record address from a length byte
! in AL. Return the offset in AX.
!
! Changed registers: AX

getlen:	push	cx
	mov 	ah,al
	mov 	cl,#4
	shr	ah,cl
	and	ax,#0x0f0f		! compute the total length in
	add	al,ah			! bytes from the length of the
	xor	ah,ah			! record and that of the vendor
	shl	ax,1			! information.
	shl	ax,1
	pop	cx
	ret



!====================================================================
! Print a string in DS:SI onto the console
!
! Changed registers: AL

prnstr:	push	si
	cld
prns1:	lodsb				! loop over all characters of
	or	al,al			! string
	jz	prns2
	push	bx
	mov	ah,#0x0E		! print it
	mov	bl,#0x07
	xor	bh,bh
	int	0x10
	pop	bx
	jmp	prns1
prns2:	pop	si
	ret



#ifdef DRV_DEBUG
!====================================================================
!
! Print hexadecimal values (in AX or AL) or characters onto the console
!
! Changed registers: AX

prnwrd:	push	ax
	mov	al,ah
	call	prnbyt			! print the upper byte
	pop	ax
prnbyt:	push	ax
	shr	al,1			! prepare upper nibble
	shr	al,1
	shr	al,1
	shr	al,1
	call	prnnib			! print it
	pop	ax
prnnib:	and	al,#0x0F		! prepare lower nibble
	add	al,#0x30
	cmp	al,#0x39		! convert it into hex
	jle	prnchr
	add	al,#7
prnchr:	push	bx
	mov	ah,#0x0E		! print it
	mov	bl,#0x07
	xor	bh,bh
	int	0x10
	pop	bx
	ret
#endif



!====================================================================
!
! String and constants definitions


! Startup signature

sigmsg:	.byte	0x0D, 0x0A
	.ascii	"DOS Net Boot Image Loader Version 1.1"
	.byte	0x0D, 0x0A
crlf:	.byte	0x0D, 0x0A
	.byte	0


! Magic numbers for boot record and bootp entry

bmagic:	.long	BOOT_MAGIC		! boot image magic number
vmagic:	.ascii	VENDOR_MAGIC		! vendor magic ID
	.byte	0			! end of vendor magic ID
dmagic:	.ascii	OEM_MAGIC		! disk OEM magic ID
	.byte	0
pmagic:	.byte	BOOTP_MAGIC_RFC		! bootp magic ID for RFC 1048
	.byte	BOOTP_MAGIC_CMU		! bootp magic ID for CMU
	.byte	BOOTP_MAGIC_STA		! bootp magic ID for Stanford
	.byte	0


! Error messages

recerr:	.ascii	"Error in load record data"
	.byte	0x0D, 0x0A
	.byte	0

bmerr:	.ascii	"Invalid boot header magic number"
	.byte	0x0D, 0x0A
	.byte	0

vmerr:	.ascii	"Invalid vendor magic ID"
	.byte	0x0D, 0x0A
	.byte	0

rderr:	.ascii	"Error while accessing ramdisk"
	.byte	0x0D, 0x0A
	.byte	0

dskerr:	.ascii	"Wrong ramdisk image"
	.byte	0x0D, 0x0A
	.byte	0

btperr:	.ascii	"BOOTP record too large"
	.byte	0x0D, 0x0A
	.byte	0


! Debug messages

#ifdef ASM_DEBUG
debug1:	.ascii	"Making driver resident"
	.byte	0x0D, 0x0A
	.byte	0

debug2:
#ifdef ASM_FREEZE_AFTER_INIT
	.ascii  "Freezing!"
#else
	.ascii	"Calling boot block"
#endif
	.byte	0x0D, 0x0A
	.byte	0
#endif

#ifdef DRV_DEBUG
consz:	.ascii	"RAMDISK: reporting conventional memory size: "
	.byte	0
extsz:	.ascii	"RAMDISK: reporting extended memory size: "
	.byte	0
bytes:	.ascii	" bytes"
	.byte	0x0D,0x0A
	.byte	0
#endif



!====================================================================
!
! Variable definitions

header:	.long	0			! pointer to boot header from boot rom
bootp:	.long	0			! pointer to bootp block from boot rom

resseg:	.word	0			! segment of resident section

oldDS:	.word	0			! old DS from boot rom
oldES:	.word	0			! old ES from boot rom
oldBP:	.word	0			! old BP from boot rom
oldSI:	.word	0			! old SI from boot rom
oldDI:	.word	0			! old DI from boot rom

avlmem:	.word	0			! available amount of RAM in kB
extmem:	.word	0			! extended memory in kB



!====================================================================
!
! Start of resident section. This will be placed at the end of the
! low 640kB RAM area.
!
!====================================================================
!

	.align	16			! has to be paragraph aligned

start_resident:				! indicate start of resident section


!====================================================================
!
! New interrupt 2Fh routine. This routine gets called by IO.SYS
! in order to determine the maximum amount of memory usable to
! DOS. This only works with DOS versions 5.0 and higher.
!
! NOTE THAT THIS INTERRUPT HAS TO BE THE FIRST ROUTINE IN THE
! RESIDENT SECTION!
!
! Input:  AX     -  Magic ID
!         DX     -  segment following last usable byte
! Output: DX     -  new segment  following last usable byte
! Registers changed: DX

int2Fh:	jmp	int2F1			! this has to be a relative jump
	nop

	.ascii	"RPL"			! magic ID string for DOS

int2F1:	cmp	ax,#0x4A06		! check for magic ID
	jne	int2F9
	push	cx
	mov	dx,#start_resident	! determine last usable segment
	mov	cl,#4			! from segment and offset of
	shr	dx,cl			! the resident section
	pop	cx
	push	ax
	push	cs
	pop	ax
	add	dx,ax			! add offset to segment
	dec	dx
	pop	ax
	iret

int2F9:	seg	cs
	jmpf	(old2Fh)		! jump to old interrupt routine



!====================================================================
!
! New interrupt 15h routine.
! Input:  AH  -  function code
! Output: depend on function
!         AX     -  number of kB in extended RAM (if AH = 0x88)
!         AX     -  contains 0x009C (if AX = 0x9C00) as installation check
!         BX:DX  -  address of ramdisk (if AX = 0x9C01)
!         BX:DX  -  size of ramdisk (if AX = 0x9C02)
!         BX:DX  -  address of BOOTP block (if AX = 0x9C03)
!         CX     -  size of BOOTP block (if AX = 0x9C03)
! Registers changed: depends on function

int15h:	cmp	ah,#0x88		! check for function 0x88: return
	jne	int152			! amount of extended memory
	push	cx
	push	dx
	seg	cs
	mov	ax,(rdaddr + 0)
	mov	cl,#10
	shr	ax,cl
	and	ax,#0x003F
	seg	cs
	mov	dx,(rdaddr + 2)		! determine amount of extended
	mov	cl,#6			! memory from base of ram disk
	shl	dx,cl
	and	dx,#0xFFC0
	or	ax,dx
	sub	ax,#1024		! subtract amount of base memory
	jnc	int151
	xor	ax,ax			! oops, no more extended memory avail
int151:	pop	dx
	pop	cx
	iret

int152:	cmp	ah,#0x9C		! check for magic ID
	jne	int159
	cmp	al,#01			! check for function number
	jne	int153
	seg	cs
	mov	bx,(rdaddr+2)		! return ramdisk address
	seg	cs
	mov	dx,(rdaddr+0)
	iret

int153:	cmp	al,#02
	jne	int154
	seg	cs
	mov	bx,(rdsize+2)		! return ramdisk size
	seg	cs
	mov	bx,(rdsize+0)
	iret

int154:	cmp	al,#0x03
	jne	int155
	mov	bx,cs			! return address of BOOTP record
	mov	dx,#btpnew
	seg	cs
	mov	cx,btplen		! return BOOTP length
	iret

int155:	or	al,al
	jnz	int159
	mov	al,ah			! return installation check code
	xor	ah,ah
	iret

int159:	seg	cs
	jmpf	(old15h)		! call the old interrupt routine



!====================================================================
!
! New interrupt 13h routine to handle disk accesses.
! Input:  AH  -  function code
!         DL  -  driver number
! Output: carry flag set if error
! Registers changed: depends on function

int13h:	or	ah,ah			! function 0 doesnt use drive numbers
	jz	int131
	cmp	dl,#0x80		! check if its for us
	jb	int131
	je	int132

! Handle function 0x08 for disk drives other than the ramdisk.

	cmp	ah,#0x08
	jne	int137
	dec	dl
	pushf
	seg	cs			! function 0x08 has to return the
	callf	(old13h)		! correct number of disk drives
	seg	cs
	mov	dl,drvnum
	jmp	int136

! Handle function 0x15 for disk drives other than the ramdisk. This is
! the only function besides 0x08 which returns a value in DX and therefore
! has to have special handling.

int137:	push	dx
	dec	dl
	cmp	ah,#0x15
	jne	int138
	pushf
	seg	cs
	callf	(old13h)		! call the BIOS for handling
	jc	int139
	cmp	ah,#0x03		! DX is only used if AH = 0x03
	jne	int139
	add	sp,#0x0002		! remove DX from stack if the BIOS
	jmp	int136			! returned a value in it

! Handle all other functions for drives other than the ramdisk. This will
! just call the original BIOS handler.

int138:	pushf
	seg	cs
	callf	(old13h)		! simply call the old int 13h routine
int139:	pop	dx
	jmp	int136

! Jump directly to the BIOS for floppy drives

int131:	seg	cs
	jmpf	(old13h)		! call the old interrupt routine

! Now handle all ramdisk functions. First check if the function number
! is correct.

int132:	cmp	ah,#0x18
	jbe	int134
	mov	ah,#0x01		! unknown command
int135:	stc
int136:	push	ds
	jmp	int13e

! Determine the handlers address according to the function number in AH
! and jump to it.

int134:	push	ds
	push	cs
	pop	ds			! set data segment
	push	bx
	mov	bl,ah
	xor	bh,bh
	shl	bx,#1			! compute pointer into routine table
	mov	bx,fntab(bx)
	jmp	bx

! Save the return status into the BIOS data area and return to the caller
! while preserving the carry flag.

int13e:	push	es			! return from function handler
	push	ax			! this code is not allowed to change
	mov	ax,#BIOS_SEG		! any register or flag
	mov	es,ax
	pop	ax
	seg	es
	mov	[BIOS_HDSTAT],ah	! set disk operation status
	pop	es
	pop	ds
intend:	push	ax			! general exit point for interrupts
	pushf
	pop	ax
	push	bp
	mov	bp,sp
	mov	(bp+8),al		! put the flags onto the stack
	pop	bp
	pop	ax
	iret


! Function table

fntab:	.word	f1300			! function 00: reset disk system
	.word	f1301			! function 01: return last error
	.word	f1302			! function 02: read disk
	.word	f1303			! function 03: write disk
	.word	f1304			! function 04: verify disk
	.word	f1305			! function 05: format disk
	.word	f1306			! function 06: format track
	.word	f1307			! function 07: format disk
	.word	f1308			! function 08: get drive parameters
	.word	f1309			! function 09: intialize controller
	.word	f130A			! function 0A: read long sectors
	.word	f130B			! function 0B: write long sectors
	.word	f130C			! function 0C: seek for cylinder
	.word	f130D			! function 0D: disk reset
	.word	f130E			! function 0E: read sector buffer
	.word	f130F			! function 0F: write sector buffer
	.word	f1310			! function 10: check if drive ready
	.word	f1311			! function 11: recalibrate drive
	.word	f1312			! function 12: controller ram diagnostic
	.word	f1313			! function 13: drive diagnostic
	.word	f1314			! function 14: controller int diagnostic
	.word	f1315			! function 15: get disk type
	.word	f1316			! function 16: detect disk change
	.word	f1317			! function 17: set media type for format
	.word	f1318			! function 18: set media type for format

f13end:	jmp	int13e


!====================================================================
!
! Function 01 - return last error status
!

f1301:	push	es
	mov	bx,#BIOS_SEG
	mov	es,bx
	seg	es
	mov	ah,[BIOS_HDSTAT]	! get disk operation status
	pop	es
	pop	bx
	clc
	jmp	intend



!====================================================================
!
! Function 02/03 - read/write from disk

f1302:
f1303:	pop	bx			! get old BX from stack
	push	dx
	push	ax
	call	cvtsec			! get linear sector number
	pop	ax
	jnc	f13021
	mov	ah,#0x04		! error: sector not found
f13028:	pop	dx
	stc
	jmp	f13end			! terminate

f13021:	push	cx
	push	bx
	push	ax
	mov	cl,al			! move number of sectors into CX
	xor	ch,ch
f13022:	jcxz	f13026
	cmp	dx,secnum		! check if sector is still correct
	jb	f13023
	pop	ax
	mov	ah,#0x04		! error: sector not found
f13027:	sub	al,cl			! compute number of sectors processed
	pop	bx
	pop	cx
	jmp	f13028

f13023:	pop	ax
	push	ax
	xor	al,al
	cmp	ah,#0x02		! check if read or write sector
	je	f13024
	inc	al
f13024:	call	rwsect			! actually handle request
	jnc	f13025
	pop	ax
	mov	ah,#0x20		! error: disk controller error
	jmp	f13027

f13025:	inc	dx
	dec	cx			! proceed with next sector
	add	bx,#SECT_SIZE
	jmp	f13022

f13026:	pop	ax
	pop	bx
	pop	cx
	pop	dx
	xor	ah,ah			! no error
	jmp	f13end



!====================================================================
!
! Function 08  -  get disk drive parameters

f1308:	pop	bx			! get old BX from stack
	mov	dl,byte ptr (drvnum)	! get number of disk drives
	mov	cl,byte ptr (secptk)	! get sectors per track
	mov	ch,byte ptr (cylnum)	! number of cylinders
	mov	dh,#2			! number of heads
	xor	bx,bx			! ramdisk drive type
	dec	dh
	dec	ch
	xor	ax,ax
f13e1:	jmp	f13end



!====================================================================
!
! Function 00, 04, 05, 06, 07, 09, 0D, 10, 11, 12, 13, 14, 16  -  no operation

f1300:
f1304:
f1305:
f1306:
f1307:
f1309:
f130D:
f1310:
f1311:
f1312:
f1313:
f1314:
f1316:	pop	bx			! get old BX from stack
	xor	ah,ah			! no error
	jmp	f13e1



!====================================================================
!
! Function 0A, 0B, 0E, 0F, 17, 18  -  not implemented

f130A:
f130B:
f130E:
f130F:
f1317:
f1318:	pop	bx			! get old BX from stack
	mov	ah,#0x01		! invalid opcode
	stc
	jmp	f13e1



!====================================================================
!
! Function 0C  -  seek for cylinder

f130C:	pop	bx			! get old BX from stack
	push	dx
	push	ax
	call	cvtsec			! get linear sector number
	pop	ax
	mov	ah,#0x00		! no error
	jnc	f130C1
	mov	ah,#0x04		! error: sector not found
f130C1:	pop	dx
	jmp	f13e1			! terminate



!====================================================================
!
! Function 15  -  get disk type

f1315:	pop	bx			! get old BX from stack
	mov	ah,#0x03		! indicate hard disk
	mov	dx,secnum		! get number sectors on disk
	xor	cx,cx
	jmp	f13e1



!====================================================================
!
! Convert Cyl/Sec/Head notation into a linear sector number
! Input:  CH  -  cylinder number
!         CL  -  sector number
!         DH  -  head number
! Output: DX  -  linear sector number
!         carry flag set if invalid sector number
! Registers changed: AX,DX

cvtsec:	push	cx
	cmp	dh,#2			! check if head number is correct
	jae	cvts8			! maximum number of heads is always 2
	mov	dl,dh
	xor	dh,dh			! move current head number into DX
	mov	al,ch
	mov	ch,cl
	mov	ah,cl			! compute track number into AX, the
	mov	cl,#6			! upper two bits of CL are the high
	shr	ah,cl			! bits of the 10 bit cylinder number
	shl	ax,#1			! compute track number from cylinders
	add	ax,dx
	mov	dl,secptk
	xor	dh,dh
	mul	dx			! compute number of track starting
	or	dx,dx			! sector
	jnz	cvts8			! should not be more than 65535 sectors

	mov	dl,ch
	and	dl,#0x3F		! move sector number into AX
	cmp	dl,secptk		! check if sector number is correct
	ja	cvts8
	xor	dh,dh
	dec	dx			! sector numbers start with 1
	js	cvts8			! therefore sector 0 does not exist
	add	dx,ax			! compute final sector number
	jc	cvts8			! should never overflow
	cmp	dx,secnum		! check if the sector is valid
	jae	cvts8
	clc				! no error
	jmp	cvts9
cvts8:	stc				! return with error
cvts9:	pop	cx
	ret



!====================================================================
!
! Read/write a sector from the ram disk. This routine requires a
! sector to be 512 bytes long.
! Input:  AL     -  non-zero if write to ram disk
!         DX     -  logical sector number
!         ES:BX  -  pointer to destination buffer
! Output: carry flag set if error
! Registers changed: AX

rwsect:	push	cx
	push	dx
	mov	ch,al			! save direction indicator
	mov	dx,es
	mov	ax,dx
	mov	cl,#12
	shr	ax,cl
	mov	cl,#4
	shl	dx,cl			! compute linear buffer address
	add	dx,bx
	adc	ax,#0
	or	ch,ch			! check direction of transfer
	jz	rwsec1
	mov	word ptr (rd_srcb+0),dx	! set source address for write
	mov	byte ptr (rd_srcb+2),al
	jmp	rwsec2
rwsec1:	mov	word ptr (rd_dstb+0),dx	! set destination address for read
	mov	byte ptr (rd_dstb+2),al
rwsec2:	pop	dx

	push	dx
	mov	ax,dx
	mov	cl,#9
	shl	dx,cl			! compute linear ramdisk address
	mov	cl,#7			! from sector number
	shr	ax,cl
	add	dx,(rdaddr+0)
	adc	ax,(rdaddr+2)
	or	ch,ch			! check direction of transfer
	jz	rwsec3
	mov	word ptr (rd_dstb+0),dx	! set destination address for write
	mov	byte ptr (rd_dstb+2),al
	jmp	rwsec4
rwsec3:	mov	word ptr (rd_srcb+0),dx	! set source address for read
	mov	byte ptr (rd_srcb+2),al
rwsec4:	push	es
	mov	ax,cs
	mov	es,ax
	mov	si,#rd_gdt
	mov	cx,#SECT_SIZE/2		! copy 512 bytes, e.g. 256 words
	mov	ax,#0x8700		! let the BIOS move the sector
	int	0x15
	pop	es
	pop	dx
	pop	cx
	ret



!====================================================================
!
! Variables for the resident section

old13h:	.long	0			! old interrupt 13h vector
old15h:	.long	0			! old interrupt 15h vector
old2Fh:	.long	0			! old interrupt 2Fh vector

rdaddr:	.long	0			! base address of ram disk
rdsize:	.long	0			! size of ram disk in bytes

rd_gdt:	.word	0,0,0,0
	.word	0,0,0,0
rd_src:	.word	0xffff			! length
rd_srcb:.byte	0,0,0			! base
	.byte	0x93			! typebyte
	.word	0			! limit16,base24 =0
rd_dst:	.word	0xffff			! length
rd_dstb:.byte	0,0,0			! base
	.byte	0x93			! typebyte
	.word	0			! limit16,base24 =0
	.word	0,0,0,0			! BIOS CS
	.word	0,0,0,0			! BIOS DS


! Disk parameters for ram disk

cylnum:	.word	81			! number of cylinders
hdnum:	.byte	2			! number of heads
	.word	0			! starting reduced write current cyl
	.word	0			! starting write precomp cylinder
	.byte	0			! maximum ECC burst length
	.byte	0			! control byte
	.byte	0			! standard timeout
	.byte	0			! formatting timeout
	.byte	0			! timeout for checking drive
	.word	0			! cyl of landing zone
secptk:	.byte	15			! sectors per track
	.byte	0			! reserved
secnum:	.word	2430			! number of sectors on disk

drvnum:	.byte	1			! number of hard disk drives


! Copy of bootp block from bootrom

btplen:	.word	0			! length of bootp block
btpnew:					! bootp block has to be at the very end

