/*
 * common.h  -  Common definitions for all mknbi programs
 *
 * Version 1.0 <Thu Oct  3 18:32:44 MET 1996>
 *
 * Copyright (C) 1996 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 * Some general definitions for compiling on different systems
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef __STDC__
# define voidstar void *
#else
# define voidstar char *
#endif

#include <fcntl.h>
#include <stdio.h>
#ifdef STDC_HEADERS
# include <stdlib.h>
#else
# ifdef HAVE_MALLOC_H
#  include <malloc.h>
# else
voidstar malloc();
void free();
# endif
#endif

#ifndef EXIT_SUCCESS
# define EXIT_SUCCESS 0
#endif
#ifndef EXIT_FAILURE
# define EXIT_FAILUR 1
#endif

#ifdef HAVE_GETOPT_H
# include <getopt.h>
#endif

#include <errno.h>
#ifndef errno
extern int errno;
#endif

#ifdef HAVE_SYS_PARAM_H
# include <sys/param.h>
#endif
#ifndef MAXPATHLEN
# ifdef PATH_MAX
#  define MAXPATHLEN PATH_MAX
# else
#  define MAXPATHLEN 1024
# endif
#endif


/*
 * Check for packed attribute. This is necessary to match some C
 * structures to what the bootrom and the assembler modules expect.
 * Without the packed attribute at least the GNU C compiler aligns
 * byte variables to word boundaries which is not always correct.
 */
#ifdef USE_PACKED
# define PACKED __attribute__((packed))
#else
# define PACKED
#endif


/*
 * sys/types.h and unistd.h are required to include variable types
 * which define certain bit sized units.
 */
#ifdef HAVE_UNISTD_H
# include <sys/types.h>
# include <unistd.h>
#endif


/*
 * Next check for type definitions for 8, 16 and 32 bit variables.
 * The assembler modules expect most values in a specific size, and
 * we must sure that the C programs produce the correct size.
 */
#ifndef USE__UXX
typedef __u8  U8_TYPE;
typedef __u16 U16_TYPE;
typedef __u32 U32_TYPE;
#endif


/*
 * Define some macros to allow a non-intel host system to produce
 * correct byte ordering code for the intel target system.
 */
#define swapbytes(a)    ((((USHORT)(a) & 0x00ff) << 8) | (((USHORT)(a) & 0xff00) >> 8))
#define low_word(a)	((a) & 0x0000ffff)
#define high_word(a)	(((a) >> 16) & 0x0000ffff)
#define get_long(a)	((long)((ttoh((a).high) << 16) | ttoh((a).low)))
#ifndef WORDS_BIGENDIAN
# define htot(a)		((__u16)(a))
# define ttoh(a)		((unsigned short)(a))
#else
# define htot(a)		((__u16)swapbytes(a))
# define ttoh(a)		((unsigned short)swapbytes(a))
#endif


/*
 * Do the usual checks for memory and string handling functions.
 */
#if defined(STDC_HEADERS) || defined(HAVE_STRING_H)
# include <string.h>
# if !defined(STDC_HEADERS) && defined(HAVE_MEMORY_H)
#  include <memory.h>
# endif
#else
# include <strings.h>
# ifndef memcpy
#  define memcpy(D, S, N) bcopy((S), (D), (N))
# endif
# ifndef strchr
#  define strchr(S, C) index ((S), (C))
# endif
# ifndef strrchr
#  define strrchr(S, C) rindex ((S), (C))
# endif
# ifndef bcopy
void bcopy();
# endif
#endif

