;**************************************************************************
;*
;* Boot-ROM-Code to load an operating system across a TCP/IP network.
;*
;* Module:  system.asm
;* Purpose: system management functions for DOS simulator
;* Entries: dos0D, dos0E, dos19, dos1A, dos25, dos2E, dos2F, dos30,
;*          dos34, dos35, dos37, dos54
;*
;**************************************************************************
;*
;* Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
;*
;*  This program is free software; you can redistribute it and/or modify
;*  it under the terms of the GNU General Public License as published by
;*  the Free Software Foundation; either version 2 of the License, or
;*  any later version.
;*
;*  This program is distributed in the hope that it will be useful,
;*  but WITHOUT ANY WARRANTY; without even the implied warranty of
;*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;*  GNU General Public License for more details.
;*
;*  You should have received a copy of the GNU General Public License
;*  along with this program; if not, write to the Free Software
;*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;*


;
;**************************************************************************
;
; Include assembler macros:
;
include ..\..\headers\asm\macros.inc
include ..\..\headers\asm\layout.inc
include ..\..\headers\asm\memory.inc
include .\dospriv.inc


;
;**************************************************************************
;
; Miscellaneous equates:
;
DEF_DTA		equ	0080h		; default DTA address within PSP
DOS_MAJOR	equ	3		; simulate DOS major version 3
DOS_MINOR	equ	2		; simulate DOS minor version 2


;
;**************************************************************************
;
; Data segment
;
data_start

		extrn	curr_psp:word	; current PSP segment
		extrn	dos_active:byte	; DOS active flag

data_end


;
;**************************************************************************
;
; Start code segment.
;
text_start

	public	dos0D, dos0E, dos19		; define entry points
	public	dos1A, dos25, dos2E
	public	dos2F, dos30, dos34
	public	dos35, dos37, dos54


;
;**************************************************************************
;
; Dummy for unused functions.
; Input:  none
; Output: AL  -  zero
; Registers changed: AL
;
dos54		label	near
dos19		label	near
dos0E		label	near

	xor	al,al

dos37		label	near
dos2E		label	near
dos1A		label	near
dos0D		label	near

	ret


;
;**************************************************************************
;
; Set interrupt vector
; Input:  AL     -  interrupt number
;         DS:DX  -  pointer to interrupt routine
; Output: none
; Registers changed: none
;
dos25		proc	near

	push	es
	push	ax
	push	bx
ifdef IS386
	movzx	bx,al
else
	mov	bl,al
	xor	bh,bh
endif
ifdef IS186
	shl	bx,2
else
	shl	bx,1			; convert interrupt number into
	shl	bx,1			; vector address
endif
	xor	ax,ax
	mov	es,ax
	mov	ax,old_ds[bp]
	cli
	mov	es:[bx+0],dx		; save new vector
	mov	es:[bx+2],ax
	sti
	pop	bx
	pop	ax
	pop	es
	ret

dos25		endp


;
;**************************************************************************
;
; Return current DTA.
; Input:  none
; Output: ES:BX  -  address of current DTA
; Registers changed: BX, ES
;
dos2F		proc	near

	mov	es,curr_psp		; return PSP:0080 as the DTA address
	mov	bx,DEF_DTA
	ret

dos2F		endp


;
;**************************************************************************
;
; Return DOS version number. This will return 3.2 as the simulated
; version number.
; Input:  none
; Output: AL  -  major version number
;         AH  -  minor version number
; Registers changed: AX, BX, CX
;
dos30		proc	near

	mov	ax,(DOS_MINOR shl 8) + DOS_MAJOR
	ret

dos30		endp


;
;**************************************************************************
;
; Return address of DOS active byte (undocumented).
; Input:  none
; Output: ES:BX  -  pointer to DOS active byte
; Registers changed:  BX, ES
;
dos34		proc	near

	mov	bx,ds
	mov	es,bx
	mov	bx,offset dgroup:dos_active
	ret

dos34		endp


;
;**************************************************************************
;
; Return interrupt vector.
; Input:  AL     -  vector number
; Output: ES:BX  -  pointer to vector routine
; Registers changed: BX, ES
;
dos35		proc	near

	xor	bx,bx
	mov	es,bx
ifdef IS386
	movzx	bx,al
else
	mov	bl,al
	xor	bh,bh
endif
ifdef IS186
	shl	bx,2
else
	shl	bx,1			; compute pointer to interrupt
	shl	bx,1			; vector
endif
	les	bx,es:[bx]		; get interrupt vector
	ret

dos35		endp


;
;**************************************************************************
;
text_end

	end

