/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  memory.h
 * Purpose: Definitions for boot rom memory layout
 * Entries: None
 *
 **************************************************************************
 *
 * Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * The memory layout of the bootrom looks like this:
 *
 *      +------------------+                     (00000:0)
 *      | Int & BIOS data  |   12kB
 *      +------------------+            OLDINTS  (000C0:0)
 *      | Old int vectors  |    4kB
 *      +------------------+            NEWDATA  (00100:0)
 *      | DOS sim data     |   48kB
 *      +------------------+            LOWMEM   (01000:0)
 *      | OS loading area  |  544kB
 *      +------------------+            HIGHMEM  (09800:0)
 *      | Bootrom code     |   32kB
 *      +------------------+            MEMEND   (0A000:0)
 *      | Video memory     |
 *      | Compressed ROM   |  384kB
 *      | BIOS             |
 *      +------------------+            EXTMEM   (10000:0)
 *      | OS loading area  |
 *      +------------------+            physical end of memory
 *
 *
 * During initialization and decompression of the bootrom code (either
 * out of the real rom or a floppy image), the lower OS loading area
 * looks like this:
 *
 *      +------------------+            LOWMEM   (01000:0)
 *      | Decompressed ROM |   64kB
 *      +------------------+            FLOPMEM  (03000:0)
 *      | Floppy image     |   64kB
 *      +------------------+            FLOPEND  (04000:0)
 *
 **************************************************************************
 *
 * These values have to be the same as those in the corresponding assembler
 * include file!
 */
#define OLDINTS		0x000C0L /* repository for old int vectors	*/
#define NEWDATA		0x00100L /* segment of ram data area		*/
#define LOWMEM		0x01000L /* beginning of OS loading area	*/
#define EXECMEM		0x01000L /* beginning of exec script load area	*/
#define FLOPMEM		0x02000L /* beginning of floppy loading area	*/
#define FLOPEND		0x03000L /* end of floppy loading area		*/
#define HIGHMEM		0x09800L /* end of OS loading area		*/
#define MEMEND		0x0A000L /* end of ram on typical PC system	*/
#define ROMSIZE		0x08000L /* max. size of rom area in bytes	*/
#define RAMSIZE		0x08000L /* minimum size of DOS ram area	*/
#define EXTMEM		0x10000L /* beginning of extended memory area	*/



/*
 **************************************************************************
 *
 * The ROM startup code and the kernel image both need some values
 * inserted at their beginning by binary patch programs. Define the
 * offsets to those values from the beginning of each file.
 *
 * Note that these values have to correspond to the actual offsets
 * in the corresponding assembler files (rom.asm and kernel.asm)!
 */
#define DATAOFS		0x00008L	/* offset to special data	*/

/* Offsets into the ROM startup code */
#define ROMLENOFS	0x00002L	/* offset to rom length byte	*/
#define ROMSIZEOFS	DATAOFS + 0L	/* offset to rom size in bytes	*/
#define ROMMAJOROFS	DATAOFS + 2L	/* offset to major version num	*/
#define ROMMINOROFS	DATAOFS + 3L	/* offset to minor version num	*/
#define ROMSEROFS	DATAOFS + 4L	/* offset to rom serial num	*/

/* Offsets into the kernel code */
#define KRNPRGOFS	DATAOFS + 0L	/* offset to prog list addr	*/
#define KRNSIZEOFS	DATAOFS + 2L	/* offset to kernel size	*/
#define KRNMAJOROFS	DATAOFS + 4L	/* offset to major version num	*/
#define KRNMINOROFS	DATAOFS + 5L	/* offset to minor version num	*/

