;**************************************************************************
;*
;* Boot-ROM-Code to load an operating system across a TCP/IP network.
;*
;* Module:  memory.inc
;* Purpose: Definitions for boot rom memory layout
;* Entries: None
;*
;**************************************************************************
;*
;* Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
;*
;*  This program is free software; you can redistribute it and/or modify
;*  it under the terms of the GNU General Public License as published by
;*  the Free Software Foundation; either version 2 of the License, or
;*  any later version.
;*
;*  This program is distributed in the hope that it will be useful,
;*  but WITHOUT ANY WARRANTY; without even the implied warranty of
;*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;*  GNU General Public License for more details.
;*
;*  You should have received a copy of the GNU General Public License
;*  along with this program; if not, write to the Free Software
;*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;*


;
;**************************************************************************
;
; These values have to be the same as those in the corresponding C header
; file! For an explanation of the memory layout see the C header file.
;
OLDINTS		equ	000C0h		; repository for old int vectors
NEWDATA		equ	00100h		; segment of ram data area
LOWMEM		equ	01000h		; beginning of OS loading area
EXECMEM		equ	01000h		; beginning of exec script load area
FLOPMEM		equ	02000h		; beginning of floppy loading area
FLOPEND		equ	03000h		; end of floppy loading area
HIGHMEM		equ	09800h		; end of OS loading area
MEMEND		equ	0A000h		; end of ram on typical PC system
ROMSIZE		equ	08000h		; size of rom area in bytes
RAMSIZE		equ	08000h		; minimum size of DOS ram area

DATAOFS		equ	00008h		; offset to special data values


;
;**************************************************************************
;
; Size of interrupt vector area:
;
VECTNUM		equ	256		; number of interrupt vectors
VECTSIZE	equ	VECTNUM * 4	; size of vector area

BOOTROM		equ	18h		; ROM entry interrupt vector
BOOTSTRAP	equ	19h		; Bootstrap interrupt vector
OLDBOOTROM	equ	86h		; old ROM entry vector

