/* Copyright (C) 1992, 1993, 1994 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <ansidecl.h>
#include <dirent.h>
#include <stdlib.h>

int
#ifdef linux
DEFUN(scandir, (dir, namelist, select, cmp),
      CONST char *dir AND
      struct dirent ***namelist AND
      __dir_select_fn_t select AND
      __dir_compar_fn_t cmp)
#else
DEFUN(scandir, (dir, namelist, select, cmp),
      CONST char *dir AND
      struct dirent ***namelist AND
      int EXFUN((*select), (struct dirent *)) AND
      int EXFUN((*cmp), (
	CONST struct dirent * CONST *,
	CONST struct dirent * CONST *)))
#endif
{
  DIR *dp = opendir (dir);
  struct dirent **v = NULL;
  size_t vsize = 0, i;
  struct dirent *d;
  int save;

  if (dp == NULL)
    return -1;

  save = errno;
  errno = 0;

  i = 0;
  while ((d = readdir (dp)) != NULL)
    if (select == NULL || (*select) (d))
      {
	if (i == vsize)
	  {
	    struct dirent **new;
	    if (vsize == 0)
	      vsize = 10;
	    else
	      vsize *= 2;
	    new = (struct dirent **) realloc (v, vsize * sizeof (*v));
	    if (new == NULL)
	      {
	      lose:
		(void) closedir (dp);
		while (i > 0)
		  free (v[--i]);
		free (v);
		errno = ENOMEM;
		return -1;
	      }
	    v = new;
	  }

	v[i] = (struct dirent *) malloc (sizeof (**v));
	if (v[i] == NULL)
	  goto lose;

	*v[i++] = *d;
      }

  if (errno != 0)
    {
      save = errno;

      (void) closedir (dp);

      /* Remember to free allocated memory upon error! */
      while (i > 0) free(v[--i]);
      free(v);

      errno = save;
      return -1;
    }

  (void) closedir (dp);
  errno = save;

  /* Sort the list if we have a comparison function to sort with.  */
  if (cmp != NULL)
    qsort (v, i, sizeof (*v), cmp);
  *namelist = v;
  return i;
}
