.\" X-BASED CUBES
.\"
.\" xcubes.man
.\"
.\" ##
.\"
.\" Copyright (c) 1994 - 97	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH CUBES 6 "01 January 1997" "V5.4"
.SH NAME
xcubes \- Cubes X widget
.SH SYNOPSIS
.B /usr/games/xcubes
[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]
[-display [{host}]:[{vs}]]
[-{foreground|fg} <color>] [-{background|bg} <color>]
[-{border|bd} <color>] [-brick <color>] [-{size{x|y|z} <int>]
[-username {string}]
.SH DESCRIPTION
This is basically a 15 puzzle.  The 15 puzzle was originally made around
1879 (the 14-15 puzzle of Sam Loyd was made soon after).  Similar 3D
puzzles include BloxBox; Qrazy Qube (2x2x2) by P. Hein of Denmark and
Varikon Box 'L (3x3x3) (Hungary) and Mad Marbles (3x3x3) by Toys & Games
International USA.
.SH FEATURES
Click "\fBmouse-left\fP" button to move a brick.  Clicks on spaces or
clicks bricks that are not in line with a space will not move the bricks.
Notice one can move more than one brick at a time by clicking on the
brick farthest from the space but in line with the space. Since you
only have a 2-D screen the next level down is either the box to the
right of the current box or the bottom of the current box.
.LP
Click "\fBmouse-right\fP" button, or press "\fBR\fP" or "\fBr\fP" keys,
to randomize the puzzle.  One must double click on "\fBmouse-right\fP" if
the puzzle is currently being worked on.
.LP
Press "\fBI\fP" or "\fBi\fP" keys to move brick in.
.LP
Press "\fBO\fP" or "\fBo\fP" keys to move brick out.
.LP
"\fBS\fP" or "\fBs\fP" keys reserved for the auto-solver (unimplemented).
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo move.
.LP
Press "\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to write or save a puzzle.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys to kill program.
.LP
Use the key pad, "R" keys, or arrow keys to move without the mouse.
.br
Key pad is defined for Cubes as:
.br
  /      Out
.sp
  8      Up
.br
  ^
.br
4<5>6  Left, In, Right
.br
  v
.br
  2      Down
.LP
The control key allows you to change the complexity of xcubes.  Hold
down control key and use the keypad or arrow keys to reduce or enlarge
puzzle complexity.
.LP
The title is in the following format (non-motif version):
.RS
xcubes: <Number of rows>x<Number of columns>x<Number of stacks> @
(<Number of moves>/{<Record number of moves> <username>|"NEVER noaccess"}) -
<Comment>
.RE
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the cubes window (resource
Pname "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the cubes window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the cubes window (resource name
"\fIbackground\fP").
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the bricks in the cubes window
(resource name "\fIborderColor\fP").
.TP 8
.B \-brick \fIcolor\fP
This option specifies the brick color of the bricks in the cubes window
(resource name "\fIbrickColor\fP").
.TP 8
.B \-size{x|y|z} <\fIint\fP>
This option allows you to change the number of cubes in a row, column, or
stack (resource name "\fIsizeA\fP").
.TP 8
.B \-username \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.SH SAVE FORMAT
The format is not standard.  The reason for this is that this is simple and
I do not know what the standard is.
.sp
.RS
sizeX: 1-8 <number of bricks in a row>
.br
sizeY: 1-8 <number of bricks in a column>
.br
sizeZ: 1-8 <number of bricks in a stack>
.br
moves: 0-MAXINT <total number of moves>
.sp
startingPosition: <array of tile positions where 0 is the empty space>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <direction>
.RE
Direction is represented as 0 up, 1 right, 2 down, 3 left, 4 in, and 5
out.
.sp
Caution: the program may crash on corrupted input.
.SH REFERENCES
Sliding Piece Puzzles (Recreations in Mathematics Series) by L. E. Horden,
Oxford University Press 1986, pp 1, 157-159.
.sp
Puzzles Old & New (How to Make and Solve Them) by Jerry Slocum & Jack
Botermans, University of Washington Press, Seattle, 1987, pp 126, 127.
.SH SEE ALSO
.LP
X(1), xrubik(6), xskewb(6), xdino(6), xpyraminx(6), xoct(6), xmball(6),
xmlink(6), xpanex(6), xtriangles(6), xhexagons(6), xabacus(1)
.SH COPYRIGHTS
.LP
\*R Copyright 1994-97, David Albert Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author
.RS
David Albert Bagley,	<\fIbagleyd@bigfoot.com\fP>
.RE
.LP
The most updated source could be found on \fIftp.x.org\fP under
\fI/contrib/games/puzzles\fP.
