/*
  Copyright (C) 1997  Dimitrios P. Bouras

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   For author contact information, look in the README file.
*/

#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include <unistd.h>
#include <string.h>
#include <sys/stat.h>
#include "common.h"

#define OLDVER "-1.2"
#define MAXLEN_OLDVER 4
#define SIZE_OLDF 3632

typedef struct {
	char descr[MAXLEN_DESCR];
	char account[MAXLEN_ACCOUNT+1];
	char passwd[MAXLEN_PASSWD+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[MAXNUM_SLINES][MAXLEN_SLINE+1];
} xisprc_t2;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	unsigned char autoRedial;
	char account[MAXLEN_ACCOUNT+1];
	char passwd[MAXLEN_PASSWD+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[MAXNUM_SLINES][MAXLEN_SLINE+1];
} xisprc_t3;

xisprc_t2 opts2[MAXNUM_ISP];
char *orcfname;
xisprc_t3 opts3[MAXNUM_ISP];
char *rcfname;

#define MSGLEN_ERR 128
void doErr(char *msg)
{
	char emsg[MSGLEN_ERR+1];

	if (errno < sys_nerr)
		sprintf(emsg, "xisprccv: %s: %s\n", msg, sys_errlist[errno]);
	else
		sprintf(emsg, "xisprccv: %s: error #%d\n", msg, errno);
	fputs(emsg, stderr);
	exit(1);
}

void readAllXisprc2(void)
{
	FILE *rcfp;
	int rw;

	rcfp = fopen(rcfname, "r");
	if (rcfp != NULL) {
		rw = fread(opts2, sizeof(xisprc_t2), MAXNUM_ISP, rcfp);
		if (rw != MAXNUM_ISP)
			doErr("readAllXisprc2: fread");
		fclose(rcfp);
	}
	else
		doErr("readAllXisprc2: fopen");
}

void initXisprc3(int rec)
{
	int i;
	xisprc_t2 *p2 = &opts2[rec];
	xisprc_t3 *p3 = &opts3[rec];

	strcpy(p3->descr, p2->descr);
	p3->autoRedial = 0;
	strcpy(p3->account, p2->account);
	strcpy(p3->passwd, p2->passwd);
	p3->maxAttempts = p2->maxAttempts;
	p3->sleepDelay = p2->sleepDelay;
	p3->numPhones = p2->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p3->phone[i], p2->phone[i]);
	p3->numSlines = p2->numSlines;
	for (i=0; i<MAXNUM_SLINES; i++)
		strcpy(p3->sline[i], p2->sline[i]);
}

void writeAllXisprc3(void)
{
	FILE *rcfp;
	int rw, i;

	for (i=0; i<MAXNUM_ISP; i++)
		initXisprc3(i);
	rcfp = fopen(rcfname, "w");
	if (rcfp == NULL)
		doErr("writeAllXisprc3: fopen");
	rw = fwrite(opts3, sizeof(xisprc_t3), MAXNUM_ISP, rcfp);
	if (rw != MAXNUM_ISP)
		doErr("writeAllXisprc3: fwrite");
	fclose(rcfp);
}

void outofMem(void)
{
	fprintf(stderr, "xisprccv: Out of memory!\n");
	exit(-1);
}

void initFnames(void)
{
	struct passwd *user;

	user = getpwuid(getuid());
	rcfname = (char *)malloc(strlen(user->pw_dir)+1+strlen(RCFNAME)+1);
	orcfname = (char *)malloc(strlen(user->pw_dir)+1+strlen(RCFNAME)+
							  MAXLEN_OLDVER+1);
	if (rcfname != NULL && orcfname != NULL) {
		strcpy(rcfname, user->pw_dir); strcat(rcfname, "/");
		strcat(rcfname, RCFNAME);
		strcpy(orcfname, rcfname);
		strcat(orcfname, OLDVER);
	}
	else outofMem();
}

int oldType(void)
{
	struct stat st;

	stat(rcfname, &st);
	return (st.st_size == SIZE_OLDF)? 1:0;
}

int main()
{
	umask(077);
	initFnames();
	if (oldType()) {
		fprintf(stderr, "xisprccv: %s: converted to v1.3\n", rcfname);
		readAllXisprc2();
		rename(rcfname, orcfname);
		writeAllXisprc3();
	}
	else
		fprintf(stderr, "xisprccv: %s: not a v1.2 file!\n", rcfname);
	return 0;
}

