/* main() for xephem.
 * Copyright (c) 1990-1997 by Elwood Charles Downey
 * Permission is granted to make and distribute copies of this program free of
 * charge, provided the copyright notice and this permission notice are
 * preserved on all copies.  All other rights reserved.  No representation is
 * made about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty, to the extent permitted by
 * applicable law.
 */

#include <stdio.h>
#include <signal.h>
#if defined(__STDC__)
#include <stdlib.h>
#endif

#include <X11/Xlib.h>
#include <X11/IntrinsicP.h> /* for XT_REVISION */

/* define WANT_EDITRES if want to try and support X11R5's EditRes feature.
 * this will require linking with -lXmu and -lXext too.
#define WANT_EDITRES
 */
#if defined(WANT_EDITRES) && (XT_REVISION >= 5)
#define	DO_EDITRES
#endif

#ifdef DO_EDITRES
#include <X11/Xmu/Editres.h>
#endif

#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include <Xm/Form.h>
#include <Xm/Separator.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleB.h>

#if XmVersion >= 1002
#include <Xm/RepType.h>
#endif /* XmVersion >= 1002 */


#include "P_.h"
#include "patchlevel.h"

#define	NMINCOL	100	/* min colors we want for the main colormap */

extern Colormap checkCM P_((Colormap cm, int nwant));
extern char *getXRes P_((char *name));
extern void c_manage P_((void));
extern void db_manage P_((void));
extern void dm_create_form P_((void));
extern void dm_manage P_((void));
extern void e_manage P_((void));
extern void fs_manage P_((void));
extern void hlp_dialog P_((char *tag, char *deflt[], int ndeflt));
extern void jm_manage P_((void));
extern void lst_manage P_((void));
extern void m_manage P_((void));
extern void mars_manage P_((void));
extern void mm_external P_((void));
extern void mm_create P_((Widget mainrc));
extern void mm_go_cb P_((Widget w, XtPointer client, XtPointer call));
extern void mm_reset P_((void));
extern void msg_manage P_((void));
extern void obj_manage P_((void));
extern void plot_manage P_((void));
extern void pref_create_pulldown P_((Widget mb_w));
extern void query P_((Widget tw, char *msg, char *label1, char *label2,
    char *label3, void (*func1)(void), void (*func2)(void),
    void (*func3)(void)));
extern void pm_manage P_((void));
extern void set_something P_((Widget w, char *resource, XtArgVal value));
extern void set_xmstring P_((Widget w, char *resource, char *txt));
extern void sm_manage P_((void));
extern void srch_manage P_((void));
extern void ss_manage P_((void));
extern void sv_manage P_((void));
extern void version P_((void));
extern void watch_cursor P_((int want));
extern void wtip P_((Widget w, char *tip));

/* these are used to describe and semi-automate making the main pulldown menus
 */
typedef struct {
    char *tip;		/* tip text, if any */
    char *name;		/* button name, or separator name if !cb */
    			/* N.B. watch for a few special cases */
    char *label;	/* button label (use name if 0) */
    char *acc;		/* button accelerator, if any */
    char *acctext;	/* button accelerator text, if any */
    char mne;		/* button mnemonic */
    void (*cb)();	/* button callback, or NULL if none */
    XtPointer client;	/* button callback client data */
} ButtonInfo;
typedef struct {
    char *tip;		/* tip text, if any */
    char *cb_name;	/* cascade button name */
    char *cb_label;	/* cascade button label (use name if 0) */
    char cb_mne;	/* cascade button mnemonic */
    char *pd_name;	/* pulldown menu name */
    ButtonInfo *bip;	/* array of ButtonInfos, one per button in pulldown */
    int nbip;		/* number of entries in bip[] */
} PullDownMenu;

#define	EXAMPLES_N	"Examples"	/* special ButtonInfo->name */
#define	SEPARATOR_N	"MainSep"	/* special ButtonInfo->name */


static void set_title P_((void));
static void make_main_window P_((void));
static Widget make_pulldown P_((Widget mb_w, PullDownMenu *pdmp));
static void setup_icon P_((void));
static void m_activate_cb P_((Widget w, XtPointer client, XtPointer call));
static void make_examples_pullright P_((Widget pulldown_w, Widget cascade_w));
static void examples_cb P_((Widget w, XtPointer client, XtPointer call));
static void alldone P_((void));
static void x_quit P_((void));


/* client arg to m_activate_cb().
 */
enum {
    PROGRESS, QUIT, XRESET, MSGTXT, EXTIN,
    DATA, MOON, EARTH, MARS, JUPMOON, SATMOON, SKYVIEW, SOLARSYS,
    PLOT, LIST, SEARCH,
    DB, OBJS, FIELDSTARS, CLOSEOBJS, 
    ABOUT, REFERENCES, INTRO, MAINMENU, OPERATION, DATETIME, NOTES
};

Widget toplevel_w;
#define	XtD	XtDisplay(toplevel_w)
Colormap xe_cm;
XtAppContext xe_app;
static char *myclass = "XEphem";

#define xephem_width 50
#define xephem_height 50
static unsigned char xephem_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
   0x00, 0x00, 0xf8, 0xff, 0xff, 0x7f, 0x00, 0x00, 0xc0, 0x07, 0x00, 0x00,
   0xa0, 0x0f, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x10, 0xf0, 0x00, 0x02, 0x00,
   0x00, 0x00, 0x0c, 0x00, 0x01, 0x01, 0x00, 0x00, 0x08, 0x0c, 0x00, 0x02,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x00, 0x0f, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0xf0, 0x0c, 0x00, 0x00,
   0x03, 0x00, 0x00, 0x00, 0x1f, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x1e,
   0x00, 0x30, 0x00, 0xf8, 0x7f, 0x00, 0x3c, 0x00, 0x08, 0xb0, 0x07, 0x80,
   0x07, 0x40, 0x00, 0x04, 0x78, 0x00, 0x00, 0x18, 0x80, 0x00, 0x04, 0x78,
   0x00, 0x00, 0x20, 0x80, 0x00, 0x02, 0x30, 0x00, 0x02, 0x20, 0x00, 0x01,
   0x02, 0x08, 0x80, 0x0f, 0x40, 0x00, 0x01, 0x82, 0x08, 0x00, 0x07, 0x40,
   0x00, 0x01, 0x02, 0x08, 0x80, 0x0f, 0x40, 0x00, 0x01, 0x02, 0x10, 0x00,
   0x02, 0x20, 0x04, 0x01, 0x04, 0x10, 0x00, 0x00, 0x20, 0x80, 0x00, 0x04,
   0x60, 0x00, 0x00, 0x18, 0x80, 0x00, 0x08, 0x80, 0x07, 0x80, 0x07, 0x40,
   0x00, 0x30, 0x00, 0xf8, 0x7f, 0x00, 0x30, 0x00, 0xc0, 0x00, 0x00, 0x00,
   0x00, 0x0c, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x3c,
   0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x0f, 0x00, 0x00,
   0x00, 0x00, 0xfc, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3c,
   0x00, 0x00, 0x00, 0x60, 0xf0, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xf0, 0x0f,
   0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x20, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00};

static String fallbacks[] = {
    "XEphem*AdpDispl.columns: 5",
    "XEphem*AdpDispl.value: 0.0",
    "XEphem*CloseList*textString: work/closelist.txt",
    "XEphem*CloseObjs*List.doubleClickInterval: 500",
    "XEphem*CloseObjs*List.visibleItemCount: 10",
    "XEphem*CloseObjs*Mag.value: 20.0",
    "XEphem*CloseObjs*OmitFixedPairs.set: True",
    "XEphem*CloseObjs*Sep.value: 2.0",
    "XEphem*DBManage*NoDups.set: True",
    "XEphem*DataSelMiscCols.Alt.set: True",
    "XEphem*DataSelMiscCols.Az.set: True",
    "XEphem*DataSelMiscCols.Cns.set: True",
    "XEphem*DataSelMiscCols.Dec.set: True",
    "XEphem*DataSelMiscCols.RA.set: True",
    "XEphem*DataSelRisetCols*Limb.set: True",
    "XEphem*DataSelRisetCols.RiseTm.set: True",
    "XEphem*DataSelRisetCols.SetTm.set: True",
    "XEphem*DataSelRows.Moon.set: True",
    "XEphem*DataSelRows.Sun.set: True",
    "XEphem*Earth*Map.height: 300",
    "XEphem*Earth*Map.width: 500",
    "XEphem*Earth*cylindrical.set: True",
    "XEphem*Earth*grid.set: True",
    "XEphem*Earth*object.set: True",
    "XEphem*Earth*sites.set: True",
    "XEphem*Earth*sunlight.set: True",
    "XEphem*Earth*trail.set: True",
    "XEphem*ExtFile*textString: work/external.txt",
    "XEphem*FieldStars*GSCCDDirectory.value: /cdrom",
    "XEphem*FieldStars*GSCCacheDirectory.value: auxil/gsccache",
    "XEphem*FieldStars*GSCNetHost.value: gastro23.physics.uiowa.edu",
    "XEphem*FieldStars*NoDups.set: True",
    "XEphem*FieldStars*PPMFilename.value: auxil/ppm.xe",
    "XEphem*Help*HelpText.columns: 80",
    "XEphem*Help*HelpText.rows: 24",
    "XEphem*Help.verticalSpacing: 20",
    "XEphem*Jupiter*CtlForm.verticalSpacing: 5",
    "XEphem*Jupiter*LimMag.value: 10",
    "XEphem*Jupiter*Map.height: 200",
    "XEphem*Jupiter*Map.width: 300",
    "XEphem*Jupiter*Scale.value: 50",
    "XEphem*Jupiter*Tags.set: True",
    "XEphem*List*Filename.value: work/ephem.lst",
    "XEphem*ListRC.spacing: 5",
    "XEphem*Mars*LowPrec.set: True",
    "XEphem*Mars.height: 400",
    "XEphem*Mars.width: 400",
    "XEphem*MarsStats*Seeing.maximum: 5",
    "XEphem*MarsStats*Seeing.minimum: 0",
    "XEphem*MarsStats*Seeing.value: 0",
    "XEphem*Message*Messages.columns: 80",
    "XEphem*Message*Messages.rows: 10",
    "XEphem*Message.verticalSpacing: 20",
    "XEphem*Moon*FakeStars.set: True",
    "XEphem*Moon*Scale3X.set: True",
    "XEphem*Moon*Umbra.set: True",
    "XEphem*Moon.height: 400",
    "XEphem*Moon.width: 400",
    "XEphem*MoonES*Earthshine.value: 4",
    "XEphem*Plot*Filename.value: work/ephem.plt",
    "XEphem*PlotDA.foreground: white",
    "XEphem*PlotDA.height: 400",
    "XEphem*PlotDA.width: 400",
    "XEphem*PlotRC.spacing: 5",
    "XEphem*Precision.Hi.set: True",
    "XEphem*Print*Filename.value: work/xephem.ps",
    "XEphem*Print*Grayscale.set: True",
    "XEphem*Print*PrintCmd.value: lpr",
    "XEphem*Print*Save.set: True",
    "XEphem*Progress*DA.foreground: white",
    "XEphem*Progress*DA.height: 50",
    "XEphem*Progress*DA.width: 200",
    "XEphem*Saturn*CtlForm.verticalSpacing: 5",
    "XEphem*Saturn*LimMag.value: 10",
    "XEphem*Saturn*Map.height: 200",
    "XEphem*Saturn*Map.width: 300",
    "XEphem*Saturn*Scale.value: 50",
    "XEphem*Saturn*Tags.set: True",
    "XEphem*SiteSL.visibleItemCount: 10",
    "XEphem*SkyEyep*Elliptical.set: True",
    "XEphem*SkyEyep*EyepH.decimalPoints: 1",
    "XEphem*SkyEyep*EyepH.maximum: 50",
    "XEphem*SkyEyep*EyepH.minimum: 1",
    "XEphem*SkyEyep*EyepH.value: 7",
    "XEphem*SkyEyep*EyepW.decimalPoints: 1",
    "XEphem*SkyEyep*EyepW.maximum: 50",
    "XEphem*SkyEyep*EyepW.minimum: 1",
    "XEphem*SkyEyep*EyepW.value: 7",
    "XEphem*SkyEyep*Lock.set: True",
    "XEphem*SkyEyep*Rectangular.set: False",
    "XEphem*SkyFITS*AutoName.set: True",
    "XEphem*SkyFITS*Header.columns: 40",
    "XEphem*SkyFITS*Header.rows: 8",
    "XEphem*SkyFITS*SaveFN.value: work/xxx.fts",
    "XEphem*SkyFITS.x: 600",
    "XEphem*SkyFITS.y: 10",
    "XEphem*SkyFilter*Binary.set: True",
    "XEphem*SkyFilter*BrightNeb.set: True",
    "XEphem*SkyFilter*ClInNeb.set: True",
    "XEphem*SkyFilter*DarkNeb.set: True",
    "XEphem*SkyFilter*DiffuseNeb.set: True",
    "XEphem*SkyFilter*Double.set: True",
    "XEphem*SkyFilter*EarthSat.set: True",
    "XEphem*SkyFilter*Elliptical.set: True",
    "XEphem*SkyFilter*FaintMagScale.value: 6",
    "XEphem*SkyFilter*GalClusters.set: True",
    "XEphem*SkyFilter*GlobularCl.set: True",
    "XEphem*SkyFilter*Hyperbolic.set: True",
    "XEphem*SkyFilter*MagStep.value: 1",
    "XEphem*SkyFilter*Multiple.set: True",
    "XEphem*SkyFilter*OpenCl.set: True",
    "XEphem*SkyFilter*Parabolic.set: True",
    "XEphem*SkyFilter*PlanetaryNeb.set: True",
    "XEphem*SkyFilter*Planets.set: True",
    "XEphem*SkyFilter*Pulsars.set: True",
    "XEphem*SkyFilter*Quasars.set: True",
    "XEphem*SkyFilter*Radio.set: True",
    "XEphem*SkyFilter*SNRemnants.set: True",
    "XEphem*SkyFilter*SphericalGal.set: True",
    "XEphem*SkyFilter*SpiralGal.set: True",
    "XEphem*SkyFilter*Stars.set: True",
    "XEphem*SkyFilter*Stellar.set: True",
    "XEphem*SkyFilter*SymbolDA.width: 25",
    "XEphem*SkyFilter*Undefined.set: True",
    "XEphem*SkyFilter*Variable.set: True",
    "XEphem*SkyFilter.x: 400",
    "XEphem*SkyFilter.y: 10",
    "XEphem*SkyList*textString: work/skylist.txt",
    "XEphem*SkyOps*AltAzMode.set: True",
    "XEphem*SkyOps*AltDecScale.value: 900",
    "XEphem*SkyOps*AutoMag.set: True",
    "XEphem*SkyOps*CnsFigures.set: True",
    "XEphem*SkyOps*CnsNames.set: True",
    "XEphem*SkyOps*JustDots.set: True",
    "XEphem*SkyOps*LblFldStars.set: True",
    "XEphem*SkyOps*LblNames.set: True",
    "XEphem*SkyOps*MagScale.set: True",
    "XEphem*SkyOps.x: 500",
    "XEphem*SkyOps.y: 10",
    "XEphem*SkyView*AzRAScale.value: 1800",
    "XEphem*SkyView*FOVScale.scaleMultiple: 1",
    "XEphem*SkyView*FOVScale.value: 1800",
    "XEphem*SkyView*Map.height: 500",
    "XEphem*SkyView*Map.width: 500",
    "XEphem*SolarSystem*Ecliptic.set: True",
    "XEphem*SolarSystem*HLatScale.value: 90",
    "XEphem*SolarSystem*Legs.set: True",
    "XEphem*SolarSystem*Names.set: True",
    "XEphem*SolarSystem*SolarDA.foreground: white",
    "XEphem*SolarSystem*SolarDA.height: 300",
    "XEphem*SolarSystem*SolarDA.width: 300",
    "XEphem*SolarSystem*Trails.set: True",
    "XEphem*SolarSystem.DistScale.value: 50",
    "XEphem*SolarSystem.HLatScale.value: 90",
    "XEphem*SrchRC.spacing: 5",
    "XEphem*StdRefr.set: True",
    "XEphem*Trails*CustomInterval.value: 0:30",
    "XEphem*Trails*NTicks.maximum: 200",
    "XEphem*XmFrame.marginHeight: 0",
    "XEphem*XmFrame.marginWidth: 0",
    "XEphem*background: black",
    "XEphem*blinkRate: 0",
    "XEphem*fontList: fixed",
    "XEphem*foreground: white",
    "XEphem*highlightThickness: 0",
    "XEphem*marginHeight: 1",
    "XEphem*marginWidth: 1",
    "XEphem*spacing: 1",
    "XEphem.CnsFont: -*-times-medium-i-*-*-10-*-*-*-*-*-*-*",
    "XEphem.DBFIFO: fifos/xephem_db_fifo",
    "XEphem.DBdirectory: edb",
    "XEphem.DBinitialFiles: Messier.edb YBS.edb",
    "XEphem.DBpattern:  *.edb",
    "XEphem.Elevation: 800",
    "XEphem.Epoch: 2000",
    "XEphem.FITSdirectory: work",
    "XEphem.FITSpattern:  *.f*ts",
    "XEphem.GlassBorderColor: white",
    "XEphem.HELPFILE: auxil/xephem.hlp",
    "XEphem.JupiterGRSColor: black",
    "XEphem.JupiterGRSLongitude: 42",
    "XEphem.Lat: 40:00:00",
    "XEphem.Long: 90:00:00",
    "XEphem.MarsAnnotColor: white",
    "XEphem.MarsDB: auxil/mars_db",
    "XEphem.MarsFile: auxil/marsmap.fts",
    "XEphem.MoonAnnotColor: white",
    "XEphem.MoonDB: auxil/moon_db",
    "XEphem.MoonFile: auxil/moon.fts",
    "XEphem.MoonShadowDim: 4",
    "XEphem.NSteps: 1",
    "XEphem.Pause: 0",
    "XEphem.Pressure: 29.5",
    "XEphem.QuickQuit: False",
    "XEphem.SITESFILE: auxil/xephem_sites",
    "XEphem.SKYINFIFO: fifos/xephem_in_fifo",
    "XEphem.SKYLOCFIFO: fifos/xephem_loc_fifo",
    "XEphem.SKYOUTFIFO: fifos/xephem_out_fifo",
    "XEphem.SkyEyePColor: black",
    "XEphem.SkyEyePDiam: 1",
    "XEphem.StepSize: RTC",
    "XEphem.Temp: 60",
    "XEphem.TwilightDip: 18",
    "XEphem.allowShellResize: True",
    "XEphem.install: guess",
    "XEphem.trailsFont: -*-helvetica-bold-r-*-*-10-*-*-*-*-*-*-*",
    "XEphem.viewsFont: 6x12",
    "XEphem.viewsGreekFont: -*-symbol-*-*-*-*-12-*-*-*-*-*-*-*",
    NULL
};

static XrmOptionDescRec options[] = {
    {"-install", ".install", XrmoptionSepArg, NULL},
};

int
main(argc, argv)
int argc;
char *argv[];
{
	toplevel_w = XtAppInitialize (&xe_app, myclass, options,
			    XtNumber(options), &argc, argv, fallbacks, NULL, 0);
	set_title();

	/* load xe_cm and toplevel_w with default or private colormap */
	xe_cm = checkCM (DefaultColormap(XtD,DefaultScreen(XtD)), NMINCOL);
	set_something (toplevel_w, XmNcolormap, (XtArgVal)xe_cm);

#ifdef DO_EDITRES
	XtAddEventHandler (toplevel_w, (EventMask)0, True,
					_XEditResCheckMessages, NULL);
	xe_msg ("Can editres!\n", 0);
#endif

#if XmVersion >= 1002
	/* install converter so tearOffModel can be set in resource files
	 * to TEAR_OFF_{EN,DIS}ABLED.
	 */
	XmRepTypeInstallTearOffModelConverter();
#endif

	/* ignore FPE, though we do have a matherr() handler in misc.c. */
	(void) signal (SIGFPE, SIG_IGN);

#ifdef SIGPIPE
	/* we deal with write errors directly -- don't want the signal */
	(void) signal (SIGPIPE, SIG_IGN);
#endif

	/* connect up the icon pixmap */
	setup_icon ();

	/* make the main menu bar and form (other stuff is in mainmenu.c) */
	make_main_window ();

	/* define the data table, but don't manage it.
	 * we do this up front to avoid the delay on its first use later.
	 */
	dm_create_form();

	/* here we go */
	XtRealizeWidget(toplevel_w);
	XtAppMainLoop(xe_app);

	printf ("XtAppMainLoop returned :-)\n");
	return (1);
}

/* called to put up or remove the watch cursor.  */
void
main_cursor (c)
Cursor c;
{
	Window win;

	if (toplevel_w && (win = XtWindow(toplevel_w)) != 0) {
	    Display *dsp = XtD;
	    if (c)
		XDefineCursor (dsp, win, c);
	    else
		XUndefineCursor (dsp, win);
	}
}

static void
set_title()
{
	char title[100];

	(void) sprintf (title, "xephem %s", PATCHLEVEL);
	set_something (toplevel_w, XmNtitle, (XtArgVal) title);
}

/* put together the menu bar, the main form, and fill in the form with the
 * initial xephem buttons.
 */
static void
make_main_window ()
{
	static ButtonInfo file_buttons[] = {
	    {"Restore many Main values to original settings",
		"Reset", "Reset", 0, 0, 'R', m_activate_cb, (XtPointer)XRESET},
	    {NULL, SEPARATOR_N},
	    {"Display a dialog containing supporting informational messages",
	        "Messages", "Messages...", 0, 0, 'M', m_activate_cb,
							    (XtPointer)MSGTXT},
	    {"Set up to run xephem Time and Location from an external file",
		"ExtIn", "External Time/Loc...", 0, 0, 'E', m_activate_cb,
							    (XtPointer)EXTIN},
	    {"Display a simple Progress meter",
		"Progress", "Progress Meter...", 0, 0, 'P', m_activate_cb,
							   (XtPointer)PROGRESS},
	    {NULL, SEPARATOR_N},
	    {"Start and stop the main execution loop",
		"Update", "Update", 0, 0, 'U', mm_go_cb, (XtPointer)NULL},
	    {NULL, SEPARATOR_N},
	    {"Exit xephem",
		"Quit", "Quit...", "Ctrl<Key>d", "Ctrl+d", 'Q', m_activate_cb,
							    (XtPointer)QUIT}
	};
	static ButtonInfo view_buttons[] = {
	    {"Display many statistics for any objects",
		"GenData", "Data Table...", 0, 0, 'D', m_activate_cb,
							    (XtPointer)DATA},
	    {NULL, SEPARATOR_N},
	    {"Display an image of Moon and supporting information",
		"Moon", "Moon...", 0, 0, 'M', m_activate_cb, (XtPointer)MOON},
	    {"Display a map of Earth and supporting information",
		"Earth", "Earth...", 0, 0, 'E', m_activate_cb,(XtPointer)EARTH},
	    {"Display an image of Mars and supporting information",
		"Mars", "Mars...", 0, 0, 'r', m_activate_cb, (XtPointer)MARS},
	    {"Display a schematic of Jupiter, GRS, its moons, and other info",
		"Jupiter", "Jupiter...", 0, 0, 'J', m_activate_cb,
							(XtPointer)JUPMOON},
	    {"Display schematic of Saturn, its rings and moons, and other info",
		"Saturn", "Saturn...", 0, 0, 'a', m_activate_cb,
							(XtPointer)SATMOON},
	    {NULL, SEPARATOR_N},
	    {"Display a full-featured map of the night sky",
		"SkyV", "Sky View...", 0, 0, 'V', m_activate_cb,
							    (XtPointer)SKYVIEW},
	    {"Display a map of the solar system",
		"SolSys", "Solar System...", 0, 0, 'S', m_activate_cb,
	    						(XtPointer)SOLARSYS}
	};
	static ButtonInfo ctrl_buttons[] = {
	    {"Capture any xephem values for making and displaying plots",
		"Plot", "Plot...", 0, 0, 'P', m_activate_cb, (XtPointer)PLOT},
	    {"Capture any xephem values in a tabular text file",
		"List", "List...", 0, 0, 'L', m_activate_cb, (XtPointer)LIST},
	    {"Build any equation of xephem fields and solve for min, max or 0",
		"Solve", "Solve...", 0, 0, 'S', m_activate_cb,(XtPointer)SEARCH}
	};
	static ButtonInfo objs_buttons[] = {
	    {"Load .edb files into memory, list current memory, or delete",
		"DataBase", "Load and Delete...",0, 0, 'D', m_activate_cb,
								(XtPointer)DB},
	    {"Search memory for an object, view definitions, assign ObjXYZ",
		"ObjX_Y", "Search and ObjXYZ...", 0, 0,'S', m_activate_cb,
							    (XtPointer)OBJS},
	    {"Define where GSC and PPM catalogs are to be found",
		"FieldStars", "Setup Field Stars...", 0, 0,'F', m_activate_cb,
	    						(XtPointer)FIELDSTARS},
	    {"Find all pairs of close objects in memory",
		"CloseObjs", "Find Close Pairs...", 0, 0, 'C', m_activate_cb,
							(XtPointer)CLOSEOBJS}
	};
	static ButtonInfo help_buttons[] = {
	    {"Overall features of xephem",
		"Introduction", "Introduction...", 0, 0, 'I', m_activate_cb,
							    (XtPointer)INTRO},
	    {NULL, SEPARATOR_N},
	    {"Description of fields within this Main xephem menu",
		"onMainMenu", "on Main Menu...", 0, 0, 'M', m_activate_cb,
							(XtPointer)MAINMENU},
	    {"How to control xephem's running behavior, including looping",
		"onOperation", "on Operation...", 0, 0, 'O', m_activate_cb,
							(XtPointer)OPERATION},
	    {"Shortcuts to setting date and time formats",
		"onTriad", "on Triad formats...", 0, 0, 'T', m_activate_cb,
							(XtPointer)DATETIME},
	    {NULL, SEPARATOR_N},
	    {NULL, EXAMPLES_N, "Examples", 0, 0, 'E'},
	    {"Credits, references and other kudos.",
		"onReferences", "Credits...",  0, 0, 'C', m_activate_cb,
							(XtPointer)REFERENCES},
	    {"A few supporting issues",
		"Notes", "Notes...", 0, 0, 'N', m_activate_cb,(XtPointer)NOTES},
	    {"Version, copyright, logo",
		"About", "About...", 0, 0, 'A', m_activate_cb, (XtPointer)ABOUT}
	};
	static PullDownMenu file_pd =
	    {"Overall control functions",
		"File", 0, 'F', "file_pd", file_buttons,XtNumber(file_buttons)};
	static PullDownMenu view_pd =
	    {"Major display options",
		"View", 0, 'V', "view_pd", view_buttons,XtNumber(view_buttons)};
	static PullDownMenu ctrl_pd =
	    {"Supporting analysis tools",
		"Tools", 0,'T',"ctrl_pd",ctrl_buttons,XtNumber(ctrl_buttons)};
	static PullDownMenu objs_pd =
	    {"Add, delete and inspect objects in memory",
		"Objects", 0,'O',"objs_pd",objs_buttons,XtNumber(objs_buttons)};
	static PullDownMenu help_pd =
	    {"Additional information about xephem and the Main display",
		"Help", 0, 'H', "help_pd", help_buttons,XtNumber(help_buttons)};
	    
	Widget mainrc;
	Widget mb_w;
	Widget cb_w;
	Arg args[20];
	int n;

	/*	Create main window as a vertical r/c  */
	n = 0;
	XtSetArg (args[n], XmNmarginHeight, 0); n++;
	XtSetArg (args[n], XmNmarginWidth, 0); n++;
	mainrc = XmCreateRowColumn (toplevel_w, "XephemMain", args, n);
	XtAddCallback (mainrc, XmNhelpCallback, m_activate_cb,
							(XtPointer)MAINMENU);
	XtManageChild (mainrc);

	/*	Create MenuBar in mainrc  */

	n = 0;
	mb_w = XmCreateMenuBar (mainrc, "MainMB", args, n); 
	XtManageChild (mb_w);

	    /* create each pulldown */

	    (void) make_pulldown (mb_w, &file_pd);
	    (void) make_pulldown (mb_w, &view_pd);
	    (void) make_pulldown (mb_w, &ctrl_pd);
	    (void) make_pulldown (mb_w, &objs_pd);
	    pref_create_pulldown (mb_w);
	    cb_w = make_pulldown (mb_w, &help_pd);

	    n = 0;
	    XtSetArg (args[n], XmNmenuHelpWidget, cb_w);  n++;
	    XtSetValues (mb_w, args, n);

	/* add the remainder of the main window */

	mm_create (mainrc);
}

/* create/manage a cascade button with a pulldown menu off a menu bar.
 * return the cascade button.
 * N.B. watch for special bip->name.
 */
static Widget
make_pulldown (mb_w, pdmp)
Widget mb_w;
PullDownMenu *pdmp;
{
	Widget pulldown_w;
	Widget button;
	Widget cascade;
	XmString accstr, labstr;
	Arg args[20];
	int n;
	int i;

	/* make the pulldown menu */

	n = 0;
	pulldown_w = XmCreatePulldownMenu (mb_w, pdmp->pd_name, args, n);

	/* fill it with buttons and/or separators */

	for (i = 0; i < pdmp->nbip; i++) {
	    ButtonInfo *bip = &pdmp->bip[i];
	    int examples = !strcmp (bip->name, EXAMPLES_N);
	    int separator = !strcmp (bip->name, SEPARATOR_N);

	    if (separator) {
		Widget s = XmCreateSeparator (pulldown_w, bip->name, args, n);
		XtManageChild (s);
		continue;
	    }

	    accstr = NULL;
	    labstr = NULL;

	    n = 0;
	    if (bip->acctext && bip->acc) {
		accstr = XmStringCreate(bip->acctext, XmSTRING_DEFAULT_CHARSET);
		XtSetArg (args[n], XmNacceleratorText, accstr); n++;
		XtSetArg (args[n], XmNaccelerator, bip->acc); n++;
	    }
	    if (bip->label) {
		labstr = XmStringCreate (bip->label, XmSTRING_DEFAULT_CHARSET);
		XtSetArg (args[n], XmNlabelString, labstr); n++;
	    }
	    XtSetArg (args[n], XmNmnemonic, bip->mne); n++;
	    if (examples)
		button = XmCreateCascadeButton (pulldown_w, bip->name, args, n);
	    else
		button = XmCreatePushButton (pulldown_w, bip->name, args, n);
	    XtManageChild (button);
	    if (bip->cb)
		XtAddCallback (button, XmNactivateCallback, bip->cb,
							(XtPointer)bip->client);
	    if (accstr)
		XmStringFree (accstr);
	    if (labstr)
		XmStringFree (labstr);

	    if (examples)
		make_examples_pullright (pulldown_w, button);
	    if (bip->tip)
		wtip (button, bip->tip);
	}

	/* create a cascade button and glue them together */

	labstr = NULL;

	n = 0;
	if (pdmp->cb_label) {
	    labstr = XmStringCreate (pdmp->cb_label, XmSTRING_DEFAULT_CHARSET);
	    XtSetArg (args[n], XmNlabelString, labstr);  n++;
	}
	XtSetArg (args[n], XmNsubMenuId, pulldown_w);  n++;
	XtSetArg (args[n], XmNmnemonic, pdmp->cb_mne); n++;
	cascade = XmCreateCascadeButton (mb_w, pdmp->cb_name, args, n);
	if (labstr)
	    XmStringFree (labstr);
	XtManageChild (cascade);
	if (pdmp->tip)
	    wtip (cascade, pdmp->tip);

	return (cascade);
}

static void
setup_icon ()
{
	Display *dsp = XtDisplay (toplevel_w);
	Window win = RootWindow (dsp, DefaultScreen(dsp));
	Pixmap pm = XCreateBitmapFromData (dsp, win, (char *)xephem_bits,
						xephem_width, xephem_height);

	set_something (toplevel_w, XmNiconPixmap, (XtArgVal)pm);
}


/* ARGSUSED */
static void
m_activate_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	int code = (int)client;

	watch_cursor(1);

	switch (code) {
	case XRESET:	mm_reset(); break;
	case MSGTXT:	msg_manage(); break;
	case EXTIN:	mm_external(); break;
	case PROGRESS:	pm_manage(); break;
	case QUIT:	x_quit(); break;
	case DATA:	dm_manage(); break;
	case EARTH:	e_manage(); break;
	case MOON:	m_manage(); break;
	case MARS:	mars_manage(); break;
	case JUPMOON:	jm_manage(); break;
	case SATMOON:	sm_manage(); break;
	case SKYVIEW:	sv_manage(); break;
	case SOLARSYS:	ss_manage(); break;
	case PLOT:	plot_manage(); break;
	case LIST:	lst_manage(); break;
	case SEARCH:	srch_manage(); break;
	case OBJS:	obj_manage(); break;
	case DB:	db_manage(); break;
	case CLOSEOBJS:	c_manage(); break;
	case FIELDSTARS:fs_manage(); break;
	case ABOUT:	version(); break;
	case REFERENCES:hlp_dialog ("Credits", NULL, 0); break;
	case INTRO:	hlp_dialog ("Intro", NULL, 0); break;
	case MAINMENU:	hlp_dialog ("MainMenu", NULL, 0); break;
	case OPERATION:	hlp_dialog ("Operation", NULL, 0); break;
	case DATETIME:	hlp_dialog ("Date/time", NULL, 0); break;
	case NOTES:	hlp_dialog ("Notes", NULL, 0); break;
	default: 	printf ("Main menu bug: code=%d\n", code); exit(1);
	}

	watch_cursor(0);
}


/* build the examples pullright off the help pulldown driven by cascade_w */
static void
make_examples_pullright (pulldown_w, cascade_w)
Widget pulldown_w;
Widget cascade_w;
{
	typedef struct {
	    char *tip;		/* tip text */
	    char *label;	/* what goes on the help label */
	    char *key;		/* string to call hlp_dialog() */
	} HelpOn;
	static HelpOn helpon[] = {
	    {"Explore tonight's sky with the Sky View",
		"Tonight's sky",	 "Example - whats up"},
	    {"Display a solar eclipse path on the Earth map",
		"Solar eclipse path",	 "Example - eclipse path"},
	    {"Making trails and using the Hubble GSC field stars",
		"Sky trail and GSC","Example - sky trail"},
	    {"Display a FITS file or retrieve a DSS image over the Internet",
		"Displaying images","Example - images"},
	    {"Make a plot of local sunrise times over the span of one year",
		"Sunrise Plot",	 "Example - sun plot"},
	    {"Solve for a Saturn ring-plane crossing event",
		"Ring crossing",	 "Example - ring plane"},
	    {"Display the moon overtaking a star",
		"Lunar occultation","Example - lunar occultation"},
	};
	Widget pd_w;
	Widget w;
	Arg args[20];
	int n;
	int i;

	n = 0;
	pd_w = XmCreatePulldownMenu (pulldown_w, "ExPD", args, n);

	for (i = 0; i < XtNumber(helpon); i++) {
	    HelpOn *hop = &helpon[i];

	    n = 0;
	    w = XmCreatePushButton (pd_w, "ExPB", args, n);
	    XtAddCallback (w, XmNactivateCallback, examples_cb,
						    (XtPointer)(hop->key));
	    set_xmstring (w, XmNlabelString, hop->label);
	    wtip (w, hop->tip);
	    XtManageChild (w);
	}

	n = 0;
	XtSetArg (args[n], XmNsubMenuId, pd_w);  n++;
	XtSetValues (cascade_w, args, n);
	wtip (cascade_w, "Step-by-step examples using several xephem features");
}

/* called from any of the Help->Example entries.
 * client is a tag for hlp_dialog().
 */
/* ARGSUSED */
static void
examples_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	char *tag = (char *)client;

	hlp_dialog (tag, NULL, 0);
}

/* outta here */
static void
alldone()
{
	XtCloseDisplay (XtDisplay (toplevel_w));
	exit(0);
}

/* user wants to quit -- confirm unless QuickQuit is set */
static void
x_quit()
{
	char *qq;

	qq = getXRes ("QuickQuit");
	if (qq && (atoi(qq)==1 || !strcmp(qq,"True") || !strcmp(qq,"true")))
	    alldone();

	query (toplevel_w, "Quit xephem?", "Yes -- quit", "No -- resume", 0,
								alldone, 0, 0);

	/* if this query returns, we just resume */
}
