#!/usr/local/bin/perl

require './webmin-lib.pl';

opendir(DIR, "..");
foreach $d (readdir(DIR)) {
	local %minfo;
	if (%minfo = &get_module_info($d)) {
		if (!&check_os_support(\%minfo)) {
			# This OS is not supported!
			next;
			}
		push(@modules, \%minfo);
		}
	}
closedir(DIR);
@modules = sort { $a->{'desc'} cmp $b->{'desc'} } @modules;
&read_file("$config_directory/webmin.catnames", \%catnames);

&header($text{'assignment_title'}, undef);
print qq(
<hr>
$text{'assignment_desc'}<p>
<form action="save_assignment.cgi">
<table border><tr $tb>
<td><b>$text{'assignment_header'}</b></td></tr>
<tr $cb><td><table>
);
foreach ( @modules ){
    $a++;
    print "<tr></tr>" if $a%2;
    print qq(<td>$_->{desc}</td><td>), &cats($_->{dir}, $_->{category}), "</td>\n";
}

print qq(
</td></tr></table>
</td></tr></table>
<input type=submit value="$text{'assignment_ok'}">
</form><hr>
);
&footer("/", $text{'index'});

sub cats {
    my $cats;
    my %cats;
    foreach (keys %text) {
	next unless /^category_/;
	my $desc = $text{$_};
	s/^category_//;
	$cats{$_} = $desc;
	}
    foreach (keys %catnames) {
	$cats{$_} = $catnames{$_};
	}
    foreach $c (sort { $cats{$a} cmp $cats{$b} } keys %cats) {
	$cats .= sprintf "<option value='%s' %s>%s\n",
			$c, $_[1] eq $c ? 'selected' : '', $cats{$c};
	}
    $cats = qq(<select name="$_[0]">$cats\n</select>\n);
}
