#!/usr/local/bin/perl

require "./inittab-lib.pl";

&ReadParse();

&error( $text{ 'save_inittab_err' } ) if( !$access{ 'inittab' } );
&error( $text{ 'save_inittab_noid' } ) if( !$in{ 'id' } );

&lock_file($config{ 'inittab_file' });
$file = &read_file_lines( $config{ 'inittab_file' } );
$number = -1;

for($i=0; $i<@$file; $i++)
{
    $line = $file->[$i];
    $line =~ s/\r|\n//g;
    $line =~ s/#.*$//g;
    $line =~ s/\/\/.*$//g;

    if( $line )
    {
	local $si = $i;

	while($line =~ /\\$/)
	{
		local $nl = $file->[++$i];
		$line =~ s/\\$//;
		$nl =~ s/^\s+//;
		$line .= $nl;
	}

        local ( $id ) = split( /:/, $line );
	if ($id eq $in{ 'oldid' })
	{
		$number = $si;
		$enumber = $i;
	}

	if( $in{ 'id' } ne $in{ 'oldid' } && $id eq $in{ 'id' } )
	{
	    &error( $text{ 'save_inittab_already' } );
	}
    }
}

if( $in{ 'button' } eq $text{ 'edit_inittab_del' } )
{
    splice( @$file, $number, $enumber-$number+1 );
}
elsif( $in{ 'button' } eq $text{ 'edit_inittab_save' } )
{
    local $new = $in{ 'id' }. ":";
    foreach ( 0..6, "a", "b", "c" )
    {
	$new .= $_ if( $in{ $_ } eq "1" );
    }
    $new .= ":". $in{ 'action' }. ":". $in{ 'process' };

    if( $number == -1 )
    {
	push( @$file, $new );
    }
    else
    {
	splice( @$file, $number, $enumber-$number+1, $new);
    }
}

&flush_file_lines();
&unlock_file($config{ 'inittab_file' });
if ( $in{ 'button' } eq $text{ 'edit_inittab_del' }) {
	&webmin_log("delete", "inittab", $in{ 'oldid' }, \%in);
	}
elsif ( $number == -1 ) {
	&webmin_log("create", "inittab", $in{ 'id' }, \%in);
	}
else {
	&webmin_log("modify", "inittab", $in{ 'id' }, \%in);
	}

&redirect( "/inittab/index.cgi" );
