/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import de.mud.ssh.MD5;
import de.mud.ssh.SshCrypto;
import de.mud.ssh.SshMisc;
import de.mud.ssh.SshPacket;
import java.io.IOException;
import java.util.Date;

public abstract class SshIO {
    private MD5 md5 = new MD5();
    private String identification_string = "";
    private String identification_string_sent = "SSH-1.5-Java Ssh 1.1 (16/09/99) leo@mud.de, original by Cedric Gourio (javassh@france-mail.com)\n";
    private static int debug = 0;
    private boolean encryption = false;
    private SshCrypto crypto;
    SshPacket lastPacketReceived;
    String cipher_type = "IDEA";
    private String login = "";
    private String password = "";
    public String dataToSend = null;
    public String hashHostKey = null;
    byte lastPacketSentType;
    private int phase = 0;
    private final int PHASE_INIT = 0;
    private final int PHASE_SSH_RECEIVE_PACKET = 1;
    private final int SSH_MSG_DISCONNECT = 1;
    private final int SSH_SMSG_PUBLIC_KEY = 2;
    private final int SSH_CMSG_SESSION_KEY = 3;
    private final int SSH_CMSG_USER = 4;
    private final int SSH_CMSG_AUTH_PASSWORD = 9;
    private final int SSH_CMSG_REQUEST_PTY = 10;
    private final int SSH_CMSG_EXEC_SHELL = 12;
    private final int SSH_SMSG_SUCCESS = 14;
    private final int SSH_SMSG_FAILURE = 15;
    private final int SSH_CMSG_STDIN_DATA = 16;
    private final int SSH_SMSG_STDOUT_DATA = 17;
    private final int SSH_SMSG_STDERR_DATA = 18;
    private final int SSH_SMSG_EXITSTATUS = 20;
    private final int SSH_CMSG_EXIT_CONFIRMATION = 33;
    private final int SSH_MSG_DEBUG = 36;
    private int position = 0;
    private int SSH_CIPHER_NONE = 0;
    private int SSH_CIPHER_IDEA = 1;
    private int SSH_CIPHER_DES = 2;
    private int SSH_CIPHER_3DES = 3;
    private int SSH_CIPHER_TSS = 4;
    private int SSH_CIPHER_RC4 = 5;
    private int SSH_CIPHER_BLOWFISH = 6;
    private final int SSH_AUTH_RHOSTS = 1;
    private final int SSH_AUTH_RSA = 2;
    private final int SSH_AUTH_PASSWORD = 3;
    private final int SSH_AUTH_RHOSTS_RSA = 4;
    private boolean cansenddata = false;
    byte[] one = new byte[1];

    public void setLogin(String user) {
        if (user == null) {
            user = "";
        }
        this.login = user;
    }

    public void setPassword(String password) {
        if (password == null) {
            password = "";
        }
        this.password = password;
    }

    public synchronized byte[] handleSSH(byte[] b) throws IOException {
        byte[] result = this.packetDone(this.handleBytes(b, 0, b.length));
        while (this.lastPacketReceived != null && this.lastPacketReceived.toBeFinished) {
            byte[] rest;
            byte[] buff = this.lastPacketReceived.unfinishedBuffer;
            int start = this.lastPacketReceived.positionInUnfinishedBuffer;
            if (buff == null || (rest = this.packetDone(this.handleBytes(buff, start, buff.length))) == null) continue;
            if (result != null) {
                byte[] tmp = new byte[rest.length + result.length];
                System.arraycopy(result, 0, tmp, 0, result.length);
                System.arraycopy(rest, 0, tmp, result.length, rest.length);
                result = tmp;
                continue;
            }
            result = rest;
        }
        return result;
    }

    private byte[] packetDone(SshPacket packet) throws IOException {
        if (packet == null) {
            return null;
        }
        this.lastPacketReceived = packet;
        byte[] result = this.handlePacket(this.lastPacketReceived.getType(), this.lastPacketReceived.getData());
        return result;
    }

    protected abstract void write(byte[] var1) throws IOException;

    public abstract String getTerminalType();

    private void write(byte b) throws IOException {
        this.one[0] = b;
        this.write(this.one);
    }

    public void disconnect() {
        this.login = "";
        this.password = "";
        this.phase = 0;
        this.encryption = false;
        this.lastPacketReceived = null;
    }

    public synchronized void sendData(String str) throws IOException {
        if (debug > 1) {
            System.out.println("SshIO.send(" + str + ")");
        }
        this.dataToSend = this.dataToSend == null ? str : this.dataToSend + str;
        if (this.cansenddata) {
            this.Send_SSH_CMSG_STDIN_DATA(this.dataToSend);
            this.dataToSend = null;
        }
    }

    private SshPacket handleBytes(byte[] buff, int offset, int count) throws IOException {
        if (debug > 1) {
            System.out.println("SshIO.getPacket(" + buff + "," + count + ")");
        }
        int boffset = offset;
        while (boffset < count) {
            byte b = buff[boffset++];
            switch (this.phase) {
                case 0: {
                    this.identification_string = this.identification_string + (char)b;
                    if (b != 10) break;
                    ++this.phase;
                    this.write(this.identification_string_sent.getBytes());
                    this.position = 0;
                    byte[] data = SshMisc.createString(this.identification_string);
                    byte packet_type = 17;
                    return this.createPacket(packet_type, data);
                }
                case 1: {
                    SshPacket result = this.lastPacketReceived.getPacketfromBytes(buff, boffset - 1, count, this.encryption, this.crypto);
                    return result;
                }
            }
        }
        return null;
    }

    private SshPacket createPacket(byte newType, byte[] newData) throws IOException {
        return new SshPacket(newType, newData, this.encryption, this.crypto);
    }

    private byte[] handlePacket(byte packetType, byte[] packetData) throws IOException {
        int boffset = 0;
        if (debug > 0) {
            System.out.println("1 packet to handle, type " + packetType);
        }
        switch (packetType) {
            case 1: {
                String str = SshMisc.getString(boffset, packetData);
                this.disconnect();
                return str.getBytes();
            }
            case 2: {
                byte[] anti_spoofing_cookie = new byte[8];
                byte[] server_key_bits = new byte[4];
                byte[] host_key_bits = new byte[4];
                byte[] protocol_flags = new byte[4];
                byte[] supported_ciphers_mask = new byte[4];
                byte[] supported_authentications_mask = new byte[4];
                int i = 0;
                while (i <= 7) {
                    anti_spoofing_cookie[i] = packetData[boffset++];
                    ++i;
                }
                int i2 = 0;
                while (i2 <= 3) {
                    server_key_bits[i2] = packetData[boffset++];
                    ++i2;
                }
                byte[] server_key_public_exponent = SshMisc.getMpInt(boffset, packetData);
                byte[] server_key_public_modulus = SshMisc.getMpInt(boffset += server_key_public_exponent.length + 2, packetData);
                boffset += server_key_public_modulus.length + 2;
                int i3 = 0;
                while (i3 <= 3) {
                    host_key_bits[i3] = packetData[boffset++];
                    ++i3;
                }
                byte[] host_key_public_exponent = SshMisc.getMpInt(boffset, packetData);
                byte[] host_key_public_modulus = SshMisc.getMpInt(boffset += host_key_public_exponent.length + 2, packetData);
                boffset += host_key_public_modulus.length + 2;
                int i4 = 0;
                while (i4 < 4) {
                    protocol_flags[i4] = packetData[boffset++];
                    ++i4;
                }
                int i5 = 0;
                while (i5 < 4) {
                    supported_ciphers_mask[i5] = packetData[boffset++];
                    ++i5;
                }
                int i6 = 0;
                while (i6 < 4) {
                    supported_authentications_mask[i6] = packetData[boffset++];
                    ++i6;
                }
                byte[] ret = this.Send_SSH_CMSG_SESSION_KEY(anti_spoofing_cookie, server_key_public_modulus, host_key_public_modulus, supported_ciphers_mask, server_key_public_exponent, host_key_public_exponent);
                if (ret != null) {
                    return ret;
                }
                if (this.hashHostKey == null || this.hashHostKey.compareTo("") == 0) break;
                byte[] Md5_hostKey = this.md5.hash(host_key_public_modulus);
                String hashHostKeyBis = "";
                int i7 = 0;
                while (i7 < Md5_hostKey.length) {
                    String hex = "";
                    int[] v = new int[]{(Md5_hostKey[i7] & 0xF0) >> 4, Md5_hostKey[i7] & 0xF};
                    int j = 0;
                    while (j < 1) {
                        switch (v[j]) {
                            case 10: {
                                hex = hex + "a";
                                break;
                            }
                            case 11: {
                                hex = hex + "b";
                                break;
                            }
                            case 12: {
                                hex = hex + "c";
                                break;
                            }
                            case 13: {
                                hex = hex + "d";
                                break;
                            }
                            case 14: {
                                hex = hex + "e";
                                break;
                            }
                            case 15: {
                                hex = hex + "f";
                                break;
                            }
                            default: {
                                hex = hex + String.valueOf(v[j]);
                            }
                        }
                        ++j;
                    }
                    hashHostKeyBis = hashHostKeyBis + hex;
                    ++i7;
                }
                if (hashHostKeyBis.compareTo(this.hashHostKey) == 0) break;
                this.password = "";
                this.login = "";
                return "\nHash value of the host key not correct \r\nlogin & password have been reset \r\n- erase the 'hashHostKey' parameter in the Html\r\n(it is used for auhentificating the server and prevent you from connecting \r\nto any other)\r\n".getBytes();
            }
            case 14: {
                if (debug > 0) {
                    System.out.println("SSH_SMSG_SUCCESS (last packet was " + this.lastPacketSentType + ")");
                }
                if (this.lastPacketSentType == 3) {
                    this.Send_SSH_CMSG_USER();
                    break;
                }
                if (this.lastPacketSentType == 4) {
                    this.Send_SSH_CMSG_REQUEST_PTY();
                    return "\nEmpty password login.\r\n".getBytes();
                }
                if (this.lastPacketSentType == 9) {
                    System.out.println("login succesful");
                    this.Send_SSH_CMSG_REQUEST_PTY();
                    return "\nLogin & password accepted\r\n".getBytes();
                }
                if (this.lastPacketSentType == 10) {
                    this.cansenddata = true;
                    if (this.dataToSend != null) {
                        this.Send_SSH_CMSG_STDIN_DATA(this.dataToSend);
                        this.dataToSend = null;
                    }
                    this.Send_SSH_CMSG_EXEC_SHELL();
                    break;
                }
                if (this.lastPacketSentType != 12) break;
                break;
            }
            case 15: {
                if (this.lastPacketSentType == 9) {
                    System.out.println("failed to log in");
                    this.disconnect();
                    return "\nLogin & password not accepted\r\n".getBytes();
                }
                if (this.lastPacketSentType == 4) {
                    this.Send_SSH_CMSG_AUTH_PASSWORD();
                    break;
                }
                if (this.lastPacketSentType != 10) break;
                break;
            }
            case 17: {
                String str = SshMisc.getString(0, packetData);
                return str.getBytes();
            }
            case 18: {
                String str = "Error : " + SshMisc.getString(0, packetData);
                System.out.println("SshIO.handlePacket : STDERR_DATA " + str);
                return str.getBytes();
            }
            case 20: {
                int value = (packetData[0] << 24) + (packetData[1] << 16) + (packetData[2] << 8) + packetData[3];
                this.Send_SSH_CMSG_EXIT_CONFIRMATION();
                System.out.println("SshIO : Exit status " + value);
                this.disconnect();
                break;
            }
            case 36: {
                String str = SshMisc.getString(0, packetData);
                if (debug > 0) {
                    System.out.println("SshIO.handlePacket :  DEBUG " + str);
                    return str.getBytes();
                }
                return "".getBytes();
            }
            default: {
                System.err.print("SshIO.handlePacket : Packet Type unknown: " + packetType);
            }
        }
        return null;
    }

    private void sendPacket(SshPacket packet) throws IOException {
        this.write(packet.getBytes());
        this.lastPacketSentType = packet.getType();
    }

    private byte[] Send_SSH_CMSG_SESSION_KEY(byte[] anti_spoofing_cookie, byte[] server_key_public_modulus, byte[] host_key_public_modulus, byte[] supported_ciphers_mask, byte[] server_key_public_exponent, byte[] host_key_public_exponent) throws IOException {
        byte cipher_types;
        byte[] session_id_byte = new byte[host_key_public_modulus.length + server_key_public_modulus.length + anti_spoofing_cookie.length];
        System.arraycopy(host_key_public_modulus, 0, session_id_byte, 0, host_key_public_modulus.length);
        System.arraycopy(server_key_public_modulus, 0, session_id_byte, host_key_public_modulus.length, server_key_public_modulus.length);
        System.arraycopy(anti_spoofing_cookie, 0, session_id_byte, host_key_public_modulus.length + server_key_public_modulus.length, anti_spoofing_cookie.length);
        byte[] hash_md5 = this.md5.hash(session_id_byte);
        if ((supported_ciphers_mask[3] & (byte)(1 << this.SSH_CIPHER_BLOWFISH)) != 0) {
            cipher_types = (byte)this.SSH_CIPHER_BLOWFISH;
            this.cipher_type = "Blowfish";
        } else if ((supported_ciphers_mask[3] & 1 << this.SSH_CIPHER_IDEA) != 0) {
            cipher_types = (byte)this.SSH_CIPHER_IDEA;
            this.cipher_type = "IDEA";
        } else if ((supported_ciphers_mask[3] & 1 << this.SSH_CIPHER_3DES) != 0) {
            cipher_types = (byte)this.SSH_CIPHER_3DES;
            this.cipher_type = "DES3";
        } else {
            System.err.println("SshIO: remote server does not supported IDEA or BlowFish, support cypher mask is " + supported_ciphers_mask[3] + ".\n");
            this.disconnect();
            return "\rRemote server does not support IDEA / Blowfish blockcipher, closing connection.\r\n".getBytes();
        }
        System.out.println("SshIO: Using " + this.cipher_type + " blockcipher.\n");
        byte[] random_bits1 = new byte[16];
        byte[] random_bits2 = new byte[16];
        random_bits1 = this.md5.hash("" + Math.random() * (double)new Date().getTime());
        random_bits2 = random_bits1;
        random_bits1 = this.md5.hash(SshMisc.addArrayOfBytes(this.md5.hash(this.password + this.login), random_bits1));
        random_bits2 = this.md5.hash(SshMisc.addArrayOfBytes(this.md5.hash(this.password + this.login), random_bits2));
        byte[] session_key = SshMisc.addArrayOfBytes(random_bits1, random_bits2);
        byte[] session_keyXored = SshMisc.XORArrayOfBytes(random_bits1, hash_md5);
        session_keyXored = SshMisc.addArrayOfBytes(session_keyXored, random_bits2);
        byte[] encrypted_session_key = SshCrypto.encrypteRSAPkcs1Twice(session_keyXored, server_key_public_exponent, server_key_public_modulus, host_key_public_exponent, host_key_public_modulus);
        byte[] protocol_flags = new byte[4];
        protocol_flags[3] = 0;
        protocol_flags[2] = 0;
        protocol_flags[1] = 0;
        protocol_flags[0] = 0;
        int length = 1 + anti_spoofing_cookie.length + encrypted_session_key.length + protocol_flags.length;
        byte[] data = new byte[length];
        int boffset = 0;
        data[boffset++] = cipher_types;
        int i = 0;
        while (i < 8) {
            data[boffset++] = anti_spoofing_cookie[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < encrypted_session_key.length) {
            data[boffset++] = encrypted_session_key[i2];
            ++i2;
        }
        int i3 = 0;
        while (i3 < 4) {
            data[boffset++] = protocol_flags[i3];
            ++i3;
        }
        byte packet_type = 3;
        SshPacket packet = this.createPacket(packet_type, data);
        this.sendPacket(packet);
        this.crypto = new SshCrypto(this.cipher_type, session_key);
        this.encryption = true;
        return null;
    }

    private byte[] Send_SSH_CMSG_USER() throws IOException {
        if (debug > 0) {
            System.err.println("Send_SSH_CMSG_USER(" + this.login + ")");
        }
        byte[] data = SshMisc.createString(this.login);
        byte packet_type = 4;
        SshPacket packet = this.createPacket(packet_type, data);
        this.sendPacket(packet);
        return null;
    }

    private byte[] Send_SSH_CMSG_AUTH_PASSWORD() throws IOException {
        byte[] data = SshMisc.createString(this.password);
        byte packet_type = 9;
        SshPacket packet = this.createPacket(packet_type, data);
        this.sendPacket(packet);
        return null;
    }

    private byte[] Send_SSH_CMSG_EXEC_SHELL() throws IOException {
        byte[] data = null;
        byte packet_type = 12;
        SshPacket packet = this.createPacket(packet_type, data);
        this.sendPacket(packet);
        this.lastPacketSentType = packet_type;
        return null;
    }

    private byte[] Send_SSH_CMSG_STDIN_DATA(String str) throws IOException {
        byte[] data = SshMisc.createString(str);
        byte packet_type = 16;
        SshPacket packet = this.createPacket(packet_type, data);
        this.sendPacket(packet);
        return null;
    }

    private byte[] Send_SSH_CMSG_REQUEST_PTY() throws IOException {
        byte[] termType = SshMisc.createString(this.getTerminalType());
        byte[] row = new byte[4];
        row[3] = 24;
        byte[] col = new byte[4];
        col[3] = 80;
        byte[] XPixels = new byte[4];
        byte[] YPixels = new byte[4];
        byte[] terminalModes = new byte[]{0};
        byte[] data = new byte[termType.length + 16 + terminalModes.length];
        int offset = 0;
        int i = 0;
        while (i < termType.length) {
            data[offset++] = termType[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < 4) {
            data[offset++] = row[i2];
            ++i2;
        }
        int i3 = 0;
        while (i3 < 4) {
            data[offset++] = col[i3];
            ++i3;
        }
        int i4 = 0;
        while (i4 < 4) {
            data[offset++] = XPixels[i4];
            ++i4;
        }
        int i5 = 0;
        while (i5 < 4) {
            data[offset++] = YPixels[i5];
            ++i5;
        }
        int i6 = 0;
        while (i6 < terminalModes.length) {
            data[offset++] = terminalModes[i6];
            ++i6;
        }
        byte packet_type = 10;
        SshPacket packet = this.createPacket(packet_type, data);
        this.sendPacket(packet);
        return null;
    }

    private byte[] Send_SSH_CMSG_EXIT_CONFIRMATION() throws IOException {
        byte packet_type = 33;
        SshPacket packet = this.createPacket(packet_type, null);
        this.sendPacket(packet);
        return null;
    }
}

