/*
 * $Id: serv_func.c 6361 2008-06-02 16:09:00Z ajc $
 */

#include "webcit.h"
#include "webserver.h"

struct serv_info serv_info; /**< our connection data to the server */
HashList *ServHash = NULL;//// TODO;
/*
 * get info about the server we've connected to
 *
 * browser_host		the citadell we want to connect to
 * user_agent		which browser uses our client?
 */
void get_serv_info(char *browser_host, char *user_agent)
{
	char buf[SIZ];
	int a;

	/** Tell the server what kind of client is connecting */
	serv_printf("IDEN %d|%d|%d|%s|%s",
		DEVELOPER_ID,
		CLIENT_ID,
		CLIENT_VERSION,
		user_agent,
		browser_host
	);
	serv_getln(buf, sizeof buf);

	/** Tell the server what kind of richtext we prefer */
	serv_puts("MSGP text/html|text/plain");
	serv_getln(buf, sizeof buf);

	/*
	 * Tell the server that when we save a calendar event, we
	 * want invitations to be generated by the Citadel server
	 * instead of by the client.
	 */
	serv_puts("ICAL sgi|1");
	serv_getln(buf, sizeof buf);

	/** Now ask the server to tell us a little bit about itself... */
	serv_puts("INFO");
	serv_getln(buf, sizeof buf);
	if (buf[0] != '1')
		return;

	a = 0;
	while (serv_getln(buf, sizeof buf), strcmp(buf, "000")) {
		switch (a) {
		case 0:
			serv_info.serv_pid = atoi(buf);
			WC->ctdl_pid = serv_info.serv_pid;
			break;
		case 1:
			safestrncpy(serv_info.serv_nodename, buf, sizeof serv_info.serv_nodename);
			break;
		case 2:
			safestrncpy(serv_info.serv_humannode, buf, sizeof serv_info.serv_humannode);
			break;
		case 3:
			safestrncpy(serv_info.serv_fqdn, buf, sizeof serv_info.serv_fqdn);
			break;
		case 4:
			safestrncpy(serv_info.serv_software, buf, sizeof serv_info.serv_software);
			break;
		case 5:
			serv_info.serv_rev_level = atoi(buf);
			break;
		case 6:
			safestrncpy(serv_info.serv_bbs_city, buf, sizeof serv_info.serv_bbs_city);
			break;
		case 7:
			safestrncpy(serv_info.serv_sysadm, buf, sizeof serv_info.serv_sysadm);
			break;
		case 9:
			safestrncpy(serv_info.serv_moreprompt, buf, sizeof serv_info.serv_moreprompt);
			break;
		case 14:
			serv_info.serv_supports_ldap = atoi(buf);
			break;
		case 15:
			serv_info.serv_newuser_disabled = atoi(buf);
			break;
		case 16:
			safestrncpy(serv_info.serv_default_cal_zone, buf, sizeof serv_info.serv_default_cal_zone);
			break;
		case 20:
			serv_info.serv_supports_sieve = atoi(buf);
			break;
		case 21:
			serv_info.serv_fulltext_enabled = atoi(buf);
			break;
		case 22:
			safestrncpy(serv_info.serv_svn_revision, buf, sizeof serv_info.serv_svn_revision);
			break;
		case 23:
			serv_info.serv_supports_openid = atoi(buf);
			break;
		}
		++a;
	}
}



/**
 * \brief Read Citadel variformat text and spit it out as HTML.
 * \param align html align string
 */
void fmout(char *align)
{
	int intext = 0;
	int bq = 0;
	char buf[SIZ];

	wprintf("<div align=%s>\n", align);
	while (serv_getln(buf, sizeof buf), strcmp(buf, "000")) {

		if ((intext == 1) && (isspace(buf[0]))) {
			wprintf("<br />");
		}
		intext = 1;

		/**
		 * Quoted text should be displayed in italics and in a
		 * different colour.  This code understands Citadel-style
		 * " >" quotes and will convert to <BLOCKQUOTE> tags.
		 */
		if ((bq == 0) && (!strncmp(buf, " >", 2))) {
			wprintf("<BLOCKQUOTE>");
			bq = 1;
		} else if ((bq == 1) && (strncmp(buf, " >", 2))) {
			wprintf("</BLOCKQUOTE>");
			bq = 0;
		}
		if ((bq == 1) && (!strncmp(buf, " >", 2))) {
			strcpy(buf, &buf[2]);
		}
		/** Activate embedded URL's */
		url(buf, sizeof(buf));

		escputs(buf);
		wprintf("\n");
	}
	if (bq == 1) {
		wprintf("</I>");
	}
	wprintf("</div><br />\n");
}




/**
 * \brief Read Citadel variformat text and spit it out as HTML in a form
 * suitable for embedding in another message (forward/quote).
 * (NO LINEBREAKS ALLOWED HERE!)
 */
void pullquote_fmout(void) {
	int intext = 0;
	int bq = 0;
	char buf[SIZ];

	while (serv_getln(buf, sizeof buf), strcmp(buf, "000")) {

		if ((intext == 1) && (isspace(buf[0]))) {
			wprintf("<br />");
		}
		intext = 1;

		/**
		 * Quoted text should be displayed in italics and in a
		 * different colour.  This code understands Citadel-style
		 * " >" quotes and will convert to <BLOCKQUOTE> tags.
		 */
		if ((bq == 0) && (!strncmp(buf, " >", 2))) {
			wprintf("<BLOCKQUOTE>");
			bq = 1;
		} else if ((bq == 1) && (strncmp(buf, " >", 2))) {
			wprintf("</BLOCKQUOTE>");
			bq = 0;
		}
		if ((bq == 1) && (!strncmp(buf, " >", 2))) {
			strcpy(buf, &buf[2]);
		}

		msgescputs(buf);
	}
	if (bq == 1) {
		wprintf("</I>");
	}
}




/**
 * \brief Transmit message text (in memory) to the server.
 *
 * \param ptr Pointer to the message being transmitted
 */
void text_to_server(char *ptr)
{
	char buf[256];
	int ch, a, pos, len;

	pos = 0;
	buf[0] = 0;

	while (ptr[pos] != 0) {
		ch = ptr[pos++];
		if (ch == 10) {
			len = strlen(buf);
			while ( (isspace(buf[len - 1]))
				&& (buf[0] !=  '\0') 
				&& (buf[1] !=  '\0') )
				buf[--len] = 0;
			serv_puts(buf);
			buf[0] = 0;
			if (ptr[pos] != 0) strcat(buf, " ");
		} else {
			a = strlen(buf);
			buf[a + 1] = 0;
			buf[a] = ch;
			if ((ch == 32) && (strlen(buf) > 200)) {
				buf[a] = 0;
				serv_puts(buf);
				buf[0] = 0;
			}
			if (strlen(buf) > 250) {
				serv_puts(buf);
				buf[0] = 0;
			}
		}
	}
	serv_puts(buf);
}


/**
 * \brief Transmit message text (in memory) to the server,
 *        converting to Quoted-Printable encoding as we go.
 *
 * \param ptr Pointer to the message being transmitted
 */
void text_to_server_qp(char *ptr)
{
	unsigned char ch, buf[256];
	int pos;
	int output_len = 0;

	pos = 0;
	buf[0] = 0;
	output_len = 0;

	while (ptr[pos] != 0) {
		ch = (unsigned char)(ptr[pos++]);

		if (ch == 13) {
			/* ignore carriage returns */
		}
		else if (ch == 10) {
			/* hard line break */
			if (output_len > 0) {
				if (isspace(buf[output_len-1])) {
					sprintf((char *)&buf[output_len-1], "=%02X", buf[output_len-1]);
					output_len += 2;
				}
			}
			buf[output_len++] = 0;
			serv_puts((char *)buf);
			output_len = 0;
		}
		else if (ch == 9) {
			buf[output_len++] = ch;
		}
		else if ( (ch >= 32) && (ch <= 60) ) {
			buf[output_len++] = ch;
		}
		else if ( (ch >= 62) && (ch <= 126) ) {
			buf[output_len++] = ch;
		}
		else {
			sprintf((char *)&buf[output_len], "=%02X", ch);
			output_len += 3;
		}
		
		if (output_len > 72) {
			/* soft line break */
			if (isspace(buf[output_len-1])) {
				sprintf((char *)&buf[output_len-1], "=%02X", buf[output_len-1]);
				output_len += 2;
			}
			buf[output_len++] = '=';
			buf[output_len++] = 0;
			serv_puts((char *)buf);
			output_len = 0;
		}
	}

	/* end of data - transmit anything that's left */
	if (output_len > 0) {
		if (isspace(buf[output_len-1])) {
			sprintf((char *)&buf[output_len-1], "=%02X", buf[output_len-1]);
			output_len += 2;
		}
		buf[output_len++] = 0;
		serv_puts((char *)buf);
		output_len = 0;
	}
}




/**
 * \brief translate server message output to text
 * (used for editing room info files and such)
 */
void server_to_text()
{
	char buf[SIZ];

	int count = 0;

	while (serv_getln(buf, sizeof buf), strcmp(buf, "000")) {
		if ((buf[0] == 32) && (count > 0)) {
			wprintf("\n");
		}
		wprintf("%s", buf);
		++count;
	}
}



/**
 * Read binary data from server into memory using a series of
 * server READ commands.
 * \param buffer the output buffer
 * \param total_len the maximal length of buffer
 */
void read_server_binary(char *buffer, size_t total_len) {
	char buf[SIZ];
	size_t bytes = 0;
	size_t thisblock = 0;

	memset(buffer, 0, total_len);
	while (bytes < total_len) {
		thisblock = 4095;
		if ((total_len - bytes) < thisblock) {
			thisblock = total_len - bytes;
			if (thisblock == 0) return;
		}
		serv_printf("READ %d|%d", (int)bytes, (int)thisblock);
		serv_getln(buf, sizeof buf);
		if (buf[0] == '6') {
			thisblock = (size_t)atoi(&buf[4]);
			if (!WC->connected) return;
			serv_read(&buffer[bytes], thisblock);
			bytes += thisblock;
		}
		else {
			lprintf(3, "Error: %s\n", &buf[4]);
			return;
		}
	}
}


/**
 * \brief Read text from server, appending to a string buffer until the
 * usual 000 terminator is found.  Caller is responsible for freeing
 * the returned pointer.
 */
char *read_server_text(void) {
	char *text = NULL;
	size_t bytes_allocated = 0;
	size_t bytes_read = 0;
	int linelen;
	char buf[SIZ];

	text = malloc(SIZ);
	if (text == NULL) {
		return(NULL);
	}
	text[0] = 0;
	bytes_allocated = SIZ;

	while (serv_getln(buf, sizeof buf), strcmp(buf, "000")) {
		linelen = strlen(buf);
		buf[linelen] = '\n';
		buf[linelen+1] = 0;
		++linelen;

		if ((bytes_read + linelen) >= (bytes_allocated - 2)) {
			bytes_allocated = 2 * bytes_allocated;
			text = realloc(text, bytes_allocated);
		}

		strcpy(&text[bytes_read], buf);
		bytes_read += linelen;
	}

	return(text);
}



/*@}*/
