#! /bin/sh
#
# Copyright (c) 1997 Silicon Graphics, Inc.  All Rights Reserved.
# 
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2 of the License, or (at your
# option) any later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# Generate a Performance Metrics Name Space Map from a specification file
#

# Get standard environment
. $PCP_DIR/etc/pcp.env

prog=`basename $0`
if [ $# -gt 1 -o "X$1" = "X-?" ]
then
    echo "Usage: $prog [infile]"
    exit 1
fi
if [ $# -eq 0 ]
then
    pathnamename="<stdin>"
    name="<stdin>"
else
    if [ ! -f $1 ]
    then
	echo "$prog: cannot open \"$1\""
	exit 1
    fi
    pathname=`pwd`/$1
    name=$1
fi

cat <<End-of-File
/*
 * Performance Metrics Name Space Map
 * Built by $prog from the file
 * $name
 * on `date`
 *
 * Do not edit this file!
 */

End-of-File

# Deal with either Windows or Unix variants of text files
cat $1 | tr '\r\n' '\n' | $PCP_AWK_PROG '
$1 == "#"	{ if (comment) text = text "\n *"
		  comment++
		  for (i = 2; i <= NF; i++)
		    text = text " " $i
		  next
		}
comment > 0	{ if (comment == 1)
			print "/*" text " */"
		  else
		    print "/*\n *" text "\n */"
		  comment = 0
		  text = ""
		}
NF == 0		{ print; next }
NF == 2 && $2 == "{"	{ if (state != 0) {
				printf "[%s:%d] nested group?\n","'$1'",NR
				exit 1
			  }
			  printf "char *%s[] = {\n",$1
			  state = 1
			  ord = 0
			  next
			}
NF == 2 && state == 1	{ printf "#define %s	%d\n",$2,ord
			  ord++
			  printf "	\"%s\",\n",$1
			  next
			}
NF == 1 && $1 == "}"	{ printf "\n"
			  printf "};\n\n"
			  state = 0
			  next
			}
			{ printf "[%s:%d] syntax error\n","'$name'",NR
			  exit 1
			}
END			{ if (state) {
				printf "[%s:%d] unterminated group?\n","'$name'",NR
				exit 1
			  }
			  if (comment == 1)
				print "/*" text " */"
			  else if (comment > 1)
				print "/*\n *" text "\n */"
			}'
