/*
 * Copyright (c) 2000,2004 Silicon Graphics, Inc.  All Rights Reserved.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */ 

#include "pmapi.h"

/*
 * Generates magic number used to provide authentication between
 * pmcd and unlicensed (but trusted) clients.
 * 
 * Note:
 * o  "authNumber" is the low 16-bits from lrand48() generated by pmcd
 *    and sent to the client in an extended error PDU
 * o  "clientId" is the pid of the client
 * o  the 0xffffff mask is needed because only 24 bits are transmitted
 *    across the credentials protocols
 */
unsigned int
__pmMakeAuthCookie(unsigned int authNumber, pid_t clientId)
{
    return( (authNumber^(unsigned int)clientId) & 0xffffff );
}
