# - Find LIBJPEG
# Find the native LIBJPEG includes and library
# This module defines
#  LIBJPEG_INCLUDE_DIR, where to find jpeglib.h, etc.
#  LIBJPEG_LIBRARIES, the libraries needed to use LIBJPEG.
#  LIBJPEG_FOUND, If false, do not try to use LIBJPEG.
# also defined, but not for general use are
#  LIBJPEG_LIBRARY, where to find the LIBJPEG library.

FIND_PATH(LIBJPEG_INCLUDE_DIR jpeglib.h)

SET(LIBJPEG_LIBRARY_NAMES_RELEASE ${LIBJPEG_LIBRARY_NAMES_RELEASE} ${LIBJPEG_LIBRARY_NAMES} jpeg libjpeg)
FIND_LIBRARY(LIBJPEG_LIBRARY_RELEASE NAMES ${LIBJPEG_LIBRARY_NAMES_RELEASE} )

SET(LIBJPEG_LIBRARY_NAMES_DEBUG ${LIBJPEG_LIBRARY_NAMES_DEBUG} jpegd libjpegd jpeg_d libjpeg_d)
FIND_LIBRARY(LIBJPEG_LIBRARY_DEBUG NAMES ${LIBJPEG_LIBRARY_NAMES_DEBUG} )

INCLUDE(LibraryDebugAndRelease)
SET_LIBRARY_FROM_DEBUG_AND_RELEASE(LIBJPEG)

# handle the QUIETLY and REQUIRED arguments and set LIBJPEG_FOUND to TRUE if 
# all listed variables are TRUE
INCLUDE(PoDoFoFindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(LIBJPEG DEFAULT_MSG LIBJPEG_LIBRARY LIBJPEG_INCLUDE_DIR)

IF(LIBJPEG_FOUND)
  SET(LIBJPEG_LIBRARIES ${LIBJPEG_LIBRARY})
ELSE(LIBJPEG_FOUND)
  MESSAGE("libjpeg not found: Library ${LIBJPEG_LIBRARY}, headers ${LIBJPEG_INCLUDE_DIR}")
ENDIF(LIBJPEG_FOUND)

MARK_AS_ADVANCED(LIBJPEG_LIBRARY LIBJPEG_INCLUDE_DIR )
