/* 
 *	HT Editor
 *	htne.h
 *
 *	Copyright (C) 1999, 2000, 2001 Stefan Weyergraf (stefan@weyergraf.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __HTNE_H__
#define __HTNE_H__

#include "htobj.h"
#include "formats.h"

#include "nestruct.h"

#define DESC_NE "ne"
#define DESC_NE_HEADER "ne/header"
#define DESC_NE_SEGMENTS "ne/segments"
#define DESC_NE_ENTRYPOINTS "ne/entrypoints"
#define DESC_NE_NAMES "ne/names"

#define ATOM_NE_FLAGS			0x4e450000
#define ATOM_NE_FLAGS_STR		 "4e450000"

#define ATOM_NE_OS				0x4e450001
#define ATOM_NE_OS_STR			 "4e450001"

#define ATOM_NE_SEGFLAGS			0x4e450002
#define ATOM_NE_SEGFLAGS_STR		 "4e450002"

#define ATOM_NE_ENTFLAGS			0x4e450003
#define ATOM_NE_ENTFLAGS_STR		 "4e450003"

struct ht_ne_shared_data {
	dword hdr_ofs;
	NE_HEADER hdr;
};

class ht_ne: public ht_format_group {
protected:
	bool loc_enum;
public:
			void init(bounds *b, ht_streamfile *file, format_viewer_if **ifs, ht_format_group *format_group, FILEOFS h);
	virtual	void done();
/* overwritten */
	virtual   void loc_enum_start();
	virtual   bool loc_enum_next(ht_format_loc *loc);
};

extern format_viewer_if htne_if;

#endif /* __HTNE_H__ */
