/* $Id: cairogen-ps.c,v 1.2 2004/12/11 19:26:06 ellson Exp $ $Revision: 1.2 $ */
/* vim:set shiftwidth=4 ts=8: */

/**********************************************************
*      This software is part of the graphviz package      *
*                http://www.graphviz.org/                 *
*                                                         *
*            Copyright (c) 1994-2004 AT&T Corp.           *
*                and is licensed under the                *
*            Common Public License, Version 1.0           *
*                      by AT&T Corp.                      *
*                                                         *
*        Information and Software Systems Research        *
*              AT&T Research, Florham Park NJ             *
**********************************************************/

/* cairogen_png.c */
/*    code adapted from xsvg.c by John Ellson <ellson@research.att.com> */

/* xsvg - SVG viewer application for the X Window System
 *
 * Copyright © 2002 USC/Information Sciences Institute
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that the name of
 * Information Sciences Institute not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  Information Sciences Institute
 * makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * INFORMATION SCIENCES INSTITUTE DISCLAIMS ALL WARRANTIES WITH REGARD
 * TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL INFORMATION SCIENCES
 * INSTITUTE BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Carl Worth <cworth@isi.edu>
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef HAVE_LIBSVG_CAIRO

#include <stdio.h>
#include <stdlib.h>
#include <svg-cairo.h>
#include "cairogen-ps.h"

#define PS_UNITS_PER_INCH       72.0
#define X_PPI           	300.0
#define Y_PPI           	300.0

/* XXX: We should make the -fit option work for scaling the PS output. */
int
render_to_ps(svg_cairo_t * svgc, FILE * ps_file, double scale, int width,
	     int height)
{
    cairo_t *cr;

    if (width < 0 || height < 0) {
	svg_cairo_get_size(svgc, &width, &height);
	width = (width * scale + 0.5);
	height = (height * scale + 0.5);
    }

    cr = cairo_create();
    cairo_scale(cr, scale, scale);

    cairo_set_target_ps(cr, ps_file,
			width / PS_UNITS_PER_INCH,
			height / PS_UNITS_PER_INCH, X_PPI, Y_PPI);

    /* XXX: This probably doesn't need to be here (eventually) */
    cairo_set_rgb_color(cr, 1, 1, 1);

    svg_cairo_render(svgc, cr);

    cairo_show_page(cr);

    svg_cairo_destroy(svgc);

    cairo_destroy(cr);

    fflush(ps_file);

    return 0;
}

#endif				/* HAVE_LIBSVG_CAIRO */
