#ifndef _FIREFLIERSTRINGS_H_
#define _FIREFLIERSTRINGS_H_

#include "config.h"
#include <glibmm/ustring.h>

using Glib::ustring;


const ustring strAppName		= PACKAGE;
const ustring strAppVersion		= VERSION;
const ustring strAppTitle		= PACKAGE;
const ustring strConnecting		= "connecting to fireflier-server";
const ustring strConnection		= "connected to fireflier-server";
const ustring strNoConnection	= "no connection to fireflier-server";
const ustring strWait4Auth		= "waiting for authentication";
const ustring strNotAvailable	= "not available";
const ustring strResolving		= "resolving...";
const ustring strNotResolvable	= "not resolvable";
const ustring strNoPacketAvail	= "no Packet available";
const ustring strTimeoutForever	= "never";
const ustring strTimeout01		= "5 minutes";
const ustring strTimeout02		= "1 hour";
const ustring strTimeout03		= "12 hours";
const ustring strTimeout04		= "1 day";
const ustring strChainInput		= "INPUT";
const ustring strChainForward	= "FORWARD";
const ustring strChainOutput	= "OUTPUT";
const ustring ICMP_TYPES[] =
{
	  "ECHO_REPLY"
	, "UNKNOWN"
	, "UNKNOWN"
	, "DEST_UNREACH"
	, "SOURCE_QUENCH"
	, "REDIRECT"
	, "UNKNOWN"
	, "UNKNOWN"
	, "ECHO"
	, "UNKNOWN"
	, "UNKNOWN"
	, "TIME_EXCEEDED"
	, "PARAMETERPROB"
	, "TIMESTAMP"
	, "TIMESTAMP_REPLY"
	, "INFO_REQUEST"
	, "INFO_REPLY"
	, "ADDRESS"
	, "ADDRESS_REPLY"
};

const ustring strThisPacket		= "_this packet";
const ustring strQueuedpackets	= "_queued packets";
const ustring strCreateRule		= "_create rule from this packet";
const ustring strAccept			= "_allow";
const ustring strDrop			= "_deny";
const ustring strChain			= "Chain: ";
const ustring strIPSrc			= "_IP: ";
const ustring strIPDst			= "I_P: ";
const ustring strHostSrc		= "Hostname: ";
const ustring strHostDst		= "Hostname: ";
const ustring strPortSrc		= "P_ort: ";
const ustring strPortDst		= "Po_rt: ";
const ustring strIFaceIn		= "I_nterface: ";
const ustring strIFaceOut		= "Interfac_e: ";
const ustring strProtocol		= "Protoco_l: ";
const ustring strTracking		= "Connection Trac_king";
const ustring strProgramName	= "Pro_gram: ";
const ustring strMAC			= "MAC: ";
const ustring strLen			= "Length: ";
const ustring strTCPFlags		= "TCP Flags: ";
const ustring strICMPType		= "ICMP Type: ";
const ustring strTimestamp		= "Timestamp: ";
const ustring strProtocol_ICMP	= "ICMP";
const ustring strProtocol_TCP	= "TCP";
const ustring strProtocol_UDP	= "UDP";
const ustring strProtocol_GRE	= "GRE";
const ustring strProtocol_UNKNOWN="UNKNOWN";
const ustring strTCPFlag_FIN	= "FIN ";
const ustring strTCPFlag_SYN	= "SYN ";
const ustring strTCPFlag_ACK	= "ACK ";
const ustring strTCPFlag_RST	= "RST ";
const ustring strLabelTimeout	= "Ti_meout of rule: ";

const ustring strToolTipTimeout	= "Time for which this rule is valid";

#endif
