#ifndef _CGCONF_H_
#define _CGCONF_H_

#include <gconfmm.h>
#include <map>
#include <glibmm/ustring.h>

using Glib::ustring;


class CGConfUI
{
public:
	typedef std::map <const ustring, Gnome::Conf::Value> contEntries;
	

private:
	contEntries m_contEntries;
	Glib::RefPtr <Gnome::Conf::Client> m_pGConfClient;


public:
	void add_dir(	Glib::RefPtr <Gnome::Conf::Client>& pGConfClient, 
					const ustring& strDir, 
					SigC::Slot2 <void, const ustring&, const Gnome::Conf::Value&> slotValueChanged, 
					Gnome::Conf::ClientPreloadType enPreloadType = Gnome::Conf::CLIENT_PRELOAD_ONELEVEL);
	
	Gnome::Conf::Value& operator [](const ustring& strKey)
	{
		return m_contEntries[strKey];
	}
	
	void write()
	{
		
		for (contEntries::const_iterator it = m_contEntries.begin(), itEnd = m_contEntries.end(); it != itEnd; it++)
			m_pGConfClient->set(it->first, it->second);
	}
};

#endif
