#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Eric3 Helpviewer

This is the main Python script that performs the neccessary initialization
of the helpviewer and starts the Qt event loop. This is a standalone version
of the integrated helpviewer.
"""

import sys

from Utilities import Startup
import Utilities

def createMainWidget(argv, qtDir):
    """
    Function to create the main widget.
    
    @param argv list of commandline parameters (list of strings)
    @param qtDir directory of the Qt installation (string)
    @return reference to the main widget (QWidget)
    """
    from Helpviewer.HelpWindow import HelpWindow
    
    try:
        home = argv[1]
    except IndexError:
        if qtDir is not None:
            home = Utilities.normjoinpath(qtDir, 'doc', 'html', 'index.html')
        else:
            home = None
    
    help = HelpWindow(home, '.', None, 'help viewer')
    help.setCaption('Helpviewer')
    return help

def main():
    """
    Main entry point into the application.
    """
    appinfo = Startup.makeAppInfo(sys.argv,
                                  "Eric3 help viewer",
                                  "file",
                                  "HTML help browser")
    res = Startup.simpleAppStartup(sys.argv,
                                   appinfo,
                                   createMainWidget,
                                   [('!+file', '')])
    sys.exit(res)

if __name__ == '__main__':
    main()
