# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Subversion Options Dialog for a new project from the repository.
"""

import os

from qt import *

from KdeQt import KQFileDialog

from NewProjectForm import SvnNewProjectOptionsForm
from Config import ConfigSvnProtocols

class SvnNewProjectOptionsDialog(SvnNewProjectOptionsForm):
    """
    Class implementing the Options Dialog for a new project from the repository.
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        SvnNewProjectOptionsForm.__init__(self, parent, None, 1)
        
        self.protocolCombo.insertStringList(ConfigSvnProtocols)
        
        hd = QDir.convertSeparators(QDir.homeDirPath())
        hd = os.path.join(unicode(hd), 'subversionroot')
        self.vcsDirectoryEdit.setText(hd)
        
    def handleDirectory(self):
        """
        Private slot to display a directory selection dialog.
        """
        directory = KQFileDialog.getExistingDirectory(self.vcsDirectoryEdit.text(),
            self, None, self.trUtf8("Select Repository-Directory"), 1)
            
        if not directory.isNull():
            self.vcsDirectoryEdit.setText(QDir.convertSeparators(directory))
        
    def handleProjectDir(self):
        """
        Private slot to display a directory selection dialog.
        """
        directory = KQFileDialog.getExistingDirectory(self.vcsProjectDirEdit.text(),
            self, None, self.trUtf8("Select Project Directory"), 1)
            
        if not directory.isNull():
            self.vcsProjectDirEdit.setText(QDir.convertSeparators(directory))
        
    def handleLayoutToggled(self, checked):
        """
        Private slot to handle the change of the layout checkbox.
        
        @param checked flag indicating the state of the checkbox (boolean)
        """
        if unicode(self.vcsComboBox.currentText().lower()) == "subversion":
            self.vcsTagLabel.setEnabled(checked)
            self.vcsTagEdit.setEnabled(checked)
            if not checked:
                self.vcsTagEdit.clear()
        
    def handleProtocol(self, protocol):
        """
        Private slot to switch the status of the directory selection button.
        """
        if str(protocol) == "file://":
            self.vcsDirButton.setEnabled(1)
        else:
            self.vcsDirButton.setEnabled(0)
        
    def getData(self):
        """
        Public slot to retrieve the data entered into the dialog.
        
        @return a tuple of 4 strings and one boolean (repository URL,
            archive name (always empty), tag name, project directory,
            standard layout flag).
        """
        return (\
            '%s%s' % (str(self.protocolCombo.currentText()),
                      unicode(self.vcsDirectoryEdit.text())),
            '',
            unicode(self.vcsTagEdit.text()),
            unicode(self.vcsProjectDirEdit.text()),
            self.layoutCheckBox.isChecked()
        )
