#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <time.h>

static void	data(int argc, char * * argv);
static void	error(int argc, char * * argv);
static void	helo(int argc, char * * argv);
static void	help(int argc, char * * argv);
static void	ok(int argc, char * * argv);
static void	quit(int argc, char * * argv);
static void	refuse(int argc, char * * argv);
static void	send_file(int error_number, FILE * file, int argc, char * * argv);

struct command {
    const char	name[4];
    void	(*function)(int argc, char * * argv);
};

static const struct command	commands[] = {
    {	"data",	data	},
    {	"debu",	refuse	},
    {	"expn",	refuse	},
    {	"helo",	helo	},
    {	"help",	help	},
    {	"mail",	ok	},
    {	"noop",	ok	},
    {	"rcpt",	refuse	},
    {	"rset",	ok	},
    {	"quit",	quit	},
    {	"vrfy",	refuse	},
    {	"",		error	}
};

static char	hostname[100];
static char	bouncerName[100], bouncerPhone[100];

static const char *
get_line(char * buffer, int length, FILE * stream)
{
    int	c;
    int	got_one = 0;

    length--;

    while ( length > 0 && (c = fgetc(stream)) != EOF ) {
	if ( c == '\r' || c == '\n' ) {
	    if ( got_one )
		break;
	    else
		continue;
	}
	*buffer++ = c;
	got_one = 1;
    }
    *buffer = '\0';
    if ( got_one )
	return buffer;
    else
	return 0;
}

static void
timeout(int signal_number)
{
    /* Don't hold resources for over a minute just to bounce a message */
    shutdown(0, 2);
    shutdown(1, 2);
    shutdown(2, 2);
    _exit(0);
}

int
main(int argc, char * * argv)
{
    char		buffer[1024];
    time_t		t = time(0);
    char *		date = ctime(&t);
#ifdef LOGFILE
    FILE *		log;
#endif
    FILE *		bouncer;

    signal(SIGALRM, timeout);
    alarm(60);

#ifdef LOGFILE
    log = fopen(LOGFILE, "w");
#endif

    bouncer = fopen("/etc/smtp-refuser.conf", "r");
    get_line(bouncerName, sizeof(bouncerName), bouncer);
    get_line(bouncerPhone, sizeof(bouncerPhone), bouncer);
    fclose(bouncer);

    if ( gethostname(hostname, sizeof(hostname)) != 0 )
	hostname[0] = '\0';

    date[strlen(date) - 1] = '\0';
    setlinebuf(stdout);

    printf("220 %s smtp-refuser ready at %s.\r\n", hostname, date);
    while ( get_line(buffer, sizeof(buffer), stdin) != NULL ) {
	const struct command *	c = commands;

#ifdef LOGFILE
	if ( log )
	    fprintf(log, "%s\n", buffer);
#endif

	while ( *(c->name) && strncasecmp(buffer, c->name, 4) != 0 )
	    c++;

	(c->function)(argc, argv);
    } 
    return 0;
}

static void
data(int argc, char * * argv)
{
    fputs("503 No recepients are valid.\r\n", stdout);
}

static void
error(int argc, char * * argv)
{
    fputs("500 Command unrecognized.\r\n", stdout);
}

static void
helo(int argc, char * * argv)
{
    printf(
     "250 %s ready. You are not welcome here.\r\n"
    ,hostname);
}

static void
help(int argc, char * * argv)
{
    static const char	help_text[] =
     "250-This server exists only to refuse mail.\r\n"
     "250-Your system has been directed to it instead of the normal mail\r\n"
     "250-server because the system administrator has some reason to\r\n"
     "250-refuse your messages. If you feel this is an error, please\r\n"
     "250 contact the system administrator using other means than e-mail.\r\n";

    fputs(help_text, stdout);
}

static void
ok(int argc, char * * argv)
{
    fputs("250 ok. Any mail you send will be rejected.\r\n", stdout);
}

static void
quit(int argc, char * * argv)
{
    printf(
     "221 %s closing connection. Please don't bother us again.\r\n"
    ,hostname);
    exit(0);
}

static void
send_file(int error_number, FILE * file, int argc, char * * argv)
{
    int	c;
    int escape = 0;
    int dollar = 0;
    int new_line = 1;

    while ( (c = getc(file)) != EOF ) {
	if ( new_line ) {
	    printf("%d- ", error_number);
	    new_line = 0;
	}

	if ( !escape ) {
	    switch ( c ) {
	    case '\\':
		escape = 1;
		continue;
	    case '$':
		dollar = 1;
		continue;
	    case '\n':
		printf("\r\n", error_number);
		new_line = 1;
		continue;
	    }
	    if ( dollar ) {
		if ( c >= '1' && c <= '9' && argc > (c - '0') ) {
		    fputs(argv[c - '0'], stdout);
		    dollar = 0;
		    continue;
		}
		if ( c == 'c' || c == 'C' ) {
		    fputs(bouncerName, stdout);
		    dollar = 0;
		    continue;
		}
		if ( c == 'p' || c == 'P' ) {
		    fputs(bouncerPhone, stdout);
		    dollar = 0;
		    continue;
		}
	    }
	}
	escape = 0;
	dollar = 0;
	putchar(c);
    }
    printf("%d \r\n", error_number);
}

static void
refuse(int argc, char * * argv)
{
    FILE *		file = NULL;
    static const char	text[] = 
     "550- All mail from your site is refused. If you feel this is an\r\n"
     "550- error, please contact the system administrator using other\r\n"
     "550 means than e-mail.\r\n";

    if ( argc > 1 )
	file = fopen(argv[1], "r");

    if ( file == NULL ) {
	fputs(text, stdout);
	return;
    }

    argc--;
    argv++;
    send_file(550, file, argc, argv);

    fclose(file);
}
