.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
.\" PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id: mkdic.man,v 1.2 1994/01/27 10:46:50 misao Exp $
.TH MKDIC 1
.SH "NAME"
mkdic \- Tool for creating a user dictionary
.SH "SYNOPSIS"
.B "mkdic [{\-cs|\-cannaserver} \fIcanna-server\fP] [\-s] [\- | \-l \fIlocal-file\fP] \fIremote-dic\fP"
.SH "DESCRIPTION"
.PP
mkdic creates user dictionary named \fIremote-dic\fP in the user dictionary 
directory of the remote host, on which \fIcannaserver\fP(1M) is in operation. 
Dictionary file name \fIremote-dic\fP is assigned to this file at this time.
.PP
If the \- and \-l option isn't specified, mkdic creates an empty dictionary.
.PP
If the \- option is specified, the standard input will be used as the 
dictionary file. If the \-l option is specified, \fIlocal-file\fP will be 
used as the dictionary file.
.PP
If the user dictionary directory does not exist, it will be created.
.PP
Dictionary directory file \(em dics.dir \(em is rewritten automatically after
the registering. The registered dictionary can thus be used by writing the 
dictionary name into the customize file.
.SH "OPTIONS"
.IP "\-cs \fIcanna-server\fP (or \-cannaserver \fIcanna-server\fP)" 12
Specifies the server machine that contains the dictionary to be created.
.IP "\-s"
Indicates that the dictionary to be created is an adjunct dictionary.  
If this option is omitted, the dictionary will be created as an 
independent-word one.
.IP "\-l \fIlocal-file\fP"
Registers the input data from \fIlocal-file\fP.
.IP "\-" 12
The standard input will be used as the dictionary file.
.SH "EXAMPLES"
.IP (1) 4
If you want to creat an empty dictionary file:
.nf

  % mkdic test
.fi
.IP (2) 4
If you want to register the input data from the standard input:
.nf

  % mkdic test \-
.fi
.PP
Registers the input data from the standard input, in the 
user dictionary directory under dictionary name ``test''.  The 
following line is then added to dictionary directory file 
\(em dics.dir \(em :
.nf

          user1.t(.mwd) \-test\-

.fi
.IP (3) 4
If the dictionary file is specified:
.nf

  % mkdic test \-l test1.t

.fi
.PP
Registers independent-word dictionary file ``test1.t'' in the remote host's 
user dictionary directory under dictionary name ``test''.  The following 
line is then added to dics.dir:
.nf

         user1.t(.mvd) \-test\-

.fi
.PP
user1.t is a dictionary file name generated automatically by the system.
.SH "SEE ALSO"
.PP
catdic(1), cannaserver(1M), lsdic(1)
