.\"
.\" @(#)cda.man	6.25 99/02/20
.\"
.\"   cda - Command-line CD Audio Player
.\"
.\"   Copyright (C) 1993-1999  Ti Kan
.\"   E-mail: ti@amb.org
.\"
.\"   This program is free software; you can redistribute it and/or modify
.\"   it under the terms of the GNU General Public License as published by
.\"   the Free Software Foundation; either version 2 of the License, or
.\"   (at your option) any later version.
.\"
.\"   This program is distributed in the hope that it will be useful,
.\"   but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"   GNU General Public License for more details.
.\"
.\"   You should have received a copy of the GNU General Public License
.\"   along with this program; if not, write to the Free Software
.\"   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.TH CDA 1 "18 March 1998" "v2.5"

.SH "NAME"
cda \- Compact disc digital audio player utility

.SH "SYNOPSIS"
.B cda
.nh
[-\fIdev\fP device] [-\fIbatch\fP] [-\fIremote\fP | -\fInoremote\fP]
[-\fIdebug\fP] \fIcommand\fP

.SH "DESCRIPTION"
.I Cda
is a program that allows the use of the CD-ROM or CD-R drive as
a full-featured stereo compact-disc player from the
shell command line.  It can be used interactively in line
mode or visual (screen) mode, or as a script-driven utility.
This is a companion utility to
.I xmcd,
a Motif-based CD audio player application
for the X window system.
.I Cda
uses the same configuration and support files as
.I xmcd.
.PP
Most of the features found on "real" CD players are available in
.I cda,
such as shuffle and repeat, and track programming functions.
Multi-disc changers are also supported.
.PP
A CD database feature allows the CD artist/title and
track titles, and other associated general purpose text to be
displayed as the program is started or when a
CD is inserted.  The CD database contents can be on your
local system or queried from a remote CD database server host.
No capability is provided to update the CD database via
.I cda.
You must use the X-based
.I xmcd(1)
utility to add or modify CD database entries.
.PP
On systems with more than one CD-ROM or CD-R drive, multiple
invocations of
.I cda
can be used to operate each drive independently.
.PP
.I Cda
is designed to be easy to use, with particular care taken
to make all output easily parsable by other programs.
.PP
The internal architecture of
.I cda
is designed to be easily portable to many UNIX operating
system variants, and adaptable to the myriad of CD-ROM drives
available.

.SH "OPTIONS"
.I Cda
supports the following options:
.TP
\fI\-dev\ device\fR
Specifies the path name to the raw CD-ROM device.  If this option is
not used, the default device to be used is the first
drive set up with the
.I xmcd
configuration program (See below).
.TP
\fI\-batch\fR
Signifies that
.I cda
should run in batch mode.  This suppresses all interaction with the
user (i.e., will not prompt the user to type anything).  Batch mode
is not meaningful in visual mode.
.TP
\fI\-remote\fR, \fI\-noremote\fR
Forces the
.I cda
client to enable or disable remote CDDB server access.  If this
option is not specified, then the default is configured via the
\fIcddbRemoteDisable\fP parameter in the common.cfg file.
.TP
\fI\-debug\fR
Causes verbose debugging diagnostics to be printed on \fIstderr\fR.
Note that if you are running in visual mode, the stderr output should
be redirected to a file, or the debug information will corrupt the
screen.

.SH "COMMANDS"
.I Cda
supports the following commands:
.TP
\fIon\fR
Start the
.I cda
daemon.
.TP
\fIoff\fR
Terminate the
.I cda
daemon.
.TP
\fIdisc <load | eject | prev | next | disc#>\fR
Load or eject the CD, or change discs on a multi-disc changer.
.TP
\fIlock <on | off>\fR
Enable/disable the CD disc lock.  When locked, the CD cannot be
ejected using the CD-ROM front-panel eject button.
.TP
\fIplay [track# [mm:ss]]\fR
Start playback.  If the
.I track#
is used, the playback starts from the specified track.  The optional
.I mm:ss
argument specifies the minutes and seconds offset into
the track from where to start playback.
.TP
\fIpause\fR
Pauses the playback.  Use \fBcda play\fR to resume playback.
.TP
\fIstop\fR
Stop the plaback.
.TP
\fItrack <prev | next>\fR
Proceed to the previous or the next track.  This command is only
valid when playback is already in progress.
.TP
\fIindex <prev | next>\fR
Proceed to the previous or the next index.  This command is only
valid when playback is already in progress.
.TP
\fIprogram [clear | track# ...]\fR
If no argument is specified, this command displays the current
program play sequence, if any.  The \fBclear\fR argument will
cause the current program to be cleared.  To define a new program,
specify a list of track numbers separated by spaces.  To start
program play, use the \fBplay\fR command.  You cannot define
a new program while shuffle mode is enabled.
.TP
\fIshuffle <on | off>\fR
Enable/disable shuffle play mode.  When shuffle is enabled,
.I cda
will play the CD tracks in a random order.  You can use this
command only when audio playback is not in progress.  Also,
you must clear any program sequence before enabling shuffle.
.TP
\fIrepeat <on | off>\fR
Enable/disable the repeat mode.
.TP
\fIvolume [value#]\fR
If no argument is specified, this command displays the current
audio volume setting.  If a
.I value
is used, then the audio volume level is set to the specified
value.  The valid range is 0 to 100.
.TP
\fIbalance [value#]\fR
If no argument is specified, this command displays the current
balance control setting.  If a
.I value
is used, then the balance is set to the specified value.
The valid range is 0 to 100, where 0 is full left, 50 is
center and 100 is full right.
.TP
\fIroute [value#]\fR
If no argument is specified, this command displays the current
channel routing setting.  If a
.I value
is used, then the routing is set to the specified value.
The valid range is 0 to 4, as specified below:
.sp
.nf
0	Normal stereo
1	Reverse stereo
2	Mono-L
3	Mono-R
4	Mono-L+R
.fi
.TP
\fIstatus [cont [secs#]]\fR
Display the current disc status, disc number, track number,
index number, time, modes, and repeat count.  If the \fBcont\fR
argument is specified, then the display will run continuously
until the user types the interrupt character (typically \fIDelete\fR or
\fICtrl-C\fR).  The optional \fBsecs\fR sub-argument is the
display update time interval.  The default is 1 second.
.TP
\fItoc [offsets]\fR
Display the CD Table of Contents.  The disc artist/title
and track titles from the CD database
associated with the current disc is also
shown, if available.
.sp
If an exact CD database match is not found, but the CD database
server provides a list of inexact matches, then the user will
be prompted to select from that list.  If batch mode is active
(i.e., the -batch option is used), then no such prompt will
occur.
.sp
If the \fBoffsets\fR argument is used,
then the track times are the absolute offsets from the start
of the CD.  Otherwise, the times shown are the track lengths.
.TP
\fIextinfo [track#]\fR
Display the disc extended information text associated with
the current CD, if available from the CD database.  If the
CD is currently playing, then the track extended information
associated with the playing track is also displayed.  If a
track number is used in the argument, then the track extended
information text of the specified track is shown instead.
.TP
\fIdevice\fR
Displays the CD-ROM and device information.
.TP
\fIversion\fR
Displays the
.I cda
version and copyright information.
.TP
\fIdebug [on | off]\fR
Show, set or unset the debug mode.  If set, verbose debugging
diagnostics will be printed on \fIstderr\fR of the terminal
that the
.I cda daemon
is started from.  If this is the same terminal that is running
.I cda
in visual mode, the debug information will corrupt the screen.
.TP
\fIvisual\fR
Enter an interactive, screen-oriented visual mode.  All
other cda commands can also be invoked within this mode.

.SH "DEVICE CONFIGURATION"
See
.I xmcd(1)
for a description of the device configuration requirements.
.PP
.B WARNING:
If
.I cda
is not correctly configured, you may cause
.I cda
to deliver commands that are not supported by your CD-ROM drive.
Under some environments this may lead to system hang or crash.

.SH "USING CDA"
Start the
.I cda daemon
with the \fBcda on\fR command (or the F1 (o) function in visual mode).
This reserves the CD-ROM device and initializes the program for
further commands.  All other
.I cda
functions will not work unless the
.I cda daemon
is running.
The other
.I cda
commands should be self explanatory.
.PP
The \fBoff\fR command (or the F1 (o) function in visual mode)
can be used to terminate the
.I cda daemon
and release the CD-ROM drive for use by other software.

.SH "VISUAL MODE"
If the
.I cda visual
command is used, it enters a screen-oriented visual mode.
In this mode, the status and other information available
is continuously displayed and updated on the screen, and
virtually all functions are available via a single key stroke.
.PP
A minimum screen size of 80 columns by 24 rows is recommended
for the visual mode.
.PP
Visual mode uses the curses screen library to control the screen.
It is essential that the TERM environment variable reflect the current
terminal type, which ideally should have 8 (or more) function keys.
Since function key definitions in terminfo descriptions are often
unreliable, alphabetic key alternatives are also available.
.PP
The screen is divided into two windows: an information window and a
status window.  According to context, the information window displays
a help screen, device and version information, disc information and
table of contents, or track extended information.  This window is
scrollable if it overflows its allotted screen area.
The status window consists of the last few lines of the screen,
enclosed in a box.  The first line contains the program list, or
track number and offset together with volume, balance and stereo/mono
information.  The remaining lines contain the function keys
(with their alphabetic synonymns) and the functions they invoke.
These functions are highlighted when they are on, making
it easy to see the current state.
.PP
Screen annotation and online help make operation self explanatory,
but for reference, a list of commands follows. Alphabetic key
alternatives to function keys are given in parenthesis.
.TP
\fI?\fR
Display help screen. Dismiss this screen by pressing the space bar.
.TP
\fIF1 (o)\fR
On/Off. Start or stop the
.I cda
daemon.
.TP
\fIF2 (j)\fR
Load or eject the CD.
.TP
\fIF3 (p)\fR
Play, pause or unpause.
.TP
\fIF4 (s)\fR
Stop.
.TP
\fIF5 (k)\fR
Enable/disable the CD caddy lock. When locked, the CD cannot be ejected
using the CD-ROM front-panel eject button.
.TP
\fIF6 (u)\fR
Shuffle/Program.  Pressing this key cycles through three states:
normal, shuffle and program. In shuffle mode, the tracks of the CD
will be played in random order.  On entering program mode,
.I cda
will prompt for a space or comma separated list of track numbers,
representing a desired playing order. The list should be terminated by
carriage return.  An empty list returns
.I cda
to normal mode.  Shuffle and program mode cannot be engaged
unless a CD is loaded but not playing or paused.
.TP
\fIF7 (e)\fR
Enable/disable repeat mode.
.TP
\fIF8 (q)\fR
Terminate the visual mode.  If the
.I cda
daemon is running, a reminder of the fact is given and it is allowed to
continue.  The CD-ROM drive will continue operating in the same state.
.I Cda
may be invoked again in either visual or line mode when required.
.TP
\fID/d\fR
Change to the previous/next disc on multi-disc changes.
.TP
\fICursor left/right (C/c)\fR
Previous/next track. This is only valid if playback is already in
progress.
.TP
\fI</>\fR
Proceed to the previous/next index mark. This is only valid if
playback is already in progress.
.TP
\fICursor up/down (^/v)\fR
Scroll the information portion of the screen up or down. It may be
scrolled up only until the last line is on the top line of the screen,
and may not be scrolled down beyond the initial position. The initial
scroll position is restored when different information is displayed,
(e.g., when switching to or from the help information).
.TP
\fI+/-\fR
Increase or decrease volume by 5%.
.TP
\fIl/r\fR
Move balance 5% to left or right.
.TP
\fITab\fR
Successive depressions of this key change the mode from stereo to mono,
mono right, mono left, reverse stereo, and back to normal stereo.
.TP
\fI<n> [mins secs]\fR
Proceed to track
.I n
at
.I mins
minutes and
.I secs
seconds from the start. If
.I "mins secs"
is not given, start at the beginning of track
.I n.
.TP
\fI^l/^r\fR
Control-l or control-r repaints the screen.  This is useful if the
screen has been corrupted (e.g., by operator messages sent
by the
.I wall(1M)
command).

.SH "CD DATABASE"
The CD Database feature of
.I xmcd
is supported by
.I cda,
which allows you to display the disc artists/title,
track titles, and extended information about the CD
or tracks via the \fBtoc\fR or \fBextinfo\fR commands of
.I cda.
In visual mode, this information is displayed automatically
if available.  You cannot update the CD database via
.I cda.
.I Xmcd
must be used for that purpose.

.SH "ENVIRONMENT"
Several environment variables are currently recognized by
.I cda,
and are described as follows:
.IP \fBXMCD_LIBDIR\fR
This parameter which specifies
the directory path under which
.I cda's
configuration files and CD database files are located.
On most systems this is \fI/usr/lib/X11/xmcd\fR.
.IP \fBXMCD_CDDBPATH\fR
This is used to override the \fIcddbPath\fR common configuration
parameter, which is a list of CD database category directories
to be used under \fBXMCDLIB\fI/cddb\fR.  See
.I xmcd(1)
for details.

.SH "NOTES"
Not all CD-ROM drives support all features that appear on
.I cda.
For example, some drives do not support a software-driven
volume control.  On these drives the
.I cda
\fBvolume\fR and \fBbalance\fR commands may have no effect, or may
simply change the volume between full mute and maximum.
Similarly, the \fBlock\fR, \fBdisc\fR, \fBindex\fR,
and \fBroute\fR commands of
.I cda
may not have any effect on drives that
do not support the appropriate functionality.

.SH "FILES"
$HOME/.xmcdcfg/\(**
.br
XMCDLIB/cddb/\(**
.br
XMCDLIB/config/config.sh
.br
XMCDLIB/config/common.cfg
.br
XMCDLIB/config/device.cfg
.br
XMCDLIB/config/.tbl/\(**
.br
XMCDLIB/config/\(**
.br
XMCDLIB/help/\(**
.br
BINDIR/cda
.br
MANDIR/cda.1
.br
/tmp/.cdaudio/\(**

.SH "RELATED WEB SITES"
Xmcd/cda home page: \fIhttp://metalab.unc.edu/tkan/xmcd/\fR
.br
CD database server page: \fIhttp://www.cddb.com/\fR
.br
Xmmix home page: \fIhttp://metalab.unc.edu/tkan/xmmix/\fR

.SH "SEE ALSO"
xmcd(1), cddbcmd(1), wm2xmcd(1), X(1),
.br
Xmcd's README and INSTALL files
.br
Xmcd web site: http://metalab.unc.edu/tkan/xmcd/
.br
CDDB web site: http://www.cddb.com/

.SH "AUTHOR"
Ti Kan (\fIti@amb.org\fR)
.br
AMB Research Laboratories, Sunnyvale, CA, U.S.A.
.PP
.I Cda
also contains code contributed by several dedicated individuals.
See the README file in the
.I cda
distribution for information.
.PP
Comments, suggestions, and bug reports are always welcome.
