// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        progress.h
//
// Purpose:     interface to progress indicator
//
// Created:     18 Jan 94   Michael Pichler
//
// $Id: progress.h,v 1.3 1996/02/07 15:31:02 bmarsch Exp $
//
//</file>
//
// $Log: progress.h,v $
// Revision 1.3  1996/02/07 15:31:02  bmarsch
// progressb.h moved to HgUtils
//


#ifndef harmony_widgets_progress_h
#define harmony_widgets_progress_h

#include "libwidgets.h"
#include <hyperg/utils/progressb.h>

#include <InterViews/patch.h>
class Color;
class Font;
class Requisition;



// Class Progress - progress indicator
//
// style names: Progress, ProgressLabel
//
// style attributes: foreground, background, font (IV)
// boolean Progress.showLabel is on by default


class Progress: public ProgressBase, public Patch
{
  public:
    Progress();
    ~Progress();

    // ProgressBase
    virtual void set(                   // set progress
      float p,                          //   to a fraction of 1.0
      int repair = 1                    //   default: immediate repair
    );  

    virtual float get() const           // get current progess
    { return p_; }                      //   as fraction of 1.0

    // Patch
    void draw (Canvas*, const Allocation&) const;

    void allocate (Canvas*, const Allocation&, Extension&);
    void request (Requisition& req) const;

  private:
    float p_;
    const Color* fgcolor_;
    const Color* bgcolor_;
    const Color* fntcolor_;
    const Font* font_;
    float charwidths_ [5];  // "nnn %"
    float charheight_;
};



#endif
