// -*- C++ -*-
//<copyright>
//
// Copyright (c) 1996
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name:    japanconvertwizard.h
//
// Purpose: Convert from and to Shift-JIS, EUC, New-JIS, Old-JIS, and NEC-JIS
//
// Created: 10 Sep 1996 Juergen Schipflinger
//
// $Id: japanconvertwizard.h,v 1.2 1996/10/03 15:59:07 jfasch Exp $
//
// Description:
//
//   This class takes an istream and supports functions to convert
//   japanese encodings to other japanese encodings. There is also a
//   function to detect the coding type, and some further usefull
//   functions.
//
// Credits:
//   Most of the code is taken from the tool jconv
//     Program: jconv.c
//     Version: 3.0
//     Date:    July 1, 1993
//     Author:  Ken R. Lunde, Adobe Systems Incorporated
//       EMAIL: lunde@mv.us.adobe.com
//       MAIL : 1585 Charleston Road, P.O. Box 7900, Mountain View, CA 94039-7900

//</file>
//
/*
 * $Log: japanconvertwizard.h,v $
 * Revision 1.2  1996/10/03 15:59:07  jfasch
 * adaptions due to moving it from the previous location in DcCommon to HgUtilities
 *
 * Revision 1.1  1996/09/11 07:11:56  jfasch
 * Initial revision
 *
*/

#ifndef hg_utils_japanconvertwizard_h
#define hg_utils_japanconvertwizard_h

#include "smartptr.h"
#include "str.h"

//<class>
//
// Name:    JapanConvertWizard
//
// Purpose: Convert from and to Shift-JIS, EUC, New-JIS, Old-JIS, and NEC-JIS
//
// Public Interface:
//
// Description:
//
//</class>

class istream;
class ostream;
class RString;

class JapanConvertWizard : public RefCounted
{
public:
  enum Coding{
    NEW_JIS,
    OLD_JIS,
    NEC_JIS,
    EUC,
    SHIFT_JIS,
    EUC_OR_SJIS,  // ambiguous Shift-JIS or EUC
    ASCII,        // no code japanese detected
    AUTO_DETECT,  // internal use
    NOT_SET       // internal use
  };

  JapanConvertWizard(istream*,bool destroy=false);
  virtual ~JapanConvertWizard();
  JapanConvertWizard& setInCoding(Coding incode)// default is autodedect
  {incode_=incode;return *this;}
  JapanConvertWizard& setOutCoding(Coding outcode)// default is SHIFT-JIS
  {outcode_=outcode;return *this;}
  JapanConvertWizard& forceHalfToFullWidthKatakana(bool force=true)
  {forceHTFWK_=force;return *this;}
  Coding detectCodeType();
  Coding convert(ostream*);
  Coding removeESCChars(ostream*); // till now not implemented
  Coding repairESCChars(ostream*); // till now not implemented
  RString getCodeName(Coding)const;

private:
  istream* instream_;
  bool destroyInstream_;
  ostream* outstream_;
  Coding incode_;
  Coding outcode_;
  char ki_[10];
  char ko_[10];
  bool forceHTFWK_;

  void setESC(bool repair=false); // set esc chars for outcode_

  bool skipESCSeq(int temp,bool& intwobyte);

  void jis2sjis(int& p1, int& p2);
  void sjis2jis(int& p1, int& p2);

  void seven2seven();
  void seven2euc();
  void seven2shift();

  void euc2seven();
  void euc2euc();
  void euc2shift();

  void shift2seven();
  void shift2euc();
  void shift2shift();

  void han2zen(int &p1,int &p2);
};

SmartPtrdeclare (JapanConvertWizardPtr, JapanConvertWizard) ;


#endif /* hg_path_japanconvertwizard_h */
