#!/usr/bin/env ruby

require 'openssl'
include OpenSSL
include X509
include PKey

p key = RSA.new(2048)
p new = Certificate.new
name = [['C', 'CZ'],['O','Ruby'],['CN','RubyCA']]
p new.subject = Name.new(name)
p new.issuer = Name.new(name)
p new.not_before = Time.now
p new.not_after = Time.now + (2*365*24*60*60)
p new.public_key = key
p new.serial = 0
p new.version = 3
ef = ExtensionFactory.new
ef.subject_certificate = new
p ext1 = ef.create_extension("basicConstraints","CA:TRUE,pathlen:0")
p ext2 = ef.create_extension("nsComment","Generated by OpenSSL for Ruby.")
p ext3 = ef.create_extension("subjectKeyIdentifier", "hash")
new.extensions = [ext1, ext2, ext3]
ef.issuer_certificate = new # we needed subjectKeyInfo inside, now we have it
p ext4 = ef.create_extension("authorityKeyIdentifier", "keyid:always,issuer:always")
p new.add_extension(ext4)
p new.sign(key, Digest::SHA1.new)

f = File.new("./#{new.serial}cert.pem","w")
f.write new.to_pem
f.close

puts "Enter Password:"
p pass = gets.chop!

f = File.new("./#{new.serial}key.pem", "w")
f.write key.export(Cipher::DES.new(Cipher::EDE3, Cipher::CBC), pass)
f.close

