import os, sys, ftplib, getpass

# Upload the files via ftp. (Could need a bit more error-checking.)
def upload(fqdn, login, incoming, files_to_upload, debug, ftp_mode):
    try:
        ftp_connection = ftplib.FTP(fqdn)
        if debug:
            print "D: FTP-Connection to host: %s" % fqdn
    except ftplib.all_errors, e:
        print "Connection failed, aborting. Check your network", e
        sys.exit(1)
    prompt = login + "@" + fqdn + " password: "
    if login == 'anonymous':
        password = 'dput@packages.debian.org'
    else:
        password = getpass.getpass(prompt)
    try:
        ftp_connection.login(login,password)
    except ftplib.error_perm:
        print "Wrong Password"
        sys.exit(1)
    if ftp_mode == 1:
        ftp_connection.set_pasv(1)
    ftp_connection.cwd(incoming)
    if debug:
        print "D: Directory to upload to: %s" % incoming
    for file in files_to_upload:
        path_to_package, package_name = os.path.split(file)
        try:
            if debug:
                print "D: Uploading File: %s" % file
            ftp_connection.storbinary('STOR ' + package_name, \
                    open(file,'r'), 1024)
            print "Uploaded via ftp: %s" % package_name
        except ftplib.all_errors:
            print "Error while uploading %s" % package_name
            sys.exit(1)
    ftp_connection.quit()
