//------------------------------------------------------------------------------
// <auto-generated />
//
// This file was automatically generated by SWIG (http://www.swig.org).
// Version 4.0.2
//
// Do not make changes to this file unless you know what you are doing--modify
// the SWIG interface file instead.
//------------------------------------------------------------------------------

namespace libsbml {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html A single unit referenced in an SBML <em>unit definition</em>.
 *
 * The SBML unit definition facility uses two classes of objects,
 * UnitDefinition and Unit.  The approach to defining units in %SBML is
 * compositional; for example, <em>meter second<sup> &ndash;2</sup></em> is
 * constructed by combining a Unit object representing <em>meter</em> with
 * another Unit object representing <em>second<sup> &ndash;2</sup></em>.
 * The combination is wrapped inside a UnitDefinition, which provides for
 * assigning an identifier and optional name to the combination.  The
 * identifier can then be referenced from elsewhere in a model.  Thus, the
 * UnitDefinition class is the container, and Unit instances are placed
 * inside UnitDefinition instances.
 *
 * A Unit has four attributes named 'kind', 'exponent', 'scale'
 * and 'multiplier'.  It represents a (possibly transformed) reference to a
 * base unit.  The attribute 'kind' on Unit indicates the chosen base unit.
 * Its value must be one of the text strings listed below; this list
 * corresponds to SBML Level&nbsp;3:
 *
 *
 * 
<table border='0' class='centered text-table width80 normal-font code'
       style='border: none !important'>
<tr>
<td>ampere</td><td>farad</td><td>joule</td><td>lux</td><td>radian</td><td>volt</td>
</tr>
<tr>
<td>avogadro</td><td>gram</td><td>katal</td><td>metre</td><td>second</td><td>watt</td>
</tr>
<tr>
<td>becquerel</td><td>gray</td><td>kelvin</td><td>mole</td><td>siemens</td><td>weber</td>
</tr>
<tr>
<td>candela</td><td>henry</td><td>kilogram</td><td>newton</td><td>sievert</td>
</tr>
<tr>
<td>coulomb</td><td>hertz</td><td>litre</td><td>ohm</td><td>steradian</td>
</tr>
<tr>
<td>dimensionless</td><td>item</td><td>lumen</td><td>pascal</td><td>tesla</td>
</tr>
</table>
 *
 *
 *
 * A few small differences exist between the Level&nbsp;3 list of base
 * units and the list defined in other Level/Version combinations of SBML.
 * Specifically, Levels of SBML before Level&nbsp;3 do not define
 * @c avogadro; conversely, Level&nbsp;2 Version&nbsp;1 defines @c Celsius,
 * and Level&nbsp;1 defines @c celsius, @c meter, and @c liter, none of
 * which are available in Level&nbsp;3.  In libSBML, each of the predefined
 * base unit names is represented by an enumeration value @if clike in
 * #UnitKind_t@else whose name begins with the characters
 * <code>UNIT_KIND_</code>@endif, discussed in a separate section below.
 *
 * The attribute named 'exponent' on Unit represents an exponent on the
 * unit.  In SBML Level&nbsp;2, the attribute is optional and has a default
 * value of @c 1 (one); in SBML Level&nbsp;3, the attribute is mandatory
 * and there is no default value.  A Unit also has an attribute
 * called 'scale'; its value must be an integer exponent for a power-of-ten
 * multiplier used to set the scale of the unit.  For example, a unit
 * having a 'kind' value of @c gram and a 'scale' value of @c -3 signifies
 * 10<sup>&nbsp;&ndash;3</sup> * gram, or milligrams.  In SBML
 * Level&nbsp;2, the attribute is optional and has a default value of @c 0
 * (zero), because 10<sup> 0</sup> = 1; in SBML Level&nbsp;3, the attribute
 * is mandatory and has no default value.  Lastly, the attribute named
 * 'multiplier' can be used to multiply the unit by a real-numbered factor;
 * this enables the definition of units that are not power-of-ten multiples
 * of SI units.  For instance, a multiplier of 0.3048 could be used to
 * define @c foot as a measure of length in terms of a @c metre.  The
 * 'multiplier' attribute is optional in SBML Level&nbsp;2, where it has a
 * default value of @c 1 (one); in SBML Level&nbsp;3, the attribute is
 * mandatory and has no default value.
 *
 * @if clike
 * <h3><a class='anchor' name='UnitKind_t'>UnitKind_t</a></h3>
 * @else
 * <h3><a class='anchor' name='UnitKind_t'>%Unit identification codes</a></h3>
 * @endif
 *
 * As discussed above, SBML defines a set of base units which serves as the
 * starting point for new unit definitions.  This set of base units
 * consists of the SI units and a small number of additional convenience
 * units.
 * 
 * @if clike Until SBML Level&nbsp;2 Version&nbsp;3, there
 * existed a data type in the SBML specifications called @c UnitKind,
 * enumerating the possible SBML base units.  Although SBML Level&nbsp;2
 * Version&nbsp;3 removed this type from the language specification,
 * libSBML maintains the corresponding enumeration type #UnitKind_t as a
 * convenience and as a way to provide backward compatibility to previous
 * SBML Level/Version specifications.  (The removal in SBML Level&nbsp;2
 * Version&nbsp;3 of the enumeration @c UnitKind was also accompanied by
 * the redefinition of the data type @c UnitSId to include the previous
 * @c UnitKind values as reserved symbols in the @c UnitSId space.  This
 * change has no net effect on permissible models, their representation or
 * their syntax.  The purpose of the change in the SBML specification was
 * simply to clean up an inconsistency about the contexts in which these
 * values were usable.)
 * @endif@if java In SBML Level&nbsp;2 Versions before
 * Version&nbsp;3, there existed an enumeration of units called
 * @c UnitKind.  In Version&nbsp;3, this enumeration was removed and the
 * identifier class @c UnitSId redefined to include the previous
 * @c UnitKind values as reserved symbols.  This change has no net effect on
 * permissible models, their representation or their syntax.  The purpose
 * of the change in the SBML specification was simply to clean up an
 * inconsistency about the contexts in which these values were usable.
 * However, libSBML maintains UnitKind in the form of of a set of static
 * integer constants whose names begin with the characters
 * <code>UNIT_KIND_</code>.  These constants are defined in the class
 * <code><a href='libsbml.libsbml.html'>libsbmlConstants</a></code>.
 * @endif@if python In SBML Level&nbsp;2 Versions before
 * Version&nbsp;3, there existed an enumeration of units called
 * @c UnitKind.  In Version&nbsp;3, this enumeration was removed and the
 * identifier class @c UnitSId redefined to include the previous
 * @c UnitKind values as reserved symbols.  This change has no net effect on
 * permissible models, their representation or their syntax.  The purpose
 * of the change in the SBML specification was simply to clean up an
 * inconsistency about the contexts in which these values were usable.
 * However, libSBML maintains UnitKind in the form of of a set of static
 * integer constants whose names begin with the characters
 * <code>UNIT_KIND_</code>.  These constants are defined in the class
 * @link libsbml libsbml@endlink.
 * @endif
 *
 * As a consequence of the fact that libSBML supports models in all Levels
 * and Versions of SBML, libSBML's set of @c UNIT_KIND_ values is a union
 * of all the possible base unit names defined in the different SBML
 * specifications.  However, not every base unit is allowed in every
 * Level+Version combination of SBML.  Note in particular the following
 * exceptions:
 * <ul>
 * <li> The alternate spelling @c 'meter' is included in
 * addition to the official SI spelling @c 'metre'.  This spelling is only
 * permitted in SBML Level&nbsp;1 models.
 *
 * <li> The alternate spelling @c 'liter' is included in addition to the
 * official SI spelling @c 'litre'.  This spelling is only permitted in
 * SBML Level&nbsp;1 models.
 *
 * <li> The unit @c 'Celsius' is included because of its presence in
 * specifications of SBML prior to SBML Level&nbsp;2 Version&nbsp;2.
 *
 * <li> The unit @c avogadro was introduced in SBML Level&nbsp;3, and
 * is only permitted for use in SBML Level&nbsp;3 models.
 * </ul>
 *
 * @if clike The table below lists the symbols defined in the
 * @c UnitKind_t enumeration, and their
 * meanings. @else The table below lists the unit
 * constants defined in libSBML, and their meanings. @endif
 *
 * @htmlinclude unitkind-table.html
 * 
 * 
 */

public class Unit : SBase {
	private HandleRef swigCPtr;
	
	internal Unit(IntPtr cPtr, bool cMemoryOwn) : base(libsbmlPINVOKE.Unit_SWIGUpcast(cPtr), cMemoryOwn)
	{
		//super(libsbmlPINVOKE.UnitUpcast(cPtr), cMemoryOwn);
		swigCPtr = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(Unit obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (Unit obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  protected override void Dispose(bool disposing) {
    lock(this) {
      if (swigCPtr.Handle != global::System.IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_Unit(swigCPtr);
        }
        swigCPtr = new global::System.Runtime.InteropServices.HandleRef(null, global::System.IntPtr.Zero);
      }
      base.Dispose(disposing);
    }
  }

  
/**
   * Creates a new Unit using the given SBML @p level and @p version
   * values.
   *
   * @param level a long integer, the SBML Level to assign to this Unit.
   *
   * @param version a long integer, the SBML Version to assign to this
   * Unit.
   *
   *
 * @throws SBMLConstructorException
 * Thrown if the given @p level and @p version combination are invalid
 * or if this object is incompatible with the given level and version.
 *
 *
   *
   *
 * @note Attempting to add an object to an SBMLDocument having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * SBMLDocument), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
 *
 *
   */ public
 Unit(long level, long version) : this(libsbmlPINVOKE.new_Unit__SWIG_0(level, version), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new Unit using the given SBMLNamespaces object
   * @p sbmlns.
   *
   *
 * 
 * The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's SBMLNamespaces facilities is to create an
 * SBMLNamespaces object somewhere in a program once, then hand that object
 * as needed to object constructors that accept SBMLNamespaces as arguments.
 *
 *
   * 
   * @param sbmlns an SBMLNamespaces object.
   *
   *
 * @throws SBMLConstructorException
 * Thrown if the given @p sbmlns is inconsistent or incompatible
 * with this object.
 *
 *
   *
   *
 * @note Attempting to add an object to an SBMLDocument having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * SBMLDocument), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
 *
 *
   */ public
 Unit(SBMLNamespaces sbmlns) : this(libsbmlPINVOKE.new_Unit__SWIG_1(SBMLNamespaces.getCPtr(sbmlns)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Copy constructor; creates a copy of this Unit.
   *
   * @param orig the object to copy.
   */ public
 Unit(Unit orig) : this(libsbmlPINVOKE.new_Unit__SWIG_2(Unit.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates and returns a deep copy of this Unit object.
   *
   * @return the (deep) copy of this Unit object.
   */ public new
 Unit clone() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Unit_clone(swigCPtr);
    Unit ret = (cPtr == global::System.IntPtr.Zero) ? null : new Unit(cPtr, true);
    return ret;
  }

  
/**
   * Initializes the fields of this Unit object to 'typical' default
   * values.
   *
   * The SBML Unit component has slightly different aspects and default
   * attribute values in different SBML Levels and Versions.  This method
   * sets the values to certain common defaults, based mostly on what they
   * are in SBML Level&nbsp;2.  Specifically:
   * <ul>
   * <li> Sets attribute 'exponent' to @c 1
   * <li> Sets attribute 'scale' to @c 0
   * <li> Sets attribute 'multiplier' to @c 1.0
   * </ul>
   *
   * The 'kind' attribute is left unchanged.
   */ public
 void initDefaults() {
    libsbmlPINVOKE.Unit_initDefaults(swigCPtr);
  }

  
/**
   * Returns the 'kind' of Unit this is.
   * 
   * @if clike
   * @return the value of the 'kind' attribute of this Unit as a
   * value from the <a class='el' href='#UnitKind_t'>UnitKind_t</a> enumeration.
   * @endif@if java
   * @return the value of the 'kind' attribute of this Unit as a
   * value from the set of constants whose names begin
   * with <code>UNIT_KIND_</code> defined in the class
   * <code><a href='libsbml.libsbml.html'>libsbmlConstants</a></code>.
   * @endif@if python
   * @return the value of the 'kind' attribute of this Unit as a
   * value from the set of constants whose names begin
   * with <code>UNIT_KIND_</code> defined in the class
   * @link libsbml libsbml@endlink.
   * @endif
   */ public
 int getKind() {
    int ret = libsbmlPINVOKE.Unit_getKind(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'exponent' attribute of this unit.
   * 
   * @return the 'exponent' value of this Unit, as an integer.
   */ public
 int getExponent() {
    int ret = libsbmlPINVOKE.Unit_getExponent(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'exponent' attribute of this unit.
   * 
   * @return the 'exponent' value of this Unit, as a double.
   */ public
 double getExponentAsDouble() {
    double ret = libsbmlPINVOKE.Unit_getExponentAsDouble(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'scale' attribute of this unit.
   * 
   * @return the 'scale' value of this Unit, as an integer.
   */ public
 int getScale() {
    int ret = libsbmlPINVOKE.Unit_getScale(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'multiplier' attribute of this Unit.
   * 
   * @return the 'multiplier' value of this Unit, as a double.
   */ public
 double getMultiplier() {
    double ret = libsbmlPINVOKE.Unit_getMultiplier(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'offset' attribute of this Unit.
   * 
   * @return the 'offset' value of this Unit, as a double.
   *
   *
 * @warning <span class='warning'>The 'offset' attribute is only available in
 * SBML Level&nbsp;2 Version&nbsp;1.  This attribute is not present in SBML
 * Level&nbsp;2 Version&nbsp;2 or above.  When producing SBML models using
 * these later specifications, modelers and software tools need to account
 * for units with offsets explicitly.  The %SBML specification document
 * offers a number of suggestions for how to achieve this.  LibSBML methods
 * such as this one related to 'offset' are retained for compatibility with
 * earlier versions of SBML Level&nbsp;2, but their use is strongly
 * discouraged.</span>
 *
   */ public
 double getOffset() {
    double ret = libsbmlPINVOKE.Unit_getOffset(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c ampere.
   * 
   * @return @c true if the kind of this Unit is @c ampere, @c false
   * otherwise. 
   */ public
 bool isAmpere() {
    bool ret = libsbmlPINVOKE.Unit_isAmpere(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c avogadro.
   * 
   * @return @c true if the kind of this Unit is @c avogadro, @c false
   * otherwise.
   *
   * @note The unit @c avogadro was introduced in SBML Level&nbsp;3, and
   * is only permitted for use in SBML Level&nbsp;3 models.
   */ public
 bool isAvogadro() {
    bool ret = libsbmlPINVOKE.Unit_isAvogadro(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c becquerel
   *
   * @return @c true if the kind of this Unit is @c becquerel, @c false
   * otherwise. 
   */ public
 bool isBecquerel() {
    bool ret = libsbmlPINVOKE.Unit_isBecquerel(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c candela
   *
   * @return @c true if the kind of this Unit is @c candela, @c false
   * otherwise. 
   */ public
 bool isCandela() {
    bool ret = libsbmlPINVOKE.Unit_isCandela(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c Celsius
   *
   * @return @c true if the kind of this Unit is @c Celsius, @c false
   * otherwise. 
   *
   * @warning <span class='warning'>The predefined unit @c Celsius was
   * removed from the list of predefined units in SBML Level&nbsp;2
   * Version&nbsp;2 at the same time that the 'offset' attribute was removed
   * from Unit definitions.  LibSBML methods such as this one related to
   * @c Celsius are retained in order to support SBML Level&nbsp;2
   * Version&nbsp;1, but their use is strongly discouraged.</span>
   */ public
 bool isCelsius() {
    bool ret = libsbmlPINVOKE.Unit_isCelsius(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c coulomb
   *
   * @return @c true if the kind of this Unit is @c coulomb, @c false
   * otherwise. 
   */ public
 bool isCoulomb() {
    bool ret = libsbmlPINVOKE.Unit_isCoulomb(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind
   * @c dimensionless.
   *
   * @return @c true if the kind of this Unit is @c dimensionless, @c false
   * otherwise.
   */ public
 bool isDimensionless() {
    bool ret = libsbmlPINVOKE.Unit_isDimensionless(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c farad
   *
   * @return @c true if the kind of this Unit is @c farad, @c false
   * otherwise. 
   */ public
 bool isFarad() {
    bool ret = libsbmlPINVOKE.Unit_isFarad(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c gram
   *
   * @return @c true if the kind of this Unit is @c gram, @c false
   * otherwise. 
   */ public
 bool isGram() {
    bool ret = libsbmlPINVOKE.Unit_isGram(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c gray
   *
   * @return @c true if the kind of this Unit is @c gray, @c false
   * otherwise. 
   */ public
 bool isGray() {
    bool ret = libsbmlPINVOKE.Unit_isGray(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c henry
   *
   * @return @c true if the kind of this Unit is @c henry, @c false
   * otherwise. 
   */ public
 bool isHenry() {
    bool ret = libsbmlPINVOKE.Unit_isHenry(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c hertz
   *
   * @return @c true if the kind of this Unit is @c hertz, @c false
   * otherwise. 
   */ public
 bool isHertz() {
    bool ret = libsbmlPINVOKE.Unit_isHertz(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c item
   *
   * @return @c true if the kind of this Unit is @c item, @c false
   * otherwise. 
   */ public
 bool isItem() {
    bool ret = libsbmlPINVOKE.Unit_isItem(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c joule
   *
   * @return @c true if the kind of this Unit is @c joule, @c false
   * otherwise. 
   */ public
 bool isJoule() {
    bool ret = libsbmlPINVOKE.Unit_isJoule(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c katal
   *
   * @return @c true if the kind of this Unit is @c katal, @c false
   * otherwise. 
   */ public
 bool isKatal() {
    bool ret = libsbmlPINVOKE.Unit_isKatal(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c kelvin
   *
   * @return @c true if the kind of this Unit is @c kelvin, @c false
   * otherwise. 
   */ public
 bool isKelvin() {
    bool ret = libsbmlPINVOKE.Unit_isKelvin(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c kilogram
   *
   * @return @c true if the kind of this Unit is @c kilogram, @c false
   * otherwise. 
   */ public
 bool isKilogram() {
    bool ret = libsbmlPINVOKE.Unit_isKilogram(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c litre
   *
   * @return @c true if the kind of this Unit is @c litre or 'liter',
   * @c false otherwise.
   */ public
 bool isLitre() {
    bool ret = libsbmlPINVOKE.Unit_isLitre(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c lumen
   *
   * @return @c true if the kind of this Unit is @c lumen, @c false
   * otherwise. 
   */ public
 bool isLumen() {
    bool ret = libsbmlPINVOKE.Unit_isLumen(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c lux
   *
   * @return @c true if the kind of this Unit is @c lux, @c false
   * otherwise. 
   */ public
 bool isLux() {
    bool ret = libsbmlPINVOKE.Unit_isLux(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c metre
   *
   * @return @c true if the kind of this Unit is @c metre or 'meter',
   * @c false 
   * otherwise.
   */ public
 bool isMetre() {
    bool ret = libsbmlPINVOKE.Unit_isMetre(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c mole
   *
   * @return @c true if the kind of this Unit is @c mole, @c false
   * otherwise. 
   */ public
 bool isMole() {
    bool ret = libsbmlPINVOKE.Unit_isMole(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c newton
   *
   * @return @c true if the kind of this Unit is @c newton, @c false
   * otherwise. 
   */ public
 bool isNewton() {
    bool ret = libsbmlPINVOKE.Unit_isNewton(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c ohm
   *
   * @return @c true if the kind of this Unit is @c ohm, @c false
   * otherwise. 
   */ public
 bool isOhm() {
    bool ret = libsbmlPINVOKE.Unit_isOhm(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c pascal
   *
   * @return @c true if the kind of this Unit is @c pascal, @c false
   * otherwise. 
   */ public
 bool isPascal() {
    bool ret = libsbmlPINVOKE.Unit_isPascal(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c radian
   *
   * @return @c true if the kind of this Unit is @c radian, @c false
   * otherwise. 
   */ public
 bool isRadian() {
    bool ret = libsbmlPINVOKE.Unit_isRadian(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c second
   *
   * @return @c true if the kind of this Unit is @c second, @c false
   * otherwise. 
   */ public
 bool isSecond() {
    bool ret = libsbmlPINVOKE.Unit_isSecond(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c siemens
   *
   * @return @c true if the kind of this Unit is @c siemens, @c false
   * otherwise. 
   */ public
 bool isSiemens() {
    bool ret = libsbmlPINVOKE.Unit_isSiemens(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c sievert
   *
   * @return @c true if the kind of this Unit is @c sievert, @c false
   * otherwise. 
   */ public
 bool isSievert() {
    bool ret = libsbmlPINVOKE.Unit_isSievert(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c steradian
   *
   * @return @c true if the kind of this Unit is @c steradian, @c false
   * otherwise. 
   */ public
 bool isSteradian() {
    bool ret = libsbmlPINVOKE.Unit_isSteradian(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c tesla
   *
   * @return @c true if the kind of this Unit is @c tesla, @c false
   * otherwise. 
   */ public
 bool isTesla() {
    bool ret = libsbmlPINVOKE.Unit_isTesla(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c volt
   *
   * @return @c true if the kind of this Unit is @c volt, @c false
   * otherwise. 
   */ public
 bool isVolt() {
    bool ret = libsbmlPINVOKE.Unit_isVolt(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c watt
   *
   * @return @c true if the kind of this Unit is @c watt, @c false
   * otherwise. 
   */ public
 bool isWatt() {
    bool ret = libsbmlPINVOKE.Unit_isWatt(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether this Unit is of the kind @c weber
   *
   * @return @c true if the kind of this Unit is @c weber, @c false
   * otherwise. 
   */ public
 bool isWeber() {
    bool ret = libsbmlPINVOKE.Unit_isWeber(swigCPtr);
    return ret;
  }

  
/**
   * Predicate to test whether the 'kind' attribute of this Unit is set.
   * 
   * @return @c true if the 'kind' attribute of this Unit is set,
   * @c false otherwise.
   */ public
 bool isSetKind() {
    bool ret = libsbmlPINVOKE.Unit_isSetKind(swigCPtr);
    return ret;
  }

  
/**
   * Predicate to test whether the 'exponent' attribute of this Unit 
   * is set.
   * 
   * @return @c true if the 'exponent' attribute of this Unit is set, 
   * @c false otherwise.
   */ public
 bool isSetExponent() {
    bool ret = libsbmlPINVOKE.Unit_isSetExponent(swigCPtr);
    return ret;
  }

  
/**
   * Predicate to test whether the 'scale' attribute of this Unit 
   * is set.
   * 
   * @return @c true if the 'scale' attribute of this Unit is set, 
   * @c false otherwise.
   */ public
 bool isSetScale() {
    bool ret = libsbmlPINVOKE.Unit_isSetScale(swigCPtr);
    return ret;
  }

  
/**
   * Predicate to test whether the 'multiplier' attribute of this Unit 
   * is set.
   * 
   * @return @c true if the 'multiplier' attribute of this Unit is set, 
   * @c false otherwise.
   */ public
 bool isSetMultiplier() {
    bool ret = libsbmlPINVOKE.Unit_isSetMultiplier(swigCPtr);
    return ret;
  }

  
/**
   * Predicate to test whether the 'offset' attribute of this Unit 
   * is set.
   * 
   * @return @c true if the 'offset' attribute of this Unit is set, 
   * @c false otherwise.
   *
   *
 * @warning <span class='warning'>The 'offset' attribute is only available in
 * SBML Level&nbsp;2 Version&nbsp;1.  This attribute is not present in SBML
 * Level&nbsp;2 Version&nbsp;2 or above.  When producing SBML models using
 * these later specifications, modelers and software tools need to account
 * for units with offsets explicitly.  The %SBML specification document
 * offers a number of suggestions for how to achieve this.  LibSBML methods
 * such as this one related to 'offset' are retained for compatibility with
 * earlier versions of SBML Level&nbsp;2, but their use is strongly
 * discouraged.</span>
 *
   */ public
 bool isSetOffset() {
    bool ret = libsbmlPINVOKE.Unit_isSetOffset(swigCPtr);
    return ret;
  }

  
/**
   * Sets the 'kind' attribute value of this Unit.
   *
   * @if clike
   * @param kind a value from the <a class='el'
   * href='#UnitKind_t'>UnitKind_t</a> enumeration.
   * @endif@if java
   * @param kind a unit identifier chosen from the set of constants whose
   * names begin with <code>UNIT_KIND_</code> in <code><a
   * href='libsbml.libsbml.html'>libsbmlConstants</a></code>.
   * @endif@if python
   * @param kind a unit identifier chosen from the set of constants whose
   * names begin with <code>UNIT_KIND_</code> in @link libsbml libsbml@endlink.
   * @endif
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   */ public
 int setKind(int kind) {
    int ret = libsbmlPINVOKE.Unit_setKind(swigCPtr, kind);
    return ret;
  }

  
/**
   * Sets the 'exponent' attribute value of this Unit.
   *
   * @param value the integer to which the attribute 'exponent' should be set.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   */ public
 int setExponent(int value) {
    int ret = libsbmlPINVOKE.Unit_setExponent__SWIG_0(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'exponent' attribute value of this Unit.
   *
   * @param value the double to which the attribute 'exponent' should be set.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   */ public
 int setExponent(double value) {
    int ret = libsbmlPINVOKE.Unit_setExponent__SWIG_1(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'scale' attribute value of this Unit.
   *
   * @param value the integer to which the attribute 'scale' should be set.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   */ public
 int setScale(int value) {
    int ret = libsbmlPINVOKE.Unit_setScale(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'multipler' attribute value of this Unit.
   *
   * @param value the floating-point value to which the attribute
   * 'multiplier' should be set.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   */ public
 int setMultiplier(double value) {
    int ret = libsbmlPINVOKE.Unit_setMultiplier(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'offset' attribute value of this Unit.
   *
   * @param value the floating point value to which the attribute 'offset'
   * should set.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   *
 * @warning <span class='warning'>The 'offset' attribute is only available in
 * SBML Level&nbsp;2 Version&nbsp;1.  This attribute is not present in SBML
 * Level&nbsp;2 Version&nbsp;2 or above.  When producing SBML models using
 * these later specifications, modelers and software tools need to account
 * for units with offsets explicitly.  The %SBML specification document
 * offers a number of suggestions for how to achieve this.  LibSBML methods
 * such as this one related to 'offset' are retained for compatibility with
 * earlier versions of SBML Level&nbsp;2, but their use is strongly
 * discouraged.</span>
 *
   */ public
 int setOffset(double value) {
    int ret = libsbmlPINVOKE.Unit_setOffset(swigCPtr, value);
    return ret;
  }

  
/**
   * Unsets the 'kind' attribute value of this Unit.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   */ public
 int unsetKind() {
    int ret = libsbmlPINVOKE.Unit_unsetKind(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'exponent' attribute value of this Unit.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   */ public
 int unsetExponent() {
    int ret = libsbmlPINVOKE.Unit_unsetExponent(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'scale' attribute value of this Unit.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   */ public
 int unsetScale() {
    int ret = libsbmlPINVOKE.Unit_unsetScale(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'multipler' attribute value of this Unit.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   */ public
 int unsetMultiplier() {
    int ret = libsbmlPINVOKE.Unit_unsetMultiplier(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'offset' attribute value of this Unit.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   *
 * @warning <span class='warning'>The 'offset' attribute is only available in
 * SBML Level&nbsp;2 Version&nbsp;1.  This attribute is not present in SBML
 * Level&nbsp;2 Version&nbsp;2 or above.  When producing SBML models using
 * these later specifications, modelers and software tools need to account
 * for units with offsets explicitly.  The %SBML specification document
 * offers a number of suggestions for how to achieve this.  LibSBML methods
 * such as this one related to 'offset' are retained for compatibility with
 * earlier versions of SBML Level&nbsp;2, but their use is strongly
 * discouraged.</span>
 *
   */ public
 int unsetOffset() {
    int ret = libsbmlPINVOKE.Unit_unsetOffset(swigCPtr);
    return ret;
  }

  
/**
   * Returns the libSBML type code of this object instance.
   *
   *
 * 
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * @if clike The set of possible type codes for core elements is defined in
 * the enumeration #SBMLTypeCode_t, and in addition, libSBML plug-ins for
 * SBML Level&nbsp;3 packages define their own extra enumerations of type
 * codes (e.g., #SBMLLayoutTypeCode_t for the Level&nbsp;3 Layout
 * package).@endif@if java In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.  @endif@if python In the Python language
 * interface for libSBML, the type codes are defined as static integer
 * constants in the interface class @link libsbml@endlink.@endif@if csharp In
 * the C# language interface for libSBML, the type codes are defined as
 * static integer constants in the interface class
 * @link libsbmlcs.libsbml@endlink.@endif  Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the 
 * <code>@if conly SBase_getPackageName()
 * @else SBase::getPackageName()
 * @endif</code>
 * method on the object.
 *
 * The exception to this is lists:  all SBML-style list elements have the type 
 * @link libsbml#SBML_LIST_OF SBML_LIST_OF@endlink, regardless of what package they 
 * are from.
 *
 *
   *
   * @return the SBML type code for this object:
   * @link libsbml#SBML_UNIT SBML_UNIT@endlink (default).
   *
   *
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getPackageName() and getTypeCode()</strong> (or 
 * ListOf::getItemTypeCode()).</span>
 *
 *
   *
   * @see getPackageName()
   * @see getElementName()
   */ public new
 int getTypeCode() {
    int ret = libsbmlPINVOKE.Unit_getTypeCode(swigCPtr);
    return ret;
  }

  
/**
   * Returns the XML element name of this object, which for Unit, is
   * always @c 'unit'.
   * 
   * @return the name of this element, i.e., @c 'unit'. 
   */ public new
 string getElementName() {
    string ret = libsbmlPINVOKE.Unit_getElementName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate to test whether a given string is the name of a built-in SBML
   * unit, depending on the SBML level, since new predefined units were added
   * between level 2 versions 1 and 2, and then all predefined units were removed
   * again in SBML Level 3.
   *
   * @param name a string to be tested against the built-in unit names.
   * @param level the level of SBML one is checking.
   *
   * @return @c true if @p name is one of @c 'substance', @c 'volume',
   * or @c 'time' and the @p level is @c 1; or if @p name is one of
   * @c 'substance', @c 'volume', @c 'area', @c 'length', or @c 'time' and
   * the @p level is @c 2; @c false otherwise (including all values when
   * @p level is @c 3).
   *
   *
   *
 * @if python @note Because this is a static method on a class, the Python
 * language interface for libSBML will contain two variants.  One will be the
 * expected, normal static method on the class (i.e., a regular
 * <em>methodName</em>), and the other will be a standalone top-level
 * function with the name <em>ClassName_methodName()</em>. This is merely an
 * artifact of how the language interfaces are created in libSBML.  The
 * methods are functionally identical. @endif
 *
 *
   */ public
 static bool isBuiltIn(string name, long level) {
    bool ret = libsbmlPINVOKE.Unit_isBuiltIn(name, level);
    return ret;
  }

  
/**
   * Predicate to test whether a given string is the name of a valid
   * base unit in SBML (such as @c 'gram' or @c 'mole').
   *
   * This method exists because prior to SBML Level&nbsp;2 Version&nbsp;3,
   * an enumeration called @c UnitKind was defined by SBML.  This enumeration
   * was removed in SBML Level&nbsp;2 Version&nbsp;3 and its values were
   * folded into the space of values of a type called @c UnitSId.  This method
   * therefore has less significance in SBML Level&nbsp;2 Version&nbsp;3
   * and Level&nbsp;2 Version&nbsp;4, but remains for backward
   * compatibility and support for reading models in older Versions of
   * Level&nbsp;2.
   *
   * @param name a string to be tested.
   * 
   * @param level a long integer representing the SBML specification
   * Level.
   * 
   * @param version a long integer representing the SBML specification
   * Version.
   * 
   * @return @c true if name is a valid SBML UnitKind, @c false otherwise.
   *
   * @note The allowed unit names differ between SBML Levels&nbsp;1
   * and&nbsp;2 and again slightly between Level&nbsp;2 Versions&nbsp;1
   * and&nbsp;2.
   *
   *
 * @if python @note Because this is a static method on a class, the Python
 * language interface for libSBML will contain two variants.  One will be the
 * expected, normal static method on the class (i.e., a regular
 * <em>methodName</em>), and the other will be a standalone top-level
 * function with the name <em>ClassName_methodName()</em>. This is merely an
 * artifact of how the language interfaces are created in libSBML.  The
 * methods are functionally identical. @endif
 *
 *
   */ public
 static bool isUnitKind(string name, long level, long version) {
    bool ret = libsbmlPINVOKE.Unit_isUnitKind(name, level, version);
    return ret;
  }

  
/**
   * Predicate returning @c true if two
   * Unit objects are identical.
   *
   * Two Unit objects are considered to be @em identical if they match in
   * all attributes.  (Contrast this to the method areEquivalent(@if java
   * Unit u1, %Unit u2@endif), which compares Unit objects only with respect
   * to certain attributes.)
   *
   * @param unit1 the first Unit object to compare.
   * @param unit2 the second Unit object to compare.
   *
   * @return @c true if all the attributes of unit1 are identical
   * to the attributes of unit2, @c false otherwise.
   *
   *
 * @if python @note Because this is a static method on a class, the Python
 * language interface for libSBML will contain two variants.  One will be the
 * expected, normal static method on the class (i.e., a regular
 * <em>methodName</em>), and the other will be a standalone top-level
 * function with the name <em>ClassName_methodName()</em>. This is merely an
 * artifact of how the language interfaces are created in libSBML.  The
 * methods are functionally identical. @endif
 *
 *
   *
   * @see @if clike areEquivalent() @else Unit::areEquivalent(Unit u1, %Unit u2) @endif
   */ public
 static bool areIdentical(Unit unit1, Unit unit2) {
    bool ret = libsbmlPINVOKE.Unit_areIdentical(Unit.getCPtr(unit1), Unit.getCPtr(unit2));
    return ret;
  }

  
/**
   * Predicate returning @c true if 
   * Unit objects are equivalent.
   *
   * Two Unit objects are considered to be @em equivalent either if (1) both
   * have a 'kind' attribute value of @c dimensionless, or (2) their 'kind',
   * 'exponent' and (for SBML Level&nbsp;2 Version&nbsp;1) 'offset'
   * attribute values are equal. (Contrast this to the method
   * areIdentical(@if java Unit, %Unit@endif), which compares Unit objects with respect to all
   * attributes, not just the 'kind' and 'exponent'.)
   *
   * @param unit1 the first Unit object to compare.
   * @param unit2 the second Unit object to compare.
   *
   * @return @c true if the 'kind' and 'exponent' attributes of unit1 are
   * identical to the kind and exponent attributes of unit2, or if the kind
   * attributes of both are @c dimensionless; @c false otherwise.
   *
   *
 * @if python @note Because this is a static method on a class, the Python
 * language interface for libSBML will contain two variants.  One will be the
 * expected, normal static method on the class (i.e., a regular
 * <em>methodName</em>), and the other will be a standalone top-level
 * function with the name <em>ClassName_methodName()</em>. This is merely an
 * artifact of how the language interfaces are created in libSBML.  The
 * methods are functionally identical. @endif
 *
 *
   * 
   * @see @if clike areIdentical() @else Unit::areIdentical(Unit u1, %Unit u2) @endif
   */ public
 static bool areEquivalent(Unit unit1, Unit unit2) {
    bool ret = libsbmlPINVOKE.Unit_areEquivalent(Unit.getCPtr(unit1), Unit.getCPtr(unit2));
    return ret;
  }

  
/**
   * Manipulates the attributes of the Unit to express the unit with the 
   * value of the scale attribute reduced to zero.
   *
   * For example, 1 millimetre can be expressed as a Unit with kind=
   * @c 'metre' multiplier=@c '1' scale=@c '-3' exponent=@c '1'. It can also be
   * expressed as a Unit with kind=@c 'metre'
   * multiplier=<code>'0.001'</code> scale=@c '0' exponent=@c '1'.
   *
   * @param unit the Unit object to manipulate.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   *
   *
 * @if python @note Because this is a static method on a class, the Python
 * language interface for libSBML will contain two variants.  One will be the
 * expected, normal static method on the class (i.e., a regular
 * <em>methodName</em>), and the other will be a standalone top-level
 * function with the name <em>ClassName_methodName()</em>. This is merely an
 * artifact of how the language interfaces are created in libSBML.  The
 * methods are functionally identical. @endif
 *
 *
   *
   * @see @if clike convertToSI() @else Unit::convertToSI(Unit u) @endif
   * @see @if clike merge() @else Unit::merge(Unit u1, Unit u2) @endif
   */ public
 static int removeScale(Unit unit) {
    int ret = libsbmlPINVOKE.Unit_removeScale(Unit.getCPtr(unit));
    return ret;
  }

  
/**
   * Merges two Unit objects with the same 'kind' attribute value into a
   * single Unit.
   *
   * For example, the following,
   * @verbatim
 <unit kind='metre' exponent='2'/>
 <unit kind='metre' exponent='1'/>
 @endverbatim
   * would be merged to become
   * @verbatim
 <unit kind='metre' exponent='3'/>
 @endverbatim
   *
   * @param unit1 the first Unit object; the result of the operation is
   * left as a new version of this unit, modified in-place.  Not modified if
   * the two units have different kinds.
   * 
   * @param unit2 the second Unit object to merge with the first.
   *
   *
 * @if python @note Because this is a static method on a class, the Python
 * language interface for libSBML will contain two variants.  One will be the
 * expected, normal static method on the class (i.e., a regular
 * <em>methodName</em>), and the other will be a standalone top-level
 * function with the name <em>ClassName_methodName()</em>. This is merely an
 * artifact of how the language interfaces are created in libSBML.  The
 * methods are functionally identical. @endif
 *
 *
   * 
   * @see @if clike convertToSI() @else Unit::convertToSI(Unit u) @endif
   * @see @if clike removeScale() @else Unit::removeScale(Unit u) @endif
   */ public
 static void merge(Unit unit1, Unit unit2) {
    libsbmlPINVOKE.Unit_merge(Unit.getCPtr(unit1), Unit.getCPtr(unit2));
  }

  
/**
   * Returns a UnitDefinition object containing the given @p unit converted
   * to the appropriate SI unit.
   *
   * This method exists because some units can be expressed in terms of
   * others when the same physical dimension is involved.  For example, one
   * hertz is identical to 1&nbsp;sec<sup>-1</sup>, one litre is equivalent
   * to 1 cubic decametre, and so on.
   *
   * @param unit the Unit object to convert to SI.
   *
   * @return a UnitDefinition object containing the SI unit.
   *
   *
 * @if python @note Because this is a static method on a class, the Python
 * language interface for libSBML will contain two variants.  One will be the
 * expected, normal static method on the class (i.e., a regular
 * <em>methodName</em>), and the other will be a standalone top-level
 * function with the name <em>ClassName_methodName()</em>. This is merely an
 * artifact of how the language interfaces are created in libSBML.  The
 * methods are functionally identical. @endif
 *
 *
   *
   * @see @if clike merge() @else Unit::merge(Unit u1, Unit u2) @endif
   */ public
 static UnitDefinition convertToSI(Unit unit) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Unit_convertToSI(Unit.getCPtr(unit));
    UnitDefinition ret = (cPtr == global::System.IntPtr.Zero) ? null : new UnitDefinition(cPtr, true);
    return ret;
  }

  
/**
   * Predicate returning @c true if
   * all the required attributes for this Unit object
   * have been set.
   *
   * The required attributes for a Unit object are:
   * @li 'kind'
   * @li 'exponent' (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
   * @li 'multiplier' (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
   * @li 'scale' (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
   *
   * @return @c true if the required attributes have been set, @c false
   * otherwise.
   */ public new
 bool hasRequiredAttributes() {
    bool ret = libsbmlPINVOKE.Unit_hasRequiredAttributes(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 void setExponentUnitChecking(double value) {
    libsbmlPINVOKE.Unit_setExponentUnitChecking(swigCPtr, value);
  }

  
/** */ /* libsbml-internal */ public
 double getExponentUnitChecking() {
    double ret = libsbmlPINVOKE.Unit_getExponentUnitChecking__SWIG_0(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isUnitChecking() {
    bool ret = libsbmlPINVOKE.Unit_isUnitChecking__SWIG_0(swigCPtr);
    return ret;
  }

}

}
