with Ada.Text_IO;           use Ada.Text_IO;
with GNATCOLL.SQL;          use GNATCOLL.SQL;
with GNATCOLL.SQL.Exec;     use GNATCOLL.SQL.Exec;
with GNATCOLL.SQL.Sqlite;

with GNATCOLL.Traces;       use GNATCOLL.Traces;

procedure SQLite_Test is
   Descr : Database_Description;
   DB    : Database_Connection;

   type Child_Cursor is new Forward_Cursor with null record;

   Insert : Prepared_Statement := Prepare ("insert into Bar values ($1)");
   Query  : Prepared_Statement := Prepare ("select * from Bar order by 1");
   DC     : Direct_Cursor;
   FC     : Child_Cursor;

   procedure Process_Query (RC : in out Forward_Cursor'Class) is
   begin
      RC.Fetch (DB, Query);

      while RC.Has_Row loop
         Put_Line (RC.Value (0));
         RC.Next;
      end loop;

      Put_Line ("Processed" & Integer'Image (RC.Processed_Rows));
   end Process_Query;

begin
   GNATCOLL.Traces.Parse_Config_File;
   Descr := Sqlite.Setup (":memory:");
   DB := Descr.Build_Connection;

   DB.Execute ("create table bar (id string)");

   if not Check_Connection (DB) then
      Put_Line ("Check_Connection should return True");
   end if;

   for J in 0 .. 9 loop
      DB.Execute (Insert, (1 => +J));
   end loop;

   DB.Commit;

   Process_Query (FC);
   Process_Query (DC);

end SQLite_Test;
