//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_26.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot26(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[26] = {2.349974545174797e-02,2.116240977285072e-01,5.885496556564078e-01,1.155643612882639e+00,1.914991132120140e+00,
    2.869438484833211e+00,4.022653911405096e+00,5.379209465144435e+00,6.944688490705934e+00,8.725825284829721e+00,1.073068616496011e+01,1.296890505651272e+01,
    1.545199249871947e+01,1.819374583298205e+01,2.121080231179406e+01,2.452339962178934e+01,2.815644675773867e+01,3.214107595384169e+01,3.651697198370508e+01,
    4.133602235846507e+01,4.666835574052357e+01,5.261305366416475e+01,5.931901757410574e+01,6.703139692639424e+01,7.621861753824244e+01,8.808338613530340e+01
    };
  constexpr double aw[26] = {2.994940248515846e-01,2.483568853742081e-01,1.706718293444080e-01,9.706405557285901e-02,4.559018410343905e-02,
    1.763516696573325e-02,5.597702267934169e-03,1.451447997862572e-03,3.057462468111910e-04,5.197599808292613e-05,7.074100498758235e-06,7.635568040303801e-07,
    6.462305217288649e-08,4.230668577428514e-09,2.107639018467193e-10,7.832644757121313e-12,2.118953962618635e-13,4.047376824044675e-15,5.250311740906098e-17,
    4.396697003627440e-19,2.219693930944449e-21,6.135380360042425e-24,8.037881303841061e-27,3.941595136916281e-30,4.627164501280460e-34,4.211542061410119e-39
    };
  constexpr double x[9984] = {  1.756362211867407e-03, -1.655519000170758e-05,  1.169314051873375e-07, -7.332973932231346e-10,  4.304895383376631e-12,
 -2.421907588751466e-14,  1.321954029016061e-16, -7.051579460861764e-19,  3.692581274486186e-21, -1.903891511506527e-23,  9.684551834724806e-26, -4.866472692035428e-28,
  1.577161007175028e-02, -1.476373461054047e-04,  1.028365874581264e-06, -6.299540335185296e-09,  3.568115603535063e-11, -1.906650580550383e-13,  9.689997093063546e-16,
 -4.690813573582685e-18,  2.154339673740953e-20, -9.285682412333101e-23,  3.668606810877186e-25, -1.256147468046960e-27,  4.361241988484578e-02, -4.026305107102939e-04,
  2.726382541839587e-06, -1.590630790993079e-08,  8.335259528096454e-11, -3.948272023704135e-13,  1.660163345183330e-15, -5.826594964267412e-18,  1.343716592227313e-20,
  1.903473395264449e-23, -5.097699104938355e-25,  4.239137673894064e-27,  8.490156254559401e-02, -7.675667736777913e-04,  4.976426083127603e-06, -2.684560066067792e-08,
  1.227322859354248e-10, -4.515051917394755e-13,  1.033291977060984e-15,  1.947854371929152e-18, -4.289077825286617e-20,  3.276974685996405e-22, -1.770415296031893e-24,
  6.894255777394614e-27,  1.390785476795914e-01, -1.222412882648342e-03,  7.462798898903109e-06, -3.584153163570231e-08,  1.289874997260982e-10, -2.272512924898286e-13,
 -1.246979861224325e-15,  1.591196597868291e-17, -9.838191623784523e-20,  3.823640136865700e-22, -4.065396329380058e-25, -7.935060560364916e-27,  2.054060369167762e-01,
 -1.742124555043247e-03,  9.827340013271256e-06, -3.980524134032651e-08,  8.681446859313719e-11,  2.707904176406619e-13, -4.166105558465338e-15,  2.427917048974989e-17,
 -6.905820390325075e-20, -1.806109614640292e-22,  3.580554101739698e-24, -2.324377515863753e-26,  2.829783744299578e-01, -2.297973865232852e-03,  1.171372108581131e-05,
 -3.656829399169030e-08, -2.688808896612854e-12,  8.732121611332926e-13, -5.797068257123713e-15,  1.528696399303000e-17,  6.622979326203636e-20, -9.565410058957388e-22,
  4.824945343064139e-24, -3.624942767791898e-27,  3.707322117861769e-01, -2.859085917197853e-03,  1.281213496256056e-05, -2.543411802578245e-08, -1.205818361790168e-10,
  1.310360250359991e-12, -4.496109656697377e-15, -1.126090391703734e-17,  2.114246296277222e-19, -9.778625766590265e-22, -8.541693662947208e-25,  3.972109287504061e-26,
  4.674591917847155e-01, -3.394109332801594e-03,  1.289900449237796e-05, -7.422320745827169e-09, -2.348444090214717e-10,  1.333774605056246e-12, -1.207179376065235e-16,
 -4.023305311279120e-17,  2.188021690523149e-19,  1.754248110527975e-22, -8.656720436118821e-24,  4.199500712599927e-26,  5.718206393404137e-01, -3.872936297059929e-03,
  1.186680428712121e-05,  1.485663455934445e-08, -3.100348136584881e-10,  8.416760006522324e-13,  5.559966334844851e-15, -5.006470144523560e-17,  3.122275129895926e-20,
  1.609533108001175e-21, -8.330811262692183e-24, -2.212943391752529e-26,  6.823641859968276e-01, -4.268382588957415e-03,  9.740139859327092e-06,  3.768094007931848e-08,
 -3.188120893455500e-10, -5.281552414289897e-14,  9.641466652434166e-15, -2.889716224603011e-17, -2.351524112781099e-19,  1.807879355760111e-21,  2.623579180802064e-24,
 -7.763375454783585e-26,  7.975422278860781e-01, -4.557736727896767e-03,  6.675775852739855e-06,  5.695825041889208e-08, -2.515146054787437e-10, -1.048568936713753e-12,
  9.685469426260764e-15,  1.437457770897061e-17, -3.658658690180450e-19,  2.626778375470618e-22,  1.315838180807602e-23, -3.909879888410036e-26,  9.157320847092524e-01,
 -4.724090529874621e-03,  2.946194468767492e-06,  6.907452661524392e-08, -1.204633568135926e-10, -1.772998402229680e-12,  5.216115749742573e-15,  5.382916648395971e-17,
 -2.320360884137109e-19, -1.751381534221957e-21,  1.045852250507263e-23,  5.819464223386720e-26,  1.035257689742455e+00, -4.757371295894667e-03, -1.091708487334385e-06,
  7.166827867418443e-08,  4.271084810262025e-11, -1.939529605545764e-12, -1.832556081684511e-15,  6.373180899990102e-17,  8.231503403696207e-20, -2.315932347183520e-21,
 -3.801890676917590e-24,  8.949913254706218e-26,  1.154412598540547e+00, -4.655008640224440e-03, -5.039258218060472e-06,  6.415724877059231e-08,  1.961273250860555e-10,
 -1.474868652044776e-12, -8.069538744467089e-15,  3.700011820282361e-17,  3.375483255545911e-19, -8.448763374857581e-22, -1.409811287695525e-23,  1.111222779266388e-26,
  1.271484057959732e+00, -4.422186425247290e-03, -8.504859844937533e-06,  4.789331553044159e-08,  3.003169753347370e-10, -5.556969376513406e-13, -1.049584344367569e-14,
 -9.194504359511892e-18,  3.398920135413017e-19,  1.256575981062850e-21, -9.320494573007761e-24, -7.460368032757252e-26,  1.384777828936470e+00, -4.071651887158589e-03,
 -1.115297610306635e-05,  2.590041078512366e-08,  3.303634418459242e-10,  4.651479422676608e-13, -8.163036202154098e-15, -4.544413231420420e-17,  1.060511841820342e-19,
  2.036439579431256e-21,  4.083134491483035e-24, -6.136646384898050e-26,  1.492643408288023e+00, -3.623078923619472e-03, -1.274686582201614e-05,  2.243179563049564e-09,
  2.834399697246313e-10,  1.211082910363592e-12, -2.638268856044128e-15, -5.088861946840934e-17, -1.606648126497015e-19,  9.809135207951397e-22,  1.077875237114921e-23,
  1.851749786078954e-26,  1.593499249321306e+00, -3.102009398198814e-03, -1.317930541696669e-05, -1.883978734303423e-08,  1.791274337640620e-10,  1.442627824053474e-12,
  3.001680179695659e-15, -2.699575245851822e-17, -2.567775888922660e-19, -6.221686218040954e-22,  5.258164302572076e-24,  5.492596929337901e-26,  1.685857541414697e+00,
 -2.538423571912854e-03, -1.248690644809965e-05, -3.384569783416362e-08,  5.234616364408453e-11,  1.151534076646318e-12,  6.006593319911310e-15,  5.806810228733368e-18,
 -1.490563712985147e-19, -1.221116089480720e-21, -3.502525687608389e-24,  1.780499799347547e-26,  1.768348078595430e+00, -1.965016501427689e-03, -1.084570371420704e-05,
 -4.075215343455168e-08, -5.867771456625163e-11,  5.450159291922060e-13,  5.464508727697280e-15,  2.504412510632644e-17,  2.564468438102701e-20, -5.879256942161281e-22,
 -5.429623754370001e-24, -2.331716377654735e-26,  1.839740730927719e+00, -1.415279403143281e-03, -8.548169922924142e-06, -3.942175307655300e-08, -1.251977643112068e-10,
 -6.912219846833134e-14,  2.571351949610558e-15,  2.252555829852583e-17,  1.118879152874449e-19,  2.658149767118819e-22, -1.188407682215076e-24, -1.860433264668011e-26,
  1.898966038259343e+00, -9.215015345178610e-04, -5.964380767176970e-06, -3.156838023186746e-08, -1.369630723323505e-10, -4.366804420559649e-13, -4.225166241315795e-16,
  7.404083743320911e-18,  7.563706687708430e-20,  4.629130273029071e-22,  1.973435698744943e-24,  4.197401950645245e-27,  1.945133503962675e+00, -5.128170824490648e-04,
 -3.492334228633118e-06, -2.028967338965769e-08, -1.042860296583507e-10, -4.721425672283972e-13, -1.797903200913535e-15, -4.833963980864358e-18,  8.220991364465495e-22,
  1.318189530125315e-22,  1.200450953363656e-24,  7.655582421883198e-27,  1.977547508597731e+00, -2.134193896800773e-04, -1.504050636840025e-06, -9.274716163211381e-09,
 -5.252469715698752e-11, -2.780514084138043e-13, -1.381972868328770e-15, -6.417366584532270e-18, -2.738690615189245e-20, -1.031758459270612e-22, -3.050657790186574e-25,
 -3.309363266710356e-28,  1.995725201412197e+00, -4.101431205596274e-05, -2.945056432313994e-07, -1.874386466941193e-09, -1.114381425137769e-11, -6.332600571974228e-14,
 -3.480491197505578e-16, -1.862510893948584e-18, -9.741729371217059e-21, -4.991084720164410e-23, -2.507330712984395e-25, -1.235125542179597e-27,  1.691958229657770e-03,
 -1.565380182895553e-05,  1.085296624472934e-07, -6.681282171609272e-10,  3.850707877717299e-12, -2.127057449479732e-14,  1.140073156782110e-16, -5.972540387483429e-19,
  3.072044133715474e-21, -1.556127999423412e-23,  7.778185450001400e-26, -3.841627959314660e-28,  1.519704910580509e-02, -1.397033735880734e-04,  9.560749169269536e-07,
 -5.757927965889339e-09,  3.209016589528394e-11, -1.689102676312630e-13,  8.468254085674216e-16, -4.052183736196374e-18,  1.845176865500544e-20, -7.924410049673849e-23,
  3.148542034899749e-25, -1.108185357334824e-27,  4.204434231682150e-02, -3.815608675935949e-04,  2.543254973201815e-06, -1.463372847303193e-08,  7.584152903517041e-11,
 -3.568919280938340e-13,  1.503115502800522e-15, -5.389233494270801e-18,  1.379712589749800e-20,  2.026467018391512e-24, -3.487017028196119e-25,  3.131585250640503e-27,
  8.190892423807068e-02, -7.290112481153490e-04,  4.665767590093777e-06, -2.495276161546348e-08,  1.139538328895632e-10, -4.261963719078285e-13,  1.070296267907273e-15,
  7.510177818280875e-19, -3.229697485310993e-20,  2.627573582161828e-22, -1.481579101785663e-24,  6.211364754374140e-27,  1.343056260383434e-01, -1.164396155635452e-03,
  7.044928465000095e-06, -3.381557266538035e-08,  1.241775020006238e-10, -2.521755465344329e-13, -8.434765646370197e-16,  1.298023062784948e-17, -8.498376115116068e-20,
  3.601914835979545e-22, -6.775241731447890e-25, -4.559032861388065e-27,  1.985917847748101e-01, -1.665392495550721e-03,  9.358173050803697e-06, -3.837808940023200e-08,
  9.128416415953302e-11,  1.787069031057588e-13, -3.518018529380466e-15,  2.199098066025809e-17, -7.321904246818051e-20, -5.678176778937235e-23,  2.637564779548196e-24,
 -1.959039053954889e-26,  2.739711199725044e-01, -2.206018827105613e-03,  1.127519567262055e-05, -3.647901091920606e-08,  1.341991627875959e-11,  7.394279333847477e-13,
 -5.344275896698561e-15,  1.689217815462385e-17,  3.521360678665674e-20, -7.684774112431588e-22,  4.539888066823940e-24, -8.899163045767096e-27,  3.594988855577867e-01,
 -2.757840520243332e-03,  1.249619527545562e-05, -2.715972655918330e-08, -9.547542474361094e-11,  1.199401784007188e-12, -4.722017096871553e-15, -5.061935147165053e-18,
  1.759981731103602e-19, -9.803178173047783e-22,  6.523149268170011e-25,  2.887568576007182e-26,  4.540884869181038e-01, -3.291335421466520e-03,  1.278827034932984e-05,
 -1.096695350183455e-08, -2.082850324628574e-10,  1.318153793929765e-12, -1.148725905101450e-15, -3.319349921710464e-17,  2.193379712218649e-19, -1.330729108094383e-22,
 -6.756314149524848e-24,  4.364279524491220e-26,  5.565197748148081e-01, -3.777371749677566e-03,  1.201589825523727e-05,  1.003752197503841e-08, -2.919796462892998e-10,
  9.584575538573532e-13,  4.180385422378142e-15, -4.820435577082426e-17,  8.298531907829604e-20,  1.262517207291771e-21, -8.884998034768681e-24, -3.615177768593770e-27,
  6.654492392016663e-01, -4.188739501869617e-03,  1.016171026020390e-05,  3.258377901535529e-08, -3.176241238186175e-10,  1.680806167040831e-13,  8.736888537175240e-15,
 -3.536697124519542e-17, -1.689786397334686e-19,  1.847258838598025e-21, -5.768074498754406e-25, -6.698868662987272e-26,  7.794223236363034e-01, -4.501666448213692e-03,
  7.334478628494064e-06,  5.277898874455348e-08, -2.701356572918222e-10, -8.125985036123773e-13,  9.926174338888051e-15,  2.916043848463302e-18, -3.474021348346007e-19,
  7.489811042909563e-22,  1.103002052044642e-23, -5.648538110546295e-26,  8.968880616129516e-01, -4.697240811166273e-03,  3.762377522120047e-06,  6.687073161831692e-08,
 -1.545539451467516e-10, -1.630619321699251e-12,  6.610504384160693e-15,  4.548054995546978e-17, -2.870019206356953e-19, -1.288836803125899e-21,  1.248903358694161e-23,
  3.357511001654824e-26,  1.016216196510544e+00, -4.762656229646199e-03, -2.288750635708846e-07,  7.203954894035507e-08,  3.626194470342926e-12, -1.961877305940447e-12,
 -2.388614132818183e-17,  6.501038817792772e-17, -2.828894510657516e-21, -2.387409036609120e-21,  2.567999010748512e-25,  9.343706691015673e-26,  1.135716884072442e+00,
 -4.692192119724401e-03, -4.251549494199384e-06,  6.704915811191609e-08,  1.647833537896899e-10, -1.654916929827263e-12, -6.887654253314192e-15,  4.720762796291927e-17,
  2.971750100339019e-19, -1.390780485310582e-21, -1.299350795981430e-23,  3.901008245865434e-26,  1.253662988488874e+00, -4.487845672567151e-03, -7.901720908184380e-06,
  5.259572413505955e-08,  2.866697004216699e-10, -8.094184141356454e-13, -1.059476676558176e-14,  2.327614308705172e-18,  3.776521722516384e-19,  8.210043446547703e-22,
 -1.237067723939677e-23, -6.260438012658965e-26,  1.368314869903426e+00, -4.159541981658426e-03, -1.081018492982141e-05,  3.124958007484978e-08,  3.376064777157319e-10,
  2.544180561350389e-13, -9.376747276231806e-15, -4.085160095886807e-17,  1.816012426650791e-19,  2.140214719634021e-21,  9.739638370021430e-25, -7.939698952931446e-26,
  1.477947424458862e+00, -3.724867265856308e-03, -1.269195060739752e-05,  6.968057577202007e-09,  3.069101749221580e-10,  1.130120556106153e-12, -4.129218231717586e-15,
 -5.538036696280002e-17, -1.174387595237419e-19,  1.423455668233393e-21,  1.121657653443571e-23,  4.315360005322553e-28,  1.580878982724358e+00, -3.208297211785151e-03,
 -1.338722256095562e-05, -1.573928771434591e-08,  2.086342863081556e-10,  1.504649942452614e-12,  2.127712930518861e-15, -3.552557006662019e-17, -2.747902625769945e-19,
 -3.616808993868733e-22,  7.804852328808047e-24,  6.019900465415223e-26,  1.675501506823830e+00, -2.639927377384292e-03, -1.288724407950949e-05, -3.281603611144254e-08,
  7.682863609941554e-11,  1.297062872814751e-12,  6.095615258041197e-15,  3.083592186881128e-19, -1.953154204656909e-19, -1.341758191630055e-21, -2.430660286632164e-24,
  3.138102853934415e-26,  1.760311362786368e+00, -2.053753318935491e-03, -1.133997916853498e-05, -4.159642877671125e-08, -4.640872317111021e-11,  6.846505908881432e-13,
  6.173740751617838e-15,  2.548219243039881e-17,  3.238928507870459e-22, -8.254738483361834e-22, -6.439600206608053e-24, -2.217731784291899e-26,  1.833939798357458e+00,
 -1.485591142652895e-03, -9.033284100779633e-06, -4.143240198236009e-08, -1.259098686917385e-10,  5.718950587386535e-16,  3.253556749820470e-15,  2.624819808014422e-17,
  1.203879088329019e-19,  2.000884917964333e-22, -2.144927209367336e-24, -2.505740048217459e-26,  1.895182149359114e+00, -9.707697838252798e-04, -6.356639573823574e-06,
 -3.383013361145262e-08, -1.457798118414344e-10, -4.440436136678956e-13, -1.787009780564242e-16,  1.010668322556919e-17,  9.376408847076184e-20,  5.451761474112877e-22,
  2.128887325961520e-24,  2.703923003448551e-27,  1.943024775258569e+00, -5.417587595174882e-04, -3.746141102076658e-06, -2.203618304703518e-08, -1.141713059699523e-10,
 -5.169087501383981e-13, -1.932102431906794e-15, -4.721768624453503e-18,  6.518308852261366e-21,  1.871531488131184e-22,  1.581312976539463e-24,  9.723177589175677e-27,
  1.976669040608568e+00, -2.259117025251753e-04, -1.620579124423730e-06, -1.016146455548680e-08, -5.843248008016805e-11, -3.134775403484367e-13, -1.574503789303379e-15,
 -7.355556168869406e-18, -3.132372834405699e-20, -1.155945455144772e-22, -3.137308086572149e-25, -3.629300518679201e-29,  1.995556285210355e+00, -4.346345816458408e-05,
 -3.181114023471629e-07, -2.063291898755158e-09, -1.249827968867060e-11, -7.234194651467777e-14, -4.048482788141825e-16, -2.205042106768646e-18, -1.173295234053247e-20,
 -6.111683779917687e-23, -3.119277389886260e-25, -1.559658798430825e-27,  1.631030156425401e-03, -1.481661868410074e-05,  1.008682197166387e-07, -6.097770099251499e-10,
  3.451358860848527e-12, -1.872446471629769e-14,  9.858035784429080e-17, -5.073429904397418e-19,  2.563996809777247e-21, -1.276315846938221e-23,  6.270408226568979e-26,
 -3.044641960332415e-28,  1.465310720053522e-02, -1.323226760259606e-04,  8.899524308884229e-07, -5.270444103367128e-09,  2.890634223789429e-11, -1.498838213534073e-13,
  7.412185769588384e-16, -3.505033891413618e-18,  1.581431212436049e-20, -6.758272323858712e-23,  2.692485025216411e-25, -9.663144404042986e-28,  4.055770718632514e-02,
 -3.618971478711955e-04,  2.374701680776222e-06, -1.347545706229638e-08,  6.905247320924059e-11, -3.225780705379340e-13,  1.358391333050922e-15, -4.948996871720192e-18,
  1.364977829581029e-20, -9.430615363124096e-24, -2.302746380730219e-25,  2.290065857616548e-27,  7.906567803279808e-02, -6.928524832331910e-04,  4.376997264705479e-06,
 -2.319629088580196e-08,  1.056879119405932e-10, -4.003653609397087e-13,  1.078199248739917e-15, -1.420536884890796e-19, -2.384060896978878e-20,  2.087368333566531e-22,
 -1.225054128578967e-24,  5.442816784938325e-27,  1.297582374582403e-01, -1.109626488984039e-03,  6.650892959165521e-06, -3.187006241962960e-08,  1.189594578143957e-10,
 -2.683531422949570e-13, -5.161928040226979e-16,  1.046264523259442e-17, -7.254587439612258e-20,  3.298518162108747e-22, -8.218925567410073e-25, -2.143816324409602e-27,
  1.920770642015732e-01, -1.592344187293039e-03,  8.906502904729732e-06, -3.689333259191160e-08,  9.406247950646934e-11,  1.013974665007323e-13, -2.935244778547596e-15,
  1.963400606225053e-17, -7.356198411664957e-20,  3.256587871953061e-23,  1.856398689877455e-24, -1.594496117411751e-26,  2.653246819690246e-01, -2.117563524571194e-03,
  1.083920174599163e-05, -3.615278993600875e-08,  2.696471428686047e-11,  6.169440863718446e-13, -4.859433090217635e-15,  1.761058886281130e-17,  1.071325294870635e-20,
 -5.957285681539448e-22,  4.076184134499088e-24, -1.184254832820587e-26,  3.486653641524088e-01, -2.659198811338465e-03,  1.216188447033198e-05, -2.850162373520199e-08,
 -7.262900211528114e-11,  1.084976601820809e-12, -4.790160167703442e-15,  1.268466598441935e-20,  1.414553684505708e-19, -9.317862884770939e-22,  1.703151694716013e-24,
  1.911977716895781e-26,  4.411268467153852e-01, -3.189610333618192e-03,  1.263753584423867e-05, -1.409040915991561e-08, -1.822688599464851e-10,  1.280218283914771e-12,
 -1.980950867392317e-15, -2.629975685653723e-17,  2.101422497853396e-19, -3.653346019918428e-22, -4.872996711997762e-24,  4.143582970463280e-26,  5.416031948822798e-01,
 -3.680840691027558e-03,  1.210896747305711e-05,  5.524199072573388e-09, -2.719148100887883e-10,  1.042929756973076e-12,  2.874184191038887e-15, -4.489023633944481e-17,
  1.220430595053279e-19,  9.085624345170754e-22, -8.705697617431577e-24,  1.107446830708503e-26,  6.488592233858782e-01, -4.105967864368977e-03,  1.052237058560887e-05,
  2.753973193320899e-08, -3.122487686744702e-10,  3.653327621616790e-13,  7.680844313601181e-15, -3.972024418575398e-17, -1.035660784818203e-19,  1.769333374255417e-21,
 -3.212618321721453e-24, -5.235521373238914e-26,  7.615369154501016e-01, -4.440531855632731e-03,  7.941399105677686e-06,  4.833975170676179e-08, -2.840051077757837e-10,
 -5.746189009017692e-13,  9.856818737646470e-15, -7.689340721674574e-18, -3.131289735926746e-19,  1.136979308187562e-21,  8.297004475893692e-24, -6.649245168639851e-26,
  8.781643160408433e-01, -4.663976455009933e-03,  4.548941973788268e-06,  6.414600329116151e-08, -1.854821933004263e-10, -1.457762912378363e-12,  7.749109608421028e-15,
  3.565296290115640e-17, -3.241220243608850e-19, -7.674366465239720e-22,  1.338972660935747e-23,  7.366802961731244e-27,  9.971673820610047e-01, -4.761031324668226e-03,
  6.346543868575474e-07,  7.178425423549403e-08, -3.547002972776391e-11, -1.940696457652160e-12,  1.782277241016459e-15,  6.355469687942736e-17, -8.760726324312607e-20,
 -2.295851872498529e-21,  4.281035986641477e-24,  8.795469401201406e-26,  1.116885246427314e+00, -4.722943906534756e-03, -3.432260460375746e-06,  6.941239168530298e-08,
  1.301443895944836e-10, -1.803334041403815e-12, -5.440926555136959e-15,  5.581965947338972e-17,  2.382369728152999e-19, -1.868363312255196e-21, -1.069845357738352e-23,
  6.465632946820644e-26,  1.235589283885386e+00, -4.548458190779575e-03, -7.243630775388377e-06,  5.703916386231622e-08,  2.679510277496314e-10, -1.061521380084866e-12,
 -1.035667267966615e-14,  1.478480619150017e-17,  3.976859568603467e-19,  2.765132397596650e-22, -1.470507409048989e-23, -4.219658360205878e-26,  1.351506244034380e+00,
 -4.244431346895477e-03, -1.040265247072510e-05,  3.667938714884074e-08,  3.403554643486592e-10,  1.637794040983652e-14, -1.042763919738809e-14, -3.380717871896573e-17,
  2.584681651133197e-19,  2.104979074298902e-21, -2.831874803348795e-24, -9.254947795160827e-26,  1.462845533829070e+00, -3.825983244230022e-03, -1.257814355949065e-05,
  1.205352093991743e-08,  3.283939884875634e-10,  1.012037296259294e-12, -5.724161635654206e-15, -5.823225261376486e-17, -5.817282677339000e-20,  1.865949285611326e-21,
  1.073713247262717e-23, -2.301928372783345e-26,  1.567830485281833e+00, -3.316091426215466e-03, -1.355506403303787e-05, -1.215797681704826e-08,  2.391521861949063e-10,
  1.542775071995049e-12,  1.008393309267261e-15, -4.446171184178827e-17, -2.815472383908202e-19,  4.035406419209497e-24,  1.048434260064241e-23,  6.063061796070715e-26,
  1.664733139556793e+00, -2.744577579226117e-03, -1.327277917823293e-05, -3.137130954037799e-08,  1.042296989111654e-10,  1.442709755867563e-12,  6.009369599292180e-15,
 -6.730379830785036e-18, -2.449945961331161e-19, -1.406786256901128e-21, -7.032547618950554e-25,  4.749689824289492e-26,  1.751911732133785e+00, -2.146481309861726e-03,
 -1.184311294191886e-05, -4.222113145289392e-08, -3.117633705081621e-11,  8.413542745258720e-13,  6.882554545683265e-15,  2.496551521356928e-17, -3.425642173080052e-20,
 -1.101600296305828e-21, -7.336348832181895e-24, -1.798834415672428e-26,  1.827849704066712e+00, -1.559880388532475e-03, -9.542545449692609e-06, -4.344236794642838e-08,
 -1.250557705392964e-10,  8.791798229401007e-14,  4.043391791238468e-15,  3.019702031643606e-17,  1.257617222252814e-19,  9.010587231026233e-23, -3.408730586389250e-24,
 -3.253878902146497e-26,  1.891194736029872e+00, -1.023287074895004e-03, -6.776889584617914e-06, -3.623378805158211e-08, -1.546788190173496e-10, -4.445788132573944e-13,
  1.493612869017914e-16,  1.343778365470249e-17,  1.149457678776543e-19,  6.320182925282813e-22,  2.193578257380573e-24, -8.246206999902760e-31,  1.940796082314398e+00,
 -5.728174820068116e-04, -4.021885186608822e-06, -2.394819324714847e-08, -1.249837446371770e-10, -5.648354691609224e-13, -2.060286793418775e-15, -4.392296605038183e-18,
  1.450380168746632e-20,  2.596633346304062e-22,  2.062329248543540e-24,  1.221308348420179e-26,  1.975738669177652e+00, -2.393804696349710e-04, -1.748339959405361e-06,
 -1.114866590895085e-08, -6.509719620788508e-11, -3.538542964394486e-13, -1.795135240100440e-15, -8.426915704359937e-18, -3.571026564492274e-20, -1.280476134991234e-22,
 -3.053369107351671e-25,  4.575178932052744e-28,  1.995377179836311e+00, -4.611090042362267e-05, -3.441202549997736e-07, -2.275388789579801e-09, -1.404751145841533e-11,
 -8.284374824182136e-14, -4.721945637028414e-16, -2.618248937756671e-18, -1.417531936916345e-20, -7.508144464544050e-23, -3.893301291779425e-25, -1.975769643582032e-27,
  1.573332518973282e-03, -1.403803110256744e-05,  9.387027149790125e-08, -5.574273020936289e-10,  3.099424373883201e-12, -1.652013983397179e-14,  8.545765578950087e-17,
 -4.321876142858511e-19,  2.146620498172144e-21, -1.050349026674752e-23,  5.073213923036643e-26, -2.422298877787228e-28,  1.413766598895513e-02, -1.254483970761121e-04,
  8.293862293303477e-07, -4.830989857136423e-09,  2.607889511473136e-11, -1.332172581134463e-13,  6.498110315861770e-16, -3.035905742261908e-18,  1.356530668965060e-20,
 -5.762372166198807e-23,  2.296549219557311e-25, -8.354532482400025e-28,  3.914711557091512e-02, -3.435280531319574e-04,  2.219417943169590e-06, -1.242050487099083e-08,
  6.291595493296140e-11, -2.915905565010169e-13,  1.225871889548921e-15, -4.519228867986412e-18,  1.316691624383060e-20, -1.682641731064715e-23, -1.441330685207902e-25,
  1.655317647584490e-27,  7.636257693131050e-02, -6.589217793995765e-04,  4.108528119556361e-06, -2.156793959831577e-08,  9.793863310009148e-11, -3.746159000088751e-13,
  1.064606055048181e-15, -7.937234698743842e-19, -1.715249257158617e-20,  1.642954861913286e-22, -1.002637258974346e-24,  4.671384652411908e-27,  1.254237688026309e-01,
 -1.057917163128474e-03,  6.279693285703000e-06, -3.001022568968705e-08,  1.134909279591087e-10, -2.774779052820000e-13, -2.540002727519805e-16,  8.324675502138448e-18,
 -6.128072414513614e-20,  2.956268455374693e-22, -8.772723873456625e-25, -4.818618130474471e-28,  1.858474238985759e-01, -1.522837328859824e-03,  8.472867934752663e-06,
 -3.537575473562809e-08,  9.542913164579191e-11,  3.728418052920590e-14, -2.418177600682317e-15,  1.731180104732833e-17, -7.121277012266824e-20,  9.380854110644856e-23,
  1.230303228748961e-24, -1.257381007872903e-26,  2.570251190266041e-01, -2.032577012697680e-03,  1.040834399541518e-05, -3.562881204752032e-08,  3.817739302120465e-11,
  5.062548721284797e-13, -4.364542846498342e-15,  1.764069257152258e-17, -7.928080442074224e-21, -4.435615067722897e-22,  3.523559252541600e-24, -1.303299645956114e-26,
  3.382209671688557e-01, -2.563289959984865e-03,  1.181358847385374e-05, -2.949632895035732e-08, -5.207656592466854e-11,  9.704980354834074e-13, -4.731373306722938e-15,
  4.017187483116936e-18,  1.093167999341269e-19, -8.493676333270188e-22,  2.358130832513420e-24,  1.093226783370379e-26,  4.285694676350484e-01, -3.089234035672775e-03,
  1.245178904873143e-05, -1.680469602438141e-08, -1.571956993733734e-10,  1.224585208683128e-12, -2.625425428816288e-15, -1.981976334993832e-17,  1.939098431961551e-19,
 -5.250498642920816e-22, -3.147607887238682e-24,  3.667073537448722e-26,  5.270738931397384e-01, -3.583776143000815e-03,  1.214985336657866e-05,  1.343759756706828e-09,
 -2.504658214733206e-10,  1.097296212919767e-12,  1.676377392762496e-15, -4.052757342225152e-17,  1.486319058527355e-19,  5.734524704658837e-22, -7.974158347858091e-24,
  2.146235683551246e-26,  6.326056837856502e-01, -4.020551305740592e-03,  1.082314400272754e-05,  2.261183656720978e-08, -3.031904855742086e-10,  5.360103907507167e-13,
  6.531653976556013e-15, -4.204424644674214e-17, -4.269511453577135e-20,  1.599516752672553e-21, -5.158891096012820e-24, -3.600418699932960e-26,  7.439054141295460e-01,
 -4.374758394452878e-03,  8.493873774586749e-06,  4.371649118209869e-08, -2.931549721057028e-10, -3.417311769179447e-13,  9.507811830614608e-15, -1.699632449884639e-17,
 -2.669415852079634e-19,  1.409062083307159e-21,  5.288270356317554e-24, -6.909717193041339e-26,  8.595859943267653e-01, -4.624558510768963e-03,  5.299959207446826e-06,
  6.095546901085224e-08, -2.127029563572171e-10, -1.260998736477693e-12,  8.598770957408202e-15,  2.494256628311676e-17, -3.420994387524729e-19, -2.328432879584127e-22,
  1.315968083122748e-23, -1.734108968673637e-26,  9.781388493488479e-01, -4.752521024999969e-03,  1.491388620863131e-06,  7.090914479251318e-08, -7.371402667164042e-11,
 -1.876959217413341e-12,  3.510414038714375e-15,  5.946927014558066e-17, -1.662744762968061e-19, -2.050792182311466e-21,  7.868866804729146e-24,  7.383315750410369e-26,
  1.097943876282364e+00, -4.747037580607815e-03, -2.588029594194707e-06,  7.119961958209229e-08,  9.290266353396379e-11, -1.914364365225126e-12, -3.781912176389774e-15,
  6.229043124512687e-17,  1.640179266413357e-19, -2.232984256959981e-21, -7.385934865432178e-24,  8.474912253280487e-26,  1.217283988662672e+00, -4.603598174887819e-03,
 -6.534181414034288e-06,  6.114319848482339e-08,  2.442759865844727e-10, -1.303670739609080e-12, -9.763866520466588e-15,  2.755332143552539e-17,  3.966739777839532e-19,
 -3.411945582823593e-22, -1.598060150346664e-23, -1.481907460550418e-26,  1.334364994456863e+00, -4.325799444366801e-03, -9.929859774244471e-06,  4.211379326540042e-08,
  3.381088389613908e-10, -2.442409531181442e-13, -1.124725705302317e-14, -2.435370335995339e-17,  3.312054722870846e-19,  1.908010753786163e-21, -7.056449483899291e-24,
 -9.799153123116836e-26,  1.447341394689745e+00, -3.925939013499179e-03, -1.240133324161508e-05,  1.746172908435535e-08,  3.471280517375189e-10,  8.549460020666665e-13,
 -7.370050396800053e-15, -5.893855118081815e-17,  1.641706009854604e-20,  2.267343052625602e-21,  9.133258999184349e-24, -5.034108077856412e-26,  1.554348409480476e+00,
 -3.425048120586859e-03, -1.367697985453447e-05, -8.083824442223294e-09,  2.701436128331445e-10,  1.551022457439955e-12, -3.620389893786974e-16, -5.338281073361388e-17,
 -2.732214096883259e-19,  4.754389018077417e-22,  1.303934943598040e-23,  5.422011506439510e-26,  1.653540123532571e+00, -2.852235041586531e-03, -1.363825148435484e-05,
 -2.946504519084466e-08,  1.345061008311301e-10,  1.583740435575867e-12,  5.703534328046828e-15, -1.538155118972934e-17, -2.955949448986310e-19, -1.387980794768815e-21,
  1.772492551927289e-24,  6.517606155985507e-26,  1.743133098070514e+00, -2.243259969333769e-03, -1.235217443900556e-05, -4.257612635698746e-08, -1.264161985402953e-11,
  1.014761420834128e-12,  7.559868060067757e-15,  2.317672402648827e-17, -7.936818807661613e-20, -1.408757863417387e-21, -7.960472792852331e-24, -9.585919655330573e-27,
  1.821454152365126e+00, -1.638339831609518e-03, -1.007578330862204e-05, -4.542362512922491e-08, -1.222561507248140e-10,  1.955623230001290e-13,  4.945532734897274e-15,
  3.424403928656046e-17,  1.261846634887191e-19, -7.725096798836727e-23, -5.018726508483686e-24, -4.071328657011286e-26,  1.886990343443849e+00, -1.079284159865155e-03,
 -7.226836630832614e-06, -3.877945131807450e-08, -1.635018321591466e-10, -4.360417754744490e-13,  5.806558266250222e-16,  1.749695854605802e-17,  1.392675107448912e-19,
  7.186044547025602e-22,  2.103633499461898e-24, -4.417555258470007e-27,  1.938438593012775e+00, -6.061769485621126e-04, -4.321643550848753e-06, -2.604103420507474e-08,
 -1.367845747199116e-10, -6.156964845278886e-13, -2.175248258353081e-15, -3.761587513040932e-18,  2.547356721551054e-20,  3.537339464673205e-22,  2.662514378481363e-24,
  1.513880280090297e-26,  1.974752300835050e+00, -2.539205851860458e-04, -1.888614632549775e-06, -1.224926119483150e-08, -7.262491257040631e-11, -3.999024566592712e-13,
 -2.047796592256346e-15, -9.645705545051385e-18, -4.053313166958017e-20, -1.396517921066636e-22, -2.691455242771460e-25,  1.245900320013020e-27,  1.995187051815530e+00,
 -4.897703209917593e-05, -3.728302233962730e-07, -2.514045595337786e-09, -1.582392721907559e-11, -9.511001670487960e-14, -5.522848737713138e-16, -3.118290405816884e-18,
 -1.718084894527683e-20, -9.254109517680146e-23, -4.875454501806355e-25, -2.510851815796307e-27,  1.518641112392374e-03, -1.331300680414518e-05,  8.746813537813666e-08,
 -5.103722768183168e-10,  2.788589895880648e-12, -1.460694483823527e-14,  7.426391981946130e-17, -3.691740356713591e-19,  1.802593557805393e-21, -8.672145331158820e-24,
  4.119012372365287e-26, -1.934381035988852e-28,  1.364878517918316e-02, -1.190382984201622e-04,  7.738326694892796e-07, -4.434222986270989e-09,  2.356386476556669e-11,
 -1.185946606851503e-13,  5.705833029694812e-16, -2.633304007052518e-18,  1.164767123936736e-20, -4.913709820969581e-23,  1.955333151254188e-25, -7.177856290596927e-28,
  3.780759367531322e-02, -3.263522137228696e-04,  2.076224429198317e-06, -1.145894771816337e-08,  5.736834699952250e-11, -2.636410766220422e-13,  1.105134041780223e-15,
 -4.108558995622355e-18,  1.247355703020053e-20, -2.128516171562566e-23, -8.226252283842325e-26,  1.179891240773118e-27,  7.379102396923110e-02, -6.270627366742786e-04,
  3.858872180371008e-06, -2.005948037118973e-08,  9.069972205731977e-11, -3.493888710859701e-13,  1.035533727155539e-15, -1.255320488252485e-18, -1.191221196974119e-20,
  1.280826910161654e-22, -8.132944878816368e-25,  3.945178588573797e-27,  1.212903374877367e-01, -1.009089661684160e-03,  5.930281705410635e-06, -2.823902313575567e-08,
  1.078981857834454e-10, -2.809888209737485e-13, -4.681160644015247e-17,  6.527181450799092e-18, -5.127158931240260e-20,  2.604686014141956e-22, -8.727226598825920e-25,
  6.075436911320296e-28,  1.798889886074054e-01, -1.456726427900594e-03,  8.057534906995719e-06, -3.384591624538330e-08,  9.563239936771413e-11, -1.518938787131836e-14,
 -1.964781082839146e-15,  1.509549659504214e-17, -6.707489499235431e-20,  1.328590272373052e-22,  7.437711508794365e-25, -9.615749233176350e-27,  2.490586523191131e-01,
 -1.951009326099693e-03,  9.984779430196156e-06, -3.494249709951815e-08,  4.729480195210884e-11,  4.073906385964584e-13, -3.876368376747269e-15,  1.715757761200802e-17,
 -2.149822880889493e-20, -3.141494094284597e-22,  2.947395986910650e-24, -1.299181393471302e-26,  3.281545649207456e-01, -2.470209805519250e-03,  1.145525384034179e-05,
 -3.018039903019937e-08, -3.379109836966475e-11,  8.586625591552729e-13, -4.574380278633161e-15,  7.045111269317157e-18,  8.053467294528464e-20, -7.474479943076725e-22,
  2.690849583517446e-24,  4.477974545824995e-27,  4.164104250220587e-01, -2.990467267681738e-03,  1.223583856005167e-05, -1.912749343646747e-08, -1.333755017704032e-10,
  1.155598478130307e-12, -3.096504232345268e-15, -1.393832371182144e-17,  1.731148500949944e-19, -6.204312312494268e-22, -1.666443160571021e-24,  3.050958141996777e-26,
  5.129331943830505e-01, -3.486579262086230e-03,  1.214266403088029e-05, -2.486315926719163e-09, -2.282066324588461e-10,  1.124466381267369e-12,  6.108684142698636e-16,
 -3.550062484259349e-17,  1.637821789742381e-19,  2.754892136152591e-22, -6.878871192700104e-24,  2.766791856814548e-26,  6.166982520826011e-01, -3.932962385299791e-03,
  1.106576001259966e-05,  1.785466536537055e-08, -2.909986146779924e-10,  6.785405449009793e-13,  5.343643779630969e-15, -4.253180454233222e-17,  1.083523051994609e-20,
  1.366290043293102e-21, -6.385087324381761e-24, -1.991501945365750e-26,  7.265454918295257e-01, -4.304789190584782e-03,  8.990142927293334e-06,  3.898355426899397e-08,
 -2.977510533324780e-10, -1.201715348196943e-13,  8.920207540834598e-15, -2.469192207175811e-17, -2.131347070340766e-19,  1.560509777107939e-21,  2.312737189286762e-24,
 -6.519200800165426e-26,  8.411771081347724e-01, -4.579292672582030e-03,  6.010210008894586e-06,  5.736188984236614e-08, -2.358090692504341e-10, -1.047488720167976e-12,
  9.143355846348351e-15,  1.396097479772123e-17, -3.412499476913097e-19,  2.718468598191999e-22,  1.192448442660521e-23, -3.795461310416035e-26,  9.591579845350080e-01,
 -4.737209147772207e-03,  2.333999365731660e-06,  6.943453895007886e-08, -1.102792237659937e-10, -1.773394748667308e-12,  5.090432023767839e-15,  5.303399812013174e-17,
 -2.337058716059119e-19, -1.676790993247798e-21,  1.067926060747652e-23,  5.301764376541704e-26,  1.078919760459027e+00, -4.764301904987077e-03, -1.725993314916832e-06,
  7.237543499217594e-08,  5.385173514503097e-11, -1.983683714770549e-12, -1.976747956406387e-15,  6.620334183965436e-17,  7.925032928449656e-20, -2.449683108941346e-21,
 -3.362429939064973e-24,  9.661054581227027e-26,  1.198769787030515e+00, -4.652872372497020e-03, -5.777913424330266e-06,  6.483058279469978e-08,  2.159290835055534e-10,
 -1.527327028888334e-12, -8.817394427740514e-15,  3.992625648010223e-17,  3.728104471448107e-19, -9.843374436974489e-22, -1.594550834961334e-23,  1.684316363402311e-26,
  1.316906248794304e+00, -4.403125362473609e-03, -9.392245093849171e-06,  4.746958020477109e-08,  3.304758951367443e-10, -5.210990159012409e-13, -1.177089170300470e-14,
 -1.271900484439080e-17,  3.937778153654108e-19,  1.540077119768090e-21, -1.130719634182892e-23, -9.343584669346806e-26,  1.431440679323736e+00, -4.024215863305025e-03,
 -1.215793659474990e-05,  2.314239968951546e-08,  3.623251227086739e-10,  6.583986286044704e-13, -9.000229003620609e-15, -5.704154384164450e-17,  1.040067795312441e-19,
  2.579940162203303e-21,  6.287966156391144e-24, -7.892793413208678e-26,  1.540428877786170e+00, -3.534776152041192e-03, -1.374703124630727e-05, -3.514360882833179e-09,
  3.009510750275323e-10,  1.523428454383104e-12, -1.975844115000524e-15, -6.174692420120676e-17, -2.461752312784218e-19,  1.040984413508893e-21,  1.512887006892886e-23,
  3.922961592532503e-26,  1.641910786883085e+00, -2.962716335172433e-03, -1.397785052822470e-05, -2.705227794702013e-08,  1.675091546692659e-10,  1.714342651068591e-12,
  5.133044202589461e-15, -2.562045859820678e-17, -3.435471082706578e-19, -1.254486860160620e-21,  5.029909721197036e-24,  8.266829087023487e-26,  1.733959184877739e+00,
 -2.344122849874686e-03, -1.286359928628522e-05, -4.260595752217127e-08,  9.518851563167681e-12,  1.203649563476379e-12,  8.165193282988124e-15,  1.976342706150454e-17,
 -1.358843206999547e-19, -1.731978619945783e-21, -8.100106366826697e-24,  4.223620035568969e-27,  1.814736081810577e+00, -1.721159344952717e-03, -1.063245252916199e-05,
 -4.734165042934631e-08, -1.170779690250035e-10,  3.262133452298447e-13,  5.960181236498431e-15,  3.819505699704847e-17,  1.193361637570141e-19, -3.162681295217192e-22,
 -6.991870361373559e-24, -4.889706318353661e-26,  1.882554566528714e+00, -1.139005396072758e-03, -7.708171079797669e-06, -4.146431419852742e-08, -1.720409210229202e-10,
 -4.156989932679598e-13,  1.136964674347764e-15,  2.238319109107110e-17,  1.665890383624737e-19,  7.970683313632326e-22,  1.770479353867965e-24, -1.116804130924152e-26,
  1.935942706020559e+00, -6.420382264729401e-04, -4.647682921924319e-06, -2.833096935678334e-08, -1.496285665079471e-10, -6.690616889336176e-13, -2.267091774576764e-15,
 -2.720768630627098e-18,  4.029415213586705e-20,  4.745086905738933e-22,  3.400434824894680e-24,  1.846109296312744e-26,  1.973705441004540e+00, -2.696378464274953e-04,
 -2.042850601391881e-06, -1.347800904001772e-08, -8.113708680277474e-11, -4.524418164114333e-13, -2.336805088205995e-15, -1.102515717288006e-17, -4.573830109754218e-20,
 -1.489993564422076e-22, -1.893769314401458e-25,  2.464816881811053e-27,  1.994984981063026e+00, -5.208480158137242e-05, -4.045830569081026e-07, -2.783197057620554e-09,
 -1.786608285186641e-11, -1.094779436097581e-13, -6.478229985275221e-16, -3.725372350661902e-18, -2.089169822828238e-20, -1.144428752306271e-22, -6.125635060017285e-25,
 -3.200834408450325e-27,  1.466750829366830e-03, -1.263702268433277e-05,  8.160203646502779e-08, -4.679985103600855e-10,  2.513469556018718e-12, -1.294241256031932e-14,
  6.468984936821895e-17, -3.161841281389519e-19,  1.518112203878289e-21, -7.182796410169631e-24,  3.355674910922581e-26, -1.550361616680912e-28,  1.318468512406884e-02,
 -1.130542459477292e-04,  7.228081956213204e-07, -4.075456586822153e-09,  2.132315013849772e-11, -1.057449156029147e-13,  5.018134312771606e-16, -2.287431844612383e-18,
  1.001219765755855e-20, -4.191583069654421e-23,  1.662871242715982e-25, -6.138331379194350e-28,  3.653455504393197e-02, -3.102772351520351e-04,  1.944054977929352e-06,
 -1.058183395491329e-08,  5.235166945164924e-11, -2.384539594077571e-13,  9.955633747139704e-16, -3.722205791841044e-18,  1.165954139585354e-20, -2.364917597573753e-23,
 -3.850999089710368e-26,  8.263209139863045e-28,  7.134302459640501e-02, -5.971304663250663e-04,  3.626639332269591e-06, -1.866284937485357e-08,  8.395742033638669e-11,
 -3.249968796250954e-13,  9.956984097933325e-16, -1.568686734096094e-18, -7.846791270052459e-21,  9.882398553845949e-23, -6.544200874168456e-25,  3.289130676234017e-27,
  1.173467580521910e-01, -9.629739600491223e-04,  5.601586165255620e-06, -2.655761250506152e-08,  1.022810559568720e-10, -2.800961397238544e-13,  1.143417951760440e-16,
  5.029849218633665e-18, -4.251456359396597e-20,  2.263167860839429e-22, -8.300262035668306e-25,  1.274233657703127e-27,  1.741884678369631e-01, -1.393864779649321e-03,
  7.660546680446012e-06, -3.232065082813129e-08,  9.489006667904605e-11, -5.750998473912488e-14, -1.571401324093807e-15,  1.303058772885365e-17, -6.185136571284690e-20,
  1.549161272420480e-22,  3.772464800618365e-25, -7.121905276932866e-27,  2.414117347930456e-01, -1.872794879134777e-03,  9.570262712690545e-06, -3.412549073498107e-08,
  5.455075647076431e-11,  3.200353421874499e-13, -3.407131784693543e-15,  1.631033113667179e-17, -3.082149677213775e-20, -2.074846835519859e-22,  2.391984934246067e-24,
 -1.215355000474574e-26,  3.184547047463780e-01, -2.380024358362606e-03,  1.109039269683240e-05, -3.058956358886674e-08, -1.769831788538380e-11,  7.515116906168555e-13,
 -4.344932943637820e-15,  9.212756123512064e-18,  5.559737168702672e-20, -6.373954930594069e-22,  2.777025385043664e-24, -2.962774289745229e-28,  4.046428267446223e-01,
 -2.893533227360625e-03,  1.199425386996831e-05, -2.108076524881250e-08, -1.110351592208817e-10,  1.077204047986988e-12, -3.412656699421035e-15, -8.766372012726606e-18,
  1.498853536570731e-19, -6.621822282250992e-22, -4.693980948414447e-25,  2.389002679909167e-26,  4.991808856257983e-01, -3.389617652477797e-03,  1.209166423359018e-05,
 -5.957238064387222e-09, -2.056481189039805e-10,  1.127798575058946e-12, -3.086482167750091e-16, -3.015157278472890e-17,  1.690498752916188e-19,  2.567506793907677e-23,
 -5.593322181739089e-24,  3.022219922322957e-26,  6.011447013270805e-01, -3.843657358237061e-03,  1.125254943488030e-05,  1.331381849574671e-08, -2.762414025973843e-10,
  7.925801379031173e-13,  4.164641743651099e-15, -4.144883546977904e-17,  5.525343744692946e-20,  1.097746304912858e-21, -6.937618967865388e-24, -5.584805344995957e-27,
  7.094730256206286e-01, -4.231077933157792e-03,  9.429319168941536e-06,  3.421169365790580e-08, -2.980733964003076e-10,  8.489867584143950e-14,  8.141890291934390e-15,
 -3.060100297675574e-17, -1.559619589066171e-19,  1.597966297651181e-21, -3.749068901219886e-25, -5.629636815284009e-26,  8.229603677566404e-01, -4.528523276015434e-03,
  6.675262605361795e-06,  5.343338033072113e-08, -2.545391019563414e-10, -8.245790045964570e-13,  9.383490334821880e-15,  3.286054267055477e-18, -3.233248836464242e-19,
  7.106192748744420e-22,  9.906626140495736e-24, -5.270308768264139e-26,  9.402517231149311e-01, -4.715236940917036e-03,  3.155479430523063e-06,  6.739345512855788e-08,
 -1.444097270540542e-10, -1.634302761129260e-12,  6.462221098851637e-15,  4.467616438140534e-17, -2.858833850107430e-19, -1.210068401832904e-21,  1.247623602317381e-23,
  2.826691145321789e-26,  1.059840454165604e+00, -4.774624211754759e-03, -8.536341772720976e-07,  7.291773004128945e-08,  1.385492305094554e-11, -2.008676980252273e-12,
 -1.009443499728726e-16,  6.731078601853709e-17, -1.032123986530669e-20, -2.497822194161897e-21,  9.704036698109156e-25,  9.865678014022347e-26,  1.180070857814352e+00,
 -4.695927473460862e-03, -4.980261423345259e-06,  6.802998181316900e-08,  1.833637332694971e-10, -1.724218287967411e-12, -7.538633816220640e-15,  5.116813813694854e-17,
  3.261596358250071e-19, -1.597736150200236e-21, -1.448860868022555e-23,  4.915519688950865e-26,  1.299147204843239e+00, -4.475895786219519e-03, -8.791278358866807e-06,
  5.265837459819696e-08,  3.172076184213896e-10, -8.064021888987995e-13, -1.194294438101032e-14,  6.738489902295263e-19,  4.401218678871554e-19,  1.009378452723546e-21,
 -1.511297169578491e-23, -7.768353454020598e-26,  1.415151188060354e+00, -4.120269046593238e-03, -1.184504952561413e-05,  2.903267398027872e-08,  3.732059837037014e-10,
  4.236906397540160e-13, -1.053653020603126e-14, -5.218601700225658e-17,  2.005013871351774e-19,  2.753969059754474e-21,  2.221850359977794e-24, -1.051697886633829e-25,
  1.526069672180081e+00, -3.644836936751503e-03, -1.375931680054656e-05,  1.541425008761396e-09,  3.308009613790036e-10,  1.454409939201412e-12, -3.808560276002501e-15,
 -6.890513057275301e-17, -1.974492012057687e-19,  1.674132631534816e-21,  1.634942196152735e-23,  1.463913363046909e-26,  1.629834287773071e+00, -3.075789438265148e-03,
 -1.428524455798996e-05, -2.409140993441752e-08,  2.029632394514259e-10,  1.827644811968477e-12,  4.255292424250364e-15, -3.729032224324697e-17, -3.841678045971980e-19,
 -9.759091168040182e-22,  9.006347224549781e-24,  9.735499968162757e-26,  1.724373643992473e+00, -2.449072241379989e-03, -1.337312757716152e-05, -4.225024600689117e-08,
  3.559352069137937e-11,  1.405703522610707e-12,  8.647877420611890e-15,  1.435565733490514e-17, -2.039739781328146e-19, -2.046805035042639e-21, -7.493977461276433e-24,
  2.444781157341922e-26,  1.807677682986503e+00, -1.808522661439002e-03, -1.121155033084220e-05, -4.915456049622026e-08, -1.090344540945017e-10,  4.825101967755654e-13,
  7.080983922082602e-15,  4.177332414538596e-17,  1.023775858476014e-19, -6.411757013465736e-22, -9.304873653752601e-24, -5.592120056177786e-26,  1.877871996035970e+00,
 -1.202708468050162e-03, -8.222527728323901e-06, -4.428177390214427e-08, -1.800280368672065e-10, -3.802617271593572e-13,  1.842730780267686e-15,  2.818570522950773e-17,
  1.964162099924610e-19,  8.554199190416909e-22,  1.075717947990629e-24, -2.098146903859474e-26,  1.933297978211738e+00, -6.806213116453350e-04, -5.002470117502731e-06,
 -3.083505564748037e-08, -1.635592494707136e-10, -7.242236030388588e-13, -2.322456807518386e-15, -1.130136386647750e-18,  6.003001580004225e-20,  6.278153956099844e-22,
  4.291049442119670e-24,  2.204690057568975e-26,  1.972593147591598e+00, -2.866503730025354e-04, -2.212684646557531e-06, -1.485174831231205e-08, -9.077263737011300e-11,
 -5.123999838524184e-13, -2.666815689296203e-15, -1.257582799928385e-17, -5.120813058106548e-20, -1.539164780159249e-22, -4.309613266435655e-26,  4.306543648098468e-27,
  1.994769949917709e+00, -5.546009114654024e-05, -4.397716576865023e-07, -3.087452490561541e-09, -2.021997560504436e-11, -1.263569480499460e-13, -7.621476514979083e-16,
 -4.464844676575993e-18, -2.548884082517859e-20, -1.420081647814566e-22, -7.721908857071731e-25, -4.092874890485234e-27,  1.417473743234481e-03, -1.200600579635866e-05,
  7.621907068238629e-08, -4.297723421919391e-10,  2.269457152342293e-12, -1.149083453507962e-14,  5.647970727896991e-17, -2.714955374566370e-19,  1.282135365230515e-21,
 -5.967510195114049e-24,  2.742832645275309e-26, -1.246970991959018e-28,  1.274373131811072e-02, -1.074617589885252e-04,  6.758820090376203e-07, -3.750572148801600e-09,
  1.932368050882925e-11, -9.443511591400477e-14,  4.420328104048865e-16, -1.989952458729086e-18,  8.616698610259513e-21, -3.577689320826307e-23,  1.413201019380694e-25,
 -5.231511707296302e-28,  3.532376639918323e-02, -2.952188378928316e-04,  1.821945461366025e-06, -9.781096349593113e-09,  4.781329803266262e-11, -2.157697342879015e-13,
  8.964353650012772e-16, -3.362953639555797e-18,  1.078844251672602e-20, -2.454509801155248e-23, -8.184273406985665e-27,  5.653456611875684e-28,  6.901114218275763e-02,
 -5.689908176543458e-04,  3.410534718068022e-06, -1.737024716348368e-08,  7.769275925366933e-11, -3.016524570618423e-13,  9.487602221114304e-16, -1.767641101252421e-18,
 -4.727040301543590e-21,  7.536617289402261e-23, -5.226651343634188e-25,  2.713220090915206e-27,  1.135825079281982e-01, -9.194086402307031e-04,  5.292529540478494e-06,
 -2.496573667788510e-08,  9.671721949991520e-11, -2.758083379921330e-13,  2.373108650617115e-16,  3.793451404312227e-18, -3.495008872898753e-20,  1.943626060337935e-22,
 -7.650448743862675e-25,  1.637887289030043e-27,  1.687331574022874e-01, -1.334106087475688e-03,  7.281764052131603e-06, -3.081354037185767e-08,  9.339115036086734e-11,
 -9.106375078814666e-14, -1.233398470290326e-15,  1.114291352806390e-17, -5.607248296620895e-20,  1.643699189532462e-22,  1.102571794626432e-25, -5.087311216086557e-27,
  2.340711074960240e-01, -1.797855504831813e-03,  9.166190947350389e-06, -3.320576268942636e-08,  6.017014055945638e-11,  2.436267330031396e-13, -2.965247751852412e-15,
  1.522197311404543e-17, -3.669438063459211e-20, -1.221426215729632e-22,  1.884583724512933e-24, -1.085788873108611e-26,  3.091097234532977e-01, -2.292773223845978e-03,
  1.072209678773983e-05, -3.075806953873031e-08, -3.689021631317191e-12,  6.505093884179199e-13, -4.065365360188048e-15,  1.064607957621577e-17,  3.463756343106852e-20,
 -5.276410398456017e-22,  2.686837174519085e-24, -3.576336253236042e-27,  3.932589592432770e-01, -2.798619666633718e-03,  1.173132164613204e-05, -2.268949924089707e-08,
 -9.032729072827235e-11,  9.928746640332686e-13, -3.594564701881194e-15, -4.353140619158988e-18,  1.259446528886253e-19, -6.618514107064436e-22,  4.393146434389533e-25,
  1.749547158385917e-26,  4.858153521797839e-01, -3.293224512065966e-03,  1.200117744289833e-05, -9.067838721087845e-09, -1.832314493279813e-10,  1.110870748597344e-12,
 -1.077311701471629e-15, -2.476775876311951e-17,  1.662685458280729e-19, -1.713801991974992e-22, -4.262008812286559e-24,  2.988302783100949e-26,  5.859510200890037e-01,
 -3.753071799069946e-03,  1.138633570798618e-05,  9.025809019514337e-09, -2.594831112499497e-10,  8.788391202871292e-13,  3.034385358947583e-15, -3.910224076848738e-17,
  8.975151156860121e-20,  8.189661713615152e-22, -6.916651583054473e-24,  6.042984469740496e-27,  6.927020688784518e-01, -4.154082097935594e-03,  9.811334052316267e-06,
  2.946641933955778e-08, -2.944934620954960e-10,  2.695110823529213e-13,  7.223791720657896e-15, -3.467889739810096e-17, -9.927157331621602e-20,  1.536814599374535e-21,
 -2.594561621921895e-24, -4.422720299945079e-26,  8.049570404959278e-01, -4.472626781344541e-03,  7.291522864817474e-06,  4.924106870774959e-08, -2.687771239978243e-10,
 -5.994140084951969e-13,  9.335014264266576e-15, -6.579263215863206e-18, -2.911956864534508e-19,  1.057635643470593e-21,  7.385332205083078e-24, -6.078709288551803e-26,
  9.214463262677108e-01, -4.686799926430348e-03,  3.949287331156940e-06,  6.483024402762135e-08, -1.754490243584299e-10, -1.465268774157761e-12,  7.579227607572971e-15,
  3.492919228510662e-17, -3.202322245485556e-19, -6.937199443166436e-22,  1.315446447230519e-23,  2.677407568048042e-27,  1.040733842216928e+00, -4.777952516461130e-03,
  2.138424959836253e-08,  7.281852792927035e-08, -2.619072615265662e-11, -1.988603153077033e-12,  1.765717720971195e-15,  6.555765847357989e-17, -9.851168699281321e-20,
 -2.373831558885942e-21,  5.170879400537587e-24,  9.067862972837683e-26,  1.161212700895289e+00, -4.732456932962139e-03, -4.147467169950799e-06,  7.067860386122599e-08,
  1.471920002754760e-10, -1.886830643216683e-12, -5.969223673642202e-15,  6.057786768346706e-17,  2.588121558607502e-19, -2.125132447567888e-21, -1.167026235027880e-23,
  7.805570647164470e-26,  1.281107083345508e+00, -4.543613457399977e-03, -8.129508517453591e-06,  5.758913397863240e-08,  2.982231480554489e-10, -1.091185713546957e-12,
 -1.172230780280906e-14,  1.521620272202973e-17,  4.648176271167639e-19,  3.435904157847987e-22, -1.798235499571536e-23, -5.107048960876231e-26,  1.398482941609582e+00,
 -4.213533810084693e-03, -1.146059585739007e-05,  3.505753799683255e-08,  3.790368085617399e-10,  1.540964158882967e-13, -1.189294166914652e-14, -4.417597997462806e-17,
  3.000693702142222e-19,  2.743882764651489e-21, -2.869768032778138e-24, -1.248171771786850e-25,  1.511270422410098e+00, -3.754745329763262e-03, -1.370812080658395e-05,
  7.061311554064820e-09,  3.588153917497546e-10,  1.339198614508554e-12, -5.816396272972999e-15, -7.413227471671452e-17, -1.253376667400057e-19,  2.331631981323683e-21,
  1.627783146294849e-23, -1.934221972810900e-26,  1.617300816803553e+00, -3.191169764199199e-03, -1.455363381729904e-05, -2.054640641791017e-08,  2.404455240707305e-10,
  1.915823365410699e-12,  3.034319810491212e-15, -5.006771379830412e-17, -4.117546981024875e-19, -5.269139249074359e-22,  1.350537189348149e-23,  1.057976480943910e-25,
  1.714360190545013e+00, -2.558073381812293e-03, -1.387574891876631e-05, -4.144443777570857e-08,  6.581153222901798e-11,  1.617268418451959e-12,  8.946980034127858e-15,
  6.594219166786941e-18, -2.827281270881931e-19, -2.317565797357075e-21, -5.846407726551236e-24,  5.157903437696578e-26,  1.800260430964583e+00, -1.900603344955081e-03,
 -1.181152289559189e-05, -5.081227248420321e-08, -9.758825913440100e-11,  6.668358279333590e-13,  8.292491629030229e-15,  4.460334912889331e-17,  7.198874025340588e-20,
 -1.064069464066024e-21, -1.186976019847270e-23, -5.999265278408023e-26,  1.872926166433842e+00, -1.270663743650952e-03, -8.771434131006629e-06, -4.722037997451739e-08,
 -1.871232985440894e-10, -3.258268475294358e-13,  2.724602212784529e-15,  3.497002795385149e-17,  2.277300563354885e-19,  8.762695288155375e-22, -1.326573325552462e-25,
 -3.464375597870480e-26,  1.930493045696121e+00, -7.221667639046098e-04, -5.388680290245305e-06, -3.357091447330330e-08, -1.786024593856094e-10, -7.801031075298196e-13,
 -2.323561958929973e-15,  1.187534019750939e-18,  8.596441860923129e-20,  8.199225919570792e-22,  5.340300396402432e-24,  2.560700550638171e-26,  1.971409978499628e+00,
 -3.050902263007317e-04, -2.399969583396847e-06, -1.638969515419519e-08, -1.016901735057987e-10, -5.808193290303232e-13, -3.042713131237169e-15, -1.430306388988350e-17,
 -5.672797826239310e-20, -1.511216880200340e-22,  2.027065385432461e-25,  7.040710932315548e-27,  1.994540830534121e+00, -5.913216069839778e-05, -4.788489403963969e-07,
 -3.432227278650480e-09, -2.294065345618846e-11, -1.462457930994616e-13, -8.993954841534491e-16, -5.368616520722716e-18, -3.120337721638025e-20, -1.768161566350041e-22,
 -9.766188352738350e-25, -5.248864413259870e-27,  1.370637411513371e-03, -1.141628201105356e-05,  7.127231821544712e-08, -3.952284154385849e-10,  2.052602984444179e-12,
 -1.022209904955164e-14,  4.942138245749365e-17, -2.337030208122685e-19,  1.085800002514098e-21, -4.972625151168636e-24,  2.249098579797866e-26, -1.006397897844556e-28,
  1.232442058646860e-02, -1.022296142265708e-04,  6.326697061052318e-07, -3.455944867067930e-09,  1.753670897015215e-11, -8.446494667329735e-14,  3.899883226130480e-16,
 -1.733778178473292e-18,  7.425152791211333e-21, -3.056053946761299e-23,  1.200682865718321e-25, -4.447745227199147e-28,  3.417131674895139e-02, -2.811000821411471e-04,
  1.709023674489955e-06, -9.049469110775653e-09,  4.370561880082794e-11, -1.953470445343473e-13,  8.069728602250692e-16, -3.031879700729061e-18,  9.904360875051019e-21,
 -2.443561417982945e-23,  1.226911040549360e-26,  3.743125992736361e-28,  6.678845656837488e-02, -5.425196299016574e-04,  3.209355127283210e-06, -1.617420732995650e-08,
  7.188332534792730e-11, -2.794908637867951e-13,  8.975289786825301e-16, -1.879306117047685e-18, -2.362795430340073e-21,  5.669573618538741e-23, -4.144614665694445e-25,
  2.218209837082884e-27,  1.099876930333684e-01, -8.782408692315452e-04,  5.002044615692246e-06, -2.346204712589927e-08,  9.126598442609200e-11, -2.689583993993028e-13,
  3.288804820259332e-16,  2.781239955232123e-18, -2.848594979608685e-20,  1.652598923440421e-22, -6.889821585972770e-25,  1.791209213650015e-27,  1.635109351153224e-01,
 -1.277305770957752e-03,  6.920902087374625e-06, -2.933535801489156e-08,  9.129810723692863e-11, -1.171185654645118e-13, -9.456241095304412e-16,  9.443715208439838e-18,
 -5.012508861385590e-20,  1.648070100306141e-22, -7.666173969628041e-26, -3.474419146362942e-27,  2.270238444566722e-01, -1.726103141683224e-03,  8.773646787112000e-06,
 -3.220778436737468e-08,  6.436483802956744e-11,  1.774391175887593e-13, -2.556034181484781e-15,  1.399103908686123e-17, -3.984581648703170e-20, -5.588010248063056e-23,
  1.439507581425607e-24, -9.355078400613449e-27,  3.001078463375071e-01, -2.208472885451738e-03,  1.035305825316590e-05, -3.071821023261533e-08,  8.370199260087448e-12,
  5.566261336604506e-13, -3.754467206437070e-15,  1.147095260747416e-17,  1.753273997697422e-20, -4.239953196819569e-22,  2.480646152576443e-24, -5.613044223566720e-27,
  3.822504245866055e-01, -2.705881279908410e-03,  1.145101625504599e-05, -2.398059678759454e-08, -7.134010511360183e-11,  9.055760125599556e-13, -3.663578993581868e-15,
 -6.993464147814133e-19,  1.026038431837630e-19, -6.306276178383300e-22,  1.080128297175086e-24,  1.176733542399520e-26,  4.728337156672996e-01, -3.197698509466034e-03,
  1.187550116483758e-05, -1.182343246137188e-08, -1.613256834866997e-10,  1.077287713841792e-12, -1.697467989503950e-15, -1.957624369512170e-17,  1.573419888121593e-19,
 -3.161491651196271e-22, -2.994045825390532e-24,  2.747825237218485e-26,  5.711215023753752e-01, -3.661617094259863e-03,  1.147032688625562e-05,  5.018284253071255e-09,
 -2.412649742638320e-10,  9.388759065285749e-13,  1.983786691551611e-15, -3.581117620587582e-17,  1.143436984094313e-19,  5.503530889544086e-22, -6.452034700036575e-24,
  1.455165460280934e-26,  6.762448488090923e-01, -4.074256670416688e-03,  1.013686718643940e-05,  2.480672958922921e-08, -2.874498233305402e-10,  4.309213226383403e-13,
  6.216462462150301e-15, -3.699398586481122e-17, -4.624779318779317e-20,  1.398024593175355e-21, -4.246921645355293e-24, -3.079469769810506e-26,  7.871868357451216e-01,
 -4.412004966915087e-03,  7.856256687539668e-06,  4.485682023194390e-08, -2.785452080839361e-10, -3.786001733755580e-13,  9.026439015488152e-15, -1.523660720480706e-17,
 -2.484570543986985e-19,  1.298646024875307e-21,  4.653943355989764e-24, -6.234560764741043e-26,  9.027671720318067e-01, -4.652143659634351e-03,  4.709472948270657e-06,
  6.179881137981759e-08, -2.028622350123445e-10, -1.272808510167834e-12,  8.410749768058749e-15,  2.438352879035456e-17, -3.357720905024119e-19, -1.723419441975898e-22,
  1.274305632646106e-23, -2.081500538615885e-26,  1.021627894487386e+00, -4.774296281649864e-03,  8.913889430318414e-07,  7.208421900663744e-08, -6.539250245148734e-11,
 -1.924632120000429e-12,  3.544680337738450e-15,  6.108543057568493e-17, -1.793238021107175e-19, -2.091573020815605e-21,  8.819337851873175e-24,  7.386900560668025e-26,
  1.142221937942999e+00, -4.762206976737875e-03, -3.286462399568379e-06,  7.272459169807398e-08,  1.081646898682632e-10, -2.008875720175254e-12, -4.169198035268147e-15,
  6.755283539743998e-17,  1.747974759161956e-19, -2.516237308632029e-21, -7.726855923253848e-24,  9.971875580420232e-26,  1.262807046360687e+00, -4.605805887483685e-03,
 -7.410578716278167e-06,  6.217100393825141e-08,  2.736293068756579e-10, -1.365721308447663e-12, -1.108716868522571e-14,  3.014563649693557e-17,  4.637870413196548e-19,
 -4.107607616745795e-22, -1.947706029423916e-23, -1.568774759780734e-26,  1.381448246937988e+00, -4.303432585643102e-03, -1.100346749953836e-05,  4.113087408939006e-08,
  3.791702310138812e-10, -1.450020524804026e-13, -1.298080944503237e-14, -3.302640750954661e-17,  3.954258323864153e-19,  2.515744254749401e-21, -8.601579583167613e-24,
 -1.336056925729167e-25,  1.496032788220303e+00, -3.863971772702716e-03, -1.358808143340112e-05,  1.300833216339360e-08,  3.840332999414899e-10,  1.174325436896324e-12,
 -7.934749560991047e-15, -7.667675496166915e-17, -2.999028555957014e-20,  2.953956760146171e-21,  1.453590875900608e-23, -6.081369990341543e-26,  1.604301814278550e+00,
 -3.308516725780690e-03, -1.477583203087319e-05, -1.638929315910483e-08,  2.793689196141693e-10,  1.970321810643427e-12,  1.445902339229028e-15, -6.343396230550039e-17,
 -4.198731163531302e-19,  1.067586591405090e-22,  1.816569496587066e-23,  1.040080204856944e-25,  1.703902763866197e+00, -2.671048271158592e-03, -1.436565895071448e-05,
 -4.012098006950901e-08,  1.003135152407702e-10,  1.833110666974512e-12,  8.992119957015808e-15, -3.828136442088498e-18, -3.697376377283984e-19, -2.496575357427589e-21,
 -2.859321771960357e-24,  8.515302915208516e-26,  1.792465135439260e+00, -1.997559975235619e-03, -1.243016232870793e-05, -5.225574866809065e-08, -8.215900140754244e-11,
  8.810638640897401e-13,  9.567194319398393e-15,  4.619727301310963e-17,  2.449824098545447e-20, -1.591738887736243e-21, -1.450386305760348e-23, -5.858833203870192e-26,
  1.867699507287126e+00, -1.343153162934675e-03, -9.356245118243206e-06, -5.026258406335852e-08, -1.929022398169816e-10, -2.478339607203537e-13,  3.810502427075191e-15,
  4.275782178561296e-17,  2.587678327546379e-19,  8.354610713362956e-22, -2.040566765156756e-24, -5.288535967937032e-26,  1.927515538194988e+00, -7.669373953520830e-04,
 -5.809201737657478e-06, -3.655638298344941e-08, -1.947577552921280e-10, -8.351299322600128e-13, -2.247054545564063e-15,  4.454159625413494e-18,  1.196069202774812e-19,
  1.057016917106794e-21,  6.536352463452164e-24,  2.860467031940915e-26,  1.970149932217956e+00, -3.251052573769778e-04, -2.606804756155676e-06, -1.811377664022174e-08,
 -1.140703317956178e-10, -6.588603568453692e-13, -3.469415955697457e-15, -1.620317233317331e-17, -6.193818654411024e-20, -1.357472381854423e-22,  5.950978857586580e-25,
  1.104175555326108e-26,  1.994296370346803e+00, -6.313416916422546e-05, -5.223384364470188e-07, -3.823903089814621e-09, -2.609420936303814e-11, -1.697541340777499e-13,
 -1.064709276706480e-15, -6.476986164110700e-18, -3.833130043655980e-20, -2.209134569258705e-22, -1.239166824498327e-24, -6.749942124681505e-27,  1.326083371429780e-03,
 -1.086453125091790e-05,  6.672008337369635e-08, -3.639600143266817e-10,  1.859511708243016e-12, -9.110743242183201e-15,  4.333841395613481e-17, -2.016563213281024e-19,
  9.219665954766899e-22, -4.155596899237112e-24,  1.849974032920901e-26, -8.149540179577660e-29,  1.192536876194292e-02, -9.732949710927381e-05,  5.928277482434525e-07,
 -3.188379405458840e-09,  1.593720959036295e-11, -7.566191139672699e-14,  3.446100014180108e-16, -1.512886266045398e-18,  6.406894763975868e-21, -2.612864540846390e-23,
  1.020162707806135e-25, -3.774971676101661e-28,  3.307358943944873e-02, -2.678506695657824e-04,  1.604500186832703e-06, -8.380410674005159e-09,  3.998565675165137e-11,
 -1.769634019922051e-13,  7.263859852293991e-16, -2.728890838641022e-18,  9.037074302811879e-21, -2.365953211801347e-23,  2.552777075514968e-26,  2.358112781789071e-28,
  6.466852554361444e-02, -5.176020158823497e-04,  3.021984716545409e-06, -1.506764030644983e-08,  6.650461620601377e-11, -2.585883829075484e-13,  8.441349676823764e-16,
 -1.925275358682354e-18, -5.978192623778578e-22,  4.194075899627710e-23, -3.263358143387162e-25,  1.799543356183609e-27,  1.065530136655185e-01, -8.393262721266133e-04,
  4.729085529368330e-06, -2.204437116605062e-08,  8.597154590779210e-11, -2.602284655247716e-13,  3.948508576897330e-16,  1.959715363921305e-18, -2.301354197307338e-20,
  1.392888888744872e-22, -6.094800488281371e-25,  1.804097395337567e-27,  1.585102517918849e-01, -1.223322003956502e-03,  6.577561354873852e-06, -2.789447365023848e-08,
  8.874929091367315e-11, -1.368162540811576e-13, -7.027700211355559e-16,  7.933774256412331e-18, -4.428046936061062e-20,  1.590741691708144e-22, -2.009208508541870e-25,
 -2.229612486330844e-27,  2.202573874921227e-01, -1.657442185096608e-03,  8.393439069933930e-06, -3.115275918623617e-08,  6.733115271223467e-11,  1.206497229804478e-13,
 -2.182363734995358e-15,  1.269412109430841e-17, -4.091611721239058e-20, -6.077923267128281e-24,  1.061806157515857e-24, -7.818410933339814e-27,  2.914372734340067e-01,
 -2.127119802013312e-03,  9.985595084629601e-06, -3.050001251822444e-08,  1.862793618032475e-11,  4.704231276592476e-13, -3.427586909601127e-15,  1.180642285852914e-17,
  3.991932802408772e-21, -3.300830379069824e-22,  2.207272735692338e-24, -6.673635032996571e-27,  3.716082675827639e-01, -2.615442277591608e-03,  1.115698264601172e-05,
 -2.498192386272537e-08, -5.410760033315885e-11,  8.177654961363970e-13, -3.640542258760845e-15,  2.229995870313202e-18,  8.079003038605122e-20, -5.785574535249259e-22,
  1.488227013584153e-24,  6.942019308835688e-27,  4.602319712578333e-01, -3.103304283279181e-03,  1.171883606458708e-05, -1.423466713333819e-08, -1.402288274914200e-10,
  1.030528527549775e-12, -2.176975986248857e-15, -1.474421052182396e-17,  1.440871598771433e-19, -4.127469208205808e-22, -1.862777493477746e-24,  2.379066374704701e-26,
  5.566588498730203e-01, -3.569677783362257e-03,  1.150801198424014e-05,  1.310518401313045e-09, -2.220903589137418e-10,  9.748842579888645e-13,  1.034930937783931e-15,
 -3.188361931369892e-17,  1.296821101322768e-19,  3.068858870253273e-22, -5.681982552409401e-24,  1.995885590645302e-26,  6.601117878608895e-01, -3.992048490349225e-03,
  1.040726245662605e-05,  2.028423148673080e-08, -2.774240196536219e-10,  5.675644809342051e-13,  5.167230023405196e-15, -3.770385205417619e-17,  7.328506346639611e-22,
  1.205002212665501e-21, -5.307730253961174e-24, -1.756876037184382e-26,  7.696678174781011e-01, -4.347078050124340e-03,  8.367586007896740e-06,  4.035113070000051e-08,
 -2.839898784144663e-10, -1.679392071844248e-13,  8.495758799807280e-15, -2.240860764132164e-17, -1.990091714146548e-19,  1.430771140422055e-21,  1.982098223657638e-24,
 -5.827876607366873e-26,  8.842385653113590e-01, -4.611558573979347e-03,  5.430779965246063e-06,  5.836054412361228e-08, -2.262508100174686e-10, -1.063974068704266e-12,
  8.942819158630045e-15,  1.363577222069624e-17, -3.330773313196718e-19,  3.130721766646529e-22,  1.138878900089266e-23, -3.985655599006665e-26,  1.002550421058126e+00,
 -4.763725806927507e-03,  1.748868165383348e-06,  7.073518909267385e-08, -1.028995169030306e-10, -1.819750511501498e-12,  5.163936117921436e-15,  5.421638545895560e-17,
 -2.475454999304987e-19, -1.680275374825496e-21,  1.157565086803066e-23,  5.059299354804162e-26,  1.123126091175527e+00, -4.784981560314593e-03, -2.404725175451271e-06,
  7.412902336998030e-08,  6.714268213259233e-11, -2.085692267901341e-12, -2.213401501201640e-15,  7.164619911553510e-17,  7.974662044457038e-20, -2.733364108128587e-21,
 -3.045542630555213e-24,  1.112195668094595e-25,  1.244270080767899e+00, -4.662034050133709e-03, -6.639205607530881e-06,  6.631641670159070e-08,  2.437309201478283e-10,
 -1.620026429116463e-12, -1.003861373789575e-14,  4.459920494969771e-17,  4.349157628492951e-19, -1.191963110705840e-21, -1.928814807083305e-23,  2.472347006000594e-26,
  1.364061732232332e+00, -4.389383241209651e-03, -1.047364799545057e-05,  4.715718284126399e-08,  3.730876270718116e-10, -4.661274673943891e-13, -1.371532288963229e-14,
 -1.900160628665207e-17,  4.783853280669739e-19,  2.054609160507290e-21, -1.441508065203409e-23, -1.280707431157691e-25,  1.480360630192834e+00, -3.971945853044515e-03,
 -1.339437470862860e-05,  1.932967950182999e-08,  4.054414365666057e-10,  9.581217412580723e-13, -1.007838165087581e-14, -7.582876781743833e-17,  8.605336220653124e-20,
  3.468693781937279e-21,  1.087179047316436e-23, -1.059139373306579e-25,  1.590830199714487e+00, -3.427431075723110e-03, -1.494437932821081e-05, -1.160288460907210e-08,
  3.189706916073795e-10,  1.982200177648976e-12, -5.167232101711211e-16, -7.665940979859096e-17, -4.018779791367762e-19,  9.213583798271460e-22,  2.244810270240949e-23,
  8.800385035290143e-26,  1.692985713333432e+00, -2.787869202304387e-03, -1.483623293814577e-05, -3.821100196179927e-08,  1.391178908382650e-10,  2.046214678983407e-12,
  8.705666478203250e-15, -1.711186117651131e-17, -4.606705375243464e-19, -2.525028712392078e-21,  1.714449278518548e-24,  1.232326999331619e-25,  1.784272011825523e+00,
 -2.099530474591929e-03, -1.306449545892196e-05, -5.341640617752703e-08, -6.213660390978459e-11,  1.126230323582971e-12,  1.086225175690188e-14,  4.594748246801484e-17,
 -4.384941420547402e-20, -2.221223984693965e-21, -1.689694759348063e-23, -4.844264414813012e-26,  1.862173300229200e+00, -1.420468539659440e-03, -9.978061063372395e-06,
 -5.338328020067933e-08, -1.968424723599902e-10, -1.410524619724454e-13,  5.128030404395957e-15,  5.149893247927003e-17,  2.867560644717561e-19,  7.008169235690901e-22,
 -4.861276702743838e-24, -7.617513163733963e-26,  1.924351986616407e+00, -8.152199779367859e-04, -6.267135619668229e-06, -3.980900736317567e-08, -2.119871538069678e-10,
 -8.870931187159701e-13, -2.062659389444010e-15,  8.943383534467559e-18,  1.626746947629687e-19,  1.344239313954125e-21,  7.836021450697192e-24,  3.012697458365835e-26,
  1.968806380503982e+00, -3.468612154782244e-04, -2.835570761638743e-06, -2.004900206412282e-08, -1.281181235403511e-10, -7.477989002416475e-13, -3.951549055021988e-15,
 -1.825775013066200e-17, -6.626565649536273e-20, -1.006749242987701e-22,  1.200548613082747e-24,  1.682354636393837e-26,  1.994035175266416e+00, -6.750378899215429e-05,
 -5.708470273788571e-07, -4.270023734146680e-09, -2.976026088784986e-11, -1.976297354974634e-13, -1.264504617872437e-15, -7.841012723258638e-18, -4.725279369565105e-20,
 -2.769577423165018e-22, -1.577250601086640e-24, -8.702214998579545e-27,  1.283665803044734e-03, -1.034774836789153e-05,  6.252524119182649e-08, -3.356108941319582e-10,
  1.687257367388502e-12, -8.135177293977348e-15,  3.808356693346855e-17, -1.744109207136466e-19,  7.848644393172594e-22, -3.482574281776237e-24,  1.526264092308985e-26,
 -6.620783548363689e-29,  1.154529967249738e-02, -9.273569457019908e-05,  5.560486478961732e-07, -2.945054583125570e-09,  1.450336268056440e-11, -6.787727558724182e-14,
  3.049834986497189e-16, -1.322159591296195e-18,  5.535873546571824e-21, -2.236261180787355e-23,  8.670372037038294e-26, -3.200432482450487e-28,  3.202723686041877e-02,
 -2.554063146418908e-04,  1.507660084611407e-06, -7.768032504103674e-09,  3.661469779617315e-11, -1.604151471064477e-13,  6.538991186122895e-16, -2.453116928058427e-18,
  8.205918646588660e-21, -2.246259184486456e-23,  3.359739288417527e-26,  1.365419300661064e-28,  6.264534912334552e-02, -4.941316816230132e-04,  2.847390323180550e-06,
 -1.404385818692206e-08,  6.153106884770397e-11, -2.389768891586324e-13,  7.901693212619509e-16, -1.922618669608116e-18,  6.951800257096196e-22,  3.036328671200951e-23,
 -2.550832633247945e-25,  1.449916357651968e-27,  1.032697310691689e-01, -8.025287255624967e-04,  4.472636308343879e-06, -2.070993088345434e-08,  8.086577442166733e-11,
 -2.501723286333000e-13,  4.401340016027499e-16,  1.298961566897019e-18, -1.841898563098128e-20,  1.164799161536562e-22, -5.315275336189328e-25,  1.727933955373466e-27,
  1.537201185762310e-01, -1.172016521596652e-03,  6.251254535355826e-06, -2.649721929237381e-08,  8.586148955156705e-11, -1.511718730415784e-13, -4.996131633766143e-16,
  6.606701069012441e-18, -3.871937455328108e-20,  1.493710726312094e-22, -2.774271723723638e-25, -1.294123928222548e-27,  2.137595722415302e-01, -1.591771525416782e-03,
  8.026140484663820e-06, -3.005888440312079e-08,  6.924840565882510e-11,  7.239034006598092e-14, -1.845236984364879e-15,  1.138885507192286e-17, -4.044932821754989e-20,
  2.995194052228626e-23,  7.503216565769118e-25, -6.359280408960179e-27,  2.830862538063134e-01, -2.048693288575269e-03,  9.621679524860184e-06, -3.013105489014714e-08,
  2.724058502268010e-11,  3.921320496762833e-13, -3.096886979329054e-15,  1.176049316405848e-17, -6.373978276760127e-21, -2.478086001793606e-22,  1.904022024092613e-24,
 -7.010387828071673e-27,  3.613230923913047e-01, -2.527399053749434e-03,  1.085252964773346e-05, -2.572152401266717e-08, -3.861953324503104e-11,  7.314150763432601e-13,
 -3.544954583645675e-15,  4.494040958169614e-18,  6.109602082211638e-20, -5.141220777074609e-22,  1.705550716962493e-24,  3.098284972216760e-27,  4.480051218603195e-01,
 -3.010273453725366e-03,  1.153522868347508e-05, -1.631641375711408e-08, -1.201715383205232e-10,  9.738338739017452e-13, -2.527587649310619e-15, -1.038357048835454e-17,
  1.281280939899745e-19, -4.675639546918308e-22, -9.094814239647315e-25,  1.948668680596526e-26,  5.425642832109365e-01, -3.477609702062964e-03,  1.150306451696617e-05,
 -2.085891289861030e-09, -2.024141411305352e-10,  9.894873185893756e-13,  2.016455670011144e-16, -2.759911151237253e-17,  1.368597037698780e-19,  9.813111181657571e-23,
 -4.736635373951545e-24,  2.259245669498964e-26,  6.443115463599415e-01, -3.907891302223518e-03,  1.062443596797003e-05,  1.594263716285600e-08, -2.649179288210843e-10,
  6.789507420305009e-13,  4.118072138095694e-15, -3.702858851133977e-17,  4.013820380327136e-20,  9.808475116528500e-22, -5.813744939250654e-24, -5.737257919657031e-27,
  7.524163440403151e-01, -4.278277937435592e-03,  8.824460981457446e-06,  3.579127517891948e-08, -2.853640186909083e-10,  2.775811301007347e-14,  7.786985665689900e-15,
 -2.794236508042777e-17, -1.466728400528882e-19,  1.460957860356585e-21, -4.121648781165964e-25, -4.998483034232489e-26,  8.658835699798434e-01, -4.565374109279760e-03,
  6.108722271433658e-06,  5.458206505591917e-08, -2.453592580595035e-10, -8.459557295714592e-13,  9.177702130037822e-15,  3.241851302428639e-18, -3.140695575484113e-19,
  7.292335681608928e-22,  9.323864025964914e-24, -5.294862312676159e-26,  9.835288324933915e-01, -4.746370280973814e-03,  2.586634228012997e-06,  6.880486986512130e-08,
 -1.379370710551342e-10, -1.678547062009266e-12,  6.562660972110228e-15,  4.542035085259514e-17, -2.992343671828227e-19, -1.180437037319960e-21,  1.322186924683137e-23,
  2.395594196732408e-26,  1.103953344720828e+00, -4.800646091387799e-03, -1.510115230235935e-06,  7.486739533471340e-08,  2.506121617421003e-11, -2.114543942107905e-12,
 -1.864862495910852e-16,  7.260979905272404e-17, -1.965894940397290e-20, -2.756497254939054e-21,  1.887684546403077e-24,  1.110577595744529e-25,  1.225520847567026e+00,
 -4.711900757448379e-03, -5.821120832312140e-06,  6.994426916175750e-08,  2.090302155386690e-10, -1.844440077597265e-12, -8.602490365185040e-15,  5.768388829090867e-17,
  3.784901715943309e-19, -1.929633950753280e-21, -1.729970383331200e-23,  6.523492153930570e-26,  1.346340347029681e+00, -4.470808226041053e-03, -9.872311384332383e-06,
  5.303397075919796e-08,  3.604395193182182e-10, -7.998858170705320e-13, -1.402278755601721e-14, -2.631839828641926e-18,  5.406594850101534e-19,  1.370493894092630e-21,
 -1.963282831534243e-23, -1.064054956925283e-25,  1.464260163338655e+00, -4.078061378621725e-03, -1.312290834313164e-05,  2.595618496948068e-08,  4.220151881010631e-10,
  6.911914276803326e-13, -1.214372095492499e-14, -7.100306376891111e-17,  2.175116793249241e-19,  3.797327083368203e-21,  5.245938504853485e-24, -1.489031285802186e-25,
  1.576880609970130e+00, -3.547453283943185e-03, -1.505168874366677e-05, -6.183630809393690e-09,  3.583094609519640e-10,  1.942625090904937e-12, -2.836964553768715e-15,
 -8.880841177235556e-17, -3.516881415065829e-19,  1.888244186635902e-21,  2.565351776733076e-23,  5.466464638271024e-26,  1.681594010374711e+00, -2.908352170770907e-03,
 -1.528002288933603e-05, -3.564656311381359e-08,  1.820837718441853e-10,  2.247652060459732e-12,  8.006647697493344e-15, -3.328320259423225e-17, -5.489253770038192e-19,
 -2.336486162304110e-21,  7.995098274354033e-24,  1.619102662844512e-25,  1.775660776868005e+00, -2.206625520864356e-03, -1.371066706670285e-05, -5.421579703746311e-08,
 -3.690199842406240e-11,  1.402125512370856e-12,  1.211616284737412e-14,  4.313058077719648e-17, -1.364434148787037e-19, -2.934092331370177e-21, -1.858142019101653e-23,
 -2.571712497094536e-26,  1.856327644151860e+00, -1.502909135212795e-03, -1.063762735183063e-05, -5.654813199163626e-08, -1.983105423362850e-10,  3.826182417635761e-16,
  6.701952213057206e-15,  6.103424176091284e-17,  3.076056445930838e-19,  4.313629360648082e-22, -8.816998031331221e-24, -1.043820921100127e-25,  1.920987723847940e+00,
 -8.673269211420508e-04, -6.765788409518412e-06, -4.334533011256063e-08, -2.302005329451902e-10, -9.329567937410061e-13, -1.731645062639888e-15,  1.498633908460951e-17,
  2.170278983003519e-19,  1.684052524244664e-21,  9.144588608479692e-24,  2.871203996465222e-26,  1.967371992046534e+00, -3.705441528124487e-04, -3.088968850270253e-06,
 -2.222387084886928e-08, -1.440651331500196e-10, -8.490132775039875e-13, -4.492922830915662e-15, -2.042539451878615e-17, -6.882727588252552e-20, -3.562547477223293e-23,
  2.111958218103460e-24,  2.508082291627594e-26,  1.993755690198254e+00, -7.228393263497332e-05, -6.250802857537740e-07, -4.779535422982392e-09, -3.403504392477434e-11,
 -2.307929600535386e-13, -1.506812471051760e-15, -9.525596101101395e-18, -5.845746084582259e-20, -3.484055625440969e-22, -2.013631223850291e-24, -1.124382330674785e-26,
  1.243250339004835e-03, -9.863208878137841e-06,  5.865467440046783e-08, -3.098683544246288e-10,  1.533312504465231e-12, -7.277047455643512e-15,  3.353364092588131e-17,
 -1.511888604924496e-19,  6.698137765571748e-22, -2.926529553047696e-24,  1.262873338479177e-26, -5.395918578482470e-29,  1.118303528488011e-02, -8.842482374306954e-05,
  5.220567714190316e-07, -2.723475681962594e-09,  1.321611493333694e-11, -6.098262012774530e-14,  2.703266921002359e-16, -1.157249786417977e-18,  4.789989796088581e-21,
 -1.916113356749166e-23,  7.372603588881124e-26, -2.711674268804279e-28,  3.102915753814626e-02, -2.437081787323951e-04,  1.417855531077321e-06, -7.207033907756065e-09,
  3.355791718943039e-11, -1.455168806031116e-13,  5.887684390574002e-16, -2.203196242622463e-18,  7.422695387289571e-21, -2.102101000321100e-23,  3.797169715255953e-26,
  6.639815065700310e-29,  6.071333646614505e-02, -4.720102844210156e-04,  2.684616570599826e-06, -1.309658525266601e-08,  5.693682823322663e-11, -2.206553689619429e-13,
  7.367984215038949e-16, -1.884733530551993e-18,  1.619153974345753e-21,  2.134671362997544e-23, -1.978492731069151e-25,  1.160917369769782e-27,  1.001296349489837e-01,
 -7.677200927639376e-04,  4.231717028485500e-06, -1.945552091449327e-08,  7.597057775951932e-11, -2.392355330331506e-13,  4.688552053509676e-16,  7.726897425668522e-19,
 -1.459039879398186e-20,  9.670439487405964e-23, -4.581866304310171e-25,  1.599536340830444e-27,  1.491300914366444e-01, -1.123255231226404e-03,  5.941428888969140e-06,
 -2.514821401507377e-08,  8.273242613947507e-11, -1.610778570630863e-13, -3.311792656331272e-16,  5.451479055637359e-18, -3.355347518682021e-20,  1.373527415041998e-22,
 -3.185181907566331e-25, -6.107518484564376e-28,  2.075186466298124e-01, -1.528986297496367e-03,  7.672121992057002e-06, -2.894162784207952e-08,  7.027843452991889e-11,
  3.178623328623517e-14, -1.544269994882447e-15,  1.011699818984511e-17, -3.889460352948235e-20,  5.476805311957487e-23,  5.000812355772563e-25, -5.042044852325014e-27,
  2.750431487780811e-01, -1.973158163214287e-03,  9.262967992938315e-06, -2.963639129775303e-08,  3.436649370888868e-11,  3.217275070556314e-13, -2.771688548436560e-15,
  1.142788435823665e-17, -1.399841035864220e-20, -1.777975484962968e-22,  1.597769265441453e-24, -6.843180332163654e-27,  3.513851684131463e-01, -2.441822872287354e-03,
  1.054063177045071e-05, -2.622698620956615e-08, -2.483075740970140e-11,  6.480504618511434e-13, -3.394437708317738e-15,  6.166356579282593e-18,  4.384000012277357e-20,
 -4.440914231282491e-22,  1.774920910187900e-24,  2.049667723276193e-28,  4.361473074350671e-01, -2.918806040420178e-03,  1.132852705406688e-05, -1.808673164212990e-08,
 -1.013227041424520e-10,  9.101304378353950e-13, -2.763497420904778e-15, -6.558210475371721e-18,  1.108357293835308e-19, -4.880981053703195e-22, -1.493391346908202e-25,
  1.508333045600836e-26,  5.288376591637250e-01, -3.385738860894646e-03,  1.145925528091174e-05, -5.166190441800121e-09, -1.826360277267290e-10,  9.855504008059322e-13,
 -5.095346722676435e-16, -2.319768180512452e-17,  1.372241946302077e-19, -7.119908603163149e-23, -3.727243605568934e-24,  2.296308510125270e-26,  6.288510834409203e-01,
 -3.822201560417255e-03,  1.079078003896220e-05,  1.181760288759289e-08, -2.504336748241702e-10,  7.655190208225206e-13,  3.104239982752028e-15, -3.522438954413906e-17,
  7.122980244838796e-20,  7.462715472299038e-22, -5.844492963903593e-24,  3.945326019088512e-27,  7.354470343604826e-01, -4.206041780582019e-03,  9.226611801939691e-06,
  3.123977147441980e-08, -2.830058887018391e-10,  2.047751456735424e-13,  6.946749999964825e-15, -3.180168680071130e-17, -9.487740602830416e-20,  1.403561260380746e-21,
 -2.378018780594152e-24, -3.907468711579095e-26,  8.477238655207950e-01, -4.513952337731622e-03,  6.739633035031718e-06,  5.053294249913408e-08, -2.600741290168805e-10,
 -6.257105769911851e-13,  9.132203442349034e-15, -6.321066208005586e-18, -2.816882346854120e-19,  1.053181606264404e-21,  6.825559053517317e-24, -5.954163623071411e-26,
  9.645899104281688e-01, -4.722414586006136e-03,  3.397971720779366e-06,  6.633827937628274e-08, -1.698357055945444e-10, -1.506899566761121e-12,  7.694722597362723e-15,
  3.526857608930201e-17, -3.320289430722573e-19, -6.384413219467426e-22,  1.368319105322983e-23, -2.731500652758150e-27,  1.084732293821783e+00, -4.809129773866950e-03,
 -6.106951130878854e-07,  7.493049338375518e-08, -1.711049417334919e-11, -2.094784743311734e-12,  1.823021331487793e-15,  7.041695913550360e-17, -1.163786149450772e-19,
 -2.585893418136794e-21,  6.557521733325136e-24,  9.941872610397371e-26,  1.206585498851351e+00, -4.755058416574322e-03, -4.962974811188320e-06,  7.298299745647863e-08,
  1.702144272968640e-10, -2.030218250276463e-12, -6.829137455479517e-15,  6.855682962422679e-17,  2.973598066201798e-19, -2.553278379186103e-21, -1.362512414349423e-23,
  1.004962905218898e-25,  1.328303324381318e+00, -4.547144381577189e-03, -9.201888680885678e-06,  5.865474626951421e-08,  3.410806418131646e-10, -1.135322038978879e-12,
 -1.384797735730134e-14,  1.529851704365571e-17,  5.748215769934024e-19,  5.014500802337274e-22, -2.354769798544792e-23, -6.915766658266718e-26,  1.447740087266101e+00,
 -4.181683015920472e-03, -1.277051758348868e-05,  3.280252302595322e-08,  4.327680937652004e-10,  3.767990500203503e-13, -1.401359916027680e-14, -6.182841308963447e-17,
  3.563130555263039e-19,  3.865257202606723e-21, -2.096596305005054e-24, -1.827196399229747e-25,  1.562449641306870e+00, -3.668063223529970e-03, -1.509022681917060e-05,
 -1.444262821652402e-10,  3.962733941078444e-10,  1.843496603858807e-12, -5.469501912548940e-15, -9.877286206407057e-17, -2.647856526385566e-19,  2.948555261404379e-21,
  2.698419328619089e-23,  2.815482464961114e-27,  1.669713486694417e+00, -3.032250379587187e-03, -1.568878528801694e-05, -3.236351130387880e-08,  2.288723432534683e-10,
  2.426568377617139e-12,  6.816678279179083e-15, -5.211834027431204e-17, -6.254697664276145e-19, -1.863800136259001e-21,  1.588111013070096e-23,  1.949892652834394e-25,
  1.766610772482138e+00, -2.318921017122466e-03, -1.436382154377669e-05, -5.456568902788919e-08, -5.856771779137888e-12,  1.706809144028246e-12,  1.324578046563710e-14,
  3.692927989191060e-17, -2.556312262135748e-19, -3.689751772343215e-21, -1.891605002479498e-23,  1.353511655254170e-26,  1.850141431840004e+00, -1.590778344503476e-03,
 -1.133521255007479e-05, -5.971169888879889e-08, -1.965501959649384e-10,  1.828609614128538e-13,  8.550512850747617e-15,  7.104849075587489e-17,  3.155962936521883e-19,
 -2.236564536332311e-23, -1.410201553360128e-23, -1.362690946470327e-25,  1.917406779019536e+00, -9.235978508051565e-04, -7.308654262554959e-06, -4.717991226026669e-08,
 -2.492369717012707e-10, -9.686374903411664e-13, -1.205167726758263e-15,  2.297423395415420e-17,  2.845297783982964e-19,  2.073635635515334e-21,  1.028701132610707e-23,
  2.213150752676467e-26,  1.965838645847914e+00, -3.963631646794029e-04, -3.370065422213270e-06, -2.467081281143272e-08, -1.621713139423495e-10, -9.639557827763555e-13,
 -5.095731664291899e-15, -2.262974158265630e-17, -6.829505381769923e-20,  7.407100457836906e-23,  3.457605898407668e-24,  3.673448048856227e-26,  1.993456176389835e+00,
 -7.752361419046552e-05, -6.858610204458618e-07, -5.363082523606687e-09, -3.903528590754948e-11, -2.703806119048207e-13, -1.801720371160499e-15, -1.161348276169747e-17,
 -7.257729560395330e-20, -4.397567196427139e-22, -2.578004436254354e-24, -1.455331409429601e-26,  1.204713002845917e-03, -9.408438886933432e-06,  5.507878711209964e-08,
 -2.864573510342360e-10,  1.395488849555671e-12, -6.520711457908566e-15,  2.958526013183807e-17, -1.313474649123262e-19,  5.730073076091978e-22, -2.465810541813529e-24,
  1.047886794057491e-26, -4.411372003556816e-29,  1.083748686969738e-02, -8.437559207802289e-05,  4.906046742300938e-07, -2.521433269610878e-09,  1.205880317728029e-11,
 -5.486691243300105e-14,  2.399698399632318e-16, -1.014460328445966e-18,  4.150512849095895e-21, -1.643801602453969e-23,  6.273166793502155e-26, -2.297100218001135e-28,
  3.007647537791997e-02, -2.327023606576870e-04,  1.334499073884701e-06, -6.692642679965559e-09,  3.078402294032563e-11, -1.321005601756641e-13,  5.302926643749668e-16,
 -1.977480200499107e-18,  6.693837632882470e-21, -1.945937607108687e-23,  3.975623288240317e-26,  1.773523264003987e-29,  5.886727528241511e-02, -4.511468303736924e-04,
  2.532780914017925e-06, -1.221995790357756e-08,  5.269631098031811e-11, -2.035989645910949e-13,  6.848564591386673e-16, -1.822056831070454e-18,  2.256821494280275e-21,
  1.438112653571310e-23, -1.521544871677858e-25,  9.240283077301708e-28,  9.712501212911177e-02, -7.347799171758629e-04,  4.005388055870763e-06, -1.827765152164395e-08,
  7.129988534378152e-11, -2.277730495610990e-13,  4.844529495279779e-16,  3.580965461129325e-19, -1.142237496692912e-20,  7.974015289039909e-23, -3.911561772610801e-25,
  1.444561684417416e-27,  1.447302535529182e-01, -1.076908658562564e-03,  5.647485060085833e-06, -2.385064973886889e-08,  7.944314194593275e-11, -1.673113119769879e-13,
 -1.928442443712653e-16,  4.454381045835962e-18, -2.884314999905623e-20,  1.242296676061604e-22, -3.341216627514378e-25, -1.275873734696319e-28,  2.015232828626927e-01,
 -1.468979368262142e-03,  7.331583900710077e-06, -2.781400701224912e-08,  7.056576108646842e-11, -2.015628605797109e-15, -1.278097307613551e-15,  8.907365159891317e-18,
 -3.661315136986528e-20,  7.068427989674569e-23,  3.040692160928566e-25, -3.897190805079874e-27,  2.672964850599222e-01, -1.900467152286540e-03,  8.910831408216647e-06,
 -2.903855746789739e-08,  4.016147190008718e-11,  2.589906450714821e-13, -2.458856749746342e-15,  1.088927684653950e-17, -1.932017803514827e-20, -1.197824867145790e-22,
  1.306575822924430e-24, -6.352220734655338e-27,  3.417845255091974e-01, -2.358762510846409e-03,  1.022393772528632e-05, -2.652495522960203e-08, -1.266966954685912e-11,
  5.688000954163415e-13, -3.204445233801949e-15,  7.327119404551261e-18,  2.912672489633384e-20, -3.735727637118046e-22,  1.736155154630715e-24, -1.837050005948941e-27,
  4.246519280007937e-01, -2.829072187177481e-03,  1.110234815415096e-05, -1.956593307071585e-08, -8.379620643860207e-11,  8.419874764488437e-13, -2.900115565213723e-15,
 -3.292541538307266e-18,  9.330521756692757e-20, -4.820451553150922e-22,  4.218137653128346e-25,  1.094413620484953e-26,  5.154775910102443e-01, -3.294360980128561e-03,
  1.138037566592491e-05, -7.931555209229810e-09, -1.630973695684237e-10,  9.660200018348433e-13, -1.098172424423532e-15, -1.887433117453268e-17,  1.322185208281887e-19,
 -2.003649200008015e-22, -2.740657395770075e-24,  2.165287288582678e-26,  6.137357332163854e-01, -3.735375004883441e-03,  1.090906709125397e-05,  7.936864662571363e-09,
 -2.344567350841772e-10,  8.284661743834339e-13,  2.153587833473415e-15, -3.255982209921896e-17,  9.395066121210524e-20,  5.182649968897847e-22, -5.503465234390469e-24,
  1.113573959382324e-26,  7.187727590580014e-01, -4.130805986152456e-03,  9.574484148192140e-06,  2.675319150693396e-08, -2.773168696093903e-10,  3.605146544860498e-13,
  6.021244423671688e-15, -3.405082545789030e-17, -4.644398750635335e-20,  1.277547705537543e-21, -3.835412570709697e-24, -2.711724447231881e-26,  8.297796297766773e-01,
 -4.457681306458127e-03,  7.320686626558584e-06,  4.628347309991417e-08, -2.704160569857235e-10, -4.096433680454344e-13,  8.835062864821784e-15, -1.468092909342295e-17,
 -2.394963984204350e-19,  1.273262522624580e-21,  4.175551866398703e-24, -5.996099426810445e-26,  9.457595931882168e-01, -4.692094993861041e-03,  4.176765659240771e-06,
  6.339015199572666e-08, -1.980532557408672e-10, -1.311594073977938e-12,  8.530788100413800e-15,  2.438086512772873e-17, -3.452567835698430e-19, -1.008085313672254e-22,
  1.302523947458891e-23, -2.647664204953152e-26,  1.065491687577097e+00, -4.810426490478153e-03,  2.854551536830381e-07,  7.432459885401070e-08, -5.841149089760941e-11,
 -2.027876959445789e-12,  3.728972608813087e-15,  6.526222286032253e-17, -2.037455295984328e-19, -2.241764178140988e-21,  1.049341167627293e-23,  7.811466454163067e-26,
  1.187491465520823e+00, -4.791215873334935e-03, -4.072205219587662e-06,  7.537335906114307e-08,  1.281317398631031e-10, -2.170095670551329e-12, -4.790844671681487e-15,
  7.650562988747965e-17,  1.967742411172276e-19, -3.001566582753116e-21, -8.605613098145347e-24,  1.256582704686081e-25,  1.309972102949890e+00, -4.617853131402834e-03,
 -8.466095302137458e-06,  6.391251043602794e-08,  3.150961724511777e-10, -1.460444590588085e-12, -1.316071152061084e-14,  3.379471736347360e-17,  5.753109677811365e-19,
 -4.874486477800889e-22, -2.553526935931416e-23, -1.955125377660217e-26,  1.430811686697889e+00, -4.282154471372703e-03, -1.233515362514871e-05,  3.976826285248352e-08,
  4.368077851236892e-10,  2.111434933003482e-14, -1.556445626734807e-14, -4.823233548158075e-17,  4.919533194454829e-19,  3.614070466517642e-21, -1.058963171825929e-23,
 -2.000415022413278e-25,  1.547536089606456e+00, -3.788681433138237e-03, -1.505272669199831e-05,  6.482819035259745e-09,  4.316021238511058e-10,  1.678188925472052e-12,
 -8.336327307986905e-15, -1.053401957355728e-16, -1.393510083217382e-19,  4.011312890825776e-21,  2.565435516987955e-23, -6.565081481056653e-26,  1.657331097803968e+00,
 -3.159248113652915e-03, -1.605354680522830e-05, -2.830495152768460e-08,  2.789095746582709e-10,  2.570338005015078e-12,  5.068040896212745e-15, -7.306709796651317e-17,
 -6.789989663969486e-19, -1.050009841336803e-21,  2.494855225427220e-23,  2.140720623122744e-25,  1.757101121591427e+00, -2.436449627347529e-03, -1.501798870095306e-05,
 -5.436870210193817e-08,  3.153683708009591e-11,  2.036063839436770e-12,  1.414427866807584e-14,  2.647983661580078e-17, -4.017966562286111e-19, -4.418633993496404e-21,
 -1.709879399405411e-23,  7.249318778306391e-26,  1.843592341958696e+00, -1.684379314274166e-03, -1.207046305251635e-05, -6.281539753870379e-08, -1.906738361110917e-10,
  4.130818215745566e-13,  1.068028973404434e-14,  8.101351379676003e-17,  3.031044428031263e-19, -7.160434654397743e-22, -2.081946669363833e-23, -1.688016031780886e-25,
  1.913591765815192e+00, -9.844009945253675e-04, -7.899383706183390e-06, -5.132401920798670e-08, -2.688412357195190e-10, -9.887414533148939e-13, -4.226210856539012e-16,
  3.335471536833399e-17,  3.667898508503112e-19,  2.500924870262018e-21,  1.096879962251384e-23,  7.142598495454551e-27,  1.964197332899408e+00, -4.245535071407558e-04,
 -3.682341956527499e-06, -2.742665143041278e-08, -1.827259915522604e-10, -1.094100389623682e-12, -5.759349871485643e-15, -2.474240776851473e-17, -6.271006927805804e-20,
  2.491020228854180e-22,  5.412039981279674e-24,  5.297236976017465e-26,  1.993134685011161e+00, -8.327897472438702e-05, -7.541517737264911e-07, -6.033372915917077e-09,
 -4.490307150744278e-11, -3.178018424225466e-13, -2.161941967693072e-15, -1.421048029225466e-17, -9.042968442821407e-20, -5.568698956182422e-22, -3.308979978632599e-24,
 -1.885886087834582e-26,  1.167939260241852e-03, -8.981188636814462e-06,  5.177108379871346e-08, -2.651354782684673e-10,  1.271887557313961e-12, -5.852805190222428e-15,
  2.615144892785809e-17, -1.143542879584331e-19,  4.913377602573846e-22, -2.083015481722058e-24,  8.718656267260203e-27, -3.617561852184632e-29,  1.050764707037538e-02,
 -8.056858489821626e-05,  4.614698958170953e-07, -2.336967598575328e-09,  1.101683220016222e-11, -4.943401664690175e-14,  2.133387594432842e-16, -8.906470435534324e-19,
  3.601573944124125e-21, -1.412013783050893e-23,  5.341767919712442e-26, -1.946238075905798e-28,  2.916652084151038e-02, -2.223394380529434e-04,  1.257057631106104e-06,
 -6.220561299233064e-09,  2.826491943884627e-11, -1.200144009593325e-13,  4.778189376382010e-16, -1.774178210857965e-18,  6.022013659622591e-21, -1.786419289222470e-23,
  3.976349632715983e-26, -1.520662690895838e-29,  5.710230357331957e-02, -4.314571113981576e-04,  2.391068735516819e-06, -1.140851690283638e-08,  4.878460887246005e-11,
 -1.877660217209650e-13,  6.349198226558577e-16, -1.742653752324752e-18,  2.674240342030329e-21,  9.048396956209952e-24, -1.158856126605567e-25,  7.311951889614191e-28,
  9.424861649567266e-02, -7.035950885298502e-04,  3.792752750318600e-06, -1.717266261850856e-08,  6.686130263444357e-11, -2.160646141012179e-13,  4.897731592718172e-16,
  3.561260069485480e-20, -8.818481348097304e-21,  6.531699966377784e-23, -3.311990622752806e-25,  1.280309207552266e-27,  1.405111961993136e-01, -1.032852256478612e-03,
  5.368792676270181e-06, -2.260654016524226e-08,  7.606021380255614e-11, -1.705431586344403e-13, -8.038939644575693e-17,  3.600372700630590e-18, -2.461181552752011e-20,
  1.108589232157749e-22, -3.320319626844781e-25,  2.002749253649219e-28,  1.957625839475976e-01, -1.411642588986399e-03,  7.004583626661209e-06, -2.668686152724865e-08,
  7.023823309551709e-11, -2.982705525274008e-14, -1.044696349387892e-15,  7.778488494250827e-18, -3.388818595932116e-20,  7.971451308418498e-23,  1.544700729234119e-25,
 -2.932174763073033e-27,  2.598349987383428e-01, -1.830563054515164e-03,  8.566385047640881e-06, -2.835763940205686e-08,  4.477547936831243e-11,  2.035633811819292e-13,
 -2.163191898722640e-15,  1.021158762911574e-17, -2.275726738125000e-20, -7.292019488881873e-23,  1.041464437320292e-24, -5.677563089245897e-27,  3.325110388137741e-01,
 -2.278246815263705e-03,  9.904784041557530e-06, -2.664076902909688e-08, -2.045623268553769e-12,  4.944486924075457e-13, -2.988164385668137e-15,  8.057214610811859e-18,
  1.690459186118684e-20, -3.061801661648705e-22,  1.623845868925569e-24, -3.161404266314642e-27,  4.135117592901252e-01, -2.741214104180309e-03,  1.086005591165181e-05,
 -2.077576160716164e-08, -6.765827598965501e-11,  7.715999043371900e-13, -2.953086479861446e-15, -5.803017778908288e-19,  7.636112743119784e-20, -4.566567059415881e-22,
  8.210116931372878e-25,  7.294095805387498e-27,  5.024815695959369e-01, -3.203741593746501e-03,  1.127017212000327e-05, -1.038815311331809e-08, -1.440808978879178e-10,
  9.337928146225578e-13, -1.568644410405606e-15, -1.477808066883388e-17,  1.232559146779779e-19, -2.915870776245130e-22, -1.838150206122198e-24,  1.923070679738794e-26,
  5.989692931220231e-01, -3.647783994881129e-03,  1.098235667328629e-05,  4.320616116276347e-09, -2.174425727371498e-10,  8.695676538624414e-13,  1.286510680734735e-15,
 -2.929631203171340e-17,  1.087782853759955e-19,  3.094832393977471e-22, -4.901455714763934e-24,  1.583087322082751e-26,  7.024046543973946e-01, -4.053000792588654e-03,
  9.869162508363621e-06,  2.238132898872155e-08, -2.687393967720468e-10,  4.934568856821627e-13,  5.053704907762039e-15, -3.483289871895633e-17, -3.469416341187300e-21,
  1.103761868711955e-21, -4.768790118126113e-24, -1.545044234650038e-26,  8.120694485135028e-01, -4.396968308466872e-03,  7.849894898786858e-06,  4.190263938082701e-08,
 -2.765260977978396e-10, -2.033572909289787e-13,  8.323793566270953e-15, -2.158428258150715e-17, -1.912792637137173e-19,  1.388586820631693e-21,  1.625446193442501e-24,
 -5.520823115080523e-26,  9.270627805263245e-01, -4.655693932065968e-03,  4.917605332700151e-06,  6.002277863638930e-08, -2.221889057711752e-10, -1.099911458788959e-12,
  9.058933636814875e-15,  1.337249774076248e-17, -3.398428771794369e-19,  3.910094160865422e-22,  1.143048205979057e-23, -4.501549714535229e-26,  1.046260171116767e+00,
 -4.804594204182853e-03,  1.170421852860438e-06,  7.307102438261859e-08, -9.793017491423187e-11, -1.917261769574973e-12,  5.453518656911143e-15,  5.753837923071092e-17,
 -2.761362785002744e-19, -1.761141049878426e-21,  1.333416184901052e-23,  5.022391846306696e-26,  1.168267219926312e+00, -4.820144077493469e-03, -3.156874745450215e-06,
  7.707074416532635e-08,  8.375678435580689e-11, -2.258760461437309e-12, -2.577186226545459e-15,  8.101817059336992e-17,  8.389690065198654e-20, -3.230735581045707e-21,
 -2.768211630865450e-24,  1.372538157622616e-25,  1.291370208182113e+00, -4.682430716785073e-03, -7.669914460051813e-06,  6.870357536900903e-08,  2.828160131481828e-10,
 -1.762889603830438e-12, -1.196076864084091e-14,  5.172605318426406e-17,  5.393180880855396e-19, -1.509749674776898e-21, -2.516903498786582e-23,  3.672479695622196e-26,
  1.413488896350153e+00, -4.378808113952096e-03, -1.181605390661975e-05,  4.673984399957543e-08,  4.333949034188767e-10, -3.667428944545672e-13, -1.667569007556642e-14,
 -3.050714135069142e-17,  6.123087420177071e-19,  3.014206726857002e-21, -1.936534965192223e-23, -1.947400668613311e-25,  1.532141181944312e+00, -3.908672200370512e-03,
 -1.493242942570666e-05,  1.364508254692449e-08,  4.629242595365081e-10,  1.442359219372942e-12, -1.132520016778175e-14, -1.072978653551252e-16,  2.262438115874647e-20,
  4.956881795273245e-21,  2.104557071027501e-23, -1.449221145259270e-25,  1.644435209726051e+00, -3.288955316147741e-03, -1.636471508169617e-05, -2.342527567482145e-08,
  3.313541376009639e-10,  2.664937597761403e-12,  2.713768273882268e-15, -9.518876572520503e-17, -6.965566989927798e-19,  1.369886986174965e-22,  3.436782006531630e-23,
  2.093063959130306e-25,  1.747110919584219e+00, -2.559191440850297e-03, -1.566598142057948e-05, -5.351967433349507e-08,  7.570464790429554e-11,  2.382819333024338e-12,
  1.468089685113454e-14,  1.095273411954351e-17, -5.722123339217324e-19, -5.016803171516615e-21, -1.222880043804477e-23,  1.522031318162666e-25,  1.836656851050352e+00,
 -1.784009298783924e-03, -1.284223260969436e-05, -6.578536812416987e-08, -1.796596502676833e-10,  6.976954070621892e-13,  1.307935100875079e-14,  9.012462878634369e-17,
  2.604665303999211e-19, -1.706087652667336e-21, -2.888411486342740e-23, -1.963051382256353e-25,  1.909523765853391e+00, -1.050134246703202e-03, -8.541734122368639e-06,
 -5.578388621596427e-08, -2.886346267088680e-10, -9.862646367390303e-13,  6.897731260900360e-16,  4.661741298106765e-17,  4.647337347979866e-19,  2.938870718887943e-21,
  1.072605376847088e-23, -2.074567040185422e-26,  1.962438044551765e+00, -4.553801365427203e-04, -4.029750555789930e-06, -3.053307305548917e-08, -2.060474900356288e-10,
 -1.240855095920679e-12, -6.478557248037582e-15, -2.655895328805125e-17, -4.922961699156257e-20,  5.182662245968763e-22,  8.208348793065590e-24,  7.526700265706434e-26,
  1.992789026243967e+00, -8.961450652077660e-05, -8.310822091825469e-07, -6.805630940438206e-09, -5.181197581336860e-11, -3.748096436286241e-13, -2.603553662537176e-15,
 -1.745224593446550e-17, -1.130732950145957e-19, -7.073655575835992e-22, -4.256462551473222e-24, -2.444696166189830e-26,  1.132823169687475e-03, -8.579409195952896e-06,
  4.870780397776238e-08, -2.456886822451643e-10,  1.160857342339238e-12, -5.261883737215324e-15,  2.315883734110804e-17, -9.976698097853415e-20,  4.222613124849285e-22,
 -1.764115616298735e-24,  7.273050931174246e-27, -2.975699987703119e-29,  1.019258277320242e-02, -7.698607697151640e-05,  4.344521526010228e-07, -2.168337782823428e-09,
  1.007739854745664e-11, -4.460057588857805e-14,  1.899405749776272e-16, -7.831336910577509e-19,  3.129729354245812e-21, -1.214560921923605e-23,  4.552453751634315e-26,
 -1.649836532908364e-28,  2.829681386695667e-02, -2.125740543444676e-04,  1.185047091360777e-06, -5.786918322381489e-09,  2.597539418610578e-11, -1.091216780335165e-13,
  4.307453076829039e-16, -1.591458319332307e-18,  5.407305721813989e-21, -1.629408103602351e-23,  3.858553675364826e-26, -3.675336529722821e-29,  5.541388354389358e-02,
 -4.128631810187039e-04,  2.258728566558233e-06, -1.065719420143940e-08,  4.517776799857883e-11, -1.731035370809838e-13,  5.873665187963458e-16, -1.652700835662569e-18,
  2.923853681082375e-21,  5.008048516173765e-24, -8.726783299393093e-26,  5.751169952994675e-28,  9.149364031017232e-02, -6.740594923280814e-04,  3.592958949710187e-06,
 -1.613681365812830e-08,  6.265748077584269e-11, -2.043278961074205e-13,  4.871555228360534e-16, -2.114057707093741e-19, -6.692395830033265e-21,  5.314750483975418e-23,
 -2.784589738295729e-25,  1.117948427133196e-27,  1.364639986238626e-01, -9.909666003610619e-04,  5.104703166662554e-06, -2.141693575682391e-08,  7.263777819065118e-11,
 -1.713481787715870e-13,  9.976760402920330e-18,  2.874107586827615e-18, -2.085718939160802e-20,  9.782313428986411e-23, -3.182312589093749e-25,  4.103068312377593e-28,
  1.902260856291993e-01, -1.356867838355999e-03,  6.691060257159294e-06, -2.556911252969047e-08,  6.940798456422912e-11, -5.240604689695679e-14, -8.416420498758568e-16,
  6.740937174120635e-18, -3.093608269274304e-20,  8.355829110992778e-23,  4.348766502856117e-26, -2.139861258649134e-27,  2.526476710796705e-01, -1.763380670328641e-03,
  8.230517297342126e-06, -2.761138668792937e-08,  4.835030624466470e-11,  1.549934287535621e-13, -1.887802788891977e-15,  9.448917560348723e-18, -2.469075545588346e-20,
 -3.603866855049919e-23,  8.081184353088206e-25, -4.922654888204401e-27,  3.235545035728733e-01, -2.200287129623044e-03,  9.585212359460992e-06, -2.659820609862711e-08,
  7.144739193311710e-12,  4.254913546406563e-13, -2.756558446284717e-15,  8.434049622104268e-18,  7.015337342495221e-21, -2.442660709453915e-22,  1.466408669479893e-24,
 -3.911928310888871e-27,  4.027190603440909e-01, -2.655348148689922e-03,  1.060474835641455e-05, -2.173868961199023e-08, -5.293497133334599e-11,  7.007920201154884e-13,
 -2.937548029024144e-15,  1.607128698635636e-18,  6.058129477042040e-20, -4.183404130378605e-22,  1.072590081015651e-24,  4.244642191182953e-27,  4.898460830019364e-01,
 -3.114116632730968e-03,  1.113229182836476e-05, -1.254621893916607e-08, -1.258127724120573e-10,  8.916154404029764e-13, -1.928881924354519e-15, -1.101443205318239e-17,
  1.116314286786185e-19, -3.490537576878222e-22, -1.057328853668559e-24,  1.619660138919435e-26,  5.845541214728377e-01, -3.559775565014390e-03,  1.101390818381282e-05,
  9.820716816494545e-10, -1.998068294133972e-10,  8.910026682252570e-13,  5.163599289147023e-16, -2.567356623527853e-17,  1.165667050813075e-19,  1.282265731015228e-22,
 -4.143637716388374e-24,  1.827290461307538e-26,  6.863521566530628e-01, -3.973045494622419e-03,  1.011228559691518e-05,  1.816671039541842e-08, -2.577362848179383e-10,
  6.030647740406110e-13,  4.082533775695946e-15, -3.434610582497268e-17,  3.269775101911398e-20,  9.025882627964365e-22, -5.214226752694523e-24, -5.071730217363161e-27,
  7.946102516925893e-01, -4.332233277337435e-03,  8.326080419752100e-06,  3.745632154511552e-08, -2.786478636710993e-10, -1.148370676324821e-14,  7.641318163923896e-15,
 -2.689746379000862e-17, -1.406848557182468e-19,  1.407306437600469e-21, -6.272909961368848e-25, -4.669684349973981e-26,  9.085231607871393e-01, -4.613534025987406e-03,
  5.615861159803506e-06,  5.630368855421952e-08, -2.419889466725384e-10, -8.792167033096377e-13,  9.283835555865084e-15,  2.806865155504831e-18, -3.180515623634289e-19,
  8.045785352331989e-22,  9.160311829012271e-24, -5.704697399317765e-26,  1.027066033061580e+00, -4.791752922588822e-03,  2.036631943435230e-06,  7.120502017690569e-08,
 -1.348414640947301e-10, -1.768097740250782e-12,  6.932109251158866e-15,  4.779432874546248e-17, -3.294856387086543e-19, -1.192544131625624e-21,  1.487159190828662e-23,
  1.951778279452889e-26,  1.148942018610203e+00, -4.841680349195003e-03, -2.225484714538087e-06,  7.804686575985887e-08,  3.814790963295376e-11, -2.293195392446465e-12,
 -2.886601671090520e-16,  8.183243597415819e-17, -3.294452602447836e-20, -3.220595232823221e-21,  3.250224094451322e-24,  1.338338908830791e-25,  1.272523093099361e+00,
 -4.740418113231190e-03, -6.819533819366988e-06,  7.293149920775028e-08,  2.448147919588575e-10, -2.030674993497622e-12, -1.028035747764296e-14,  6.792447462541088e-17,
  4.673871091960853e-19, -2.467516177548928e-21, -2.231359252728186e-23,  9.230020188381459e-26,  1.395788324769149e+00, -4.470975849280800e-03, -1.121388305129091e-05,
  5.359348912601110e-08,  4.220005372314557e-10, -7.749012357070236e-13, -1.724042385957890e-14, -9.342940007979567e-18,  7.048750395266921e-19,  2.075508146293059e-21,
 -2.734162950353638e-23, -1.634526110843775e-25,  1.516268791824666e+00, -4.027348665034243e-03, -1.472334636955914e-05,  2.126686227580026e-08,  4.888111869058028e-10,
  1.134754501426393e-12, -1.429149898914543e-14, -1.035701590416173e-16,  2.144697863219552e-19,  5.647231857083184e-21,  1.288664299006832e-23, -2.250681381195331e-25,
  1.631015905302982e+00, -3.420903252694632e-03, -1.661224065562724e-05, -1.769463206100795e-08,  3.850753438667761e-10,  2.695580342562689e-12, -2.608394441864593e-16,
 -1.171168021250261e-16, -6.647339187050881e-19,  1.687342087499320e-21,  4.287165159127425e-23,  1.709922363752626e-25,  1.736619464625711e+00, -2.687063898297811e-03,
 -1.629931500295080e-05, -5.190794010759281e-08,  1.268978777935969e-10,  2.736601956391758e-12,  1.470348212434012e-14, -1.032741520096657e-17, -7.597585210673961e-19,
 -5.344387974054243e-21, -3.438897776159501e-24,  2.497595050163964e-25,  1.829310270999215e+00, -1.889952549125335e-03, -1.364838624410026e-05, -6.853036166665353e-08,
 -1.623576988535383e-10,  1.042758405088513e-12,  1.570860691554107e-14,  9.723662680912014e-17,  1.761182660761817e-19, -3.039540057477496e-21, -3.788689937035442e-23,
 -2.096034568317264e-25,  1.905182208743295e+00, -1.121225745786914e-03, -9.239496413999541e-06, -6.055846780894765e-08, -3.080795352146898e-10, -9.522654915437871e-13,
  2.219743200525534e-15,  6.326200400286255e-17,  5.779279919707005e-19,  3.337514468780352e-21,  8.867210221979988e-24, -6.739314764919767e-26,  1.960549645803555e+00,
 -4.891417156665265e-04, -4.416775019320356e-06, -3.403707354962185e-08, -2.324805194530700e-10, -1.405422618125411e-12, -7.240966298596772e-15, -2.776545285523108e-17,
 -2.379008718275504e-20,  9.210591348962642e-22,  1.215006489563331e-23,  1.053328719901137e-25,  1.992416732998841e+00, -9.660451996058773e-05, -9.179825742790806e-07,
 -7.698160945185066e-09, -5.997482067400354e-11, -4.435925180580320e-13, -3.146948680426291e-15, -2.151311471006176e-17, -1.418802693985545e-19, -9.011309842589662e-22,
 -5.484350244622883e-24, -3.166742017149056e-26,  1.099266620893392e-03, -8.201231874149426e-06,  4.586760454473688e-08, -2.279275900851202e-10,  1.060959166359738e-12,
 -4.738123185443060e-15,  2.054537350723074e-17, -8.721706464212514e-20,  3.636890153012118e-22, -1.497768925008690e-24,  6.082153614605165e-27, -2.455368472715964e-29,
  9.891428688410846e-03, -7.361186513178232e-05,  4.093708755048188e-07, -2.013995072574985e-09,  9.229253439078740e-12, -4.029420969731448e-14,  1.693516440662169e-16,
 -6.896405071663020e-19,  2.723586001755672e-21, -1.046214372590132e-23,  3.883072090226427e-26, -1.399864266555783e-28,  2.746504835762647e-02, -2.033645466753272e-04,
  1.118027467929617e-06, -5.388224597750835e-09,  2.389282886205181e-11, -9.929949926683138e-14,  3.885208681957590e-16, -1.427515485678924e-18,  4.848069284895995e-21,
 -1.478744468919377e-23,  3.664900023558215e-26, -5.014829513788457e-29,  5.379777753766187e-02, -3.952928676735527e-04,  2.135067492042568e-06, -9.961296095045945e-09,
  4.185297215996650e-11, -1.595513317732413e-13,  5.424233571419600e-16, -1.556879467470888e-18,  3.047050244275276e-21,  1.984422864915069e-24, -6.482877564426535e-26,
  4.493542805215716e-28,  8.885368694240159e-02, -6.460736514141232e-04,  3.405199498801379e-06, -1.516635360434886e-08,  5.868724287310178e-11, -1.927297022288274e-13,
  4.785108194802705e-16, -3.970057319465115e-19, -4.968141823895267e-21,  4.294691272566855e-23, -2.326905541150556e-25,  9.642397095815322e-28,  1.325802073357582e-01,
 -9.511374907026566e-04,  4.854560188214919e-06, -2.028210795924490e-08,  6.921935122596408e-11, -1.702152888919882e-13,  8.161987277125270e-17,  2.260604814171003e-18,
 -1.755994398276000e-20,  8.549648119548573e-23, -2.972115166842101e-25,  5.328664589048130e-28,  1.849037545263789e-01, -1.304547881205377e-03,  6.390856100812480e-06,
 -2.446800504857622e-08,  6.817259167074867e-11, -7.044957892844036e-14, -6.663015702076392e-16,  5.799275707894540e-18, -2.791754456138196e-20,  8.361242615083802e-23,
 -3.615768558900450e-26, -1.504780082582828e-27,  2.457237570672396e-01, -1.698848507191057e-03,  7.903916849959693e-06, -2.681535620008160e-08,  5.101806656676902e-11,
  1.127707303653230e-13, -1.634447505378467e-15,  8.643883657171253e-18, -2.545644412428948e-20, -7.820024146303786e-24,  6.083747143976321e-25, -4.159885922258486e-27,
  3.149047005558033e-01, -2.124879577477603e-03,  9.266989182097165e-06, -2.641932555861411e-08,  1.501221875330593e-11,  3.621854310529964e-13, -2.518505431261470e-15,
  8.528819438823807e-18, -7.650504510253847e-22, -1.891720504430048e-22,  1.286014947461387e-24, -4.226575373524905e-27,  3.922656726287430e-01, -2.571566976843864e-03,
  1.033925248926227e-05, -2.247733392693379e-08, -3.961942329334212e-11,  6.310363131756506e-13, -2.867611140948085e-15,  3.313365513942180e-18,  4.633133189768859e-20,
 -3.724596208456781e-22,  1.203807701094061e-24,  1.821868551108039e-27,  4.775667330811344e-01, -3.025693399264859e-03,  1.097023922418180e-05, -1.441917783571828e-08,
 -1.084663400553112e-10,  8.420132150072647e-13, -2.189214621394545e-15, -7.650106725216104e-18,  9.846731736386161e-20, -3.780449582048042e-22, -4.158931758778733e-25,
  1.295250256640573e-26,  5.704912414449836e-01, -3.471670150044591e-03,  1.100710118176591e-05, -2.071840613981246e-09, -1.819188848542297e-10,  8.951936544471256e-13,
 -1.498029363016212e-16, -2.189996961831639e-17,  1.183960747546737e-19, -2.114822411266834e-23, -3.320939933658238e-24,  1.885167220092909e-26,  6.706230541935235e-01,
 -3.891344362385307e-03,  1.030595781821153e-05,  1.414441934878629e-08, -2.447723450050535e-10,  6.896521048869709e-13,  3.140087489355567e-15, -3.282041611875695e-17,
  6.140725013453122e-20,  6.922006840199965e-22, -5.243448286022155e-24,  3.395956987864297e-27,  7.774172756065563e-01, -4.263902476788536e-03,  8.748830060676807e-06,
  3.300581799297829e-08, -2.771070563052858e-10,  1.624082081928508e-13,  6.832721782632000e-15, -3.059745231826320e-17, -9.094112667776837e-20,  1.344167662921362e-21,
 -2.451436170404650e-24, -3.598202754432848e-26,  8.901630629555112e-01, -4.565971638358713e-03,  6.267733439469795e-06,  5.230330325328095e-08, -2.573446156026885e-10,
 -6.565824499633565e-13,  9.224770152485680e-15, -6.841670179984164e-18, -2.831155236009425e-19,  1.118766885329679e-21,  6.511111557774082e-24, -6.227317172237602e-26,
  1.007936963818092e+00, -4.772081329560566e-03,  2.877010932325034e-06,  6.877413368294399e-08, -1.684376258503455e-10, -1.586895176307438e-12,  8.117112454706897e-15,
  3.667983332338459e-17, -3.615843889936831e-19, -5.894430889665348e-22,  1.506668860700341e-23, -1.019234805033107e-26,  1.129545631074641e+00, -4.855731085371652e-03,
 -1.286772733860812e-06,  7.829072017895506e-08, -7.600746790958933e-12, -2.272852617127513e-12,  1.970703510830861e-15,  7.895952410564519e-17, -1.451633856329220e-19,
 -2.977042207472618e-21,  8.798715098133480e-24,  1.162083452538073e-25,  1.253457940733018e+00, -4.791410252591877e-03, -5.922235440936561e-06,  7.651089823135832e-08,
  2.018964234810451e-10, -2.252978902518656e-12, -8.183614665496588e-15,  8.129615218934469e-17,  3.636049878483821e-19, -3.264111707818399e-21, -1.717259401494792e-23,
  1.393644031145140e-25,  1.377729232659380e+00, -4.558000966230202e-03, -1.053083351943496e-05,  6.019898973026846e-08,  4.023570581174094e-10, -1.189200647575274e-12,
 -1.717659169132217e-14,  1.418426918787702e-17,  7.583069802437644e-19,  8.529410593382712e-22, -3.337404728598963e-23, -1.068779871807901e-25,  1.499925629723282e+00,
 -4.143980071039391e-03, -1.442053223279344e-05,  2.924979627315068e-08,  5.078462365460417e-10,  7.579253775023980e-13, -1.706422749339022e-14, -9.337550674625048e-17,
  4.244653564859136e-19,  5.943296824133154e-21,  1.421239833400208e-24, -2.928445121086104e-25,  1.617065304910814e+00, -3.554541690420942e-03, -1.678583417484436e-05,
 -1.110363119811748e-08,  4.386465881839309e-10,  2.647633576919314e-12, -3.826339469919792e-15, -1.370718395932184e-16, -5.714867468637355e-19,  3.532541561550121e-21,
  4.881373572920211e-23,  9.207533330606257e-26,  1.725606529358032e+00, -2.819911199717738e-03, -1.690816021577410e-05, -4.942069443460875e-08,  1.851203756514797e-10,
  3.083090070634461e-12,  1.404496319437306e-14, -3.772125071072452e-17, -9.517009939297277e-19, -5.231001211499222e-21,  9.885974997323885e-24,  3.562809610904559e-25,
  1.821526818232948e+00, -2.002471535018630e-03, -1.448557979562616e-05, -7.093982373088770e-08, -1.375091096950555e-10,  1.452961310917608e-12,  1.849149388473734e-14,
  1.008111632209311e-16,  3.720436496869796e-20, -4.737825604038802e-21, -4.692616042437701e-23, -1.954307198486923e-25,  1.900544751190611e+00, -1.198133746677471e-03,
 -9.996391042888282e-06, -6.563656700939602e-08, -3.264373486316658e-10, -8.755325310410851e-13,  4.268502735976848e-15,  8.373965310318853e-17,  7.035771167535651e-19,
  3.613699450803117e-21,  4.415207053241412e-24, -1.398484411560059e-25,  1.958519731555123e+00, -5.261751289577308e-04, -4.848496921587337e-06, -3.799133714747212e-08,
 -2.623900773801233e-10, -1.588586798636357e-12, -8.023347798220270e-15, -2.789270274365204e-17,  1.933108158349693e-20,  1.510665758715739e-21,  1.761866171429175e-23,
  1.449536191028076e-25,  1.992015018183417e+00, -1.043349074086546e-04, -1.016424734866695e-06, -8.733050934248779e-09, -6.965351485941917e-11, -5.268922911647598e-13,
 -3.818073552985016e-15, -2.661754974824149e-17, -1.786285727613862e-19, -1.150935195571241e-21, -7.073255750230040e-24, -4.092785576940516e-26,  1.067178650700131e-03,
 -7.844950013137505e-06,  4.323128295294762e-08, -2.116843592342576e-10,  9.709363751407797e-13, -4.273072249416914e-15,  1.825844536566773e-17, -7.639681046275936e-20,
  3.139001433295755e-22, -1.274782038892891e-24,  5.097954616628404e-27, -2.032684332671715e-29,  9.603381563318421e-03, -7.043111937863426e-05,  3.860630466051027e-07,
 -1.872559649103416e-09,  8.462498994711740e-12, -3.645197854934352e-14,  1.512073246681865e-16, -6.082238326967534e-19,  2.373481823502088e-21, -9.025643936799449e-24,
  3.314744482418670e-26, -1.189462309871228e-28,  2.666907808525822e-02, -1.946726105730326e-04,  1.055598551383160e-06, -5.021333905381007e-09,  2.199693482982919e-11,
 -9.043759489886589e-14,  3.506443313386150e-16, -1.280616385341814e-18,  4.341552417068437e-21, -1.336822062701044e-23,  3.425649396818801e-26, -5.782612629997519e-29,
  5.225002584583754e-02, -3.786793239367373e-04,  2.019446771527811e-06, -9.316484056099072e-09,  3.878865328878711e-11, -1.470452155305834e-13,  5.002031966499140e-16,
 -1.458694546047711e-18,  3.076289218669030e-21, -2.446546951227227e-25, -4.736037886397348e-26,  3.483248435392789e-28,  8.632274504060522e-02, -6.195443663818783e-04,
  3.228712039424963e-06, -1.425757457764844e-08,  5.494650400636121e-11, -1.813954349191697e-13,  4.653890208608516e-16, -5.329648006950392e-19, -3.579754841244931e-21,
  3.444523263319879e-23, -1.934235791329279e-25,  8.228254205837296e-28,  1.288518151358695e-01, -9.132559806488735e-04,  4.617708009224050e-06, -1.920170593933470e-08,
  6.583944488239284e-11, -1.675575824019498e-13,  1.374965734773759e-16,  1.745685321022138e-18, -1.469021130911019e-20,  7.409823568819900e-23, -2.722729055982096e-25,
  5.919014737196100e-28,  1.797859831610957e-01, -1.254577066157698e-03,  6.103735444406172e-06, -2.338933094332270e-08,  6.661633050579849e-11, -8.459044154251452e-14,
 -5.159790931824173e-16,  4.953675894544174e-18, -2.494805325191453e-20,  8.099757254476603e-23, -9.096597419806248e-26, -1.007564074747241e-27,  2.390528075409810e-01,
 -1.636890274608595e-03,  7.587098055578847e-06, -2.598307450577527e-08,  5.290034185073101e-11,  7.635618381095641e-14, -1.403834096323235e-15,  7.829124802322744e-18,
 -2.534206492992878e-20,  1.307116688760080e-23,  4.414547921557981e-25, -3.436768297976854e-27,  3.065514526681891e-01, -2.052007178736426e-03,  8.951627074174527e-06,
 -2.612438345325921e-08,  2.167078969690669e-11,  3.045982709043167e-13, -2.280996361413212e-15,  8.404937457247464e-18, -6.694343974234483e-21, -1.414702298478550e-22,
  1.099076895479881e-24, -4.228108560209511e-27,  3.821431105041572e-01, -2.489941710392296e-03,  1.006612548178362e-05, -2.301398385245551e-08, -2.767859450500927e-11,
  5.634824166859498e-13, -2.756029231048312e-15,  4.590846105307785e-18,  3.380349692629292e-20, -3.232834147292171e-22,  1.241693125123372e-24, -6.633154335693054e-30,
  4.656383474666924e-01, -2.938651847875073e-03,  1.078734261906007e-05, -1.602283848315700e-08, -9.216705124462849e-11,  7.872450225293250e-13, -2.361366944120861e-15,
 -4.719059135232057e-18,  8.468698908953584e-20, -3.842262471064437e-22,  8.380150625370362e-26,  9.793948286050131e-27,  5.567804489381196e-01, -3.383760912455246e-03,
  1.096536452533901e-05, -4.839707932992713e-09, -1.640984272095883e-10,  8.846665343558311e-13, -7.102485212826651e-16, -1.814749952446206e-17,  1.154422851553205e-19,
 -1.375546517547947e-22, -2.505500052294017e-24,  1.801877416939844e-26,  6.552235544660666e-01, -3.808283272448712e-03,  1.045266029590247e-05,  1.034219266486362e-08,
 -2.302988785673175e-10,  7.542301811042063e-13,  2.252086180417934e-15, -3.049674022240315e-17,  8.260579702178973e-20,  4.874618580526574e-22, -4.947737161224659e-24,
  9.678536113290952e-27,  7.605040494100261e-01, -4.192402626879696e-03,  9.118432841113579e-06,  2.860670363598659e-08, -2.722899464063323e-10,  3.158279066858585e-13,
  5.942374251579657e-15, -3.275514879235612e-17, -4.466709674424118e-20,  1.217808473396341e-21, -3.782979130526101e-24, -2.453094040249745e-26,  8.720033351499969e-01,
 -4.513390130271775e-03,  6.870273395193506e-06,  4.809268225404329e-08, -2.682829634992449e-10, -4.384716345005845e-13,  8.912749641425743e-15, -1.521206650726834e-17,
 -2.388141367236507e-19,  1.324288372093784e-21,  3.772402167193861e-24, -6.127152729060949e-26,  9.888998297373652e-01, -4.745812240394559e-03,  3.685118357328150e-06,
  6.583613861404287e-08, -1.981510579688360e-10, -1.381083021892133e-12,  8.979789738571103e-15,  2.488457160655137e-17, -3.721369509403593e-19, -3.638457891302172e-24,
  1.403787190803998e-23, -3.564832236684057e-26,  1.110108061016194e+00, -4.862272814427995e-03, -3.495034934355840e-07,  7.780876261738839e-08, -5.240887351266089e-11,
 -2.199646604019780e-12,  4.100965228750651e-15,  7.267699205407712e-17, -2.448396047571685e-19, -2.530665783830778e-21,  1.330861068286375e-23,  8.724032208990773e-26,
  1.234203431714576e+00, -4.835064187103107e-03, -4.986241970675082e-06,  7.937088910857383e-08,  1.550634756163983e-10, -2.420868359509678e-12, -5.762965170911539e-15,
  9.093146652807468e-17,  2.353096832131108e-19, -3.817729128473495e-21, -1.027654443618452e-23,  1.711081092328866e-25,  1.359333462521068e+00, -4.639250593992141e-03,
 -9.770676303117703e-06,  6.642421691889360e-08,  3.744970905063319e-10, -1.593911939784671e-12, -1.643697856709268e-14,  3.867579395173866e-17,  7.640423554560895e-19,
 -5.547256663387282e-22, -3.645095986207039e-23, -3.037500930856943e-26,  1.483121400252407e+00, -4.257801201318197e-03, -1.402035564424032e-05,  3.747349357546568e-08,
  5.187063245568230e-10,  3.187420630185501e-13, -1.945648835674424e-14, -7.638441704424364e-17,  6.362062933709460e-19,  5.727988518946863e-21, -1.248553257892679e-23,
 -3.336684828657419e-25,  1.602577894623602e+00, -3.689238040882856e-03, -1.687524005251166e-05, -3.667994425625526e-09,  4.903599276120338e-10,  2.507809936600192e-12,
 -7.898535563977263e-15, -1.529418014615619e-16, -4.084849243486524e-19,  5.533474145590365e-21,  5.035197790371638e-23, -2.875958637176086e-26,  1.714052675435075e+00,
 -2.957493518790745e-03, -1.748134396260227e-05, -4.594758259641866e-08,  2.500489051417166e-10,  3.403883014199443e-12,  1.253482673691294e-14, -7.107991687857621e-17,
 -1.128842396747617e-18, -4.491627794465264e-21,  2.780627674892699e-23,  4.552338512426686e-25,  1.813279721700930e+00, -2.121796317472275e-03, -1.534901886893317e-05,
 -7.288242277428548e-08, -1.037833071981995e-10,  1.930593291432594e-12,  2.130255617499974e-14,  9.889435862177296e-17, -1.691008886902707e-19, -6.773428888460205e-21,
 -5.442804788087437e-23, -1.366332362418008e-25,  1.895587158512220e+00, -1.281345511693395e-03, -1.081592536198397e-05, -7.099323914265107e-08, -3.427199751274293e-10,
 -7.422867104861769e-13,  6.948138151372703e-15,  1.083560073799165e-16,  8.351117520163377e-19,  3.638781080194454e-21, -3.930258294381966e-24, -2.455505638561883e-25,
  1.956334463718382e+00, -5.668605425511148e-04, -5.330665493705644e-06, -4.245447830595759e-08, -2.961500842260836e-10, -1.790393755031381e-12, -8.786461401124805e-15,
 -2.625464718738188e-17,  8.806419013242717e-20,  2.357037618992555e-21,  2.506843968645524e-23,  1.955553469645155e-25,  1.991580724200973e+00, -1.129052720184903e-04,
 -1.128272681419465e-06, -9.937054236612803e-09, -8.117157501164356e-11, -6.281558017767753e-13, -4.650030057693542e-15, -3.305492218795439e-17, -2.256183304898695e-19,
 -1.473142144994168e-21, -9.122524858399569e-24, -5.266420745902763e-26,  1.036474827630406e-03, -7.509002847977126e-06,  4.078153549090616e-08, -1.968099671852808e-10,
  8.896893802852401e-13, -3.859444865425173e-15,  1.625333359479417e-17, -6.704860884335590e-20,  2.714727503733279e-22, -1.087687849331577e-24,  4.281775503722023e-27,
 -1.688920752557453e-29,  9.327694958145446e-03, -6.743025022333584e-05,  3.643812956556252e-07, -1.742800447043279e-09,  7.768412844118241e-12, -3.301907478223845e-14,
  1.351932971920706e-16, -5.372251947583624e-19,  2.071213308510486e-21, -7.798993442265925e-24,  2.831363125315200e-26, -1.012887458120525e-28,  2.590690386766707e-02,
 -1.864629975770368e-04,  9.973960099275591e-07, -4.683407637706469e-09,  2.026951241537108e-11, -8.243715434894252e-14,  3.166615954486363e-16, -1.149127405022975e-18,
  3.884335263194587e-21, -1.205019549810498e-23,  3.161722373062465e-26, -6.162965196946527e-29,  5.076692625106610e-02, -3.629606098246508e-04,  1.911277699124132e-06,
 -8.718754259862816e-09,  3.596454683600095e-11, -1.355193568129052e-13,  4.607341622111919e-16, -1.360731388179769e-18,  3.036844286899952e-21, -1.857711324282755e-24,
 -3.388262947966480e-26,  2.672280526924223e-28,  8.389516413291655e-02, -5.943843600014877e-04,  3.062778239300862e-06, -1.340685220839682e-08,  5.142901768360304e-11,
 -1.704170248750025e-13,  4.490384465241247e-16, -6.291012450624515e-19, -2.470619349381493e-21,  2.739378855628593e-23, -1.600784021593813e-25,  6.951651856477762e-28,
  1.252712401598951e-01, -8.772183435750814e-04,  4.393498160617465e-06, -1.817488904479294e-08,  6.252498728543989e-11, -1.637218432500918e-13,  1.801808789607207e-16,
  1.316228602709007e-18, -1.221236737840842e-20,  6.373503529161156e-23, -2.457875367887323e-25,  6.057888493058211e-28,  1.748635824803467e-01, -1.206851883567018e-03,
  5.829400756650477e-06, -2.233763139239792e-08,  6.481146673562932e-11, -9.539704965375848e-14, -3.880200099966268e-16,  4.201211132650957e-18, -2.210721720442389e-20,
  7.659186533683771e-23, -1.265568986203275e-25, -6.279687112325694e-28,  2.326246857499840e-01, -1.577426184315778e-03,  7.280424259310190e-06, -2.512620975509267e-08,
  5.410783047225124e-11,  4.520366406856408e-14, -1.195878462264823e-15,  7.028831942975122e-18, -2.458828313279392e-20,  2.790336113978352e-23,  3.049260911961332e-25,
 -2.781919863532472e-27,  2.984846734414252e-01, -1.981641794033937e-03,  8.640406485931683e-06, -2.573180999188108e-08,  2.723423438903566e-11,  2.526497989938981e-13,
 -2.049364417121400e-15,  8.117355275596745e-18, -1.104034705642594e-20, -1.011787335489594e-22,  9.170240575752371e-25, -4.019892655010936e-27,  3.723426430790246e-01,
 -2.410524072971011e-03,  9.787660911826431e-06, -2.337023227036529e-08, -1.705939381472162e-11,  4.989920613990945e-13, -2.614022971365824e-15,  5.495906300580030e-18,
  2.305536591445085e-20, -2.740402462454085e-22,  1.210990219785289e-24, -1.308949844931971e-27,  4.540550859814172e-01, -2.853146096202022e-03,  1.058673001779764e-05,
 -1.737467090130210e-08, -7.699805314350689e-11,  7.292801022764615e-13, -2.457631026173645e-15, -2.228952610628547e-18,  7.101105230097453e-20, -3.731276710089621e-22,
  4.501545215833670e-25,  6.916094683369777e-27,  5.434204220533873e-01, -3.296313599157056e-03,  1.089211500683930e-05, -7.324827605989747e-09, -1.466145791239861e-10,
  8.619352200582195e-13, -1.167533862848165e-15, -1.455039676017454e-17,  1.088732229655766e-19, -2.223915994753785e-22, -1.749486468696059e-24,  1.622113624026462e-26,
  6.401583630466602e-01, -3.724227042037890e-03,  1.055516444035191e-05,  6.780739396603724e-09, -2.147413332258353e-10,  7.983469188079785e-13,  1.437555915080000e-15,
 -2.760985575813726e-17,  9.670735855084417e-20,  2.994313028272355e-22, -4.423896900118004e-24,  1.378646350925264e-26,  7.438824040725387e-01, -4.118155576397641e-03,
  9.435806138986275e-06,  2.430803158784539e-08, -2.646221739277820e-10,  4.473170589558682e-13,  5.011590539630805e-15, -3.351415545880289e-17, -3.779720840819238e-21,
  1.048200506007453e-21, -4.617419756207128e-24, -1.356109139422261e-26,  8.540632502418966e-01, -4.456193059076269e-03,  7.421378242075214e-06,  4.374146182024603e-08,
 -2.749521098939869e-10, -2.304954861614529e-13,  8.387167574230213e-15, -2.206739822337614e-17, -1.890606614349709e-19,  1.422722926149462e-21,  1.193338965283472e-24,
 -5.525375124196817e-26,  9.699804674554918e-01, -4.713227078061715e-03,  4.455256524059080e-06,  6.245667077607914e-08, -2.235680718242893e-10, -1.158548828755762e-12,
  9.510573717735650e-15,  1.307902293466527e-17, -3.625951136036900e-19,  5.204090235105678e-22,  1.202656764288486e-23, -5.456915924144083e-26,  1.090659266683319e+00,
 -4.861351582336221e-03,  5.777378116870903e-07,  7.662429975927968e-08, -9.525766135692798e-11, -2.077769641199644e-12,  6.013309926644440e-15,  6.349410615383091e-17,
 -3.255288989165146e-19, -1.931798231649280e-21,  1.637208129419728e-23,  5.125402421256679e-26,  1.214789481918965e+00, -4.871105867115447e-03, -4.020524925034489e-06,
  8.145793019893241e-08,  1.054730787867122e-10, -2.527905129412551e-12, -3.132605584737937e-15,  9.619808634620038e-17,  9.233531334833380e-20, -4.073177759740199e-21,
 -2.408907454392369e-24,  1.830286448596222e-25,  1.340625318004471e+00, -4.714128338767864e-03, -8.938754266105914e-06,  7.214012820025778e-08,  3.387758569071388e-10,
 -1.972670131761746e-12, -1.501678158442913e-14,  6.252311086919635e-17,  7.177340842300401e-19, -2.014292147747178e-21, -3.589357318261178e-23,  5.644313590405377e-26,
  1.465868917352494e+00, -4.368023914441421e-03, -1.352075161065267e-05,  4.579773884764371e-08,  5.202510518591113e-10, -1.713919265846675e-13, -2.128008668505350e-14,
 -5.285187118792521e-17,  8.298483430261428e-19,  4.931412698075739e-21, -2.735103025620294e-23, -3.346052349189141e-25,  1.587550853082292e+00, -3.824278909508321e-03,
 -1.687056367830026e-05,  4.567234228209017e-09,  5.382668033992523e-10,  2.265577410926251e-12, -1.233121563353307e-14, -1.624423676596678e-16, -1.737252292291242e-19,
  7.478563096399010e-21,  4.576904903752436e-23, -1.840911537039555e-25,  1.701939610809707e+00, -3.099476464720944e-03, -1.800641277869365e-05, -4.138658536681015e-08,
  3.209520159191896e-10,  3.676613371973196e-12,  1.001632347490336e-14, -1.095347749127466e-16, -1.265478615853107e-18, -2.955796966997997e-21,  4.947517671367593e-23,
  5.220003931105267e-25,  1.804541377314101e+00, -2.248111934180430e-03, -1.623220442678740e-05, -7.420535479137962e-08, -5.983870730794363e-11,  2.474231081681811e-12,
  2.395612785372314e-14,  8.915143885813762e-17, -4.533097405965459e-19, -9.039957741003056e-21, -5.800671029829573e-23, -1.391850450795791e-26,  1.890283193162130e+00,
 -1.371374873965185e-03, -1.170120295690661e-05, -7.658537683295351e-08, -3.556362903112435e-10, -5.359846222336676e-13,  1.037557946633362e-14,  1.371217287389400e-16,
  9.603182636447410e-19,  3.225812610217301e-21, -1.777321203583746e-23, -3.904310303852690e-25,  1.953978386955095e+00, -6.116270313336872e-04, -5.869769082163536e-06,
 -4.749104333972884e-08, -3.341242505531230e-10, -2.009686190857820e-12, -9.467900205415767e-15, -2.186755408791178e-17,  1.931975962391758e-19,  3.549272428178135e-21,
  3.499341744704770e-23,  2.573174049528546e-25,  1.991110263053562e+00, -1.224315065576611e-04, -1.255744924595550e-06, -1.134269801816115e-08, -9.493010066706110e-11,
 -7.517304500136118e-13, -5.685147065971663e-15, -4.119843701837047e-17, -2.858148730437832e-19, -1.888466421552754e-21, -1.174998005607174e-23, -6.726098443367895e-26,
  1.007076697324915e-03, -7.191961178720116e-06,  3.850274578311816e-08, -1.831718750260333e-10,  8.162541407346684e-13, -3.490946580313047e-15,  1.449193328243590e-17,
 -5.895633467115299e-20,  2.352277255439659e-22, -9.304144136376480e-25,  3.602234737958685e-27, -1.409498052168536e-29,  9.063674523461386e-03, -6.459679033974683e-05,
  3.441922227342400e-07, -1.623617584329331e-09,  7.139296946797853e-12, -2.994770562940225e-14,  1.210381963995610e-16, -4.752284497709133e-19,  1.809802958960428e-21,
 -6.751045544492272e-24,  2.419108305230378e-26, -8.654816798329281e-29,  2.517666189614039e-02, -1.787032424318704e-04,  9.430878912298498e-07, -4.371883149078231e-09,
  1.869423281120187e-11, -7.520972935304924e-14,  2.861627039638123e-16, -1.031530843184517e-18,  3.472633975921161e-21, -1.084027557511772e-23,  2.886901389918864e-26,
 -6.298791527965981e-29,  4.934501517327441e-02, -3.480793082289885e-04,  1.810017712945984e-06, -8.164416567706057e-09,  3.336170621791301e-11, -1.249080320375579e-13,
  4.239823978756158e-16, -1.264862219531246e-18,  2.948218729434620e-21, -2.998094624678593e-24, -2.361178562526499e-26,  2.019184030440524e-28,  8.156563163595379e-02,
 -5.705119295602454e-04,  2.906722603273221e-06, -1.261067524182991e-08,  4.812697715125730e-11, -1.598595454495125e-13,  4.304565549153644e-16, -6.935603032018275e-19,
 -1.592643877296305e-21,  2.156788290217358e-23, -1.320469778121160e-25,  5.811727519956021e-28,  1.218313051480888e-01, -8.429259934393836e-04,  4.181294627909954e-06,
 -1.720043802477592e-08,  5.929655956680683e-11, -1.589973557337097e-13,  2.118958463649665e-16,  9.602987261623306e-19, -1.008847565968140e-20,  5.443334834662705e-23,
 -2.194264227764699e-25,  5.881435788119327e-28,  1.701277723907210e-01, -1.161271403199682e-03,  5.567506585589261e-06, -2.131637884106736e-08,  6.281952682750224e-11,
 -1.033753510654860e-13, -2.798828680645136e-16,  3.536871504526766e-18, -1.944686520784433e-20,  7.106625592247535e-23, -1.476781483925161e-25, -3.468656338319078e-28,
  2.264295790645585e-01, -1.520374072075808e-03,  6.984129056012852e-06, -2.425474597926828e-08,  5.474037903440205e-11,  1.877636388253149e-14, -1.009920257201896e-15,
  6.260204393728565e-18, -2.339211425494360e-20,  3.782687304697964e-23,  1.954124546551190e-25, -2.210440260848506e-27,  2.906944080943544e-01, -1.913745894268262e-03,
  8.334397554212956e-06, -2.525823412672044e-08,  3.181357336105552e-11,  2.061494414882829e-13, -1.827523628914428e-15,  7.712524026070292e-18, -1.406432866935891e-20,
 -6.794352427881552e-23,  7.471810033776172e-25, -3.685280097146905e-27,  3.628553676456767e-01, -2.333348460393110e-03,  9.505898862225297e-06, -2.356669882009768e-08,
 -7.694060000782832e-12,  4.381767182575159e-13, -2.451225983126759e-15,  6.085049530891132e-18,  1.404532393715904e-20, -2.270351294277490e-22,  1.132996423128176e-24,
 -2.171181535520740e-27,  4.428105406697957e-01, -2.769306096135788e-03,  1.037131305051144e-05, -1.849317644364742e-08, -6.300606292597143e-11,  6.697925319435013e-13,
 -2.490220118757672e-15, -1.674962879666705e-19,  5.796890693456666e-20, -3.497981106483602e-22,  6.981974697502383e-25,  4.428009985668655e-27,  5.304088302240256e-01,
 -3.209566850402050e-03,  1.079070565990341e-05, -9.534405237052539e-09, -1.296870815681857e-10,  8.294113129537136e-13, -1.527461749732726e-15, -1.120670046219585e-17,
  9.977348798098150e-20, -2.787634419555102e-22, -1.086368430289336e-24,  1.385610520390192e-26,  6.254307719987451e-01, -3.639517436279377e-03,  1.061645042353629e-05,
  3.474231706288821e-09, -1.984901553988422e-10,  8.239298125891899e-13,  7.091889946097137e-16, -2.437566549587292e-17,  1.044550661110553e-19,  1.353713336047280e-22,
 -3.763510809962765e-24,  1.593246961787799e-26,  7.275625014086341e-01, -4.041573598204217e-03,  9.702414316147423e-06,  2.015186378165822e-08, -2.545489885242188e-10,
  5.563543755184929e-13,  4.076913711610492e-15, -3.306797790565508e-17,  3.051421116109286e-20,  8.545189015544621e-22, -4.996635756828515e-24, -3.955104881856523e-27,
  8.363604384532191e-01, -4.394797510334075e-03,  7.919763079445233e-06,  3.931606387791050e-08, -2.776024797701378e-10, -3.725421369898221e-14,  7.692319900319413e-15,
 -2.729324257458673e-17, -1.375460950786112e-19,  1.424427359277976e-21, -1.038907509252803e-24, -4.577754475635126e-26,  9.512035018848750e-01, -4.674649596084938e-03,
  5.182549852887347e-06,  5.870671677905966e-08, -2.444335385007419e-10, -9.271911423167315e-13,  9.717793732020105e-15,  1.863639985823800e-18, -3.358163135079740e-19,
  9.495635580840025e-22,  9.349018070300073e-24, -6.584808442222629e-26,  1.071228886930678e+00, -4.853080727891010e-03,  1.486740344489413e-06,  7.477615789960619e-08,
 -1.352321945616842e-10, -1.913352939454914e-12,  7.635776432929386e-15,  5.209459838091714e-17, -3.828443355228283e-19, -1.243029277584646e-21,  1.778869707833816e-23,
  1.320644297510319e-26,  1.195246956262272e+00, -4.899335261578913e-03, -3.034583483624268e-06,  8.273786979526613e-08,  5.438247756058276e-11, -2.570566987512710e-12,
 -4.197785081734707e-16,  9.680377832711252e-17, -5.410097778926714e-20, -4.009679862021296e-21,  5.516194780834187e-24,  1.737787581865431e-25,  1.321631393211149e+00,
 -4.782086622249337e-03, -8.041913901924889e-06,  7.722597376521751e-08,  2.958733221824423e-10, -2.309546559684674e-12, -1.295743083972489e-14,  8.405966610321580e-17,
  6.202081096874204e-19, -3.374825286427054e-21, -3.151438814952975e-23,  1.411802504525984e-25,  1.448184169500167e+00, -4.473850570648140e-03, -1.292143888965759e-05,
  5.406613659397479e-08,  5.116122990199429e-10, -6.967157183552396e-13, -2.236314783718223e-14, -2.369563627213740e-17,  9.842248059003441e-19,  3.553115704495209e-21,
 -4.122290323513238e-23, -2.877977377244547e-25,  1.571984366628876e+00, -3.958874451625773e-03, -1.676264430586010e-05,  1.352436111636896e-08,  5.802482942255808e-10,
  1.914680361882705e-12, -1.691454417237844e-14, -1.633594219425598e-16,  1.260485635729790e-19,  9.097112157531402e-21,  3.390355719569101e-23, -3.559292075497250e-25,
  1.689250587679563e+00, -3.245421356304515e-03, -1.846977458565452e-05, -3.565115990102589e-08,  3.966157629770558e-10,  3.875541936874265e-12,  6.369404538563501e-15,
 -1.513052463654917e-16, -1.330658427725899e-18, -5.106279781018825e-22,  7.281486309832333e-23,  5.258198600926850e-25,  1.795283556940521e+00, -2.381543734885532e-03,
 -1.712667677769372e-05, -7.473484312141144e-08, -4.412225264189527e-12,  3.077177176558687e-12,  2.619717653959988e-14,  6.899259408893319e-17, -8.201830898178063e-19,
 -1.131880944130560e-20, -5.445212321752897e-23,  1.899421487473401e-25,  1.884604516410809e+00, -1.468758048834831e-03, -1.265467476608231e-05, -8.234641606947086e-08,
 -3.635364705404113e-10, -2.373237930882859e-13,  1.466148083654040e-14,  1.695361323063047e-16,  1.059045289057642e-18,  2.119642648183571e-21, -3.888269626881859e-23,
 -5.752800458828101e-25,  1.951434220771794e+00, -6.609587717794557e-04, -6.473104450652723e-06, -5.317112128012902e-08, -3.766357175482133e-10, -2.243436399553490e-12,
 -9.972370339128970e-15, -1.334735373576002e-17,  3.490786158600583e-19,  5.195681945589398e-21,  4.783907252949160e-23,  3.274872929875855e-25,  1.990599545040723e+00,
 -1.330489292671478e-04, -1.401491864872556e-06, -1.298968157320136e-08, -1.114282031835269e-10, -9.031163707624664e-13, -6.977650428135373e-15, -5.152906140059719e-17,
 -3.630177386046894e-19, -2.422623810177103e-21, -1.508619594152327e-23, -8.487146336744888e-26,  9.789112820771286e-04, -6.892514627518993e-06,  3.638079937192008e-08,
 -1.706520090942875e-10,  7.497838282778312e-13, -3.162128910830687e-15,  1.294169398152311e-17, -5.193832730223529e-20,  2.041834020655288e-22, -7.980273382997482e-25,
  3.033584191113898e-27, -1.183304837819159e-29,  8.810673725469453e-03, -6.191928883022094e-05,  3.253749179244471e-07, -1.514027041521291e-09,  6.568347075603820e-12,
 -2.719613949746919e-14,  1.085073443358286e-16, -4.210238223136058e-19,  1.583299700786406e-21, -5.855804008269259e-24,  2.065965524673992e-26, -7.437137368437621e-29,
  2.447661310041392e-02, -1.713634168041334e-04,  8.923714838224146e-07, -4.084445423428264e-09,  1.725644115613998e-11, -6.867621453397149e-14,  2.587784703250383e-16,
 -9.264331130291565e-19,  3.102500966193826e-21, -9.741025640328236e-24,  2.609295875689865e-26, -6.307692670954089e-29,  4.798105029313871e-02, -3.339821704638171e-04,
  1.715166757088143e-06, -7.650073531325524e-09,  3.096248729584819e-11, -1.151468932693084e-13,  3.898696281649934e-16, -1.172412025721305e-18,  2.825277089490406e-21,
 -3.781295080237964e-24, -1.593524929719596e-26,  1.487275066168852e-28,  7.932915123300090e-02, -5.478506099807339e-04,  2.759910982855310e-06, -1.186566651679955e-08,
  4.503149597294241e-11, -1.497667012015722e-13,  4.104331000413695e-16, -7.330730475195544e-19, -9.053925421932919e-22,  1.676669967918714e-23, -1.087518191919394e-25,
  4.795838058195073e-28,  1.185252171086497e-01, -8.102853686150894e-04,  3.980477821573107e-06, -1.627684782810888e-08,  5.616946434637131e-11, -1.536239236268256e-13,
  2.345473799618805e-16,  6.671771689953360e-19, -8.280716971929104e-21,  4.616353395930339e-23, -1.943539480655477e-25,  5.484657969771114e-28,  1.655701707512449e-01,
 -1.117737609127610e-03,  5.317671393135775e-06, -2.032813899950761e-08,  6.069251600022878e-11, -1.089721484159705e-13, -1.891863325600081e-16,  2.954339996645931e-18,
 -1.699789298217839e-20,  6.491798033600773e-23, -1.582857469116092e-25, -1.475861110302609e-28,  2.204580065279660e-01, -1.465650357777825e-03,  6.698335466359143e-06,
 -2.337715454055602e-08,  5.488729196328958e-11, -3.441571833715828e-15, -8.448997842291961e-16,  5.534772371108193e-18, -2.191172628912298e-20,  4.384660297561444e-23,
  1.090836633770720e-25, -1.728588344349490e-27,  2.831708678628274e-01, -1.848274157555601e-03,  8.034481385262938e-06, -2.471854365183841e-08,  3.551517682568930e-11,
  1.648273642800880e-13, -1.618202164818724e-15,  7.228787867125396e-18, -1.601037172953612e-20, -4.118537768920115e-23,  5.936153388446283e-25, -3.289412864620203e-27,
  3.536722750145719e-01, -2.258433918270179e-03,  9.222638849558516e-06, -2.362283315415168e-08,  4.952125757814069e-13,  3.814354149852607e-13, -2.275719781212033e-15,
  6.412276709867198e-18,  6.663173586107517e-21, -1.837993400513022e-22,  1.025060372824006e-24, -2.685116169111457e-27,  4.318978289340194e-01, -2.687239404855715e-03,
  1.014377789992831e-05, -1.939735186277836e-08, -5.020721032022795e-11,  6.101691516475366e-13, -2.470792607038497e-15,  1.491757459270373e-18,  4.591997468299458e-20,
 -3.186106783914297e-22,  8.461878643518597e-25,  2.370196135461863e-27,  5.177424413435627e-01, -3.123732884199580e-03,  1.066438352054831e-05, -1.147878486058554e-08,
 -1.134890387071997e-10,  7.893380165978315e-13, -1.798112616693857e-15, -8.181756096752885e-18,  8.909585119028762e-20, -3.107844609655949e-22, -5.337197248954243e-25,
  1.124607315518049e-26,  6.110427549391463e-01, -3.554471801834211e-03,  1.063963232078856e-05,  4.309175592050581e-10, -1.818946703056321e-10,  8.331413328989995e-13,
  7.399974723674384e-17, -2.098279506680403e-17,  1.067901921407968e-19, -8.910789501764034e-25, -3.045899378448367e-24,  1.644799649692503e-26,  7.115528805962598e-01,
 -3.963055352893772e-03,  9.920183538781912e-06,  1.617310048925318e-08, -2.425177540686524e-10,  6.432268433330268e-13,  3.169029095633527e-15, -3.163808713345491e-17,
  5.765965223522865e-20,  6.535911391734499e-22, -4.993571174649469e-24,  3.755214966858794e-27,  8.189108460484777e-01, -4.329627735288174e-03,  8.364913182324986e-06,
  3.487822613591961e-08, -2.765656790854561e-10,  1.377405691154251e-13,  6.874118401994461e-15, -3.088601502607589e-17, -8.747073690915879e-20,  1.345835172407420e-21,
 -2.808183262157030e-24, -3.447156860526725e-26,  9.325921903917987e-01, -4.630439087779471e-03,  5.862993933164076e-06,  5.466009790701233e-08, -2.606469968750979e-10,
 -6.945181971995556e-13,  9.625150188779492e-15, -8.269132955673611e-18, -2.956146092384432e-19,  1.263966936635030e-21,  6.344499516402987e-24, -6.952339073072954e-26,
  1.051845979173473e+00, -4.837637173959654e-03,  2.369842683256502e-06,  7.231673392184680e-08, -1.715558285769546e-10, -1.714011307318806e-12,  8.917166125544943e-15,
  3.926541080772077e-17, -4.147439323640204e-19, -5.306129413757186e-22,  1.757393092367873e-23, -2.218229409004975e-26,  1.175607365690853e+00, -4.919629625926867e-03,
 -2.038204169696359e-06,  8.319706768914712e-08,  3.088371625415118e-12, -2.548442723651652e-12,  2.245177962272122e-15,  9.282011233862196e-17, -1.926974415909819e-19,
 -3.643213958102776e-21,  1.259948358044577e-23,  1.453516037201906e-25,  1.302380354127503e+00, -4.842638225334878e-03, -7.088375130345545e-06,  8.157436205653006e-08,
  2.467743383464014e-10, -2.590158812008629e-12, -1.034582904236904e-14,  1.017326308502800e-16,  4.777241879495467e-19, -4.489130987609038e-21, -2.369150885871117e-23,
  2.109431446924874e-25,  1.430086328044916e+00, -4.574488997987026e-03, -1.222408522329898e-05,  6.211113716307696e-08,  4.922759388658974e-10, -1.237727818284542e-12,
 -2.256886903412206e-14,  9.504545927554134e-18,  1.079622062110678e-18,  1.675462511590500e-21, -5.197133103470915e-23, -1.934329521748032e-25,  1.555881920827418e+00,
 -4.092165849862888e-03, -1.654346011514787e-05,  2.309108309566156e-08,  6.141155828759886e-10,  1.454609477987021e-12, -2.138123067152199e-14, -1.538578003104241e-16,
  4.737305471991544e-19,  1.009089458033254e-20,  1.461379297787015e-23, -5.162560966125214e-25,  1.675970836498697e+00, -3.394776991895140e-03, -1.885693277338166e-05,
 -2.867844228467768e-08,  4.752872358372751e-10,  3.972761637674159e-12,  1.538224338758521e-15, -1.935740367024739e-16, -1.291196834196649e-18,  2.845823415360811e-21,
  9.434995695530263e-23,  4.351187752515021e-25,  1.785477680080101e+00, -2.522140719423441e-03, -1.802177521959147e-05, -7.427833077311670e-08,  6.355813735533843e-11,
  3.725734094554809e-12,  2.769739008482393e-14,  3.582772920358694e-17, -1.264136548573380e-18, -1.324995241768438e-20, -3.997144497293290e-23,  4.827083470363420e-25,
  1.878520611184563e+00, -1.574047185079343e-03, -1.367782138612859e-05, -8.818016916532763e-08, -3.643596356446739e-10,  1.754038779196303e-13,  1.989197154148046e-14,
  2.042931529328969e-16,  1.100698156865707e-18, -3.577798996899410e-24, -6.884345227261246e-23, -7.897077934051491e-25,  1.948682625777212e+00, -7.154017611610536e-04,
 -7.148838013634981e-06, -5.956934856421947e-08, -4.239207788316288e-10, -2.485808975831539e-12, -1.015878745198261e-14,  1.214644526661381e-18,  5.742324427925819e-19,
  7.418508233994404e-21,  6.381362616269287e-23,  3.974028300449542e-25,  1.990043893562188e+00, -1.449161117595499e-04, -1.568692081219735e-06, -1.492664554715797e-08,
 -1.312891764218483e-10, -1.089291355051023e-12, -8.597081667503679e-15, -6.466517340917699e-17, -4.620466448163607e-19, -3.106546632382034e-21, -1.925706565046750e-23,
 -1.050448520586109e-25,  9.519106285195793e-04, -6.609460286974799e-06,  3.440292085116881e-08, -1.591450140000785e-10,  6.895331665935169e-13, -2.868266938931280e-15,
  1.157473729667929e-17, -4.584168699407759e-20,  1.775183055193728e-22, -6.865337280530220e-25,  2.554268494141469e-27, -1.002375779743454e-29,  8.568089971658635e-03,
 -5.938721663276107e-05,  3.078196529193560e-07, -1.413147284637676e-09,  6.049539948655582e-12, -2.472789126624123e-14,  9.739740492093340e-17, -3.735778967944164e-19,
  1.386605233471675e-21, -5.091804387392291e-24,  1.761194262384738e-26, -6.453764028476223e-29,  2.380513345064189e-02, -1.644159068003405e-04,  8.449705002495139e-07,
 -3.819001734017123e-09,  1.594297917836782e-11, -6.276591108662161e-14,  2.341769498928110e-16, -8.325679006002954e-19,  2.769942593595148e-21, -8.752764294568796e-24,
  2.332085869395148e-26, -6.299327836076606e-29,  4.667199453674323e-02, -3.206197899150456e-04,  1.626263893294471e-06, -7.172599826732778e-09,  2.875051136073128e-11,
 -1.061738663096844e-13,  3.582865442014970e-16, -1.084292230365019e-18,  2.679129251387043e-21, -4.301440757730016e-24, -1.039590468115841e-26,  1.042031560727739e-28,
  7.718102257444799e-02, -5.263288497468530e-04,  2.621748876718260e-06, -1.116859707956309e-08,  4.213298862387895e-11, -1.401653645416649e-13,  3.895864254021649e-16,
 -7.531879417996388e-19, -3.752593451361066e-22,  1.281109174622962e-23, -8.969493655988262e-26,  3.880341617798858e-28,  1.153465475026506e-01, -7.792077881358179e-04,
  3.790447531251250e-06, -1.540240454459928e-08,  5.315464197741903e-11, -1.477990749586596e-13,  2.497579882890107e-16,  4.273303106031193e-19, -6.753087062161847e-21,
  3.885661442532844e-23, -1.714000124626936e-25,  4.924791318202771e-28,  1.611827812041526e-01, -1.076155647395363e-03,  5.079487560182453e-06, -1.937471393950234e-08,
  5.847406010217009e-11, -1.125793110604675e-13, -1.137373049820624e-16,  2.446568178204657e-18, -1.477597598100758e-20,  5.849973706238365e-23, -1.616763824986722e-25,
 -1.701221982571871e-29,  2.147008228616900e-01, -1.413170860254793e-03,  6.423073092187103e-06, -2.250055898546574e-08,  5.462783424319384e-11, -2.193723086524234e-14,
 -6.995001345277881e-16,  4.859553536050564e-18, -2.027191922693822e-20,  4.681040334351143e-23,  4.195156245467973e-26, -1.337951054662038e-27,  2.759044582767357e-01,
 -1.785174899275130e-03,  7.741370454683354e-06, -2.412597081946679e-08,  3.843944604173380e-11,  1.283602785191739e-13, -1.423160578001049e-15,  6.697040015642622e-18,
 -1.709942644430869e-20, -2.021505470526772e-23,  4.578675466814685e-25, -2.882717200599997e-27,  3.447843071584074e-01, -2.185786007960790e-03,  8.939454694523793e-06,
 -2.355678622234942e-08,  7.592390760217392e-12,  3.289909224386791e-13, -2.094130601530822e-15,  6.527306448945692e-18,  7.551093810698538e-22, -1.452508864409006e-22,
  9.005085331818851e-25, -2.941009570000479e-27,  4.213096794791956e-01, -2.607033004300179e-03,  9.906582106099855e-06, -2.010624502169609e-08, -3.859262016320582e-11,
  5.515270459726776e-13, -2.410127968873109e-15,  2.784382271579744e-18,  3.507966912949495e-20, -2.831888954569049e-22,  9.129716806899809e-25,  7.314615621821934e-28,
  5.054172255378528e-01, -3.038998482530480e-03,  1.051625632320643e-05, -1.317073236385184e-08, -9.815076093369166e-11,  7.437459522070965e-13, -1.988992810414084e-15,
 -5.512899680487350e-18,  7.763551041512497e-20, -3.230129309050479e-22, -9.678831477752403e-26,  8.628163372260391e-27,  5.969950664203524e-01, -3.469382268537172e-03,
  1.062789109990710e-05, -2.346190873973424e-09, -1.652596800673241e-10,  8.282524256312974e-13, -4.658408095264597e-16, -1.758812769942910e-17,  1.047383573080529e-19,
 -1.083920522073513e-22, -2.334572930179274e-24,  1.570914872758804e-26,  6.958605194711672e-01, -3.882982537515503e-03,  1.009141614259838e-05,  1.239956795452107e-08,
 -2.289632405864653e-10,  7.088820145185872e-13,  2.312258989923152e-15, -2.945462607416558e-17,  7.765007023366351e-20,  4.589553603493567e-22, -4.697461116538378e-24,
  9.351624203627933e-27,  8.017287186097954e-01, -4.261109234717507e-03,  8.757020719944733e-06,  3.048387845180705e-08, -2.722325764975068e-10,  2.920693386656630e-13,
  5.977236020957784e-15, -3.293431685990928e-17, -4.137667153019963e-20,  1.206622776079618e-21, -4.067417959877164e-24, -2.281767877826491e-26,  9.141682947329435e-01,
 -4.580983322188179e-03,  6.493475010787747e-06,  5.039107684212482e-08, -2.722514192957860e-10, -4.673183159469006e-13,  9.268334329940845e-15, -1.695774194711216e-17,
 -2.462778078933834e-19,  1.457002547328731e-21,  3.328968345944382e-24, -6.657187993588988e-26,  1.032538774817324e+00, -4.815256420456068e-03,  3.220081505443773e-06,
  6.930957348633912e-08, -2.036146890524228e-10, -1.488318713693676e-12,  9.828874141659192e-15,  2.582117891412465e-17, -4.215117519686001e-19,  1.437302947821777e-22,
  1.593192561293537e-23, -5.115718945355326e-26,  1.155902555005673e+00, -4.931944810279218e-03, -1.041212981371343e-06,  8.284252810728189e-08, -4.713522588662110e-11,
 -2.464185101846953e-12,  4.738858159720590e-15,  8.466439405142663e-17, -3.133456897154348e-19, -3.023084276424482e-21,  1.809462397031945e-23,  1.025695805948098e-25,
  1.282902676341856e+00, -4.895366554142473e-03, -6.087542937995257e-06,  8.509583269966256e-08,  1.927271644702257e-10, -2.802704492608541e-12, -7.308784257312238e-15,
  1.142702657385543e-16,  3.014356761413213e-19, -5.236057191431565e-21, -1.333376676215138e-23,  2.549148759682610e-25,  1.411597693449408e+00, -4.669168517947436e-03,
 -1.143240490089636e-05,  6.976024721786346e-08,  4.621467692653414e-10, -1.772242219139439e-12, -2.181294988307248e-14,  4.460180174286220e-17,  1.100798030934960e-18,
 -5.369207554523854e-22, -5.768279279527929e-23, -6.123328337519819e-26,  1.539250555486980e+00, -4.223236096624044e-03, -1.620654621262144e-05,  3.312035923542175e-08,
  6.377376160658719e-10,  8.918152831377000e-13, -2.542187061568256e-14, -1.328200489748482e-16,  8.416946287910109e-19,  1.018289629165786e-20, -1.085222101102111e-23,
 -6.308371934551883e-25,  1.662088028521703e+00, -3.546873699039415e-03, -1.915282322030150e-05, -2.043812415465693e-08,  5.546489860094190e-10,  3.940090756521188e-12,
 -4.439507692101341e-15, -2.324902743783119e-16, -1.116662234741804e-18,  6.950349323541908e-21,  1.093576859721252e-22,  2.265308472222776e-25,  1.775095155815681e+00,
 -2.669857094136389e-03, -1.890443690794795e-05, -7.262891262721575e-08,  1.447759191241770e-10,  4.397487818136553e-12,  2.806059521601792e-14, -1.251750984817715e-17,
 -1.763855941803594e-18, -1.431986128385954e-20, -1.082874283212589e-23,  8.520766722734505e-25,  1.871998736271025e+00, -1.687801065024599e-03, -1.477075666484148e-05,
 -9.395390330833922e-08, -3.555936535357276e-10,  7.254129438027634e-13,  2.610107133918421e-14,  2.389101137656983e-16,  1.042038442062762e-18, -3.516793290346315e-21,
 -1.083803142714114e-22, -1.003351744204631e-24,  1.945701942178568e+00, -7.755709647272803e-04, -7.906050007032053e-06, -6.676300525976271e-08, -4.760604671677609e-10,
 -2.726870080395494e-12, -9.823656612372992e-15,  2.439105412752574e-17,  8.916187262295265e-19,  1.033794713706111e-20,  8.252785366465385e-23,  4.475540851217806e-25,
  1.989437942923179e+00, -1.582195697920770e-04, -1.761172592517027e-06, -1.721341662995868e-08, -1.552940570701369e-10, -1.319128455993430e-12, -1.063263014959298e-14,
 -8.139811406133691e-17, -5.889179040435805e-19, -3.975482552969476e-21, -2.434276977894958e-23, -1.259891054179236e-25,  9.260113982379023e-04, -6.341692591641464e-06,
  3.255753053741371e-08, -1.485567377373134e-10,  6.348450188739324e-13, -2.605256297165387e-15,  1.036711846488388e-17, -4.053766138922299e-20,  1.545399451361784e-22,
 -5.927422364685830e-25,  2.145524431973593e-27, -8.620694822584403e-30,  8.335361094867638e-03, -5.699088178274451e-05,  2.914267228321831e-07, -1.320187570222811e-09,
  5.577535437250118e-12, -2.251102640448723e-14,  8.753180402308269e-17, -3.320088527251142e-19,  1.215318548458205e-21, -4.441733147115922e-24,  1.494646519580295e-26,
 -5.701121020032659e-29,  2.316070510608587e-02, -1.578352118501098e-04,  8.006325478735779e-07, -3.573658995706014e-09,  1.474202571280239e-11, -5.741567584095060e-14,
  2.120598651416088e-16, -7.487967220039383e-19,  2.470964814625628e-21, -7.875529142951878e-24,  2.053380722535952e-26, -6.399484062546871e-29,  4.541500131297484e-02,
 -3.079463018207026e-04,  1.542884155325817e-06, -6.729122407944502e-09,  2.671061308098757e-11, -9.792976945054601e-14,  3.291028084895135e-16, -1.001109727403925e-18,
  2.517788860218139e-21, -4.637436163882735e-24, -6.691214762997199e-27,  6.467827602995323e-29,  7.511682224640044e-02, -5.058797010064778e-04,  2.491679595504598e-06,
 -1.051639488875021e-08,  3.942146855282635e-11, -1.310693162279519e-13,  3.683936295788320e-16, -7.584776275545860e-19,  2.524252022192762e-23,  9.539373034934389e-24,
 -7.451158452756127e-26,  3.027322675735655e-28,  1.122892130457431e-01, -7.496092877615059e-04,  3.610625040027493e-06, -1.457524879558487e-08,  5.025945069476110e-11,
 -1.416844731712476e-13,  2.588989519507702e-16,  2.323309538767547e-19, -5.472611969514008e-21,  3.241431943044475e-23, -1.512283375633143e-25,  4.219108114327642e-28,
  1.569579801646274e-01, -1.036434000210972e-03,  4.852529781286155e-06, -1.845726762653714e-08,  5.620045770599612e-11, -1.145384880965986e-13, -5.154533197790836e-17,
  2.006184759693449e-18, -1.278633887540968e-20,  5.204257743114476e-23, -1.606713762789134e-25,  5.306240008408833e-29,  2.091492194735977e-01, -1.362851482624046e-03,
  6.158293346463591e-06, -2.163089077851577e-08,  5.403185886026452e-11, -3.716416142866108e-14, -5.722594467167801e-16,  4.238029421381718e-18, -1.856985389333549e-20,
  4.740566763217779e-23, -1.001503117952594e-26, -1.039635783643257e-27,  2.688858020363016e-01, -1.724391343345082e-03,  7.455627869532417e-06, -2.349219520364775e-08,
  4.067995999342509e-11,  9.639224649271744e-14, -1.243389606424647e-15,  6.141508039654375e-18, -1.752702550298873e-20, -4.322804222284112e-24,  3.394931880079252e-25,
 -2.505983119239330e-27,  3.361824076387272e-01, -2.115398548379760e-03,  8.657710587546072e-06, -2.338533803930500e-08,  1.368441628897139e-11,  2.809231040555826e-13,
 -1.911765743166661e-15,  6.474501990057610e-18, -3.857074356333199e-21, -1.118530251995760e-22,  7.687799437714409e-25, -3.025372332354974e-27,  4.110385109612150e-01,
 -2.528755126362142e-03,  9.661956179436474e-06, -2.063859675251615e-08, -2.813357846082712e-11,  4.947372083443483e-13, -2.317931697356639e-15,  3.750901662524086e-18,
  2.554629575250443e-20, -2.464244061907437e-22,  9.160168077570410e-25, -5.379324463985502e-28,  4.934284545122969e-01, -2.955526210702694e-03,  1.034926740106963e-05,
 -1.462478640293733e-08, -8.376429820378463e-11,  6.944277666135410e-13, -2.110322684961639e-15, -3.214668101154373e-18,  6.602206901162811e-20, -3.200338978873631e-22,
  2.277057308378007e-25,  6.153114955072108e-27,  5.832873434874443e-01, -3.384515453339551e-03,  1.058441611780974e-05, -4.858593500721210e-09, -1.488443834125156e-10,
  8.115371523159227e-13, -9.120930018100846e-16, -1.431562945664943e-17,  9.931814404994463e-20, -1.883777890588566e-22, -1.676638688122717e-24,  1.407668727017543e-26,
  6.804909078682707e-01, -3.801717211395204e-03,  1.021870736245609e-05,  8.852317239699173e-09, -2.142959499752765e-10,  7.547742500325947e-13,  1.524547035734466e-15,
 -2.674085166605016e-17,  9.090045560060987e-20,  2.804654152224441e-22, -4.201522833868228e-24,  1.285753501117679e-26,  7.848266068870846e-01, -4.189663397034319e-03,
  9.096910085562628e-06,  2.618236691394598e-08, -2.650319552695355e-10,  4.243464241582290e-13,  5.042834371475881e-15, -3.359652217721252e-17, -1.078772982729891e-21,
  1.027121856364831e-21, -4.828843236555572e-24, -1.201425496230140e-26,  8.959519813830120e-01, -4.526691435466397e-03,  7.071762037693352e-06,  4.597219227984800e-08,
 -2.794162394140185e-10, -2.514173890950674e-13,  8.691220999910953e-15, -2.397931193962358e-17, -1.921167365984250e-19,  1.533622629635568e-21,  5.603088843277973e-25,
 -5.860195030174341e-26,  1.013334456902790e+00, -4.786226469945437e-03,  4.031309209811567e-06,  6.582664281843100e-08, -2.309714123806570e-10, -1.245264942986735e-12,
  1.036465711479749e-14,  1.253377307306294e-17, -4.054705631042495e-19,  7.293529315229707e-22,  1.320175073084180e-23, -7.139120147365840e-26,  1.136164389406185e+00,
 -4.936314595061764e-03, -5.323182049016705e-08,  8.170105873068075e-08, -9.509584680352203e-11, -2.323233690537184e-12,  6.953764215325163e-15,  7.304368990946213e-17,
 -4.081927909002365e-19, -2.223593675119760e-21,  2.151093244561746e-23,  5.202354534132456e-26,  1.263230345040846e+00, -4.939934192446299e-03, -5.049768780407235e-06,
  8.772260915849193e-08,  1.351830138579818e-10, -2.938807815533289e-12, -4.003115973431024e-15,  1.208196398574827e-16,  1.060983346924203e-19, -5.539199005656904e-21,
 -1.738432282615375e-24,  2.665541960791995e-25,  1.392743576360906e+00, -4.757156437576755e-03, -1.055217633043764e-05,  7.684308852131615e-08,  4.215884114578297e-10,
 -2.276820188692183e-12, -2.007704029073157e-14,  7.907010589032050e-17,  1.039686784815002e-18, -2.854149056273344e-21, -5.707220631729872e-23,  9.028396839570601e-26,
  1.522101069908152e+00, -4.351124090305257e-03, -1.574740118826042e-05,  4.343249602661635e-08,  6.491885885704617e-10,  2.404407816298525e-13, -2.870956054450951e-14,
 -1.001596960123918e-16,  1.193608024951479e-18,  9.176498641855507e-21, -3.972899720775708e-23, -6.663325648503065e-25,  1.647592756076623e+00, -3.700920510182875e-03,
 -1.934225891543099e-05, -1.094139766808911e-08,  6.318382554611684e-10,  3.751649758195041e-12, -1.140577788178015e-14, -2.633614760568922e-16, -7.861032184953022e-19,
  1.143521304140803e-20,  1.124784051794477e-22, -1.035416607578708e-25,  1.764107801355929e+00, -2.824532477324161e-03, -1.975906511650747e-05, -6.957254888462379e-08,
  2.393968396957294e-10,  5.059880738088157e-12,  2.684226176268922e-14, -7.721234866818733e-17, -2.277057598442807e-18, -1.388500964958194e-20,  3.550543053098342e-23,
  1.253561018231093e-24,  1.865003924606042e+00, -1.810572291858919e-03, -1.593174509798638e-05, -9.949095949093280e-08, -3.342604282121662e-10,  1.435731369912881e-12,
  3.323187341587032e-14,  2.693033880680887e-16,  8.262755134360373e-19, -8.786967532146497e-21, -1.562448921406794e-22, -1.155031661494982e-24,  1.942467899156145e+00,
 -8.421577041471963e-04, -8.754748320204262e-06, -7.482878715234391e-08, -5.328820195675081e-10, -2.950850731160359e-12, -8.680545770113839e-15,  5.955347197732839e-17,
  1.327994620606533e-18,  1.403667548339972e-20,  1.023607835665514e-22,  4.399475263926168e-25,  1.988775515268061e+00, -1.731795336777713e-04, -1.983559571956206e-06,
 -1.992386203013359e-08, -1.844246605625206e-10, -1.603930107149274e-12, -1.319853219233393e-14, -1.027324756955585e-16, -7.509495384826422e-19, -5.065633670713496e-21,
 -3.029092600292189e-23, -1.431577575714472e-25,  9.011544967157701e-04, -6.088194266943755e-06,  3.083411809712704e-08, -1.388029158320218e-10,  5.851388684181275e-13,
 -2.369526434585910e-15,  9.298203811921968e-18, -3.591796115598703e-20,  1.346575968227063e-22, -5.141828724380955e-25,  1.789731686696361e-27, -7.621038878371199e-30,
  8.111962158623530e-03, -5.472135340438690e-05,  2.761054193984634e-07, -1.234437709492222e-09,  5.147591645582135e-12, -2.051756723459813e-14,  7.875677494393784e-17,
 -2.955665140915835e-19,  1.065588549115063e-21, -3.892382292447729e-24,  1.255721367814040e-26, -5.206211850259508e-29,  2.254190832946531e-02, -1.515977627779270e-04,
  7.591268566904110e-07, -3.346703537465708e-09,  1.364295337856301e-11, -5.256915620867000e-14,  1.921590248583351e-16, -6.741091857013715e-19,  2.201544162851669e-21,
 -7.111350722803256e-24,  1.764693182238648e-26, -6.791232676937587e-29,  4.420740090295368e-02, -2.959191072786680e-04,  1.464635636117777e-06, -6.317001580458521e-09,
  2.482877824067026e-11, -9.035872657187228e-14,  3.021742683518319e-16, -9.232584150351075e-19,  2.346606054264528e-21, -4.859531980986165e-24, -4.698282110394366e-27,
  2.547841405757899e-29,  7.313238594895988e-02, -4.864405246978129e-04,  2.369182348449551e-06, -9.906149312406535e-09,  3.688677821747863e-11, -1.224823289542680e-13,
  3.472152342504856e-16, -7.527258450958527e-19,  3.179961499624905e-22,  6.800496315735719e-24, -6.305229949265628e-26,  2.174322557272086e-28,  1.093474571948971e-01,
 -7.214104419703107e-04,  3.440454548799711e-06, -1.379342762677266e-08,  4.748832606051624e-11, -1.354115867263730e-13,  2.631197944586699e-16,  7.474540766475171e-20,
 -4.410327611834614e-21,  2.671194329804244e-23, -1.345350898444246e-25,  3.332243145970842e-28,  1.528885032389467e-01, -9.984845987259365e-04,  4.636362050807801e-06,
 -1.757643538766299e-08,  5.390163532533463e-11, -1.151460464647559e-13, -8.275982409708017e-19,  1.625763161969216e-18, -1.102785000898750e-20,  4.566999109999713e-23,
 -1.578809313061645e-25,  6.346860145400989e-29,  2.037947229568339e-01, -1.314608783086333e-03,  5.903882877376960e-06, -2.077303437078833e-08,  5.316050485639299e-11,
 -4.953998685634354e-14, -4.616584070326731e-16,  3.670937086765348e-18, -1.688086713385913e-20,  4.615660664445237e-23, -5.097872385462614e-26, -8.395533845791460e-28,
  2.621057571033520e-01, -1.665862744541624e-03,  7.177685327058794e-06, -2.282745713840566e-08,  4.232299252710506e-11,  6.855100959474672e-14, -1.079285417959992e-15,
  5.580564425553140e-18, -1.746389017962108e-20,  7.148750081951677e-24,  2.363344063479542e-25, -2.197809883046469e-27,  3.278575653266730e-01, -2.047255226632576e-03,
  8.378577736699145e-06, -2.312387128384582e-08,  1.885865164449600e-11,  2.371986967652794e-13, -1.732772201105258e-15,  6.292322622618014e-18, -7.362375987095672e-21,
 -8.376702245821431e-23,  6.355379799102316e-25, -3.024438350140404e-27,  4.010765033849303e-01, -2.452457049357398e-03,  9.411909031833153e-06, -2.101256136946998e-08,
 -1.878618731537397e-11,  4.404515802436942e-13, -2.202745302156115e-15,  4.433449323714416e-18,  1.732602215393189e-20, -2.105635384819418e-22,  8.698880908601826e-25,
 -1.519895120965439e-27,  4.817707956675930e-01, -2.873455807614003e-03,  1.016617792635330e-05, -1.585668503644807e-08, -7.038832226852699e-11,  6.429280590847960e-13,
 -2.172472130947114e-15, -1.284055133919288e-18,  5.472380016997293e-20, -3.061936444760306e-22,  4.478006800515345e-25,  3.886452762935597e-27,  5.699182075384143e-01,
 -3.300112597398840e-03,  1.051235533982517e-05, -7.111576968335505e-09, -1.328631826580693e-10,  7.851893035503561e-13, -1.269541042109159e-15, -1.125772305344344e-17,
  9.147304559491999e-20, -2.436766740197899e-22, -1.104556977009140e-24,  1.184851854432109e-26,  6.654481303542802e-01, -3.719599770833101e-03,  1.030486666771745e-05,
  5.546085378461781e-09, -1.988934877334843e-10,  7.827153466567380e-13,  8.178198217288269e-16, -2.370177975231750e-17,  9.811414889727695e-20,  1.243183910239820e-22,
 -3.594280665991472e-24,  1.444675099115076e-26,  7.682153928502036e-01, -4.115702765287036e-03,  9.385955917242917e-06,  2.201600742873444e-08, -2.554108235523341e-10,
  5.341149277495465e-13,  4.106936322324829e-15, -3.307756177056818e-17,  3.231939408851618e-20,  8.262175230495121e-22, -5.150123939512387e-24, -2.927049643292929e-27,
  8.779617500119995e-01, -4.467986984856793e-03,  7.596474509898642e-06,  4.147239889163027e-08, -2.824164528623837e-10, -5.152878050408663e-14,  7.942034451599338e-15,
 -2.924421663369669e-17, -1.370963914152431e-19,  1.507566260722910e-21, -1.782261059736068e-24, -4.753048384149445e-26,  9.942589637178938e-01, -4.750880946142718e-03,
  4.798277836769987e-06,  6.194546663080889e-08, -2.533682286500990e-10, -9.937402577922045e-13,  1.053858903034622e-14,  7.435223322440787e-20, -3.705018664046235e-19,
  1.190752940814003e-21,  9.790034460231922e-24, -8.214235807171053e-26,  1.116424447502997e+00, -4.932848133938491e-03,  9.165495555871856e-07,  7.981754343221850e-08,
 -1.397338743636900e-10, -2.133344629184119e-12,  8.805288463613706e-15,  5.887035635224555e-17, -4.723418795149077e-19, -1.332645967041206e-21,  2.266216239980473e-23,
  7.328936126760806e-28,  1.243396524874042e+00, -4.976089382842209e-03, -3.986073269269583e-06,  8.941126281188119e-08,  7.572132960481852e-11, -2.994087719278794e-12,
 -6.025758680845820e-16,  1.210335309805381e-16, -9.177067243715578e-20, -5.378224620343071e-21,  9.628395558601539e-24,  2.448295982319358e-25,  1.373552112981857e+00,
 -4.837774334775504e-03, -9.591172070791896e-06,  8.319885043051528e-08,  3.714318191959644e-10, -2.728452543555263e-12, -1.741582738136463e-14,  1.102659411431052e-16,
  8.972087335318234e-19, -5.013197930942058e-21, -4.980919336184743e-23,  2.369311803921817e-25,  1.504448165456108e+00, -4.474841842868723e-03, -1.516385411983866e-05,
  5.381967462324603e-08,  6.469035044613282e-10, -4.776333721023638e-13, -3.093214872469884e-14, -5.704207467085825e-17,  1.488384908283689e-18,  7.012769418278793e-21,
 -6.797105822080080e-23, -5.994685675493179e-25,  1.632479016354092e+00, -3.856006315348388e-03, -1.941047826651633e-05, -2.491479221488219e-10,  7.035235955345493e-10,
  3.386990159806050e-12, -1.906408139962233e-14, -2.810777290867499e-16, -2.956291062541762e-19,  1.572349312977845e-20,  9.883713941809722e-23, -5.279424465351841e-25,
  1.752488341240712e+00, -2.985871450507142e-03, -2.056750308123754e-05, -6.489850521667853e-08,  3.468170107295574e-10,  5.669468555937633e-12,  2.358766073383299e-14,
 -1.576872601168527e-16, -2.737047758610288e-18, -1.125162637223496e-20,  9.870962311659173e-23,  1.601053630921290e-24,  1.857499041095731e+00, -1.942890260750421e-03,
 -1.715663053338832e-05, -1.045634616240691e-07, -2.969453350581783e-10,  2.326432185097377e-12,  4.108580368612462e-14,  2.893762514944462e-16,  3.850584343077260e-19,
 -1.606587542991021e-20, -2.076284940641345e-22, -1.142814229998064e-24,  1.938953294749646e+00, -9.159369720488828e-04, -9.705832897315795e-06, -8.383769540674663e-08,
 -5.938203931319099e-10, -3.133875752704635e-12, -6.336293836882788e-15,  1.109611160285397e-16,  1.911454841871592e-18,  1.849137111664919e-20,  1.194206697066830e-22,
  3.073343067479250e-25,  1.988049471786319e+00, -1.900570739919935e-04, -2.241467822964167e-06, -2.314952541168173e-08, -2.199186879175792e-10, -1.958105597419348e-12,
 -1.644062158262347e-14, -1.299270083218212e-16, -9.566651353431058e-19, -6.405766621154316e-21, -3.674304501467578e-23, -1.466020234545090e-25,  8.772847365579423e-04,
 -5.848028228923057e-06,  2.922313091299896e-08, -1.298080267021196e-10,  5.399008923539422e-13, -2.157967681983853e-15,  8.350139514679651e-18, -3.189191422717387e-20,
  1.173566413272870e-22, -4.491057972957360e-25,  1.468001240557420e-27, -7.091243796819871e-30,  7.897402550832211e-03, -5.257039344749579e-05,  2.617731192318270e-07,
 -1.155259101181202e-09,  4.755490958576380e-12, -1.872298793677690e-14,  7.093789609609298e-17, -2.636171817395013e-19,  9.339592034369765e-22, -3.435161632705684e-24,
  1.031526706078516e-26, -5.051853498503260e-29,  2.194741409414986e-02, -1.456817571193191e-04,  7.202422366051220e-07, -3.136583050312240e-09,  1.263619969663568e-11,
 -4.817611134309496e-14,  1.742327096201925e-16, -6.076256513939885e-19,  1.957500746181485e-21, -6.467586574628081e-24,  1.446909357169351e-26, -7.791233108047597e-29,
  4.304668790824107e-02, -2.844986196661744e-04,  1.391156795835108e-06, -5.933813128455226e-09,  2.309207474638616e-11, -8.340843653504086e-14,  2.773477629012930e-16,
 -8.510009381327749e-19,  2.168435671711702e-21, -5.037772557245512e-24, -4.547824506133943e-27, -2.057978135738351e-29,  7.122379182312653e-02, -4.679527111405527e-04,
  2.253770296185471e-06, -9.335112407426955e-09,  3.451876295306704e-11, -1.144007200993014e-13,  3.263148073195841e-16, -7.391025287557601e-19,  5.194780222834042e-22,
  4.442725323793635e-24, -5.553528450321254e-26,  1.211484441653781e-28,  1.065158323662604e-01, -6.945361768753647e-04,  3.279404037628714e-06, -1.305493671979051e-08,
  4.484333381654594e-11, -1.290866928577906e-13,  2.633741562903988e-16, -5.201080199300087e-20, -3.542317269611241e-21,  2.159165424091612e-23, -1.223415969479677e-25,
  2.144328472501941e-28,  1.489674312953232e-01, -9.622228849282828e-04,  4.430543423864535e-06, -1.673241889021401e-08,  5.160200320314978e-11, -1.146580533906552e-13,
  3.999179850288071e-17,  1.297963889877510e-18, -9.496830472019670e-21,  3.939864832401037e-23, -1.561248475217980e-25,  2.746260950905141e-30,  1.986291915095497e-01,
 -1.268360445102634e-03,  5.659675319844621e-06, -1.993096082491578e-08,  5.206692377564463e-11, -5.944587544354255e-14, -3.661882108015194e-16,  3.156871942699080e-18,
 -1.526451082856086e-20,  4.341263929259479e-23, -8.561064938690537e-26, -7.566258074078274e-28,  2.555554305818792e-01, -1.609525372700844e-03,  6.907859675879782e-06,
 -2.214067649013015e-08,  4.344731580542159e-11,  4.446037820538004e-14, -9.308028146793146e-16,  5.027477160455916e-18, -1.705905345348234e-20,  1.473494027926070e-23,
  1.443778700214355e-25, -2.006381584721907e-27,  3.198008519486488e-01, -1.981331074850051e-03,  8.103051106209346e-06, -2.278638121107067e-08,  2.320088244503253e-11,
  1.976971445338340e-13, -1.560305386028875e-15,  6.013122994311021e-18, -9.952453296066384e-21, -6.100556927449573e-23,  5.024698506936903e-25, -3.035347220554522e-27,
  3.914156624228679e-01, -2.378174838852857e-03,  9.158236332909264e-06, -2.124549724732209e-08, -1.049546459038846e-11,  3.891312152551930e-13, -2.071939185653626e-15,
  4.873167231868790e-18,  1.035367667883313e-20, -1.773520662834332e-22,  7.847847014194707e-25, -2.332783294728882e-27,  4.704384004119659e-01, -2.792905691909797e-03,
  9.969555557862095e-06, -1.688287140020706e-08, -5.805308670320965e-11,  5.905451126365989e-13, -2.185540132793035e-15,  2.944928946199284e-19,  4.405875998314310e-20,
 -2.854849977792213e-22,  5.724780113083510e-25,  1.803806998112879e-27,  5.568853648942947e-01, -3.216390066936497e-03,  1.041477413432625e-05, -9.113514413073175e-09,
 -1.174879449325247e-10,  7.512601040344599e-13, -1.545151247124444e-15, -8.478495132112293e-18,  8.202427303549139e-20, -2.781811602536488e-22, -6.398348941189162e-25,
  9.217567430998311e-27,  6.507349558409752e-01, -3.636947528860124e-03,  1.035284536296745e-05,  2.489871252674384e-09, -1.830948120874309e-10,  7.947371793616997e-13,
  1.986073497689408e-16, -2.051701675028003e-17,  1.001559039255983e-19, -6.654797982638769e-24, -2.955169521438147e-24,  1.434088050488268e-26,  7.519043333348405e-01,
 -4.039626976241523e-03,  9.625997576265890e-06,  1.801993562746393e-08, -2.438171647693692e-10,  6.217102637489571e-13,  3.199430911779160e-15, -3.160731671127130e-17,
  5.834428445658173e-20,  6.198194199828760e-22, -5.120186199162370e-24,  3.876625551245382e-27,  8.602143890988965e-01, -4.405301343361021e-03,  8.067030074501218e-06,
  3.695556076660824e-08, -2.816096174491497e-10,  1.288078074032068e-13,  7.069815410029675e-15, -3.278057936423883e-17, -8.457874425699746e-20,  1.398025521244813e-21,
 -3.605615731198415e-24, -3.531830805284053e-26,  9.753368210616776e-01, -4.709591678503279e-03,  5.516688677887636e-06,  5.774629598811158e-08, -2.707203503925281e-10,
 -7.420867387842575e-13,  1.038162789170948e-14, -1.102740601188682e-17, -3.214687177040947e-19,  1.508896179854771e-21,  6.102748379299966e-24, -8.414819133046698e-26,
  1.096713728057614e+00, -4.921725668452447e-03,  1.859576267166103e-06,  7.725247760861552e-08, -1.801629722450232e-10, -1.903983343013253e-12,  1.023608048814442e-14,
  4.316197467267272e-17, -5.041216969168869e-19, -4.395899895036810e-22,  2.165581256318382e-23, -4.517049023678888e-26,  1.223435208503683e+00, -5.003670182609690e-03,
 -2.907844382047760e-06,  9.014410829953754e-08,  1.596699820067976e-11, -2.968389851892061e-12,  2.716791166494278e-15,  1.150936698380542e-16, -2.759736460236519e-19,
 -4.790700934822570e-21,  1.937767369301306e-23,  1.941522095856538e-25,  1.354054016985021e+00, -4.910413426420260e-03, -8.558999750293859e-06,  8.868360272603805e-08,
  3.129490639847033e-10, -3.106318696908231e-12, -1.395617503185841e-14,  1.357271696238985e-16,  6.837281947770243e-19, -6.759736470450530e-21, -3.666466299877693e-23,
  3.537245704873095e-25,  1.486310513834840e+00, -4.593394364045171e-03, -1.445636242790928e-05,  6.405293041439034e-08,  6.298264824195870e-10, -1.233575799683869e-12,
 -3.182860527502566e-14, -5.948262244699854e-18,  1.685933123163407e-18,  3.810095665975735e-21, -9.089535537160807e-23, -4.257849608523684e-25,  1.616744681226066e+00,
 -4.011105768787547e-03, -1.934378223213692e-05,  1.152160033353555e-08,  7.660473249479104e-10,  2.834490126940284e-12, -2.697646683231951e-14, -2.807715944463320e-16,
  3.347555521032574e-19,  1.907774491865921e-20,  6.554825661531345e-23, -9.832284801831274e-25,  1.740210987884096e+00, -3.153423459945544e-03, -2.130915376755500e-05,
 -5.841324350866987e-08,  4.654571579927724e-10,  6.172348794372954e-12,  1.789157900241699e-14, -2.508495636048419e-16, -3.053417721288048e-18, -5.827276129742420e-21,
  1.737348860051927e-22,  1.767051206715432e-24,  1.849444918231508e+00, -2.085239222297515e-03, -1.843818226191529e-05, -1.088860094607108e-07, -2.398950813387825e-10,
  3.410520167577382e-12,  4.926191526509182e-14,  2.907464015362000e-16, -3.543661650529218e-19, -2.531027596229563e-20, -2.522734908219393e-22, -8.217440181416266e-25,
  1.935127647502332e+00, -9.977741751481873e-04, -1.077098391891635e-05, -9.384731543745683e-08, -6.577285055531102e-10, -3.241103421198148e-12, -2.266272393953850e-15,
  1.837223007992621e-16,  2.665636469622036e-18,  2.345237266791890e-20,  1.259736259361359e-22, -5.989954460477132e-26,  1.987251532085178e+00, -2.091629336874760e-04,
 -2.541739652468070e-06, -2.700426185729017e-08, -2.633400437989324e-10, -2.400018822010553e-12, -2.054392596451305e-14, -1.645260170726622e-16, -1.215237667737300e-18,
 -7.998988711774475e-21, -4.270030238733135e-23, -1.161050215407471e-25,  8.543505314115151e-04, -5.620330324703526e-06,  2.771587527895549e-08, -1.215042948353770e-10,
  4.986753725303591e-13, -1.967870204133551e-15,  7.507388407401630e-18, -2.838446172720071e-20,  1.021708793109298e-22, -3.966056413693986e-25,  1.156137201421994e-27,
 -7.216456142376559e-30,  7.691223336588052e-03, -5.053039530713078e-05,  2.483544729052272e-07, -1.082076871209557e-09,  4.397475390092434e-12, -1.710578813528965e-14,
  6.395698007623707e-17, -2.356338828524032e-19,  8.171798378772813e-22, -3.067625065966940e-24,  8.034942451749548e-27, -5.422825611088891e-29,  2.137597731872719e-02,
 -1.400670099463764e-04,  6.837852393927967e-07, -2.941890493493987e-09,  1.171315090793459e-11, -4.419182152396154e-14,  1.580619052405840e-16, -5.486062591437300e-19,
  1.734212732418643e-21, -5.962693144509772e-24,  1.061710926814915e-26, -9.983201972008718e-29,  4.193050967162965e-02, -2.736480317561180e-04,  1.322113977616784e-06,
 -5.577331583493893e-09,  2.148857921650256e-11, -7.703035437094589e-14,  2.544636659565014e-16, -7.845506319618405e-19,  1.983429414103072e-21, -5.255031619080043e-24,
 -6.787946589278716e-27, -8.582842055652087e-29,  6.938734486414627e-02, -4.503614162224472e-04,  2.144988603277972e-06, -8.800697801602021e-09,  3.230739810032708e-11,
 -1.068154920643760e-13,  3.058737006849444e-16, -7.203405240084643e-19,  6.404085757672927e-22,  2.293667958437437e-24, -5.284031744190670e-26, -6.089693017345516e-30,
  1.037891829121274e-01, -6.689155781339173e-04,  3.126965670424518e-06, -1.235775452640522e-08,  4.232462852372094e-11, -1.227953128896023e-13,  2.604411099308866e-16,
 -1.538568552013302e-19, -2.851241753069688e-21,  1.684047740554437e-23, -1.164898720715798e-25,  3.891735531415671e-29,  1.451881763724494e-01, -9.275678317817614e-04,
  4.234632716410720e-06, -1.592506822304989e-08,  4.932121187663735e-11, -1.132952074666874e-13,  7.228483060803868e-17,  1.015551708793369e-18, -8.191201255939502e-21,
  3.311689336998995e-23, -1.591540431755245e-25, -1.618396054756447e-28,  1.936448096520724e-01, -1.224025659775046e-03,  5.425461513337175e-06, -1.910784981538143e-08,
  5.079700165526481e-11, -6.722746116823813e-14, -2.844044383789761e-16,  2.692686942257056e-18, -1.377137963482398e-20,  3.931310013411136e-23, -1.199353692736178e-25,
 -8.361597696105975e-28,  2.492261889176954e-01, -1.555313370168285e-03,  6.646368040571644e-06, -2.143957278517747e-08,  4.412421642397541e-11,  2.374918318570014e-14,
 -7.975892112730955e-16,  4.491018026014358e-18, -1.644573518104903e-20,  1.876145716295411e-23,  5.694930399635246e-26, -2.008228663602146e-27,  3.120034539909915e-01,
 -1.917593814096242e-03,  7.831965860577317e-06, -2.238551361426221e-08,  2.679379568743615e-11,  1.622323394270372e-13, -1.396700667441007e-15,  5.663121636894593e-18,
 -1.181930250003386e-20, -4.360699539083201e-23,  3.663694996261522e-25, -3.187947156986412e-27,  3.820478769187248e-01, -2.305931012665040e-03,  8.902531004293295e-06,
 -2.135381850237118e-08, -3.198884119249908e-12,  3.410738098259967e-13, -1.931769921581981e-15,  5.108174026772381e-18,  4.507199946260678e-21, -1.482463847700985e-22,
  6.645724646798952e-25, -3.150672970940152e-27,  4.594249863027995e-01, -2.713974536575876e-03,  9.761768547086991e-06, -1.772007796394988e-08, -4.676526251435106e-11,
  5.383410803609820e-13, -2.159068818549278e-15,  1.544473060367613e-18,  3.420720070180681e-20, -2.615930108653741e-22,  6.073547318522845e-25, -2.279787419548663e-28,
  5.441857047588038e-01, -3.133540150829371e-03,  1.029462221564685e-05, -1.087521029176634e-08, -1.028513153580080e-10,  7.116148882077910e-13, -1.747338622131827e-15,
 -6.018147447133590e-18,  7.163910310730477e-20, -2.965151982615640e-22, -2.986464470581734e-25,  6.224685246513213e-27,  6.363529317667714e-01, -3.554053845185316e-03,
  1.036567156346966e-05, -3.124176249025158e-10, -1.671970674291797e-10,  7.929711950641246e-13, -3.311908911034817e-16, -1.733746098819115e-17,  9.793746235261199e-20,
 -1.126162608756970e-22, -2.354880215997038e-24,  1.269622497314418e-26,  7.359011185586607e-01, -3.961819386362512e-03,  9.819253386663892e-06,  1.422220983549859e-08,
 -2.306856087559311e-10,  6.881067345478750e-13,  2.343639306124720e-15, -2.942238876164131e-17,  7.702567596996164e-20,  4.198469769938033e-22, -4.848222915324371e-24,
  8.019621297924583e-27,  8.427249570228362e-01, -4.339067579550468e-03,  8.483576291823381e-06,  3.247931818764867e-08, -2.774124390799973e-10,  2.872087032275632e-13,
  6.121419005653883e-15, -3.471250039487848e-17, -3.718837787708726e-20,  1.226217270398430e-21, -4.900839287815004e-24, -2.381821973017764e-26,  9.565910047513083e-01,
 -4.662761023430604e-03,  6.183208815099966e-06,  5.330944890993387e-08, -2.831012936894164e-10, -4.977436107963417e-13,  9.937302875937096e-15, -2.040535802359987e-17,
 -2.636384166412820e-19,  1.679958927719732e-21,  2.485599353166190e-24, -7.935966629808831e-26,  1.077062376905781e+00, -4.903192749146630e-03,  2.768098004819498e-06,
  7.407895854319486e-08, -2.156975500865068e-10, -1.645646646545122e-12,  1.121755614922696e-14,  2.693947013928344e-17, -5.049396105171951e-19,  3.754152947387046e-22,
  1.882974048516505e-23, -8.148908466537822e-26,  1.203380853433568e+00, -5.022606161020159e-03, -1.826526965947533e-06,  8.992925634293168e-08, -4.249354939592263e-11,
 -2.865666928494235e-12,  5.791008110994422e-15,  1.036682138969269e-16, -4.326061964668657e-19, -3.864533874515477e-21,  2.641142636514953e-23,  1.230279319930954e-25,
  1.334282273043604e+00, -4.974548322602121e-03, -7.466858897523111e-06,  9.317691153648476e-08,  2.477928262509839e-10, -3.393424401018119e-12, -9.887921973637600e-15,
  1.534617549032811e-16,  4.179535062182817e-19, -7.891293731860921e-21, -1.942765894202997e-23,  4.201990530291301e-25,  1.467710741644325e+00, -4.705801554523305e-03,
 -1.362821241234392e-05,  7.389133192658962e-08,  5.975345609672177e-10, -1.993263788165589e-12, -3.122443306651381e-14,  4.946203625371106e-17,  1.753779353992329e-18,
 -1.287684818277667e-22, -1.041425259667286e-22, -1.648794271767536e-25,  1.600391932815384e+00, -4.165090558229076e-03, -1.913023290299500e-05,  2.419405575974572e-08,
  8.156349930505860e-10,  2.094576601916024e-12, -3.458177174622192e-14, -2.586567530681843e-16,  1.057185450466623e-18,  2.071091439104470e-20,  1.324522497301476e-23,
 -1.374838705683261e-24,  1.727252099457977e+00, -3.326564400549842e-03, -2.196128648595729e-05, -4.995761126748369e-08,  5.925714879567560e-10,  6.506277950308863e-12,
  9.478763566859530e-15, -3.504227771386037e-16, -3.119502830401386e-18,  2.657405431696622e-21,  2.493049668035980e-22,  1.600874600966457e-24,  1.840800590346700e+00,
 -2.238030845362876e-03, -1.976537779514743e-05, -1.121116766241023e-07, -1.592128592395024e-10,  4.688302430775483e-12,  5.709283725886917e-14,  2.628206237946568e-16,
 -1.454179369478062e-18, -3.592921335033638e-20, -2.728583928516980e-22, -2.086656086395359e-26,  1.930956823587427e+00, -1.088630556047545e-03, -1.196243712275860e-05,
 -1.048905705111488e-07, -7.226245456547233e-10, -3.223309754785322e-12,  4.205933324005449e-15,  2.834878855626477e-16,  3.598320656299467e-18,  2.824897729201491e-20,
  1.083082514087957e-22, -8.251790534933014e-25,  1.986372054030751e+00, -2.308685141544902e-04, -2.892746706566378e-06, -3.163014372033017e-08, -3.166679905990825e-10,
 -2.953026175272965e-12, -2.574077346302158e-14, -2.083594091337817e-16, -1.534976208729417e-18, -9.785877898373956e-21, -4.589716329674949e-23, -1.241385901084623e-26,
  8.323036174170026e-04, -5.404302817797912e-06,  2.630442877086931e-08, -1.138308222122608e-10,  4.610572202043412e-13, -1.796873500791562e-15,  6.756309577194298e-18,
 -2.533514730646585e-20,  8.864687091563998e-23, -3.569582283838928e-25,  8.178943554862706e-28, -8.371186445701466e-30,  7.492994844103573e-03, -4.859432857028090e-05,
  2.357806824181345e-07, -1.014372982525788e-09,  4.070189731098126e-12, -1.564713861793485e-14,  5.770914039120650e-17, -2.111938752450247e-19,  7.119306110513668e-22,
 -2.796822523646551e-24,  5.414942932525297e-27, -6.670832777606585e-29,  2.082643067003976e-02, -1.347348186558229e-04,  6.495785030050692e-07, -2.761349770110173e-09,
  1.086603667296986e-11, -4.057659222446996e-14,  1.434461188102764e-16, -4.964732077394545e-19,  1.526045462085489e-21, -5.636783428649966e-24,  5.358344995384195e-27,
 -1.440301052330561e-28,  4.085665559096333e-02, -2.633331019245317e-04,  1.257199116938246e-06, -5.245514694255501e-09,  2.000730036513523e-11, -7.117984020762179e-14,
  2.333559604346661e-16, -7.241691387872693e-19,  1.788209495042861e-21, -5.629279814155233e-24, -1.268971066858504e-26, -1.914153650285236e-28,  6.761956235908161e-02,
 -4.336153130804770e-04,  2.042412515026766e-06, -8.300477866567297e-09,  3.024287645330591e-11, -9.971418030018897e-14,  2.860005568549696e-16, -6.989376589927800e-19,
  6.844216725495291e-22,  1.242049023744852e-25, -5.703337601954923e-26, -1.992474652886225e-28,  1.011626288703198e-01, -6.444816971392500e-04,  2.982655831209042e-06,
 -1.169986974822978e-08,  3.993082816104464e-11, -1.166062042083620e-13,  2.549404897486616e-16, -2.362966239184511e-19, -2.329093216235350e-21,  1.214207778618293e-23,
 -1.204775533643233e-25, -2.434709338149804e-28,  1.415444675767292e-01, -8.944419295059874e-04,  4.048192289732111e-06, -1.515395265796054e-08,  4.707481079406718e-11,
 -1.112477082985279e-13,  9.722098566157727e-17,  7.712613013810548e-19, -7.116031421316499e-21,  2.652517467838949e-23, -1.728604797232511e-25, -4.970337619243112e-28,
  1.888340815690402e-01, -1.181525432146567e-03,  5.200998324184115e-06, -1.830620029119515e-08,  4.939005044390402e-11, -7.319694943181797e-14, -2.149730572308159e-16,
  2.273645180169949e-18, -1.245197490026632e-20,  3.370470985208427e-23, -1.628842255192046e-25, -1.168039321848620e-27,  2.431096649011741e-01, -1.503159494001004e-03,
  6.393341511632805e-06, -2.073078381670539e-08,  4.441765965954859e-11,  6.057191854064576e-15, -6.791047417517110e-16,  3.975824461410736e-18, -1.575117021884613e-20,
  1.920580550546170e-23, -3.707664221072688e-26, -2.333376685525705e-27,  3.044566994886892e-01, -1.856005068927896e-03,  7.566013220692049e-06, -2.193262388026213e-08,
  2.971585158722813e-11,  1.305702373574150e-13, -1.243645763438665e-15,  5.262334260973468e-18, -1.316013048448558e-20, -3.186859378655800e-23,  2.170281755035562e-25,
 -3.676049425967072e-27,  3.729649699087473e-01, -2.235736115706642e-03,  8.646195171753121e-06, -2.135289900505495e-08,  3.170616584979324e-12,  2.964392213557867e-13,
 -1.787489206978234e-15,  5.171857068827997e-18, -3.871697978946043e-22, -1.247249821542539e-22,  5.036333187148061e-25, -4.236451458382431e-27,  4.487239128253566e-01,
 -2.636742872024389e-03,  9.544984376816620e-06, -1.838498619809518e-08, -3.651251161299628e-11,  4.871575297313353e-13, -2.101881357101412e-15,  2.493057521312112e-18,
  2.521899145207991e-20, -2.381345909016872e-22,  5.491795150164439e-25, -2.484949211521116e-27,  5.318153935071532e-01, -3.051732092170756e-03,  1.015470810533725e-05,
 -1.240930424418139e-08, -8.905073134548449e-11,  6.679057772173866e-13, -1.885370792510508e-15, -3.898316974840769e-18,  6.080662620615334e-20, -3.039707871877482e-22,
 -9.973216293116209e-26,  2.703384595550934e-27,  6.223024807682436e-01, -3.471187744609274e-03,  1.034639315977462e-05, -2.861285920837159e-09, -1.514546386268727e-10,
  7.795469988205039e-13, -7.734968074650703e-16, -1.428546329500435e-17,  9.231508784277001e-20, -1.964640261343412e-22, -1.860861422549729e-24,  9.485097103750791e-27,
  7.202119427743776e-01, -3.882644375274815e-03,  9.968237383318281e-06,  1.064411835428548e-08, -2.164262367056443e-10,  7.347593255890724e-13,  1.556329480476373e-15,
 -2.675243512320164e-17,  8.874004250380588e-20,  2.335411527844840e-22, -4.458752649398844e-24,  9.154026350710245e-27,  8.255067864659932e-01, -4.269714931357117e-03,
  8.846911022888429e-06,  2.809432251164580e-08, -2.702783793736226e-10,  4.223642748364721e-13,  5.139164153387977e-15, -3.523593389233160e-17,  3.201077792164420e-21,
  1.012125315399521e-21, -5.737532482761173e-24, -1.475135843885130e-26,  9.380428339131647e-01, -4.610814176327064e-03,  6.795457371710097e-06,  4.871293678693132e-08,
 -2.907221803445297e-10, -2.670014569668974e-13,  9.257032705676253e-15, -2.786163290268443e-17, -2.021903524240061e-19,  1.711941626099446e-21, -8.224492296624315e-25,
 -7.062539044684429e-26,  1.057499439473494e+00, -4.877553250038832e-03,  3.635300420821181e-06,  7.037934579549871e-08, -2.458665358021974e-10, -1.369181996797678e-12,
  1.174867337267634e-14,  1.113548746798509e-17, -4.788074870847696e-19,  1.048693544432607e-21,  1.465146928610279e-23, -1.065917581398363e-25,  1.183268016988828e+00,
 -5.032917632661052e-03, -7.533195241057091e-07,  8.879936152356738e-08, -9.819052923828083e-11, -2.693535541622850e-12,  8.480503816548353e-15,  8.781192971165757e-17,
 -5.516219859427589e-19, -2.723339582027705e-21,  3.005554096884624e-23,  4.180139874590102e-26,  1.314271779711572e+00, -5.029748536803555e-03, -6.327225224579490e-06,
  9.658723974119620e-08,  1.779059684118465e-10, -3.577927012570788e-12, -5.447314867350257e-15,  1.621775121897309e-16,  1.243975722196305e-19, -8.292641909374591e-21,
 -6.075373786662005e-25,  4.246052155257726e-25,  1.448675324897805e+00, -4.811121231983250e-03, -1.268559899690846e-05,  8.309283066849035e-08,  5.503202520835681e-10,
 -2.719722553626386e-12, -2.906028820658131e-14,  1.046958920310320e-16,  1.673214924983976e-18, -4.351082693701092e-21, -1.047429203613436e-22,  1.403821970520486e-25,
  1.583427642622032e+00, -4.316746375193904e-03, -1.876037347072531e-05,  3.753186847334425e-08,  8.486629500959603e-10,  1.182217750376380e-12, -4.123843616523400e-14,
 -2.129185324954871e-16,  1.796972633342881e-18,  1.994992716028495e-20, -5.291626889108629e-23, -1.596030364356955e-24,  1.713590905159568e+00, -3.504481525867595e-03,
 -2.249956637643163e-05, -3.942663981394079e-08,  7.241195303735177e-10,  6.604906572640696e-12, -1.701749212959494e-15, -4.466619872266071e-16, -2.828649439681652e-18,
  1.388978882275542e-20,  3.077304322046315e-22,  9.705989493162936e-25,  1.831523649314642e+00, -2.401570912207249e-03, -2.112266033551254e-05, -1.138321135170348e-07,
 -5.118097313989291e-11,  6.140309822416424e-12,  6.359096837399935e-14,  1.935046879602763e-16, -2.941015989635987e-18, -4.649072545696993e-20, -2.448348251318734e-22,
  1.405225138646867e-24,  1.926402646800979e+00, -1.189566203696511e-03, -1.329259757941364e-05, -1.169598630570893e-07, -7.853670311485926e-10, -3.013136453245111e-12,
  1.391397722645521e-14,  4.156504918852605e-16,  4.681387601004738e-18,  3.150179442644570e-20,  4.431275843125722e-23, -2.204784329974812e-24,  1.985399764330320e+00,
 -2.556195853430062e-04, -3.304771954193783e-06, -3.720496946052081e-08, -3.824089718964599e-10, -3.646702126442527e-12, -3.231798380547706e-14, -2.634673898389217e-16,
 -1.919926138399027e-18, -1.157312496181287e-20, -4.165494414593671e-23,  2.382010733109530e-25,  8.110987993793653e-04, -5.199208534716057e-06,  2.498156235414021e-08,
 -1.067328317950145e-10,  4.266854113815877e-13, -1.642925799980340e-15,  6.084748053699337e-18, -2.269849965017688e-20,  7.629056293730535e-23, -3.322864974037377e-25,
  3.954942244400218e-28, -1.115564904564766e-29,  7.302314460594378e-03, -4.675568922702693e-05,  2.239888561092778e-07, -9.516802017162952e-10,  3.770631079460970e-12,
 -1.433059773734315e-14,  5.209978337333871e-17, -1.899873769968902e-19,  6.143781857368400e-22, -2.645552598542456e-24,  1.954299567316568e-27, -9.348252289533068e-29,
  2.029767888162733e-02, -1.296678403429876e-04,  6.174592579694037e-07, -2.593803013895488e-09,  1.008783362316706e-11, -3.729536854177396e-14,  1.301982484661004e-16,
 -4.508587557119324e-19,  1.325267906990605e-21, -5.570037916140293e-24, -2.618574538388422e-27, -2.263611764255201e-28,  3.982304725262759e-02, -2.535219579587792e-04,
  1.196127629880923e-06, -4.936489146866599e-09,  1.863809918512525e-11, -6.581634303256169e-14,  2.138490701217903e-16, -6.703059657697075e-19,  1.573982491522233e-21,
 -6.351162801695028e-24, -2.469537902048206e-26, -3.692498319159545e-28,  6.591716028713175e-02, -4.176663590108742e-04,  1.945645475401045e-06, -7.832179776902630e-09,
  2.831566053939843e-11, -9.308254723957505e-14,  2.667343343945127e-16, -6.774267340805540e-19,  6.449951211929343e-22, -2.413637332025177e-24, -7.212559202374958e-26,
 -5.114702346307417e-28,  9.863155048742682e-02, -6.211713581455742e-04,  2.846014864006914e-06, -1.107930344415200e-08,  3.765931193836710e-11, -1.105750801244696e-13,
  2.473396772270513e-16, -3.047917598261902e-19, -1.982378801349687e-21,  6.987628242507803e-24, -1.406401421679537e-25, -7.111004894723900e-28,  1.380303370898057e-01,
 -8.627711448054267e-04,  3.870791045818100e-06, -1.441842165212902e-08,  4.487480946744293e-11, -1.086801590122320e-13,  1.157620691219716e-16,  5.574406411961686e-19,
 -6.292234735532611e-21,  1.901732630776009e-23, -2.069840088773378e-25, -1.110338017242950e-27,  1.841898233593444e-01, -1.140782822049745e-03,  4.986016204721953e-06,
 -1.752793047194607e-08,  4.787944643163989e-11, -7.763631084104248e-14, -1.567166634557717e-16,  1.893227765083519e-18, -1.136984743393538e-20,  2.598157297139160e-23,
 -2.285593870790558e-25, -1.896648654043489e-27,  2.371977619112828e-01, -1.452995754290380e-03,  6.148837431337815e-06, -2.001998083085799e-08,  4.438454382775976e-11,
 -8.961777707151654e-15, -5.747374978135746e-16,  3.482351156813657e-18, -1.511297519935453e-20,  1.546589144144890e-23, -1.560562143134791e-25, -3.179693755754459e-27,
  2.971520802046704e-01, -1.796521458221191e-03,  7.305755513872523e-06, -2.143785150273987e-08,  3.204046608243167e-11,  1.024422880352949e-13, -1.102358575473889e-15,
  4.824197771494217e-18, -1.419247401853635e-20, -2.669102853022984e-23,  3.387628498056603e-26, -4.775877497654164e-27,  3.641587435411470e-01, -2.167590195388981e-03,
  8.390452996772672e-06, -2.125702059115538e-08,  8.682109008963081e-12,  2.552718050193691e-13, -1.643500189308273e-15,  5.091123816438188e-18, -4.563545413066696e-21,
 -1.087546533487053e-22,  2.823725290381803e-25, -5.960882570271345e-27,  4.383282507615162e-01, -2.561274684954070e-03,  9.321172055527829e-06, -1.889395675788617e-08,
 -2.726772007871221e-11,  4.376334604882423e-13, -2.022037660907816e-15,  3.166879177511146e-18,  1.700808700350627e-20, -2.191476780567499e-22,  3.789749412600673e-25,
 -5.402788062060187e-27,  5.197699644837086e-01, -2.971113296655418e-03,  9.997680346041349e-06, -1.372974283073436e-08, -7.615285281281300e-11,  6.215567860907325e-13,
 -1.968931881738439e-15, -2.128201170398682e-18,  4.980952624631541e-20, -3.068059564946789e-22, -7.437446739118332e-26, -1.746686385611263e-27,  6.085829980172145e-01,
 -3.388593959009712e-03,  1.029802895985637e-05, -5.160971339438327e-09, -1.360800416722229e-10,  7.565099411442858e-13, -1.133293954847449e-15, -1.145817082166515e-17,
  8.399118343771872e-20, -2.638931954743276e-22, -1.547427910642126e-24,  4.420776364780733e-27,  7.048415844042849e-01, -3.802445297684920e-03,  1.007568071814267e-05,
  7.300640690180572e-09, -2.014165187217588e-10,  7.634498559572612e-13,  8.480398230938688e-16, -2.381188766598111e-17,  9.403096734634275e-20,  6.283003983329778e-23,
 -4.093713287739996e-24,  6.823903993865593e-27,  8.085715095977795e-01, -4.197663947543039e-03,  9.158395721712439e-06,  2.384381337323973e-08, -2.606774127510831e-10,
  5.339085703069327e-13,  4.159147137902563e-15, -3.459596312779655e-17,  3.536732165771914e-20,  7.714647197943508e-22, -6.258817254113088e-24, -9.737717415160359e-27,
  9.197118946337363e-01, -4.554191701605049e-03,  7.351965409768200e-06,  4.403045516839811e-08, -2.939072500028929e-10, -5.486872935298390e-14,  8.395511093915872e-15,
 -3.335790427847064e-17, -1.418758414794396e-19,  1.619705032371878e-21, -3.721405245825166e-24, -6.134794826021448e-26,  1.038052643079637e+00, -4.845161494992228e-03,
  4.455395564931428e-06,  6.624180771840088e-08, -2.704140247895962e-10, -1.085164985356319e-12,  1.185238851298665e-14, -3.478684330489642e-18, -4.316829342810412e-19,
  1.535903629856308e-21,  9.600654679741612e-24, -1.215240033129060e-25,  1.163130999089652e+00, -5.034712545651104e-03,  3.011068069698685e-07,  8.680920495115187e-08,
 -1.498374244051893e-10, -2.462575538182352e-12,  1.067904041522659e-14,  6.882555207414138e-17, -6.278003979623639e-19, -1.508615828743513e-21,  3.008526424514505e-23,
 -3.982775523611488e-26,  1.294058951687948e+00, -5.075687237582153e-03, -5.153479585660346e-06,  9.885571211069385e-08,  1.054090476459077e-10, -3.653996224878199e-12,
 -8.953192294166773e-16,  1.614128402135128e-16, -1.701819248556539e-19, -7.956187628292033e-21,  1.700111205280836e-23,  3.658328117747129e-25,  1.429234391010125e+00,
 -4.908472255771762e-03, -1.163756907145329e-05,  9.142600790062656e-08,  4.892193329497784e-10, -3.376114551408964e-12, -2.540841964617968e-14,  1.549413787560730e-16,
  1.443463284536840e-18, -8.328406378822582e-21, -9.199524754477731e-23,  4.315664302472230e-25,  1.565863671371698e+00, -4.464795558911165e-03, -1.822791857208490e-05,
  5.124395384177347e-08,  8.619635148544967e-10,  1.280980950157642e-13, -4.629085576699500e-14, -1.444711071100527e-16,  2.460019889094014e-18,  1.641891408466393e-20,
 -1.233658641075371e-22, -1.558543773518934e-24,  1.699210280822818e+00, -3.686163571872349e-03, -2.289883057607094e-05, -2.679059083478041e-08,  8.547456265427636e-10,
  6.404306488964712e-12, -1.538301091594334e-14, -5.267363143732010e-16, -2.099429984679534e-18,  2.675253665098142e-20,  3.270576669697766e-22, -1.742865738055496e-25,
  1.821570745200292e+00, -2.576020177253324e-03, -2.248923333005720e-05, -1.135840064998279e-07,  8.726416548773634e-11,  7.719265478223334e-12,  6.742730273221498e-14,
  7.087739219636015e-17, -4.770980404675227e-18, -5.448060566410079e-20, -1.395351948026329e-22,  3.478166232112473e-24,  1.921422504030034e+00, -1.301739118750091e-03,
 -1.477342949401314e-05, -1.299854185180809e-07, -8.412557502982881e-10, -2.521559743197505e-12,  2.782111562591959e-14,  5.837184235737228e-16,  5.818752594574084e-18,
  3.074717823145278e-20, -9.824479104670541e-23, -4.431817749604369e-24,  1.984321427546261e+00, -2.839534445134900e-04, -3.790493348556864e-06, -4.395176615239100e-08,
 -4.637344276322491e-10, -4.518197060581294e-12, -4.061997004314463e-14, -3.318649197965054e-16, -2.362885940867113e-18, -1.289987687625338e-20, -2.083382516553749e-23,
  7.703270901777266e-25,  7.906937191613773e-04, -5.004365600127584e-06,  2.374067096424767e-08, -1.001610100966814e-10,  3.952371338485156e-13, -1.504253645042467e-15,
  5.481585745103580e-18, -2.044658035693756e-20,  6.448312780652534e-23, -3.275900167356561e-25, -1.973537157365351e-28, -1.619148256085758e-29,  7.118804617437754e-03,
 -4.500845476612180e-05,  2.129214312991017e-07, -8.935768317995891e-10,  3.496103290702560e-12, -1.314190477767733e-14,  4.704111807875824e-17, -1.718447717061446e-19,
  5.194458081152423e-22, -2.661843251347744e-24, -3.109475020389476e-27, -1.402465886501534e-28,  1.978869353970593e-02, -1.248499805400420e-04,  5.872779773192550e-07,
 -2.438199364718226e-09,  9.372175260372860e-12, -3.431749347615467e-14,  1.181375112538774e-16, -4.117002918854459e-19,  1.120140976335232e-21, -5.909940100317319e-24,
 -1.537242555494245e-26, -3.630846659706784e-28,  3.882772931707359e-02, -2.441849170961902e-04,  1.138636464956814e-06, -4.648537597297423e-09,  1.737160433786648e-11,
 -6.090371558005641e-14,  1.957497103950203e-16, -6.238235493426747e-19,  1.322976853689237e-21, -7.738846642790382e-24, -4.674818201373233e-26, -6.519853614959696e-28,
  6.427704062251559e-02, -4.024695772348407e-04,  1.854317296171777e-06, -7.393681002633430e-09,  2.651650106759243e-11, -8.690630771459868e-14,  2.480380199128136e-16,
 -6.587854484452166e-19,  4.995973813379001e-22, -5.878025652326288e-24, -1.046327982832369e-25, -9.973498822250113e-28,  9.619157350781163e-02, -5.989249684595714e-04,
  2.716606573600090e-06, -1.049412696301986e-08,  3.550644438350465e-11, -1.047483142854736e-13,  2.379470691267290e-16, -3.653612212068910e-19, -1.841364315659062e-21,
  5.412099457612329e-25, -1.870278052329729e-25, -1.445205375811676e-27,  1.346401063826689e-01, -8.324848589184036e-04,  3.702006741306700e-06, -1.371765766734655e-08,
  4.273013833780338e-11, -1.057367491985251e-13,  1.286423875726978e-16,  3.653343708961916e-19, -5.770770316042028e-21,  9.496063938026631e-24, -2.763912113578808e-25,
 -2.114202424733567e-27,  1.797051544362624e-01, -1.101723129113576e-03,  4.780225611468569e-06, -1.677446820303752e-08,  4.629319300013668e-11, -8.080170282387384e-14,
 -1.086729835386394e-16,  1.542411222274452e-18, -1.062214016444415e-20,  1.483732187083953e-23, -3.379506901928208e-25, -3.173069234785648e-27,  2.314826557942473e-01,
 -1.404753959654098e-03,  5.912850323340030e-06, -1.931197929684168e-08,  4.407498881847746e-11, -2.163959199466108e-14, -4.839288638043904e-16,  3.006142697679472e-18,
 -1.470587467270190e-20,  6.019773948272421e-24, -3.276990286112855e-25, -4.751607629515402e-27,  2.900812696806359e-01, -1.739095569378250e-03,  7.051640259370628e-06,
 -2.091020576322327e-08,  3.383541806873611e-11,  7.755440347797938e-14, -9.737843774412780e-16,  4.354485554267981e-18, -1.518417347949846e-20, -3.005439353126724e-23,
 -2.165568223930807e-25, -6.768583314711031e-27,  3.556210183022214e-01, -2.101484172540853e-03,  8.136363901006042e-06, -2.107935835751297e-08,  1.340455133854147e-11,
  2.175183631589281e-13, -1.503569403977386e-15,  4.884072771082360e-18, -8.345067762778944e-21, -1.034300584433356e-22, -3.611127259452167e-26, -8.703211671808946e-27,
  4.282308452186960e-01, -2.487618987028078e-03,  9.092107255141089e-06, -1.926282449983830e-08, -1.899287017200153e-11,  3.902229314649299e-13, -1.926913594621409e-15,
  3.587305638104993e-18,  9.324506391021992e-21, -2.098411470305680e-22,  5.689472158724798e-26, -9.448256987215289e-27,  5.080444027039528e-01, -2.891810667121285e-03,
  9.826014621069140e-06, -1.485132402814699e-08, -6.419820006169904e-11,  5.737572250170098e-13, -2.007872705275548e-15, -7.118353211303174e-19,  3.867797210454166e-20,
 -3.129289102860167e-22, -2.744302364725477e-25, -7.603909632320239e-27,  5.951929476592925e-01, -3.306493327952415e-03,  1.022352784416013e-05, -7.218791965134644e-09,
 -1.212462896840139e-10,  7.257554550258345e-13, -1.418006406592786e-15, -8.934136372237340e-18,  7.340602715423216e-20, -3.238806388932496e-22, -1.505179205742764e-24,
 -2.886320205390124e-27,  6.897934931474459e-01, -3.721543039951908e-03,  1.014445927502009e-05,  4.201013655400446e-09, -1.859962353593888e-10,  7.761430064992603e-13,
  2.235505418649433e-16, -2.079780968369491e-17,  9.340418175902891e-20, -9.645868016927070e-23, -3.916136228220693e-24,  5.930467466442650e-28,  7.919291012812024e-01,
 -4.123322337831080e-03,  9.419865504772436e-06,  1.976349692715017e-08, -2.490787461913680e-10,  6.222556605687698e-13,  3.210130699970751e-15, -3.306897456868986e-17,
  5.853403538683046e-20,  5.128564883169829e-22, -6.674128281542823e-24, -1.008836079502797e-26,  9.016159927057569e-01, -4.493342473136271e-03,  7.852114136625048e-06,
  3.932978179988969e-08, -2.930677845533504e-10,  1.349549805965284e-13,  7.406460515824321e-15, -3.699885287022293e-17, -8.687582360959866e-20,  1.419069028964168e-21,
 -6.262913925966340e-24, -5.486040861401489e-26,  1.018748211918593e+00, -4.806413825630507e-03,  5.223671210155153e-06,  6.175695191632856e-08, -2.892884825914561e-10,
 -8.033839864833300e-13,  1.157037070703012e-14, -1.634436889759940e-17, -3.707918322667279e-19,  1.810298332296223e-21,  4.062770657478183e-24, -1.293062864566461e-25,
  1.143003501760696e+00, -5.028181254694009e-03,  1.326854372784396e-06,  8.403233335834734e-08, -1.963817845068674e-10, -2.185465298047930e-12,  1.231836595750714e-14,
  4.809443725842959e-17, -6.610791683951990e-19, -3.629318420853849e-22,  2.665463031978864e-23, -1.144765479291415e-25,  1.273681293252515e+00, -5.112146882912141e-03,
 -3.959503026368469e-06,  9.995797222236374e-08,  3.247604694271018e-11, -3.622123763534398e-12,  3.506049679702249e-15,  1.515452748260951e-16, -4.407494057911576e-19,
 -6.983991505770524e-21,  3.078519289513899e-23,  2.530603712527125e-25,  1.409421430091194e+00, -4.997056631568373e-03, -1.049582323328931e-05,  9.868177147889791e-08,
  4.159761388197286e-10, -3.928938182334450e-12, -2.047328941916220e-14,  1.956663620499649e-16,  1.082639258406841e-18, -1.155740755491175e-20, -6.787157234283555e-23,
  6.481915887794166e-25,  1.547717067728549e+00, -4.607924947249499e-03, -1.753035697457226e-05,  6.499429380715997e-08,  8.531361668835355e-10, -1.022020442364125e-12,
 -4.915264567207226e-14, -5.737551897681904e-17,  2.946410673196258e-18,  1.018944542726675e-20, -1.856814690806218e-22, -1.226034854340214e-24,  1.684097550022626e+00,
 -3.870398095217643e-03, -2.313411422509881e-05, -1.211517005152572e-08,  9.779100640750088e-10,  5.851518613262687e-12, -3.090959853014168e-14, -5.760243596667233e-16,
 -9.066351861066778e-19,  3.924484410707896e-20,  2.861465662239473e-22, -1.736469960303889e-24,  1.810898254074425e+00, -2.761350033817432e-03, -2.383848347483015e-05,
 -1.108644313238195e-07,  2.578958131747238e-10,  9.342241118884940e-12,  6.697388331966611e-14, -1.139102170659394e-16, -6.789381425189258e-18, -5.628536242241589e-20,
  6.742463160547884e-23,  5.956996689760675e-24,  1.915968966028335e+00, -1.426398244254657e-03, -1.641554565845431e-05, -1.438067330517197e-07, -8.835730549061220e-10,
 -1.635697683269110e-12,  4.693057138590527e-14,  7.864380816814633e-16,  6.800088095872649e-18,  2.204308994655495e-20, -3.603819682457268e-22, -7.645293684128295e-24,
  1.983121437958529e+00, -3.165204399623211e-04, -4.365595650848043e-06, -5.215071557613486e-08, -5.646458246860387e-10, -5.613560095029370e-12, -5.104126611522195e-14,
 -4.149873834591576e-16, -2.831818155959444e-18, -1.279447293477381e-20,  3.372160741923139e-23,  1.822561438721613e-24,  7.710486440734036e-04, -4.819142697373219e-06,
  2.257571143268535e-08, -9.407093914730647e-11,  3.664224271859504e-13, -1.379343455215626e-15,  4.936177520132861e-18, -1.857484493353021e-20,  5.235835323480674e-23,
 -3.517031272171618e-25, -1.059468468247830e-27, -2.316384339104498e-29,  6.942110946094400e-03, -4.334704364871200e-05,  2.025256558867703e-07, -8.396821456088302e-10,
  3.244174647068753e-12, -1.206886919116870e-14,  4.244752403869046e-17, -1.567928674387256e-19,  4.197302879218689e-22, -2.927750983539126e-24, -1.065541182804049e-26,
 -2.042334491670847e-28,  1.929850829341158e-02, -1.202662922402242e-04,  5.588971526954695e-07, -2.293585157274451e-09,  8.713264738151643e-12, -3.161667573538015e-14,
  1.070786995600015e-16, -3.794128966333994e-19,  8.919949655089410e-22, -6.896477168361833e-24, -3.530205844346837e-26, -5.467916196102056e-28,  3.786886109396926e-02,
 -2.352943210492289e-04,  1.084482302172992e-06, -4.380087120929815e-09,  1.619911870455687e-11, -5.641081519063462e-14,  1.788305333900277e-16, -5.863691300659934e-19,
  1.002847926412060e-21, -1.028875048306021e-23, -8.348664245853169e-26, -1.025534233581863e-27,  6.269627948134419e-02, -3.879828530925265e-04,  1.768082380728012e-06,
 -6.983004795149690e-09,  2.483641830684771e-11, -8.117316733018209e-14,  2.297777267549317e-16, -6.470883495217086e-19,  2.004426263002862e-22, -1.112215915939375e-23,
 -1.622400619973037e-25, -1.633681132829430e-27,  9.383855521257851e-02, -5.776863334314292e-04,  2.594017530112942e-06, -9.942476898524562e-09,  3.346772222133217e-11,
 -9.916704136426228e-14,  2.268838592560400e-16, -4.255575451649449e-19, -1.974341623923796e-21, -8.486158806976554e-24, -2.714156746430015e-25, -2.410051562120526e-27,
  1.313683727107423e-01, -8.035157895726012e-04,  3.541427708316518e-06, -1.305072247832214e-08,  4.064699930793969e-11, -1.025472119781656e-13,  1.363214615412107e-16,
  1.838013505699415e-19, -5.653765281391318e-21, -3.800849567029581e-24, -3.982970927974336e-25, -3.456289365804292e-27,  1.753734882835935e-01, -1.064274030616230e-03,
  4.583322389871112e-06, -1.604683309898898e-08,  4.465437884104578e-11, -8.292962093928781e-14, -7.018421324229010e-17,  1.208137870906373e-18, -1.036942877987101e-20,
 -1.968255854832465e-24, -5.151850060546561e-25, -4.925702064633219e-27,  2.259567947268119e-01, -1.358366180530490e-03,  5.685321520354638e-06, -1.861084519033872e-08,
  4.353259764528924e-11, -3.229689822083047e-14, -4.063331045399462e-16,  2.536046820949908e-18, -1.478109030787700e-20, -1.189167397308340e-23, -5.840823731778607e-25,
 -6.960656334938129e-27,  2.832361376097083e-01, -1.683676824111661e-03,  6.804013173849195e-06, -2.035765973102418e-08,  3.516238559015543e-11,  5.559070482687142e-14,
 -8.588394646004121e-16,  3.848980205446125e-18, -1.650089973912515e-20, -4.545893514919838e-23, -5.741414376502542e-25, -9.558491208829733e-27,  3.473436669707259e-01,
 -2.037401106377847e-03,  7.884835774327857e-06, -2.083199734333105e-08,  1.740496837010864e-11,  1.830401000191276e-13, -1.371120345218739e-15,  4.556365905485597e-18,
 -1.219621128427702e-20, -1.135731757038535e-22, -4.979463096438064e-25, -1.237118042140247e-26,  4.184243724803938e-01, -2.415811333637881e-03,  8.859379548036449e-06,
 -1.950675278052666e-08, -1.164259017243017e-11,  3.452090711451111e-13, -1.823429316029400e-15,  3.764361689231738e-18,  1.697885762679971e-21, -2.173315326471253e-22,
 -4.685890384578264e-25, -1.452108479360499e-26,  4.966332240450219e-01, -2.813932020540106e-03,  9.642005891287976e-06, -1.578931673377167e-08, -5.320588114548305e-11,
  5.254584595392751e-13, -2.012189419920431e-15,  3.427190701688781e-19,  2.711587095384185e-20, -3.326360389800605e-22, -7.628277405625880e-25, -1.469136307097438e-26,
  5.821299570450135e-01, -3.225083495472673e-03,  1.012573548450185e-05, -9.044541227224086e-09, -1.070904401892975e-10,  6.889756696466222e-13, -1.637114207943422e-15,
 -6.783721846564072e-18,  6.060832166608889e-20, -3.892479227607663e-22, -1.830364789893992e-24, -1.206133215736046e-26,  6.750698817471290e-01, -3.640235127399500e-03,
  1.017752847247628e-05,  1.349356310239081e-09, -1.704651645506785e-10,  7.748536139369389e-13, -3.176810913390156e-16, -1.789477187446489e-17,  8.709462424379246e-20,
 -2.552266342968979e-22, -4.092358124517446e-24, -8.969931079723816e-27,  7.755879374368547e-01, -4.047081543881332e-03,  9.633539306008616e-06,  1.588167309577696e-08,
 -2.359370425512872e-10,  6.884144757459081e-13,  2.312825517482895e-15, -3.095294546728225e-17,  7.207303204253423e-20,  2.356855152651743e-22, -7.225283484149076e-24,
 -1.562945229240533e-26,  8.837711335121198e-01, -4.428717178844792e-03,  8.296056391346723e-06,  3.467159077420498e-08, -2.886764777098622e-10,  3.000096350008795e-13,
  6.338880518139085e-15, -3.901450580299440e-17, -4.087148767372570e-20,  1.121190367395214e-21, -8.615793560777029e-24, -5.271134978851414e-26,  9.996107163094440e-01,
 -4.761739932711790e-03,  5.936501097119512e-06,  5.701470357980684e-08, -3.026230130117998e-10, -5.324665187151512e-13,  1.095656972197812e-14, -2.714682133955921e-17,
 -3.040791453027361e-19,  1.857749727092060e-21, -1.714154265226324e-24, -1.325569554263560e-25,  1.122918313212967e+00, -5.013589499003835e-03,  2.315000494759641e-06,
  8.055702827517511e-08, -2.370379839885399e-10, -1.876060227973450e-12,  1.336828673439779e-14,  2.692559795567113e-17, -6.563453773520856e-19,  5.831654713750824e-22,
  2.019907116663579e-23, -1.762827618915785e-25,  1.253176955736399e+00, -5.139021559860409e-03, -2.759261584669989e-06,  9.990403220990281e-08, -3.879046172743194e-11,
 -3.488876433187478e-12,  7.515872770098047e-15,  1.336754887488169e-16, -6.677019978486280e-19, -5.571757673859267e-21,  3.874463049752486e-23,  1.049961750156130e-25,
  1.389272921862170e+00, -5.076179482813297e-03, -9.274382596462110e-06,  1.046839905012734e-07,  3.329460943505624e-10, -4.351040157545775e-12, -1.457555777238819e-14,
  2.231880342185551e-16,  6.249426533849810e-19, -1.366371725758891e-20, -3.673698858985196e-23,  7.450575343202432e-25,  1.529010146823525e+00, -4.744817995718023e-03,
 -1.666940755373289e-05,  7.841650344124402e-08,  8.208253016375798e-10, -2.210022646803948e-12, -4.939480959523285e-14,  4.124889030617740e-17,  3.167947243664313e-18,
  1.841219273913892e-21, -2.274138495506071e-22, -6.351436199805385e-25,  1.668245277941860e+00, -4.055777940605679e-03, -2.318190054696864e-05,  4.421802562048718e-09,
  1.086204579989956e-09,  4.914245834996525e-12, -4.721732386511704e-14, -5.804021215762754e-16,  6.892147982764273e-19,  4.865995234368873e-20,  1.722158629925529e-22,
 -3.430607019719960e-24,  1.799463130966571e+00, -2.957294486309446e-03, -2.513765395389334e-05, -1.051575555943377e-07,  4.604213052125346e-10,  1.088494991208140e-11,
  6.044503136326227e-14, -3.625144343394659e-16, -8.697414989718514e-18, -4.763684538102894e-20,  3.815045321279544e-22,  8.205811545329669e-24,  1.909989452987414e+00,
 -1.564867714248169e-03, -1.822690925404426e-05, -1.581364785408688e-07, -9.031102566418826e-10, -2.199154096868806e-13,  7.209259836078445e-14,  1.013230269292834e-15,
  7.242796765738438e-18, -2.399361636704604e-22, -7.830290631724518e-22, -1.164850403061863e-23,  1.981781314570772e+00, -3.541110085947929e-04, -5.049542034685868e-06,
 -6.215391642893308e-08, -6.901628009929913e-10, -6.988637992302444e-12, -6.399590973347796e-14, -5.125297626185972e-16, -3.244429075560156e-18, -9.344693607994806e-21,
  1.531186580737703e-22,  3.803437803742930e-24,  7.521262732690905e-04, -4.642954799737986e-06,  2.148114672435826e-08, -8.842261206908084e-11,  3.399790405355221e-13,
 -1.266939057892677e-15,  4.437564537439207e-18, -1.711225000460620e-20,  3.867084869675541e-23, -4.163553263400302e-25, -2.211043112630219e-27, -2.817743717431440e-29,
  6.771900588171817e-03, -4.176627872147300e-05,  1.927531207347083e-07, -7.896524853967768e-10,  3.012636481268529e-12, -1.110139405832762e-14,  3.822882424876915e-17,
 -1.451488073986135e-19,  3.043310346099592e-22, -3.551013759982643e-24, -2.085621589828030e-26, -2.503650252227700e-28,  1.882621445007684e-02, -1.159028842660846e-04,
  5.321901797812627e-07, -2.159095515981796e-09,  8.105785259600788e-12, -2.917128459722704e-14,  9.681519740250343e-17, -3.551641352412192e-19,  6.120401214085447e-22,
 -8.839398035125400e-24, -6.284800281180239e-26, -6.798576815938077e-28,  3.694470874927521e-02, -2.268243849102140e-04,  1.033439881253983e-06, -4.129699278692062e-09,
  1.511250904116493e-11, -5.231264371104131e-14,  1.628006531880923e-16, -5.609434197650747e-19,  5.605214658120270e-22, -1.463160078944902e-23, -1.357069336354837e-25,
 -1.297704777703826e-27,  6.117211605562985e-02, -3.741667442381765e-04,  1.686617998822400e-06, -6.598316331304978e-09,  2.326663601930942e-11, -7.587561720366577e-14,
  2.116790606093082e-16, -6.484844173239823e-19, -3.357039905156553e-22, -1.922145811383272e-23, -2.462371554294971e-25, -2.100166857008370e-27,  9.156857118636104e-02,
 -5.574024776936036e-04,  2.477856205385761e-06, -9.422568397192998e-09,  3.153782997111515e-11, -9.387231793626778e-14,  2.140215944978760e-16, -4.959436271254970e-19,
 -2.503270073849646e-21, -2.172527310187304e-23, -3.958931169027011e-25, -3.121214996604530e-27,  1.282099959452833e-01, -7.757999013108793e-04,  3.388654049061951e-06,
 -1.241659890090797e-08,  3.862908246117730e-11, -9.923442782217208e-14,  1.388906835688750e-16, -2.703628244931661e-21, -6.117446103811627e-21, -2.313992692778143e-23,
 -5.761338009832051e-25, -4.449117690206643e-27,  1.711885227404589e-01, -1.028365680088238e-03,  4.394992212841384e-06, -1.534571247253911e-08,  4.298148765272496e-11,
 -8.424582231516613e-14, -4.104346950665846e-17,  8.707512198550423e-19, -1.086795062569898e-20, -2.739032139383662e-23, -7.657003726723425e-25, -6.223025236093558e-27,
  2.206128973723807e-01, -1.313765140488034e-03,  5.466147538778994e-06, -1.791999781530154e-08,  4.279461294537836e-11, -4.125080174414647e-14, -3.420458862741546e-16,
  2.051056101421186e-18, -1.570923360778475e-20, -4.198737538065175e-23, -9.330096436743347e-25, -8.590454306745425e-27,  2.766087609467145e-01, -1.630212244819807e-03,
  6.563130005710628e-06, -1.978725142775097e-08,  3.607649227129220e-11,  3.621045588813491e-14, -7.587430493582069e-16,  3.289464075027122e-18, -1.865933875820754e-20,
 -7.760107332624307e-23, -1.048430573501176e-24, -1.160535749022056e-26,  3.393186437217519e-01, -1.975317355087530e-03,  7.636637814526533e-06, -2.052597684111799e-08,
  2.074679078227658e-11,  1.516161063058376e-13, -1.249654544674744e-15,  4.095697613879113e-18, -1.678390654213612e-20, -1.453754426265076e-22, -1.112442276598608e-24,
 -1.505932731443993e-26,  4.089013909072013e-01, -2.345875278723846e-03,  8.624401059814479e-06, -1.964014267065847e-08, -5.167493736040863e-12,  3.027103414422670e-13,
 -1.718476188472446e-15,  3.688558219376154e-18, -6.630237616600433e-21, -2.502239568209069e-22, -1.204332005810261e-24, -1.828874418363462e-26,  4.855305486695643e-01,
 -2.737567550940242e-03,  9.447764641835387e-06, -1.655915649087418e-08, -4.317840121501420e-11,  4.773678091576614e-13, -1.992295504638613e-15,  1.011555463637418e-18,
  1.441799093856439e-20, -3.780028007458286e-22, -1.546193928188819e-24, -2.013287659702839e-26,  5.693909076858760e-01, -3.144539845107114e-03,  1.000736794894980e-05,
 -1.064994776913656e-08, -9.371814391513546e-11,  6.476112760013377e-13, -1.802120042211456e-15, -5.083789453228584e-18,  4.512578627885383e-20, -4.756416144789646e-22,
 -2.544735014850071e-24, -1.949322327305516e-26,  6.606718203339590e-01, -3.558795322778635e-03,  1.017786570180347e-05, -1.254688812674755e-09, -1.550833336637240e-10,
  7.615219167723262e-13, -7.813281849101441e-16, -1.528729569038499e-17,  7.483830550557308e-20, -4.296768233593067e-22, -4.692801003742988e-24, -1.735587365301452e-26,
  7.595548657000608e-01, -3.969314019459607e-03,  9.801932756320266e-06,  1.221955275283647e-08, -2.216825034001433e-10,  7.337885245639174e-13,  1.479301209728977e-15,
 -2.856810181483614e-17,  7.517111911734594e-20, -6.908595565999213e-23, -8.055825535953178e-24, -2.121096980507754e-26,  8.661915265547421e-01, -4.360762503494347e-03,
  8.684626300314889e-06,  3.010866094900356e-08, -2.812440531500959e-10,  4.389209073374341e-13,  5.233731386675377e-15, -3.974762438168385e-17, -7.268618653806895e-21,
  7.304786106667635e-22, -1.090403565909855e-23, -5.025579097000303e-26,  9.806629565545946e-01, -4.711594249508274e-03,  6.591319831425410e-06,  5.210155066014729e-08,
 -3.107097586750702e-10, -2.796686868476457e-13,  1.007012502788464e-14, -3.583191942701533e-17, -2.398372287546995e-19,  1.672993433505729e-21, -7.490185251584722e-24,
 -1.276507904175562e-25,  1.102907022920819e+00, -4.991269969275403e-03,  3.257748053738067e-06,  7.648189707335086e-08, -2.713018968941289e-10, -1.548523108600056e-12,
  1.383233646031009e-14,  6.398356805813060e-18, -6.228056038979177e-19,  1.222314836451904e-21,  1.147288097842920e-23, -2.150732568244027e-25,  1.232584292218499e+00,
 -5.156316043281295e-03, -1.566404626242400e-06,  9.873619217653333e-08, -1.064742299015784e-10, -3.266169405315823e-12,  1.093167287010115e-14,  1.094050762160385e-16,
 -8.396952237590859e-19, -3.975515619023142e-21,  3.995275885114909e-23, -4.721288339425247e-26,  1.368827888781952e+00, -5.145265877075051e-03, -7.989139248491211e-06,
  1.092981145570132e-07,  2.429430662078250e-10, -4.624065630090488e-12, -8.121916328048765e-15,  2.350965311833412e-16,  1.145065122891713e-19, -1.447846347292832e-20,
 -4.242442064860680e-24,  7.125714070404465e-25,  1.509770434218318e+00, -4.874189774420467e-03, -1.565127597256082e-05,  9.113229275457170e-08,  7.649228770933296e-10,
 -3.370185797056421e-12, -4.682340745810873e-14,  1.418860327910182e-16,  3.065682906667589e-18, -7.601233378469062e-21, -2.392441065084568e-22,  1.131762264880670e-25,
  1.651652018241340e+00, -4.240718408360902e-03, -2.302153426368818e-05,  2.252032432900466e-08,  1.171860883711323e-09,  3.590165487629721e-12, -6.288883371937552e-14,
 -5.293121623764269e-16,  2.524476917419091e-18,  5.208499805095435e-20, -1.099980998628097e-23, -4.799657833904332e-24,  1.787223957820432e+00, -3.163301008298845e-03,
 -2.634791562271361e-05, -9.597443847792002e-08,  6.916361080988700e-10,  1.218091468109608e-11,  4.616560104983415e-14, -6.645916244058686e-16, -1.004660085071792e-17,
 -2.473547798915875e-20,  7.707693870394082e-22,  9.174691075823656e-24,  1.903425986804969e+00, -1.718518858947619e-03, -2.021105872067534e-05, -1.725173056546026e-07,
 -8.877738864569452e-10,  1.876692002617701e-12,  1.036572583582776e-13,  1.237741501630380e-15,  6.535866551133932e-18, -4.300955874397612e-20, -1.383666976332333e-21,
 -1.548698800521793e-23,  1.980279074424908e+00, -3.976896471396659e-04, -5.866541328271568e-06, -7.440324783835538e-08, -8.465187648968625e-10, -8.708741222423826e-12,
 -7.984024627089977e-14, -6.201728849778589e-16, -3.422237971141067e-18,  1.034687420173407e-21,  3.917865648447697e-22,  7.380585421173747e-24,  7.338915603585998e-04,
 -4.475259325974944e-06,  2.045189549244734e-08, -8.318003166230032e-11,  3.156671257785015e-13, -1.166061910727361e-15,  3.973357161069446e-18, -1.613406206243737e-20,
  2.179843258069028e-23, -5.285097927280202e-25, -3.328406319262677e-27, -1.834016932744831e-29,  6.607860644633708e-03, -4.026135419480119e-05,  1.835593348392504e-07,
 -7.431780379505372e-10,  2.799459483843427e-12, -1.023169622189571e-14,  3.428050832599756e-17, -1.376378471401917e-19,  1.588852781272578e-22, -4.596044145941299e-24,
 -3.078496211533684e-26, -1.623862614338547e-28,  1.837095691980499e-02, -1.117468381757837e-04,  5.070403357227000e-07, -2.033947455639341e-09,  7.544799825024867e-12,
 -2.696515469205603e-14,  8.709316171669272e-17, -3.412132501110213e-19,  2.415249076894559e-22, -1.192610193719500e-23, -8.981084107471691e-26, -4.380325489051372e-28,
  3.605363809066341e-02, -2.187510589854586e-04,  9.853004375848749e-07, -3.896062175314157e-09,  1.410406436843202e-11, -4.859240509034714e-14,  1.472580537951986e-16,
 -5.525924685729119e-19, -7.738791452962374e-23, -2.115410019827840e-23, -1.871706073458454e-25, -8.288112672064369e-28,  5.970194227917214e-02, -3.609843044748651e-04,
  1.609622599189357e-06, -6.237920428555774e-09,  2.179844663837240e-11, -7.101513621960460e-14,  1.932524827861515e-16, -6.723780637632731e-19, -1.226772067633886e-21,
 -3.084291492388104e-23, -3.295026019378515e-25, -1.329504421898723e-27,  8.937790278433583e-02, -5.380234739407003e-04,  2.367751951279068e-06, -8.932708498982165e-09,
  2.971057372783965e-11, -8.891232711323442e-14,  1.988727957081175e-16, -5.918838479095313e-19, -3.602838062602186e-21, -4.019486900376237e-23, -5.195864950708899e-25,
 -1.964655244766001e-27,  1.251600857794903e-01, -7.492763082166297e-04,  3.243298345066039e-06, -1.181423041173821e-08,  3.667760333820909e-11, -9.592501870204246e-14,
  1.359152206596081e-16, -2.166166191954456e-19, -7.411488681508461e-21, -4.993826690152569e-23, -7.524003915768903e-25, -2.803797548472965e-27,  1.671442299570348e-01,
 -9.939307739826814e-04,  4.214914131293354e-06, -1.467153395367191e-08,  4.128848785869458e-11, -8.497872732397917e-14, -2.172473499306074e-17,  5.007599812477877e-19,
 -1.246985940310164e-20, -6.326455267677664e-23, -1.012363805700222e-24, -3.962822561922946e-27,  2.154439495981428e-01, -1.270884545444527e-03,  5.255187228354624e-06,
 -1.724231168077551e-08,  4.189185719553080e-11, -4.882922513343859e-14, -2.919368851824423e-16,  1.516243650846238e-18, -1.798160427374378e-20, -8.654931587574202e-23,
 -1.274200988785746e-24, -5.576058914290872e-27,  2.701914321344431e-01, -1.578647131274516e-03,  6.329167108370995e-06, -1.920519321370284e-08,  3.662570276896897e-11,
  1.903551518997312e-14, -6.754808557270605e-16,  2.638587590721608e-18, -2.232822069477649e-20, -1.293347928487246e-22, -1.511325476868349e-24, -7.720192042099080e-27,
  3.315380087896947e-01, -1.915203636274271e-03,  7.392412676204655e-06, -2.017136132716946e-08,  2.348814946035880e-11,  1.229346862839720e-13, -1.143349653822257e-15,
  3.465007116904460e-18, -2.297495941008918e-20, -2.026318061322298e-22, -1.717252366724088e-24, -1.027590404828518e-26,  3.996543861626044e-01, -2.277823756918826e-03,
  8.388415893018473e-06, -1.967659523518434e-08,  4.824838950548277e-13,  2.626735987839965e-13, -1.619596485601856e-15,  3.321401663613780e-18, -1.669655289979922e-20,
 -3.139949798767158e-22, -1.945952981156810e-24, -1.274336345124563e-26,  4.747301685591188e-01, -2.662791309070863e-03,  9.245216312936110e-06, -1.717621961176315e-08,
 -3.410668735223126e-11,  4.299316914147440e-13, -1.959653608234900e-15,  1.241532293011882e-18, -5.155566645760122e-22, -4.571925869096443e-22, -2.372111554294888e-24,
 -1.412125420867425e-26,  5.569720220871341e-01, -3.065016621471084e-03,  9.870991319562186e-06, -1.204821590397833e-08, -8.120918376216514e-11,  6.027988504091581e-13,
 -1.926973860935136e-15, -3.935073510423801e-18,  2.596280007607672e-20, -5.944121957104246e-22, -3.351007183278101e-24, -1.318336106930382e-26,  6.465993315026167e-01,
 -3.477473654703512e-03,  1.014842035379592e-05, -3.615338358994776e-09, -1.400737525907934e-10,  7.378884986906596e-13, -1.178437390603750e-15, -1.317770512172884e-17,
  5.580597907956792e-20, -6.324552473306957e-22, -5.395732185763245e-24, -9.908534593770672e-27,  7.438352855909278e-01, -3.890371189957188e-03,  9.927775686572386e-06,
  8.791700741528418e-09, -2.067151062697884e-10,  7.599601238334667e-13,  7.122433047670175e-16, -2.626639792395655e-17,  6.666676452812793e-20, -4.087487740505895e-22,
 -8.844956816964632e-24, -9.263773230064266e-27,  8.488896117552456e-01, -4.289916066128345e-03,  9.019241563245138e-06,  2.568542964006170e-08, -2.712997311033617e-10,
  5.511701608133287e-13,  4.120870634813821e-15, -3.964776914641516e-17,  1.067756586089120e-20,  2.541237913261017e-22, -1.275382601987538e-23, -2.754593647495412e-26,
  9.619258806240419e-01, -4.656447671016370e-03,  7.186567289279258e-06,  4.709822294204369e-08, -3.139718235123261e-10, -5.083914553890726e-14,  8.967964175455673e-15,
 -4.261153317101623e-17, -1.863004664418606e-19,  1.267735742322909e-21, -1.252737562063302e-23, -9.309302301884622e-26,  1.082999772501380e+00, -4.961612884329758e-03,
  4.148522309143887e-06,  7.191136133566152e-08, -2.989495432533795e-10, -1.216605887579015e-12,  1.373961192268184e-14, -1.275749810394959e-17, -5.728460134710319e-19,
  1.490303343178652e-21,  2.010419164868324e-24, -2.025063811949414e-25,  1.211941422213149e+00, -5.164141771078160e-03, -3.938986317535705e-07,  9.652525761740482e-08,
 -1.689420994868162e-10, -2.970206846238143e-12,  1.359948026458673e-14,  8.054703992742359e-17, -9.548869008871010e-19, -2.455052874218856e-21,  3.532409615433099e-23,
 -1.480891721723448e-25,  1.348127389652774e+00, -5.203873687318450e-03, -6.657319409939342e-06,  1.124370015374496e-07,  1.490457893321617e-10, -4.740066427521119e-12,
 -1.566158756557145e-15,  2.304479743504404e-16, -4.024866657238311e-19, -1.405144508069432e-20,  2.476992425825775e-23,  6.017212287012932e-25,  1.490030467245282e+00,
 -4.994823084993590e-03, -1.448667380552278e-05,  1.027723176504968e-07,  6.866593204437995e-10, -4.435506742362438e-12, -4.153135366734847e-14,  2.337862711299405e-16,
  2.623101445928141e-18, -1.683859626499336e-20, -2.168529332728206e-22,  9.047871464369042e-25,  1.634322968092828e+00, -4.423486060758489e-03, -2.263670118502407e-05,
  4.175766516319616e-08,  1.227424878053995e-09,  1.913832100214010e-12, -7.629979878885847e-14, -4.190410695790795e-16,  4.338506132878393e-18,  4.719303270547039e-20,
 -2.372770613836957e-22, -5.296265421250492e-24,  1.774142183529955e+00, -3.378484109296402e-03, -2.742499629010778e-05, -8.290610325414654e-08,  9.446364470928589e-10,
  1.302866715246977e-11,  2.296924338175587e-14, -9.936003659251533e-16, -1.028656868485027e-17,  1.393777308829694e-20,  1.151866076227017e-21,  7.646984481102279e-24,
  1.896215087149662e+00, -1.888725842973803e-03, -2.236478304500759e-05, -1.862740618953171e-07, -8.224405352916508e-10,  4.802134566623245e-12,  1.409252088201860e-13,
  1.410054302112168e-15,  3.820240131902475e-18, -1.126841049753074e-19, -2.110621731307529e-21, -1.687149717454068e-23,  1.978588453123874e+00, -4.484375306702815e-04,
 -6.846747782696027e-06, -8.945118339851611e-08, -1.041325160025479e-09, -1.084550010714925e-11, -9.870696517053067e-14, -7.253377396334482e-16, -3.010551160770017e-18,
  2.479100059622754e-20,  8.409562710347550e-22,  1.357133556284511e-23,  7.163115506210408e-04, -4.315552681606378e-06,  1.948328592239860e-08, -7.831089871038172e-11,
  2.932632305548200e-13, -1.076062088262801e-15,  3.528319331892710e-18, -1.576760848431739e-20,  2.769862398286363e-25, -6.664308146964811e-25, -3.175310285865638e-27,
  3.639224042254328e-29,  6.449696750527121e-03, -3.882780587715339e-05,  1.749033348158553e-07, -6.999803578410267e-10,  2.602743007463718e-12, -9.454797441529951e-15,
  3.047120566112631e-17, -1.354470826275614e-19, -2.959667803043957e-23, -5.868109043340432e-24, -2.928363272784744e-26,  3.307242500861658e-28,  1.793193047654161e-02,
 -1.077861330475840e-04,  4.833398290682444e-07, -1.917434751673898e-09,  7.025627955981607e-12, -2.498911528003607e-14,  7.757775940307821e-17, -3.410699351888245e-19,
 -2.547245385266536e-22, -1.561965202325832e-23, -8.502471716041600e-26,  9.350493355028256e-28,  3.519410788111877e-02, -2.110519028027431e-04,  9.398702182842680e-07,
 -3.677985180975942e-09,  1.316630029519405e-11, -4.524491928829063e-14,  1.316257336238318e-16, -5.687404762901660e-19, -9.777723775324016e-22, -2.881123172914906e-23,
 -1.763115906623542e-25,  1.874307540748738e-27,  5.828329317121951e-02, -3.484009210223592e-04,  1.536814133520024e-06, -5.900262197796392e-09,  2.042297193891096e-11,
 -6.660855055664022e-14,  1.736908149310407e-16, -7.320095138976668e-19, -2.580618902327605e-21, -4.426329539971989e-23, -3.092609525572414e-25,  3.171010778866324e-27,
  8.726302526671463e-02, -5.195022805532424e-04,  2.263353806271375e-06, -8.471311849225618e-09,  2.797864072828629e-11, -8.435276420752298e-14,  1.804392147819715e-16,
 -7.344333525747000e-19, -5.432963879361348e-21, -6.130440538473371e-23, -4.871894812877104e-25,  4.830692946432653e-27,  1.222139893320351e-01, -7.238871728745883e-04,
  3.104985886793256e-06, -1.124256209557166e-08,  3.479108500528863e-11, -9.276450950432952e-14,  1.262170293751760e-16, -4.884938290831670e-19, -9.763961140881350e-21,
 -8.051283742724814e-23, -7.072918868363386e-25,  6.829173738711902e-27,  1.632348461348992e-01, -9.609045934248599e-04,  4.042763251966849e-06, -1.402453914710823e-08,
  3.958459209478686e-11, -8.537934644728430e-14, -1.368936134828612e-17,  5.726985169344431e-20, -1.549553329607358e-20, -1.045453992797383e-22, -9.579930477632952e-25,
  9.109554009244067e-27,  2.104431999819160e-01, -1.229659360620148e-03,  5.052267682582991e-06, -1.658022210293438e-08,  4.084829711404268e-11, -5.539451328700845e-14,
 -2.580782498975413e-16,  8.808503971023630e-19, -2.204396804704786e-20, -1.388714675798246e-22, -1.218801205251540e-24,  1.160124233337833e-26,  2.639766647837479e-01,
 -1.528925658160737e-03,  6.102230632490728e-06, -1.861699350653120e-08,  3.684984489762293e-11,  3.625069624739754e-15, -6.123892993950639e-16,  1.837495726242543e-18,
 -2.811589886616204e-20, -1.920299242901813e-22, -1.465778672147348e-24,  1.427775275775552e-26,  3.239939490777569e-01, -1.857025994100035e-03,  7.152687596346481e-06,
 -1.977734091285262e-08,  2.567983816469431e-11,  9.656822852087142e-14, -1.057817097666808e-15,  2.599250667808338e-18, -3.156710715906662e-20, -2.746737088517210e-22,
 -1.687441186792284e-24,  1.727031182414794e-26,  3.906758110625525e-01, -2.211660389415609e-03,  8.152509675528416e-06, -1.962892927655178e-08,  5.354427280266328e-12,
  2.248478967056721e-13, -1.535888362436711e-15,  2.590496428915729e-18, -2.947809444866295e-20, -3.961009634825511e-22, -1.917303158875242e-24,  2.103837053567937e-26,
  4.642256091349242e-01, -2.589662677175866e-03,  9.036102944724237e-06, -1.765568134261238e-08, -2.597563122478320e-11,  3.832994100636113e-13, -1.927731544802082e-15,
  9.425975237697384e-19, -1.876249912376639e-20, -5.562135728881691e-22, -2.287726205118013e-24,  2.653616753302049e-26,  5.448689458008521e-01, -2.986648194427066e-03,
  9.719006255912539e-06, -1.325366383735242e-08, -6.962420737321440e-11,  5.553024577940582e-13, -2.028930149943206e-15, -3.473141175427992e-18,  2.093208154907722e-21,
 -7.302958222948707e-22, -3.097179859366344e-24,  3.514366579653142e-26,  6.328514845208364e-01, -3.396496817177352e-03,  1.009207090727236e-05, -5.740115028400958e-09,
 -1.256277464606896e-10,  7.053575488750655e-13, -1.526133968297673e-15, -1.179811180301113e-17,  2.914476482294745e-20, -8.453989777553794e-22, -4.838782384611130e-24,
  4.775038950132713e-26,  7.284332355618074e-01, -3.810582049388926e-03,  1.001393535423675e-05,  5.606535509092995e-09, -1.914033583360433e-10,  7.684534760543588e-13,
  3.950894691967383e-18, -2.443681847066253e-17,  4.560747566373507e-20, -7.561653250371927e-22, -8.017338022709298e-24,  6.176901755998336e-26,  8.318761044155418e-01,
 -4.216602155706682e-03,  9.301802094123916e-06,  2.143781810467304e-08, -2.593770176184212e-10,  6.367929083391580e-13,  3.016181253492798e-15, -3.925949462832157e-17,
  1.051789150802597e-20, -2.606518652012999e-22, -1.232323970393577e-23,  6.476703358265608e-26,  9.434185339076806e-01, -4.596779821697270e-03,  7.721607859891294e-06,
  4.207781645078560e-08, -3.129362537723417e-10,  1.494393960845167e-13,  7.697510534159495e-15, -4.794622778464905e-17, -1.504425464578074e-19,  7.111790349167295e-22,
 -1.442955643664910e-23,  2.821744621642943e-26,  1.063225045495483e+00, -4.925056008379333e-03,  4.982014145084481e-06,  6.695127007414167e-08, -3.200235824309018e-10,
 -8.931634110889767e-13,  1.313384878870458e-14, -3.023066804240950e-17, -5.196703858398613e-19,  1.419332067279247e-21, -4.607482066151619e-24, -6.978931300178494e-26,
  1.191285817993718e+00, -5.162710095965900e-03,  7.462850693432243e-07,  9.336538838649073e-08, -2.249178374663498e-10, -2.620280623863704e-12,  1.541558993069399e-14,
  4.883621073647067e-17, -1.019434625134577e-18, -1.172755077367453e-21,  2.915971443029644e-23, -9.465968713598375e-26,  1.327213970735963e+00, -5.251701933473961e-03,
 -5.296896136540063e-06,  1.140634430390308e-07,  5.438176250251300e-11, -4.702138431225723e-12,  4.631678751892156e-15,  2.097160694786243e-16, -8.843738732142109e-19,
 -1.255678077965221e-20,  4.958968407468745e-23,  5.545381388826454e-25,  1.469827453180028e+00, -5.105603714963192e-03, -1.319058308660368e-05,  1.129974173635397e-07,
  5.885583206089922e-10, -5.344839695891936e-12, -3.391273534890312e-14,  3.064441581896145e-16,  1.872488933304094e-18, -2.448378568715503e-20, -1.596026640427533e-22,
  1.703836425426877e-24,  1.616270484542881e+00, -4.602239198722686e-03, -2.201684575417848e-05,  6.159949375780366e-08,  1.246526648203790e-09, -4.097967467402866e-14,
 -8.584955917870917e-14, -2.553066262847781e-16,  5.811594989274331e-18,  3.318850836147050e-20, -4.564642819805663e-22, -4.399529248950312e-24,  1.760183535322795e+00,
 -3.601586682939284e-03, -2.832051592483543e-05, -6.568750056103152e-08,  1.208279861929551e-09,  1.320967972089262e-11, -9.317621997802625e-15, -1.305257055470230e-15,
 -8.884573817840539e-18,  6.557441221261631e-20,  1.395098931678444e-21,  2.868246647320963e-24,  1.888287885812852e+00, -2.076800405498496e-03, -2.467522424246790e-05,
 -1.984673842141493e-07, -6.893245396599565e-10,  8.667565645347575e-12,  1.813839573037005e-13,  1.449690596118623e-15, -1.928082810390332e-18, -2.110856582819778e-19,
 -2.772382149077732e-21, -1.168745125414150e-23,  1.976677934047393e+00, -5.078057666175192e-04, -8.027723477980235e-06, -1.079834678411717e-07, -1.283621715066398e-09,
 -1.346797845880399e-11, -1.201771864972925e-13, -7.995829158472177e-16, -1.345083462473991e-18,  7.302673934465921e-20,  1.644781465179790e-21,  2.374897753724347e-23,
  6.993552313344683e-04, -4.163367156235207e-06,  1.857101269991086e-08, -7.378640640849228e-11,  2.725529327576810e-13, -9.967022711584286e-16,  3.083196503162197e-18,
 -1.616201991659754e-20, -2.530524012542961e-23, -7.257001150269063e-25,  1.322215344430172e-27,  1.900450130072049e-28,  6.297131762691629e-03, -3.746148442926345e-05,
  1.667473188610547e-07, -6.598107968132632e-10,  2.420651546330960e-12, -8.769308005779878e-15,  2.663230830934494e-17, -1.399540466027488e-19, -2.556342517919032e-22,
 -6.426351737351504e-24,  1.138496425759348e-26,  1.716391668122875e-27,  1.750837630514633e-02, -1.040095776547422e-04,  4.609888982775533e-07, -1.808925071844725e-09,
  6.543683724413125e-12, -2.324330980315081e-14,  6.782517550157622e-17, -3.587444175659009e-19, -8.605504662538371e-22, -1.729968809073405e-23,  2.895322540264201e-26,
  4.800088960993421e-27,  3.436466363308666e-02, -2.037059707958029e-04,  8.969690403063898e-07, -3.474397414110006e-09,  1.229167968324825e-11, -4.228153541647587e-14,
  1.150987314508088e-16, -6.177265937958422e-19, -2.106696203189433e-21, -3.244315998816616e-23,  4.981257959264413e-26,  9.498856388402940e-27,  5.691383780408761e-02,
 -3.363841653001616e-04,  1.467928344991353e-06, -5.583932678277322e-09,  1.913077177038480e-11, -6.269680579409020e-14,  1.517842200159712e-16, -8.420366880191199e-19,
 -4.337545209306151e-21, -5.088974514971133e-23,  6.984362325220097e-26,  1.588929361299019e-26,  8.522059656233806e-02, -5.017945896053191e-04,  2.164329082927069e-06,
 -8.036922119688375e-09,  2.633311453216415e-11, -8.029079728671247e-14,  1.570861096263245e-16, -9.466987449395663e-19, -7.900792636049600e-21, -7.207710430412634e-23,
  8.748831861688001e-26,  2.405727711454882e-26,  1.193672791551983e-01, -6.995776055442448e-04,  2.973354380057117e-06, -1.070058779172631e-08,  3.296478451824387e-11,
 -8.993759385339096e-14,  1.076953638765241e-16, -8.518395770514890e-19, -1.304441836789523e-20, -9.646631943131222e-23,  1.066058258584476e-25,  3.409002994160822e-26,
  1.594548611374914e-01, -9.292250281732691e-04,  3.878212493811065e-06, -1.340486472974253e-08,  3.787354439318592e-11, -8.574839448931871e-14, -1.963951710900680e-17,
 -5.049438687208989e-19, -1.977796126298383e-20, -1.262670026439738e-22,  1.390304773719900e-25,  4.607595079458138e-26,  2.056041542975018e-01, -1.190026045434116e-03,
  4.857188822694573e-06, -1.593584211586423e-08,  3.968003316310769e-11, -6.137705659952042e-14, -2.441000235957213e-16,  8.766391250898881e-20, -2.770024409222519e-20,
 -1.661497813570624e-22,  2.054914820366807e-25,  6.012217289396320e-26,  2.579571971008847e-01, -1.480991405230246e-03,  5.882364144543916e-06, -1.802759895426785e-08,
  3.677898642779457e-11, -1.056328978048625e-14, -5.746443452356906e-16,  8.178859715820873e-19, -3.580796050335460e-20, -2.236743884974122e-22,  3.324689665344317e-25,
  7.640461736251457e-26,  3.166787950684198e-01, -1.800746682841128e-03,  6.917884099071676e-06, -1.935236940908941e-08,  2.736259150765280e-11,  7.193027177913676e-14,
 -1.000746150141047e-15,  1.420348273154789e-18, -4.233037048601800e-20, -3.088751279572001e-22,  5.409527200005773e-25,  9.526869748092870e-26,  3.819581203515170e-01,
 -2.147380715341632e-03,  7.917618523637758e-06, -1.950926300465700e-08,  9.488038734756809e-12,  1.887367516179165e-13, -1.478793475132598e-15,  1.407282988999492e-18,
 -4.470164736888558e-20, -4.319468098657183e-22,  8.211958594876638e-25,  1.173929201593247e-25,  4.540101850145186e-01, -2.518227825372097e-03,  8.821985963939930e-06,
 -1.801246978814302e-08, -1.877059197049246e-11,  3.372636703549782e-13, -1.912860143295241e-15,  7.937211899278789e-21, -3.991671331864161e-20, -5.972004287062348e-22,
  1.086958864219120e-24,  1.439905310888335e-25,  5.330768242000637e-01, -2.909550431322431e-03,  9.553636204667737e-06, -1.428148173381792e-08, -5.901304528532228e-11,
  5.054236872256695e-13, -2.129337014387568e-15, -3.845894917392728e-18, -2.577166799946501e-20, -7.905431282870676e-22,  1.108886212747717e-24,  1.769032972757831e-25,
  6.194264872934240e-01, -3.316068887524721e-03,  1.001158804972506e-05, -7.639402636825666e-09, -1.119132048548064e-10,  6.648422386934618e-13, -1.848231704855126e-15,
 -1.138351682823031e-17, -3.927621769189454e-21, -9.576757714747312e-22,  4.556322905122572e-25,  2.181301343515952e-25,  7.133514844663562e-01, -3.730252347625421e-03,
  1.006334562467602e-05,  2.666809469873267e-09, -1.760880252306072e-10,  7.604752552663309e-13, -6.643381648551907e-16, -2.346689331334300e-17,  1.367933015075709e-20,
 -9.749770112715192e-22, -1.435860947905118e-24,  2.676974221081170e-25,  8.151600556056843e-01, -4.141228282608416e-03,  9.534587721479975e-06,  1.739323257936909e-08,
 -2.460061684951201e-10,  6.960162250679861e-13,  1.919586404206546e-15, -3.915936971014439e-17, -6.541099664397756e-21, -6.377120509339847e-22, -4.700174892847936e-24,
  3.180476226438718e-25,  9.251580384719937e-01, -4.533072052233282e-03,  8.196629651070731e-06,  3.710431827707445e-08, -3.082115305500432e-10,  3.175455234583960e-13,
  6.290706444754528e-15, -5.245560584017375e-17, -1.342850726285531e-19,  2.330890677150660e-22, -7.185820271289076e-24,  3.450226729689940e-25,  1.043609497444119e+00,
 -4.882074528572007e-03,  5.754172245135238e-06,  6.170479213619499e-08, -3.348128062116075e-10, -5.899417935411546e-13,  1.206199431379229e-14, -4.607926578740406e-17,
 -4.718623560747908e-19,  1.262450570338191e-21, -4.679504848729461e-25,  3.133726446598292e-25,  1.170653922487996e+00, -5.152323304608726e-03,  1.843414457567349e-06,
  8.936795819517573e-08, -2.735321356939929e-10, -2.237614863303981e-12,  1.632152837639516e-14,  1.576006495204423e-17, -1.040975492838136e-18, -8.543672615400040e-24,
  3.180542087145463e-23,  2.874253680796447e-25,  1.306131093006281e+00, -5.288594363811646e-03, -3.925992712775363e-06,  1.141891825570967e-07, -3.809201306570572e-11,
 -4.524114222155713e-12,  1.004258770192602e-14,  1.746161342676932e-16, -1.294467682775694e-18, -1.003902490087763e-20,  7.824963775925286e-23,  8.282397527361212e-25,
  1.449202791746133e+00, -5.205552812283358e-03, -1.178177508016160e-05,  1.215179822680984e-07,  4.742488746704445e-10, -6.049863758665881e-12, -2.463379111371695e-14,
  3.511908297842738e-16,  8.965536730314537e-19, -2.910959905023358e-20, -6.482142023413720e-23,  2.652397353251607e-24,  1.597514417432540e+00, -4.775078933900100e-03,
 -2.115838064864828e-05,  8.142337594730150e-08,  1.224636929749530e-09, -2.165168126486438e-12, -9.024207584547287e-14, -5.408524814609116e-17,  6.636753951416449e-18,
  1.170887611194406e-20, -5.979944733829468e-22, -1.715811963646657e-24,  1.745319558360540e+00, -3.830955222398567e-03, -2.898412730892404e-05, -4.426659648673884e-08,
  1.467121541079569e-09,  1.251793405715778e-11, -4.941258839061415e-14, -1.540895324650385e-15, -5.507415701670900e-18,  1.218511357245016e-19,  1.364495382690737e-21,
 -4.535395931717122e-24,  1.879570551769231e+00, -2.283901351097981e-03, -2.711648405402081e-05, -2.078596636508834e-07, -4.692218624661253e-10,  1.349309698782856e-11,
  2.198117644571437e-13,  1.244219853025131e-15, -1.161228372696419e-17, -3.282266256632628e-19, -2.958268725676770e-21,  5.757479911705967e-24,  1.974509539432262e+00,
 -5.775814334965198e-04, -9.456170202642011e-06, -1.308406664256432e-07, -1.583650262745763e-09, -1.662281649800610e-11, -1.426693457342139e-13, -7.855799074259593e-16,
  2.757044469346162e-18,  1.638726322165223e-19,  3.010871094431803e-21,  3.932154486847005e-23,  };
  constexpr double w[9984] = {  1.183978805210559e-01, -6.080615436321836e-04,  3.344586320871367e-06, -1.924073525009431e-08,  1.133964840455872e-10,
 -6.750854474973296e-13,  4.025609176651033e-15, -2.393740862700941e-17,  1.416232312092055e-19, -8.329618879317011e-22,  4.869050132518723e-24, -2.829005300125891e-26,
  1.171863074315817e-01, -9.933866808075006e-04,  9.628582988658506e-06, -9.037633777724473e-08,  8.083247865635263e-10, -6.940450210475864e-12,  5.764742948487420e-14,
 -4.657823711084283e-16,  3.675644861200308e-18, -2.841360530707023e-20,  2.156576606937622e-22, -1.610009883627995e-24,  1.148149909023815e-01, -1.735593376062562e-03,
  2.539305668630343e-05, -3.296090379433252e-07,  3.928660848676208e-09, -4.393279210971238e-11,  4.669473046653076e-13, -4.758344907224947e-15,  4.678052639769785e-17,
 -4.457938478030212e-19,  4.132810674158482e-21, -3.737888493125726e-23,  1.113828297917166e-01, -2.780865250189349e-03,  5.630385045963159e-05, -9.628581278683601e-07,
  1.470791744654433e-08, -2.065147934596295e-10,  2.712341429293404e-12, -3.371531674894226e-14,  3.999808086018819e-16, -4.557168283769237e-18,  5.010600739560049e-20,
 -5.336274390395085e-22,  1.070269638383072e-01, -4.055666779472357e-03,  1.092026548518661e-04, -2.389759642543414e-06,  4.554360215761305e-08, -7.831984455578766e-10,
  1.241898948239900e-11, -1.842244508983538e-13,  2.582936659407094e-15, -3.449056143630436e-17,  4.412223706638872e-19, -5.431794495147703e-21,  1.019111210396740e-01,
 -5.474109393027888e-03,  1.905265319999994e-04, -5.210580623486046e-06,  1.213217220531307e-07, -2.507161249318876e-09,  4.716207615633581e-11, -8.212574611113636e-13,
  1.339753213170822e-14, -2.065750540035255e-16,  3.031081725573495e-18, -4.254482480855899e-20,  9.621269009787808e-02, -6.945958572159615e-03,  3.047678456187319e-04,
 -1.020579959972697e-05,  2.852723987963165e-07, -6.974031047386300e-09,  1.534027452895472e-10, -3.093921350694149e-12,  5.798701179725658e-14, -1.020044175445938e-15,
  1.697062237686520e-17, -2.685958881868148e-19,  9.011008701210273e-02, -8.384218749583753e-03,  4.532718156876183e-04, -1.825209661822589e-05,  6.031120693072894e-07,
 -1.720537841925110e-08,  4.370571436770891e-10, -1.009211610428967e-11,  2.149635470629012e-13, -4.269945803635022e-15,  7.976305503090714e-17, -1.410170018074257e-18,
  8.377174590883846e-02, -9.711426211933487e-03,  6.335754341048648e-04, -3.017884528114773e-05,  1.162571094361408e-06, -3.822833741445022e-08,  1.109007138494136e-09,
 -2.901787038191558e-11,  6.956928534048044e-13, -1.546274795898798e-14,  3.215167225567188e-16, -6.297100441063591e-18,  7.734764718442932e-02, -1.086409515370135e-02,
  8.393647045754132e-04, -4.658929157626701e-05,  2.065790267365494e-06, -7.741862930456742e-08,  2.538766892160241e-09, -7.456625730332586e-11,  1.994520881004534e-12,
 -4.919447855594596e-14,  1.129673096645257e-15, -2.432728345058898e-17,  7.096380735257092e-02, -1.179511732659641e-02,  1.061001662547685e-03, -6.768366452063747e-05,
  3.413657987284764e-06, -1.442802345289884e-07,  5.297508865379673e-09, -1.731267972065170e-10,  5.124462450167924e-12, -1.391841548781480e-13,  3.504109962956462e-15,
 -8.239527505485742e-17,  6.471969658727440e-02, -1.247423597751138e-02,  1.286476921678122e-03, -9.312370525533563e-05,  5.283559558285712e-06, -2.493760824755301e-07,
  1.016036787308581e-08, -3.664208399698458e-10,  1.190969285516238e-11, -3.536350208912520e-13,  9.694232490776437e-15, -2.472765309640205e-16,  5.868819626720352e-02,
 -1.288694764202241e-02,  1.502593315922265e-03, -1.219696590475563e-04,  7.704425178714327e-06, -4.023103564946324e-07,  1.803470419030801e-08, -7.120993988498653e-10,
  2.522946314243505e-11, -8.133484709072385e-13,  2.411944355743237e-14, -6.632556342715195e-16,  5.291749595278394e-02, -1.303230889420904e-02,  1.696182949689535e-03,
 -1.527050630553893e-04,  1.063453379208872e-05, -6.089619458038772e-07,  2.979240725033340e-08, -1.278287378079821e-09,  4.902136119604394e-11, -1.704470528430525e-12,
  5.433602042063566e-14, -1.601226411429303e-15,  4.743425648744311e-02, -1.292014529215168e-02,  1.855193663394495e-03, -1.833467059941282e-04,  1.394768352053189e-05,
 -8.684887578736943e-07,  4.601188078756614e-08, -2.129806990406695e-09,  8.780898802738374e-11, -3.271891981341266e-12,  1.114477058167160e-13, -3.499290936119029e-15,
  4.224740612649748e-02, -1.256810141422080e-02,  1.969535683468219e-03, -2.116217033698822e-04,  1.743199317894391e-05, -1.170846980826024e-06,  6.667283614893943e-08,
 -3.306214790890853e-09,  1.455852203294793e-10, -5.777445391710868e-12,  2.090366659556134e-13, -6.954044272245234e-15,  3.735204972584162e-02, -1.199886686232818e-02,
  2.031638818462418e-03, -2.351838839253239e-04,  2.080314849990894e-05, -1.495602814805625e-06,  9.088144943607970e-08, -4.795438328300478e-09,  2.240927401204790e-10,
 -9.414065764627464e-12,  3.597333935858799e-13, -1.261016367169179e-14,  3.273311655774063e-02, -1.123779458378325e-02,  2.036722401299413e-03, -2.518386571180365e-04,
  2.373103797893503e-05, -1.812622193002674e-06,  1.167198220933135e-07, -6.510441017839195e-09,  3.208619304229852e-10, -1.418502646160256e-11,  5.692525246456845e-13,
 -2.091394720453708e-14,  2.836851762313575e-02, -1.031101838271435e-02,  1.982817113170628e-03, -2.597484052798698e-04,  2.587615974566560e-05, -2.084845994119910e-06,
  1.413014513369369e-07, -8.278264528751929e-09,  4.276716971683740e-10, -1.978187421665694e-11,  8.291092486365011e-13, -3.175699137560527e-14,  2.423170728054371e-02,
 -9.244089857110631e-03,  1.870597961872382e-03, -2.575972583726098e-04,  2.693046539268329e-05, -2.272892027140168e-06,  1.610724555916122e-07, -9.849586047921970e-09,
  5.302243354216682e-10, -2.551452514646070e-11,  1.110801869358172e-12, -4.412647250484242e-14,  2.029363685670636e-02, -8.061096113892172e-03,  1.703092986757748e-03,
 -2.447025869436324e-04,  2.665668982024286e-05, -2.340792298685288e-06,  1.723362727675058e-07, -1.093223204175141e-08,  6.096387420758805e-10, -3.034829133852212e-11,
  1.365069081484745e-12, -5.595234513983392e-14,  1.652414896310038e-02, -6.784187031111456e-03,  1.485326762871705e-03, -2.210687397323647e-04,  2.492065840801800e-05,
 -2.261882178493239e-06,  1.719149411918127e-07, -1.124498141803710e-08,  6.458530934865949e-10, -3.307678882557415e-11,  1.529000035344709e-12, -6.433704221042168e-14,
  1.289289680595737e-02, -5.433430101724435e-03,  1.223946138189726e-03, -1.873851976361656e-04,  2.171231965037189e-05, -2.023772538074695e-06,  1.578123589451914e-07,
 -1.058071253083841e-08,  6.223313033453419e-10, -3.261060471783939e-11,  1.541063591597717e-12, -6.623256467805229e-14,  9.369902008942114e-03, -4.026920877401573e-03,
  9.268630086802347e-04, -1.449760598905851e-04,  1.715300495654341e-05, -1.631471001872498e-06,  1.297293448098962e-07, -8.863137061257259e-09,  5.308494579556811e-10,
 -2.830716476818554e-11,  1.360399084334573e-12, -5.942059284008246e-14,  5.926020756539717e-03, -2.581157078952618e-03,  6.029512079366503e-04, -9.571276530889588e-05,
  1.148858758539818e-05, -1.108062635505276e-06,  8.930497496423678e-08, -6.181163949557282e-09,  3.748831328192973e-10, -2.023319536770907e-11,  9.837533762311679e-13,
 -4.345201568378799e-14,  2.536872140194742e-03, -1.113146187443152e-03,  2.621641785537429e-04, -4.195745794314763e-05,  5.076581937410066e-06, -4.934334837380529e-07,
  4.006697588021014e-08, -2.793276332086298e-09,  1.705925477996713e-10, -9.269147497146185e-12,  4.535934172636774e-13, -2.015976750109624e-14,  1.160177276647857e-01,
 -5.821985576336276e-04,  3.124154406887231e-06, -1.752937479539633e-08,  1.008091650399516e-10, -5.860281085359287e-13,  3.414555492963570e-15, -1.984996563445576e-17,
  1.148621322624116e-19, -6.609502788877090e-22,  3.780896358103215e-24, -2.150201494694336e-26,  1.133602465120347e-01, -9.204862989487851e-04,  8.617317354863148e-06,
 -7.848264764909783e-08,  6.823596569523965e-10, -5.701012529887986e-12,  4.610955132319992e-14, -3.629922665284326e-16,  2.792368961356414e-18, -2.105158545222036e-20,
  1.558886398398969e-22, -1.135858251408777e-24,  1.082552813057001e-01, -1.547264595674235e-03,  2.178775957422630e-05, -2.732132472141627e-07,  3.152095653248799e-09,
 -3.416946529698417e-11,  3.524688092554028e-13, -3.489197898512347e-15,  3.335010178061801e-17, -3.091894414860328e-19,  2.790318063602335e-21, -2.458013212863798e-23,
  1.010923142867274e-01, -2.372943500824481e-03,  4.603585182509756e-05, -7.573336851666291e-07,  1.115899569004281e-08, -1.514394317528131e-10,  1.925353640148837e-12,
 -2.319569142221286e-14,  2.669811113162459e-16, -2.953801945676161e-18,  3.156142777328684e-20, -3.268784093326411e-22,  9.238595935405737e-02, -3.285459464017588e-03,
  8.442885443277600e-05, -1.771778761105830e-06,  3.248617999204872e-08, -5.387383716495959e-10,  8.253020621965810e-12, -1.184488669287738e-13,  1.608746324209353e-15,
 -2.083158623286306e-17,  2.586599168157395e-19, -3.093318627450805e-21,  8.270912691016184e-02, -4.170452385010072e-03,  1.381714948944479e-04, -3.616106755189491e-06,
  8.085877596708715e-08, -1.608885835286387e-09,  2.919876028616285e-11, -4.913516979499041e-13,  7.756753950187770e-15, -1.158758284002751e-16,  1.649024183680150e-18,
 -2.246983531925063e-20,  7.262654464548109e-02, -4.929533284935416e-03,  2.056572521414551e-04, -6.583323436269229e-06,  1.765464824103660e-07, -4.152003367027663e-09,
  8.804595343078626e-11, -1.714952581087665e-12,  3.108765047511962e-14, -5.296045521798988e-16,  8.542809540666124e-18, -1.312259938973203e-19,  6.263966075539637e-02,
 -5.492973720306914e-03,  2.824035688099163e-04, -1.086895825153326e-05,  3.444952774464909e-07, -9.452343243026884e-09,  2.314471679130853e-10, -5.160883469285869e-12,
  1.063187175147261e-13, -2.045307796016211e-15,  3.704677237435182e-17, -6.357785882624242e-19,  5.314983130974647e-02, -5.825107708478276e-03,  3.618311984061847e-04,
 -1.648489889543016e-05,  6.094566892168402e-07, -1.928395809209980e-08,  5.394754003127966e-10, -1.363707408141732e-11,  3.163547981074220e-13, -6.813089355773974e-15,
  1.374342262551275e-16, -2.614290195935413e-18,  4.444178045846313e-02, -5.922798207413844e-03,  4.365690143403210e-04, -2.321145191631327e-05,  9.889234301328233e-07,
 -3.569997237737809e-08,  1.130046073376997e-09, -3.209517539821369e-11,  8.314447221260309e-13, -1.988858341920258e-14,  4.434716610078507e-16, -9.283743133278011e-18,
  3.668507130272830e-02, -5.808839435816207e-03,  4.998471660684671e-04, -3.060783419305499e-05,  1.485952491285292e-06, -6.059411046764847e-08,  2.150727336324259e-09,
 -6.806210305500758e-11,  1.953733854233248e-12, -5.153008450909871e-14,  1.261314168109191e-15, -2.886724644893453e-17,  2.994864829978963e-02, -5.522828125501006e-03,
  5.465944745997720e-04, -3.807935312575842e-05,  2.084415030175559e-06, -9.511445589550372e-08,  3.753351018201166e-09, -1.313094542766624e-10,  4.146044595770065e-12,
 -1.197444717540006e-13,  3.196525578172371e-15, -7.948364529768705e-17,  2.422262887906439e-02, -5.111884039607625e-03,  5.740212846978396e-04, -4.497991116039689e-05,
  2.748543429047181e-06, -1.390982178824721e-07,  6.053054392677116e-09, -2.323488129248985e-10,  8.013217142206156e-12, -2.517595282244894e-13,  7.283719653292033e-15,
 -1.956065412439420e-16,  1.944209406713790e-02, -4.622917024511769e-03,  5.816604057936724e-04, -5.071927804229311e-05,  3.427162962914827e-06, -1.907218303674905e-07,
  9.081037254711219e-09, -3.797010365509793e-10,  1.420670234720857e-11, -4.824568390627131e-13,  1.503647070602931e-14, -4.336178324923275e-16,  1.550904072024245e-02,
 -4.097278307275931e-03,  5.709855172625161e-04, -5.484762146612008e-05,  4.061414072152580e-06, -2.465041722332254e-07,  1.274552399880933e-08, -5.764356850759129e-10,
  2.324480247420853e-11, -8.479669219380100e-13,  2.830277359894830e-14, -8.715355126694542e-16,  1.231029749037400e-02, -3.567881361214413e-03,  5.447957732567101e-04,
 -5.710127338076688e-05,  4.593773382766659e-06, -3.016867501712354e-07,  1.681511740860597e-08, -8.169640763920127e-10,  3.527797892526262e-11, -1.374045843783371e-12,
  4.883208914409608e-14, -1.596854530570737e-15,  9.730633897509786e-03, -3.058381426216680e-03,  5.065519137178377e-04, -5.740745148236364e-05,  4.976076487904630e-06,
 -3.508953424137595e-07,  2.093261314607232e-08, -1.085229747885620e-09,  4.986550679403992e-11, -2.061294496557450e-12,  7.755765533154371e-14, -2.678733638753526e-15,
  7.661293949697943e-03, -2.583783457860274e-03,  4.597996245561124e-04, -5.585641926956696e-05,  5.174901140940371e-06, -3.889119671647746e-07,  2.465803055257099e-08,
 -1.355151142963732e-09,  6.584686429452245e-11, -2.871743375217956e-12,  1.137528175674401e-13, -4.127377958226961e-15,  6.004737705844368e-03, -2.151844764204959e-03,
  4.077511370420649e-04, -5.265485955012413e-05,  5.173682130843901e-06, -4.113766554268264e-07,  2.753107459125784e-08, -1.593531447588451e-09,  8.137632608623113e-11,
 -3.722461705352328e-12,  1.543643326548937e-13, -5.852515284348020e-15,  4.676562984992483e-03, -1.764760574632714e-03,  3.530392744325522e-04, -4.807428711399892e-05,
  4.971871231108049e-06, -4.152863526493958e-07,  2.913865601475384e-08, -1.764921213388059e-09,  9.414503557925605e-11, -4.490743564461818e-12,  1.938716947684588e-13,
 -7.639730506324587e-15,  3.605531320916378e-03, -1.420786963310530e-03,  2.976205812339214e-04, -4.240498437798073e-05,  4.582054812489843e-06, -3.992343440977061e-07,
  2.917349548165986e-08, -1.837381647381809e-09,  1.017579794089829e-10, -5.032181472354340e-12,  2.249146149394390e-13, -9.163006211233429e-15,  2.732453991127634e-03,
 -1.115611325247873e-03,  2.427869151711674e-04, -3.592139099526862e-05,  4.026131021315822e-06, -3.634063494778108e-07,  2.747410084733024e-08, -1.787916606817223e-09,
  1.021854371824330e-10, -5.208704602640736e-12,  2.396875942490209e-13, -1.004182095558498e-14,  2.008490626708744e-03, -8.433996291228105e-04,  1.892432360002439e-04,
 -2.886077214085379e-05,  3.331515220666440e-06, -3.093977986872600e-07,  2.404225933535067e-08, -1.606519416497847e-09,  9.418588105479487e-11, -4.920058194427760e-12,
  2.318093891437269e-13, -9.934225745848995e-15,  1.393226264950328e-03, -5.975272746103197e-04,  1.372169884825671e-04, -2.141418930531617e-05,  2.528040785154678e-06,
 -2.399346368263140e-07,  1.903943936321168e-08, -1.298189796060445e-09,  7.760479095828191e-11, -4.130574877468646e-12,  1.981557940558024e-13, -8.640401902563727e-15,
  8.527626983225695e-04, -3.710507900672298e-04,  8.657767791903752e-05, -1.372772014164507e-05,  1.645926750100312e-06, -1.585758841304023e-07,  1.276709298966611e-08,
 -8.827644329343988e-10,  5.348636151373854e-11, -2.884019538707504e-12,  1.400941570262668e-13, -6.182410979434665e-15,  3.584118795075950e-04, -1.571966590874801e-04,
  3.700392814012575e-05, -5.919223008550397e-06,  7.158309662395052e-07, -6.954329588958455e-08,  5.644238557397355e-09, -3.933051098951989e-10,  2.400918350863601e-11,
 -1.303957592618556e-12,  6.378247146948068e-14, -2.833583739202167e-15,  1.137376252439272e-01, -5.580201750192162e-04,  2.923106734773628e-06, -1.600592184263227e-08,
  8.986513337018233e-11, -5.103540099765234e-13,  2.906835493490332e-15, -1.652764897326425e-17,  9.357691114191823e-20, -5.270379031029577e-22,  2.951563778736863e-24,
 -1.643648244190387e-26,  1.098104647859807e-01, -8.551376167178517e-04,  7.737455185014956e-06, -6.842021087765836e-08,  5.786317937006023e-10, -4.706911026313035e-12,
  3.709086396859877e-14, -2.846499904234830e-16,  2.135681922184556e-18, -1.571032054166454e-20,  1.135576333674884e-22, -8.079352328264472e-25,  1.023952083689718e-01,
 -1.385268492937753e-03,  1.879065296045746e-05, -2.278183839699260e-07,  2.545967608650752e-09, -2.677155439070518e-11,  2.681809317312245e-13, -2.580495633278514e-15,
  2.399264143538747e-17, -2.165181402705061e-19,  1.903100096781048e-21, -1.633630393179226e-23,  9.228355741204547e-02, -2.038188362528006e-03,  3.792672971979520e-05,
 -6.007140343117681e-07,  8.544286118531468e-09, -1.121494856529647e-10,  1.381082726555129e-12, -1.613560942681427e-14,  1.802851097425044e-16, -1.937905275716181e-18,
  2.013277872353625e-20, -2.028707185595109e-22,  8.047180476680599e-02, -2.686991932990968e-03,  6.596262881795244e-05, -1.328467278529545e-06,  2.345085950766195e-08,
 -3.752750942509109e-10,  5.557261248757061e-12, -7.720991551759345e-14,  1.016345804459683e-15, -1.276827624642040e-17,  1.539515023615430e-19, -1.789258418565776e-21,
  6.799134828420980e-02, -3.218879430171661e-03,  1.015904615875074e-04, -2.545931180465704e-06,  5.470449341439554e-08, -1.048604356905297e-09,  1.836949130422829e-11,
 -2.988602643163306e-13,  4.567562836579509e-15, -6.613489623721291e-17,  9.131472529552309e-19, -1.208336194342468e-20,  5.575891792334765e-02, -3.557892829510456e-03,
  1.411972268120146e-04, -4.322596738032382e-06,  1.112619070939764e-07, -2.518222801953460e-09,  5.150031355785607e-11, -9.690990309644589e-13,  1.699633933546939e-14,
 -2.804922062430885e-16,  4.387890145155080e-18, -6.543320536754820e-20,  4.447572864299523e-02, -3.674377771256603e-03,  1.796673907049012e-04, -6.610597231138508e-06,
  2.010223285437620e-07, -5.306238534150641e-09,  1.252645231962872e-10, -2.697812414732478e-12,  5.376208290405730e-14, -1.001807326214532e-15,  1.759739312612295e-17,
 -2.931852312135261e-19,  3.458629391957131e-02, -3.581272239238330e-03,  2.117607435448818e-04, -9.227363097466172e-06,  3.273951949153629e-07, -9.968280116807764e-09,
  2.689252977246609e-10, -6.567619643115102e-12,  1.474239810244197e-13, -3.076382719015250e-15,  6.020367825515605e-17, -1.112235939055569e-18,  2.629026643774426e-02,
 -3.321422228184746e-03,  2.334585934178687e-04, -1.188595869579949e-05,  4.864632909519361e-07, -1.691277345353143e-08,  5.166752925662160e-10, -1.418778159199658e-11,
  3.559076228171112e-13, -8.255306196137906e-15,  1.787118639057473e-16, -3.636288667124672e-18,  1.958981407783103e-02, -2.951708831842076e-03,  2.427908637622101e-04,
 -1.426291689081115e-05,  6.662121748005113e-07, -2.619983935543312e-08,  8.986335311336318e-10, -2.752837001839916e-11,  7.660814815267184e-13, -1.961500324278158e-14,
  4.666521249466375e-16, -1.039209754423697e-17,  1.435223446944030e-02, -2.528960698043878e-03,  2.399622943507968e-04, -1.607651931903927e-05,  8.484399234405148e-07,
 -3.740724029505420e-08,  1.428917293936290e-09, -4.846937663693359e-11,  1.485980532957662e-12, -4.172548962045864e-14,  1.084168002783999e-15, -2.626879917170745e-17,
  1.037100077850072e-02, -2.100478151102777e-03,  2.268971937160657e-04, -1.714677288583132e-05,  1.012730279203862e-06, -4.963385216934662e-08,  2.095222056791484e-09,
 -7.813485434949203e-11,  2.621449329400690e-12, -8.021868046714784e-14,  2.262952599578105e-15, -5.931811675226195e-17,  7.414938806218851e-03, -1.699732770615921e-03,
  2.064884192225970e-04, -1.742007334472908e-05,  1.140997946321714e-06, -6.165350313133017e-08,  2.854661576148818e-09, -1.162277895904021e-10,  4.239758009694682e-12,
 -1.405298518472735e-13,  4.279178509799735e-15, -1.206827422794375e-16,  5.261739126339055e-03, -1.346239694688629e-03,  1.818427907124845e-04, -1.695799655922284e-05,
  1.221032443749756e-06, -7.216689864787969e-08,  3.638376369088223e-09, -1.606411831472062e-10,  6.330854810417962e-12, -2.259335593607056e-13,  7.384087325236678e-15,
 -2.228445962274225e-16,  3.716717125135587e-03, -1.047959934210243e-03,  1.557167343716152e-04, -1.590204132129698e-05,  1.248086910571449e-06, -8.006274908629619e-08,
  4.363784137925438e-09, -2.075420555994542e-10,  8.781357474820361e-12, -3.354264159692175e-13,  1.170023606214620e-14, -3.758292842886550e-16,  2.620179179480519e-03,
 -8.046805739026856e-04,  1.302102462104926e-04, -1.443039562606866e-05,  1.224435359756317e-06, -8.460621533026330e-08,  4.950331524884653e-09, -2.519419502935389e-10,
  1.137369718875160e-11, -4.622681061482718e-13,  1.711348389671509e-14, -5.819722306429601e-16,  1.847344362061229e-03, -6.112846414682544e-04,  1.066906321284749e-04,
 -1.271997280174695e-05,  1.157501132897309e-06, -8.551215924618318e-08,  5.333681926909143e-09, -2.885783763241137e-10,  1.381381695416041e-11, -5.938860662369391e-13,
  2.320371506756054e-14, -8.309243983852050e-16,  1.304246599324854e-03, -4.603481034663917e-04,  8.587037336841743e-05, -1.092077944701261e-05,  1.057419726843924e-06,
 -8.290744870807317e-08,  5.474555047041321e-09, -3.128315354399215e-10,  1.578012848856689e-11, -7.133944728038868e-13,  2.925128019924754e-14, -1.097104386083994e-15,
  9.220778584740039e-04, -3.439108783835226e-04,  6.795873643909634e-05, -9.143708016156803e-06,  9.347821868124769e-07, -7.721923172553625e-08,  5.360899863860675e-09,
 -3.214244427044729e-10,  1.697938088184604e-11, -8.023967715205890e-13,  3.433190868430954e-14, -1.341342828319735e-15,  6.514726075633666e-04, -2.545100114722642e-04,
  5.282582956601040e-05, -7.459036375971035e-06,  7.989947060307348e-07, -6.903636351246724e-08,  5.004415796500878e-09, -3.127685839159541e-10,  1.719447051253807e-11,
 -8.443146626207947e-13,  3.748158560626391e-14, -1.517104606381860e-15,  4.574855208528979e-04, -1.856609046154775e-04,  4.014341550320374e-05, -5.901529531291518e-06,
  6.573714356872284e-07, -5.898313412771599e-08,  4.433773587491854e-09, -2.869537623913993e-10,  1.631415344645514e-11, -8.273859636319391e-13,  3.788912497388432e-14,
 -1.580013364529264e-15,  3.155218817801105e-04, -1.319786057737761e-04,  2.948843915763618e-05, -4.478370277015630e-06,  5.148590765386191e-07, -4.762788756344605e-08,
  3.687071930176270e-09, -2.454812157776256e-10,  1.434186809304278e-11, -7.466842849466947e-13,  3.506721584775040e-14, -1.498184967633302e-15,  2.082032144391045e-04,
 -8.909384958999435e-05,  2.040920593897940e-05, -3.177276340617951e-06,  3.741976471311791e-07, -3.543301166139542e-08,  2.805455321997108e-09, -1.908785556936214e-10,
  1.138706866348041e-11, -6.048836194749899e-13,  2.896263890910133e-14, -1.260573815817289e-15,  1.230255676040996e-04, -5.347130389482407e-05,  1.246124715975833e-05,
 -1.973434151277179e-06,  2.363279821423704e-07, -2.274245239481158e-08,  1.828957912009819e-09, -1.263234959980679e-10,  7.645849581911034e-12, -4.118504672589160e-13,
  1.998641014896694e-14, -8.811734379750027e-16,  5.069274458588804e-05, -2.222302622238200e-05,  5.228524490587994e-06, -8.359209224725873e-07,  1.010375832755839e-07,
 -9.810793098371180e-09,  7.958579481644494e-10, -5.543017845885996e-11,  3.382094300753532e-12, -1.835982275641423e-13,  8.976519909077926e-15, -3.986114021603207e-16,
  1.115511313171063e-01, -5.353799139417759e-04,  2.739337754555451e-06, -1.464609730908922e-08,  8.031988621003318e-11, -4.458216244699122e-13,  2.483286072572405e-15,
 -1.381531686226152e-17,  7.656543606410335e-20, -4.222411969298828e-22,  2.315931510367713e-24, -1.263356744493221e-26,  1.065087268080770e-01, -7.963716106946851e-04,
  6.969004333349994e-06, -5.986941878298814e-08,  4.927875972139467e-10, -3.905142944752382e-12,  2.999829527536558e-14, -2.245456752395627e-16,  1.643982940633553e-18,
 -1.180571010389555e-20,  8.333519945445059e-23, -5.792113122290384e-25,  9.713839736927693e-02, -1.245224585159513e-03,  1.628464525580658e-05, -1.910397357942428e-07,
  2.069466998763320e-09, -2.112221094877335e-11,  2.056010998127044e-13, -1.924051624598260e-15,  1.741120831496069e-17, -1.530232781419080e-19,  1.310622768993629e-21,
 -1.096826418036991e-23,  8.469504749170355e-02, -1.761444236986342e-03,  3.146983462525273e-05, -4.802910988411350e-07,  6.599275248555227e-09, -8.383246296854526e-11,
  1.000580108918587e-12, -1.134320736207435e-14,  1.230967852282449e-16, -1.286215755583439e-18,  1.299847526351742e-20, -1.274956952933287e-22,  7.068658381798380e-02,
 -2.217205433466425e-03,  5.204623599877717e-05, -1.006724842192461e-06,  1.712132270662919e-08, -2.645540032802197e-10,  3.789263110934633e-12, -5.099139174637930e-14,
  6.508745569616441e-16, -7.936898764864802e-18,  9.296984842547643e-20, -1.050530243888363e-21,  5.656687244776500e-02, -2.514932073542901e-03,  7.566931715766032e-05,
 -1.817056056884409e-06,  3.754013379444956e-08, -6.936087252337981e-10,  1.173456858691494e-11, -1.846654265276063e-13,  2.733509660031030e-15, -3.837751737298272e-17,
  5.143135568757701e-19, -6.611545308680826e-21,  4.349616159720442e-02, -2.608969502011755e-03,  9.853993416217222e-05, -2.886394188003107e-06,  7.134164456450289e-08,
 -1.554619150409721e-09,  3.067426854462323e-11, -5.578346075279967e-13,  9.468677536622648e-15, -1.514224320040992e-16,  2.297917945911187e-18, -3.327466217151230e-20,
  3.221824596885980e-02, -2.506788134588729e-03,  1.166027677379176e-04, -4.102462424399037e-06,  1.197215679657999e-07, -3.040977613560890e-09,  6.922907367837279e-11,
 -1.440391332207799e-12,  2.777230106054878e-14, -5.013709382743013e-16,  8.542158772427108e-18, -1.381858124616838e-19,  2.305637362762466e-02, -2.254197237841734e-03,
  1.268688883897533e-04, -5.287383484282817e-06,  1.800507912613089e-07, -5.275522589245882e-09,  1.372591734818237e-10, -3.238699774164366e-12,  7.034936060442323e-14,
 -1.422501824123752e-15,  2.700724943183789e-17, -4.845927387047955e-19,  1.599428636217700e-02, -1.913879047846815e-03,  1.282274542229078e-04, -6.249846350189834e-06,
  2.456754321844425e-07, -8.224761799402436e-09,  2.424635279023663e-10, -6.436444377766481e-12,  1.563324015412863e-13, -3.515776037791401e-15,  7.388382381056123e-17,
 -1.460998429682340e-18,  1.079518659412447e-02, -1.546127033527045e-03,  1.214840904125750e-04, -6.843156997293154e-06,  3.074073363274663e-07, -1.165485943653668e-08,
  3.861728382261038e-10, -1.144798830803615e-11,  3.087709573428845e-13, -7.672742704037520e-15,  1.773714309533405e-16, -3.842454464653509e-18,  7.117670108980912e-03,
 -1.196864906668026e-03,  1.087795898319630e-04, -7.003313530974515e-06,  3.561201544452478e-07, -1.516225280628259e-08,  5.603711078043834e-10, -1.842115717514135e-11,
  5.481244191250080e-13, -1.495725662186372e-14,  3.781325334826807e-16, -8.924036538874264e-18,  4.604272496720466e-03, -8.936785054940986e-04,  9.276413524930047e-05,
 -6.754548936743895e-06,  3.852877949403357e-07, -1.827342022296567e-08,  7.477942030768927e-10, -2.707551444383440e-11,  8.831821518592657e-13, -2.630866111675534e-14,
  7.232711589663543e-16, -1.849579840372762e-17,  2.935378708560728e-03, -6.477166722579656e-04,  7.588019082362837e-05, -6.186877763584363e-06,  3.924348691866361e-07,
 -2.057182510240156e-08,  9.255191384640525e-10, -3.666626691297969e-11,  1.303086261145814e-12, -4.212836223081129e-14,  1.252551884209495e-15, -3.452553175650676e-17,
  1.852942675183094e-03, -4.584316330807210e-04,  5.994137218303952e-05, -5.420627019232722e-06,  3.791243579046208e-07, -2.179916605220600e-08,  1.070678676092280e-09,
 -4.611082323168211e-11,  1.774590072581626e-12, -6.190973533840240e-14,  1.979856683818001e-15, -5.851868751855030e-17,  1.163495298534328e-03, -3.186732081278157e-04,
  4.601834956704203e-05, -4.573380704410533e-06,  3.498037206407232e-07, -2.189634641877810e-08,  1.165965709129012e-09, -5.423578584521111e-11,  2.246650739404478e-12,
 -8.409449038674816e-14,  2.876956436501171e-15, -9.071004190198681e-17,  7.299680190878730e-04, -2.187412290546452e-04,  3.453720177898672e-05, -3.738527820482749e-06,
  3.101896337277232e-07, -2.098130064448635e-08,  1.202933287287690e-09, -6.004696678668979e-11,  2.661041992625145e-12, -1.062557375832383e-13,  3.867495189495269e-15,
 -1.294020654665859e-16,  4.594437055691406e-04, -1.489780189914208e-04,  2.547188093854700e-05, -2.977134743414627e-06,  2.658243953567852e-07, -1.928599543230737e-08,
  1.182340090874706e-09, -6.292423002895226e-11,  2.964981825057684e-12, -1.255625746234430e-13,  4.835470545761556e-15, -1.707796873253169e-16,  2.910588034943165e-04,
 -1.010753605121545e-04,  1.854040871389355e-05, -2.319894242010618e-06,  2.211528378298368e-07, -1.708311977678631e-08,  1.112086111385207e-09, -6.268857150193542e-11,
  3.121281892290616e-12, -1.393598602232350e-13,  5.646310338062453e-15, -2.093644545417292e-16,  1.859697305577004e-04, -6.849400910800153e-05,  1.335765373505364e-05,
 -1.774311145434897e-06,  1.791656263465085e-07, -1.462622359838471e-08,  1.003986786611645e-09, -5.954761570350051e-11,  3.113172577375705e-12, -1.456652864089270e-13,
  6.173472159318132e-15, -2.390088377316601e-16,  1.198448837877530e-04, -4.638493795581008e-05,  9.532811670410196e-06, -1.333053602124193e-06,  1.414650866741140e-07,
 -1.211398637269664e-08,  8.706203888057512e-10, -5.396619596173394e-11,  2.943476701623659e-12, -1.434470557318170e-13,  6.322019042365632e-15, -2.541201349179764e-16,
  7.762121618318739e-05, -3.129607013617324e-05,  6.719550186641818e-06, -9.810598147101653e-07,  1.085540432078811e-07, -9.677844333559807e-09,  7.230232274637310e-10,
 -4.651875525535519e-11,  2.629803534227372e-12, -1.326508101394920e-13,  6.043031948355187e-15, -2.507471272139170e-16,  5.001593131479383e-05, -2.083293747793076e-05,
  4.633503947167377e-06, -7.005061362186310e-07,  8.018159565994778e-08, -7.386041043889441e-09,  5.694654263078436e-10, -3.776673048640287e-11,  2.198213452585767e-12,
 -1.140352203262632e-13,  5.337072131181489e-15, -2.272636002440151e-16,  3.128261325516079e-05, -1.335384071690584e-05,  3.050882393223274e-06, -4.737006675400025e-07,
  5.564569807249444e-08, -5.256036634203291e-09,  4.151576998919227e-10, -2.818159450426503e-11,  1.677479320379268e-12, -8.891818330758797e-14,  4.248793157231975e-15,
 -1.845612173285124e-16,  1.779698150483652e-05, -7.726003760165079e-06,  1.798140044542842e-06, -2.843895444648781e-07,  3.401326398309048e-08, -3.269108502714177e-09,
  2.625864372180079e-10, -1.811535829803268e-11,  1.095216679549113e-12, -5.893076950809996e-14,  2.856812356615005e-15, -1.258257185408656e-16,  7.178200326216529e-06,
 -3.145268319258420e-06,  7.395918731942017e-07, -1.181774144302969e-07,  1.427616936084811e-08, -1.385470043215592e-09,  1.123306504495445e-10, -7.819595090714223e-12,
  4.768749851595091e-13, -2.587459886790155e-14,  1.264459104241349e-15, -5.612339437870273e-17,  1.094523579371552e-01, -5.141470348109322e-04,  2.571011195297218e-06,
 -1.342919909918627e-08,  7.196948273664833e-11, -3.906012766846321e-13,  2.128594790901162e-15, -1.159158688723787e-17,  6.290659242036294e-20, -3.398178749183479e-22,
  1.826121595346772e-24, -9.762010056124228e-27,  1.034303760710341e-01, -7.433649617701046e-04,  6.295422641783324e-06, -5.257255785835754e-08,  4.214041958646854e-10,
 -3.255057441875697e-12,  2.438794192167714e-14, -1.781416496870865e-16,  1.273312769473516e-18, -8.930567049202239e-21,  6.159098541144340e-23, -4.183746798448436e-25,
  9.240428876774492e-02, -1.123584885869721e-03,  1.417771760084710e-05, -1.610569598123155e-07,  1.692308321182218e-09, -1.677605744064144e-11,  1.587667339683334e-13,
 -1.445789508564371e-15,  1.274035291744938e-17, -1.091037336847983e-19,  9.110060951694556e-22, -7.436186719107331e-24,  7.811866195678709e-02, -1.531063983692292e-03,
  2.628849197770234e-05, -3.869116263652316e-07,  5.139169939565864e-09, -6.322419093434422e-11,  7.318132539578571e-13, -8.054646329817809e-15,  8.494224648751237e-17,
 -8.631839731171518e-19,  8.489788052378002e-21, -8.109335095937169e-23,  6.258007288600571e-02, -1.844873606678214e-03,  4.144935371952305e-05, -7.706173608811155e-07,
  1.263514724313141e-08, -1.886316584446150e-10,  2.614778865295004e-12, -3.409888660861322e-14,  4.222707806266723e-16, -5.000491320833870e-18,  5.692948568091206e-20,
 -6.256968625361735e-22,  4.759289777428981e-02, -1.987548239219354e-03,  5.705587388671543e-05, -1.313684677317851e-06,  2.611157622056131e-08, -4.652898392256456e-10,
  7.606172460052355e-12, -1.158346838017159e-13,  1.661439140674119e-15, -2.262716085876932e-17,  2.944351938779140e-19, -3.678320159247231e-21,  3.444213425637443e-02,
 -1.941919241297385e-03,  6.984236453741535e-05, -1.958421080804346e-06,  4.650359429333704e-08, -9.760973982299027e-10,  1.858899375583444e-11, -3.268320378393760e-13,
  5.371025817458588e-15, -8.325959126552904e-17,  1.226077803525395e-18, -1.724463091439844e-20,  2.378549327793087e-02, -1.742417117623540e-03,  7.711832599486950e-05,
 -2.595297381279441e-06,  7.270614928656455e-08, -1.777610970785683e-09,  3.903589203124814e-11, -7.848261145091310e-13,  1.464440593786553e-14, -2.561824010767370e-16,
  4.234330208879934e-18, -6.652070177697758e-20,  1.572751118413861e-02, -1.451059045543217e-03,  7.772868369905001e-05, -3.098464457327461e-06,  1.012752240367565e-07,
 -2.855903372087989e-09,  7.166880908341824e-11, -1.634012008294395e-12,  3.434883605818619e-14, -6.730662573297005e-16,  1.239816283464261e-17, -2.160716257072804e-19,
  9.995538416066206e-03, -1.131943366485627e-03,  7.226411410627384e-05, -3.371253103581775e-06,  1.272642036411953e-07, -4.102275828093816e-09,  1.166903468885172e-10,
 -2.994377918109793e-12,  7.041403893734960e-14, -1.535239305672590e-15,  3.131688374375365e-17, -6.017800814792223e-19,  6.132578884898834e-03, -8.340243202175047e-04,
  6.256059540614233e-05, -3.377590766261051e-06,  1.458699251490355e-07, -5.330103034611214e-09,  1.705631071268328e-10, -4.891869422516412e-12,  1.278477326385174e-13,
 -3.082544775833029e-15,  6.922674515202855e-17, -1.458538690083583e-18,  3.649865437287239e-03, -5.849669180825685e-04,  5.088186210521876e-05, -3.145817907006908e-06,
  1.540437520105501e-07, -6.330341744147318e-09,  2.262575849145451e-10, -7.205145846222598e-12,  2.079933953547094e-13, -5.513691814636045e-15,  1.355729579589811e-16,
 -3.115370546485731e-18,  2.118427873585669e-03, -3.935058181175942e-04,  3.920840435430100e-05, -2.748390077241083e-06,  1.512915789403448e-07, -6.939117715643822e-09,
  2.751099459512146e-10, -9.665611646440688e-12,  3.063677897786650e-13, -8.879346709189920e-15,  2.377773357778677e-16, -5.929179845101304e-18,  1.205972760865468e-03,
 -2.557732274557850e-04,  2.886042800965537e-05, -2.271879738845358e-06,  1.394261054328753e-07, -7.084683989036104e-09,  3.094682524571032e-10, -1.192101398345659e-11,
  4.124802617322540e-13, -1.299875378647541e-14,  3.771274910898761e-16, -1.015405283248999e-17,  6.774447866910821e-04, -1.618209315605432e-04,  2.045502233177882e-05,
 -1.791719175500615e-06,  1.216000641857728e-07, -6.795627702371999e-09,  3.248770870525400e-10, -1.363648989863348e-11,  5.120985495051040e-13, -1.745181696493955e-14,
  5.457240508004194e-16, -1.578707126150984e-17,  3.778654605365988e-04, -1.003804670641760e-04,  1.406852635104958e-05, -1.359008958718921e-06,  1.011880457776598e-07,
 -6.174470014022060e-09,  3.209130495641336e-10, -1.458689168244285e-11,  5.910801861552092e-13, -2.166375889542080e-14,  7.263464183212027e-16, -2.246377707646491e-17,
  2.105978481249918e-04, -6.148695669074962e-05,  9.460266869042465e-06, -9.990251706017328e-07,  8.096409438092034e-08, -5.355389576852040e-09,  3.005809026033328e-10,
 -1.470292044521368e-11,  6.390799933346836e-13, -2.505043688353396e-14,  8.957649118397990e-16, -2.946709683002873e-17,  1.179922968983246e-04, -3.744220385669554e-05,
  6.263534505729316e-06, -7.168660261155605e-07,  6.273851027520605e-08, -4.465721776305651e-09,  2.688372622908749e-10, -1.406124661903781e-11,  6.516633779136079e-13,
 -2.716253534922045e-14,  1.030267831344850e-15, -3.586196216283103e-17,  6.682064477648517e-05, -2.280397407835350e-05,  4.108846769796755e-06, -5.053082765305282e-07,
  4.737936474103005e-08, -3.602438205015463e-09,  2.309996640986507e-10, -1.283507306154317e-11,  6.303118660388910e-13, -2.777352311835502e-14,  1.111145803616386e-15,
 -4.070618408990176e-17,  3.841545924462185e-05, -1.395826820943756e-05,  2.683965969100581e-06, -3.516500354864246e-07,  3.504342330901028e-08, -2.824892100347560e-09,
  1.915826267227372e-10, -1.123260482101689e-11,  5.807970089101453e-13, -2.688976803119859e-14,  1.128140704870716e-15, -4.325553555146710e-17,  2.247218067222767e-05,
 -8.610442275387487e-06,  1.750825901139505e-06, -2.422953948396440e-07,  2.545595193809980e-08, -2.158983238246492e-09,  1.537414302492533e-10, -9.446153232026224e-12,
  5.108906611912082e-13, -2.469720587848527e-14,  1.080058290363198e-15, -4.309350297135030e-17,  1.335913145400511e-05, -5.348311740960603e-06,  1.139669038114826e-06,
 -1.651592737461862e-07,  1.814400174690650e-08, -1.606453783003862e-09,  1.192251436662937e-10, -7.622363720642221e-12,  4.282978362136060e-13, -2.147845644547152e-14,
  9.730222920796523e-16, -4.015903838902488e-17,  8.005882100411043e-06, -3.319425022967486e-06,  7.346284136686418e-07, -1.105208325976342e-07,  1.259065184866110e-08,
 -1.154526075037606e-09,  8.862505355831205e-11, -5.852921120130080e-12,  3.392981816076555e-13, -1.753356112892313e-14,  8.175633855817019e-16, -3.468998358014210e-17,
  4.727758249453459e-06, -2.012850575451950e-06,  4.585382523218541e-07, -7.099206717063333e-08,  8.316275504211122e-09, -7.834107553084614e-10,  6.171943296998541e-11,
 -4.179221075628828e-12,  2.481703332979505e-13, -1.312461271674606e-14,  6.257535522180127e-16, -2.712435263419045e-17,  2.582086210070964e-06, -1.119493552387002e-06,
  2.601798706678172e-07, -4.109123441306457e-08,  4.907768401641338e-09, -4.710682037182621e-10,  3.778896051138430e-11, -2.603737754736822e-12,  1.572269618873942e-13,
 -8.450144093918331e-15,  4.091818963317773e-16, -1.800259361989090e-17,  1.017702304983156e-06, -4.456919963527896e-07,  1.047402666445627e-07, -1.672624152437108e-08,
  2.019395798916909e-09, -1.958655590314969e-10,  1.587143859058325e-11, -1.104244980731177e-12,  6.730617331996377e-14, -3.650052386668334e-15,  1.782834967481427e-16,
 -7.909287956275017e-18,  1.074359122334886e-01, -4.942045473182282e-04,  2.416520778816559e-06, -1.233751429149163e-08,  6.464315963565656e-11, -3.431931243586697e-13,
  1.830469267747181e-15, -9.761011640408761e-18,  5.189075934784197e-20, -2.746783487902900e-22,  1.446715054824291e-24, -7.581631906291731e-27,  1.005538030182887e-01,
 -6.954151906404081e-04,  5.702956984652664e-06, -4.632071475513469e-08,  3.617747220538392e-10, -2.725279047638623e-12,  1.992528010569246e-14, -1.420979365879406e-16,
  9.920580568283667e-19, -6.798705223731160e-21,  4.583067555755589e-23, -3.043892745553429e-25,  8.812517021897563e-02, -1.017457790927899e-03,  1.239705840539195e-05,
 -1.364701432517750e-07,  1.391835696246106e-09, -1.340876473353504e-11,  1.234485040121819e-13, -1.094502056439847e-15,  9.396743174986065e-18, -7.844693845749404e-20,
  6.388838073267833e-22, -5.088795838314478e-24,  7.238747072106180e-02, -1.338020212023040e-03,  2.210007901532826e-05, -3.139179936349467e-07,  4.033526930609106e-09,
 -4.808641430012220e-11,  5.400955095626300e-13, -5.774537314215207e-15,  5.920874678488564e-17, -5.854522720403834e-19,  5.606646931035906e-21, -5.217602639780349e-23,
  5.580970114256448e-02, -1.547097724942144e-03,  3.330064224993022e-05, -5.955255347136494e-07,  9.419963487404568e-09, -1.359591203507823e-10,  1.824971767092026e-12,
 -2.307571160036672e-14,  2.773782865302366e-16, -3.191285542279462e-18,  3.532773008318432e-20, -3.778196872710159e-22,  4.046492815213450e-02, -1.587703632000450e-03,
  4.352063382136519e-05, -9.614309419274296e-07,  1.839667536150577e-08, -3.163329939192973e-10,  4.999208412274474e-12, -7.371155362384668e-14,  1.024910198304823e-15,
 -1.354570891786246e-17,  1.712140729945194e-19, -2.079423526469970e-21,  2.765917750518052e-02, -1.465875883383266e-03,  5.023222062494337e-05, -1.349093546572295e-06,
  3.079149471121272e-08, -6.228200496651272e-10,  1.145307862384399e-11, -1.947596877303827e-13,  3.099833708464312e-15, -4.659485871868643e-17,  6.660349888781827e-19,
 -9.101551858055040e-21,  1.787720781259146e-02, -1.232673539539348e-03,  5.192787368070854e-05, -1.672131470850880e-06,  4.498391239480845e-08, -1.058977543685951e-09,
  2.243861374225733e-11, -4.360564037922635e-13,  7.876226617964142e-15, -1.335447990970989e-16,  2.141813122489808e-18, -3.268237138671282e-20,  1.096529752568961e-02,
 -9.542118607870326e-04,  4.864967567902164e-05, -1.855126922251941e-06,  5.820976183723531e-08, -1.580051743459877e-09,  3.825001403516667e-11, -8.427728199427501e-13,
  1.714695730968621e-14, -3.256359667471832e-16,  5.820283449441020e-18, -9.852858334724719e-20,  6.409516545703553e-03, -6.864065572495075e-04,  4.174370259654989e-05,
 -1.863729674417314e-06,  6.756010555473780e-08, -2.096756174423360e-09,  5.754822080894779e-11, -1.427459219089655e-12,  3.249773671358642e-14, -6.869094944768101e-16,
  1.360061085833169e-17, -2.539540387339519e-19,  3.587660553647905e-03, -4.628455186700576e-04,  3.312585522198327e-05, -1.713475006414323e-06,  7.112309431690940e-08,
 -2.504099433333671e-09,  7.737169111286184e-11, -2.146483309198939e-12,  5.434681156775091e-14, -1.271195245535772e-15,  2.772865752082126e-17, -5.680834634191084e-19,
  1.933548602002857e-03, -2.950093987067652e-04,  2.453861398298586e-05, -1.456022310013102e-06,  6.862374173469477e-08, -2.720695756633905e-09,  9.400377735598964e-11,
 -2.898822428427684e-12,  8.115592667689533e-14, -2.089234795284677e-15,  4.994765073844396e-17, -1.117205349510103e-18,  1.009513323444182e-03, -1.792140252938167e-04,
  1.712339793413779e-05, -1.154551609787767e-06,  6.128983657139501e-08, -2.716801528058204e-09,  1.042914942012376e-10, -3.553590834240662e-12,  1.093961725625428e-13,
 -3.083336914557790e-15,  8.038917607331811e-17, -1.953803115047995e-18,  5.140517551448284e-04, -1.046340082692332e-04,  1.135828252753490e-05, -8.623825547674261e-07,
  5.116093932168585e-08, -2.517911103041359e-09,  1.067091036045004e-10, -3.994097729049078e-12,  1.344664772947335e-13, -4.128059526934958e-15,  1.168008489732800e-16,
 -3.070167013856222e-18,  2.571633056055149e-04, -5.921619970426848e-05,  7.226974824083752e-06, -6.124673373842429e-07,  4.029385971312705e-08, -2.186609849679873e-09,
  1.016624478852950e-10, -4.155641248785312e-12,  1.521666147903192e-13, -5.062027692507583e-15,  1.546753828281507e-16, -4.376597695147363e-18,  1.273763665444632e-04,
 -3.276815352169320e-05,  4.451208139969576e-06, -4.174412772845412e-07,  3.022363942106264e-08, -1.795987855425170e-09,  9.102460255222997e-11, -4.039518397484770e-12,
  1.599888071824267e-13, -5.737119665652028e-15,  1.883763203455536e-16, -5.710512915983532e-18,  6.297172748892354e-05, -1.788634209952216e-05,  2.678057280397278e-06,
 -2.755630097927039e-07,  2.178906153626982e-08, -1.407923196728400e-09,  7.728394440364684e-11, -3.701085503634870e-12,  1.576519302371941e-13, -6.061307548592170e-15,
  2.127706057142230e-16, -6.876508631990648e-18,  3.132535942656939e-05, -9.714404327584221e-06,  1.587942819153234e-06, -1.777542861199441e-07,  1.523140013881783e-08,
 -1.062585523425072e-09,  6.275435630106043e-11, -3.222899096453738e-12,  1.467821241691269e-13, -6.017002839442005e-15,  2.246106110783108e-16, -7.699912043574822e-18,
  1.580178021353387e-05, -5.293060059050882e-06,  9.357154425037481e-07, -1.129780769260974e-07,  1.040862631436591e-08, -7.782507045723039e-10,  4.911218280339722e-11,
 -2.687491609964563e-12,  1.300681220416947e-13, -5.651836116654588e-15,  2.231165323749563e-16, -8.070062115021098e-18,  8.138264940865012e-06, -2.914234097977583e-06,
  5.519501593248054e-07, -7.126141257516465e-08,  7.002175944818576e-09, -5.569050467171421e-10,  3.728636463032990e-11, -2.159423581336157e-12,  1.103519170599807e-13,
 -5.051979533494689e-15,  2.096836606195507e-16, -7.957469958399203e-18,  4.300375436632816e-06, -1.629879608796195e-06,  3.276359072292617e-07, -4.483641910545907e-08,
  4.660127717695108e-09, -3.911812242256127e-10,  2.758255298098801e-11, -1.678804370304287e-12,  8.998126147962614e-14, -4.312398259435506e-15,  1.870354139659140e-16,
 -7.403753844201840e-18,  2.334621911039874e-06, -9.275230759583792e-07,  1.960341752205332e-07, -2.818178781898828e-08,  3.072095352264790e-09, -2.699862931670751e-10,
  1.989523181876581e-11, -1.263310326520062e-12,  7.052308795376105e-14, -3.514578511766491e-15,  1.582673290662388e-16, -6.494772091697847e-18,  1.294972919915571e-06,
 -5.342610397633270e-07,  1.176043263951108e-07, -1.759942337001580e-08,  1.994695299147884e-09, -1.820085316094216e-10,  1.390563907756134e-11, -9.141939725617725e-13,
  5.276671361217689e-14, -2.715435140633677e-15,  1.261118116422356e-16, -5.330628287574683e-18,  7.190330551097315e-07, -3.052523627513001e-07,  6.932053160309606e-08,
 -1.069913118028194e-08,  1.249568379308289e-09, -1.173708630128806e-10,  9.221058721244141e-12, -6.227160464981810e-13,  3.688303440761186e-14, -1.945761900293237e-15,
  9.254976669621800e-17, -4.002610456870575e-18,  3.758089439132886e-07, -1.627103170964620e-07,  3.775737235761048e-08, -5.954079430644791e-09,  7.100738253361116e-10,
 -6.805778519861943e-11,  5.451990606931119e-12, -3.751500308429131e-13,  2.262420249913436e-14, -1.214420440478625e-15,  5.873533439348057e-17, -2.581167456870033e-18,
  1.444750854161842e-07, -6.323609553348664e-08,  1.485159073193523e-08, -2.370198955129086e-09,  2.859822092736041e-10, -2.772123716506017e-11,  2.244989120979975e-12,
 -1.561037748895965e-13,  9.509538890665607e-15, -5.154264164520439e-16,  2.516216380265366e-17, -1.115707115488594e-18,  1.054968448797930e-01, -4.754475054281085e-04,
  2.274457329059174e-06, -1.135583736753567e-08,  5.819740416428026e-11, -3.023626780153310e-13,  1.578997448474316e-15, -8.248174014059551e-18,  4.296839486177584e-20,
 -2.229591383036933e-22,  1.151353404024175e-24, -5.917190884815341e-27,  9.786000285794849e-02, -6.519205064279041e-04,  5.180120714153150e-06, -4.094367229466298e-08,
  3.117465541753789e-10, -2.291444071261120e-12,  1.635656396983262e-14, -1.139389243327108e-16,  7.773148954729090e-19, -5.207399546288783e-21,  3.432628623258028e-23,
 -2.229995578676597e-25,  8.424382910979879e-02, -9.244726960769025e-04,  1.088467750679094e-05, -1.161950377341775e-07,  1.150970853943072e-09, -1.078221808325394e-11,
  9.662041564826349e-14, -8.344660894404150e-16,  6.983408986638283e-18, -5.686059696064814e-20,  4.518752432488484e-22, -3.513709309573783e-24,  6.736659132764244e-02,
 -1.175259298036228e-03,  1.869068455712263e-05, -2.564224612441468e-07,  3.189354067145015e-09, -3.686829902779571e-11,  4.020499334858421e-13, -4.177914874311403e-15,
  4.167153728551418e-17, -4.011252331879125e-19,  3.742045302042080e-21, -3.394270989407524e-23,  5.011222361035226e-02, -1.306907801050899e-03,  2.697606839858875e-05,
 -4.643827203944406e-07,  7.091204851392308e-09, -9.900738946112630e-11,  1.287617246616012e-12, -1.579454027228523e-14,  1.843759916350143e-16, -2.061913102722386e-18,
  2.220425706840718e-20, -2.311679349475822e-22,  3.474385480973094e-02, -1.281125055621147e-03,  3.356011163814491e-05, -7.118188441062626e-07,  1.312004802072536e-08,
 -2.178204064004019e-10,  3.329615213550821e-12, -4.755527899214633e-14,  6.412802212890345e-16, -8.228411957329220e-18,  1.010654157594809e-19, -1.193741051553419e-21,
  2.250754609821604e-02, -1.121257427969089e-03,  3.663177755228820e-05, -9.428166608706857e-07,  2.069408218705222e-08, -4.035602060675202e-10,  7.168933881290196e-12,
 -1.179546511579955e-13,  1.818963348478452e-15, -2.652145715885555e-17,  3.681055767272031e-19, -4.888819752669709e-21,  1.366564587282916e-02, -8.867154924649910e-04,
  3.556638452046648e-05, -1.096255781021836e-06,  2.833094157863006e-08, -6.423992916345700e-10,  1.313821524838870e-11, -2.468595660827945e-13,  4.317399083684836e-15,
 -7.096955372656703e-17,  1.104705846340713e-18, -1.637685676744101e-20,  7.805405887502989e-03, -6.403408570755124e-04,  3.107551300780788e-05, -1.133733141090258e-06,
  3.415703806836440e-08, -8.926328379300689e-10,  2.084897868289276e-11, -4.440070124265911e-13,  8.744840593254981e-15, -1.609740064694420e-16,  2.792107635064990e-18,
 -4.591699944946227e-20,  4.212428323956381e-03, -4.262989284927164e-04,  2.469132798298876e-05, -1.054940967785991e-06,  3.672154558267017e-08, -1.097287423397685e-09,
  2.905924394654058e-11, -6.967581871217562e-13,  1.535719979421720e-14, -3.146942090336316e-16,  6.047852987518260e-18, -1.097307327241152e-19,  2.159078253879341e-03,
 -2.639795008904694e-04,  1.801771491206281e-05, -8.926426170994491e-07,  3.560270208761840e-08, -1.207569896803830e-09,  3.602065440801527e-11, -9.664650861869659e-13,
  2.370267916071753e-14, -5.377679164350789e-16,  1.139202555147850e-17, -2.269132185071798e-19,  1.057228859249390e-03, -1.533812488169684e-04,  1.219124270961954e-05,
 -6.938613104289711e-07,  3.146141980453479e-08, -1.202919654377789e-09,  4.016416107696976e-11, -1.198976290527407e-12,  3.254376900962731e-14, -8.133568739120333e-16,
  1.890088837554702e-17, -4.113957211649933e-19,  4.979144445387475e-04, -8.436349384054779e-05,  7.722255436393085e-06, -5.004442533020332e-07,  2.560255076483782e-08,
 -1.096173271537300e-09,  4.072196235531446e-11, -1.345020903012142e-12,  4.019607006267305e-14, -1.101265422396957e-15,  2.794293363193763e-17, -6.616621771201635e-19,
  2.272518135555779e-04, -4.432803515877759e-05,  4.623939112526894e-06, -3.382876461821356e-07,  1.938380240359350e-08, -9.232895142123253e-10,  3.793704231123064e-11,
 -1.378862506499344e-12,  4.513968742446493e-14, -1.349193599011254e-15,  3.720912983984193e-17, -9.543354493558248e-19,  1.013592863990996e-04, -2.246385913848408e-05,
  2.643589469689141e-06, -2.165185048257179e-07,  1.379475066315086e-08, -7.262614090861877e-10,  3.281122572147672e-11, -1.305144943537913e-12,  4.656453492703342e-14,
 -1.511053958813262e-15,  4.508755158229341e-17, -1.247058723708136e-18,  4.458480746192315e-05, -1.108939015390398e-05,  1.458037399011657e-06, -1.325886656540879e-07,
  9.324577819171347e-09, -5.390614887202195e-10,  2.661702615261807e-11, -1.152259133658100e-12,  4.456902244889237e-14, -1.562499470203495e-15,  5.020613230869581e-17,
 -1.490774453604014e-18,  1.953030275213596e-05, -5.388330057398019e-06,  7.840274628684974e-07, -7.850909519630820e-08,  6.049857929749843e-09, -3.814795762739384e-10,
  2.045959363941143e-11, -9.583776304495390e-13,  3.997152730318409e-14, -1.506157091745753e-15,  5.186155823051208e-17, -1.645486836469218e-18,  8.606467406394234e-06,
 -2.604491877277051e-06,  4.154537389705688e-07, -4.543008545529963e-08,  3.807121088745254e-09, -2.600350662939353e-10,  1.505110818828424e-11, -7.582984014226336e-13,
  3.390914081077087e-14, -1.365926737918177e-15,  5.014289142346495e-17, -1.691666595460220e-18,  3.854094858574078e-06, -1.265485221755023e-06,  2.192236559494484e-07,
 -2.595706384257075e-08,  2.347250722371105e-09, -1.724142020878632e-10,  1.069776795606517e-11, -5.760250104179083e-13,  2.745190520747071e-14, -1.175423645812483e-15,
  4.575264739244372e-17, -1.632716820744726e-18,  1.770549389801375e-06, -6.241467163199567e-07,  1.163122679454042e-07, -1.478299439374599e-08,  1.430911104769339e-09,
 -1.121831864480145e-10,  7.408809078858983e-12, -4.235040143245894e-13,  2.137344325066200e-14, -9.668724597948088e-16,  3.967425076178561e-17, -1.489277953664584e-18,
  8.409360297389538e-07, -3.149902875539517e-07,  6.254159900215336e-08, -8.456333371221301e-09,  8.688180720336233e-10, -7.212838332325340e-11,  5.032372372859486e-12,
 -3.032160638430514e-13,  1.609574368459861e-14, -7.643054994226852e-16,  3.285739148484636e-17, -1.289712561659281e-18,  4.147367502889887e-07, -1.634054060580366e-07,
  3.423168595473699e-08, -4.878644778193830e-09,  5.273967303216150e-10, -4.597976399828254e-11,  3.362371934385657e-12, -2.119448419374131e-13,  1.174891899428546e-14,
 -5.815999508650571e-16,  2.602260411309183e-17, -1.061342469675070e-18,  2.118457178079816e-07, -8.692840295260032e-08,  1.902382787380729e-08, -2.830608383182205e-09,
  3.190429203351488e-10, -2.895679629068286e-11,  2.201059904555597e-12, -1.439974721233301e-13,  8.272597648339197e-15, -4.238109927546079e-16,  1.959841089669825e-17,
 -8.250071745030528e-19,  1.101053281591637e-07, -4.659749912999039e-08,  1.054599004229364e-08, -1.622230331731357e-09,  1.888459269813611e-10, -1.768251151285000e-11,
  1.385014201829949e-12, -9.326229002656696e-14,  5.508536443146339e-15, -2.898289009113924e-16,  1.375043228525674e-17, -5.932266824563136e-19,  5.488378410102866e-08,
 -2.372679798428869e-08,  5.496754267536198e-09, -8.653734735499756e-10,  1.030375652443922e-10, -9.860431380250133e-12,  7.887204526025769e-13, -5.419342532859434e-14,
  3.263710074069166e-15, -1.749549608256393e-16,  8.450781009569661e-18, -3.709161060137092e-19,  2.053840087345044e-08, -8.984242883492768e-09,  2.108636751942138e-09,
 -3.362979208944941e-10,  4.055024413385942e-11, -3.928154603385492e-12,  3.179206799813189e-13, -2.209295100398258e-14,  1.345063282566005e-15, -7.286179288609882e-17,
  3.554985806198043e-18, -1.575447889455989e-19,  1.036306048899629e-01, -4.577815438881576e-04,  2.143581133742768e-06, -1.047107373593909e-08,  5.251117577233402e-11,
 -2.670898628887277e-13,  1.366152303885024e-15, -6.993206195527373e-18,  3.571178524929695e-20, -1.817117268711642e-22,  9.203081473000579e-25, -4.640046156246822e-27,
  9.533220633141867e-02, -6.123633915315242e-04,  4.717278206151170e-06, -3.630206577836192e-08,  2.695986590637910e-10, -1.934523442373609e-12,  1.348811253004653e-14,
 -9.181736005728016e-17,  6.123709386695468e-19, -4.011961289407452e-21,  2.587119373456864e-23, -1.644641916850607e-25,  8.071168369312061e-02, -8.426751818404772e-04,
  9.594101453686242e-06, -9.938617880172604e-08,  9.567457339378651e-10, -8.720230487444758e-12,  7.609942758822861e-14, -6.405414257194576e-16,  5.227707390398935e-18,
 -4.153357987444140e-20,  3.222249947328383e-22, -2.447064478971090e-24,  6.294627187160047e-02, -1.037227416078840e-03,  1.589705569088018e-05, -2.108046749499044e-07,
  2.539730237528950e-09, -2.848457385844125e-11,  3.017564854814642e-13, -3.049271171777410e-15,  2.960069733320328e-17, -2.775117505208629e-19,  2.523031188199191e-21,
 -2.231599011301704e-23,  4.528345391147302e-02, -1.111601099935269e-03,  2.202394166245786e-05, -3.652247633368460e-07,  5.387438583459988e-09, -7.280775499399133e-11,
  9.179273759513387e-13, -1.092883717985335e-14,  1.239543940286279e-16, -1.348029520659960e-18,  1.412762916845446e-20, -1.432391351191186e-22,  3.010685270907149e-02,
 -1.043547782095249e-03,  2.614696923395569e-05, -5.328217799652972e-07,  9.465808898400008e-09, -1.518175077837873e-10,  2.245848344036311e-12, -3.108593466346840e-14,
  4.067303005849703e-16, -5.068849071217090e-18,  6.052240190949034e-20, -6.954871286955442e-22,  1.854417879249235e-02, -8.683874240380674e-04,  2.706573519094482e-05,
 -6.679476600657883e-07,  1.410648925171081e-08, -2.653513171834008e-10,  4.555624745937648e-12, -7.255573255861064e-14,  1.084468603612087e-15, -1.534332548286212e-17,
  2.068498436385275e-19, -2.670760012220010e-21,  1.061424955868537e-02, -6.479744410556480e-04,  2.475679223409730e-05, -7.307090939541450e-07,  1.814792338988167e-08,
 -3.965026448305491e-10,  7.829765034527456e-12, -1.422877178798489e-13,  2.410260269235941e-15, -3.842135000038156e-17,  5.805981284276307e-19, -8.363941235770023e-21,
  5.666613823415222e-03, -4.380642908421522e-04,  2.023840365062665e-05, -7.065744763299632e-07,  2.044435057186732e-08, -5.144940679449253e-10,  1.159673860600384e-11,
 -2.387548584298234e-13,  4.552791382465380e-15, -8.124765105841383e-17,  1.367777234964775e-18, -2.185426810452240e-20,  2.834294757566230e-03, -2.708681918160609e-04,
  1.493985959421472e-05, -6.108223786278767e-07,  2.041774591480296e-08, -5.874508724438168e-10,  1.501203149052991e-11, -3.479571607238706e-13,  7.425330422404979e-15,
 -1.475157589777599e-16,  2.751793054519837e-18, -4.851540138903454e-20,  1.335189654455081e-03, -1.545711587805380e-04,  1.005714616076767e-05, -4.771000322781026e-07,
  1.828143202963681e-08, -5.972660453787837e-10,  1.719747217882376e-11, -4.462120190708175e-13,  1.059916917542419e-14, -2.332293327089216e-16,  4.797692610353242e-18,
 -9.290061578352924e-20,  5.960693453632221e-04, -8.213644486255540e-05,  6.234174014988843e-06, -3.401701985495291e-07,  1.483302952668977e-08, -5.467574095444413e-10,
  1.763611614226033e-11, -5.095067512680384e-13,  1.340454023998452e-14, -3.251636007469809e-16,  7.342931662383309e-18, -1.554895661099044e-19,  2.539854839970495e-04,
 -4.101844358507370e-05,  3.593723069040143e-06, -2.236825732975485e-07,  1.102171564416404e-08, -4.555547671479258e-10,  1.636964476527344e-11, -5.238748731949759e-13,
  1.519216174089118e-14, -4.044303550754240e-16,  9.982974999632782e-18, -2.302200155029539e-19,  1.041435182615653e-04, -1.943890354702533e-05,  1.946332030273615e-06,
 -1.370813519639164e-07,  7.580522320751449e-09, -3.492089597086950e-10,  1.390248455738796e-11, -4.903739853011698e-13,  1.560128159968188e-14, -4.537592168918580e-16,
  1.219135203958657e-17, -3.049461984442079e-19,  4.147497988901107e-05, -8.833096225160701e-06,  1.001075621434544e-06, -7.915385047930260e-08,  4.879072592633859e-09,
 -2.489924050713821e-10,  1.092217407428208e-11, -4.224559224727897e-13,  1.467539348964315e-14, -4.642444878162962e-16,  1.351853879733871e-17, -3.652688169336249e-19,
  1.620884180739138e-05, -3.891576195808635e-06,  4.945708065033588e-07, -4.355775645400071e-08,  2.972290659356075e-09, -1.670032429645932e-10,  8.026314667320332e-12,
 -3.386547954320282e-13,  1.278249852827963e-14, -4.377804571907104e-16,  1.375578333929348e-17, -3.998052879181747e-19,  6.286889904309051e-06, -1.682100911560658e-06,
  2.375185074090334e-07, -2.311674791768850e-08,  1.734049621497299e-09, -1.065895715304515e-10,  5.579943077718414e-12, -2.554292414102082e-13,  1.042205647726751e-14,
 -3.845658160339844e-16,  1.297893632373798e-17, -4.039797207063218e-19,  2.449525764295544e-06, -7.222627210710538e-07,  1.122732676001909e-07, -1.197806287235222e-08,
  9.805519887092772e-10, -6.550150049077781e-11,  3.712016536427780e-12, -1.832917585639461e-13,  8.040553329239934e-15, -3.180073654787165e-16,  1.147114406623386e-17,
 -3.805700832399700e-19,  9.707559511283993e-07, -3.120169663659217e-07,  5.289826486738798e-08, -6.134923327690949e-09,  5.439223647636056e-10, -3.920935793856011e-11,
  2.389685224094820e-12, -1.264983386688362e-13,  5.931322382740612e-15, -2.500489511875286e-16,  9.589434729271572e-18, -3.373809529176291e-19,  3.961282342034760e-07,
 -1.373044942277879e-07,  2.514727003980287e-08, -3.143007846971859e-09,  2.993870609593170e-10, -2.311576622286178e-11,  1.504522165863589e-12, -8.481433847557305e-14,
  4.223977208082555e-15, -1.886722377155313e-16,  7.648557766205746e-18, -2.838012961760799e-19,  1.682679220275793e-07, -6.223066491464195e-08,  1.219270832191476e-08,
 -1.627409611639190e-09,  1.651415635170539e-10, -1.354832529719432e-11,  9.346243931186435e-13, -5.570877609610260e-14,  2.926843479853690e-15, -1.376164387324500e-16,
  5.860539145979345e-18, -2.279726868779354e-19,  7.498177538289613e-08, -2.927686485608205e-08,  6.074707444625794e-09, -8.576859473645526e-10,  9.188670990472975e-11,
 -7.942081909400892e-12,  5.760103413237328e-13, -3.602323343096484e-14,  1.981909652630022e-15, -9.740455398952022e-17,  4.328223768328578e-18, -1.753691334583350e-19,
  3.508111980339275e-08, -1.431051124628693e-08,  3.112001316208234e-09, -4.601697521438424e-10,  5.155592630519649e-11, -4.652397374387499e-12,  3.516908739422296e-13,
 -2.288706783491611e-14,  1.308223732794721e-15, -6.669775431378215e-17,  3.070068082378658e-18, -1.286656549024450e-19,  1.698557085790215e-08, -7.164019950946547e-09,
  1.615378265052790e-09, -2.475781781790900e-10,  2.871912174367813e-11, -2.679968268240769e-12,  2.092289324970579e-13, -1.404474432901428e-14,  8.270667556086798e-16,
 -4.339068161339457e-17,  2.052924198033956e-18, -8.833462106334432e-20,  8.044913036349672e-09, -3.472226526828278e-09,  8.029637084009390e-10, -1.261882799796968e-10,
  1.499885146038193e-11, -1.432949312194816e-12,  1.144345116122920e-13, -7.850652794784304e-15,  4.720863825131104e-16, -2.527035850514535e-17,  1.218935415653674e-18,
 -5.342964419452874e-20,  2.924013584577086e-09, -1.278263293833392e-09,  2.998021017040554e-10, -4.778037745928322e-11,  5.757267801785915e-12, -5.573348480623692e-13,
  4.507739691167057e-14, -3.130502766143508e-15,  1.904720220180371e-16, -1.031155235113808e-17,  5.028114606260846e-19, -2.227010619263398e-20,  1.018329998541771e-01,
 -4.411216180416323e-04,  2.022798636624891e-06, -9.671912166088117e-09,  4.748203710224506e-11, -2.365285910453340e-13,  1.185406420184811e-15, -5.948370754508563e-18,
  2.978642408654075e-20, -1.486742339984682e-22,  7.387312763625220e-25, -3.655212747464677e-27,  9.295557004753163e-02, -5.762971645923389e-04,  4.306312780351820e-06,
 -3.228125838990990e-08,  2.339479980482960e-10, -1.639571689591414e-12,  1.117120195040000e-14, -7.434598246814317e-17,  4.849480774522821e-19, -3.108374049241843e-21,
  1.961638535056011e-23, -1.220730583719765e-25,  7.748728593124325e-02, -7.704453109420188e-04,  8.487865110394646e-06, -8.538002500343362e-08,  7.992443794292638e-10,
 -7.091460335130459e-12,  6.029808788036584e-14, -4.948867074935473e-16,  3.940725504004057e-18, -3.056338991480114e-20,  2.315795298557833e-22, -1.718323555428551e-24,
  5.903661516983889e-02, -9.195196650865442e-04,  1.359361356811242e-05, -1.743602476092995e-07,  2.036060966474922e-09, -2.216851669464541e-11,  2.282646048305387e-13,
 -2.244187235536053e-15,  2.121292262583220e-17, -1.937841971050217e-19,  1.717759350444273e-21, -1.482157611685519e-23,  4.116360756907198e-02, -9.515783487615382e-04,
  1.811399676437157e-05, -2.895745263137105e-07,  4.128938906309230e-09, -5.404259434619456e-11,  6.608675928165327e-13, -7.640927826709975e-15,  8.424265797125423e-17,
 -8.913267680091795e-19,  9.094872029786630e-21, -8.983933912516235e-23,  2.631387155740742e-02, -8.575858782362443e-04,  2.057036312436322e-05, -4.030025367680412e-07,
  6.904901312879746e-09, -1.070445605491136e-10,  1.533238752431709e-12, -2.057690071245537e-14,  2.613426709112025e-16, -3.164682286426531e-18,  3.674758223440290e-20,
 -4.109877093293327e-22,  1.545784671769799e-02, -6.804539677120700e-04,  2.024696663155192e-05, -4.793857051407881e-07,  9.746548179077922e-09, -1.769321138700050e-10,
  2.937047574752833e-12, -4.529819131462298e-14,  6.564965921942733e-16, -9.016179156101997e-18,  1.181046286101295e-19, -1.482971630167264e-21,  8.369176846288356e-03,
 -4.806003954413232e-04,  1.749850841925512e-05, -4.947854308501210e-07,  1.181445611550571e-08, -2.488154332708750e-10,  4.745789642549967e-12, -8.344068162954612e-14,
  1.369409551695335e-15, -2.117509640116506e-17,  3.107220050836834e-19, -4.350758330010160e-21,  4.191402347030345e-03, -3.052057479753320e-04,  1.342601994323483e-05,
 -4.486697732681298e-07,  1.247104309112874e-08, -3.022980509526189e-10,  6.577168836891126e-12, -1.309373590971341e-13,  2.417918169348786e-15, -4.183936563521099e-17,
  6.837407873023868e-19, -1.061593129203532e-20,  1.950242665526981e-03, -1.758955872430959e-04,  9.237776198759765e-06, -3.614405119645545e-07,  1.160285746046014e-08,
 -3.214651842107979e-10,  7.927692780637803e-12, -1.776478349168404e-13,  3.670660276272616e-15, -7.070372167184166e-17,  1.280292139027401e-18, -2.193456066714552e-20,
  8.475436916524547e-04, -9.282298750973502e-05,  5.755269549645162e-06, -2.613803467173945e-07,  9.620905384919551e-09, -3.027356490789569e-10,  8.413691754855177e-12,
 -2.110945189104565e-13,  4.856226252116576e-15, -1.036323433596142e-16,  2.069937049453097e-18, -3.896165162054313e-20,  3.461801620755381e-04, -4.525926276898964e-05,
  3.278316900358530e-06, -1.714248343244095e-07,  7.186032225463991e-09, -2.552922958314526e-10,  7.953227609624737e-12, -2.223132598782957e-13,  5.667835828101804e-15,
 -1.334173686394150e-16,  2.927228542523964e-18, -6.029111423344864e-20,  1.338794787147246e-04, -2.058254718200581e-05,  1.724520368450153e-06, -1.030254809302347e-07,
  4.886664279724710e-09, -1.948907038303336e-10,  6.770974229266072e-12, -2.098716953074015e-13,  5.903641057724562e-15, -1.526525261633479e-16,  3.664428196118236e-18,
 -8.227383605699062e-20,  4.944647020665711e-05, -8.818903757599110e-06,  8.466560459059276e-07, -5.735575566387704e-08,  3.058721712449647e-09, -1.361833028123737e-10,
  5.249869663066107e-12, -1.796041613513286e-13,  5.550277019878280e-15, -1.570041375173225e-16,  4.107521667645768e-18, -1.001543003688525e-19,  1.761483489733670e-05,
 -3.599383395806476e-06,  3.923621677248592e-07, -2.991848829164909e-08,  1.782582326211227e-09, -8.810612455684400e-11,  3.749647829952616e-12, -1.409256468809951e-13,
  4.763434301507935e-15, -1.468029616800623e-16,  4.169292174269305e-18, -1.099883480481683e-19,  6.121481237685508e-06, -1.416343734981120e-06,  1.737485877763639e-07,
 -1.480272802312607e-08,  9.790597846016729e-10, -5.341304038385933e-11,  2.496439647547460e-12, -1.025773042280836e-13,  3.775251648786468e-15, -1.262174194626167e-16,
  3.875564965536365e-18, -1.101829915259129e-19,  2.101725689276163e-06, -5.444346798497125e-07,  7.449721393924756e-08, -7.038149737642563e-09,  5.133376483246549e-10,
 -3.072731218850501e-11,  1.568568732747871e-12, -7.010484830624913e-14,  2.795926661259835e-15, -1.009455998266526e-16,  3.336671654875975e-18, -1.018089341678719e-19,
  7.229037415133757e-07, -2.073567459687662e-07,  3.136627390132036e-08, -3.260638015501913e-09,  2.604380587745623e-10, -1.699636821726147e-11,  9.420960976825628e-13,
 -4.554869460906097e-14,  1.958375329416853e-15, -7.598359072260598e-17,  2.691088356544697e-18, -8.772967775641824e-20,  2.528186347259554e-07, -7.942852337964398e-08,
  1.316091785159462e-08, -1.493185929843532e-09,  1.296481996594161e-10, -9.162087966020035e-12,  5.479519755853941e-13, -2.848888433023183e-14,  1.313088939483986e-15,
 -5.445737536768691e-17,  2.056019610347419e-18, -7.126258239133834e-20,  9.126947080891745e-08, -3.106653708292799e-08,  5.585212190625744e-09, -6.856792705337598e-10,
  6.420785242468541e-11, -4.877481834419093e-12,  3.125751104884855e-13, -1.736238189517683e-14,  8.525916709405942e-16, -3.757360685894452e-17,  1.503722781255305e-18,
 -5.511480714800582e-20,  3.450111443497706e-08, -1.258503385722170e-08,  2.430698648459117e-09, -3.199582963755044e-10,  3.203857990874155e-11, -2.595290185892114e-12,
  1.768788431892125e-13, -1.042180787906120e-14,  5.415367055515634e-16, -2.519545943814761e-17,  1.062220763169633e-18, -4.092457052207166e-20,  1.381368086109637e-08,
 -5.340882793440142e-09,  1.096753723599444e-09, -1.532908770492594e-10,  1.626362608226682e-11, -1.392706768423120e-12,  1.001146209292397e-13, -6.208200494999946e-15,
  3.388034635720337e-16, -1.652267325171627e-17,  7.287778978494000e-19, -2.932037233985002e-20,  5.886294642616251e-09, -2.385789565532322e-09,  5.152590927668112e-10,
 -7.567803664643715e-11,  8.423697940796440e-12, -7.554242139842243e-13,  5.676526349417492e-14, -3.673102345203116e-15,  2.088117994692297e-16, -1.059053189564872e-17,
  4.850495745824826e-19, -2.023160785617083e-20,  2.641405047747231e-09, -1.109938350608201e-09,  2.492677260716294e-10, -3.805208746748648e-11,  4.397124568913229e-12,
 -4.088123946384945e-13,  3.180381588409776e-14, -2.127645179647393e-15,  1.248866786375054e-16, -6.531631849490185e-18,  3.081090219335245e-19, -1.321982837115491e-20,
  1.183944816468392e-09, -5.100914760394062e-10,  1.177308371663019e-10, -1.846606459890648e-11,  2.190777217193800e-12, -2.089221260958484e-13,  1.665534014936434e-14,
 -1.140707361590660e-15,  6.848416049730275e-17, -3.660221212836669e-18,  1.762908529043477e-19, -7.716332737141498e-21,  4.169389203962916e-10, -1.821466148106817e-10,
  4.268835987598742e-11, -6.798248903218172e-12,  8.185445746623523e-13, -7.918234952148165e-14,  6.399791527215701e-15, -4.441447671438726e-16,  2.700558807634403e-17,
 -1.461055768048919e-18,  7.119938525002749e-20, -3.151593621952651e-21,  1.001001608662879e-01, -4.253909153726965e-04,  1.911142714281755e-06, -8.948553129144831e-09,
  4.302300829801526e-11, -2.099745309467908e-13,  1.031430641804946e-15, -5.075438551071458e-18,  2.492947755749832e-20, -1.221028771538017e-22,  5.953880800320119e-25,
 -2.892161616440557e-27,  9.071691568342179e-02, -5.433349297935145e-04,  3.940359896600153e-06, -2.878653214209685e-08,  2.036776788934428e-10, -1.394787752236756e-12,
  9.290970468138928e-15, -6.047653399965498e-17,  3.859665212953104e-19, -2.421339135385650e-21,  1.496007797225264e-23, -9.116829954750669e-26,  7.453511496206643e-02,
 -7.064335273546255e-04,  7.535594323035751e-06, -7.365258725345312e-08,  6.708338623675405e-10, -5.797294715095994e-12,  4.805323480970446e-14, -3.847381636430491e-16,
  2.990453946418849e-18, -2.265098953147472e-20,  1.676893227625670e-22, -1.216195790385868e-24,  5.556352268252913e-02, -8.186181028692517e-04,  1.168303019335095e-05,
 -1.450526405420037e-07,  1.642755024703864e-09, -1.737350882915755e-11,  1.739696354732489e-13, -1.664909737484229e-15,  1.533105728868995e-17, -1.365284397779966e-19,
  1.180472971193878e-21, -9.940429304169677e-24,  3.762659430690959e-02, -8.195197665302089e-04,  1.500241763166702e-05, -2.313641652022946e-07,  3.190822690305293e-09,
 -4.047182009387020e-11,  4.802975960100998e-13, -5.395414942065358e-15,  5.785126265081096e-17, -5.957692528936529e-19,  5.921212262273739e-21, -5.700754632406198e-23,
  2.318447788040001e-02, -7.106395878742420e-04,  1.633253312812115e-05, -3.078320473867079e-07,  5.089790555593965e-09, -7.631159270932570e-11,  1.058874547159573e-12,
 -1.378504283320791e-14,  1.700277124856338e-16, -2.001419950587012e-18,  2.260997398648486e-20, -2.462005274227977e-22,  1.302696602749014e-02, -5.390837214915274e-04,
  1.532455442417568e-05, -3.483122363598004e-07,  6.821166236241548e-09, -1.195594911379250e-10,  1.919842510710924e-12, -2.868578681439881e-14,  4.032711505178987e-16,
 -5.378184753896933e-18,  6.847616074478278e-20, -8.364356731469352e-22,  6.693232066711283e-03, -3.614901007002198e-04,  1.254912495089316e-05, -3.400896060785356e-07,
  7.810780946011391e-09, -1.586278099766218e-10,  2.923499764431101e-12, -4.974793700389304e-14,  7.912803606271875e-16, -1.187233999976617e-17,  1.692183965736350e-19,
 -2.303616155341188e-21,  3.155543186413977e-03, -2.163509915600886e-04,  9.064405299821411e-06, -2.900295024283937e-07,  7.746537792713875e-09, -1.809211800496262e-10,
  3.800643992855661e-12, -7.318086687816524e-14,  1.308962172887611e-15, -2.196705342128750e-17,  3.485482840262501e-19, -5.259571991316002e-21,  1.370881947621686e-03,
 -1.166155301131807e-04,  5.831578431393218e-06, -2.183709066840154e-07,  6.733062890136543e-09, -1.796573654935863e-10,  4.276214833240685e-12, -9.265145637617463e-14,
  1.853867506509393e-15, -3.462539411523297e-17,  6.086784641055021e-19, -1.013432656570975e-20,  5.516378848888185e-04, -5.710791080196631e-05,  3.373229589675311e-06,
 -1.466449345941557e-07,  5.184682498415112e-09, -1.571239594782290e-10,  4.214826335719325e-12, -1.022523378421874e-13,  2.278113887973051e-15, -4.714589119857257e-17,
  9.143292238458118e-19, -1.672853382121167e-20,  2.068893662835194e-04, -2.563636896761766e-05,  1.771174555472247e-06, -8.872158547841311e-08,  3.574418343550488e-09,
 -1.223595758300482e-10,  3.680897632579277e-12, -9.953377636338593e-14,  2.458647039177896e-15, -5.615163584568644e-17,  1.196768732447148e-18, -2.397167217084680e-20,
  7.285938600467395e-05, -1.064986328804552e-05,  8.526482512080479e-07, -4.886225518495281e-08,  2.229862860118298e-09, -8.577467659426324e-11,  2.880146202469606e-12,
 -8.643278598961137e-14,  2.357623644094864e-15, -5.919439765410121e-17,  1.381451350763966e-18, -3.018792930395796e-20,  2.430713668953487e-05, -4.136505829423726e-06,
  3.803897582919651e-07, -2.476569469730411e-08,  1.272776020745159e-09, -5.473499310244293e-11,  2.042037064017296e-12, -6.772339968845437e-14,  2.031844620762591e-15,
 -5.587491305801586e-17,  1.422771198065219e-18, -3.380311675679499e-20,  7.762411281530743e-06, -1.519454691081873e-06,  1.591201610162325e-07, -1.168918423442602e-08,
  6.725956299378368e-10, -3.217162352267442e-11,  1.327403258489889e-12, -4.844360320616287e-14,  1.592256595108199e-15, -4.777762625458878e-17,  1.322658998693196e-18,
 -3.404826104432364e-20,  2.401726905885638e-06, -5.346295358215982e-07,  6.322173980231264e-08, -5.204299039100817e-09,  3.332879363986344e-10, -1.763812135474561e-11,
  8.009978546865986e-13, -3.202576888380434e-14,  1.148419415685793e-15, -3.745370899753875e-17,  1.123054204532137e-18, -3.121138245565240e-20,  7.300186166365600e-07,
 -1.827774183483558e-07,  2.420134405621121e-08, -2.216633636207025e-09,  1.570179637486044e-10, -9.142866056838151e-12,  4.546767057083717e-13, -1.982241296616437e-14,
  7.720734338715469e-16, -2.725300782170991e-17,  8.815881721678185e-19, -2.634955474531919e-20,  2.214113823708027e-07, -6.168006078170585e-08,  9.066059271498798e-09,
 -9.170987261083579e-10,  7.138617722118048e-11, -4.546277288987643e-12,  2.462229003769931e-13, -1.164498055603873e-14,  4.902781857096586e-16, -1.864522716613237e-17,
  6.478317590373752e-19, -2.073655369430188e-20,  6.816228769417289e-08, -2.089982258431290e-08,  3.379769541866386e-09, -3.746406223082647e-10,  3.181824201486805e-11,
 -2.201914610918938e-12,  1.290918589226758e-13, -6.585698476098850e-15,  2.981112482147594e-16, -1.215227718713858e-17,  4.513132250919867e-19, -1.539870909001090e-20,
  2.168668069486494e-08, -7.239175933381475e-09,  1.275907628746174e-09, -1.536772930053750e-10,  1.413107678204778e-11, -1.055033474465920e-12,  6.650790765700869e-14,
 -3.636786520872548e-15,  1.759370576591754e-16, -7.643694613586167e-18,  3.017651373519953e-19, -1.091742326366981e-20,  7.259281460274977e-09, -2.608827229204205e-09,
  4.961665070091222e-10, -6.434400659577050e-11,  6.351695223292976e-12, -5.075670230466550e-13,  3.414706928857769e-14, -1.987259764236868e-15,  1.020520139798947e-16,
 -4.694947428179084e-18,  1.958196277141173e-19, -7.467461843727380e-21,  2.596637986172957e-09, -9.932933684353733e-10,  2.016950206086437e-10, -2.788376017753920e-11,
  2.927482463595752e-12, -2.481888578865003e-13,  1.767117814756160e-14, -1.085850694501043e-15,  5.874480430534956e-17, -2.841121406035077e-18,  1.243235180509115e-19,
 -4.964041607236756e-21,  1.001799049222907e-09, -4.032029798273321e-10,  8.642968191523038e-11, -1.260144298952515e-11,  1.392791786118526e-12, -1.240618318760269e-13,
  9.262413038146630e-15, -5.956546561567680e-16,  3.366329018623268e-17, -1.697747501927327e-18,  7.733977872867221e-20, -3.209342628161623e-21,  4.143529801274815e-10,
 -1.734088476782714e-10,  3.877303626151026e-11, -5.893363803588192e-12,  6.781708496696895e-13, -6.279904096645342e-14,  4.866767666384191e-15, -3.243881198419369e-16,
  1.897383995744147e-17, -9.890083946350328e-19,  4.650336130740972e-20, -1.989162357105323e-21,  1.749931304788254e-10, -7.524865829961174e-11,  1.733091339514823e-11,
 -2.712655560829483e-12,  3.211697364367109e-13, -3.056812894238050e-14,  2.432309306101352e-15, -1.662848805957611e-16,  9.965822590739341e-18, -5.317467183016855e-19,
  2.556997717891051e-20, -1.117490125771725e-21,  5.955126554401224e-11, -2.599723751254941e-11,  6.087900288323403e-12, -9.687374263272758e-13,  1.165490636178920e-13,
 -1.126577312102109e-14,  9.098588224648375e-16, -6.309832044375935e-17,  3.833904603651788e-18, -2.072802654569797e-19,  1.009438080260139e-20, -4.465346744798752e-22,
  9.842851150895657e-02, -4.105199126068655e-04,  1.807755930872727e-06, -8.292482682583951e-09,  3.905999916424572e-11, -1.868393011563248e-13,  8.998573319763317e-16,
 -4.343667718037989e-18,  2.093349455652710e-20, -1.006468645950675e-22,  4.817337383177912e-25, -2.298240516332130e-27,  8.860450945900995e-02, -5.131404479590025e-04,
  3.613591738369264e-06, -2.573929151427123e-08,  1.778814815737166e-10, -1.190805521873664e-12,  7.758216364769299e-15, -4.941221101430812e-17,  3.086691614106344e-19,
 -1.895981305800039e-21,  1.147270612886030e-23, -6.849258345306868e-26,  7.182459923916469e-02, -6.495100523552152e-04,  6.712530529474467e-06, -6.378762856673695e-08,
  5.656010071329333e-10, -4.763185263123644e-12,  3.850635989617955e-14, -3.008938334700385e-16,  2.283893897871505e-18, -1.690179206108820e-20,  1.223055785327982e-22,
 -8.673763065204093e-25,  5.246555252013529e-02, -7.316945673966427e-04,  1.008933029368759e-05, -1.213363728402549e-07,  1.333529902234260e-09, -1.370644578541386e-11,
  1.335419219078928e-13, -1.244634154914476e-15,  1.117024102004568e-17, -9.701454148409852e-20,  8.185414305191841e-22, -6.729477193420438e-24,  3.457211924874528e-02,
 -7.097956902787226e-04,  1.250755219449622e-05, -1.862080247485163e-07,  2.485423521864478e-09, -3.056664408042882e-11,  3.522185927965829e-13, -3.846115783320324e-15,
  4.012480072306266e-17, -4.023724930934862e-19,  3.896853452513398e-21, -3.658131372854628e-23,  2.058165693059390e-02, -5.934784703254985e-04,  1.308094179439533e-05,
 -2.373454484473747e-07,  3.789340228753944e-09, -5.497637940135297e-11,  7.393657703222713e-13, -9.341608018646266e-15,  1.119455151919526e-16, -1.281459107541807e-18,
  1.408965716685081e-20, -1.494305934890575e-22,  1.109175096651012e-02, -4.315176384292659e-04,  1.172815202731035e-05, -2.560485927328146e-07,  4.832519925669593e-09,
 -8.182510716567216e-11,  1.271588696949324e-12, -1.841475624944683e-14,  2.512171587877587e-16, -3.254611812140121e-18,  4.029162566184691e-20, -4.789368646873599e-22,
  5.424920865268154e-03, -2.755153746313867e-04,  9.124358853950789e-06, -2.371120747490435e-07,  5.240303509958021e-09, -1.026705468877613e-10,  1.829077114100513e-12,
 -3.013450820820232e-14,  4.646920905062374e-16, -6.767383157477137e-18,  9.371794222950598e-20, -1.240714642761336e-21,  2.415776287063268e-03, -1.558960509511813e-04,
  6.222647581666546e-06, -1.906962678450095e-07,  4.895973058179155e-09, -1.102059296030482e-10,  2.235955190353045e-12, -4.165203869696730e-14,  7.218140895961387e-16,
 -1.175088761170540e-17,  1.810663638651530e-19, -2.656007576267340e-21,  9.833951806772483e-04, -7.885410006256358e-05,  3.754841580585935e-06, -1.345855883832155e-07,
  3.986380035692956e-09, -1.024586281710004e-10,  2.354159360716436e-12, -4.932584470781568e-14,  9.558807208756779e-16, -1.731379191707832e-17,  2.955018758441510e-19,
 -4.781855453485396e-21,  3.677486723949643e-04, -3.595821155136076e-05,  2.022979173717272e-06, -8.417681358598885e-08,  2.858587926022054e-09, -8.343475060385527e-11,
  2.160253613348524e-12, -5.067665461160917e-14,  1.093440257211295e-15, -2.194509283485993e-17,  4.132298617489882e-19, -7.348803534372908e-21,  1.271014436279516e-04,
 -1.491229775842085e-05,  9.822001040507517e-07, -4.711718550869522e-08,  1.823977563857413e-09, -6.015323546772413e-11,  1.747102424357511e-12, -4.569504943206142e-14,
  1.093479784560431e-15, -2.422653201079858e-17,  5.015170537952527e-19, -9.768033067427536e-21,  4.089955496014188e-05, -5.677059378646899e-06,  4.339950679535505e-07,
 -2.384407529299612e-08,  1.046484886817423e-09, -3.881099262535968e-11,  1.259103806358889e-12, -3.657245725050630e-14,  9.670636077752745e-16, -2.357021343031326e-17,
  5.346322069346157e-19, -1.136791820448411e-20,  1.236265781225001e-05, -2.004579400935544e-06,  1.763998489419990e-07, -1.102905304229546e-08,  5.458805951518967e-10,
 -2.266175850944013e-11,  8.177927816104730e-13, -2.627966141770079e-14,  7.651236075909543e-16, -2.044579647422059e-17,  5.065183830238855e-19, -1.172135692627248e-20,
  3.547745250778594e-06, -6.642134112742542e-07,  6.674391600638526e-08, -4.719046934820442e-09,  2.620100401582841e-10, -1.211915980721486e-11,  4.844509592820654e-13,
 -1.715698706563862e-14,  5.480305563118438e-16, -1.600174919606051e-17,  4.315708074849544e-19, -1.083518445659523e-20,  9.788738965131129e-07, -2.092891578343254e-07,
  2.382530010707262e-08, -1.892830280784043e-09,  1.172516883791245e-10, -6.013801894836829e-12,  2.651358930545988e-13, -1.030707797288231e-14,  3.598525157268499e-16,
 -1.144033529994584e-17,  3.347714476619575e-19, -9.089069300227153e-21,  2.635517007036630e-07, -6.366830092808287e-08,  8.145779686684397e-09, -7.223882125366762e-10,
  4.964107261466126e-11, -2.808882575440171e-12,  1.359495773372589e-13, -5.776329512837603e-15,  2.195397323003321e-16, -7.570387229238048e-18,  2.394787681439497e-19,
 -7.006437157008209e-21,  7.043390268768973e-08, -1.902352096714935e-08,  2.712966059837768e-09, -2.666974159063772e-10,  2.020621813703449e-11, -1.254387109705168e-12,
  6.631127341133453e-14, -3.064832457460758e-15,  1.262406389202492e-16, -4.701672813684273e-18,  1.601325586901765e-19, -5.028903836544070e-21,  1.904667188773296e-08,
 -5.690447411708241e-09,  8.967878815440447e-10, -9.699259896226994e-11,  8.047794663806293e-12, -5.447602845418858e-13,  3.127489887355962e-14, -1.564011453355417e-15,
  6.946576464769341e-17, -2.780904145450399e-18,  1.015069025797500e-19, -3.406680895199352e-21,  5.321757626638439e-09, -1.739607601123825e-09,  3.001759762259630e-10,
 -3.542675986997551e-11,  3.195149852970935e-12, -2.342051593620716e-13,  1.450819231264004e-14, -7.802541452673533e-16,  3.715319576938310e-17, -1.589940719815717e-18,
  6.187022221975437e-20, -2.207779303342898e-21,  1.569782819097466e-09, -5.551298336098558e-10,  1.038418181774812e-10, -1.325238063966446e-11,  1.288342334657295e-12,
 -1.014633397147595e-13,  6.732066615128054e-15, -3.866485032190169e-16,  1.960737244032380e-17, -8.912852652902391e-19,  3.675075756654013e-20, -1.386239523945394e-21,
  4.987403600031663e-10, -1.885800904590853e-10,  3.782935756692902e-11, -5.168318821977105e-12,  5.365033255182781e-13, -4.499521760748530e-14,  3.170849870757389e-15,
 -1.929372695688595e-16,  1.034068719295941e-17, -4.956671146478720e-19,  2.150548910612070e-20, -8.517267286512123e-22,  1.731339788964889e-10, -6.915061248822400e-11,
  1.470250776821255e-11, -2.126595285330039e-12,  2.332500637183634e-13, -2.062484611456657e-14,  1.529108252672061e-15, -9.768083553264878e-17,  5.485352075022481e-18,
 -2.749662939914585e-19,  1.245334551557707e-20, -5.139177942672488e-22,  6.561661146745865e-11, -2.733909616398589e-11,  6.083568201028990e-12, -9.203290834244670e-13,
  1.054249463214091e-13, -9.719937136409902e-15,  7.501352073426751e-16, -4.980034340486000e-17,  2.901801262148641e-18, -1.507059089248727e-19,  7.061575236019482e-21,
 -3.010534875616491e-22,  2.598678898736233e-11, -1.115102402954198e-11,  2.562334371366177e-12, -4.001456684435859e-13,  4.727133167079364e-14, -4.489599979767203e-15,
  3.565084695673892e-16, -2.432495772047770e-17,  1.455108943128630e-18, -7.750031072137022e-20,  3.720290959823828e-21, -1.623193604017210e-22,  8.520886955492873e-12,
 -3.716946010377949e-12,  8.696695255304305e-13, -1.382674158315998e-13,  1.662099219982038e-14, -1.605289078228848e-15,  1.295450271812252e-16, -8.976963962746720e-18,
  5.450397787108221e-19, -2.944625228245640e-20,  1.433001146974158e-21, -6.334712529507689e-23,  9.681474035871229e-02, -3.964455565809345e-04,  1.711876275859954e-06,
 -7.696283601655264e-09,  3.552970492958758e-11, -1.666297217137063e-13,  7.870935532782998e-16, -3.728238457101787e-18,  1.763402009994303e-20, -8.325502509861667e-23,
  3.912364643673525e-25, -1.833940989239268e-27,  8.660787494898944e-02, -4.854205628351054e-04,  3.321042462818132e-06, -2.307405107963532e-08,  1.558207880291750e-10,
 -1.020154725601828e-12,  6.503296109728229e-15, -4.054388418652554e-17,  2.479967833254316e-19, -1.492051116585068e-21,  8.845546940180528e-24, -5.175167184200048e-26,
  6.932931969809769e-02, -5.987246982744350e-04,  5.998388147703202e-06, -5.545263261248514e-08,  4.789368139004250e-10, -3.932404615730877e-12,  3.101936766136381e-14,
 -2.366703038638826e-16,  1.755015435773517e-18, -1.269466717388021e-20,  8.982575181806918e-23, -6.231470591654448e-25,  4.969146793546195e-02, -6.564611092525755e-04,
  8.752799805080728e-06, -1.020299485083718e-07,  1.088824051732981e-09, -1.088225985384508e-11,  1.032133002284135e-13, -9.372841976791791e-16,  8.202117572725095e-18,
 -6.950387869174245e-20,  5.724815432108325e-22, -4.596892071154715e-24,  3.191980220912590e-02, -6.180408717616772e-04,  1.049287622667179e-05, -1.509067845057167e-07,
  1.950596847222074e-09, -2.327298348904331e-11,  2.605231650856074e-13, -2.766692192664552e-15,  2.809640760262895e-17, -2.744750412814963e-19,  2.591309616010514e-21,
 -2.372778287089961e-23,  1.840035218318160e-02, -4.992705308733209e-04,  1.056318516442457e-05, -1.846302520030773e-07,  2.847998013217579e-09, -4.000461991257515e-11,
  5.217239924067975e-13, -6.400371305988279e-15,  7.455115155880892e-17, -8.302549513455949e-19,  8.888134534355602e-21, -9.184604822766113e-23,  9.535575445219003e-03,
 -3.487827189878545e-04,  9.070414965464561e-06, -1.903223895418927e-07,  3.463707186233996e-09, -5.668401715736441e-11,  8.529067140009962e-13, -1.197641723094765e-14,
  1.586128957108836e-16, -1.996934585297239e-18,  2.404614096580476e-20, -2.782427904023142e-22,  4.452653034038963e-03, -2.126183949122366e-04,  6.721329654329890e-06,
 -1.675686874259413e-07,  3.565341274543967e-09, -6.741922534324505e-11,  1.161467327947718e-12, -1.853365873901169e-14,  2.771779432214433e-16, -3.919256540447875e-18,
  5.275052736054548e-20, -6.793349592036793e-22,  1.878942399176898e-03, -1.140869504124453e-04,  4.340034118246125e-06, -1.274320876663240e-07,  3.146012770296723e-09,
 -6.827404568740931e-11,  1.338256750727292e-12, -2.412519918105409e-14,  4.051684006686521e-16, -6.400126545966197e-18,  9.579223218736326e-20, -1.366206681690412e-21,
  7.191757380470692e-04, -5.432907512078317e-05,  2.463680291793982e-06, -8.454110945418738e-08,  2.406021519586812e-09, -5.957933729215204e-11,  1.321722886755268e-12,
 -2.678574434230255e-14,  5.028145269153034e-16, -8.833530748578770e-18,  1.463983636834408e-19, -2.302788339372152e-21,  2.508369929008709e-04, -2.314798408806206e-05,
  1.240174511435557e-06, -4.939164430560049e-08,  1.611125682673013e-09, -4.529199114442888e-11,  1.131939425028389e-12, -2.567783689725270e-14,  5.365993819319457e-16,
 -1.044437713746224e-17,  1.909608665906755e-19, -3.301006949974764e-21,  8.018272643225183e-05, -8.898734319866309e-06,  5.585369146863886e-07, -2.565282967152743e-08,
  9.540406907106424e-10, -3.030806011325135e-11,  8.497963445401241e-13, -2.149600403215889e-14,  4.982816865468795e-16, -1.070851852401394e-17,  2.152926648909987e-19,
 -4.077000658043219e-21,  2.365875918164136e-05, -3.114800110528912e-06,  2.272127252753271e-07, -1.196222407301136e-08,  5.047175931746852e-10, -1.804151723801465e-11,
  5.653389708158650e-13, -1.588977929597502e-14,  4.072094121030210e-16, -9.632229842492168e-18,  2.123028501997976e-19, -4.391487610114286e-21,  6.500156266165430e-06,
 -1.002879632425832e-06,  8.437301268857609e-08, -5.062361449240489e-09,  2.411648844442933e-10, -9.659829182431744e-12,  3.370303267009981e-13, -1.048965413515784e-14,
  2.962502464417501e-16, -7.689732366356501e-18,  1.852745431481016e-19, -4.174499035566664e-21,  1.680801336287747e-06, -3.005131154755544e-07,  2.894270926263714e-08,
 -1.967716689975597e-09,  1.053354084396733e-10, -4.708231104072956e-12,  1.822231118434180e-13, -6.258842683310731e-15,  1.941791696406509e-16, -5.514255288673578e-18,
  1.448149320637120e-19, -3.544243234682451e-21,  4.143716402142697e-07, -8.495149754482727e-08,  9.297513329478337e-09, -7.120862901424764e-10,  4.262502329133484e-11,
 -2.116942963015118e-12,  9.053539359186035e-14, -3.419470459597449e-15,  1.161530588756420e-16, -3.597295742022223e-18,  1.026632097959595e-19, -2.721331419775666e-21,
  9.891851344206247e-08, -2.301656869212023e-08,  2.841258704700995e-09, -2.436595907076287e-10,  1.622479920250331e-11, -8.912223279403792e-13,  4.194153023939576e-14,
 -1.735230134025983e-15,  6.430123359690412e-17, -2.164388671965497e-18,  6.690532564807465e-20, -1.914728683329604e-21,  2.328758325666745e-08, -6.087388497106224e-09,
  8.410124816011983e-10, -8.023537573247217e-11,  5.909741414139562e-12, -3.572172102960702e-13,  1.841281903017090e-14, -8.308599491008636e-16,  3.345135861771190e-17,
 -1.219051749208730e-18,  4.066572591610697e-20, -1.252002605172693e-21,  5.522187095176782e-09, -1.604839404725615e-09,  2.461017856720200e-10, -2.593512439525505e-11,
  2.099703637568856e-12, -1.388632331282934e-13,  7.798333470553327e-15, -3.818996295548275e-16,  1.662736153146314e-17, -6.531102879073938e-19,  2.341089323781062e-20,
 -7.722091106316386e-22,  1.350590816957963e-09, -4.316697151999057e-10,  7.282000459047583e-11, -8.410098054073795e-12,  7.430678761158239e-13, -5.341448275073007e-14,
  3.248101163519429e-15, -1.716339778683816e-16,  8.036781122176617e-18, -3.384750436241001e-19,  1.297190972469193e-20, -4.562062385498703e-22,  3.494186473222471e-10,
 -1.214326725655194e-10,  2.231328043503959e-11, -2.799093114000836e-12,  2.676929321967499e-13, -2.075615476339624e-14,  1.356912061577423e-15, -7.684190617419987e-17,
  3.844784588512441e-18, -1.725492048101206e-19,  7.028472365752049e-21, -2.620475613364379e-22,  9.802722130699228e-11, -3.659972239107379e-11,  7.245786300523275e-12,
 -9.773581070292709e-13,  1.002228208821364e-13, -8.308078893136262e-15,  5.790187782143240e-16, -3.486150665429006e-17,  1.849734538579013e-18, -8.781805210384582e-20,
  3.775442860257061e-21, -1.482285624553741e-22,  3.042147729639824e-11, -1.204903634214995e-11,  2.539133881538541e-12, -3.640920929943177e-13,  3.960340528179229e-14,
 -3.474151337302537e-15,  2.556254575413107e-16, -1.621202027721880e-17,  9.041496933606572e-19, -4.502579406817306e-20,  2.026488661125921e-21, -8.312985964458304e-23,
  1.049844761850038e-11, -4.352896501797706e-12,  9.635474349209886e-13, -1.450177548073121e-13,  1.652979636411481e-14, -1.516789923493710e-15,  1.165282772063136e-16,
 -7.702699484229410e-18,  4.469739196800748e-19, -2.312221570789666e-20,  1.079348896489640e-21, -4.585021859275931e-23,  3.878886267850367e-12, -1.660609823939039e-12,
  3.806232451587295e-13, -5.929221409756799e-14,  6.987667714956578e-15, -6.621207280714059e-16,  5.246088091234901e-17, -3.571858164410678e-18,  2.132321509305810e-19,
 -1.133476770096898e-20,  5.430917737651364e-22, -2.365316641123472e-23,  1.221542924888712e-12, -5.324155569226836e-13,  1.244570677425272e-13, -1.976905146507528e-14,
  2.374280032965176e-15, -2.291121242024564e-16,  1.847340312390981e-17, -1.279082422032225e-18,  7.759816347561060e-20, -4.189077658622110e-21,  2.037091785623613e-22,
 -8.998656275796160e-24,  9.525577655291972e-02, -3.831105506877862e-04,  1.622824979087540e-06, -7.153477088330458e-09,  3.237787547695778e-11, -1.489310651297762e-13,
  6.901729950023639e-16, -3.209035268177311e-18,  1.490012905228209e-20, -6.910576491362815e-23,  3.188784849865588e-25, -1.469474484448051e-27,  8.471763360710677e-02,
 -4.599188917221745e-04,  3.058465796187558e-06, -2.073603338572456e-08,  1.368909635554097e-10, -8.768489036304468e-13,  5.471557181741017e-15, -3.340333444092262e-17,
  2.001392173045692e-19, -1.179843249943227e-21,  6.855268395636948e-24, -3.931850765663801e-26,  6.702635706441280e-02, -5.532747738441057e-04,  5.376464236501797e-06,
 -4.838052317479249e-08,  4.072276935749400e-10, -3.261513625609761e-12,  2.511479266646770e-14, -1.871787297358006e-16,  1.356583612080954e-18, -9.594937885761229e-21,
  6.641309266961177e-23, -4.508503595298682e-25,  4.719831136957555e-02, -5.910556970411157e-04,  7.626198055676419e-06, -8.622375259376412e-08,  8.939683018938956e-10,
 -8.692572511500449e-12,  8.029709557261810e-14, -7.107982303195409e-16,  6.067705052028821e-18, -5.018768946956712e-20,  4.037121165122431e-22, -3.167403728593073e-24,
  2.960476084546002e-02, -5.408441167718739e-04,  8.854924581878642e-06, -1.231058114552660e-07,  1.541876652005624e-09, -1.785690186787753e-11,  1.942891347219251e-13,
 -2.007576360398822e-15,  1.985430020654426e-17, -1.890281365200636e-19,  1.740395412525208e-21, -1.555051560189974e-23,  1.655926780622542e-02, -4.229093171394628e-04,
  8.596675125451136e-06, -1.448391074913295e-07,  2.159887690536166e-09, -2.938953860475427e-11,  3.718661370104000e-13, -4.431535504013833e-15,  5.019452228879670e-17,
 -5.440645638381293e-19,  5.673112281760837e-21, -5.714017024512265e-23,  8.272331634569939e-03, -2.844922064009002e-04,  7.084964983560380e-06, -1.429648136547220e-07,
  2.510266611381966e-09, -3.972512503070484e-11,  5.790148829949924e-13, -7.886958767906739e-15,  1.014437568098630e-16, -1.241626576940423e-18,  1.454767171738722e-20,
 -1.639203689061729e-22,  3.698230899491181e-03, -1.660147272503926e-04,  5.012745452084208e-06, -1.199556953561787e-07,  2.458349978349277e-09, -4.488618075007418e-11,
  7.480862368876365e-13, -1.156627854486058e-14,  1.678191856595489e-16, -2.304728542083794e-18,  3.015768953401903e-20, -3.779098999891838e-22,  1.483434561220721e-03,
 -8.472118297622199e-05,  3.072888659702595e-06, -8.648044526918056e-08,  2.053753586885140e-09, -4.298596135739601e-11,  8.142906735659210e-13, -1.421026467379228e-14,
  2.313478602262763e-16, -3.546827193847734e-18,  5.157766293609412e-20, -7.153842146336373e-22,  5.356704190920137e-04, -3.810367624994722e-05,  1.645800153468878e-06,
 -5.407962362147402e-08,  1.479180674812762e-09, -3.529767067668705e-11,  7.562145401562270e-13, -1.482596534355538e-14,  2.696403206653330e-16, -4.595418104608640e-18,
  7.396554916359240e-20, -1.131072941060540e-21,  1.748727434750716e-04, -1.521950064550499e-05,  7.764387850244826e-07, -2.959782941522766e-08,  9.274391953489944e-10,
 -2.511384351976996e-11,  6.058968002148915e-13, -1.329239876110506e-14,  2.690502559865851e-16, -5.079080897949565e-18,  9.017355039303166e-20, -1.515227724372790e-21,
  5.188834925801733e-05, -5.442043102624330e-06,  3.253870695487692e-07, -1.430559997564569e-08,  5.110693994310759e-10, -1.563827579195883e-11,  4.232686831632722e-13,
 -1.035445408305291e-14,  2.324858639037789e-16, -4.846191924316084e-18,  9.461928329868721e-20, -1.742017413896015e-21,  1.408872045643047e-05, -1.757291534101463e-06,
  1.222420430171141e-07, -6.164556827900650e-09,  2.499675942109778e-10, -8.609865084091859e-12,  2.605316974071750e-13, -7.084245809440597e-15,  1.759160642902590e-16,
 -4.037671238053473e-18,  8.645990919094650e-20, -1.739475631462624e-21,  3.530189191540026e-06, -5.175471771246647e-07,  4.159191664824830e-08, -2.393233182458840e-09,
  1.096770460249611e-10, -4.236727156228180e-12,  1.428566927306053e-13, -4.304704630619499e-15,  1.178885220780348e-16, -2.971366576680260e-18,  6.960357670090521e-20,
 -1.526466077763827e-21,  8.249359873234263e-07, -1.406349465970618e-07,  1.296775653723410e-08, -8.470089312310072e-10,  4.368419757930338e-11, -1.885606220809598e-12,
  7.061651320727242e-14, -2.351023939973359e-15,  7.080863469606012e-17, -1.954696292110089e-18,  4.996250024859064e-20, -1.191472324486057e-21,  1.821332490771227e-07,
 -3.574377550752547e-08,  3.756103514102885e-09, -2.770296468004136e-10,  1.600935734290855e-11, -7.692487667197079e-13,  3.188830886008975e-14, -1.169325534336757e-15,
  3.861886332682820e-17, -1.164398024275603e-18,  3.238973956649901e-20, -8.377582110270675e-22,  3.860318922361068e-08, -8.636093384436142e-09,  1.027112620191136e-09,
 -8.507131467941599e-11,  5.483062006243934e-12, -2.920845735595371e-13,  1.335305175662182e-14, -5.374772471402459e-16,  1.940325449638716e-17, -6.370479823769623e-19,
  1.922920239760606e-20, -5.379296744462248e-22,  8.007179230047716e-09, -2.022062065437738e-09,  2.702167178018336e-10, -2.498460696663848e-11,  1.786810300386506e-12,
 -1.050443770821283e-13,  5.274036791349720e-15, -2.321239289837139e-16,  9.126542983063326e-18, -3.251614286772976e-19,  1.061531897916110e-20, -3.201535014168180e-22,
  1.662895699932410e-09, -4.692562060707746e-10,  6.991217053865754e-11, -7.168681162362235e-12,  5.655655142554299e-13, -3.650059665633525e-14,  2.002915822291983e-15,
 -9.595536018790912e-17,  4.091376628048600e-18, -1.575387259901770e-19,  5.540748245165101e-21, -1.794787596506739e-22,  3.549778652250044e-10, -1.107519212906204e-10,
  1.823785762508696e-11, -2.058370361998576e-12,  1.779387354040030e-13, -1.252906822243030e-14,  7.470854996019969e-16, -3.874830856293181e-17,  1.782522401974941e-18,
 -7.381552104875712e-20,  2.783756582956880e-21, -9.640981418316369e-23,  8.018682278628673e-11, -2.734727842896283e-11,  4.929579058954668e-12, -6.070933315747681e-13,
  5.704995942162795e-14, -4.350409702313314e-15,  2.799393392617325e-16, -1.561635488588302e-17,  7.702642494082878e-19, -3.410058484797773e-20,  1.371089525127238e-21,
 -5.049036465393843e-23,  1.974742741397073e-11, -7.272179833711466e-12,  1.419282390837953e-12, -1.888143988362257e-13,  1.910808354405153e-14, -1.564219421760556e-15,
  1.077218362774716e-16, -6.412453347949725e-18,  3.365828081794466e-19, -1.581587647617556e-20,  6.733063292467215e-22, -2.618885063436415e-23,  5.441898241154310e-12,
 -2.135674954727296e-12,  4.457140125385836e-13, -6.331127160699696e-14,  6.824535998839352e-15, -5.935292499281416e-16,  4.331404885338840e-17, -2.725610041627298e-18,
  1.508795118243717e-19, -7.460480357162677e-21,  3.335095077199905e-22, -1.359318449606507e-23,  1.698637267187888e-12, -7.005325232799866e-13,  1.541794888708316e-13,
 -2.307434876329607e-14,  2.615920249665225e-15, -2.387999870977967e-16,  1.825554862826155e-17, -1.201048381787350e-18,  6.938224202133409e-20, -3.573829477993702e-21,
  1.661457225627903e-22, -7.030335257621411e-24,  5.822177618873684e-13, -2.486268364346447e-13,  5.683027941109422e-14, -8.828822210609087e-15,  1.037761655128013e-15,
 -9.808626765094401e-17,  7.752795160567947e-18, -5.266396882743721e-19,  3.136980875148305e-20, -1.663997744850059e-21,  7.956705968572113e-23, -3.458666416809004e-24,
  1.754783202099758e-13, -7.641499936098552e-14,  1.784508125118161e-14, -2.831759083159558e-15,  3.397687207243107e-16, -3.275613123056532e-17,  2.638744264774331e-18,
 -1.825440033403160e-19,  1.106500486614322e-20, -5.968452761895556e-22,  2.900071566899886e-23, -1.280096197630728e-24,  9.374876802740677e-02, -3.704627316491039e-04,
  1.539996069658612e-06, -6.658389674806469e-09,  2.955788661083760e-11, -1.333934839842192e-13,  6.066381104266786e-16, -2.769695330765035e-18,  1.262715565994097e-20,
 -5.755427041474622e-23,  2.607859798626288e-25, -1.182283234666626e-27,  8.292536841987300e-02, -4.364105485959881e-04,  2.822218481036562e-06, -1.867924434701931e-08,
  1.205949807343932e-10, -7.560687828717208e-13,  4.619899476215943e-15, -2.762875113694642e-17,  1.622107585429269e-19, -9.373030217750041e-22,  5.339287743047072e-24,
 -3.003151759555269e-26,  6.489575457406897e-02, -5.124793123620644e-04,  4.832940637866441e-06, -4.235567017044896e-08,  3.476245111893525e-10, -2.717046999864343e-12,
  2.043305240307487e-14, -1.488184316137068e-16,  1.054563812213096e-18, -7.296093863938501e-21,  4.941915256512578e-23, -3.284121425714705e-25,  4.494988142681058e-02,
 -5.339542578383411e-04,  6.671918475026144e-06, -7.321275634826694e-08,  7.378827583116840e-10, -6.983894007097743e-12,  6.286219791227104e-14, -5.426764904738958e-16,
  4.520925359363623e-18, -3.651457033230058e-20,  2.869672309212622e-22, -2.200673058250400e-24,  2.757426538910675e-02, -4.755199949968454e-04,  7.514660846651413e-06,
 -1.010574328351071e-07,  1.227160827009013e-09, -1.380255375939651e-11,  1.460372690161250e-13, -1.468915300430888e-15,  1.415341323800985e-17, -1.313809912275998e-19,
  1.180131203540890e-21, -1.029318335111219e-23,  1.499494379580874e-02, -3.605424224427776e-04,  7.048020832172146e-06, -1.145374572488476e-07,  1.652160640239694e-09,
 -2.178888940668143e-11,  2.676117314246195e-13, -3.099379148253787e-15,  3.415201590266302e-17, -3.604321597537088e-19,  3.662123778265711e-21, -3.596513502024581e-23,
  7.237747010706567e-03, -2.340478295354608e-04,  5.586409642363794e-06, -1.084705088988564e-07,  1.838574151810040e-09, -2.814957499281248e-11,  3.976329858177409e-13,
 -5.256359567313078e-15,  6.568724607906828e-17, -7.819018673911865e-19,  8.917254492840178e-21, -9.787640714594425e-23,  3.106120705439399e-03, -1.310643605297453e-04,
  3.782537173421139e-06, -8.692847953115689e-08,  1.716773531403550e-09, -3.028062692714335e-11,  4.884290589346005e-13, -7.319814063614850e-15,  1.030755221676389e-16,
 -1.375350609959652e-18,  1.750184817548523e-20, -2.134692274236506e-22,  1.187853969798459e-03, -6.378956944654181e-05,  2.207016046998392e-06, -5.955792016232398e-08,
  1.361105346974512e-09, -2.748621464116412e-11,  5.033697541276460e-13, -8.506296660662227e-15,  1.342863257769982e-16, -1.998700545959344e-18,  2.824622167865784e-20,
 -3.810942401193826e-22,  4.059830274060268e-04, -2.717864134912177e-05,  1.118396476001864e-06, -3.519963258403803e-08,  9.255511009941754e-10, -2.128964969644613e-11,
  4.405849373728131e-13, -8.358388073243984e-15,  1.473108148933338e-16, -2.435978107574538e-18,  3.808534891055851e-20, -5.662819095084443e-22,  1.244799116335770e-04,
 -1.021002659824895e-05,  4.959752665092714e-07, -1.809791075919257e-08,  5.448227050069368e-10, -1.421263076950832e-11,  3.310537095156518e-13, -7.024638542821894e-15,
  1.377333566504295e-16, -2.522039549084480e-18,  4.348250713873323e-20, -7.102984333505423e-22,  3.440804185444825e-05, -3.407223142578624e-06,  1.940121875707760e-07,
 -8.163955790829484e-09,  2.801494894701147e-10, -8.256631438862058e-12,  2.157210540471699e-13, -5.103464939152058e-15,  1.109888419738441e-16, -2.244004741102154e-18,
  4.254712576100398e-20, -7.615338821635459e-22,  8.628075286389506e-06, -1.018436183732228e-06,  6.752216847321883e-08, -3.260430077292366e-09,  1.270247184899399e-10,
 -4.214993921212842e-12,  1.231430566268162e-13, -3.238877374538737e-15,  7.792011380867261e-17, -1.735100341860000e-18,  3.609084153262846e-20, -7.061248754324669e-22,
  1.978520024788181e-06, -2.752606167130417e-07,  2.111336455265315e-08, -1.164403150713306e-09,  5.130946825342569e-11, -1.910712300203502e-12,  6.224131839266388e-14,
 -1.815213450069554e-15,  4.818931634044688e-17, -1.179065764505238e-18,  2.684471282365375e-20, -5.728733384046864e-22,  4.191410414405173e-07, -6.803001721266196e-08,
  5.999473008829131e-09, -3.761650429395515e-10,  1.867837474039907e-11, -7.781185992785004e-13,  2.818207848787866e-14, -9.090018551336563e-16,  2.656494673369420e-17,
 -7.125506903540293e-19,  1.771871113826035e-20, -4.115483169574495e-22,  8.309089350281753e-08, -1.558347773627781e-08,  1.570340744837873e-09, -1.114175381517281e-10,
  6.210500858006697e-12, -2.884830547398845e-13,  1.158307576169730e-14, -4.120959750631081e-16,  1.322452819903668e-17, -3.879528622290361e-19,  1.051246914943126e-20,
 -2.651691378059426e-22,  1.566404369731424e-08, -3.363145920624078e-09,  3.848140933967119e-10, -3.074505696417123e-11,  1.915974519764549e-12, -9.888499363569026e-14,
  4.387607817589850e-15, -1.716776772105005e-16,  6.033134443774937e-18, -1.930649361454402e-19,  5.686608696931260e-21, -1.553981568507952e-22,  2.864496130943484e-09,
 -6.975286109393856e-10,  9.002170696848324e-11, -8.055841904516385e-12,  5.587130672369456e-13, -3.191023303843505e-14,  1.558967387459090e-15, -6.686030027449531e-17,
  2.564876328120940e-18, -8.926409958535586e-20,  2.849645987603395e-21, -8.412667074864915e-23,  5.205799325983326e-10, -1.423824693723139e-10,  2.057591871862451e-11,
 -2.049905035422817e-12,  1.573927087486168e-13, -9.900779817996315e-15,  5.302722707328738e-16, -2.482650959066275e-17,  1.035668958179705e-18, -3.905680149417512e-20,
  1.346641018302815e-21, -4.280235513252596e-23,  9.675494885299107e-11, -2.941675203756826e-11,  4.721275117322199e-12, -5.199823881725319e-13,  4.392249080402350e-14,
 -3.025715830072573e-15,  1.767147841750832e-16, -8.986866372133861e-18,  4.057571485969052e-19, -1.650608673854514e-20,  6.120024873322575e-22, -2.085524218186040e-23,
  1.900248281643885e-11, -6.350151137851797e-12,  1.121314612722412e-12, -1.353916335963384e-13,  1.248653121346223e-14, -9.353817979516981e-16,  5.918236543123180e-17,
 -3.248982924026092e-18,  1.578301522447861e-19, -6.886729586548913e-21,  2.730952371854760e-22, -9.925243620967338e-24,  4.083965706779364e-12, -1.481588549227789e-12,
  2.847150784194484e-13, -3.731553803841276e-14,  3.722959835785941e-15, -3.006720547799682e-16,  2.044175178461911e-17, -1.202085047944253e-18,  6.236765518434692e-20,
 -2.898412027306883e-21,  1.220972611717980e-22, -4.701733029402693e-24,  9.924607616462184e-13, -3.855922715912579e-13,  7.962553865231789e-14, -1.119466635400717e-14,
  1.194899133444172e-15, -1.029512723919145e-16,  7.446434230654111e-18, -4.646247595192879e-19,  2.551328375165726e-20, -1.251895470123756e-21,  5.555615714186290e-23,
 -2.248656292359956e-24,  2.782125708331903e-13, -1.140632062432373e-13,  2.494628399271941e-14, -3.710495981697388e-15,  4.181740485164773e-16, -3.795885053016671e-17,
  2.886257088993299e-18, -1.889177892581791e-19,  1.086021158882833e-20, -5.568022812635093e-22,  2.577077782415454e-23, -1.085872610032873e-24,  8.792495590457673e-14,
 -3.744279492557948e-14,  8.532752556952331e-15, -1.321665482901471e-15,  1.549070101277422e-16, -1.460116779968978e-17,  1.151053193844079e-18, -7.799355870706697e-20,
  4.634611469767465e-21, -2.452767489548799e-22,  1.170260720130392e-23, -5.076300346069967e-25,  2.526366293674803e-14, -1.099092061059171e-14,  2.563964609569795e-15,
 -4.064329906763649e-16,  4.871536975026070e-17, -4.691791660679254e-18,  3.775905976631927e-19, -2.609656673464846e-20,  1.580422351275136e-21, -8.517308524264371e-23,
  4.135053831719729e-24, -1.823728248099065e-25,  9.229106208953582e-02, -3.584545237973788e-04,  1.462847403295603e-06, -6.206040960232728e-09,  2.702955651505921e-11,
 -1.197209721157232e-13,  5.344459087902459e-16, -2.396861784743812e-18,  1.073108176222577e-20, -4.809253673880339e-23,  2.139529525456294e-25, -9.552238401525881e-28,
  8.122350693968682e-02, -4.146977139906845e-04,  2.609164481962811e-06, -1.686492416985233e-08,  1.065226232005792e-10, -6.539176679734226e-13,  3.914171749317661e-15,
 -2.293912429061712e-17,  1.320139604188430e-19, -7.479614968905382e-22,  4.178523519498020e-24, -2.305612656326425e-26,  6.292007359654853e-02, -4.757582691284106e-04,
  4.356333894653728e-06, -3.720311193638171e-08,  2.978687088819973e-10, -2.273073157491479e-12,  1.670165925032998e-14, -1.189199746344136e-16,  8.242618440752472e-19,
 -5.580416426614040e-21,  3.700170580678134e-23, -2.407923363094505e-25,  4.291552091378353e-02, -4.839025256892388e-04,  5.859844862990722e-06, -6.244696993031717e-08,
  6.121406222573260e-10, -5.642332752202135e-12,  4.950977637892542e-14, -4.170002005674160e-16,  3.391649044335184e-18, -2.676010791533505e-20,  2.055468751019021e-22,
 -1.541290645624674e-24,  2.578518466530232e-02, -4.199394857810546e-04,  6.411250159074470e-06, -8.345395185046519e-08,  9.830742696240359e-10, -1.074410128010148e-11,
  1.105975001015505e-13, -1.083388052926093e-15,  1.017456712547270e-17, -9.212190693979850e-20,  8.076162450826378e-22, -6.878719994331003e-24,  1.365743104484089e-02,
 -3.092376559145849e-04,  5.818852902866809e-06, -9.126757210250197e-08,  1.274171080376720e-09, -1.629515582500201e-11,  1.943635205924465e-13, -2.188680176173062e-15,
  2.347187433428581e-17, -2.412915092073356e-19,  2.389764121895453e-21, -2.289227400291616e-23,  6.383348048896929e-03, -1.941026954300239e-04,  4.444240413996530e-06,
 -8.308481872680002e-08,  1.360218674008617e-09, -2.015873650467320e-11,  2.760971536935112e-13, -3.543523256735086e-15,  4.304148773430332e-17, -4.984585762386052e-19,
  5.535284795085206e-21, -5.920263999464693e-23,  2.636380673182467e-03, -1.045518769701157e-04,  2.886108138745493e-06, -6.373161262801067e-08,  1.213530998358343e-09,
 -2.068640369658739e-11,  3.230751427834840e-13, -4.694936880974918e-15,  6.418775310323895e-17, -8.324126569427324e-19,  1.030482947386967e-20, -1.223725377234679e-22,
  9.639540496843097e-04, -4.865988438261903e-05,  1.606770500013531e-06, -4.159465947300939e-08,  9.151509124339146e-10, -1.783730692773864e-11,  3.159200952906880e-13,
 -5.171380080319522e-15,  7.918817363833943e-17, -1.144570935933708e-18,  1.572398236261541e-20, -2.064128314953596e-22,  3.128046433951760e-04, -1.969828907996488e-05,
  7.724672311583971e-07, -2.329356788038311e-08,  5.889854906381841e-10, -1.306296456364459e-11,  2.612058924195412e-13, -4.796233565189978e-15,  8.193394674665769e-17,
 -1.314904931009397e-18,  1.997305796576416e-20, -2.888091882824340e-22,  9.038386560411241e-05, -6.981829941763227e-06,  3.229580691248779e-07, -1.128195604922988e-08,
  3.263483490894187e-10, -8.202825917651678e-12,  1.844993400378517e-13, -3.787088684302791e-15,  7.193903906825328e-17, -1.277884499868315e-18,  2.139785862457465e-20,
 -3.398329780315427e-22,  2.335595421516187e-05, -2.181732235293659e-06,  1.182836527417109e-07, -4.763541524952662e-09,  1.570107312447565e-10, -4.457097907934691e-12,
  1.124122593438786e-13, -2.571920308535437e-15,  5.417819179277694e-17, -1.062464808354408e-18,  1.956276770455528e-20, -3.404030065402518e-22,  5.428372545767190e-06,
 -6.057070717381557e-07,  3.825615791489016e-08, -1.768272061959108e-09,  6.617661386419524e-11, -2.115142933194279e-12,  5.965439093512615e-14, -1.517487117850846e-15,
  3.536489512362241e-17, -7.639182098236583e-19,  1.543325294105013e-20, -2.936102011039683e-22,  1.143243492593504e-06, -1.507404584491708e-07,  1.102743664866119e-08,
 -5.825869198011609e-10,  2.467388085340668e-11, -8.854534964078035e-13,  2.785656800405686e-14, -7.860658084446479e-16,  2.022369382648771e-17, -4.802184055876205e-19,
  1.062421050313793e-20, -2.205637804651906e-22,  2.202927884524636e-07, -3.399048774678939e-08,  2.864037392061211e-09, -1.722477382437228e-10,  8.229295003899603e-12,
 -3.306812033609212e-13,  1.157691849239227e-14, -3.615988326223944e-16,  1.024943562822229e-17, -2.670198501429074e-19,  6.457159896014626e-21, -1.460207206267758e-22,
  3.932485510793551e-08, -7.036380798252718e-09,  6.791074539546154e-10, -4.630598996636105e-11,  2.487517245900023e-12, -1.116177294144860e-13,  4.337889894067206e-15,
 -1.496404247573962e-16,  4.663278054439181e-18, -1.330281274204127e-19,  3.509593317385771e-21, -8.628965721781241e-23,  6.607971068414578e-09, -1.359149208379269e-09,
  1.494025644636737e-10, -1.150060563128548e-11,  6.922353482771103e-13, -3.458123819970387e-14,  1.487953960981455e-15, -5.655036987325286e-17,  1.933101949575360e-18,
 -6.025200913003634e-20,  1.730577172092227e-21, -4.616716110213274e-23,  1.066542408848031e-09, -2.499556524144925e-10,  3.110517161972033e-11, -2.690344795211737e-12,
  1.807303344327207e-13, -1.001708333836269e-14,  4.757139402132015e-16, -1.986203272202385e-17,  7.427647885483016e-19, -2.523009966976068e-20,  7.869939370125164e-22,
 -2.272512319948293e-23,  1.695669748680738e-10, -4.486456003422209e-11,  6.278407315652612e-12, -6.068435132818493e-13,  4.528572350821262e-14, -2.773252156246272e-15,
  1.448108590453877e-16, -6.618764229814980e-18,  2.698761203794004e-19, -9.958631732565113e-21,  3.363194408443691e-22, -1.048047725590522e-23,  2.738432700072794e-11,
 -8.098470643462828e-12,  1.264733376750351e-12, -1.357267857198047e-13,  1.118738609835830e-14, -7.530475298227776e-16,  4.302879100277546e-17, -2.143284645099113e-18,
  9.488005495532403e-20, -3.787959385394161e-21,  1.379589453561895e-22, -4.621837222184513e-24,  4.657714071463410e-12, -1.522656579449355e-12,  2.629870595243638e-13,
 -3.108937385205563e-14,  2.810306554509952e-15, -2.065645059097514e-16,  1.283651396825758e-17, -6.927737100196578e-19,  3.311266493107770e-20, -1.422724479335694e-21,
  5.559607037414200e-23, -1.992513657757851e-24,  8.685782948332239e-13, -3.100031866186200e-13,  5.858247982020451e-14, -7.555054551525410e-15,  7.422789247556111e-16,
 -5.908042560938002e-17,  3.961550780246103e-18, -2.299235753650776e-19,  1.178129850108447e-20, -5.410584977842418e-22,  2.253655070556346e-23, -8.585738833237280e-25,
  1.848147379231703e-13, -7.101635944041774e-14,  1.449647063731905e-14, -2.015371838341119e-15,  2.128279856194475e-16, -1.815140856909108e-17,  1.300256372387078e-18,
 -8.038862519188225e-20,  4.375900500365368e-21, -2.129427866325886e-22,  9.375494574547899e-24, -3.766365043490046e-25,  4.617783730278741e-14, -1.880972032304658e-14,
  4.085408101808968e-15, -6.035698684402986e-16,  6.758344235768168e-17, -6.096981045583749e-18,  4.608765349741101e-19, -2.999812980854939e-20,  1.715334650206528e-21,
 -8.750072851266755e-23,  4.030348697027066e-24, -1.690447445276765e-25,  1.336711709969786e-14, -5.674990365940001e-15,  1.288979338877139e-15, -1.990046065929915e-16,
  2.325140545351782e-17, -2.185044651786330e-18,  1.717596062516274e-19, -1.160630183038507e-20,  6.878788914320678e-22, -3.631364512770076e-23,  1.728460360470284e-24,
 -7.480591881858477e-26,  3.645878169087339e-15, -1.584485952568924e-15,  3.692049808501046e-16, -5.845849697954031e-17,  6.999067838781440e-18, -6.733543290842149e-19,
  5.413432886443342e-20, -3.737639339173868e-21,  2.261335193495648e-22, -1.217549602435891e-23,  5.905709348730456e-25, -2.602388905118081e-26,  9.088018803868370e-02,
 -3.470424600563042e-04,  1.390892930146012e-06, -5.792048633991528e-09,  2.475816197092545e-11, -1.076623549422467e-13,  4.718923433087448e-16, -2.079595549805390e-18,
  9.144182986319420e-21, -4.031899830052763e-23,  1.760337086035941e-25, -7.752400988085977e-28,  7.960522061592523e-02, -3.946059021860038e-04,  2.416595934861144e-06,
 -1.526029504540611e-08,  9.433401067217702e-11, -5.672315033988537e-13,  3.327189549857320e-15, -1.911512812444496e-17,  1.078666857154211e-19, -5.994524477629019e-22,
  3.285240892673308e-24, -1.778900366899371e-26,  6.108402442382459e-02, -4.426156460408629e-04,  3.937059297740986e-06, -3.278020611168874e-08,  2.561605851540765e-10,
 -1.909385820457558e-12,  1.371289069414573e-14, -9.549175371562841e-17,  6.476403361358158e-19, -4.292164886433767e-21,  2.786983941921558e-23, -1.776641800618896e-25,
  4.106914661924315e-02, -4.398628948425956e-04,  5.165721573590710e-06, -5.349469252866434e-08,  5.102903594018159e-10, -4.582782515832417e-12,  3.921899328189840e-14,
 -3.224181060203893e-16,  2.561285308893871e-18, -1.974879381954435e-20,  1.483139446025034e-22, -1.087830035395828e-24,  2.420202131463298e-02, -3.724033206947442e-04,
  5.497527254638098e-06, -6.930928970477225e-08,  7.924564257466411e-10, -8.419843679821668e-12,  8.436352206237089e-14, -8.051763867582932e-16,  7.373473524198946e-18,
 -6.514293392914379e-20,  5.575947873628622e-22, -4.639402800575884e-24,  1.250710431345292e-02, -2.667443211901656e-04,  4.835975182000085e-06, -7.325401564674543e-08,
  9.903581189770299e-10, -1.228836596355298e-11,  1.424109518544728e-13, -1.559919097231231e-15,  1.628820123579119e-17, -1.631647011156623e-19,  1.575816765489361e-21,
 -1.472922197919227e-23,  5.672215348462397e-03, -1.621953229251059e-04,  3.565579181847346e-06, -6.421781961325046e-08,  1.016009732675159e-09, -1.458256080189758e-11,
  1.937409373656970e-13, -2.415196386400821e-15,  2.852564881310011e-17, -3.215233675505033e-19,  3.477849085481038e-21, -3.625875089484783e-23,  2.259935029442990e-03,
 -8.422096116946507e-05,  2.225426612425562e-06, -4.724449987472177e-08,  8.677844601126290e-10, -1.430308184119504e-11,  2.163795289043375e-13, -3.050301997310868e-15,
  4.050356963538632e-17, -5.106920863390824e-19,  6.152253736049256e-21, -7.115440832724312e-23,  7.921804145605063e-04, -3.757800429012674e-05,  1.184927797139811e-06,
 -2.943878226423957e-08,  6.238297103440044e-10, -1.174059950315563e-11,  2.011757447820111e-13, -3.191027405973508e-15,  4.741178027534392e-17, -6.656786431662572e-19,
  8.892262396703672e-21, -1.136058559051263e-22,  2.448031787158632e-04, -1.449428803888659e-05,  5.418557508733391e-07, -1.566010224657861e-08,  3.809015917483991e-10,
 -8.148069283162132e-12,  1.574718535691924e-13, -2.799384753939853e-15,  4.636460984867086e-17, -7.222864327048437e-19,  1.066149401570665e-20, -1.499551192475063e-22,
  6.687709691552395e-05, -4.861999458852839e-06,  2.141811736192179e-07, -7.164112133887222e-09,  1.991659603679125e-10, -4.824425017342344e-12,  1.048011333662433e-13,
 -2.081315952732612e-15,  3.830992081698252e-17, -6.602618163703932e-19,  1.073911298767925e-20, -1.658378541297936e-22,  1.621196147365718e-05, -1.427337188861295e-06,
  7.366802263852284e-08, -2.839284785108466e-09,  8.989466797122511e-11, -2.458049427232045e-12,  5.984807628379878e-14, -1.324312214784498e-15,  2.702293945805525e-17,
 -5.140283008871326e-19,  9.191509506088213e-21, -1.554906460615089e-22,  3.504986294625984e-06, -3.693078471297523e-07,  2.221126515683405e-08, -9.825136333550708e-10,
  3.531592947721454e-11, -1.087137222189365e-12,  2.959631495437381e-14, -7.280868428417025e-16,  1.643573523854201e-17, -3.443730701061081e-19,  6.756828474418465e-21,
 -1.249822955024580e-22,  6.804019653330953e-07, -8.491617127532629e-08,  5.920678371924510e-09, -2.994992014885739e-10,  1.218708481765342e-11, -4.213372405205518e-13,
  1.279843993537983e-14, -3.493553469479273e-16,  8.708637550898176e-18, -2.006439397637226e-19,  4.312505804328344e-21, -8.707918364782010e-23,  1.196674978407218e-07,
 -1.752699779498820e-08,  1.409710310011564e-09, -8.126577516666506e-11,  3.733488085931294e-12, -1.446391474556488e-13,  4.892516370741711e-15, -1.479213811145261e-16,
  4.065051521610777e-18, -1.028224459320202e-19,  2.417213817203201e-21, -5.320151084158930e-23,  1.929625668029294e-08, -3.288524143879057e-09,  3.036237213223163e-10,
 -1.987758018592216e-11,  1.028255856643297e-12, -4.453854937118185e-14,  1.674351764859592e-15, -5.597034458975555e-17,  1.692864126525557e-18, -4.693550679174518e-20,
  1.204998055091390e-21, -2.886449176003455e-23,  2.897425334649184e-09, -5.698660206153346e-10,  6.009530145556684e-11, -4.451799192026795e-12,  2.585520889321252e-13,
 -1.249075226682389e-14,  5.207526270392752e-16, -1.920907418037357e-17,  6.382724969301043e-19, -1.936362867093770e-20,  5.419976953480040e-22, -1.410661846165543e-23,
  4.133911348294667e-10, -9.306213380258218e-11,  1.114917840758033e-11, -9.307714650861050e-13,  6.049121330210464e-14, -3.250145043731998e-15,  1.498907633446695e-16,
 -6.086957748559472e-18,  2.217093307976332e-19, -7.344407903845106e-21,  2.236730361904003e-22, -6.312803380694972e-24,  5.750962569190660e-11, -1.469046990583866e-11,
  1.987440974719555e-12, -1.860935940902142e-13,  1.347946087925594e-14, -8.026342744766722e-16,  4.081565522716580e-17, -1.819326504197356e-18,  7.243662057050969e-20,
 -2.613095079030131e-21,  8.636312407891589e-23, -2.636411808587141e-24,  8.057872071569098e-12, -2.313488416480366e-12,  3.509589042672592e-13, -3.664350985179337e-14,
  2.943214957129311e-15, -1.933368602423917e-16,  1.079520476278565e-17, -5.260891484453813e-19,  2.281099568888779e-20, -8.929067972922351e-22,  3.191453917857830e-23,
 -1.050218236730911e-24,  1.182751751362741e-12, -3.775905231672396e-13,  6.368614119753627e-14, -7.360344166102299e-15,  6.512469326016698e-16, -4.690953142566864e-17,
  2.859811314752618e-18, -1.515658220688130e-19,  7.120724144075633e-21, -3.009821112106648e-22,  1.157966437856316e-23, -4.088978161747921e-25,  1.903125475673314e-13,
 -6.672747691885412e-14,  1.238285414683337e-14, -1.569351030411903e-15,  1.516562527809692e-16, -1.188297623434308e-17,  7.850420652250775e-19, -4.492533246090043e-20,
  2.271389801826850e-21, -1.029964312691368e-22,  4.238512853083712e-24, -1.596293514731578e-25,  3.519946823530689e-14, -1.336275617711562e-14,  2.693486968038438e-15,
 -3.699169657258476e-16,  3.861201209617497e-17, -3.256893498024747e-18,  2.308700757056721e-19, -1.413224337061290e-20,  7.620435938305801e-22, -3.675150695891674e-23,
  1.604342142983979e-24, -6.392967425982556e-26,  7.776775638028114e-15, -3.145105541678223e-15,  6.779238908331633e-16, -9.941524832237639e-17,  1.105310986542634e-17,
 -9.904341052415082e-19,  7.438872023043102e-20, -4.812460524470447e-21,  2.735921047696518e-22, -1.387942678159290e-23,  6.359509702458531e-25, -2.654105898040964e-26,
  2.047116784854162e-15, -8.661698681669229e-16,  1.960191013077921e-16, -3.015507083236931e-17,  3.511159819205395e-18, -3.288756591609621e-19,  2.577082686587085e-20,
 -1.736203991404721e-21,  1.026075034820131e-22, -5.402001296436520e-24,  2.564579743273301e-25, -1.107181307882356e-26,  5.275024787893489e-16, -2.289923548928565e-16,
  5.329177104945415e-17, -8.427587288522776e-18,  1.007796767284446e-18, -9.684355576134810e-20,  7.776997574962665e-21, -5.363723116499272e-22,  3.241758921911723e-23,
 -1.743675322730028e-24,  8.449477409040691e-26, -3.719845088302268e-27,  8.951384158594247e-02, -3.361867604743514e-04,  1.323696013507385e-06, -5.412547891209104e-09,
  2.271361787876471e-11, -9.700391162796439e-14,  4.175513713061706e-16, -1.808910468666689e-18,  7.811631846890870e-21, -3.391540650648383e-23,  1.451853845920077e-25,
 -6.323980116420985e-28,  7.806433788168281e-02, -3.759808048981441e-04,  2.242167659727392e-06, -1.383754446542197e-08,  8.374648736626968e-11, -4.934306612266525e-13,
  2.837218332828440e-15, -1.598477091721656e-17,  8.847472445886010e-20, -4.824406126084234e-22,  2.594429924611367e-24, -1.379140739853074e-26,  5.937415817305343e-02,
 -4.126257363123027e-04,  3.567083582834972e-06, -2.897012557546682e-08,  2.210589112955479e-10, -1.610155249818238e-12,  1.130748507082970e-14, -7.703879346657242e-17,
  5.114391031595567e-19, -3.319175153669299e-21,  2.111250948550775e-23, -1.318842418875425e-25,  3.938846815675709e-02, -4.009727166736736e-04,  4.569906159111742e-06,
 -4.601506123560089e-08,  4.273612428035530e-10, -3.741215743169450e-12,  3.123951333444834e-14, -2.507747140958396e-16,  1.946513384515995e-18, -1.467265936811082e-20,
  1.077770838289887e-22, -7.735026900715023e-25,  2.279538924794870e-02, -3.315465200499296e-04,  4.736671002582134e-06, -5.787436375388517e-08,  6.426097878256144e-10,
 -6.641018280788472e-12,  6.479787027050369e-14, -6.028125424763050e-16,  5.385059587309659e-18, -4.644114014832235e-20,  3.882623276881124e-22, -3.156922762915679e-24,
  1.151229243281488e-02, -2.313208765409441e-04,  4.044454426709004e-06, -5.920257667426415e-08,  7.755143824972370e-10, -9.340759798549671e-12,  1.052271936255250e-13,
 -1.121677268467005e-15,  1.140837109860956e-17, -1.114050408801773e-19,  1.049570814070291e-21, -9.575888767246874e-24,  5.075965630530060e-03, -1.364974213470876e-04,
  2.883637514676179e-06, -5.006350046267349e-08,  7.658696411898083e-10, -1.065094271837367e-11,  1.373296009258861e-13, -1.663560794267217e-15,  1.911291609703488e-17,
 -2.097504921510965e-19,  2.210768180243268e-21, -2.247463762529993e-23,  1.955374139755319e-03, -6.846928858349003e-05,  1.733200430660892e-06, -3.539288858460178e-08,
  6.274263981558791e-10, -1.000384343971583e-11,  1.466589928646488e-13, -2.006364204383092e-15,  2.588514556766107e-17, -3.174298506951142e-19,  3.722533253669800e-21,
 -4.194350609567960e-23,  6.588078940381620e-04, -2.935824234083540e-05,  8.845748792538050e-07, -2.110122507489717e-08,  4.308629330202054e-10, -7.833036675769121e-12,
  1.299028956758309e-13, -1.997346544431195e-15,  2.880409010921926e-17, -3.929721978554056e-19,  5.105774874512637e-21, -6.350097255910078e-23,  1.944370209223549e-04,
 -1.081869371730941e-05,  3.857223379278492e-07, -1.068793955577868e-08,  2.501587250704001e-10, -5.163057843770810e-12,  9.647107508054470e-14, -1.660826513700864e-15,
  2.667624612792383e-17, -4.035034241589159e-19,  5.789131667741560e-21, -7.921817411380745e-23,  5.037934640932170e-05, -3.444788706294249e-06,  1.445416201352793e-07,
 -4.630280668913179e-09,  1.237418013402051e-10, -2.889308945330417e-12,  6.063133280072525e-14, -1.165246185154632e-15,  2.078668935582842e-17, -3.476495438977872e-19,
  5.493311001124808e-21, -8.249537074717341e-23,  1.149567912646027e-05, -9.531126734692990e-07,  4.682633082347193e-08, -1.727262020419541e-09,  5.253439917156851e-11,
 -1.383807448819136e-12,  3.252933923026028e-14, -6.962278537974668e-16,  1.376273388279131e-17, -2.539540226528239e-19,  4.410277010821841e-21, -7.253698227877098e-23,
  2.320125330330156e-06, -2.306046846503825e-07,  1.320228318988670e-08, -5.587995642223452e-10,  1.928956397845577e-11, -5.718573111745478e-13,  1.502697336790184e-14,
 -3.574889403576892e-16,  7.816457262608715e-18, -1.588536360713110e-19,  3.026868471387031e-21, -5.443369580462863e-23,  4.166605559021931e-07, -4.915829891446542e-08,
  3.264737079660077e-09, -1.580650550435644e-10,  6.177857123899722e-12, -2.057142042859486e-13,  6.032056970725385e-15, -1.592471431201117e-16,  3.845539061562528e-18,
 -8.595173551635596e-20,  1.794441662402242e-21, -3.523597612736201e-23,  6.712728459315796e-08, -9.319017507824763e-09,  7.148450127338783e-10, -3.947419234664594e-11,
  1.742985952592966e-12, -6.507251836926840e-14,  2.125869019898411e-15, -6.219326543910470e-17,  1.656509453766366e-18, -4.066813152134097e-20,  9.291280128619439e-22,
 -1.989704787691593e-23,  9.810142992236414e-09, -1.589744873914624e-09,  1.402536943883705e-10, -8.808163624930186e-12,  4.384385352103606e-13, -1.832014260875831e-14,
  6.658097412491674e-16, -2.155597852070795e-17,  6.324614166131332e-19, -1.703462624229690e-20,  4.253925732618677e-22, -9.923181537430604e-24,  1.320024071274619e-09,
 -2.478019228725369e-10,  2.503533337670199e-11, -1.782758895186579e-12,  9.980776505443223e-14, -4.658920066727938e-15,  1.880540584377985e-16, -6.727801152819892e-18,
  2.171500305675953e-19, -6.408069882083770e-21,  1.746889397876833e-22, -4.433240419859325e-24,  1.668138640726647e-10, -3.600085704770571e-11,  4.145727919397573e-12,
 -3.336163051808753e-13,  2.095145983120222e-14, -1.090103505344546e-15,  4.877409086117621e-17, -1.924751933455151e-18,  6.822633787807535e-20, -2.202359988293248e-21,
  6.543730030518561e-23, -1.803841946381305e-24,  2.032102326425529e-11, -5.001341347168701e-12,  6.530032680849672e-13, -5.914465943905041e-14,  4.152745992679714e-15,
 -2.401446724830542e-16,  1.187946245625566e-17, -5.158704994404219e-19,  2.003682767507472e-20, -7.059811100645901e-22,  2.281463410871053e-23, -6.817093495151058e-25,
  2.467875856012719e-12, -6.865026498421673e-13,  1.009857096583360e-13, -1.024220931538588e-14,  8.005045589655634e-16, -5.124964996096943e-17,  2.792962648591138e-18,
 -1.330197552274731e-19,  5.643347064904875e-21, -2.163729968828082e-22,  7.582633912539731e-24, -2.448810901562413e-25,  3.116500352661747e-13, -9.698054064325486e-14,
  1.594643378175259e-14, -1.798967269060433e-15,  1.555837748738187e-16, -1.096803179600253e-17,  6.551888645561953e-19, -3.406137690716053e-20,  1.571261888880204e-21,
 -6.527184210563716e-23,  2.470066705588432e-24, -8.586321216256014e-26,  4.303862333459063e-14, -1.480092520996814e-14,  2.693200249136153e-15, -3.349625001929782e-16,
  3.179739630719318e-17, -2.449796143711046e-18,  1.592812707701213e-19, -8.978340092838108e-21,  4.474747185848064e-22, -2.001637433475921e-23,  8.131205608988613e-25,
 -3.024926344805087e-26,  6.868741847515345e-15, -2.573099513652316e-15,  5.115405589176387e-16, -6.932460485793518e-17,  7.145037799197051e-18, -5.954840028498215e-19,
  4.173423435649998e-20, -2.527271680624301e-21,  1.348893552646716e-22, -6.442507855594294e-24,  2.786561280932143e-25, -1.100704144918801e-26,  1.330625361584764e-15,
 -5.338869468646636e-16,  1.141175728141490e-16, -1.659916750797886e-17,  1.831209688056297e-18, -1.628795874012443e-19,  1.214783743763517e-20, -7.806662547346093e-22,
  4.410164152977010e-23, -2.223890237464894e-24,  1.013176551161783e-25, -4.205583740900686e-27,  3.160392515991891e-16, -1.332226137738092e-16,  3.002780830391684e-17,
 -4.601218032293359e-18,  5.337262247017765e-19, -4.981155454287749e-20,  3.889839753856082e-21, -2.612046669295363e-22,  1.538878731201638e-23, -8.077734010255553e-25,
  3.824031197957551e-26, -1.646473158581768e-27,  7.653443436193734e-17, -3.318337518616740e-17,  7.712115528139575e-18, -1.217964683601271e-18,  1.454583595304654e-19,
 -1.396015222101885e-20,  1.119708883682473e-21, -7.713526313226519e-23,  4.656716827274416e-24, -2.502047014704939e-25,  1.211177513198256e-26, -5.326827890228397e-28,
  8.818987085860915e-02, -3.258509605529391e-04,  1.260863641423784e-06, -5.064122870720252e-09,  2.086979070450425e-11, -8.756331517073042e-14,  3.702256254506743e-16,
 -1.577404970569217e-18,  6.688829303519834e-21, -2.862924376928792e-23,  1.199465829484963e-25, -5.191988738249610e-28,  7.659526889046724e-02, -3.586856134206134e-04,
  2.083842706728542e-06, -1.257299645857431e-08,  7.452414091386021e-11, -4.304037397837636e-13,  2.426806666934791e-15, -1.341256497823401e-17,  7.283743414246068e-20,
 -3.898425875348321e-22,  2.057650568825707e-24, -1.074249056242394e-26,  5.777860861184578e-02, -3.854218608031110e-04,  3.239646864953713e-06, -2.567676437021224e-08,
  1.914039883373565e-10, -1.362916129667633e-12,  9.362659700588223e-15, -6.243229939291005e-17,  4.058491946484206e-19, -2.580136840598246e-21,  1.608233399301976e-23,
 -9.847553752250651e-26,  3.785435557279916e-02, -3.665113814279821e-04,  4.056408625519693e-06, -3.973740625818695e-08,  3.595000626605731e-10, -3.069149026163014e-12,
  2.501601879601997e-14, -1.961679438299481e-16,  1.488345945756783e-18, -1.097192528539919e-20,  7.885532499952583e-23, -5.539485590488413e-25,  2.154082556410306e-02,
 -2.962659041415441e-04,  4.099744933139552e-06, -4.857608087838507e-08,  5.240681824667166e-10, -5.270386044935636e-12,  5.010018060438270e-14, -4.544952731805759e-16,
  3.962223466478342e-18, -3.336827589372226e-20,  2.725748424919539e-22, -2.166562033291884e-24,  1.064750094203947e-02, -2.016093815229415e-04,  3.402724976984967e-06,
 -4.816163281397483e-08,  6.116082160370515e-10, -7.154373289917145e-12,  7.838158128224413e-14, -8.134336160723807e-16,  8.061926299695117e-18, -7.677412331528277e-20,
  7.058425500329453e-22, -6.288099910908509e-24,  4.572583444174176e-03, -1.156381525556518e-04,  2.349908989816293e-06, -3.934933664872575e-08,  5.823665872220271e-10,
 -7.851288032168661e-12,  9.828864695656609e-14, -1.157458873284621e-15,  1.294112011812796e-17, -1.383278581914534e-19,  1.421169197648048e-21, -1.409251136282885e-23,
  1.706760673958494e-03, -5.614593558720918e-05,  1.362687241041561e-06, -2.678098024271503e-08,  4.584396614133751e-10, -7.074179600843531e-12,  1.005451379685330e-13,
 -1.335399306507111e-15,  1.674578231119503e-17, -1.997959843467591e-19,  2.281586782206212e-21, -2.505284027145677e-23,  5.540754632401480e-04, -2.318820040505066e-05,
  6.680541422011161e-07, -1.530860606840363e-08,  3.013364613904270e-10, -5.294106998041591e-12,  8.500691618612482e-14, -1.267435416256299e-15,  1.774671474012453e-17,
 -2.353376696890234e-19,  2.974890819210874e-21, -3.602791953733881e-23,  1.566081758056425e-04, -8.184995485858952e-06,  2.784428069733065e-07, -7.399923989304358e-09,
  1.667307593927629e-10, -3.321306684667667e-12,  6.001819683062426e-14, -1.000942854012102e-15,  1.559582157793317e-17, -2.291097684834183e-19,  3.195746392637532e-21,
 -4.255483131830599e-23,  3.860326874112364e-05, -2.480979582776044e-06,  9.917927725891775e-08, -3.043513358642110e-09,  7.820875760380525e-11, -1.760722015717454e-12,
  3.570105650431069e-14, -6.641211278165142e-16,  1.148415269670056e-17, -1.864184987212888e-19,  2.862180901072653e-21, -4.180621888746321e-23,  8.318888828524615e-06,
 -6.489786585653665e-07,  3.035041087967229e-08, -1.071532658579231e-09,  3.131157986760299e-11, -7.946386471984218e-13,  1.803706335100222e-14, -3.734487856190045e-16,
  7.152271644375268e-18, -1.280364925253395e-19,  2.159701424438331e-21, -3.453792289408453e-23,  1.572877521883717e-06, -1.473189948201752e-07,  8.026327073065193e-09,
 -3.250236255898601e-10,  1.077446427913157e-11, -3.076136104760249e-13,  7.802220229488125e-15, -1.794958097307627e-16,  3.801382568029937e-18, -7.493286211899197e-20,
  1.386580094596533e-21, -2.424253139758081e-23,  2.622665280466152e-07, -2.921535418938063e-08,  1.847127530097821e-09, -8.556595564608385e-11,  3.211415523837129e-12,
 -1.029762503151010e-13,  2.914352064507035e-15, -7.440129651928688e-17,  1.740238027866525e-18, -3.772844728283606e-20,  7.649906884010716e-22, -1.460582048372471e-23,
  3.884715902646440e-08, -5.104381460753827e-09,  3.731215190695056e-10, -1.972530651810683e-11,  8.367196895701642e-13, -3.009188817398576e-14,  9.491462791773981e-16,
 -2.686043657011899e-17,  6.931899700900465e-19, -1.651314505242087e-20,  3.665455350908503e-22, -7.635368854790101e-24,  5.163485278524172e-09, -7.943315753729973e-10,
  6.689145896696570e-11, -4.026473104810998e-12,  1.927241353585085e-13, -7.763956803630454e-15,  2.726359644601882e-16, -8.544640674524062e-18,  2.430875097478870e-19,
 -6.357567751310433e-21,  1.543615919211223e-22, -3.505161920085511e-24,  6.245595990503084e-10, -1.117011598002165e-10,  1.079710236723991e-11, -7.382828707745286e-13,
  3.980658031493091e-14, -1.793922710178164e-15,  7.005456786889389e-17, -2.429113466962893e-18,  7.611076959496584e-20, -2.183432799258885e-21,  5.793718584874577e-23,
 -1.432865627682876e-24,  7.007581770294809e-11, -1.446929727496883e-11,  1.599104199199661e-12, -1.238803625440214e-13,  7.509184191140265e-15, -3.779605353129991e-16,
  1.639129729480736e-17, -6.280373230416129e-19,  2.164746405245802e-20, -6.804204009018598e-22,  1.970978880340145e-23, -5.302992341613864e-25,  7.484435187538628e-12,
 -1.771060050508103e-12,  2.227831159246049e-13, -1.948936973479697e-14,  1.324711937957009e-15, -7.430727426693005e-17,  3.571846365455381e-18, -1.509573527096805e-19,
  5.714386205433670e-21, -1.964768461810877e-22,  6.203124959811340e-24, -1.812786449675241e-25,  7.875204721640698e-13, -2.118063086130389e-13,  3.015767085950431e-14,
 -2.966386845948274e-15,  2.252764606660670e-16, -1.403798768106751e-17,  7.457777520036177e-19, -3.467310511633581e-20,  1.437773938656616e-21, -5.394240683261394e-23,
  1.851718462095456e-24, -5.863659301361956e-26,  8.534371568751048e-14, -2.583557191249052e-14,  4.134069035608135e-15, -4.545112808706368e-16,  3.836559028412546e-17,
 -2.643440831967507e-18,  1.545350317302816e-19, -7.871364100838059e-21,  3.561460419548295e-22, -1.452523595644012e-23,  5.401521470543792e-25, -1.846715523699021e-26,
  1.006473455639371e-14, -3.389068637354553e-15,  6.037051415368487e-16, -7.357633732216973e-17,  6.851681919480299e-18, -5.183966979858423e-19,  3.313266421327147e-20,
 -1.837585176307303e-21,  9.018814849419732e-23, -3.975920266364137e-24,  1.592923660169253e-25, -5.848545117770998e-27,  1.375862134812640e-15, -5.079254847867369e-16,
  9.946460312860950e-17, -1.328530095711654e-17,  1.350524101757788e-18, -1.110968137051678e-19,  7.690641720559555e-21, -4.603058660202501e-22,  2.429758434281023e-23,
 -1.148362824565052e-24,  4.917703144156592e-26, -1.924235432268317e-27,  2.316545098945468e-16, -9.213447941077966e-17,  1.951230801583489e-17, -2.812871874046288e-18,
  3.076739453131261e-19, -2.714548926581309e-20,  2.009057300420747e-21, -1.281727257679043e-22,  7.190943354979187e-24, -3.602458441249893e-25,  1.631056419350808e-26,
 -6.730528089206059e-28,  4.922500502473388e-17, -2.066432610828281e-17,  4.636941819550692e-18, -7.074411613245541e-19,  8.171922411000276e-20, -7.596428309951793e-21,
  5.909753125502543e-22, -3.954194858293436e-23,  2.321656802540445e-24, -1.214708892240810e-25,  5.732728049919069e-27, -2.461043541220993e-28,  1.113792452152832e-17,
 -4.822659020791239e-18,  1.119183494223095e-18, -1.764940393725997e-19,  2.104845838871091e-20, -2.017344405920108e-21,  1.615942448286351e-22, -1.111800204891183e-23,
  6.703906662376159e-25, -3.597810641673491e-26,  1.739661308589633e-27, -7.642920358739399e-29,  8.690626380370693e-02, -3.160015827687879e-04,  1.202041398917891e-06,
 -4.743748169286338e-09,  1.920392207347506e-11, -7.918464171503804e-14,  3.289062917669920e-16, -1.378969877488385e-18,  5.739288670363186e-21, -2.426045794402178e-23,
  9.914103125974693e-26, -4.301243541335970e-28,  7.519294015225078e-02, -3.425987392994931e-04,  1.939846913284253e-06, -1.144643335620371e-08,  6.646938817526221e-11,
 -3.764160433022098e-13,  2.081884309346710e-15, -1.129131113873269e-17,  6.017745036724378e-20, -3.162572565011296e-22,  1.638610545289433e-24, -8.406398853308896e-27,
  5.628687494867179e-02, -3.606871038477438e-04,  2.949038935876962e-06, -2.282072723903884e-08,  1.662583434409210e-10, -1.157803586548187e-12,  7.783250494718042e-15,
 -5.081512751101613e-17,  3.235710680836942e-19, -2.015732955087531e-21,  1.231623248203225e-23, -7.394637242064176e-26,  3.645032469578518e-02, -3.358741859720217e-04,
  3.612146906322934e-06, -3.444562337361866e-08,  3.037023588358960e-10, -2.529639474376869e-12,  2.013479439284948e-14, -1.542965775496631e-16,  1.144715581508109e-18,
 -8.255779306234840e-21,  5.807489270663696e-23, -3.994584337216931e-25,  2.041785727431669e-02, -2.656646570326032e-04,  3.563864445075693e-06, -4.097300363037615e-08,
  4.297233053785563e-10, -4.207403819875782e-12,  3.898278833997367e-14, -3.449931447754911e-16,  2.936243390409764e-18, -2.415631936135285e-20,  1.928715187442242e-22,
 -1.499160012457354e-24,  9.892068043696328e-03, -1.765432296700697e-04,  2.879089005203566e-06, -3.942564180703433e-08,  4.856279551428829e-10, -5.519748703471827e-12,
  5.883760856530640e-14, -5.947231900857848e-16,  5.746005803359026e-18, -5.338274834820331e-20,  4.791112481865671e-22, -4.169087023701342e-24,  4.144847709068082e-03,
 -9.858039782132591e-05,  1.928829261153121e-06, -3.116974135495800e-08,  4.465286405733241e-10, -5.838708731241172e-12,  7.100050979396620e-14, -8.131558330735418e-16,
  8.850940530621617e-18, -9.218289243439922e-20,  9.234963966807715e-22, -8.935435824270810e-24,  1.502107438142847e-03, -4.641518902683427e-05,  1.081049141840405e-06,
 -2.045840645175395e-08,  3.383450924170245e-10, -5.055303512664321e-12,  6.968888214849951e-14, -8.989537562983373e-16,  1.096095752863593e-17, -1.272820700401919e-19,
  1.415862796697283e-21, -1.515552408377658e-23,  4.709540169976650e-04, -1.850399924551516e-05,  5.101137354134610e-07, -1.123443500225744e-08,  2.132826298470998e-10,
 -3.622705080774236e-12,  5.634298476480028e-14, -8.149077055064889e-16,  1.108258211649849e-17, -1.428957690289285e-19,  1.757959591273722e-21, -2.073711485889834e-23,
  1.278188406307640e-04, -6.271882029277626e-06,  2.036875355670205e-07, -5.193981161334467e-09,  1.127009120956705e-10, -2.167614215406595e-12,  3.789552041130960e-14,
 -6.124219730533581e-16,  9.259248334459517e-18, -1.321424217612129e-19,  1.792434928755363e-21, -2.323202565074178e-23,  3.006176154997434e-05, -1.814763670621052e-06,
  6.913824691228312e-08, -2.032982210396280e-09,  5.024726031172572e-11, -1.091006480991695e-12,  2.138055436350607e-14, -3.850675791902077e-16,  6.456106848402418e-18,
 -1.017383722718312e-19,  1.518068489341210e-21, -2.157045700778453e-23,  6.137748493655699e-06, -4.501631641404908e-07,  2.004095540692658e-08, -6.773083923131638e-10,
  1.901826445168220e-11, -4.650943803933481e-13,  1.019539379921947e-14, -2.042320612948792e-16,  3.790152679846740e-18, -6.583249808552892e-20,  1.078693794061667e-21,
 -1.677460710372797e-23,  1.090915915748756e-06, -9.618790998427989e-08,  4.986187225268220e-09, -1.931663124308096e-10,  6.149335363876306e-12, -1.690809968106494e-13,
  4.139538068003730e-15, -9.209762972303427e-17,  1.889248356260532e-18, -3.612216129263056e-20,  6.491266838314194e-22, -1.103376982538941e-23,  1.695102611421332e-07,
 -1.780693511673029e-08,  1.071283744258777e-09, -4.746850091453388e-11,  1.710468315028297e-12, -5.280924858546401e-14,  1.442344896724657e-15, -3.560371602319297e-17,
  8.065357112780213e-19, -1.695917154681160e-20,  3.339346996003224e-22, -6.198686025015461e-24,  2.317022430175102e-08, -2.877442865403396e-09,  2.002877774777780e-10,
 -1.013157836635378e-11,  4.127030738599154e-13, -1.429323811224140e-14,  4.351453435311602e-16, -1.190894715374196e-17,  2.977105068600949e-19, -6.879965059233039e-21,
  1.483410014834787e-22, -3.005062803415473e-24,  2.811341364056614e-09, -4.098889904020570e-10,  3.291334169615508e-11, -1.897475740423241e-12,  8.727789868105267e-14,
 -3.388010733659466e-15,  1.148986760564647e-16, -3.484394653764521e-18,  9.607702141527834e-20, -2.438975406731031e-21,  5.755500536330034e-23, -1.271747738680940e-24,
  3.067180823399666e-10, -5.216529864452908e-11,  4.818041159268245e-12, -3.160220702817066e-13,  1.639586728499093e-14, -7.128225981655136e-16,  2.691235988467906e-17,
 -9.038780188533627e-19,  2.747662091247754e-20, -7.658451426539658e-22,  1.976999808456776e-23, -4.762383780055424e-25,  3.064001047307998e-11, -6.040684957659227e-12,
  6.397184993242971e-13, -4.764766718247325e-14,  2.784694269668313e-15, -1.354583841283785e-16,  5.688936192499871e-18, -2.114619078710762e-19,  7.082128744241601e-21,
 -2.165972916026675e-22,  6.112599049544701e-24, -1.604148901199835e-25,  2.874237516104724e-12, -6.525212383471714e-13,  7.894217958159492e-14, -6.660323633966280e-15,
  4.376775883717219e-16, -2.378615629448322e-17,  1.109825223787159e-18, -4.560365931605917e-20,  1.680879286031753e-21, -5.634745301052721e-23,  1.736563996134715e-24,
 -4.959448844125370e-26,  2.620811928218371e-13, -6.800154122998175e-14,  9.354289745379019e-15, -8.908987600598364e-16,  6.564466495057030e-17, -3.976245727357088e-18,
  2.056730091643714e-19, -9.323960224969411e-21,  3.774986064445348e-22, -1.384509711899620e-23,  4.651145145183216e-25, -1.442863494025573e-26,  2.432538103701672e-14,
 -7.148606625258209e-15,  1.111092671406150e-15, -1.188493781201864e-16,  9.776652339405428e-18, -6.574706762485901e-19,  3.756598585598538e-20, -1.872518678541293e-21,
  8.300630013169038e-23, -3.320234626687752e-24,  1.212112793753527e-25, -4.071997268725527e-27,  2.438557415309771e-15, -8.025106658890250e-16,  1.397048043073838e-16,
 -1.665812664087893e-17,  1.519572065856928e-18, -1.127546323100806e-19,  7.075412955865201e-21, -3.856592736663679e-22,  1.861955239643926e-23, -8.081498079058729e-25,
  3.190261749320630e-26, -1.155009975130134e-27,  2.834610119534797e-16, -1.029745558987300e-16,  1.983493261102444e-17, -2.607712116632656e-18,  2.611423725854241e-19,
 -2.117979800711067e-20,  1.446663524259741e-21, -8.549743043128178e-23,  4.459288376525704e-24, -2.083773980467032e-25,  8.827881268308929e-27, -3.419170795774314e-28,
  4.110125574016620e-17, -1.618855732909153e-17,  3.393591999589340e-18, -4.844112061405732e-19,  5.248995589641585e-20, -4.590068725262826e-21,  3.368661113225319e-22,
 -2.132063484112340e-23,  1.187171788894362e-24, -5.905020769441732e-26,  2.655500024928651e-27, -1.088773793696585e-28,  7.742362644924777e-18, -3.235227814504229e-18,
  7.223863371406686e-19, -1.096823722714214e-19,  1.261160329297958e-20, -1.167220260100764e-21,  9.042869947924002e-23, -6.026714895917433e-24,  3.525276880279284e-25,
 -1.837899839850465e-26,  8.644544412403518e-28, -3.699191555387704e-29,  1.626241398448193e-18, -7.031222103193584e-19,  1.629102971189760e-19, -2.565003470838877e-20,
  3.054291349922432e-21, -2.922991467321219e-22,  2.338063323329762e-23, -1.606441692921087e-24,  9.673819297782137e-26, -5.185169062793011e-27,  2.504180187061215e-28,
 -1.098900487256415e-29,  8.566113682920605e-02, -3.066078456606221e-04,  1.146909089849181e-06, -4.448738829472151e-09,  1.769614317360916e-11, -7.173425185177829e-14,
  2.927402877646425e-16, -1.208556992799419e-18,  4.932931945452677e-21, -2.065171610768707e-23,  8.179628568635351e-26, -3.614119533012167e-28,  7.385273760822315e-02,
 -3.276118681536223e-04,  1.808630848994737e-06, -1.044053864398927e-08,  5.941619239567125e-11, -3.300371837449464e-13,  1.791061679646484e-15, -9.535835927112507e-18,
  4.988803844301688e-20, -2.575472337940174e-22,  1.309966956687638e-24, -6.608985452327338e-27,  5.488963838418300e-02, -3.381466612396558e-04,  2.690418463123556e-06,
 -2.033615649549394e-08,  1.448607773745509e-10, -9.869732275303395e-13,  6.495120376739286e-15, -4.153284735883622e-17,  2.591411498567778e-19, -1.582426455109530e-21,
  9.480835201965837e-24, -5.583060483818348e-26,  3.516211619366300e-02, -3.085514750737622e-04,  3.226366497945138e-06, -2.996626997512602e-08,  2.576122582084876e-10,
 -2.094368169690269e-12,  1.628565047541766e-14, -1.220049010351521e-16,  8.854089635854150e-19, -6.249349347428242e-21,  4.304245543505267e-23, -2.899748475956832e-25,
  1.940926350816972e-02, -2.390096414629755e-04,  3.110821080032616e-06, -3.472288490613068e-08,  3.542003005123673e-10, -3.377870468133492e-12,  3.051759630394628e-14,
 -2.635784427948960e-16,  2.190941191828442e-18, -1.761451838939118e-20,  1.375139065707341e-22, -1.045598445300603e-24,  9.229140215241063e-03, -1.552787758431945e-04,
  2.449192465921204e-06, -3.246733953803125e-08,  3.881054754963421e-10, -4.288347382413087e-12,  4.449509206062040e-14, -4.382317901414571e-16,  4.129145807383051e-18,
 -3.743820263245407e-20,  3.281308523425461e-22, -2.789914528038326e-24,  3.779178965332341e-03, -8.453276507142591e-05,  1.594085626175071e-06, -2.487409418485251e-08,
  3.451036156237106e-10, -4.378741148390946e-12,  5.174517373044499e-14, -5.765972959691535e-16,  6.112335844378098e-18, -6.205131917821426e-20,  6.063679212108922e-22,
 -5.726619418228536e-24,  1.332309118255283e-03, -3.866390296314041e-05,  8.649654807516573e-07, -1.577075482259445e-08,  2.521137243639583e-10, -3.649057116866882e-12,
  4.881081273659181e-14, -6.117700702419029e-16,  7.255704114670995e-18, -8.203308181613093e-20,  8.891830998547110e-22, -9.281264291329011e-24,  4.043212209345730e-04,
 -1.490939432633228e-05,  3.936030696496855e-07, -8.335167855606021e-09,  1.526912093132664e-10, -2.508516675737162e-12,  3.780453487682940e-14, -5.306052975702094e-16,
  7.011252528951642e-18, -8.792657291922238e-20,  1.053057102317320e-21, -1.210282379666355e-23,  1.056348755925738e-04, -4.864038595911600e-06,  1.508939004973292e-07,
 -3.693448771153493e-09,  7.721061822011035e-11, -1.434360279834266e-12,  2.426886463093980e-14, -3.801816503868416e-16,  5.579229484044988e-18, -7.737394884453500e-20,
  1.020898726949492e-21, -1.288248807886474e-23,  2.377172859087714e-05, -1.347067413335152e-06,  4.892735233857838e-08, -1.378992237380338e-09,  3.279281135643710e-11,
 -6.869176088497025e-13,  1.301429548254390e-14, -2.269888991258681e-16,  3.690847668928379e-18, -5.647571845581133e-20,  8.191374104947301e-22, -1.132482288571962e-23,
  4.612744773171301e-06, -3.178026644681086e-07,  1.347033642379378e-08, -4.358595666656018e-10,  1.176259023961696e-11, -2.772460568189864e-13,  5.870537002961215e-15,
 -1.137966852475049e-16,  2.046695404160562e-18, -3.449811529680172e-20,  5.491734715049103e-22, -8.305533501867018e-24,  7.733245450388006e-07, -6.412361118390413e-08,
  3.162289494590583e-09, -1.171996094530424e-10,  3.583118659919417e-12, -9.488877568308657e-14,  2.242582008837125e-15, -4.825428412299905e-17,  9.588645476274043e-19,
 -1.778359093718237e-20,  3.103685074747361e-22, -5.129183381069108e-24,  1.123800126775600e-07, -1.111944860145378e-08,  6.362911179397834e-10, -2.696256144304114e-11,
  9.326731191380762e-13, -2.772303789788093e-14,  7.306752914177927e-16, -1.743861997439687e-17,  3.825737066774831e-19, -7.801728146744619e-21,  1.491728271289396e-22,
 -2.691943098602506e-24,  1.422893221137618e-08, -1.667733623711991e-09,  1.104640257878630e-10, -5.344397357948723e-12,  2.089869830692530e-13, -6.968156586914251e-15,
  2.047101412562525e-16, -5.416820470397408e-18,  1.311472672875976e-19, -2.939553868729003e-21,  6.155317176565840e-23, -1.212412841102237e-24,  1.581967730843847e-09,
 -2.182403450294812e-10,  1.669397735363547e-11, -9.211063291364667e-13,  4.069215815143938e-14, -1.521377338831797e-15,  4.980726765338178e-17, -1.460957165851230e-18,
  3.902964116230834e-20, -9.613712926766334e-22,  2.204189550227359e-23, -4.737772808220897e-25,  1.562379862447904e-10, -2.522229185629516e-11,  2.223168516063197e-12,
 -1.397432260054809e-13,  6.970798003336528e-15, -2.921610720480090e-16,  1.065750446430022e-17, -3.465034731545425e-19,  1.021362852334317e-20, -2.764509262215121e-22,
  6.939340467244679e-24, -1.627420251543486e-25,  1.393983711753943e-11, -2.618687944864159e-12,  2.653408204932171e-13, -1.897796845331364e-14,  1.068250850671097e-15,
 -5.017304381892425e-17,  2.038852732307419e-18, -7.346431147177475e-20,  2.388916922689484e-21, -7.104114992945526e-23,  1.951941093789504e-24, -4.993360608955730e-26,
  1.151104921863887e-12, -2.501658370978133e-13,  2.905711881379990e-14, -2.360867997486027e-15,  1.497985300304343e-16, -7.878374704193000e-18,  3.564335815832746e-19,
 -1.422605785678121e-20,  5.100915521654881e-22, -1.665751781738016e-23,  5.007168285807556e-25, -1.396388034315374e-26,  9.103066574903342e-14, -2.273460179393815e-14,
  3.015694733339075e-15, -2.776357700177562e-16,  1.981942329863440e-17, -1.165389469639824e-18,  5.861975547377277e-20, -2.588303671080842e-21,  1.022087696338849e-22,
 -3.660820506850606e-24,  1.202414647241767e-25, -3.650942238162921e-27,  7.226873265350971e-15, -2.057122775653401e-15,  3.099643013703485e-16, -3.220212693584910e-17,
  2.577469537524587e-18, -1.689339690198133e-19,  9.421585449427944e-21, -4.590208560006937e-22,  1.991260954733725e-23, -7.803390887996401e-25,  2.793835634235044e-26,
 -9.213656997609162e-28,  6.133234114729644e-16, -1.968675995629930e-16,  3.343115671667059e-17, -3.893513825681262e-18,  3.473839805636638e-19, -2.524417833568464e-20,
  1.553238521510700e-21, -8.310499947129364e-23,  3.942459397344973e-24, -1.682931646874423e-25,  6.539551082106366e-27, -2.332432788175544e-28,  6.019267312770616e-17,
 -2.148282832119065e-17,  4.064008289748248e-18, -5.251582563518963e-19,  5.173963567092375e-20, -4.132234171988813e-21,  2.781798585397943e-22, -1.621650779697207e-23,
  8.349123463855251e-25, -3.853875218908174e-26,  1.613815174502151e-27, -6.182117777944226e-29,  7.445027037671443e-18, -2.900829013190389e-18,  6.012723438824207e-19,
 -8.489852754781230e-20,  9.104903105234141e-21, -7.884521321038527e-22,  5.733300122213626e-23, -3.597154250417499e-24,  1.986506015084410e-25, -9.804080047217582e-27,
  4.376423547804125e-28, -1.781853354998033e-29,  1.230979523956423e-18, -5.117367288422061e-19,  1.136387311247671e-19, -1.716227402827962e-20,  1.963336747356650e-21,
 -1.808322508684108e-22,  1.394561623383716e-23, -9.253904444299050e-25,  5.390748475149249e-26, -2.799506861760152e-27,  1.311874032791925e-28, -5.594123752719534e-30,
  2.383048749307616e-19, -1.028678228565922e-19,  2.379214292041475e-20, -3.739549502050607e-21,  4.445423123144799e-22, -4.247468363164268e-23,  3.392249972234322e-24,
 -2.327307335127565e-25,  1.399493667369368e-26, -7.491102295767928e-28,  3.613120879942418e-29, -1.583557517723619e-30,  8.445272454246963e-02, -2.976414056665150e-04,
  1.095176914885723e-06, -4.176707478783154e-09,  1.632906414969040e-11, -6.509738774703316e-14,  2.610032052002900e-16, -1.061997206504925e-18,  4.244680138088293e-21,
 -1.768179235225197e-23,  6.706616174919857e-26, -3.111296834332327e-28,  7.257045692125894e-02, -3.136282929327799e-04,  1.688837840174332e-06, -9.540437612542947e-09,
  5.322457347417866e-11, -2.900835682372624e-13,  1.545083206526920e-15, -8.078195224452239e-18,  4.149343709188508e-20, -2.105299182510110e-22,  1.050994724157600e-24,
 -5.221317740105654e-27,  5.357860660238615e-02, -3.175614939844550e-04,  2.459666211673978e-06, -1.816820932028784e-08,  1.265905738383896e-10, -8.441584559711851e-13,
  5.440227075591777e-15, -3.408316092983762e-17,  2.084472075636025e-19, -1.248073549616234e-21,  7.334667742507878e-24, -4.237506667062032e-26,  3.397734961384780e-02,
 -2.841119045237629e-04,  2.890185502114338e-06, -2.615944269850543e-08,  2.193724495617648e-10, -1.741501153879867e-12,  1.323458706283494e-14, -9.696257875988955e-17,
  6.885783790372119e-19, -4.757923302489196e-21,  3.209678267536131e-23, -2.118509052495443e-25,  1.850048869516232e-02, -2.156983165383611e-04,  2.726042673086293e-06,
 -2.955871830819591e-08,  2.934079076557193e-10, -2.726638157661312e-12,  2.403068984213903e-14, -2.026365107558926e-16,  1.645667280093134e-18, -1.293410441555644e-20,
  9.876479167087649e-23, -7.348480351983112e-25,  8.644885563006133e-03, -1.371442647243119e-04,  2.094189369383976e-06, -2.688968435650229e-08,  3.120956327718852e-10,
 -3.353940445606469e-12,  3.388860343587357e-14, -3.253522900582188e-16,  2.990772016097712e-18, -2.647377609127923e-20,  2.266714075161914e-22, -1.883749277609310e-24,
  3.464787109514660e-03, -7.288641142523701e-05,  1.326040949757617e-06, -1.999067565648987e-08,  2.687459525572668e-10, -3.310399610603566e-12,  3.803367754561621e-14,
 -4.125147884912428e-16,  4.260503279095763e-18, -4.217407269450545e-20,  4.021437399524247e-22, -3.708234278608470e-24,  1.190384363489050e-03, -3.243776056924156e-05,
  6.977022908499111e-07, -1.226251977981266e-08,  1.895845317863354e-10, -2.659417468242100e-12,  3.453251825301253e-14, -4.207001920342450e-16,  4.855201126329370e-18,
 -5.346387355693626e-20,  5.648788369290736e-22, -5.751402430187083e-24,  3.504018012774572e-04, -1.212264183054653e-05,  3.067306963891777e-07, -6.248804094124463e-09,
  1.105101474101551e-10, -1.756796515453424e-12,  2.566520942688603e-14, -3.496997022627066e-16,  4.491210986003573e-18, -5.479953803136816e-20,  6.391237162532137e-22,
 -7.158810443860478e-24,  8.833933464721289e-05, -3.815162867970808e-06,  1.131314862228322e-07, -2.659216689216100e-09,  5.357997534844207e-11, -9.617912643430755e-13,
  1.575488753482851e-14, -2.393217822685703e-16,  3.410040206910299e-18, -4.596854085067866e-20,  5.901378955507136e-22, -7.251937600634310e-24,  1.907283589917915e-05,
 -1.013864265478329e-06,  3.512378736162184e-08, -9.491862701187356e-10,  2.172483388096293e-11, -4.391711910973221e-13,  8.046465158691845e-15, -1.359491401121420e-16,
  2.144362220051976e-18, -3.186833383109571e-20,  4.494060475649195e-22, -6.046566440813398e-24,  3.527952085697028e-06, -2.281383711205454e-07,  9.208376172603381e-09,
 -2.853258431573704e-10,  7.402386132253400e-12, -1.681999701243990e-13,  3.440980624624382e-15, -6.455852989671381e-17,  1.125508859514274e-18, -1.841295981898788e-20,
  2.848140990441982e-22, -4.189710438455973e-24,  5.597267478121103e-07, -4.360355129510979e-08,  2.045599636110859e-09, -7.253140270016039e-11,  2.129811216485735e-12,
 -5.432867576957021e-14,  1.239613746246137e-15, -2.579939495813315e-17,  4.966521063179699e-19, -8.935687330456015e-21,  1.514675847041625e-22, -2.433841493844350e-24,
  7.634321189362665e-08, -7.106317814763914e-09,  3.866659524805414e-10, -1.566676439712075e-11,  5.202052761967885e-13, -1.488625712927561e-14,  3.786020144474476e-16,
 -8.736216847626052e-18,  1.856060246944522e-19, -3.670723263259935e-21,  6.815210858528768e-23, -1.195575622110620e-24,  8.987443929918783e-09, -9.927905850260240e-10,
  6.253692529197337e-11, -2.892708691097772e-12,  1.085593496151828e-13, -3.483999418876853e-15,  9.875001513668116e-17, -2.526013828645400e-18,  5.922103635910198e-20,
 -1.287246410133046e-21,  2.617331551912314e-23, -5.011871762022061e-25,  9.191410032802884e-10, -1.197838874843226e-10,  8.720748589504998e-12, -4.602296225311123e-13,
  1.951787849323955e-14, -7.025266012025583e-16,  2.219440272219718e-17, -6.294682448286908e-19,  1.628763953360532e-20, -3.891634942337757e-22,  8.666524752758600e-24,
 -1.811562404362519e-25,  8.248688582203423e-11, -1.261639280532887e-11,  1.060000015361070e-12, -6.379448186894550e-14,  3.057358785013330e-15, -1.234523168842332e-16,
  4.348551075926406e-18, -1.367919288506590e-19,  3.907839298286433e-21, -1.026670559484140e-22,  2.504785369821379e-24, -5.716459087521584e-26,  6.596043985546034e-12,
 -1.178261519200451e-12,  1.140615831989033e-13, -7.824653403481925e-15,  4.237803648044609e-16, -1.920096932400803e-17,  7.543656446736331e-19, -2.632948895357046e-20,
  8.307333565189408e-22, -2.400538587586100e-23,  6.417727024415630e-25, -1.599403020912725e-26,  4.807836259160652e-13, -9.979944535327800e-14,  1.110991049805000e-14,
 -8.680319994480112e-16,  5.311335435309136e-17, -2.700259932727356e-18,  1.183359009063765e-19, -4.583261117399580e-21,  1.597288565871348e-22, -5.077042482624143e-24,
  1.487365625732592e-25, -4.047421948101037e-27,  3.302149133038251e-14, -7.919338348735491e-15,  1.011016646393904e-15, -8.982466332251015e-17,  6.203223763418448e-18,
 -3.536127584720395e-19,  1.727597631247672e-20, -7.421203014040373e-22,  2.855290184125770e-23, -9.977523130885425e-25,  3.201155660507609e-26, -9.505167847615973e-28,
  2.240885207031292e-15, -6.163922645389506e-16,  8.985696497506873e-17, -9.050542928841127e-18,  7.037235429635766e-19, -4.488778560944475e-20,  2.440284218441183e-21,
 -1.160607261569016e-22,  4.921388853793614e-24, -1.887415682722563e-25,  6.620381990524386e-27, -2.141215365724115e-28,  1.604381550826283e-16, -5.012085190596200e-17,
  8.286321512277598e-18, -9.409365699402134e-19,  8.197917522237046e-20, -5.825776036805358e-21,  3.509943301751378e-22, -1.841105153103738e-23,  8.572014641696224e-25,
 -3.594852613443727e-26,  1.373602235098961e-27, -4.821719192815464e-29,  1.320324870552997e-17, -4.621337012542827e-18,  8.571607165563600e-19, -1.087007545013667e-19,
  1.052116047854088e-20, -8.263670201725558e-22,  5.476233680122798e-23, -3.145361485011598e-24,  1.596869630115206e-25, -7.273981900144148e-27,  3.008014411641722e-28,
 -1.138698778117045e-29,  1.379472813521873e-18, -5.310598420162973e-19,  1.087095798422095e-19, -1.516641006100855e-20,  1.608119979328748e-21, -1.377704797688245e-22,
  9.917171413784271e-24, -6.163003364850369e-25,  3.372905423927106e-26, -1.650503265400339e-27,  7.308415435689069e-29, -2.952997847432021e-30,  1.980711114251772e-19,
 -8.186838355077409e-20,  1.806919654051964e-20, -2.712753268522923e-21,  3.085856039210621e-22, -2.827033829198751e-23,  2.169164915561520e-24, -1.432513432630538e-25,
  8.307176390338928e-27, -4.295573474301376e-28,  2.004770427310749e-29, -8.515947401545257e-31,  3.505903297802927e-20, -1.510691211701197e-20,  3.487306030984955e-21,
 -5.470776795200565e-22,  6.491500640555886e-23, -6.191520337434853e-24,  4.936546258715229e-25, -3.381343874505570e-26,  2.030192973654109e-27, -1.085105127791213e-28,
  5.226315096207648e-30, -2.287501167277555e-31,  8.327937046330436e-02, -2.890761275868706e-04,  1.046582126524319e-06, -3.925527527675424e-09,  1.508742544834037e-11,
 -5.917536342705457e-14,  2.330767458042619e-16, -9.358605137796907e-19,  3.653223884129755e-21, -1.526224947689429e-23,  5.414003433328658e-26, -2.797447529199509e-28,
  7.134225995465708e-02, -3.005614823410286e-04,  1.579277015331811e-06, -8.733317311317616e-09,  4.777614746575150e-11, -2.555725283362308e-13,  1.336398757549196e-15,
 -6.863985644414755e-18,  3.461880597994989e-20, -1.727488536268403e-22,  8.458670831772674e-25, -4.148105086219917e-27,  5.234638147717098e-02, -2.987230442912208e-04,
  2.253265374809021e-06, -1.627104285916823e-08,  1.109394849889219e-10, -7.243307813008972e-13,  4.572911880998005e-15, -2.807856995369231e-17,  1.683774354459254e-19,
 -9.888064138229139e-22,  5.701780032775809e-24, -3.232550002193221e-26,  3.288523773105411e-02, -2.621889438161156e-04,  2.596236038416241e-06, -2.291174601954306e-08,
  1.875110436630291e-10, -1.454110430987716e-12,  1.080403451968337e-14, -7.743798366512593e-17,  5.383215033596432e-19, -3.642617162117905e-21,  2.407652661921775e-23,
 -1.557310624547968e-25,  1.767917309891439e-02, -1.952329367445264e-04,  2.397802112209219e-06, -2.527094516460280e-08,  2.442119534271709e-10, -2.212441202989159e-12,
  1.902921782567674e-14, -1.567217396737217e-16,  1.243996105353480e-18, -9.561258959768361e-21,  7.143684430324182e-23, -5.202655898857224e-25,  8.127885385240561e-03,
 -1.216013901160807e-04,  1.799395864503350e-06, -2.239150744460570e-08,  2.524645598814700e-10, -2.639939550709218e-12,  2.598692567079681e-14, -2.432966783682580e-16,
  2.182750972334237e-18, -1.886986848039642e-20,  1.578880108509624e-22, -1.282913446211918e-24,  3.193035775458041e-03, -6.316926537631992e-05,  1.109918143607730e-06,
 -1.617447534302088e-08,  2.108045067802673e-10, -2.522089636900493e-12,  2.818413729656478e-14, -2.976595537623416e-16,  2.996359632197048e-18, -2.893178100718837e-20,
  2.692839476561847e-22, -2.425271364183993e-24,  1.070932423075969e-03, -2.739694463011416e-05,  5.671325886915879e-07, -9.613354204696805e-09,  1.438135567710695e-10,
 -1.956069827597985e-12,  2.466713917151790e-14, -2.922190192526838e-16,  3.282831101137887e-18, -3.522068692791183e-20,  3.628520901517188e-22, -3.604845182832989e-24,
  3.063831863322882e-04, -9.941148408563173e-06,  2.412945048591690e-07, -4.731320431958350e-09,  8.081754149280888e-11, -1.243750951695917e-12,  1.762101060279246e-14,
 -2.331678810579677e-16,  2.911621390502510e-18, -3.457650976436781e-20,  3.928264610605320e-22, -4.289482680935540e-24,  7.470548910971934e-05, -3.024518547052565e-06,
  8.579059907101211e-08, -1.937353909997612e-09,  3.764032640442944e-11, -6.531358096536835e-13,  1.036198645724880e-14, -1.526810324930519e-16,  2.112983045078383e-18,
 -2.769541274837702e-20,  3.460404547018137e-22, -4.142134401490056e-24,  1.551476217610286e-05, -7.731310259122870e-07,  2.556004362063590e-08, -6.625309129333223e-10,
  1.460021798866417e-11, -2.849287209815523e-13,  5.050108113916346e-15, -8.267746923184419e-17,  1.265398970308943e-18, -1.826938757237156e-20,  2.505473407987165e-22,
 -3.281323003680163e-24,  2.743586625714836e-06, -1.663828441334595e-07,  6.397099127754624e-09, -1.898611348788548e-10,  4.736497732854985e-12, -1.037802291119934e-13,
  2.051727431017662e-15, -3.726559800725880e-17,  6.298903246033062e-19, -1.000356253097896e-20,  1.503805912498899e-22, -2.152025737562207e-24,  4.132506074524196e-07,
 -3.021413069514080e-08,  1.348463018179822e-09, -4.574728879207698e-11,  1.290389171230214e-12, -3.171073934159172e-14,  6.986330488053717e-16, -1.406583870981808e-17,
  2.623509271097552e-19, -4.579512567044617e-21,  7.540264571194312e-23, -1.178141794673254e-24,  5.308743813476815e-08, -4.643287431702064e-09,  2.401775175502123e-10,
 -9.304075450939871e-12,  2.965424559074574e-13, -8.169587389207018e-15,  2.005020552873416e-16, -4.473218357464348e-18,  9.203666172217664e-20, -1.765257582736448e-21,
  3.182474972544604e-23, -5.427264353610689e-25,  5.832656298911280e-09, -6.063815771806702e-10,  3.630629871911428e-11, -1.605109007897926e-12,  5.779862505865209e-14,
 -1.785133194378399e-15,  4.881000524862525e-17, -1.206835817841695e-18,  2.739453390351166e-20, -5.773827923478425e-22,  1.139827791617816e-23, -2.121633639044369e-25,
  5.508520870713981e-10, -6.770582651076079e-11,  4.687648498235657e-12, -2.364842771429008e-13,  9.623432257656365e-15, -3.333561394442286e-16,  1.015962167796617e-17,
 -2.785280571167252e-19,  6.978525064833651e-21, -1.616973880179099e-22,  3.496730833874245e-24, -7.106345706289407e-26,  4.509915854143109e-11, -6.523299173892768e-12,
  5.218328188810334e-13, -3.004443325765845e-14,  1.382432784464649e-15, -5.374731004565153e-17,  1.827209819256025e-18, -5.558545187885035e-20,  1.538322995711174e-21,
 -3.921160727268969e-23,  9.294307197770382e-25, -2.063372891326333e-26,  3.244320824612201e-12, -5.499342493495988e-13,  5.078841698284346e-14, -3.337965642265694e-15,
  1.737798266069418e-16, -7.589399096382549e-18,  2.880617729416299e-19, -9.732362745961027e-21,  2.977515140930621e-22, -8.355576809902853e-24,  2.172273377970436e-25,
 -5.271097908656021e-27,  2.093996169352127e-13, -4.142158315554795e-14,  4.411863489212812e-15, -3.310100652124963e-16,  1.950805607466327e-17, -9.576793101868296e-19,
  4.061390978039690e-20, -1.525081131609438e-21,  5.161562153121867e-23, -1.595619736713259e-24,  4.552340131926103e-26, -1.207898398600606e-27,  1.251624414453422e-14,
 -2.875422217338452e-15,  3.526083526885526e-16, -3.018270209524718e-17,  2.013504087931176e-18, -1.111281325013169e-19,  5.266967832143894e-21, -2.198733753711204e-22,
  8.233865924414706e-24, -2.804386425115517e-25,  8.780771299676103e-27, -2.547478464116960e-28,  7.260898890546457e-16, -1.925232534534230e-16,  2.709640060717951e-17,
 -2.641126352185523e-18,  1.991703533189668e-19, -1.234551659359855e-20,  6.533349422046124e-22, -3.029496552456402e-23,  1.254209151403193e-24, -4.702155005059597e-26,
  1.614212279139939e-27, -5.115156924598899e-29,  4.373299156953447e-17, -1.326585010680409e-17,  2.130803487589153e-18, -2.354740619674924e-19,  2.000003509758678e-20,
 -1.387753194718777e-21,  8.175482385879988e-23, -4.198672744940739e-24,  1.916242039206180e-25, -7.885905637432017e-27,  2.959813661562672e-28, -1.021520295888283e-29,
  2.998462365097195e-18, -1.027245630999662e-18,  1.864683487977148e-19, -2.316771173913019e-20,  2.199615267898329e-21, -1.696649542680463e-22,  1.105362167379625e-23,
 -6.247791706251555e-25,  3.124306663884665e-26, -1.402967971500675e-27,  5.723761317164531e-29, -2.139229197582935e-30,  2.620051548374188e-19, -9.952198512982009e-20,
  2.009255053874225e-20, -2.766260756981223e-21,  2.896594090471000e-22, -2.452447274373702e-23,  1.745841340589815e-24, -1.073647697807970e-25,  5.818147872377835e-27,
 -2.820641069958106e-28,  1.238019682048052e-29, -4.960834654674009e-31,  3.229627886701120e-20, -1.326302262444276e-20,  2.907349564628072e-21, -4.336089301127886e-22,
  4.901575633873845e-23, -4.463871576340380e-24,  3.405945600745198e-25, -2.237402891428075e-26,  1.291000753553459e-27, -6.644164987703417e-29,  3.087028009622147e-30,
 -1.305789504940512e-31,  5.180350805321971e-21, -2.227828729429638e-21,  5.131799144603726e-22, -8.033752648129893e-23,  9.513457493925213e-24, -9.056330004557116e-25,
  7.207383501442417e-26, -4.928102449637355e-27,  2.953917428486517e-28, -1.576290394497963e-29,  7.580436431150348e-31, -3.313026426429868e-32,  8.213951860430770e-02,
 -2.808878801314982e-04,  1.000886094026186e-06, -3.693301524661431e-09,  1.395780023675489e-11, -5.388325393358987e-14,  2.084295383444252e-16, -8.273542244370813e-19,
  3.139840199072023e-21, -1.333847399584606e-23,  4.210943693080416e-26, -2.715791345716411e-28,  7.016463657317298e-02, -2.883338478010007e-04,  1.478900511551842e-06,
 -8.008111056768797e-09,  4.297048847575600e-11, -2.256855971251406e-13,  1.158826034929728e-15, -5.849498245675300e-18,  2.896727817320078e-20, -1.423048549600771e-22,
  6.823595190153544e-25, -3.319878645542329e-27,  5.118634614318437e-02, -2.814488193351841e-04,  2.068203603822444e-06, -1.460619770759295e-08,  9.748969859666930e-11,
 -6.234378269476225e-13,  3.857092024683283e-15, -2.321866337025979e-17,  1.365648460545502e-19, -7.868038155907538e-22,  4.453239453018392e-24, -2.477888526101394e-26,
  3.187634964091150e-02, -2.424699385529135e-04,  2.338380136459685e-06, -2.013084220648326e-08,  1.608557431317692e-10, -1.219001034265030e-12,  8.858476624500610e-15,
 -6.213658394373803e-17,  4.229902073612581e-19, -2.803702598951204e-21,  1.816422512146695e-23, -1.151539167453542e-25,  1.693477513198052e-02, -1.772003083507050e-04,
  2.116611395644565e-06, -2.169414535168731e-08,  2.041966633075572e-10, -1.804199571993074e-12,  1.515026096130897e-14, -1.219114882654340e-16,  9.461516041364428e-19,
 -7.113747054937248e-21,  5.202384567536680e-23, -3.709600596952594e-25,  7.668660323961424e-03, -1.082161486931124e-04,  1.553295778071266e-06, -1.874275967825139e-08,
  2.053891121572042e-10, -2.090694883713512e-12,  2.005845778148544e-14, -1.832011879470680e-16,  1.604716790068197e-18, -1.355329669899712e-20,  1.108600891142016e-22,
 -8.810044837851553e-25,  2.956964323309384e-03, -5.501256433589219e-05,  9.345088438125476e-07, -1.317103588328707e-08,  1.665039821462307e-10, -1.935742033983368e-12,
  2.104915507209087e-14, -2.165539681401749e-16,  2.125480885244842e-18, -2.002572109372498e-20,  1.819998380975961e-22, -1.601483175737483e-24,  9.697397028790306e-04,
 -2.328498487442758e-05,  4.643845096419293e-07, -7.595724954735051e-09,  1.100062402952116e-10, -1.451451966451735e-12,  1.778340910187771e-14, -2.049375605497900e-16,
  2.241964645647917e-18, -2.344366209558724e-20,  2.355797962051003e-22, -2.284382291486743e-24,  2.701484413555083e-04, -8.217664894625981e-06,  1.915250598732210e-07,
 -3.616306195449373e-09,  5.969263929292113e-11, -8.897128957065997e-13,  1.222924487169558e-14, -1.572136549043945e-16,  1.909453109474757e-18, -2.207662372558932e-20,
  2.443993359782550e-22, -2.602438396176203e-24,  6.384607301456896e-05, -2.421860249389629e-06,  6.576485827321659e-08, -1.427425373805349e-09,  2.675410585524388e-11,
 -4.489423026090153e-13,  6.900809739264863e-15, -9.866657275239676e-17,  1.326651575692785e-18, -1.691266089116535e-20,  2.057222765698904e-22, -2.399337800954379e-24,
  1.278593140622674e-05, -5.968748070438017e-07,  1.884260414583533e-08, -4.686426024672000e-10,  9.947457016209054e-12, -1.874750335911811e-13,  3.215474456263000e-15,
 -5.102465997393265e-17,  7.579887668934853e-19, -1.063431117375186e-20,  1.418626395119892e-22, -1.808903121103981e-24,  2.167610159077496e-06, -1.231730304590865e-07,
  4.512761588514590e-09, -1.283242331246449e-10,  3.079286305306108e-12, -6.507774642746354e-14,  1.243657251245779e-15, -2.187319859014104e-17,  3.585326684572237e-19,
 -5.528710112139997e-21,  8.078729515032699e-23, -1.124883817605445e-24,  3.109313805834429e-07, -2.131419375441845e-08,  9.050661769360716e-10, -2.938236690446261e-11,
  7.962698179202551e-13, -1.885479029817492e-14,  4.011668221965031e-16, -7.814565680785605e-18,  1.412408102830270e-19, -2.392301926550898e-21,  3.826582817069322e-23,
 -5.814422712239144e-25,  3.774942754003835e-08, -3.098711960523948e-09,  1.523482542630261e-10, -5.642347054388123e-12,  1.726253736913449e-13, -4.578703453962741e-15,
  1.084444282581685e-16, -2.339338501522448e-18,  4.661514291847165e-20, -8.671204517213090e-22,  1.518025705604559e-23, -2.516647302451458e-25,  3.885118815820286e-09,
 -3.796056485954243e-10,  2.159406156589703e-11, -9.122292789385935e-13,  3.151386092260105e-14, -9.365913014363397e-16,  2.470187282312305e-17, -5.903051090898404e-19,
  1.297285414107267e-20, -2.651045194253920e-22,  5.080856818122512e-24, -9.192249342456379e-26,  3.401800210716166e-10, -3.937047305884842e-11,  2.590300430159088e-12,
 -1.248562694922444e-13,  4.873589556702628e-15, -1.624224801813492e-16,  4.774094246451912e-18, -1.264855686088517e-19,  3.067959883449313e-21, -6.892260649233230e-23,
  1.447026300757099e-24, -2.858552241391039e-26,  2.551177503916104e-11, -3.483235411899965e-12,  2.650211416315868e-13, -1.458598726606676e-14,  6.439723106594749e-16,
 -2.409429015508704e-17,  7.901906205543167e-19, -2.323689370177312e-20,  6.227347104960837e-22, -1.539500137624382e-23,  3.543953778151477e-25, -7.650679303030837e-27,
  1.657629737329520e-12, -2.660686794600597e-13,  2.341020528181698e-14, -1.472490159106481e-15,  7.362555961354368e-17, -3.096914017013671e-18,  1.134821896544291e-19,
 -3.709007713441123e-21,  1.099647094872476e-22, -2.995081315834498e-24,  7.567990898039841e-26, -1.787121771563343e-27,  9.507763110352965e-14, -1.788103545570856e-14,
  1.819145699814725e-15, -1.308842446155221e-16,  7.420933668331352e-18, -3.514159207641003e-19,  1.440837192572104e-20, -5.241073623527308e-22,  1.721234781050943e-23,
 -5.171083332825706e-25,  1.435734532459428e-26, -3.711995399205733e-28,  4.958602542332312e-15, -1.088514041595772e-15,  1.279658333609852e-16, -1.053590185275949e-17,
  6.779754465974355e-19, -3.618159529361786e-20,  1.661642406565317e-21, -6.733803035578400e-23,  2.451936826708330e-24, -8.131935455590435e-26,  2.482623925790584e-27,
 -7.031440651465090e-29,  2.461073500757326e-16, -6.274062627520309e-17,  8.506987869592574e-18, -8.009363856135313e-19,  5.848202970531439e-20, -3.517352121003871e-21,
  1.809516077838215e-22, -8.170289708970939e-24,  3.298545955793864e-25, -1.207583730075154e-26,  4.053009848416516e-28, -1.257100538333967e-29,  1.244488136661786e-17,
 -3.656359233938960e-18,  5.693394951477557e-19, -6.111210295551204e-20,  5.051245106795897e-21, -3.416789721429507e-22,  1.965340348113306e-23, -9.868878489603466e-25,
  4.409531073200873e-26, -1.778625817947632e-27,  6.550126502198815e-29, -2.220351785215535e-30,  7.066795490653432e-19, -2.364574725566719e-19,  4.192346699879063e-20,
 -5.094003056415664e-21,  4.736319047720813e-22, -3.582348130137794e-23,  2.291292696821284e-24, -1.272851279961032e-25,  6.262017680809180e-27, -2.768956114298269e-28,
  1.113329055276889e-29, -4.104144104053134e-31,  5.112684646840011e-20, -1.913223117286215e-20,  3.803836536095604e-21, -5.160833870259360e-22,  5.329888852942141e-23,
 -4.454440001773013e-24,  3.132560456719860e-25, -1.904459776736209e-26,  1.020940161291922e-27, -4.899331573501026e-29,  2.129794207702900e-30, -8.457152229340997e-32,
  5.344244826862229e-21, -2.178817863285457e-21,  4.739717789669594e-22, -7.016955442674323e-23,  7.876768764659326e-24, -7.126193278698558e-25,  5.403589219510871e-26,
 -3.528929442037356e-27,  2.024997257985436e-28, -1.036745890224478e-29,  4.793267561846321e-31, -2.018110546975247e-32,  7.691459666062836e-22, -3.300527307720092e-22,
  7.584813476267739e-23, -1.184644849795098e-23,  1.399723781852916e-24, -1.329640396533549e-25,  1.056041663443473e-26, -7.206864134322529e-28,  4.311889874929622e-29,
 -2.296917709787593e-30,  1.102752972365285e-31, -4.811920098373612e-33,  8.103170582436114e-02, -2.730543535058328e-04,  9.578717209701575e-07, -3.478333927104189e-09,
  1.292833864288635e-11, -4.914801502142854e-14,  1.866002619529962e-16, -7.342608097800905e-19,  2.687057062361636e-21, -1.189771245575320e-23,  2.974086443487347e-26,
 -2.977070105432413e-28,  6.903437103414589e-02, -2.768756785600009e-04,  1.386784140402044e-06, -7.355235689102586e-09,  3.872215003670322e-11, -1.997390101594481e-13,
  1.007283233104063e-15, -4.999518684317764e-18,  2.430223315056725e-20, -1.177330381153238e-22,  5.508283394372747e-25, -2.688239402460628e-27,  5.009256827902033e-02,
 -2.655786868072163e-04,  1.901892482502907e-06, -1.314129541518617e-08,  8.589642958913112e-11, -5.382002646363192e-13,  3.264125615718310e-15, -1.926943120994332e-17,
  1.112000257501115e-19, -6.286865839416116e-22,  3.494068714252577e-24, -1.908076242978439e-26,  3.094241344168795e-02, -2.246872057866382e-04,  2.111483506281192e-06,
 -1.774120419759611e-08,  1.384683576449607e-10, -1.025834438450596e-12,  7.293923448530960e-15, -5.008493817413131e-17,  3.340006523255771e-19, -2.169097454412820e-21,
  1.378075356244483e-23, -8.562324747697086e-26,  1.625826587670775e-02, -1.612558142224937e-04,  1.874754724759366e-06, -1.869701667001051e-08,  1.714889666362398e-10,
 -1.478357309481188e-12,  1.212480428366540e-14, -9.536039777337898e-17,  7.238902541024356e-19, -5.325738194377670e-21,  3.813727326244628e-23, -2.663022942925579e-25,
  7.259298895557495e-03, -9.663658526956143e-05,  1.346800358862764e-06, -1.576653400253492e-08,  1.680019255579648e-10, -1.665466855191830e-12,  1.558007651898378e-14,
 -1.388715349830719e-16,  1.188086775197605e-18, -9.806631794198794e-21,  7.844297843706427e-23, -6.098619466668688e-25,  2.750925479834037e-03, -4.812618792590761e-05,
  7.912467995818604e-07, -1.079117417813247e-08,  1.323868610614452e-10, -1.496257819994683e-12,  1.583875250805690e-14, -1.587954281794578e-16,  1.520228510956820e-18,
 -1.398103073962867e-20,  1.241131375331799e-22, -1.067340998670214e-24,  8.834921527663853e-04, -1.990664657034753e-05,  3.829085677729283e-07, -6.046482396598091e-09,
  8.481923142634944e-11, -1.086121586036029e-12,  1.293459116265392e-14, -1.450594225754734e-16,  1.545898866190509e-18, -1.576068020404604e-20,  1.545297220972622e-22,
 -1.463019437641876e-24,  2.400886044678818e-04, -6.844066429365379e-06,  1.533205150465920e-07, -2.789012331080766e-09,  4.450963613512318e-11, -6.428022810680083e-13,
  8.575476324160694e-15, -1.071437639379491e-16,  1.266173582165955e-18, -1.425736037743386e-20,  1.538477894419175e-22, -1.597998289291162e-24,  5.511182766640447e-05,
 -1.957608949273312e-06,  5.093462162898370e-08, -1.063051476995867e-09,  1.923027495697531e-11, -3.121881898393538e-13,  4.651184258425498e-15, -6.455300742757263e-17,
  8.435751723177891e-19, -1.046301539602314e-20,  1.239375769222068e-22, -1.408782814433299e-24,  1.066777272639304e-05, -4.661830570340033e-07,  1.406247972048351e-08,
 -3.357269341432842e-10,  6.866741597604754e-12, -1.250251656582933e-13,  2.075800570095728e-15, -3.193798180128801e-17,  4.606391137744524e-19, -6.281692305763866e-21,
  8.153407040465633e-23, -1.012459166461606e-24,  1.738433726751465e-06, -9.248226362115304e-08,  3.230266623753616e-09, -8.803342463151833e-11,  2.032594663569530e-12,
 -4.144670488432358e-14,  7.658512736114791e-16, -1.304647461585411e-17,  2.074314478271828e-19, -3.106506359506920e-21,  4.413298292846693e-23, -5.980246451163780e-25,
  2.381944586410986e-07, -1.529302843321986e-08,  6.179868586261222e-10, -1.920182527463210e-11,  5.000672588960316e-13, -1.141188909623071e-14,  2.345355839531478e-16,
 -4.421128081252489e-18,  7.744644018090960e-20, -1.273046893312243e-21,  1.978467446187738e-23, -2.923910179455228e-25,  2.742148160783697e-08, -2.109944789536218e-09,
  9.859396938912123e-11, -3.491092132749384e-12,  1.025347877757992e-13, -2.618628955129243e-15,  5.985847614922994e-17, -1.248632525758895e-18,  2.409886892830709e-20,
 -4.347951686899690e-22,  7.391846847957175e-24, -1.191363100877180e-25,  2.653329439391638e-09, -2.433075624243688e-10,  1.314528660251216e-11, -5.305271831414077e-13,
  1.758122891860451e-14, -5.027689562703416e-16,  1.279005066748318e-17, -2.954005087615126e-19,  6.284901025845190e-21, -1.245217396053384e-22,  2.316810941111216e-24,
 -4.073870346700179e-26,  2.162443408085140e-10, -2.352724904640212e-11,  1.469990067454144e-12, -6.767144067137115e-14,  2.532938530269918e-15, -8.119639877993695e-17,
  2.301273918022885e-18, -5.891095767518773e-20,  1.383064850157180e-21, -3.011988095262036e-23,  6.138332341634296e-25, -1.178506898006590e-26,  1.491690303768431e-11,
 -1.918915920215875e-12,  1.387266638778704e-13, -7.293523462685192e-15,  3.088055436314815e-16, -1.111395495109200e-17,  3.514778355016220e-19, -9.987532227458944e-21,
  2.591030149741287e-22, -6.210352484885674e-24,  1.388010949871292e-25, -2.912872444794496e-27,  8.791024223741613e-13, -1.333364275445077e-13,  1.116208403416082e-14,
 -6.712599313354199e-16,  3.220860976778779e-17, -1.303946197423716e-18,  4.610047725842854e-20, -1.456740910215164e-21,  4.183153803849371e-23, -1.105275179666216e-24,
  2.713091506900936e-26, -6.231897499796726e-28,  4.498621897996491e-14, -8.024789125774565e-15,  7.785207293886982e-16, -5.364390692047660e-17,  2.922859065206379e-18,
 -1.333840749386804e-19,  5.282677768159961e-21, -1.859924426471925e-22,  5.922691187575185e-24, -1.728004123710242e-25,  4.665852902406610e-27, -1.174682964594555e-28,
  2.053609061601827e-15, -4.296573554320856e-16,  4.832800236733198e-17, -3.821048247456589e-18,  2.368435146705304e-19, -1.220656454794869e-20,  5.425783985062821e-22,
 -2.132264244088102e-23,  7.541948202503668e-25, -2.433438003237358e-26,  7.237398773055863e-28, -1.999459587966608e-29,  8.734021428230386e-17, -2.134993077230866e-17,
  2.782691390759692e-18, -2.525876251770751e-19,  1.782798710375688e-20, -1.038852889079372e-21,  5.188321623192208e-23, -2.278213584673617e-24,  8.958909981389540e-26,
 -3.199188294450992e-27,  1.048688978737594e-28, -3.180585349783351e-30,  3.703492797589587e-18, -1.051104113008933e-18,  1.583010790396553e-19, -1.647086917554738e-20,
  1.322462586215844e-21, -8.706160315501409e-23,  4.882130918152759e-24, -2.393678000049174e-25,  1.045716854574203e-26, -4.129254589305083e-28,  1.490375809224109e-29,
 -4.956705160538362e-31,  1.732609293939043e-19, -5.648878003851612e-20,  9.761277332282745e-21, -1.157686872261867e-21,  1.052270645736420e-22, -7.791806296047738e-24,
  4.885511954853509e-25, -2.663727956634218e-26,  1.287615319891755e-27, -5.599939020540033e-29,  2.216591270403557e-30, -8.051181519618904e-32,  1.027551977143280e-20,
 -3.781560243749144e-21,  7.391641927711818e-22, -9.867568197580775e-23,  1.003688439655903e-23, -8.269391381462458e-25,  5.738023135818471e-26, -3.444851968488535e-27,
  1.824989533155321e-28, -8.660794633955996e-30,  3.725592738841978e-31, -1.464816608123161e-32,  8.989745938893623e-22, -3.635148593798252e-22,  7.840134200432991e-23,
 -1.151154838767376e-23,  1.282160331195069e-24, -1.151489297822502e-25,  8.671273974341318e-27, -5.626262687427451e-28,  3.208806442358868e-29, -1.633378885233834e-30,
  7.510761896159388e-32, -3.146098819055485e-33,  1.148091248420683e-22, -4.914652954934489e-23,  1.126452881128074e-23, -1.754854224261944e-24,  2.068363154088705e-25,
 -1.960203016591315e-26,  1.553389788666111e-27, -1.057855115320973e-28,  6.316451889324140e-30, -3.358296719704040e-31,  1.609383977793699e-32, -7.010465603961771e-34,
  7.995455487243419e-02, -2.655548964165786e-04,  9.173411661745306e-07, -3.279107684826558e-09,  1.198854566589643e-11, -4.490699217826725e-14,  1.671818538861020e-16,
 -6.549251449714052e-19,  2.276829838205424e-21, -1.098924223548227e-23,  1.508454472024503e-26, -3.804227364536862e-28,  6.794851234773765e-02, -2.661242196246893e-04,
  1.302110939205924e-06, -6.766372095922576e-09,  3.495821697822462e-11, -1.771599437653773e-13,  8.775759617642571e-16, -4.285631322787820e-18,  2.043330454628247e-20,
 -9.791730164049863e-23,  4.433416862091990e-25, -2.223534277164994e-27,  4.905971701249378e-02, -2.509717565912751e-04,  1.752101085865566e-06, -1.184898463371937e-08,
  7.587410412315660e-11, -4.659536668039724e-13,  2.771179914630123e-15, -1.604773869901881e-17,  9.089324589735271e-20, -5.043550810314023e-22,  2.753985127716751e-24,
 -1.475320145986098e-26,  3.007615121425584e-02, -2.086107519008852e-04,  1.911234524601098e-06, -1.568078867720293e-08,  1.195945667743733e-10, -8.664695924353599e-13,
  6.030156206051611e-15, -4.054687896117460e-17,  2.649906597598752e-19, -1.686360192148641e-21,  1.051345219419893e-23, -6.398511002079114e-26,  1.564188073540134e-02,
 -1.471107369308476e-04,  1.665926592966731e-06, -1.617478253588019e-08,  1.446283089802901e-10, -1.216952682702952e-12,  9.752166597710127e-15, -7.499058300362250e-17,
  5.570171250566617e-19, -4.010978607281076e-21,  2.813786840890022e-23, -1.924025218936006e-25,  6.893164437405653e-03, -8.657568528583885e-05,  1.172693302835315e-06,
 -1.332591021039826e-08,  1.381377397423922e-10, -1.334215520712219e-12,  1.217489456541549e-14, -1.059446229277562e-16,  8.856108334563917e-19, -7.146150668363894e-21,
  5.592116213794025e-23, -4.254205858223242e-25,  2.570308546075138e-03, -4.228032791291177e-05,  6.735373159768803e-07, -8.893150388309809e-09,  1.059294115720443e-10,
 -1.164418829110924e-12,  1.200421150681186e-14, -1.173278735068279e-16,  1.096009757510257e-18, -9.842112829363900e-21,  8.537170962825755e-23, -7.177210080900413e-25,
  8.095630950430479e-04, -1.711208614494766e-05,  3.178276756593820e-07, -4.847574155065722e-09,  6.589891772294434e-11, -8.193259264497428e-13,  9.488021326106393e-15,
 -1.035912587585440e-16,  1.075836961211817e-18, -1.069756294200436e-20,  1.023742699510042e-22, -9.465995186992267e-25,  2.149693912963047e-04, -5.740177437277915e-06,
  1.237346642564329e-07, -2.169467415364091e-09,  3.349049687677929e-11, -4.688476352755185e-13,  6.073268922844024e-15, -7.377581884774813e-17,  8.486007359208171e-19,
 -9.309276903623172e-21,  9.794688663135273e-23, -9.926775578854191e-25,  4.802235886917619e-05, -1.596365776228049e-06,  3.983615656369204e-08, -7.998158524783245e-10,
  1.397079254247190e-11, -2.195158226073392e-13,  3.171174283564520e-15, -4.273784983329387e-17,  5.429838610076573e-19, -6.554421672352463e-21,  7.562853159814977e-23,
 -8.380646345194541e-25,  9.004931652235658e-06, -3.681042069357751e-07,  1.061845122093341e-08, -2.434328043810904e-10,  4.799792321160375e-12, -8.445987638143424e-14,
  1.357935804146037e-15, -2.026423522140989e-17,  2.838485032744204e-19, -3.763523514785232e-21,  4.754179882644125e-23, -5.750581811533612e-25,  1.414203336684829e-06,
 -7.036994604317319e-08,  2.344565202421129e-09, -6.125663364547914e-11,  1.361354026846973e-12, -2.679213462219089e-14,  4.788271762732074e-16, -7.902884857231537e-18,
  1.219113242705092e-19, -1.773567472811413e-21,  2.450226310133860e-23, -3.231776328999947e-25,  1.856222228312398e-07, -1.115035219894926e-08,  4.289262860455779e-10,
 -1.275836101835812e-11,  3.193765719335241e-13, -7.025938050619758e-15,  1.395089522225846e-16, -2.545437312402595e-18,  4.322430098980371e-20, -6.896601092974724e-22,
  1.041547761763423e-23, -1.497329392070042e-25,  2.032858232666643e-08, -1.464402424811463e-09,  6.503967786140732e-11, -2.201946944325230e-12,  6.209201826402061e-14,
 -1.527075415578613e-15,  3.369421082506144e-17, -6.797354372620143e-19,  1.270801559694219e-20, -2.224047068207306e-22,  3.672129623369436e-24, -5.754250835909770e-26,
  1.855968605142628e-09, -1.594967996649119e-10,  8.182152067119111e-12, -3.154430616496938e-13,  1.002744599660277e-14, -2.759160260472931e-16,  6.770278493495076e-18,
 -1.511264237269717e-19,  3.112841975605989e-21, -5.979538730543698e-23,  1.080026136164375e-24, -1.845756464414899e-26,  1.413436393333328e-10, -1.443297943210852e-11,
  8.558850571719295e-13, -3.761718911794588e-14,  1.349846214766274e-15, -4.161336801380759e-17,  1.137064358168165e-18, -2.812101067420571e-20,  6.389376689987950e-22,
 -1.348690260354665e-23,  2.667693071190533e-25, -4.977053395525602e-27,  9.006114476668171e-12, -1.089523871747144e-12,  7.477483038116824e-14, -3.753078880995916e-15,
  1.523167491285954e-16, -5.271065936692236e-18,  1.606907249233005e-19, -4.410924366679003e-21,  1.107403822625725e-22, -2.572735930186685e-24,  5.581127711702696e-26,
 -1.138284366660274e-27,  4.835088052471779e-13, -6.915016044860535e-14,  5.500876840059773e-15, -3.159919381681589e-16,  1.453917651708447e-17, -5.661590916629046e-19,
  1.930124855036234e-20, -5.893642828098206e-22,  1.638402647798356e-23, -4.197577876188696e-25,  1.000514194087617e-26, -2.234476582454861e-28,  2.216879412775802e-14,
 -3.741949832696291e-15,  3.456199275908881e-16, -2.277904413702201e-17,  1.191474353732572e-18, -5.235005174835439e-20,  2.001091609248767e-21, -6.814220108817591e-23,
  2.102510310729113e-24, -5.953324832965805e-26,  1.562301496836539e-27, -3.827782176860966e-29,  8.890766091674455e-16, -1.768188147645522e-16,  1.899216671319989e-17,
 -1.439703186115129e-18,  8.584118563439828e-20, -4.267373663899216e-21,  1.833890172096005e-22, -6.981839863991657e-24,  2.396615872970390e-25, -7.516299184686517e-27,
  2.175948415939395e-28, -5.859082961379107e-30,  3.247688003060650e-17, -7.590893815296197e-18,  9.489198971127092e-19, -8.288526345149884e-20,  5.645621215257764e-21,
 -3.182550932374046e-22,  1.540940584573175e-23, -6.572091432957695e-25,  2.514406269966094e-26, -8.748572502763633e-28,  2.797981940621261e-29, -8.289934656848584e-31,
  1.154463317554832e-18, -3.156172304136628e-19,  4.586395066504841e-20, -4.616052394488791e-21,  3.593542327864435e-22, -2.298565162737060e-23,  1.254680032156450e-24,
 -5.997879697588906e-26,  2.558562621653079e-27, -9.878315945844609e-29,  3.490301812025960e-30, -1.137658015958658e-31,  4.429881514127805e-20, -1.403671994836925e-20,
  2.358552222378019e-21, -2.724663455990704e-22,  2.416526750289443e-23, -1.748826094620217e-24,  1.073246647004531e-25, -5.735039556354765e-27,  2.720271974558861e-28,
 -1.162157255769855e-29,  4.523322665531205e-31, -1.617090231658557e-32,  2.132691888221367e-21, -7.703595490074343e-22,  1.477638333878192e-22, -1.937619024685079e-23,
  1.938080595748398e-24, -1.571908562836549e-25,  1.074805192510434e-26, -6.364283945783569e-28,  3.328247036541223e-29, -1.560355753867953e-30,  6.635587931964676e-32,
 -2.580946324802131e-33,  1.540119628444151e-22, -6.170232492997122e-23,  1.317969959523007e-23, -1.917318664620953e-24,  2.116950747397335e-25, -1.885676336423965e-26,
  1.409121580194959e-27, -9.077129116744272e-29,  5.141909810255967e-30, -2.600730421886886e-31,  1.188725405504983e-32, -4.951247554628424e-34,  1.723950894146733e-23,
 -7.359613088213950e-24,  1.681900380447427e-24, -2.612680539850325e-25,  3.071039821733100e-26, -2.902902209058624e-27,  2.294788200962223e-28, -1.559101666660763e-29,
  9.288796940863993e-31, -4.928241092724455e-32,  2.357026619777564e-33, -1.024774092819094e-34,  7.890676804859767e-02, -2.583703702442653e-04,  8.791138252123612e-07,
 -3.094264159196463e-09,  1.112908510765717e-11, -4.110681175454031e-14,  1.498051245514781e-16, -5.883151394859171e-19,  1.887661215565596e-21, -1.076420663153375e-23,
 -5.111675959123029e-27, -5.567819812058676e-28,  6.690434807803847e-02, -2.560228713822176e-04,  1.224157135836238e-06, -6.234281366668591e-09,  3.161628498861054e-11,
 -1.574673453529825e-13,  7.662258013297390e-16, -3.684928368430038e-18,  1.720486157560427e-20, -8.203792035595130e-23,  3.528880253506094e-25, -1.913147129291701e-27,
  4.808299131123216e-02, -2.375037469177736e-04,  1.616900956647160e-06, -1.070608500478400e-08,  6.718534778592285e-11, -4.045247660814667e-13,  2.359978374109666e-15,
 -1.340960890138614e-17,  7.457245837984752e-20, -4.061404962543431e-22,  2.180816563422419e-24, -1.144393018529461e-26,  2.927114046911270e-02, -1.940422916335198e-04,
  1.733998725615762e-06, -1.389841687790735e-08,  1.036251763449312e-10, -7.344647124628465e-13,  5.004981124984549e-15, -3.296255484650156e-17,  2.112195292660363e-19,
 -1.317076699473882e-21,  8.066910366879374e-24, -4.800752401691490e-26,  1.507891652811216e-02, -1.345221453994066e-04,  1.484949657576648e-06, -1.404340450477819e-08,
  1.224695670492675e-10, -1.006209392007617e-12,  7.881724426807744e-15, -5.927466333488898e-17,  4.309960218857820e-19, -3.038008442408576e-21,  2.089279591640033e-23,
 -1.398315842881969e-25,  6.564662515147497e-03, -7.779813873343197e-05,  1.025211824347997e-06, -1.131425867342841e-08,  1.141507166205584e-10, -1.074636210245512e-12,
  9.569402057215090e-15, -8.132365552136428e-17,  6.644784007818047e-19, -5.242987043248775e-21,  4.015609163673043e-23, -2.989370898886071e-25,  2.411326417124215e-03,
 -3.729176129041536e-05,  5.762680351962851e-07, -7.369982956295511e-09,  8.527512023303316e-11, -9.120820147541036e-13,  9.161141925427893e-15, -8.732269252711083e-17,
  7.962457842598444e-19, -6.983918721808845e-21,  5.921531845844438e-23, -4.867776422103841e-25,  7.458553365003288e-04, -1.478539341329167e-05,  2.654798686450498e-07,
 -3.912831733954354e-09,  5.157327132588853e-11, -6.228593312743295e-13,  7.016741623549829e-15, -7.461076340399427e-17,  7.553942906815189e-19, -7.328238425162419e-21,
  6.847345162071231e-23, -6.185249119844618e-25,  1.938355382458111e-04, -4.845989615417250e-06,  1.006305627127399e-07, -1.701366399677313e-09,  2.541844180299238e-11,
 -3.450939189325823e-13,  4.342271059231173e-15, -5.130445387741382e-17,  5.745970075143413e-19, -6.143073070581729e-21,  6.304087200507710e-23, -6.235885372153719e-25,
  4.221844467904743e-05, -1.312576312532709e-06,  3.144704464867587e-08, -6.076446326484445e-10,  1.025392121057467e-11, -1.560029357189764e-13,  2.186077939417462e-15,
 -2.861906932979653e-17,  3.536265207495339e-19, -4.155697738940360e-21,  4.672299954443702e-23, -5.048868001049860e-25,  7.685596420811363e-06, -2.936535908186366e-07,
  8.107544117106399e-09, -1.785548921413401e-10,  3.395357542011620e-12, -5.776500069790515e-14,  8.996887133346766e-16, -1.302621192639680e-17,  1.772610954368856e-19,
 -2.285807509396433e-21,  2.810976616741820e-23, -3.312842991422837e-25,  1.166054850196497e-06, -5.422046571063878e-08,  1.724327340331413e-09, -4.320531872553425e-11,
  9.245566259035243e-13, -1.756768350276561e-14,  3.037671152236755e-16, -4.858843370494084e-18,  7.274214886219500e-20, -1.028264314670525e-21,  1.381757301776689e-23,
 -1.774350588284332e-25,  1.470239144382076e-07, -8.254080145548803e-09,  3.023782401387539e-10, -8.612254747628605e-12,  2.072868614380411e-13, -4.397046892999394e-15,
  8.437512156741742e-17, -1.490429770301725e-18,  2.453958601145232e-20, -3.801226889781908e-22,  5.579631554215498e-24, -7.804007821991814e-26,  1.536536663703547e-08,
 -1.034954194050717e-09,  4.369572337402440e-11, -1.414599499923755e-12,  3.830490610153372e-14, -9.073482635044234e-16,  1.932779234449404e-17, -3.771445784679987e-19,
  6.830951822598898e-21, -1.159790154363529e-22,  1.859975024489159e-24, -2.833996712893329e-26,  1.328284198376386e-09, -1.068218200312173e-10,  5.202469393240668e-12,
 -1.915810907416677e-13,  5.841941189585851e-15, -1.546778426790326e-16,  3.661032062961491e-18, -7.898626200870764e-20,  1.575122738651931e-21, -2.933607967925350e-23,
  5.143977399342691e-25, -8.544122116225875e-27,  9.489261795875688e-11, -9.079163243024880e-12,  5.107595162552804e-13, -2.142630025007214e-14,  7.369701464968565e-16,
 -2.184646258371957e-17,  5.754534564316325e-19, -1.374785606637943e-20,  3.022775775839726e-22, -6.183931887901568e-24,  1.187067822106687e-25, -2.151914899496040e-27,
  5.608600240763222e-12, -6.368761184123978e-13,  4.146063233225078e-14, -1.985590341464734e-15,  7.721276365273673e-17, -2.568420038854527e-18,  7.545686428707696e-20,
 -2.000342449278348e-21,  4.858897676625567e-23, -1.093883681219130e-24,  2.302761662356341e-26, -4.563307369176898e-28,  2.755317957705666e-13, -3.707721868914178e-14,
  2.799491432484055e-15, -1.534816538223114e-16,  6.767261471242404e-18, -2.533241866003046e-19,  8.323511953344899e-21, -2.454861297730245e-22,  6.603777009867529e-24,
 -1.639851592887187e-25,  3.793924700935801e-27, -8.235154940854195e-29,  1.137032288772431e-14, -1.811664214597475e-15,  1.590633848745588e-16, -1.001566576345468e-17,
  5.024196674415883e-19, -2.123574437651759e-20,  7.828658171700348e-22, -2.576570601020188e-23,  7.698037166035046e-25, -2.114124631096436e-26,  5.388905201465195e-28,
 -1.284194946644878e-29,  4.022887108944140e-16, -7.584739220568349e-17,  7.764611020418998e-18, -5.634583290840785e-19,  3.227439020466707e-20, -1.545801176866434e-21,
  6.415880171482178e-23, -2.364034893085612e-24,  7.868285933781254e-26, -2.396565733343177e-27,  6.747919134818221e-29, -1.769584209277238e-30,  1.266007579183815e-17,
 -2.821132425503002e-18,  3.374766260238825e-19, -2.831195783232379e-20,  1.857949567983681e-21, -1.011747740830669e-22,  4.742876704421498e-24, -1.962352964415671e-25,
  7.296000904598119e-27, -2.470811179222874e-28,  7.702118991823364e-30, -2.227137750686963e-31,  3.775216947381102e-19, -9.912091234418403e-20,  1.386324955371473e-20,
 -1.346775860797186e-21,  1.014622655322864e-22, -6.294828406357207e-24,  3.339439164200385e-25, -1.554248649332323e-26,  6.465281138332693e-28, -2.437589949186499e-29,
  8.421452320327671e-31, -2.687243263730160e-32,  1.184004456408236e-20, -3.635962518035559e-21,  5.925938646579007e-22, -6.653511081532813e-23,  5.746624911135668e-24,
 -4.057258188730861e-25,  2.433063095030132e-26, -1.272302809128616e-27,  5.913406052405883e-29, -2.478447216146078e-30,  9.474014232589904e-32, -3.329802794301819e-33,
  4.584105567278576e-22, -1.621656387583664e-22,  3.046068050748845e-23, -3.916101258761800e-24,  3.845292166988311e-25, -3.065404604815814e-26,  2.062446570562876e-27,
 -1.202935095276664e-28,  6.202348960328247e-30, -2.869363176364119e-31,  1.205048719361958e-32, -4.632258897509320e-34,  2.692973124781182e-23, -1.067600877412609e-23,
  2.255686386204114e-24, -3.247492318427355e-25,  3.550710999955647e-26, -3.133944928424724e-27,  2.321913904491857e-28, -1.483730616381779e-29,  8.341747690700390e-31,
 -4.189420104568560e-32,  1.902173927667581e-33, -7.873536754447629e-35,  2.605907165251641e-24, -1.109053273517665e-24,  2.526197189230014e-25, -3.911688366474065e-26,
  4.583952595100419e-27, -4.320493443727490e-28,  3.406100794978998e-29, -2.308167426457903e-30,  1.371798326082578e-31, -7.261335796331435e-33,  3.465251727277520e-34,
 -1.503470545296333e-35,  7.788712141750392e-02, -2.514830184515868e-04,  8.430245347357421e-07, -2.922586024038058e-09,  1.034160155169859e-11, -3.770269761123178e-14,
  1.341191355204405e-16, -5.342021939949308e-19,  1.489845435457052e-21, -1.153983777962821e-23, -3.595365353517233e-26, -8.706106795452726e-28,  6.589938113435806e-02,
 -2.465204932002479e-04,  1.152280137652635e-06, -5.752650418924698e-09,  2.864278514243068e-11, -1.402564847905057e-13,  6.703300833221658e-16, -3.179063341588870e-18,
  1.448583234979343e-20, -6.954841390948283e-23,  2.727406717375490e-25, -1.754603652381391e-27,  4.715805808934866e-02, -2.250647524288075e-04,  1.494620374682119e-06,
 -9.692888966366790e-09,  5.963217267826859e-11, -3.521341910973430e-13,  2.015834322443516e-15, -1.124132739645762e-17,  6.140759871270216e-20, -3.281795878760110e-22,
  1.735800403804184e-24, -8.891000045133931e-27,  2.852169737428398e-02, -1.808103152789484e-04,  1.576701308814871e-06, -1.235170251741701e-08,  9.006608764035761e-11,
 -6.246984967972786e-13,  4.169949128200122e-15, -2.690379135054652e-17,  1.691385417046913e-19, -1.032890307734867e-21,  6.229010222328842e-24, -3.609948013508716e-26,
  1.456356493499184e-02, -1.232847851891008e-04,  1.327553599091692e-06, -1.223514466182208e-08,  1.041102038372886e-10, -8.355013849871547e-13,  6.399762251355106e-15,
 -4.708268895091835e-17,  3.352987115965943e-19, -2.313347356568430e-21,  1.561427624282194e-23, -1.021395888440612e-25,  6.269055243686711e-03, -7.011003561066953e-05,
  8.997283343256945e-07, -9.648043603279608e-09,  9.478192295897670e-11, -8.700564792732791e-13,  7.563720714665259e-15, -6.279430206896092e-17,  5.017333093662151e-19,
 -3.871733174134331e-21,  2.904199942666030e-23, -2.115014328028888e-25,  2.270850552629087e-03, -3.301349403621420e-05,  4.954492208734644e-07, -6.140350359846952e-09,
  6.904805690228193e-11, -7.188927573998090e-13,  7.038059479516973e-15, -6.544724144919032e-17,  5.827601439377642e-19, -4.993839339850272e-21,  4.140663119859302e-23,
 -3.328655839079751e-25,  6.906826922682190e-04, -1.283623309502716e-05,  2.230936445110602e-07, -3.178831152395303e-09,  4.064403267870793e-11, -4.770213487054878e-13,
  5.229878014626424e-15, -5.417957593668187e-17,  5.349583698560159e-19, -5.064863251174941e-21,  4.622370121309657e-23, -4.080036328824931e-25,  1.759414776093420e-04,
 -4.116186921396100e-06,  8.244366616585007e-08, -1.344677529882221e-09,  1.945228025751566e-11, -2.562281521741720e-13,  3.133101512013331e-15, -3.601810055302158e-17,
  3.929210211361366e-19, -4.095219729577152e-21,  4.100327696868890e-23, -3.959800385773266e-25,  3.742875781204777e-05, -1.087597700152944e-06,  2.504526486701058e-08,
 -4.659428171043241e-10,  7.599678847208235e-12, -1.120006974786552e-13,  1.523018246881227e-15, -1.937537778247053e-17,  2.329187356356070e-19, -2.665584018726522e-21,
  2.921106233509810e-23, -3.078947290272795e-25,  6.628329550672764e-06, -2.365210880908631e-07,  6.256202061465050e-09, -1.324117579503477e-10,  2.429455511316531e-12,
 -3.997723084417762e-14,  6.033933413019936e-16, -8.479098073097630e-18,  1.121302635862569e-19, -1.406681004099322e-21,  1.684500192236973e-23, -1.934790810365724e-25,
  9.738014276938761e-07, -4.227256409195577e-08,  1.284193510958709e-09, -3.086905701194728e-11,  6.363142297774724e-13, -1.167754558599809e-14,  1.954233893387356e-16,
 -3.030305742205280e-18,  4.404104705014510e-20, -6.050690654846864e-22,  7.910545551706800e-24, -9.892007681226137e-26,  1.182627224780220e-07, -6.198093590794319e-09,
  2.163498202650356e-10, -5.901907783260372e-12,  1.366257138639727e-13, -2.795348988266017e-15,  5.185173737540665e-17, -8.869648476963469e-19,  1.416293088781816e-20,
 -2.130354033200765e-22,  3.039879757793445e-24, -4.137332501114052e-26,  1.183024912633336e-08, -7.441018508365066e-10,  2.987175210946001e-11, -9.248841113905304e-13,
  2.405422502361367e-14, -5.489002059233607e-16,  1.129011957983863e-17, -2.131289318052343e-19,  3.740434668660444e-21, -6.161924575110857e-23,  9.599652360358662e-25,
 -1.422395815824654e-26,  9.716445643482579e-10, -7.301639984060210e-11,  3.375866857261979e-12, -1.187452134964234e-13,  3.473650116489160e-15, -8.850697622938124e-17,
  2.020859133767889e-18, -4.214375171357675e-20,  8.137171401953413e-22, -1.469484520461076e-23,  2.501580490729252e-25, -4.038574732896543e-27,  6.536436900008067e-11,
 -5.850003196863022e-12,  3.120896647273332e-13, -1.249338077206957e-14,  4.118517200316741e-16, -1.173883055262153e-17,  2.980633678027675e-19, -6.878483735282941e-21,
  1.463482489320429e-22, -2.901551775745566e-24,  5.405116171615011e-26, -9.520094243031178e-28,  3.598767188348273e-12, -3.828454055730589e-13,  2.362421842901051e-14,
 -1.079030335636945e-15,  4.019121866861749e-17, -1.284757799302630e-18,  3.636612987874722e-20, -9.308529714582858e-22,  2.187197302125607e-23, -4.770725984782374e-25,
  9.743910424641444e-27, -1.875795101326777e-28,  1.625176515684491e-13, -2.053231994468266e-14,  1.469847797894487e-15, -7.685170480348473e-17,  3.245238176272574e-18,
 -1.167240252745271e-19,  3.694736537639634e-21, -1.052088640531367e-22,  2.737687541245485e-24, -6.586808542304864e-26,  1.478662580502300e-27, -3.118431198804872e-29,
  6.064942236572777e-15, -9.099385785605813e-16,  7.583218662560769e-17, -4.556758724878620e-18,  2.190228334258072e-19, -8.898605112487902e-21,  3.161629423512635e-22,
 -1.005068234561324e-23,  2.905976756314268e-25, -7.736211045950815e-27,  1.914388608837704e-28, -4.434900022142833e-30,  1.901752896429259e-16, -3.389793789374404e-17,
  3.301151099188201e-18, -2.289840426787482e-19,  1.258437856118972e-20, -5.800723652003027e-22,  2.322984664956282e-23, -8.276595340655692e-25,  2.668758690514239e-26,
 -7.888185779995467e-28,  2.158569827568937e-29, -5.509021708586619e-31,  5.175398983335047e-18, -1.096193023018827e-18,  1.251992517016283e-19, -1.006913700208218e-20,
  6.356006287217980e-22, -3.338679616391036e-23,  1.513350395270034e-24, -6.066999664783480e-26,  2.189654948406248e-27, -7.209935210846520e-29,  2.188458411667432e-30,
 -6.170220104619761e-32,  1.296778594023875e-19, -3.259532364067057e-20,  4.376480742632237e-21, -4.094786776940977e-22,  2.979602616245228e-23, -1.789906395100874e-24,
  9.214009589027235e-26, -4.169153919863681e-27,  1.688881181892441e-28, -6.210304675112161e-30,  2.095429053612337e-31, -6.538540967808739e-33,  3.316056036216696e-21,
 -9.839118637865481e-22,  1.551323088102756e-22, -1.688927821145810e-23,  1.417598000008538e-24, -9.745882626035629e-26,  5.701177271992557e-27, -2.912840013480579e-28,
  1.324649823066453e-29, -5.439297267716222e-31,  2.039426978690726e-32, -7.038576335154605e-34,  1.023504467141561e-22, -3.537162841526931e-23,  6.491516038043607e-24,
 -8.165368494614729e-25,  7.856155646178167e-26, -6.145142879215995e-27,  4.062029882245290e-28, -2.330349986548741e-29,  1.183069439749917e-30, -5.394243128076188e-32,
  2.234706789643823e-33, -8.480857484828480e-35,  4.817514131477470e-24, -1.887119394233568e-24,  3.938377190881473e-25, -5.603993671425102e-26,  6.060308261129110e-27,
 -5.294371140206346e-28,  3.885141074563398e-29, -2.460507924769489e-30,  1.371781722256695e-31, -6.835476245938351e-33,  3.080788779267992e-34, -1.266422717985263e-35,
  3.968565376623810e-25, -1.683113083002963e-25,  3.819578697068140e-26, -5.893209879210494e-27,  6.882492702735734e-28, -6.466048176741126e-29,  5.082088307583023e-30,
 -3.434042724352485e-31,  2.035409551011868e-32, -1.074646683756166e-33,  5.116010138869970e-35, -2.214608966883385e-36,  7.689445951673531e-02, -2.448763495839480e-04,
  8.089219652617530e-07, -2.762982933186446e-09,  9.618550792230333e-12, -3.465833878878523e-14,  1.197640225190707e-16, -4.935339232656479e-19,  1.038164154237710e-21,
 -1.386985451050433e-23, -8.387110118517895e-26, -1.324613873223887e-27,  6.493130916705817e-02, -2.375707961389254e-04,  1.085908221705100e-06, -5.315962134994372e-09,
  2.599158570719530e-11, -1.251865892010404e-13,  5.874437092480203e-16, -2.753620951610717e-18,  1.216001269859216e-20, -6.016741974358127e-23,  1.964853736513234e-25,
 -1.728910744685923e-27,  4.628099856002821e-02, -2.135573468321463e-04,  1.383806218892506e-06, -8.792590183883944e-09,  5.304889670970663e-11, -3.073196591990463e-13,
  1.726902945327159e-15, -9.452642603279318e-18,  5.075435135909567e-20, -2.659504373548331e-22,  1.390133030384933e-24, -6.901386767529945e-27,  2.782277798120249e-02,
 -1.687660039957028e-04,  1.436731861616273e-06, -1.100540480533241e-08,  7.851490878176264e-11, -5.330804991643869e-13,  3.487152737811095e-15, -2.204114916827890e-17,
  1.360826098185418e-19, -8.126757492523414e-22,  4.846906789779914e-24, -2.713739958015234e-26,  1.409077515048664e-02, -1.132245432480325e-04,  1.190200870126946e-06,
 -1.069514369088649e-08,  8.883529008201362e-11, -6.965872835651618e-13,  5.219952070922105e-15, -3.757333547433036e-17,  2.622574143407577e-19, -1.770001417925547e-21,
  1.175106189571199e-23, -7.490164029598807e-26,  6.002312233197248e-03, -6.335079559282358e-05,  7.925070292932264e-07, -8.261445515883226e-09,  7.906252654827264e-11,
 -7.079330017339339e-13,  6.010801949190727e-15, -4.876175183889595e-17,  3.811991536385489e-19, -2.876648152303271e-21,  2.115499471278716e-23, -1.505827959044843e-25,
  2.146282242697148e-03, -2.932689205195676e-05,  4.279472739860277e-07, -5.142013827262755e-09,  5.622112684649508e-11, -5.700176995939157e-13,  5.441709915529288e-15,
 -4.938229508229923e-17,  4.295749761226645e-19, -3.597063130398281e-21,  2.918378706348770e-23, -2.294037368760376e-25,  6.426803712413100e-04, -1.119369584881607e-05,
  1.885554247252521e-07, -2.598513310629188e-09,  3.224522332967820e-11, -3.679307418616833e-13,  3.927454595327611e-15, -3.965378881804544e-17,  3.819906067685068e-19,
 -3.530515749207887e-21,  3.148411103521157e-23, -2.715992652803331e-25,  1.607006207621664e-04, -3.516255620709270e-06,  6.801819938898683e-08, -1.070670955962152e-09,
  1.500477602477448e-11, -1.918406909985762e-13,  2.280533764035700e-15, -2.551811757947938e-17,  2.712502610007394e-19, -2.756919540488366e-21,  2.694152183408187e-23,
 -2.540772423715545e-25,  3.344638862845334e-05, -9.076919197735333e-07,  2.011556315670294e-08, -3.604524134629603e-10,  5.685249825101077e-12, -8.119736828795640e-14,
  1.071895491832846e-15, -1.325591292147486e-17,  1.550890647891966e-19, -1.728992201615665e-21,  1.847366268214949e-23, -1.899840887011732e-25,  5.773139917984899e-06,
 -1.922224506039436e-07,  4.876448236980207e-09, -9.922398471335282e-11,  1.757407325971250e-12, -2.798182833488008e-14,  4.094388939386493e-16, -5.586137284194190e-18,
  7.181328874077212e-20, -8.767054772840431e-22,  1.022613920253931e-23, -1.145004365064787e-25,  8.231350858293743e-07, -3.332387993478657e-08,  9.678968318238097e-10,
 -2.232782578489661e-11,  4.435371507626517e-13, -7.864451865254712e-15,  1.274211905454598e-16, -1.916047439093309e-18,  2.704103730193056e-20, -3.611743842425008e-22,
  4.595189364295944e-24, -5.596974492147166e-26,  9.653076900123643e-08, -4.717272521908687e-09,  1.569960504380580e-10, -4.103143218158821e-12,  9.138891471173195e-14,
 -1.804042142181994e-15,  3.235749615069813e-17, -5.361430495659359e-19,  8.304749122114683e-21, -1.213295205066146e-22,  1.683394111208267e-24, -2.229901358871958e-26,
  9.269744674485167e-09, -5.437273694015651e-10,  2.076275311880949e-11, -6.149277471792697e-13,  1.536455220863553e-14, -3.378354371139068e-16,  6.711241978136726e-18,
 -1.225894672531691e-19,  2.085067537833290e-21, -3.333375173946082e-23,  5.045470177188904e-25, -7.271086669288159e-27,  7.257440826927560e-10, -5.088360901350729e-11,
  2.233534990279249e-12, -7.504664327850603e-14,  2.106293541952607e-15, -5.165174929234638e-17,  1.137837431390632e-18, -2.293908852421755e-20,  4.288829213870802e-22,
 -7.510584400774085e-24,  1.241394605237172e-25, -1.948037091366803e-27,  4.614574635559571e-11, -3.856552641055701e-12,  1.950598185667885e-13, -7.450358009351885e-15,
  2.353837522607041e-16, -6.450689289135063e-18,  1.578857756337959e-19, -3.519538030897404e-21,  7.246063999909911e-23, -1.392272293184287e-24,  2.516834681060998e-26,
 -4.306907530805966e-28,  2.376566120327225e-12, -2.363966907966799e-13,  1.381869809002567e-14, -6.017291451385368e-16,  2.146280738191014e-17, -6.591804248185347e-19,
  1.797425808629067e-20, -4.441685458071974e-22,  1.009405559785142e-23, -2.132867499898889e-25,  4.225926288904473e-27, -7.901912676157978e-29,  9.911159020292737e-14,
 -1.173016908762171e-14,  7.953769222693782e-16, -3.963380888899640e-17,  1.602042325486209e-18, -5.534188015877775e-20,  1.686977156248913e-21, -4.636383499425239e-23,
  1.166645044641377e-24, -2.718794824935161e-26,  5.920407690094456e-28, -1.212763023452325e-29,  3.361335703128026e-15, -4.736869406105536e-16,  3.741746722571066e-17,
 -2.143513977186071e-18,  9.863942228546088e-20, -3.849557525266373e-21,  1.317341998336476e-22, -4.042642073275126e-24,  1.130548079222437e-25, -2.916025026484912e-27,
  7.001874721182647e-29, -1.576113355128742e-30,  9.387652427763712e-17, -1.577499704466165e-17,  1.458737683387098e-18, -9.658262344028609e-20,  5.086791173838306e-21,
 -2.254256729897006e-22,  8.702197440887728e-24, -2.995539018363061e-25,  9.350220622278609e-27, -2.679944666979944e-28,  7.122238534098064e-30, -1.767819094928801e-31,
  2.218960006388992e-18, -4.453410519024244e-19,  4.845237253925253e-20, -3.728813602232920e-21,  2.260519784588479e-22, -1.143795105456110e-23,  5.006840534170813e-25,
 -1.942663124379169e-26,  6.798739707346297e-28, -2.174447784939600e-29,  6.420664342101404e-31, -1.763501239517369e-32,  4.684170218407856e-20, -1.123412376516158e-20,
  1.444211448006847e-21, -1.298511153150572e-22,  9.108495062222020e-24, -5.288807694410390e-25,  2.637673250854163e-26, -1.158628806135476e-27,  4.564541074679141e-29,
 -1.634960321368702e-30,  5.381328710836041e-32, -1.640221498151438e-33,  9.754348367487048e-22, -2.787199677696236e-22,  4.239384647022998e-23, -4.464415566126118e-24,
  3.633655770908451e-25, -2.427789783561704e-26,  1.382942277970920e-27, -6.892253730702191e-29,  3.062151318020160e-30, -1.230149618545399e-31,  4.518189757687887e-33,
 -1.529324130263691e-34,  2.381251364269999e-23, -8.017206751488371e-24,  1.433919857036209e-24, -1.760699340024644e-25,  1.656502161887036e-26, -1.269036377183452e-27,
  8.227518616286283e-29, -4.635470400032322e-30,  2.313872117955105e-31, -1.038433199677441e-32,  4.238467212814604e-34, -1.586229211918505e-35,  8.841003116234069e-25,
 -3.416202795257011e-25,  7.030698641715763e-26, -9.872740339253053e-27,  1.054559893128199e-27, -9.107394791814641e-29,  6.611971881583846e-30, -4.145783036796094e-31,
  2.289869705895386e-32, -1.131098051307197e-33,  5.056368031369759e-35, -2.062663153892377e-36,  6.094866995673164e-26, -2.574662571206784e-26,  5.818287530431858e-27,
 -8.940669253077762e-28,  1.040151426831390e-28, -9.736873971343157e-30,  7.626859595585451e-31, -5.137115995853097e-32,  3.035683742674369e-33, -1.598218876485628e-34,
  7.588166927069233e-36, -3.276455157297254e-37,  7.592769050845895e-02, -2.385350324859390e-04,  7.766671696305830e-07, -2.614479919494995e-09,  8.953025396458640e-12,
 -3.194656314120172e-14,  1.063297881962233e-16, -4.690716571413784e-19,  4.631391383683281e-22, -1.852842681388794e-23, -1.521332090315444e-25, -1.737008607086033e-27,
  6.399800623693670e-02, -2.291318122702662e-04,  1.024531656748662e-06, -4.919386039872352e-09,  2.362281414001880e-11, -1.119711370813596e-13,  5.154743332053734e-16,
 -2.397789257522071e-18,  1.011707083973947e-20, -5.383447899631990e-23,  1.201423498609721e-25, -1.726310522636644e-27,  4.544826160815595e-02, -2.028949650392296e-04,
  1.283192056059533e-06, -7.990813897483044e-09,  4.729643394759255e-11, -2.688750257332215e-13,  1.483600797390493e-15, -7.971523276087197e-18,  4.211232884660529e-20,
 -2.159320308443625e-22,  1.122104746495780e-24, -5.346724803695788e-27,  2.716989438165812e-02, -1.577798342244015e-04,  1.311866779046426e-06, -9.830113209777998e-09,
  6.864265921988947e-11, -4.563283353214722e-13,  2.926821259720091e-15, -1.811939402175108e-17,  1.100479413025323e-19, -6.405510203828340e-22,  3.808403981476983e-24,
 -2.039471311869431e-26,  1.365614013090806e-02, -1.041931562836120e-04,  1.069948697284969e-06, -9.378767557573987e-09,  7.607577912207910e-11, -5.830405381322416e-13,
  4.276422100042896e-15, -3.011596176628113e-17,  2.062619388514119e-19, -1.359589087261511e-21,  8.913300382952105e-24, -5.513638529597235e-26,  5.760990296200193e-03,
 -5.738681107871107e-05,  7.005166282423463e-07, -7.102316868796102e-09,  6.624260539900417e-11, -5.787694424813899e-13,  4.801775170951850e-15, -3.806913048399077e-17,
  2.914012241407082e-19, -2.149283397610339e-21,  1.552377330290366e-23, -1.078618490855958e-25,  2.035451539776685e-03, -2.613566092760610e-05,  3.712858898880976e-07,
 -4.327026269909787e-09,  4.602233217607784e-11, -4.545678301798231e-13,  4.233486765545027e-15, -3.750085483360582e-17,  3.188700539470205e-19, -2.608970838093046e-21,
  2.073018978761557e-23, -1.592964437988770e-25,  6.007366722054918e-04, -9.801738148754087e-06,  1.602415869459436e-07, -2.136691331594499e-09,  2.574593297067526e-11,
 -2.857235209928844e-13,  2.970779533349590e-15, -2.924219179867216e-17,  2.749498112420100e-19, -2.481153673631231e-21,  2.163179360800728e-23, -1.823950979141450e-25,
  1.476479188101993e-04, -3.019694347859746e-06,  5.649300081358274e-08, -8.585416256237997e-10,  1.166212062360466e-11, -1.447859046949392e-13,  1.673991358995796e-15,
 -1.823815721557273e-17,  1.889773544252522e-19, -1.873534580950865e-21,  1.787664585473533e-23, -1.646716059189385e-25,  3.011210671414087e-05, -7.626376692788613e-07,
  1.628653356506878e-08, -2.811990397972994e-10,  4.291164559787190e-12, -5.941785278101440e-14,  7.617818979682208e-16, -9.161229090243538e-18,  1.043517650197095e-19,
 -1.133612578964164e-21,  1.181336515583180e-23, -1.185665556942570e-25,  5.075355102118360e-06, -1.575349110609036e-07,  3.837598164240015e-09, -7.509750743439270e-11,
  1.284594574728570e-12, -1.979912644963402e-14,  2.809651838781427e-16, -3.723049033399483e-18,  4.654338772727438e-20, -5.531105204216088e-22,  6.286101279765036e-24,
 -6.863147381293775e-26,  7.037848158828357e-07, -2.654275718154861e-08,  7.378442600440169e-10, -1.634001031850330e-11,  3.129422271225102e-13, -5.363210446338802e-15,
  8.415908884807537e-17, -1.227610462728236e-18,  1.682891957807941e-20, -2.185830431944018e-22,  2.707091131541472e-24, -3.212399314012419e-26,  7.989357171721540e-08,
 -3.635888531990124e-09,  1.154649280618117e-10, -2.891984432608700e-12,  6.199752223943845e-14, -1.181191056273131e-15,  2.049199381078620e-17, -3.289847746416956e-19,
  4.944649638558238e-21, -7.018134651788672e-23,  9.470078170159369e-25, -1.221177377559001e-26,  7.385592863947683e-09, -4.034246589551308e-10,  1.466110335703985e-11,
 -4.154414739605115e-13,  9.975230553812798e-15, -2.113997074788247e-16,  4.056967336575007e-18, -7.172262262720566e-20,  1.182499151963710e-21, -1.834919197650458e-23,
  2.698907471361134e-25, -3.783435714795323e-27,  5.529589122136519e-10, -3.611450806930416e-11,  1.505359635689216e-12, -4.831985843628953e-14,  1.301381108692964e-15,
 -3.071965124039729e-17,  6.530055243199812e-19, -1.272843162023314e-20,  2.304716103576457e-22, -3.914238035953436e-24,  6.282253308551694e-26, -9.583314598646678e-28,
  3.335322858500657e-11, -2.598283407957654e-12,  1.245804456191077e-13, -4.539768727935770e-15,  1.374604886132302e-16, -3.622163022468632e-18,  8.546258977899733e-20,
 -1.840323865185001e-21,  3.666458266747802e-23, -6.827449938715448e-25,  1.197708793790177e-26, -1.991308090826962e-28,  1.613436897956706e-12, -1.497605078694264e-13,
  8.289091669115952e-15, -3.440070798090196e-16,  1.174794028742880e-17, -3.466160204255174e-19,  9.103704236285848e-21, -2.171622334528362e-22,  4.772777201850254e-24,
 -9.768515264226025e-26,  1.877378823231443e-27, -3.409369267819508e-29,  6.242471066903470e-14, -6.905567538511545e-15,  4.431217321024632e-16, -2.103166144703106e-17,
  8.134119624990481e-19, -2.697766590896422e-20,  7.916970664044844e-22, -2.099468372704346e-23,  5.107194052791448e-25, -1.152541191216369e-26,  2.433912210575428e-28,
 -4.841493158218679e-30,  1.933727372492091e-15, -2.553062268628159e-16,  1.909059647142068e-17, -1.041638111617935e-18,  4.585782542135420e-20, -1.718033857345928e-21,
  5.659511667671830e-23, -1.675749039277054e-24,  4.530592274170670e-26, -1.131692161705140e-27,  2.635633797365838e-29, -5.762288387037765e-31,  4.835577758886622e-17,
 -7.638408748201591e-18,  6.695124375926483e-19, -4.225534744816415e-20,  2.130433881184570e-21, -9.068261291257404e-23,  3.371643829889625e-24, -1.120443355138904e-25,
  3.383065669325615e-27, -9.396204522412958e-29,  2.423598561131148e-30, -5.846846224356800e-32,  9.977314825398222e-19, -1.891289940589112e-19,  1.955739455072985e-20,
 -1.437654007392723e-21,  8.357574418835470e-23, -4.068106558227033e-24,  1.717664832105383e-25, -6.443089041515172e-27,  2.184290780203668e-28, -6.779209550701212e-30,
  1.945537001243624e-31, -5.201070205539226e-33,  1.780837663233452e-20, -4.060950316195111e-21,  4.985070964783484e-22, -4.297572351311974e-23,  2.900394566829657e-24,
 -1.625024943975640e-25,  7.839556383435007e-27, -3.338242624201221e-28,  1.277310718581150e-29, -4.451074062410237e-31,  1.427457764362161e-32, -4.245246926708168e-34,
  3.020136138260776e-22, -8.281092386662461e-23,  1.211504807012150e-23, -1.230927298143713e-24,  9.693309074940895e-26, -6.281488596804444e-27,  3.477839570083116e-28,
 -1.687882745078303e-29,  7.315002430593264e-31, -2.870837989419921e-32,  1.031504133485115e-33, -3.419918405859334e-35,  5.791956355775278e-24, -1.893842583875315e-24,
  3.291903709494798e-25, -3.936085683003083e-26,  3.613123404536932e-27, -2.705560551760362e-28,  1.717301073442853e-29, -9.486279951504768e-31,  4.648720724362397e-32,
 -2.050584684299926e-33,  8.235291428019902e-35, -3.035604776802321e-36,  1.669497881928391e-25, -6.350944630525939e-26,  1.286503399947961e-26, -1.779766861297380e-27,
  1.874810731274068e-28, -1.598345382393630e-29,  1.146553033994991e-30, -7.109158145931538e-32,  3.885976057111177e-33, -1.900934693202558e-34,  8.420865565582712e-36,
 -3.406090647465178e-37,  9.450175221327410e-27, -3.973944200137140e-27,  8.937479953059409e-28, -1.367072189659349e-28,  1.583555691801914e-29, -1.476343391624898e-30,
  1.152006056461747e-31, -7.731648024659695e-33,  4.553523485915991e-34, -2.389751897918442e-35,  1.131251411266635e-36, -4.870900354114139e-38,  7.498578172780407e-02,
 -2.324448026221488e-04,  7.461322532929807e-07, -2.476208752977630e-09,  8.338555303054188e-12, -2.955124365111002e-14,  9.329374362976479e-17, -4.662490904312776e-19,
 -3.319913257410112e-22, -2.614388044104599e-23, -2.265799316320353e-25, -1.428433159238807e-27,  6.309750647316111e-02, -2.211654300805092e-04,  9.676950300044182e-07,
 -4.558686408448957e-09,  2.150184863011787e-11, -1.003705881735293e-13,  4.525830933756128e-16, -2.104270164572537e-18,  8.247656052024112e-21, -5.049343534942374e-23,
  4.927649168646109e-26, -1.388179091501858e-27,  4.465662315743134e-02, -1.930005195147216e-04,  1.191671355206572e-06, -7.275229581274821e-09,  4.225767581708639e-11,
 -2.358016442572299e-13,  1.278155052995415e-15, -6.740080322796801e-18,  3.509342914083581e-20, -1.753813097072366e-22,  9.139124376183354e-25, -4.183598166902667e-27,
  2.655904329914485e-02, -1.477387442740670e-04,  1.200205847343275e-06, -8.801192221227902e-09,  6.017940468188658e-11, -3.917951059322011e-13,  2.465512965536971e-15,
 -1.493907581435946e-17,  8.952831101376671e-20, -5.046055770431281e-22,  3.023904716308093e-24, -1.558901470009944e-26,  1.325580198724676e-02, -9.606390629878738e-05,
  9.643392659504907e-07, -8.249538964610809e-09,  6.537667796742172e-11, -4.898224052413562e-13,  3.518686903706660e-15, -2.423435945698865e-17,  1.631915207745569e-19,
 -1.047051134035874e-21,  6.816354840055529e-24, -4.101596670997673e-26,  5.542135868300440e-03, -5.210641204808151e-05,  6.212854642663143e-07, -6.129121114386392e-09,
  5.573845902056276e-11, -4.753317872818228e-13,  3.855558930970412e-15, -2.987112722749809e-17,  2.241492958612356e-19, -1.613644284420904e-21,  1.147601305632952e-23,
 -7.790149522203168e-26,  1.936537421044176e-03, -2.336120976399199e-05,  3.234966581665577e-07, -3.658216662725106e-09,  3.786757102539699e-11, -3.644927857302964e-13,
  3.313263148771375e-15, -2.865250399584857e-17,  2.383263815503589e-19, -1.904542891460354e-21,  1.483841828855535e-23, -1.115143754265585e-25,  5.639405404100691e-04,
 -8.615774187599250e-06,  1.368961517983406e-07, -1.766859770728097e-09,  2.068293693683284e-11, -2.233328992649978e-13,  2.262853213760363e-15, -2.172046334712128e-17,
  1.994462456503605e-19, -1.757294929213171e-21,  1.498840068373240e-23, -1.235684751564264e-25,  1.364119852417370e-04, -2.605994949800303e-06,  4.722113066371907e-08,
 -6.930926411309086e-10,  9.130080365748160e-12, -1.101125072536035e-13,  1.238752803823198e-15, -1.314505002504810e-17,  1.328281026678530e-19, -1.284766768611088e-21,
  1.197476360450445e-23, -1.077761381814855e-25,  2.730230581360163e-05, -6.447600262378538e-07,  1.328787591666973e-08, -2.211347786799149e-10,  3.266658711700817e-12,
 -4.387060796996836e-14,  5.464775152435837e-16, -6.393042571516606e-18,  7.092441857347501e-20, -7.509826698293022e-22,  7.635561671279187e-24, -7.481362372877200e-26,
  4.501366022445901e-06, -1.301172751526793e-07,  3.047778490879709e-09, -5.737811105061600e-11,  9.483974210067890e-13, -1.415540501838334e-14,  1.948923676189723e-16,
 -2.509071174489601e-18,  3.051338179536058e-20, -3.530810222796363e-22,  3.911010780538342e-24, -4.164825546531337e-26,  6.082877088126536e-07, -2.134669627249740e-08,
  5.685928726874044e-10, -1.209198322111947e-11,  2.233781396952582e-13, -3.701602975341521e-15,  5.627676646358316e-17, -7.965730750444899e-19,  1.061054848364827e-20,
 -1.340559757339735e-22,  1.616559703553624e-24, -1.869408885587036e-26,  6.699930673644427e-08, -2.835757175656884e-09,  8.601200547717113e-11, -2.065130864469406e-12,
  4.262901571622006e-14, -7.841392169123143e-16,  1.316241118292128e-17, -2.048052882661354e-19,  2.987693390517108e-21, -4.120765096075303e-23,  5.409107856500464e-25,
 -6.791584215554875e-27,  5.978344678482037e-09, -3.036538196078896e-10,  1.050934447028806e-11, -2.849844680167056e-13,  6.577997548852595e-15, -1.343985883342393e-16,
  2.492347820693258e-18, -4.265543702683938e-20,  6.818611504419438e-22, -1.027197673027032e-23,  1.468458436257937e-25, -2.002793184283512e-27,  4.293587946332950e-10,
 -2.607871614917324e-11,  1.032638924394702e-12, -3.166907888090277e-14,  8.186530129425155e-16, -1.860559420760856e-17,  3.817090964548738e-19, -7.194961714673307e-21,
  1.261886981533128e-22, -2.078774472810570e-24,  3.240138388900198e-26, -4.805360884453472e-28,  2.465470212623095e-11, -1.787019351011512e-12,  8.122709056170170e-14,
 -2.823899866654704e-15,  8.195401190547938e-17, -2.076615574971501e-18,  4.723588313548023e-20, -9.826515510482092e-22,  1.894601440835033e-23, -3.419356644679316e-25,
  5.821291942189090e-27, -9.403676139231488e-29,  1.124778373666393e-12, -9.722353770650679e-14,  5.093513542044779e-15, -2.014213018276042e-16,  6.585066948527423e-18,
 -1.866309401978702e-19,  4.721189188965293e-21, -1.087087853850351e-22,  2.310457779152714e-24, -4.580263154888401e-26,  8.537924534618624e-28, -1.505761084244007e-29,
  4.055965074783675e-14, -4.184036765756537e-15,  2.538925575043206e-16, -1.147209118340164e-17,  4.243825652699931e-19, -1.350964834709481e-20,  3.815869812598989e-22,
 -9.761769212611571e-24,  2.295221779582767e-25, -5.014723619697794e-27,  1.026789483176546e-28, -1.982978652073292e-30,  1.153473901583175e-15, -1.423074058234835e-16,
  1.006102704758613e-17, -5.224233111648954e-19,  2.198932534912649e-20, -7.904118163498423e-22,  2.505260998784375e-23, -7.154126821382947e-25,  1.869162122016863e-26,
 -4.519823607626691e-28,  1.020581153913875e-29, -2.166373884351225e-31,  2.596974068393479e-17, -3.844884082155350e-18,  3.189007849662346e-19, -1.916189961624065e-20,
  9.239066198100361e-22, -3.774017166908174e-23,  1.350446812620346e-24, -4.329321677715727e-26,  1.263649056761077e-27, -3.398869097946810e-29,  8.503545190792576e-31,
 -1.992735537369446e-32,  4.703330725599221e-19, -8.392838849978555e-20,  8.230635622255921e-21, -5.769205395035956e-22,  3.211469944591058e-23, -1.501900140901904e-24,
  6.109787844734714e-26, -2.213365146796058e-27,  7.261652307225868e-29, -2.185031535879738e-30,  6.089387272970239e-32, -1.583167996753913e-33,  7.130419682995395e-21,
 -1.540368420521049e-21,  1.800684398161058e-22, -1.485112067155316e-23,  9.624899585187698e-25, -5.194657652216890e-26,  2.420436381426838e-27, -9.977352607182292e-29,
  3.703021372007323e-30, -1.253878658118633e-31,  3.913575808071504e-33, -1.134410507861907e-34,  9.862192922289489e-23, -2.585045738159439e-23,  3.626285630471803e-24,
 -3.545432855144600e-25,  2.695047162282311e-26, -1.690379526119946e-27,  9.079741089385556e-29, -4.283889559035027e-30,  1.808134114002877e-31, -6.922283872214679e-33,
  2.429801536145758e-34, -7.880713009703393e-36,  1.477776701917564e-24, -4.676498618257377e-25,  7.875936122766607e-26, -9.145616845667258e-27,  8.171599535746789e-28,
 -5.968187903960316e-29,  3.701527955908052e-30, -2.001165849320934e-31,  9.611766682226570e-33, -4.160998939794587e-34,  1.641960924523246e-35, -5.953527086986014e-37,
  3.254992980784658e-26, -1.216227253934823e-26,  2.419702844663236e-27, -3.291353934678488e-28,  3.413197439856968e-29, -2.867944251435407e-30,  2.029790677032873e-31,
 -1.242940838407480e-32,  6.715623823434895e-34, -3.249757464095533e-35,  1.425116364487181e-36, -5.710232191249179e-38,  1.481284140150098e-27, -6.196482141731008e-28,
  1.385970736158327e-28, -2.108877370277171e-29,  2.430817637220452e-30, -2.255818982851101e-31,  1.752670823100111e-32, -1.171568124715500e-33,  6.873916178051622e-35,
 -3.594782863461978e-36,  1.696038392304521e-37, -7.280007247878493e-39,  7.406775558525609e-02, -2.265923786785764e-04,  7.171991276126565e-07, -2.347402884132946e-09,
  7.768853344748758e-12, -2.747098873162731e-14,  7.993549467320451e-17, -4.937759770422395e-19, -1.446964327851301e-21, -3.592562320552246e-23, -2.430839649007385e-25,
  1.289514507120805e-27,  6.222798947343052e-02, -2.136369871116135e-04,  9.149905842029720e-07, -4.230145473611728e-09,  1.959843136992255e-11, -9.018747385750692e-14,
  3.970873094022420e-16, -1.869151411806923e-18,  6.453370244216238e-21, -4.942278082559743e-23,  1.525046232338719e-26,  1.470493695928107e-28,  4.390315067127139e-02,
 -1.838052135046605e-04,  1.108274936966207e-06, -6.635230271924674e-09,  3.783374560315324e-11, -2.072692823985794e-13,  1.104253788734988e-15, -5.711399639559430e-18,
  2.939563004444032e-20, -1.422642910920456e-22,  7.469255354255077e-25, -3.503432015727302e-27,  2.598664507420961e-02, -1.385437612477490e-04,  1.100120218067383e-06,
 -7.897930537031217e-09,  5.290294866391449e-11, -3.373345725287635e-13,  2.084755563316322e-15, -1.234276012290577e-17,  7.338328752595648e-20, -3.964286157632120e-22,
  2.403580396397627e-24, -1.304816860540082e-26,  1.288637298459016e-02, -8.872810340860725e-05,  8.713119338415605e-07, -7.277515857004280e-09,  5.637265969847701e-11,
 -4.129595953677782e-13,  2.907923669950240e-15, -1.956604976027022e-17,  1.299990578653031e-19, -8.074254260817031e-22,  5.232060300725059e-24, -3.180552872736774e-26,
  5.343205464827938e-03, -4.741585648150993e-05,  5.527887265169382e-07, -5.308601655630105e-09,  4.709338185157672e-11, -3.920752149600815e-13,  3.111448049392099e-15,
 -2.354550850620270e-17,  1.735564210890150e-19, -1.216506901092652e-21,  8.530187804611191e-24, -5.737222643264095e-26,  1.848004348535961e-03, -2.093905817218223e-05,
  2.830060653392121e-07, -3.106591917094883e-09,  3.131211377859558e-11, -2.937994060261726e-13,  2.608220195024074e-15, -2.201747408450167e-17,  1.793613237091163e-19,
 -1.398639177396259e-21,  1.069307476197706e-23, -7.900120444753572e-26,  5.315410183917859e-04, -7.600109754855358e-06,  1.175410197606213e-07, -1.468909796647467e-09,
  1.671359517146637e-11, -1.756558666288352e-13,  1.735288915618400e-15, -1.624452842137904e-17,  1.457823713653045e-19, -1.253843849812959e-21,  1.046759927018083e-23,
 -8.454812367862071e-26,  1.266941662799177e-04, -2.259168433701354e-06,  3.971274266297896e-08, -5.631310389833819e-10,  7.197630196771879e-12, -8.435851753630286e-14,
  9.238542628632342e-16, -9.550668749569557e-18,  9.416629974968781e-20, -8.886898342074845e-22,  8.094320693889238e-24, -7.124374519398153e-26,  2.492023744504163e-05,
 -5.482452951507217e-07,  1.092105568140818e-08, -1.752314780159641e-10,  2.507128357261127e-12, -3.266976946749510e-14,  3.955678581952756e-16, -4.502966235354191e-18,
  4.867630104536512e-20, -5.024783117883797e-22,  4.986271527951406e-24, -4.771796405104833e-26,  4.025638402743515e-06, -1.082512085635117e-07,  2.441707173290708e-09,
 -4.423651922508677e-11,  7.068969736915254e-13, -1.022144765543421e-14,  1.365936444553816e-16, -1.709077230095748e-18,  2.022647246316756e-20, -2.279565533027898e-22,
  2.461750494507826e-24, -2.557810625568813e-26,  5.311583359533244e-07, -1.732279432290421e-08,  4.427088554280041e-10, -9.043750677173698e-12,  1.612267489878245e-13,
 -2.584291265864014e-15,  3.808118857477598e-17, -5.232205445560919e-19,  6.774211021972444e-21, -8.327524745266860e-23,  9.780511218779418e-25, -1.102508373545253e-26,
  5.689044784237843e-08, -2.236281648029979e-09,  6.485599169999570e-11, -1.493136677968337e-12,  2.969122952949352e-14, -5.274871545498614e-16,  8.570031692318849e-18,
 -1.292807721164137e-19,  1.831015473646556e-21, -2.454722164232242e-23,  3.135260208387673e-25, -3.833910068052574e-27,  4.912501046388975e-09, -2.316541236380133e-10,
  7.641831653067513e-12, -1.983559896561077e-13,  4.402874356090157e-15, -8.675390719197229e-17,  1.555060336704758e-18, -2.577140439172561e-20,  3.995250923916474e-22,
 -5.844410945641508e-24,  8.122218195700001e-26, -1.077973801497213e-27,  3.394400753094233e-10, -1.914040313431915e-11,  7.203641512975130e-13, -2.111086900933914e-14,
  5.239274766048172e-16, -1.146691716791587e-17,  2.271017466634980e-19, -4.140392558579877e-21,  7.034990300103635e-23, -1.124293773727299e-24,  1.702116995402465e-26,
 -2.454554719214283e-28,  1.861940347347314e-11, -1.253256502113851e-12,  5.401395294008153e-14, -1.791552207961407e-15,  4.984072144222972e-17, -1.214563889467011e-18,
  2.663781093065868e-20, -5.354077616205096e-22,  9.991099674159514e-24, -1.747805507800749e-25,  2.887906928923658e-27, -4.532935118563027e-29,  8.042718523436869e-13,
 -6.460078365513622e-14,  3.202885981017264e-15, -1.206667776677862e-16,  3.776459778778065e-18, -1.028104147789584e-19,  2.504961441338231e-21, -5.567488884926599e-23,
  1.144288634117012e-24, -2.197132052921568e-26,  3.972337398306707e-28, -6.803256100903421e-30,  2.715336936328142e-14, -2.605833875412325e-15,  1.494415090016664e-16,
 -6.425812823583699e-18,  2.273033122221251e-19, -6.943754764201675e-21,  1.887390735578278e-22, -4.657052074848999e-24,  1.058188104317330e-25, -2.238034383659365e-27,
  4.442422364151762e-29, -8.328171949353070e-31,  7.126077708143703e-16, -8.193306006628802e-17,  5.471020321309753e-18, -2.701542637883294e-19,  1.086561549346791e-20,
 -3.745587847114573e-22,  1.141818100051037e-23, -3.143504087015619e-25,  7.934103684216204e-27, -1.856644351825657e-28,  4.063338918551170e-30, -8.371548879438656e-32,
  1.452772414408043e-17, -2.009826864656755e-18,  1.574930403184978e-19, -8.999253054604901e-21,  4.145743048245934e-22, -1.623900670291463e-23,  5.588403882524153e-25,
 -1.727222610241951e-26,  4.870605146710633e-28, -1.267978335097704e-29,  3.075386732839981e-31, -6.996974853648573e-33,  2.323300090349148e-19, -3.889377750687130e-20,
  3.609479211302931e-21, -2.408538798346624e-22,  1.282076752531168e-23, -5.753927444524818e-25,  2.252835335072884e-26, -7.874209569738966e-28,  2.497834955284197e-29,
 -7.280658256216785e-31,  1.968753114618184e-32, -4.974036022757722e-34,  3.007911804350538e-21, -6.132252617173109e-22,  6.807952332375896e-23, -5.359875786036169e-24,
  3.329542281609598e-25, -1.728183424070968e-26,  7.765854016378587e-28, -3.094691165059650e-29,  1.112690342153824e-30, -3.656733720193911e-32,  1.109555989498588e-33,
 -3.131447697373372e-35,  3.402580153059411e-23, -8.491105023918666e-24,  1.138452605195113e-24, -1.068188696343021e-25,  7.819556771137654e-27, -4.737180137465090e-28,
  2.463945772335438e-29, -1.128177755272997e-30,  4.630171556240014e-32, -1.726616452491550e-33,  5.912531874824574e-35, -1.873492016219236e-36,  3.968503180872450e-25,
 -1.210757770787387e-25,  1.969142001605014e-26, -2.214259090046758e-27,  1.920836730058140e-28, -1.365194039724616e-29,  8.256277143847933e-31, -4.360333891629453e-32,
  2.049134900022761e-33, -8.692028724854685e-35,  3.365171347418916e-36, -1.198578327668873e-37,  6.577087181635874e-27, -2.407383131706283e-27,  4.692266208047283e-28,
 -6.261565785704435e-29,  6.379559356997649e-30, -5.273655715855563e-31,  3.676548359423601e-32, -2.220090905518556e-33,  1.184059602917151e-34, -5.661070417041233e-36,
  2.454792767105720e-37, -9.733509025561894e-39,  2.350966864567813e-28, -9.774945645750458e-29,  2.172579445859400e-29, -3.285939650673257e-30,  3.766311771150758e-31,
 -3.476889930120534e-32,  2.688229637578226e-33, -1.788779407215232e-34,  1.045076845767961e-35, -5.443665128148561e-37,  2.558813726077653e-38, -1.094518368122897e-39,
  7.317268578297631e-02, -2.209653889704684e-04,  6.897582966137501e-07, -2.227397163739210e-09,  7.237465862759507e-12, -2.572493533723371e-14,  6.525486189324352e-17,
 -5.624332652946437e-19, -2.885191242685443e-21, -4.260941056115040e-23, -3.084201672653119e-26,  9.640527195608721e-27,  6.138776723246921e-02, -2.065149124549385e-04,
  8.660523938396269e-07, -3.930500161153596e-09,  1.788585725505446e-11, -8.126371641436666e-14,  3.473758819577146e-16, -1.690925402341612e-18,  4.695384835807240e-21,
 -4.767888832265517e-23,  1.033636739905284e-25,  4.499141703551389e-27,  4.318517206299868e-02, -1.752475202396314e-04,  1.032151935833008e-06, -6.061665999319104e-09,
  3.394095740117394e-11, -1.825844606560616e-13,  9.567732916805920e-16, -4.847215112682035e-18,  2.477526367007714e-20, -1.154268664629756e-22,  5.943343562415167e-25,
 -3.595486353589956e-27,  2.544949137026031e-02, -1.301080062179981e-04,  1.010209589961079e-06, -7.102851260396079e-09,  4.662992292429427e-11, -2.911948034423397e-13,
  1.770014358323485e-15, -1.020539670477003e-17,  6.070503571419615e-20, -3.117174907778365e-22,  1.825950786297982e-24, -1.390647765934329e-26,  1.254486932016768e-02,
 -8.209219928980293e-05,  7.891327593089646e-07, -6.438013046506260e-09,  4.876931416713024e-11, -3.492990233573821e-13,  2.414216696978997e-15, -1.583340095886216e-17,
  1.043765831929019e-19, -6.245614014997175e-22,  3.939750982724355e-24, -2.790007183487500e-26,  5.162000534841272e-03, -4.323612081184989e-05,  4.933602580502617e-07,
 -4.613995610548561e-09,  3.994830377145767e-11, -3.247224013351822e-13,  2.523785583352193e-15, -1.863122822884416e-17,  1.353355933681256e-19, -9.214920328960844e-22,
  6.313573532496554e-24, -4.459467457854323e-26,  1.768551573604811e-03, -1.881603464002478e-05,  2.485494888975634e-07, -2.649403388413972e-09,  2.601532758192440e-11,
 -2.379951552450948e-13,  2.065066683732549e-15, -1.700734102037891e-17,  1.359370266160038e-19, -1.033389238856753e-21,  7.726627682504563e-24, -5.737696536580167e-26,
  5.029156821767999e-04, -6.725996195707793e-06,  1.014096034926897e-07, -1.227480066846454e-09,  1.358266195153831e-11, -1.389789343277825e-13,  1.339503381342894e-15,
 -1.222765462371518e-17,  1.073620522496724e-19, -9.011437330981373e-22,  7.355260417284858e-24, -5.869124849138579e-26,  1.182527026414111e-04, -1.966659852682024e-06,
  3.359413396398221e-08, -4.603467667570038e-10,  5.712165961732265e-12, -6.508200476091001e-14,  6.942248109574987e-16, -6.992399496396851e-18,  6.731744660157015e-20,
 -6.199094697853122e-22,  5.516149877641457e-24, -4.763218953257416e-26,  2.288957680656558e-05, -4.686525292011222e-07,  9.038961148905791e-09, -1.398686697870612e-10,
  1.939299964883634e-12, -2.452855742269693e-14,  2.888247437650600e-16, -3.200019878292963e-18,  3.372296194426281e-20, -3.394535896549170e-22,  3.287942401655166e-24,
 -3.077308563033037e-26,  3.628591237681307e-06, -9.066308325390846e-08,  1.972520380035109e-09, -3.439852656586373e-11,  5.317224328834049e-13, -7.451265260912633e-15,
  9.669097487575465e-17, -1.176130453452721e-18,  1.355113507870752e-20, -1.487889465319103e-22,  1.566866129598650e-24, -1.589465613950202e-26,  4.683202856937649e-07,
 -1.417499839039167e-08,  3.481042163889048e-10, -6.832524781981487e-12,  1.176094989235768e-13, -1.824171170419674e-15,  2.606396950688032e-17, -3.477182487204896e-19,
  4.377422220566635e-21, -5.237281940054264e-23,  5.992380893941979e-25, -6.587113887627961e-27,  4.887996762299436e-08, -1.781763096140852e-09,  4.947367056963870e-11,
 -1.092420931209152e-12,  2.093612902404837e-14, -3.593613040726557e-16,  5.653132534552212e-18, -8.270248364444539e-20,  1.137563704796250e-21, -1.482760013412355e-23,
  1.843196056154948e-25, -2.195754078934611e-27,  4.094610878664339e-09, -1.789627880803112e-10,  5.632933893103322e-12, -1.399844652012184e-13,  2.989277320022118e-15,
 -5.682105907520798e-17,  9.848033649901581e-19, -1.580828688330338e-20,  2.377338663147179e-22, -3.377763085112964e-24,  4.564395576080386e-26, -5.896163214752192e-28,
  2.729802769477687e-10, -1.426398770797661e-11,  5.106242314189504e-13, -1.430187195265054e-14,  3.408747063890323e-16, -7.186437225425905e-18,  1.374300511894056e-19,
 -2.423955990736195e-21,  3.990871779475071e-23, -6.188635976142215e-25,  9.101889592973613e-27, -1.276451331891386e-28,  1.435140388368874e-11, -8.952260722665570e-13,
  3.659843127583641e-14, -1.158209614384772e-15,  3.089287573518223e-17, -7.241294218767330e-19,  1.531538011986062e-20, -2.974651916410407e-22,  5.373203798114641e-24,
 -9.112080307714329e-26,  1.461393994281808e-27, -2.229052865551124e-29,  5.892121965375749e-13, -4.387991246084990e-14,  2.058863407717629e-15, -7.389058771813061e-17,
  2.213811826917230e-18, -5.789451035077393e-20,  1.358679380399076e-21, -2.914992789119646e-23,  5.793895383828219e-25, -1.077529340629873e-26,  1.889523023711963e-28,
 -3.142605835235560e-30,  1.870788104772055e-14, -1.666064958492642e-15,  9.026079975296227e-17, -3.692141521833182e-18,  1.248645738042483e-19, -3.659898771176998e-21,
  9.572039324617786e-23, -2.277833091213848e-24,  5.001315710236811e-26, -1.023820247943569e-27,  1.969915578528828e-29, -3.584428800655404e-31,  4.554078598094492e-16,
 -4.866245497848843e-17,  3.066202709523986e-18, -1.438903124959730e-19,  5.527497217234014e-21, -1.826648051115358e-22,  5.353853974969310e-24, -1.420581572111475e-25,
  3.462737866157426e-27, -7.839472872178435e-29,  1.662461616365614e-30, -3.323486902774523e-32,  8.456118052759542e-18, -1.089735441985687e-18,  8.056062141994108e-20,
 -4.372995330438433e-21,  1.923219312867534e-22, -7.218857969861850e-24,  2.387737435196456e-25, -7.110863645888501e-27,  1.936231209659598e-28, -4.876296561900866e-30,
  1.146017446528394e-31, -2.530224785126941e-33,  1.201735632469608e-19, -1.880696960959554e-20,  1.648273124354162e-21, -1.045428541931582e-22,  5.314713679118634e-24,
 -2.286497479235124e-25,  8.607817463047079e-27, -2.900238622612692e-28,  8.887992075904689e-30, -2.507576181413098e-31,  6.574373721734831e-33, -1.612961181345725e-34,
  1.336954262437828e-21, -2.562035844177910e-22,  2.693937521272516e-23, -2.020287263371655e-24,  1.200753171581091e-25, -5.984374004525547e-27,  2.589792615553687e-28,
 -9.964043183884052e-30,  3.466452860925436e-31, -1.104417641415344e-32,  3.254342644846845e-34, -8.933423032112830e-36,  1.242175708689462e-23, -2.938404422319969e-24,
  3.752988999089700e-25, -3.370110978643369e-26,  2.370217245175357e-27, -1.384000831220113e-28,  6.957437746473181e-30, -3.086223958117397e-31,  1.229650490042150e-32,
 -4.459806443806879e-34,  1.487806060873441e-35, -4.599816860794965e-37,  1.125469627975241e-25, -3.296319828458776e-26,  5.158598333925625e-27, -5.599968789572495e-28,
  4.703707552328214e-29, -3.245370881235171e-30,  1.909673942100481e-31, -9.832550814379743e-33,  4.512912947735213e-34, -1.872553467343844e-35,  7.101740436241880e-37,
 -2.481093179008500e-38,  1.383079346360285e-27, -4.943624350016672e-28,  9.413004397869059e-29, -1.229164242233459e-29,  1.227588921858371e-30, -9.963290603198365e-32,
  6.829415327222304e-33, -4.059985678235232e-34,  2.134216206874875e-35, -1.006757322354049e-36,  4.311307220139801e-38, -1.689705257547569e-39,  3.785160804357765e-29,
 -1.562679347916802e-29,  3.447829339597813e-30, -5.178643444220023e-31,  5.897485828914486e-32, -5.411760625980814e-33,  4.161014106814993e-34, -2.754524831438325e-35,
  1.601590265287811e-36, -8.305192310192709e-38,  3.887594029184990e-39, -1.656421447172600e-40,  };
  int offset = -26;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 26;
    if (std::isnan(t)) {
      fill_n(rr+offset, 26, 0.5);
      fill_n(ww+offset, 26, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 26; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=26; ++j) {
        const int boxof = it*312+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
