program MySQLWorkbench;

{$R '..\..\res\windows\mysqlwb.res' '..\..\res\windows\mysqlwb.rc'}
{$R '..\..\..\common\res\windows\mysqlcommon.res' '..\..\..\common\res\windows\mysqlcommon.rc'}
{$R '..\..\..\common\res\windows\WindowsXP.res' '..\..\..\common\res\windows\WindowsXP.rc'}
{%File '..\..\PrepareApplicationFolder.cmd'}

uses
  gnugettext in '..\..\..\common\source\windows\gnugettext.pas',
  TntForms,
  Forms,
  Main in 'Main.pas' {MainForm},
  AuxFuncs in '..\..\..\common\source\windows\AuxFuncs.pas',
  AuxApplicationFuncs in '..\..\..\common\source\windows\AuxApplicationFuncs.pas',
  CommonFuncs in '..\..\..\common\source\windows\CommonFuncs.pas',
  MyxError in '..\..\..\common\source\windows\MyxError.pas',
  MyxBaseForm in '..\..\..\common\source\windows\MyxBaseForm.pas',
  MyxTabHeader in '..\..\..\common\source\windows\MyxTabHeader.pas' {MyxTabHeaderFrame: TFrame},
  MySQLConnection in '..\..\..\common\source\windows\MySQLConnection.pas',
  About in '..\..\..\common\source\windows\About.pas' {AboutForm},
  UniCodeEditor in '..\..\..\common\source\windows\UniCodeEditor\Source\UniCodeEditor.pas',
  Toolbar in '..\..\..\common\source\windows\Toolbar.pas',
  Grt in '..\..\..\common\source\windows\Grt.pas',
  GrtObjectTree in '..\..\..\common\source\windows\GrtObjectTree.pas',
  XGrtShell in '..\..\..\common\source\windows\xgrtsh\XGrtShell.pas' {XGrtShellForm: TTntForm},
  GrtForms in '..\..\..\common\source\windows\GrtForms.pas',
  MyxOptions in '..\..\..\common\source\windows\MyxOptions.pas',
  MyxAppOptions in 'MyxAppOptions.pas',
  AppInstanceMgmt in '..\..\..\common\source\windows\AppInstanceMgmt.pas',
  MyxConnectionDialog in '..\..\..\common\source\windows\MyxConnectionDialog.pas' {MyxConnectionDialogForm: TTntForm},
  ReverseEngineering in 'ReverseEngineering.pas' {ReverseEngineeringForm},
  MigrationObjSelFilter in '..\..\..\common\source\windows\MigrationObjSelFilter.pas' {MigrationObjSelFilterFrame: TFrame},
  MigrationObjMapDetail in '..\..\..\common\source\windows\MigrationObjMapDetail.pas' {MigrationObjMapDetailFrame: TFrame},
  AdvancedEdit in '..\..\..\common\source\windows\AdvancedEdit.pas' {AdvancedEditFrame: TTntFrame},
  MyxTableEditor in '..\..\..\common\source\windows\MyxTableEditor.pas' {MyxTableEditorForm},
  MyxTableEditorVTEdit in '..\..\..\common\source\windows\MyxTableEditorVTEdit.pas',
  MyxEditor in '..\..\..\common\source\windows\MyxEditor.pas',
  GrtWb in 'GrtWb.pas',
  MyxTableEditorIndexVTEdit in '..\..\..\common\source\windows\MyxTableEditorIndexVTEdit.pas',
  MyxTableEditorIndexColumnVTEdit in '..\..\..\common\source\windows\MyxTableEditorIndexColumnVTEdit.pas',
  MyxViewEditor in '..\..\..\common\source\windows\MyxViewEditor.pas' {MyxViewEditorForm},
  MyxSchemaEditor in '..\..\..\common\source\windows\MyxSchemaEditor.pas' {MyxSchemaEditorForm},
  MyxRoutineGroupEditor in '..\..\..\common\source\windows\MyxRoutineGroupEditor.pas' {MyxRoutineGroupEditorForm},
  MyxTableEditorFkVTEdit in '..\..\..\common\source\windows\MyxTableEditorFkVTEdit.pas',
  MyxTableEditorFkColumnVTEdit in '..\..\..\common\source\windows\MyxTableEditorFkColumnVTEdit.pas',
  LayerTree,
  MyxDbUtils in '..\..\..\common\source\windows\MyxDbUtils.pas',
  MyxRoutineEditorFrame in '..\..\..\common\source\windows\MyxRoutineEditorFrame.pas' {RoutineFrame: TFrame},
  DatabaseSynchronisation in 'DatabaseSynchronisation.pas' {DatabaseSynchronisationForm},
  ModelPrintSetup in 'ModelPrintSetup.pas' {ModelPrintSetupForm},
  PrintProgress in 'PrintProgress.pas' {ModelPrintForm},
  ModelProperties in 'ModelProperties.pas' {ModelPropertiesForm},
  myx_grt_builtin_module_public_interface in '..\..\..\common\library\public-interface\myx_grt_builtin_module_public_interface.pas',
  myx_grt_public_interface in '..\..\..\common\library\public-interface\myx_grt_public_interface.pas',
  myx_grt_wb_public_interface in '..\..\..\common\library\public-interface\myx_grt_wb_public_interface.pas',
  myx_public_interface in '..\..\..\common\library\public-interface\myx_public_interface.pas',
  myx_util_public_interface in '..\..\..\common\library\public-interface\myx_util_public_interface.pas',
  GenericCanvasViewer in '..\..\..\common\source\windows\GenericCanvasViewer\Source\GenericCanvasViewer.pas',
  myx_sql_parser_public_interface in '..\..\..\common\library\public-interface\myx_sql_parser_public_interface.pas';

{$R *.res}

var
  SplashScreen: TAboutForm;

begin
  // Mask out certain FPU exceptions, which the JVM is not capable to catch.
  Set8087CW($133F);
  
  // Add extra domain for runtime library translations
  AddDomainForResourceString('delphi');

  // Force program to use user defined instead of the current Windows settings
  UseLanguage('en'); //MYXCommonOptions.Language);

  InitThreads;

  //Application Title
  TntApplication.Title := 'MySQL Workbench';
  Application.Title := 'MySQL Workbench';
  Application.HelpFile := '';
  Application.Initialize;

  // Display splashscreen
  if (Not(GetBoolOptionFromCommandLine('nologo'))) then
    SplashScreen := ShowSplashScreen(TntApplication.Title)
  else
    SplashScreen := nil;

  Application.CreateForm(TMainForm, MainForm);
  if (MainForm.GrtInitialized) then
  begin
    MainForm.InitializeGui;
    if (SplashScreen <> nil) then
      SplashScreen.Close;

    RegisterApplication(Application, '');
    try
      Application.Run;
    finally
      UnregisterApplication(Application);
    end;

    // Store windows positions
    TMyxBaseForm.StoreWindowPositions;

    MainForm.FinalizeGui;
  end
  else
    if (SplashScreen <> nil) then
      SplashScreen.Close;

  // Store options
  if (CommonOptions <> nil) then
    CommonOptions.SaveToFile;
  if (AppOptions <> nil) then
    AppOptions.SaveToFile;

  // Shutdown the GRT
  RuntimeEnvironment.Free;
  MainForm.Free;
end.

