/*
 *	This is an example of a mixer program for Linux
 *
 *	updated 1/1/93 to add stereo, level query, broken
 *      	devmask kludge - cmetz@thor.tjhsst.edu 
 *
 * (C) Craig Metz and Hannu Savolainen 1993.
 *
 * You may do anything you wish with this program.
 */

#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <sys/soundcard.h>

char *names[SOUND_MIXER_NRDEVICES] = SOUND_DEVICE_NAMES;

int devmask = 0, recmask = 0, recsrc = 0;

void usage(void)
{
   int i, n = 0;
   printf("Usage: mixer [device] <port> [value] | +rec <port> | -rec <port>\n");
   printf("       <port>:= {");
   for (i = 0; i < SOUND_MIXER_NRDEVICES; i++) 
     if ((1 << i) & devmask)  {
	if (n)
	  putchar('|');
	printf(names[i]);
	n = 1;
     } 
   printf("}\n");
   exit(1);
}

void print_recsrc(void)
{
   int i, n = 0;
   fprintf(stderr, "Recording source: ");
   
   for (i = 0; i < SOUND_MIXER_NRDEVICES; i++)
     if ((1 << i) & recsrc) {
	if (n) fprintf(stderr, ", ");
	fprintf(stderr, names[i]);
	n = 1;
     }
   fprintf(stderr, "\n");
}

int main(int argc, char *argv[])
{
   int foo, bar, baz, dev, i=1;
   
   char name[30] = "/dev/mixer";

   if (argc>1) {
       if (strncmp(argv[1], "/dev/",5)==0) {
	  strcpy(name, argv[1]);
	  i++;
       } else if (strncmp(argv[1], "mixer",5)==0) {
	  strcpy(name, argv[1]);
	  i++;
       }
   }
   
   if ((baz = open(name, O_RDWR)) < 0) {
      perror(name);
      exit(1);
   }
   if (ioctl(baz, SOUND_MIXER_READ_DEVMASK, &devmask) == -1) {
      perror("SOUND_MIXER_READ_DEVMASK");
      exit(-1);
   }
   if (ioctl(baz, SOUND_MIXER_READ_RECMASK, &recmask) == -1) {
      perror("SOUND_MIXER_READ_RECMASK");
      exit(-1);
   }
   if (ioctl(baz, SOUND_MIXER_READ_RECSRC, &recsrc) == -1) {
      perror("SOUND_MIXER_READ_RECSRC");
      exit(-1);
   }

   if ((argc<2)||(argc<3)&&(i>1)) usage();

   printf("%s: ",argv[0]);

   while (i<argc)  {
      for (foo = 0; foo < SOUND_MIXER_NRDEVICES && strcmp(names[foo], argv[i]); foo++);
      if (foo >= SOUND_MIXER_NRDEVICES) {
	 if (!strcmp("+rec", argv[i]) || !strcmp("-rec", argv[i])) {
	    i++;
	    if (i>=argc) usage();
	    for (dev = 0; dev < SOUND_MIXER_NRDEVICES && strcmp(names[dev], argv[i]); dev++);
	    if (dev >= SOUND_MIXER_NRDEVICES) usage();

	    if (!((1 << dev) & recmask)) {
	       fprintf(stderr, "Invalid recording source %s\n", argv[i]);
	       exit(-1);
	    }
	    if (argv[i-1][0] == '+')
	      recsrc |= (1 << dev);
	    else
	      recsrc &= ~(1 << dev);
	 
	    if (ioctl(baz, SOUND_MIXER_WRITE_RECSRC, &recsrc) == -1) {
	       perror("SOUND_MIXER_WRITE_RECSRC");
	       exit(-1);
	    }
	    i++;
	 } else usage();
      } else {
	 i++;
	 if ((i<argc) && isdigit(argv[i][0])) {
	    
	    if (strchr(argv[i], ':') == NULL) {
	       sscanf(argv[i], "%d", &bar);
	       dev = bar;
	    } else sscanf(argv[i], "%d:%d", &bar, &dev);
	 
	    if (bar < 0) bar = 0;
	    if (dev < 0) dev = 0;
	    if (bar > 100) bar = 100;
	    if (dev > 100) dev = 100;

	    printf("%s=%d:%d ", names[foo], bar, dev);
	    bar |= dev << 8;
	    if (ioctl(baz, MIXER_WRITE(foo), &bar) == -1) perror("WRITE_MIXER");
	    i++;
	 } else {
	    if (ioctl(baz, MIXER_READ(foo),&bar)== -1) perror("MIXER_READ");
	    printf("%s=%d:%d ", names[foo], bar & 0x7f, (bar >> 8) & 0x7f);
	 }
      }
   }
   printf("\n");
   print_recsrc();
   close(baz);
}
